# Contributor Guide

First of all: every contribution is welcome! If you don't know how to make a change just ask!

That said we can separate the contributions in two:

* Contributions no related to components: changes in web app, initialization, ...
* Contributions related to components: generation, use, extend, ...

## Contributions no related to components

This part is just like every other Perl module. In this case we're using [Dist::Zilla](http://dzil.org/) to build
the distribution package.

So a typical workflow will be fork and pull request based (for those not familiar you can check [forking projects](https://guides.github.com/activities/forking/))

```bash
# Just in case Dist Zilla is not installed
$ cpanm Dist::Zilla
$ dzil authordeps | cpanm
# Make your changes
$ dzil test
```

If the last step suceed then you're ready to make a Pull Request!!

## Contributions related to components

The parts related to components are mainly autogenerated using the Python packages so we'll need them. 
To set up the developement environment first you have to follow: [Dash instructions for contributing](https://github.com/plotly/dash/blob/dev/CONTRIBUTING.md#getting-started)

Once the Javascript and Python parts are working the script [tool/build_dist.pl](https://github.com/pablrod/perl-Dash/blob/master/tool/build_dist.pl) will execute the commands and will generate the files and assets needed to build the Perl package distribution.

After a succesful execution you can just start hacking!

Once the changes in components are done you'll have to pass all the tests so don't forget to run the full tests:

```bash
$ dzil test
```

Beware: some parts are still under development!

