package Task::Catalyst;

use strict;
use warnings;

our $VERSION = '2.0001';

=head1 NAME

Task::Catalyst - All you need to start with Catalyst

=head1 SYNOPSIS

C<perl -MCPAN -e 'install Task::Catalyst'>

=head1 DESCRIPTION

Installs everything you need to write serious Catalyst applications.

L<Catalyst>

L<Catalyst::Devel>

L<Catalyst::Engine::Apache>

L<FCGI>

L<FCGI::ProcManager>

L<PAR>

L<Catalyst::Log::Log4perl>

L<Catalyst::Plugin::HTML::Widget>

L<Catalyst::Controller::FormBuilder>

L<Catalyst::Plugin::StackTrace>

L<Catalyst::Plugin::Prototype>

L<Catalyst::Plugin::Session>

L<Catalyst::Plugin::Session::Store::File>

L<Catalyst::Plugin::Session::State::Cookie>

L<Catalyst::Plugin::Session::State::URI>

L<Catalyst::Plugin::Authentication>

L<Catalyst::Plugin::Authentication::Store::DBIC>

L<Catalyst::Plugin::Authentication::Store::Htpasswd>

L<Catalyst::Plugin::Authorization::ACL>

L<Catalyst::Plugin::Authorization::Roles>

L<Catalyst::Plugin::I18N>

L<Catalyst::Controller::BindLex>

L<Catalyst::Model::DBIC::Schema>

L<Catalyst::View::TT>

L<Test::WWW::Mechanize::Catalyst>

L<DBD::SQLite>

=head1 AUTHOR

The Catalyst Core Team - see http://catalyst.perl.org/

=head1 LICENSE

This library is free software, you can redistribute it and/or modify it under
the same terms as Perl itself.

=cut

1;
