/*****************************************************************************
 * gyachi_md5.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2009, Greg Hosler
 * (ghosler ['at'] users.sourceforge.net)
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *****************************************************************************/

#ifndef _GYACHI_MD5_H
#define _GYACHI_MD5_H 1

#include "md5.h"

typedef struct md5_ctx md5_ctx_t;

/* gyachi interface to md5 routines */
extern void md5_init(md5_ctx_t *ctx);
extern void md5_append(md5_ctx_t *ctx, const uint8_t *data, int nbytes);
extern void md5_finish(md5_ctx_t *, uint8_t digest[16]);

/* md5_init      calls __md5_init_ctx
 * md5_append    calls __md5_process_bytes
 * md5_finish    calls __md5_finish_ctx
 */
#endif /* gyachi_md5.h */
