/*****************************************************************************
 * gy_config.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 *
 * Copyright (C) 2006 Stefan Sikora and Zoltan Csala
 * (hdhoshy ['at'] users.sourceforge.net)
 * http://gyachi.sourceforge.net
 *
 * Copyright (C) 2003-2005, Erica Andrews
 * (Phrozensmoke ['at'] yahoo.com)
 * http://phpaint.sourceforge.net/pyvoicechat/
 * 
 * Copyright (C) 2000-2002 Chris Pinkham
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * cpinkham@infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 *****************************************************************************/


#ifndef _GY_CONFIG_H_
#define _GY_CONFIG_H_

#include "parsecfg.h"

#ifdef WIN32_PATH
#define CODEC_PATHS WIN32_PATH, "/usr/lib/win32", "/usr/local/lib/win32", "/usr/lib/codecs"
#else
#define CODEC_PATHS "/usr/lib/win32", "/usr/local/lib/win32", "/usr/lib/codecs"
#endif

/* gyachi globals */
extern char *GYACH_CFG_COMMON_DIR;		/* ~/.yahorc	   */
extern char *GYACH_CFG_DIR;			/* ~/.yahorc/gyach */
extern char *cfg_filename;
extern GList *login_list;
extern GList *room_list;
extern char *chat_tabs[4];

#define CHAT_TAB    "Chat"
#define BUDDY_TAB   "Buddies"
#define YAHOO_TAB   "My Yahoo!"
#define CONTACT_TAB "Contacts"


/* config variables */
extern cfgList *fav_room_list;
extern int  show_blended_colors;
extern int  show_colors;
extern int  show_fonts;
extern int  def_user;
extern int  auto_away;
extern int  auto_login;
extern int  pm_brings_back;
extern int  buffer_size;
extern int  show_html;
extern int  show_statuses;
extern int  show_enters;
extern int  profile_viewer;
extern int  ignore_on_mults;
extern int  mute_on_mults;
extern int  use_bold;
extern int  use_italics;
extern int  use_underline;
extern int  force_lowercase;
extern int  suppress_mult;
extern int  ping_minutes;
extern int  auto_leave_chatroom;
extern int  chat_text_width;
extern int  chat_user_height;
extern int  disp_auto_ignored;
extern int  remember_tab_settings;
extern int  remember_password;
extern int  remember_position;
extern int  chat_window_x;
extern int  chat_window_y;
extern int  chat_window_width;
extern int  chat_window_height;
extern int  remember_notebook_position;
extern int  notebook_window_x;
extern int  notebook_window_y;
extern int  notebook_window_width;
extern int  notebook_window_height;
extern int  notebook_current_page;
extern int  disable_emotes;
extern int  emotes_window_height;
extern int  limit_lfs;
extern int  auto_reply_when_away;
extern int  pm_in_sep_windows;
extern int  pm_in_notebook;
extern int  pm_auto_logging;
extern int  pm_from_friends;
extern int  pm_from_users;
extern int  pm_from_all;
extern int  chat_window_logging;
extern int  debug_logging;
extern int  debug_packets;
extern int  enable_encryption;
extern int  auto_raise_pm;
extern int  auto_close_roomlist;
extern int  cache_room_list;
extern int  cache_room_captcha;
extern int  chat_timestamp;
extern int  chat_timestamp_pm;
extern int  ignore_guests;
extern int  auto_reconnect;
extern int  history_limit;
extern int  custom_color_red;
extern int  custom_color_green;
extern int  custom_color_blue;
extern char *auto_reply_msg;
extern char *use_color;
extern char *custom_away_message;
extern int   custom_away_icon;
extern char *logfile_directory;
extern char *logfile_template;
extern char *browser_command;
extern char *filter_command;
extern char *font_family;
extern char *font_name;
extern int  font_size;
extern char *display_font_family;
extern char *display_font_name;
extern int  display_font_size;
extern int  indent_wrapped;
extern char *last_chatserver ;
extern char *last_chatroom ;
extern char *last_loginname;
extern int  login_invisible;
extern int  login_noroom;
extern int  show_offline_buddies;
extern int  show_offline_in_online;
extern int  dont_show_offline_buddies;
extern int  show_empty_groups;
extern int  expand_all_groups;
extern int  expand_only_online_groups;
extern int  expand_no_groups;
extern int  use_chat_fader;
extern char *fader_string;
extern char *fader_type;
extern char *password;
extern char *ymsgr_token;
extern char *def_room;
extern int  show_adult;
extern char *webcam_viewer_app;
extern char *webcam_device;
extern char *contact_first;
extern char *contact_last;
extern char *contact_email;
extern char *contact_home;
extern char *contact_work;
extern char *contact_mobile;
extern int  locale_status;
extern int  highlight_friends_in_chat;
extern int  highlight_me_in_chat;
extern int  enable_tab_icons;
extern int  enable_sound_events;
extern int  enable_trayicon;
extern int  enable_webcam_features;
extern int  show_cam_is_on;
extern char *webcamtext;
extern int  enable_tuxvironments;
extern int  enter_leave_timestamp;
extern int  enable_chat_spam_filter;
extern int  mute_noage;
extern int  mute_minors;
extern int  mute_nogender;
extern int  mute_males;
extern int  mute_females;
extern int  enable_sound_events_pm;
extern int  allow_py_voice_helper;
extern int  max_sim_animations;
extern int  enable_animations;
extern int  enable_preemptive_strike;
extern int  enable_basic_protection;
extern int  disallow_random_friend_add;
extern int  never_ignore_a_friend;
extern int  allow_no_sent_files;
extern int  show_avatars;
extern char *send_avatar;
extern int  show_emoticons;
extern int  support_scentral_smileys;
extern int  use_proxy;
extern char *proxy_host;
extern int  proxy_port;
extern char *custom_scale_text;
extern int  first_post_is_url;
extern int  first_post_is_pm;
extern int  url_from_nonroom_user;
extern int  highlight_friends;
extern int  popup_buzz;
extern int  popup_buddy_on;
extern int  popup_buddy_off;
extern int  popup_new_mail;
extern int  popup_news_bulletin;
extern int  popup_attach_systray;
extern int  transparent_bg;
extern int  shading_r;
extern int  shading_g;
extern int  shading_b;
extern int  use_buddy_list_font;
extern int  show_quick_access_toolbar;
extern int  pm_nick_names;
extern int  show_my_status_in_chat;
extern int  bimage_share;
extern int  share_blist_avatar;
extern int  bimage_size;
extern int  auto_reject_invitations;
extern int  pmb_audibles;
extern int  pmb_smileys;
extern int  pmb_send_erase;
extern int  bimage_friend_only;
extern int  show_yavatars;
extern int  enable_audibles;
extern int  activate_profnames;
extern int  show_bimages;
extern int  show_bicon;
extern int  pm_window_style;
extern char *bimage_file;
extern char *flash_player_cmd;
extern char *mp3_player;
extern int  messy_ver;
extern int  pmb_toolbar1;
extern int  pmb_toolbar2;
extern int  chatwin_smileys;
extern int  chatwin_send_erase;
extern int  show_tabs_at_bottom;
extern char *file_transfer_server;
extern int  allow_pm_buzzes;
extern int  enable_addressbook;
extern int  enable_pm_searches;
extern int  buddy_image_upload_method;
extern int  fxfr_close_meter_when_done;
extern char *selected_theme;
extern char *photoshare_dir;
extern char *file_upload_dir;
extern char *file_download_dir;
extern int  auto_open_dl_manager;
extern char *gyachi_sound_device;
extern int  gtk_spellcheck;

extern int  gyach_init();
extern int  read_config();

#endif /* #ifndef _GYACH_H_ */
