/*****************************************************************************
 * gyachi_sha.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2009, Greg Hosler
 * (ghosler ['at'] users.sourceforge.net)
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *****************************************************************************/

#include "gyachi_sha.h"


void shaInit(SHA_CTX *ctx)
{
	sha1_init_ctx(ctx);
}


void shaUpdate(SHA_CTX *ctx, unsigned char *dataIn, int len)
{
	sha1_process_bytes(dataIn, len, ctx);
}


void shaFinal(SHA_CTX *ctx, unsigned char *hashout)
{
	sha1_finish_ctx(ctx, hashout);
}

