/*****************************************************************************
 * ignore.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005, Erica Andrews
 * (Phrozensmoke ['at'] yahoo.com)
 * http://phpaint.sourceforge.net/pyvoicechat/
 * 
 * Copyright (C) 2000-2002 Chris Pinkham
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * cpinkham@infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 *****************************************************************************/


#ifndef _IGNORE_H_
#define _IGNORE_H_

extern GList *mute_list;
extern GList *regex_list;
extern GHashTable *ignore_hash;

extern void ignore_add( char *user );
extern void ignore_remove( char *user );
extern int  ignore_check( char *user );
extern char *auto_ignore_check( char *str );
extern void ignore_load();
extern void ignore_save();
extern void ignore_toggle( char *user );
extern int  ignore_count_in_room();
extern int  ignore_count();
extern void mute_add( char *user );
extern void mute_remove( char *user );
extern int  mute_check( char *user );
extern void mute_toggle( char *user );
extern int  mute_count_in_room();
extern void regex_toggle( char *regex );
extern int  regex_match( char *regex_str, char *str );

extern void immunity_add( char *user );
extern int  immunity_check( char *user );

extern void open_perm_ignore (GtkMenuItem *menuitem, gpointer  user_data);
extern void open_temp_friend_editor (GtkMenuItem *menuitem, gpointer  user_data); 
extern void open_flooder_editor (GtkMenuItem *menuitem, gpointer  user_data);

void start_check_perm_igg_add_timeout(char *myname);

/* added: PhrozenSmoke */
extern int perm_igg_check( char *user );
extern int add_perm_igg( char *user );
extern void remove_perm_igg(char *user);
extern void clear_perm_igg_hash( );
extern void update_perm_igg_clist();

extern void open_ignore_editor (GtkMenuItem *menuitem, gpointer  user_data);

#endif /* #ifndef _IGNORE_H_ */
