/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Polygon;
import org.freeplane.api.Dash;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.ShapedPainter;

abstract class VariableInsetsPainter
extends ShapedPainter {
    private double zoomedVerticalInset = 0.0;
    private double zoomedHorizontalInset = 0.0;

    VariableInsetsPainter(MainView mainView, NodeGeometryModel shapeConfiguration) {
        super(mainView, shapeConfiguration);
    }

    @Override
    boolean areInsetsFixed() {
        return false;
    }

    @Override
    Dimension getPreferredSize() {
        if (this.mainView.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension prefSize = this.getPreferredRectangleSizeWithoutMargin(this.mainView.getMaximumWidth());
        double widthWithMargin = Math.max((double)prefSize.width * this.getHorizontalMarginFactor(), (double)prefSize.width + this.getMinimumHorizontalInset());
        prefSize.width = this.mainView.limitWidth((int)Math.ceil(widthWithMargin), this.mainView.getPaintedBorderWidth());
        prefSize.height = (int)Math.ceil(Math.max((double)prefSize.height * this.getVerticalMarginFactor(), (double)prefSize.height + this.getMinimumVerticalInset()));
        return prefSize;
    }

    abstract double getVerticalMarginFactor();

    abstract double getHorizontalMarginFactor();

    double getMinimumHorizontalInset() {
        return this.getShapeConfiguration().getHorizontalMargin().toBaseUnits() * (double)this.mainView.getZoom() + (double)this.mainView.getPaintedBorderWidth() - 1.0;
    }

    double getMinimumVerticalInset() {
        return this.getShapeConfiguration().getVerticalMargin().toBaseUnits() * (double)this.mainView.getZoom() + (double)this.mainView.getPaintedBorderWidth() - 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dimension getPreferredRectangleSizeWithoutMargin(int maximumWidth) {
        Dimension prefSize;
        int scaledMaximumWidth = maximumWidth != Integer.MAX_VALUE ? (int)((double)maximumWidth / this.getHorizontalMarginFactor()) : maximumWidth;
        double zoomedHorizontalInsetBackup = this.zoomedHorizontalInset;
        double zoomedVerticalInsetBackup = this.zoomedVerticalInset;
        this.zoomedHorizontalInset = this.getMinimumHorizontalInset();
        this.zoomedVerticalInset = this.getMinimumVerticalInset();
        int oldMinimumWidth = this.mainView.getMinimumWidth();
        int oldMaximumWidth = this.mainView.getMaximumWidth();
        try {
            this.mainView.setMinimumWidth(0);
            this.mainView.setMaximumWidth(scaledMaximumWidth);
            prefSize = super.getPreferredSize();
            prefSize.width = (int)((double)prefSize.width - this.zoomedHorizontalInset);
            prefSize.height = (int)((double)prefSize.height - this.zoomedVerticalInset);
        }
        finally {
            this.zoomedHorizontalInset = zoomedHorizontalInsetBackup;
            this.zoomedVerticalInset = zoomedVerticalInsetBackup;
            this.mainView.setMaximumWidth(oldMaximumWidth);
            this.mainView.setMinimumWidth(oldMinimumWidth);
        }
        return prefSize;
    }

    @Override
    Insets getZoomedInsets() {
        int topInset = (int)this.zoomedVerticalInset;
        int leftInset = (int)this.zoomedHorizontalInset;
        return new Insets(topInset, leftInset, topInset, leftInset);
    }

    @Override
    void setBounds(int x, int y, int width, int height) {
        int oldMinimumWidth = this.mainView.getMinimumWidth();
        this.mainView.setMinimumWidth(0);
        Dimension preferredRectangleSize = this.getPreferredRectangleSizeWithoutMargin(this.mainView.getMaximumWidth());
        Dimension preferredSize = this.getPreferredSize();
        this.mainView.setMinimumWidth(oldMinimumWidth);
        super.setBounds(x, y, width, height);
        this.zoomedHorizontalInset = (Math.min(preferredSize.width, width) - preferredRectangleSize.width) / 2;
        this.zoomedVerticalInset = (Math.min(preferredSize.height, height) - preferredRectangleSize.height) / 2;
    }

    @Override
    Insets getInsets() {
        Insets insets = this.getZoomedInsets();
        float zoom = this.mainView.getZoom();
        if (zoom != 1.0f) {
            insets.left = (int)((float)insets.left / zoom);
            insets.right = (int)((float)insets.right / zoom);
            insets.top = (int)((float)insets.top / zoom);
            insets.bottom = (int)((float)insets.bottom / zoom);
        }
        return insets;
    }

    @Override
    Insets getInsets(Insets insets) {
        return this.getInsets();
    }

    int[] toInt(double[] relation, int offset, int size) {
        int[] y = new int[relation.length];
        for (int i = 0; i < relation.length; ++i) {
            double relation1 = relation[i];
            y[i] = offset + (int)((double)size * relation1);
        }
        return y;
    }

    Polygon polygonOf(double[] xCoords, double[] yCoords, PaintOperation operation) {
        int edgeWidthOffset = this.mainView.getDash() != Dash.SOLID ? this.mainView.getPaintedBorderWidth() * operation.borderWidthFactor : this.mainView.getPaintedBorderWidth();
        Polygon polygon = new Polygon(this.toInt(xCoords, edgeWidthOffset / 2, this.mainView.getWidth() - edgeWidthOffset), this.toInt(yCoords, edgeWidthOffset / 2, this.mainView.getHeight() - edgeWidthOffset), xCoords.length);
        return polygon;
    }

    static enum PaintOperation {
        DRAW(1),
        FILL(2);

        final int borderWidthFactor;

        private PaintOperation(int borderWidthFactor) {
            this.borderWidthFactor = borderWidthFactor;
        }
    }
}

