/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import net.infonode.util.Writable;

public class Enum
implements Serializable,
Writable {
    private static final long serialVersionUID = 1L;
    private static final HashMap VALUE_MAP = new HashMap();
    private int value;
    private transient String name;

    protected Enum(int value, String name) {
        this.value = value;
        this.name = name;
        HashMap<Integer, Enum> values = (HashMap<Integer, Enum>)VALUE_MAP.get(this.getClass());
        if (values == null) {
            values = new HashMap<Integer, Enum>();
            VALUE_MAP.put(this.getClass(), values);
        }
        values.put(new Integer(value), this);
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        this.writeObject(out);
    }

    protected static Object getObject(Class cl, int value) throws IOException {
        HashMap map = (HashMap)VALUE_MAP.get(cl);
        if (map == null) {
            throw new IOException("Invalid enum class '" + cl + "'!");
        }
        Object object = map.get(new Integer(value));
        if (object == null) {
            throw new IOException("Invalid enum value '" + value + "'!");
        }
        return object;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeShort(this.value);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.value = in.readShort();
    }

    protected static Object decode(Class cl, ObjectInputStream in) throws IOException {
        return Enum.getObject(cl, in.readShort());
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            return Enum.getObject(this.getClass(), this.getValue());
        }
        catch (IOException e) {
            return this;
        }
    }
}

