/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamGobbler
extends Thread {
    private InputStream inputStream;
    private OutputStream outputStream;
    private int bufferSize = 1024;

    public InputStreamGobbler(Process process, OutputStream outputStream) {
        this(process.getInputStream(), outputStream);
    }

    public InputStreamGobbler(InputStream inputStream, OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[this.bufferSize];
        while (true) {
            try {
                int read;
                while ((read = this.inputStream.read(buffer)) != -1) {
                    if (this.outputStream == null) continue;
                    this.outputStream.write(buffer, 0, read);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    protected void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

