/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JPopupButton
extends JButton {
    private final ArrayList<JPopupButtonItem> items = new ArrayList();
    private JPopupButtonItem selectedItem;
    private ChangeListener listener;

    public JPopupButton() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = JPopupButton.this.createPopup();
                menu.show(JPopupButton.this, 0, JPopupButton.this.getHeight());
            }
        });
    }

    public JPopupMenu createPopup() {
        JPopupMenu menu = new JPopupMenu();
        for (final JPopupButtonItem item : this.items) {
            JRadioButtonMenuItem r = new JRadioButtonMenuItem(item.object.toString(), item.icon, item == this.selectedItem);
            r.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (item != JPopupButton.this.selectedItem) {
                        JPopupButton.this.selectedItem = item;
                        JPopupButton.this.fireChangeEvent();
                    }
                }
            });
            menu.add(r);
        }
        return menu;
    }

    public void addItem(Object object, Icon icon) {
        this.items.add(new JPopupButtonItem(object, icon));
    }

    public Object getSelectedItem() {
        return this.selectedItem.object;
    }

    public void setSelectedItem(Object item) {
        for (JPopupButtonItem i : this.items) {
            if (i.object != item) continue;
            this.selectedItem = i;
            return;
        }
        throw new IllegalArgumentException("This elemen doesn't exist.");
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.listener = changeListener;
    }

    private void fireChangeEvent() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this.selectedItem.object));
        }
    }

    private class JPopupButtonItem {
        private final Object object;
        private final Icon icon;

        public JPopupButtonItem(Object object, Icon icon) {
            this.object = object;
            this.icon = icon;
        }
    }
}

