/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.runtime.launcher.LauncherHelper;
import com.install4j.runtime.launcher.util.LauncherUtil;
import java.io.File;

public class Common {
    public static final String LIBRARY_NAME = "i4jinst";
    public static final String EXT_32_BIT = ".32";
    public static final String EXT_64_BIT = ".64";
    public static final String EXT_ARM64_BIT = ".arm64";
    public static final int WIN_LIBRARY_COUNT = 1;
    public static final int MAC_LIBRARY_COUNT = 2;
    public static final int BASE = 0;
    private static boolean[] initialized = new boolean[Math.max(1, 2) + 1];

    public static void initFromLauncher(boolean value) {
        Common.initialized[0] = value;
    }

    public static synchronized void init() {
        Common.init(0);
    }

    public static synchronized void init(int libraryNumber) {
        if (Boolean.getBoolean("install4j.installerIntegrationTest")) {
            return;
        }
        if (!initialized[libraryNumber]) {
            Common.initialized[libraryNumber] = true;
            if (LauncherUtil.isWindows()) {
                String osArch = System.getProperty("os.arch");
                if (osArch.contains("aarch") || osArch.contains("arm")) {
                    File debugArmLibrary = LauncherHelper.INSTANCE.getInstallerFile(Common.getWinLibraryFilename(libraryNumber) + EXT_ARM64_BIT);
                    if (debugArmLibrary.exists()) {
                        System.load(debugArmLibrary.getAbsolutePath());
                    } else {
                        Common.loadNonDebug(Common.getWinLibraryFilename(libraryNumber));
                    }
                } else {
                    boolean is64Bit = osArch.contains("64");
                    File debug64BitLibrary = LauncherHelper.INSTANCE.getInstallerFile(Common.getWinLibraryFilename(libraryNumber) + EXT_64_BIT);
                    File debug32BitLibrary = LauncherHelper.INSTANCE.getInstallerFile(Common.getWinLibraryFilename(libraryNumber) + EXT_32_BIT);
                    if (is64Bit && debug64BitLibrary.exists()) {
                        System.load(debug64BitLibrary.getAbsolutePath());
                    } else if (!is64Bit && debug32BitLibrary.exists()) {
                        System.load(debug32BitLibrary.getAbsolutePath());
                    } else {
                        Common.loadNonDebug(Common.getWinLibraryFilename(libraryNumber));
                    }
                }
            } else if (LauncherUtil.isMacOS()) {
                File runtimeDir = ResourceHelper.getRuntimeDir();
                if (ResourceHelper.isFromFile() && runtimeDir != null && runtimeDir.getPath().endsWith("../dist/install4j/resource")) {
                    System.load(new File(ResourceHelper.getRuntimeDir(), "macos/" + Common.getMacLibraryFilename(libraryNumber)).getAbsolutePath());
                } else {
                    Common.loadNonDebug(Common.getMacLibraryFilename(libraryNumber));
                }
            }
        }
    }

    public static void loadNonDebug(String fileName) {
        File defaultFile = new File(ResourceHelper.getRuntimeDir(), fileName);
        try {
            System.load(defaultFile.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError e) {
            String currentDir = new File(System.getProperty("user.dir"), fileName).getAbsolutePath();
            try {
                System.load(currentDir);
            }
            catch (UnsatisfiedLinkError e1) {
                try {
                    System.loadLibrary(LIBRARY_NAME);
                }
                catch (UnsatisfiedLinkError e2) {
                    throw new UnsatisfiedLinkError("could not load i4jinst from " + defaultFile.isFile() + ", " + currentDir + ", " + defaultFile.getAbsolutePath());
                }
            }
        }
    }

    static byte[] getAnsiCString(String str) {
        byte[] bytes = str.getBytes();
        byte[] terminatedBytes = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, terminatedBytes, 0, bytes.length);
        return terminatedBytes;
    }

    static byte[] getAnsiCString(File file) {
        return Common.getAnsiCString(file.getAbsolutePath());
    }

    public static String getWinLibraryFilename(int libraryNumber) {
        return LIBRARY_NAME + Common.getLibrarySuffix(libraryNumber) + ".dll";
    }

    public static String getMacLibraryFilename(int libraryNumber) {
        return "libi4jinst" + Common.getLibrarySuffix(libraryNumber) + ".dylib";
    }

    private static String getLibrarySuffix(int libraryNumber) {
        return libraryNumber == 0 ? "" : String.valueOf(libraryNumber + 1);
    }
}

