/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.seqno;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class SeqNoStats
implements ToXContentFragment,
Writeable {
    private static final String SEQ_NO = "seq_no";
    private static final String MAX_SEQ_NO = "max_seq_no";
    private static final String LOCAL_CHECKPOINT = "local_checkpoint";
    private static final String GLOBAL_CHECKPOINT = "global_checkpoint";
    private final long maxSeqNo;
    private final long localCheckpoint;
    private final long globalCheckpoint;

    public SeqNoStats(long maxSeqNo, long localCheckpoint, long globalCheckpoint) {
        assert (localCheckpoint <= maxSeqNo) : "local checkpoint [" + localCheckpoint + "] is above maximum seq no [" + maxSeqNo + "]";
        this.maxSeqNo = maxSeqNo;
        this.localCheckpoint = localCheckpoint;
        this.globalCheckpoint = globalCheckpoint;
    }

    public SeqNoStats(StreamInput in) throws IOException {
        this(in.readZLong(), in.readZLong(), in.readZLong());
    }

    public long getMaxSeqNo() {
        return this.maxSeqNo;
    }

    public long getLocalCheckpoint() {
        return this.localCheckpoint;
    }

    public long getGlobalCheckpoint() {
        return this.globalCheckpoint;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeZLong(this.maxSeqNo);
        out.writeZLong(this.localCheckpoint);
        out.writeZLong(this.globalCheckpoint);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(SEQ_NO);
        builder.field(MAX_SEQ_NO, this.maxSeqNo);
        builder.field(LOCAL_CHECKPOINT, this.localCheckpoint);
        builder.field(GLOBAL_CHECKPOINT, this.globalCheckpoint);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeqNoStats that = (SeqNoStats)o;
        return this.maxSeqNo == that.maxSeqNo && this.localCheckpoint == that.localCheckpoint && this.globalCheckpoint == that.globalCheckpoint;
    }

    public int hashCode() {
        return Objects.hash(this.maxSeqNo, this.localCheckpoint, this.globalCheckpoint);
    }

    public String toString() {
        return "SeqNoStats{maxSeqNo=" + this.maxSeqNo + ", localCheckpoint=" + this.localCheckpoint + ", globalCheckpoint=" + this.globalCheckpoint + "}";
    }
}

