/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import com.google.common.base.Objects;
import java.io.IOException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.timeseries.annotation.Generated;

public class DataByFeatureId
implements ToXContentObject,
Writeable {
    public static final String FEATURE_ID_FIELD = "feature_id";
    public static final String DATA_FIELD = "data";
    protected String featureId;
    protected Double data;

    public DataByFeatureId(String featureId, Double data) {
        this.featureId = featureId;
        this.data = data;
    }

    protected DataByFeatureId() {
    }

    public DataByFeatureId(StreamInput input) throws IOException {
        this.featureId = input.readString();
        this.data = input.readDouble();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field(FEATURE_ID_FIELD, this.featureId).field(DATA_FIELD, this.data);
        return xContentBuilder.endObject();
    }

    public static DataByFeatureId parse(XContentParser parser) throws IOException {
        String featureId = null;
        Double data = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "feature_id": {
                    featureId = parser.text();
                    continue block8;
                }
                case "data": {
                    data = parser.doubleValue();
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new DataByFeatureId(featureId, data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataByFeatureId that = (DataByFeatureId)o;
        return Objects.equal((Object)this.getFeatureId(), (Object)that.getFeatureId()) && Objects.equal((Object)this.getData(), (Object)that.getData());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getFeatureId(), this.getData()});
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public Double getData() {
        return this.data;
    }

    public void setData(Double data) {
        this.data = data;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.featureId);
        out.writeDouble(this.data.doubleValue());
    }

    @Generated
    public String toString() {
        return super.toString() + ", " + new ToStringBuilder((Object)this).append("featureId", (Object)this.featureId).append(DATA_FIELD, (Object)this.data).toString();
    }
}

