/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.dao;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequestBuilder;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoSettings;
import org.opensearch.geospatial.ip2geo.jobscheduler.Datasource;
import org.opensearch.geospatial.ip2geo.jobscheduler.DatasourceExtension;
import org.opensearch.geospatial.shared.StashedThreadContext;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;

public class DatasourceDao {
    @Generated
    private static final Logger log = LogManager.getLogger(DatasourceDao.class);
    private static final Integer MAX_SIZE = 1000;
    private final Client client;
    private final ClusterService clusterService;
    private final ClusterSettings clusterSettings;

    public DatasourceDao(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
        this.clusterSettings = clusterService.getClusterSettings();
    }

    public void createIndexIfNotExists(final StepListener<Void> stepListener) {
        if (this.clusterService.state().metadata().hasIndex(".scheduler-geospatial-ip2geo-datasource")) {
            stepListener.onResponse(null);
            return;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(".scheduler-geospatial-ip2geo-datasource").mapping(this.getIndexMapping()).settings(DatasourceExtension.INDEX_SETTING);
        StashedThreadContext.run(this.client, () -> this.client.admin().indices().create(createIndexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(){

            public void onResponse(CreateIndexResponse createIndexResponse) {
                stepListener.onResponse(null);
            }

            public void onFailure(Exception e) {
                if (e instanceof ResourceAlreadyExistsException) {
                    log.info("index[{}] already exist", (Object)".scheduler-geospatial-ip2geo-datasource");
                    stepListener.onResponse(null);
                    return;
                }
                stepListener.onFailure(e);
            }
        }));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getIndexMapping() {
        try (InputStream is = DatasourceDao.class.getResourceAsStream("/mappings/ip2geo_datasource.json");){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                string = reader.lines().map(String::trim).collect(Collectors.joining());
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IndexResponse updateDatasource(Datasource datasource) {
        datasource.setLastUpdateTime(Instant.now());
        return StashedThreadContext.run(this.client, () -> {
            try {
                return (IndexResponse)((IndexRequestBuilder)this.client.prepareIndex(".scheduler-geospatial-ip2geo-datasource").setId(datasource.getName()).setOpType(DocWriteRequest.OpType.INDEX).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(datasource.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).execute().actionGet((TimeValue)this.clusterSettings.get(Ip2GeoSettings.TIMEOUT));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void updateDatasource(List<Datasource> datasources, ActionListener<BulkResponse> listener) {
        BulkRequest bulkRequest = new BulkRequest();
        datasources.stream().map(datasource -> {
            datasource.setLastUpdateTime(Instant.now());
            return datasource;
        }).map(this::toIndexRequest).forEach(indexRequest -> bulkRequest.add(indexRequest));
        StashedThreadContext.run(this.client, () -> this.client.bulk(bulkRequest, listener));
    }

    private IndexRequest toIndexRequest(Datasource datasource) {
        try {
            IndexRequest indexRequest = new IndexRequest();
            indexRequest.index(".scheduler-geospatial-ip2geo-datasource");
            indexRequest.id(datasource.getName());
            indexRequest.opType(DocWriteRequest.OpType.INDEX);
            indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            indexRequest.source(datasource.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
            return indexRequest;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void putDatasource(Datasource datasource, ActionListener listener) {
        datasource.setLastUpdateTime(Instant.now());
        StashedThreadContext.run(this.client, () -> {
            try {
                ((IndexRequestBuilder)this.client.prepareIndex(".scheduler-geospatial-ip2geo-datasource").setId(datasource.getName()).setOpType(DocWriteRequest.OpType.CREATE).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(datasource.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).execute(listener);
            }
            catch (IOException e) {
                new RuntimeException(e);
            }
        });
    }

    public void deleteDatasource(Datasource datasource) {
        DeleteResponse response = (DeleteResponse)((DeleteRequestBuilder)((DeleteRequestBuilder)this.client.prepareDelete().setIndex(".scheduler-geospatial-ip2geo-datasource")).setId(datasource.getName()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute().actionGet((TimeValue)this.clusterSettings.get(Ip2GeoSettings.TIMEOUT));
        if (!response.status().equals((Object)RestStatus.OK)) {
            if (response.status().equals((Object)RestStatus.NOT_FOUND)) {
                throw new ResourceNotFoundException("datasource[{}] does not exist", new Object[]{datasource.getName()});
            }
            throw new OpenSearchException("failed to delete datasource[{}] with status[{}]", new Object[]{datasource.getName(), response.status()});
        }
        log.info("deleted datasource[{}] successfully", (Object)datasource.getName());
    }

    public Datasource getDatasource(String name) throws IOException {
        GetResponse response;
        GetRequest request = new GetRequest(".scheduler-geospatial-ip2geo-datasource", name);
        try {
            response = StashedThreadContext.run(this.client, () -> (GetResponse)this.client.get(request).actionGet((TimeValue)this.clusterSettings.get(Ip2GeoSettings.TIMEOUT)));
            if (!response.isExists()) {
                log.error("Datasource[{}] does not exist in an index[{}]", (Object)name, (Object)".scheduler-geospatial-ip2geo-datasource");
                return null;
            }
        }
        catch (IndexNotFoundException e) {
            log.error("Index[{}] is not found", (Object)".scheduler-geospatial-ip2geo-datasource");
            return null;
        }
        XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef());
        return (Datasource)Datasource.PARSER.parse(parser, null);
    }

    public void getDatasource(String name, final ActionListener<Datasource> actionListener) {
        GetRequest request = new GetRequest(".scheduler-geospatial-ip2geo-datasource", name);
        StashedThreadContext.run(this.client, () -> this.client.get(request, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                if (!response.isExists()) {
                    actionListener.onResponse(null);
                    return;
                }
                try {
                    XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef());
                    actionListener.onResponse((Object)((Datasource)Datasource.PARSER.parse(parser, null)));
                }
                catch (IOException e) {
                    actionListener.onFailure((Exception)e);
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        }));
    }

    public void getDatasources(String[] names, ActionListener<List<Datasource>> actionListener) {
        StashedThreadContext.run(this.client, () -> this.client.prepareMultiGet().add(".scheduler-geospatial-ip2geo-datasource", names).execute(this.createGetDataSourceQueryActionLister(MultiGetResponse.class, actionListener)));
    }

    public void getAllDatasources(ActionListener<List<Datasource>> actionListener) {
        StashedThreadContext.run(this.client, () -> this.client.prepareSearch(new String[]{".scheduler-geospatial-ip2geo-datasource"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPreference(Preference.PRIMARY.type()).setSize(MAX_SIZE.intValue()).execute(this.createGetDataSourceQueryActionLister(SearchResponse.class, actionListener)));
    }

    public List<Datasource> getAllDatasources() {
        SearchResponse response = StashedThreadContext.run(this.client, () -> (SearchResponse)this.client.prepareSearch(new String[]{".scheduler-geospatial-ip2geo-datasource"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPreference(Preference.PRIMARY.type()).setSize(MAX_SIZE.intValue()).execute().actionGet((TimeValue)this.clusterSettings.get(Ip2GeoSettings.TIMEOUT)));
        List<BytesReference> bytesReferences = this.toBytesReferences(response);
        return bytesReferences.stream().map(bytesRef -> this.toDatasource((BytesReference)bytesRef)).collect(Collectors.toList());
    }

    private <T> ActionListener<T> createGetDataSourceQueryActionLister(Class<T> response, final ActionListener<List<Datasource>> actionListener) {
        return new ActionListener<T>(){

            public void onResponse(T response) {
                try {
                    List<BytesReference> bytesReferences = DatasourceDao.this.toBytesReferences(response);
                    List datasources = bytesReferences.stream().map(bytesRef -> DatasourceDao.this.toDatasource((BytesReference)bytesRef)).collect(Collectors.toList());
                    actionListener.onResponse(datasources);
                }
                catch (Exception e) {
                    actionListener.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        };
    }

    private List<BytesReference> toBytesReferences(Object response) {
        if (response instanceof SearchResponse) {
            SearchResponse searchResponse = (SearchResponse)response;
            return Arrays.stream(searchResponse.getHits().getHits()).map(SearchHit::getSourceRef).collect(Collectors.toList());
        }
        if (response instanceof MultiGetResponse) {
            MultiGetResponse multiGetResponse = (MultiGetResponse)response;
            return Arrays.stream(multiGetResponse.getResponses()).map(MultiGetItemResponse::getResponse).filter(Objects::nonNull).filter(GetResponse::isExists).map(GetResponse::getSourceAsBytesRef).collect(Collectors.toList());
        }
        throw new OpenSearchException("No supported instance type[{}] is provided", new Object[]{response.getClass()});
    }

    private Datasource toDatasource(BytesReference bytesReference) {
        try {
            XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesReference);
            return (Datasource)Datasource.PARSER.parse(parser, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

