/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN9120Codec;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.knn.index.codec.KNN9120Codec.DerivedSourceStoredFieldsReader;

public class DerivedSourceStoredFieldsWriter
extends StoredFieldsWriter {
    private final StoredFieldsWriter delegate;
    private final List<String> vectorFieldTypes;

    public void startDocument() throws IOException {
        this.delegate.startDocument();
    }

    public void writeField(FieldInfo fieldInfo, int i) throws IOException {
        this.delegate.writeField(fieldInfo, i);
    }

    public void writeField(FieldInfo fieldInfo, long l) throws IOException {
        this.delegate.writeField(fieldInfo, l);
    }

    public void writeField(FieldInfo fieldInfo, float v) throws IOException {
        this.delegate.writeField(fieldInfo, v);
    }

    public void writeField(FieldInfo fieldInfo, double v) throws IOException {
        this.delegate.writeField(fieldInfo, v);
    }

    public void writeField(FieldInfo info, DataInput value, int length) throws IOException {
        this.delegate.writeField(info, value, length);
    }

    public int merge(MergeState mergeState) throws IOException {
        for (int i = 0; i < mergeState.storedFieldsReaders.length; ++i) {
            mergeState.storedFieldsReaders[i] = DerivedSourceStoredFieldsReader.wrapForMerge(mergeState.storedFieldsReaders[i]);
        }
        return this.delegate.merge(mergeState);
    }

    public void writeField(FieldInfo fieldInfo, BytesRef bytesRef) throws IOException {
        if (Objects.equals(fieldInfo.name, "_source") && !this.vectorFieldTypes.isEmpty()) {
            Tuple mapTuple = XContentHelper.convertToMap((BytesReference)BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytesRef.bytes, bytesRef.offset, bytesRef.length)), (boolean)true, (MediaType)MediaTypeRegistry.JSON);
            Map filteredSource = (Map)XContentMapValues.filter(null, (String[])this.vectorFieldTypes.toArray(new String[0])).apply((Map)mapTuple.v2());
            BytesStreamOutput bStream = new BytesStreamOutput();
            MediaType actualContentType = (MediaType)mapTuple.v1();
            XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)actualContentType, (OutputStream)bStream).map(filteredSource);
            builder.close();
            BytesReference bytesReference = bStream.bytes();
            this.delegate.writeField(fieldInfo, bytesReference.toBytesRef());
            return;
        }
        this.delegate.writeField(fieldInfo, bytesRef);
    }

    public void writeField(FieldInfo fieldInfo, String s) throws IOException {
        this.delegate.writeField(fieldInfo, s);
    }

    public void finishDocument() throws IOException {
        this.delegate.finishDocument();
    }

    public void finish(int i) throws IOException {
        this.delegate.finish(i);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public long ramBytesUsed() {
        return this.delegate.ramBytesUsed();
    }

    @Generated
    public DerivedSourceStoredFieldsWriter(StoredFieldsWriter delegate, List<String> vectorFieldTypes) {
        this.delegate = delegate;
        this.vectorFieldTypes = vectorFieldTypes;
    }
}

