/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;

public class KNNVectorAsArraySerializer
implements KNNVectorSerializer {
    @Override
    public byte[] floatToByteArray(float[] input) {
        byte[] bytes;
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
             ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);){
            objectStream.writeObject(input);
            bytes = byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    @Override
    public float[] byteToFloatArray(BytesRef bytesRef) {
        float[] fArray;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytesRef.bytes, bytesRef.offset, bytesRef.length);
        try {
            float[] vector;
            ObjectInputStream objectStream = new ObjectInputStream(byteStream);
            fArray = vector = (float[])objectStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        byteStream.close();
        return fArray;
    }
}

