/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.vectorvalues;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializerFactory;
import org.opensearch.knn.index.vectorvalues.KNNVectorValuesIterator;

public interface VectorValueExtractorStrategy {
    public static float[] extractFloatVector(KNNVectorValuesIterator iterator) throws IOException {
        return (float[])iterator.getVectorExtractorStrategy().extract(VectorDataType.FLOAT, iterator);
    }

    public static byte[] extractByteVector(KNNVectorValuesIterator iterator) throws IOException {
        return (byte[])iterator.getVectorExtractorStrategy().extract(VectorDataType.BYTE, iterator);
    }

    public static byte[] extractBinaryVector(KNNVectorValuesIterator iterator) throws IOException {
        return (byte[])iterator.getVectorExtractorStrategy().extract(VectorDataType.BINARY, iterator);
    }

    public <T> T extract(VectorDataType var1, KNNVectorValuesIterator var2) throws IOException;

    public static class FieldWriterIteratorVectorExtractor
    implements VectorValueExtractorStrategy {
        @Override
        public <T> T extract(VectorDataType vectorDataType, KNNVectorValuesIterator vectorValuesIterator) throws IOException {
            switch (vectorDataType) {
                case FLOAT: {
                    return ((KNNVectorValuesIterator.FieldWriterIteratorValues)vectorValuesIterator).vectorsValue();
                }
                case BYTE: 
                case BINARY: {
                    return ((KNNVectorValuesIterator.FieldWriterIteratorValues)vectorValuesIterator).vectorsValue();
                }
            }
            throw new IllegalArgumentException("Valid Vector data type not passed to extract vector from FieldWriterIteratorVectorExtractor strategy");
        }
    }

    public static class DISIVectorExtractor
    implements VectorValueExtractorStrategy {
        @Override
        public <T> T extract(VectorDataType vectorDataType, KNNVectorValuesIterator vectorValuesIterator) throws IOException {
            DocIdSetIterator docIdSetIterator = vectorValuesIterator.getDocIdSetIterator();
            switch (vectorDataType) {
                case FLOAT: {
                    if (docIdSetIterator instanceof BinaryDocValues) {
                        BinaryDocValues values = (BinaryDocValues)docIdSetIterator;
                        return (T)this.getFloatVectorFromByteRef(values.binaryValue());
                    }
                    if (docIdSetIterator instanceof FloatVectorValues) {
                        return (T)((FloatVectorValues)docIdSetIterator).vectorValue();
                    }
                    throw new IllegalArgumentException("VectorValuesIterator is not of a valid type. Valid Types are: BinaryDocValues and FloatVectorValues");
                }
                case BYTE: 
                case BINARY: {
                    if (docIdSetIterator instanceof BinaryDocValues) {
                        BinaryDocValues values = (BinaryDocValues)docIdSetIterator;
                        BytesRef bytesRef = values.binaryValue();
                        return (T)ArrayUtil.copyOfSubArray((byte[])bytesRef.bytes, (int)bytesRef.offset, (int)(bytesRef.offset + bytesRef.length));
                    }
                    if (docIdSetIterator instanceof ByteVectorValues) {
                        return (T)((ByteVectorValues)docIdSetIterator).vectorValue();
                    }
                    throw new IllegalArgumentException("VectorValuesIterator is not of a valid type. Valid Types are: BinaryDocValues and ByteVectorValues");
                }
            }
            throw new IllegalArgumentException("Valid Vector data type not passed to extract vector from DISIVectorExtractor strategy");
        }

        private float[] getFloatVectorFromByteRef(BytesRef bytesRef) {
            KNNVectorSerializer vectorSerializer = KNNVectorSerializerFactory.getSerializerByBytesRef(bytesRef);
            return vectorSerializer.byteToFloatArray(bytesRef);
        }
    }
}

