/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.collect.ImmutableSet;
import com.selectivem.collections.CheckTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.opensearch.security.privileges.PrivilegesEvaluationException;

public class PrivilegesEvaluatorResponse {
    public boolean allowed = false;
    public Set<String> missingSecurityRoles = new HashSet<String>();
    PrivilegesEvaluatorResponseState state = PrivilegesEvaluatorResponseState.PENDING;
    public CreateIndexRequestBuilder createIndexRequestBuilder;
    private Set<String> onlyAllowedForIndices = ImmutableSet.of();
    private CheckTable<String, String> indexToActionCheckTable;
    private String privilegeMatrix;
    private String reason;
    private List<PrivilegesEvaluationException> evaluationExceptions = new ArrayList<PrivilegesEvaluationException>();

    public boolean isAllowed() {
        return this.allowed;
    }

    public boolean isPartiallyOk() {
        return !this.onlyAllowedForIndices.isEmpty();
    }

    public Set<String> getAvailableIndices() {
        return this.onlyAllowedForIndices;
    }

    public Set<String> getMissingPrivileges() {
        return this.indexToActionCheckTable != null ? this.indexToActionCheckTable.getIncompleteColumns() : Collections.emptySet();
    }

    public String getReason() {
        return this.reason;
    }

    public PrivilegesEvaluatorResponse reason(String reason) {
        this.reason = reason;
        return this;
    }

    public String getEvaluationExceptionInfo() {
        StringBuilder result = new StringBuilder("Exceptions encountered during privilege evaluation:\n");
        for (PrivilegesEvaluationException evaluationException : this.evaluationExceptions) {
            result.append(evaluationException.getNestedMessages()).append("\n");
        }
        return result.toString();
    }

    public boolean hasEvaluationExceptions() {
        return !this.evaluationExceptions.isEmpty();
    }

    public PrivilegesEvaluatorResponse evaluationExceptions(Collection<PrivilegesEvaluationException> evaluationExceptions) {
        this.evaluationExceptions.addAll(evaluationExceptions);
        return this;
    }

    public String getPrivilegeMatrix() {
        String result = this.privilegeMatrix;
        if (result == null) {
            this.privilegeMatrix = result = this.indexToActionCheckTable.toTableString("ok", "MISSING");
        }
        return result;
    }

    public Set<String> getMissingSecurityRoles() {
        return new HashSet<String>(this.missingSecurityRoles);
    }

    public CreateIndexRequestBuilder getCreateIndexRequestBuilder() {
        return this.createIndexRequestBuilder;
    }

    public PrivilegesEvaluatorResponse markComplete() {
        this.state = PrivilegesEvaluatorResponseState.COMPLETE;
        return this;
    }

    public PrivilegesEvaluatorResponse markPending() {
        this.state = PrivilegesEvaluatorResponseState.PENDING;
        return this;
    }

    public boolean isComplete() {
        return this.state == PrivilegesEvaluatorResponseState.COMPLETE;
    }

    public boolean isPending() {
        return this.state == PrivilegesEvaluatorResponseState.PENDING;
    }

    public String toString() {
        return "PrivEvalResponse [\nallowed=" + this.allowed + ",\nonlyAllowedForIndices=" + String.valueOf(this.onlyAllowedForIndices) + ",\n" + (this.indexToActionCheckTable != null ? this.indexToActionCheckTable.toTableString("ok", "MISSING") : "") + "]";
    }

    public static PrivilegesEvaluatorResponse ok() {
        PrivilegesEvaluatorResponse response = new PrivilegesEvaluatorResponse();
        response.allowed = true;
        return response;
    }

    public static PrivilegesEvaluatorResponse partiallyOk(Set<String> availableIndices, CheckTable<String, String> indexToActionCheckTable) {
        PrivilegesEvaluatorResponse response = new PrivilegesEvaluatorResponse();
        response.onlyAllowedForIndices = ImmutableSet.copyOf(availableIndices);
        response.indexToActionCheckTable = indexToActionCheckTable;
        return response;
    }

    public static PrivilegesEvaluatorResponse insufficient(String missingPrivilege) {
        PrivilegesEvaluatorResponse response = new PrivilegesEvaluatorResponse();
        response.indexToActionCheckTable = CheckTable.create((Set)ImmutableSet.of((Object)"_"), (Set)ImmutableSet.of((Object)missingPrivilege));
        return response;
    }

    public static PrivilegesEvaluatorResponse insufficient(Collection<String> missingPrivileges) {
        PrivilegesEvaluatorResponse response = new PrivilegesEvaluatorResponse();
        response.indexToActionCheckTable = CheckTable.create((Set)ImmutableSet.of((Object)"_"), (Set)ImmutableSet.copyOf(missingPrivileges));
        return response;
    }

    public static PrivilegesEvaluatorResponse insufficient(CheckTable<String, String> indexToActionCheckTable) {
        PrivilegesEvaluatorResponse response = new PrivilegesEvaluatorResponse();
        response.indexToActionCheckTable = indexToActionCheckTable;
        return response;
    }

    public static enum PrivilegesEvaluatorResponseState {
        PENDING,
        COMPLETE;

    }
}

