/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.version.PSystemVersion;

public class Splash
extends Window
implements MouseListener,
MouseMotionListener {
    private static final Color LINK_NORMAL = Color.BLUE;
    private static final Color LINK_HOVER = new Color(127, 0, 127);
    private static Splash singleton;
    private final int width = 280;
    private final int height = 80;
    private final BufferedImage logo;
    private final AtomicInteger total = new AtomicInteger();
    private final AtomicInteger done = new AtomicInteger();
    private final AtomicInteger errors = new AtomicInteger();
    private final Font font = new Font("SansSerif", 1, 12);
    private int xClicked;
    private int yClicked;
    private int limY;
    private int limX;
    private Color link = LINK_NORMAL;

    public static void main(String[] args) throws Exception {
        Splash.createSplash();
        Splash.incTotal(30);
        for (int i = 0; i < 20; ++i) {
            Splash.incDone(i > 3);
            Thread.sleep(1000L);
        }
    }

    private Splash() {
        super((Frame)null);
        this.logo = PSystemVersion.getPlantumlImage();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)(dimension.getWidth() - 280.0) / 2;
        int y = (int)(dimension.getHeight() - 80.0) / 2;
        this.setBounds(x, y, 280, 80);
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.setFocusable(false);
        this.setFocusableWindowState(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        int x = event.getXOnScreen();
        int y = event.getYOnScreen();
        this.setBounds(x - this.xClicked, y - this.yClicked, 280, 80);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (event.getY() > this.limY && event.getX() < this.limX) {
            this.updateLinkColor(LINK_HOVER);
        } else {
            this.updateLinkColor(LINK_NORMAL);
        }
    }

    private void updateLinkColor(Color newLink) {
        if (this.link != newLink) {
            this.link = newLink;
            this.setCursor(this.link == LINK_NORMAL ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12));
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.xClicked = event.getX();
        this.yClicked = event.getY();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.link != LINK_NORMAL) {
            try {
                Desktop.getDesktop().browse(new URI("https://plantuml.com"));
            }
            catch (Exception e) {
                Logme.error(e);
            }
            return;
        }
        this.xClicked = event.getX();
        this.yClicked = event.getY();
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.updateLinkColor(LINK_NORMAL);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    private void incTotalInternal(int nb) {
        this.total.addAndGet(nb);
        this.repaint();
    }

    private void incDoneInternal(boolean error) {
        this.done.incrementAndGet();
        if (error) {
            this.errors.incrementAndGet();
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, 280, 80);
        g2.setColor(Color.BLACK);
        g2.drawRect(0, 0, 279, 79);
        g2.drawRect(1, 1, 277, 77);
        g2.drawImage(this.logo, 280 - this.logo.getWidth() - 4, 80 - this.logo.getHeight() - 4, null);
        this.drawProgessBar(g2, this.done.intValue(), this.total.intValue());
        int nbErrors = this.errors.get();
        if (nbErrors > 0) {
            g2.setColor(Color.RED);
            String message = "" + nbErrors + (nbErrors > 1 ? " diagrams" : " diagram") + " contains errors";
            g2.drawString(message, 10, 20);
        }
        g2.setColor(this.link);
        String urllink = "https://plantuml.com";
        Rectangle2D rect = this.getUsed(g2, "https://plantuml.com");
        g2.drawString("https://plantuml.com", 10, (int)(80.0 - rect.getMaxY()));
        this.limY = (int)(80.0 - rect.getMaxY() + rect.getMinY());
        this.limX = (int)(10.0 + rect.getMaxX());
    }

    private void drawProgessBar(Graphics g2, int intValue, int totalValue) {
        if (totalValue == 0) {
            return;
        }
        g2.setFont(this.font);
        String label = "" + intValue + "/" + totalValue;
        Rectangle2D rect = this.getUsed(g2, label);
        int x = 10;
        int y = 33;
        int barWidth = 170;
        int barHeight = (int)(rect.getHeight() + 2.0);
        int gray = 230;
        g2.setColor(new Color(230, 230, 230));
        int value = 170 * intValue / totalValue;
        g2.fillRect(10, 33, value, barHeight);
        g2.setColor(Color.BLACK);
        g2.drawRect(10, 33, 170, barHeight);
        double xLabel = 10.0 + (170.0 - rect.getWidth()) / 2.0;
        double yLabel = 33.0 - rect.getY() + ((double)barHeight - rect.getHeight()) / 2.0;
        g2.drawString(label, (int)xLabel, (int)yLabel);
    }

    private Rectangle2D getUsed(Graphics g2, String label) {
        return g2.getFontMetrics().getStringBounds(label, g2);
    }

    public static synchronized void createSplash() {
        if (singleton == null) {
            singleton = new Splash();
        }
    }

    public static void incTotal(int nb) {
        if (singleton != null) {
            singleton.incTotalInternal(nb);
        }
    }

    public static void incDone(boolean error) {
        if (singleton != null) {
            singleton.incDoneInternal(error);
        }
    }

    public static synchronized void disposeSplash() {
        if (singleton != null) {
            singleton.setVisible(false);
            singleton.dispose();
            singleton = null;
        }
    }
}

