/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.ir.attributes;

import com.strobel.annotations.NotNull;
import com.strobel.annotations.Nullable;
import com.strobel.assembler.ir.attributes.ModuleDependency;
import com.strobel.assembler.ir.attributes.PackageInfo;
import com.strobel.assembler.ir.attributes.ServiceInfo;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.VerifyArgument;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public final class ModuleAttribute
extends SourceAttribute {
    private final String _name;
    private final String _version;
    private final EnumSet<Flags.Flag> _flags;
    private final List<ModuleDependency> _requires;
    private final List<PackageInfo> _exports;
    private final List<PackageInfo> _opens;
    private final List<TypeReference> _uses;
    private final List<ServiceInfo> _provides;

    public ModuleAttribute(int length, String moduleName, String version, int flags, ModuleDependency[] requires, PackageInfo[] exports, PackageInfo[] opens, TypeReference[] uses, ServiceInfo[] provides) {
        super("Module", length);
        this._name = VerifyArgument.notNull(moduleName, "moduleName");
        this._version = version;
        this._flags = Flags.asFlagSet(flags, Flags.Kind.Module);
        this._requires = ArrayUtilities.isNullOrEmpty(requires) ? Collections.emptyList() : ArrayUtilities.asUnmodifiableList(requires);
        this._exports = ArrayUtilities.isNullOrEmpty(exports) ? Collections.emptyList() : ArrayUtilities.asUnmodifiableList(exports);
        this._opens = ArrayUtilities.isNullOrEmpty(opens) ? Collections.emptyList() : ArrayUtilities.asUnmodifiableList(opens);
        this._uses = ArrayUtilities.isNullOrEmpty(uses) ? Collections.emptyList() : ArrayUtilities.asUnmodifiableList(uses);
        this._provides = ArrayUtilities.isNullOrEmpty(provides) ? Collections.emptyList() : ArrayUtilities.asUnmodifiableList(provides);
    }

    @NotNull
    public final String getModuleName() {
        return this._name;
    }

    @NotNull
    public final EnumSet<Flags.Flag> getFlags() {
        return this._flags;
    }

    @Nullable
    public final String getVersion() {
        return this._version;
    }

    @NotNull
    public final List<ModuleDependency> getRequires() {
        return this._requires;
    }

    @NotNull
    public final List<PackageInfo> getExports() {
        return this._exports;
    }

    @NotNull
    public final List<PackageInfo> getOpens() {
        return this._opens;
    }

    @NotNull
    public final List<TypeReference> getUses() {
        return this._uses;
    }

    @NotNull
    public List<ServiceInfo> getProvides() {
        return this._provides;
    }
}

