/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterChain;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeEvent;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.TomcatPrincipal;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyoteInputStream;
import org.apache.catalina.connector.CoyoteReader;
import org.apache.catalina.connector.InputBuffer;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationMapping;
import org.apache.catalina.core.ApplicationPart;
import org.apache.catalina.core.ApplicationPushBuilder;
import org.apache.catalina.core.ApplicationSessionCookieConfig;
import org.apache.catalina.core.AsyncContextImpl;
import org.apache.catalina.mapper.MappingData;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.TLSUtil;
import org.apache.catalina.util.URLEncoder;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.ContextBind;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.EncodedSolidusHandling;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.http.CookieProcessor;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.Parameters;
import org.apache.tomcat.util.http.Rfc6265CookieProcessor;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.http.ServerCookies;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.FileUpload;
import org.apache.tomcat.util.http.fileupload.RequestContext;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItemFactory;
import org.apache.tomcat.util.http.fileupload.impl.FileCountLimitExceededException;
import org.apache.tomcat.util.http.fileupload.impl.InvalidContentTypeException;
import org.apache.tomcat.util.http.fileupload.impl.SizeException;
import org.apache.tomcat.util.http.fileupload.servlet.ServletRequestContext;
import org.apache.tomcat.util.http.parser.AcceptLanguage;
import org.apache.tomcat.util.http.parser.MediaType;
import org.apache.tomcat.util.http.parser.Upgrade;
import org.apache.tomcat.util.res.StringManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class Request
implements HttpServletRequest {
    private static final String HTTP_UPGRADE_HEADER_NAME = "upgrade";
    private static final Log log = LogFactory.getLog(Request.class);
    protected org.apache.coyote.Request coyoteRequest;
    protected static final StringManager sm = StringManager.getManager(Request.class);
    protected Cookie[] cookies = null;
    protected static final Locale defaultLocale = Locale.getDefault();
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    protected boolean sslAttributesParsed = false;
    protected final ArrayList<Locale> locales = new ArrayList();
    private final transient HashMap<String, Object> notes = new HashMap();
    protected String authType = null;
    protected DispatcherType internalDispatcherType = null;
    protected final InputBuffer inputBuffer = new InputBuffer();
    protected CoyoteInputStream inputStream = new CoyoteInputStream(this.inputBuffer);
    protected CoyoteReader reader = new CoyoteReader(this.inputBuffer);
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    protected Principal userPrincipal = null;
    protected boolean parametersParsed = false;
    protected boolean cookiesParsed = false;
    protected boolean cookiesConverted = false;
    protected boolean secure = false;
    protected transient Subject subject = null;
    protected static final int CACHED_POST_LEN = 8192;
    protected byte[] postData = null;
    protected ParameterMap<String, String[]> parameterMap = new ParameterMap();
    protected Collection<Part> parts = null;
    protected Exception partsParseException = null;
    protected Session session = null;
    protected Object requestDispatcherPath = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected boolean requestedSessionURL = false;
    protected boolean requestedSessionSSL = false;
    protected boolean localesParsed = false;
    protected int localPort = -1;
    protected String remoteAddr = null;
    protected String peerAddr = null;
    protected String remoteHost = null;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected String localName = null;
    private volatile AsyncContextImpl asyncContext = null;
    protected Boolean asyncSupported = null;
    private HttpServletRequest applicationRequest = null;
    private int maxParameterCount = -1;
    private int maxPartCount = -1;
    private int maxPartHeaderSize = -1;
    protected final Connector connector;
    protected FilterChain filterChain = null;
    protected final MappingData mappingData = new MappingData();
    private final ApplicationMapping applicationMapping = new ApplicationMapping(this.mappingData);
    protected RequestFacade facade = null;
    protected Response response = null;
    protected B2CConverter URIConverter = null;
    private static final Map<String, SpecialAttributeAdapter> specialAttributes = new HashMap<String, SpecialAttributeAdapter>();

    public Request(Connector connector) {
        this.connector = connector;
        if (connector != null) {
            this.maxParameterCount = connector.getMaxParameterCount();
            this.maxPartCount = connector.getMaxPartCount();
            this.maxPartHeaderSize = connector.getMaxPartHeaderSize();
        }
    }

    public void setCoyoteRequest(org.apache.coyote.Request request) {
        this.coyoteRequest = request;
        this.inputBuffer.setRequest(request);
    }

    public org.apache.coyote.Request getCoyoteRequest() {
        return this.coyoteRequest;
    }

    public void addPathParameter(String string, String string2) {
        this.coyoteRequest.addPathParameter(string, string2);
    }

    public String getPathParameter(String string) {
        return this.coyoteRequest.getPathParameter(string);
    }

    public void setAsyncSupported(boolean bl) {
        this.asyncSupported = bl;
    }

    public void recycle() {
        this.internalDispatcherType = null;
        this.requestDispatcherPath = null;
        this.authType = null;
        this.inputBuffer.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
        this.userPrincipal = null;
        this.subject = null;
        this.parametersParsed = false;
        if (this.connector != null) {
            this.maxParameterCount = this.connector.getMaxParameterCount();
            this.maxPartCount = this.connector.getMaxPartCount();
            this.maxPartHeaderSize = this.connector.getMaxPartHeaderSize();
        } else {
            this.maxParameterCount = -1;
            this.maxPartCount = -1;
            this.maxPartHeaderSize = -1;
        }
        if (this.parts != null) {
            for (Part part : this.parts) {
                try {
                    part.delete();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    log.warn((Object)sm.getString("coyoteRequest.deletePartFailed", new Object[]{part.getName()}), throwable);
                }
            }
            this.parts = null;
        }
        this.partsParseException = null;
        this.locales.clear();
        this.localesParsed = false;
        this.secure = false;
        this.remoteAddr = null;
        this.peerAddr = null;
        this.remoteHost = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
        this.attributes.clear();
        this.sslAttributesParsed = false;
        this.notes.clear();
        this.recycleSessionInfo();
        this.recycleCookieInfo(false);
        if (this.getDiscardFacades()) {
            this.parameterMap = new ParameterMap();
        } else {
            this.parameterMap.setLocked(false);
            this.parameterMap.clear();
        }
        this.mappingData.recycle();
        this.applicationMapping.recycle();
        this.applicationRequest = null;
        if (this.getDiscardFacades()) {
            if (this.facade != null) {
                this.facade.clear();
                this.facade = null;
            }
            if (this.inputStream != null) {
                this.inputStream.clear();
                this.inputStream = null;
            }
            if (this.reader != null) {
                this.reader.clear();
                this.reader = null;
            }
        }
        this.asyncSupported = null;
        if (this.asyncContext != null) {
            this.asyncContext.recycle();
            this.asyncContext = null;
        }
    }

    public void recycleSessionInfo() {
        if (this.session != null) {
            try {
                this.session.endAccess();
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.warn((Object)sm.getString("coyoteRequest.sessionEndAccessFail"), throwable);
            }
        }
        this.session = null;
        this.requestedSessionCookie = false;
        this.requestedSessionId = null;
        this.requestedSessionURL = false;
        this.requestedSessionSSL = false;
    }

    protected void recycleCookieInfo(boolean bl) {
        this.cookiesParsed = false;
        this.cookiesConverted = false;
        this.cookies = null;
        if (bl) {
            this.getCoyoteRequest().getCookies().recycle();
        }
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Context getContext() {
        return this.mappingData.context;
    }

    public boolean getDiscardFacades() {
        return this.connector == null || this.connector.getDiscardFacades();
    }

    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    public void setFilterChain(FilterChain filterChain) {
        this.filterChain = filterChain;
    }

    public Host getHost() {
        return this.mappingData.host;
    }

    public MappingData getMappingData() {
        return this.mappingData;
    }

    public HttpServletRequest getRequest() {
        if (this.facade == null) {
            this.facade = new RequestFacade(this);
        }
        if (this.applicationRequest == null) {
            this.applicationRequest = this.facade;
        }
        return this.applicationRequest;
    }

    public void setRequest(HttpServletRequest httpServletRequest) {
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        while (httpServletRequest2 instanceof HttpServletRequestWrapper) {
            httpServletRequest2 = ((HttpServletRequestWrapper)httpServletRequest2).getRequest();
        }
        if (httpServletRequest2 != this.facade) {
            throw new IllegalArgumentException(sm.getString("request.illegalWrap"));
        }
        this.applicationRequest = httpServletRequest;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public InputStream getStream() {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    protected B2CConverter getURIConverter() {
        return this.URIConverter;
    }

    protected void setURIConverter(B2CConverter b2CConverter) {
        this.URIConverter = b2CConverter;
    }

    public Wrapper getWrapper() {
        return this.mappingData.wrapper;
    }

    public ServletInputStream createInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public void finishRequest() throws IOException {
        if (this.response.getStatus() == 413) {
            this.checkSwallowInput();
        }
    }

    public Object getNote(String string) {
        return this.notes.get(string);
    }

    public void removeNote(String string) {
        this.notes.remove(string);
    }

    public void setLocalPort(int n) {
        this.localPort = n;
    }

    public void setNote(String string, Object object) {
        this.notes.put(string, object);
    }

    public void setRemoteAddr(String string) {
        this.remoteAddr = string;
    }

    public void setRemoteHost(String string) {
        this.remoteHost = string;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public void setServerPort(int n) {
        this.coyoteRequest.setServerPort(n);
    }

    public void setMaxParameterCount(int n) {
        this.maxParameterCount = n;
    }

    public void setMaxPartCount(int n) {
        this.maxPartCount = n;
    }

    public void setMaxPartHeaderSize(int n) {
        this.maxPartHeaderSize = n;
    }

    public Object getAttribute(String string) {
        SpecialAttributeAdapter specialAttributeAdapter = specialAttributes.get(string);
        if (specialAttributeAdapter != null) {
            return specialAttributeAdapter.get(this, string);
        }
        Object object = this.attributes.get(string);
        if (object != null) {
            return object;
        }
        object = this.coyoteRequest.getAttribute(string);
        if (object != null) {
            return object;
        }
        if (!this.sslAttributesParsed && TLSUtil.isTLSRequestAttribute(string)) {
            this.coyoteRequest.action(ActionCode.REQ_SSL_ATTRIBUTE, (Object)this.coyoteRequest);
            object = this.coyoteRequest.getAttribute("jakarta.servlet.request.X509Certificate");
            if (object != null) {
                this.attributes.put("jakarta.servlet.request.X509Certificate", object);
            }
            if ((object = this.coyoteRequest.getAttribute("jakarta.servlet.request.cipher_suite")) != null) {
                this.attributes.put("jakarta.servlet.request.cipher_suite", object);
            }
            if ((object = this.coyoteRequest.getAttribute("jakarta.servlet.request.key_size")) != null) {
                this.attributes.put("jakarta.servlet.request.key_size", object);
            }
            if ((object = this.coyoteRequest.getAttribute("jakarta.servlet.request.ssl_session_id")) != null) {
                this.attributes.put("jakarta.servlet.request.ssl_session_id", object);
            }
            if ((object = this.coyoteRequest.getAttribute("jakarta.servlet.request.ssl_session_mgr")) != null) {
                this.attributes.put("jakarta.servlet.request.ssl_session_mgr", object);
            }
            if ((object = this.coyoteRequest.getAttribute("org.apache.tomcat.util.net.secure_protocol_version")) != null) {
                this.attributes.put("org.apache.tomcat.util.net.secure_protocol_version", object);
            }
            if ((object = this.coyoteRequest.getAttribute("org.apache.tomcat.util.net.secure_requested_protocol_versions")) != null) {
                this.attributes.put("org.apache.tomcat.util.net.secure_requested_protocol_versions", object);
            }
            if ((object = this.coyoteRequest.getAttribute("org.apache.tomcat.util.net.secure_requested_ciphers")) != null) {
                this.attributes.put("org.apache.tomcat.util.net.secure_requested_ciphers", object);
            }
            object = this.attributes.get(string);
            this.sslAttributesParsed = true;
        }
        return object;
    }

    public long getContentLengthLong() {
        return this.coyoteRequest.getContentLengthLong();
    }

    public Enumeration<String> getAttributeNames() {
        if (this.isSecure() && !this.sslAttributesParsed) {
            this.getAttribute("jakarta.servlet.request.X509Certificate");
        }
        HashSet<String> hashSet = new HashSet<String>(this.attributes.keySet());
        return Collections.enumeration(hashSet);
    }

    public String getCharacterEncoding() {
        String string = this.coyoteRequest.getCharacterEncoding();
        if (string != null) {
            return string;
        }
        Context context = this.getContext();
        if (context != null) {
            return context.getRequestCharacterEncoding();
        }
        return null;
    }

    private Charset getCharset() {
        String string;
        Charset charset = null;
        try {
            charset = this.coyoteRequest.getCharset();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (charset != null) {
            return charset;
        }
        Context context = this.getContext();
        if (context != null && (string = context.getRequestCharacterEncoding()) != null) {
            try {
                return B2CConverter.getCharset((String)string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return Constants.DEFAULT_BODY_CHARSET;
    }

    public int getContentLength() {
        return this.coyoteRequest.getContentLength();
    }

    public String getContentType() {
        return this.coyoteRequest.getContentType();
    }

    public void setContentType(String string) {
        this.coyoteRequest.setContentType(string);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getInputStream.ise"));
        }
        this.usingInputStream = true;
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public Locale getLocale() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (!this.locales.isEmpty()) {
            return this.locales.get(0);
        }
        return defaultLocale;
    }

    public Enumeration<Locale> getLocales() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (!this.locales.isEmpty()) {
            return Collections.enumeration(this.locales);
        }
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        arrayList.add(defaultLocale);
        return Collections.enumeration(arrayList);
    }

    public String getParameter(String string) {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return this.coyoteRequest.getParameters().getParameter(string);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        Enumeration<String> enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String[] stringArray = this.getParameterValues(string);
            this.parameterMap.put(string, stringArray);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    public Enumeration<String> getParameterNames() {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return this.coyoteRequest.getParameters().getParameterNames();
    }

    public String[] getParameterValues(String string) {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return this.coyoteRequest.getParameters().getParameterValues(string);
    }

    public String getProtocol() {
        return this.coyoteRequest.protocol().toStringType();
    }

    public BufferedReader getReader() throws IOException {
        String string;
        Context context;
        if (this.usingInputStream) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getReader.ise"));
        }
        if (this.coyoteRequest.getCharacterEncoding() == null && (context = this.getContext()) != null && (string = context.getRequestCharacterEncoding()) != null) {
            this.setCharacterEncoding(string);
        }
        this.usingReader = true;
        this.inputBuffer.checkConverter();
        if (this.reader == null) {
            this.reader = new CoyoteReader(this.inputBuffer);
        }
        return this.reader;
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.coyoteRequest.action(ActionCode.REQ_HOST_ADDR_ATTRIBUTE, (Object)this.coyoteRequest);
            this.remoteAddr = this.coyoteRequest.remoteAddr().toString();
        }
        return this.remoteAddr;
    }

    public String getPeerAddr() {
        if (this.peerAddr == null) {
            this.coyoteRequest.action(ActionCode.REQ_PEER_ADDR_ATTRIBUTE, (Object)this.coyoteRequest);
            this.peerAddr = this.coyoteRequest.peerAddr().toString();
        }
        return this.peerAddr;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (!this.connector.getEnableLookups()) {
                this.remoteHost = this.getRemoteAddr();
            } else {
                this.coyoteRequest.action(ActionCode.REQ_HOST_ATTRIBUTE, (Object)this.coyoteRequest);
                this.remoteHost = this.coyoteRequest.remoteHost().toString();
            }
        }
        return this.remoteHost;
    }

    public int getRemotePort() {
        if (this.remotePort == -1) {
            this.coyoteRequest.action(ActionCode.REQ_REMOTEPORT_ATTRIBUTE, (Object)this.coyoteRequest);
            this.remotePort = this.coyoteRequest.getRemotePort();
        }
        return this.remotePort;
    }

    public String getLocalName() {
        if (this.localName == null) {
            this.coyoteRequest.action(ActionCode.REQ_LOCAL_NAME_ATTRIBUTE, (Object)this.coyoteRequest);
            this.localName = this.coyoteRequest.localName().toString();
        }
        return this.localName;
    }

    public String getLocalAddr() {
        if (this.localAddr == null) {
            this.coyoteRequest.action(ActionCode.REQ_LOCAL_ADDR_ATTRIBUTE, (Object)this.coyoteRequest);
            this.localAddr = this.coyoteRequest.localAddr().toString();
        }
        return this.localAddr;
    }

    public int getLocalPort() {
        if (this.localPort == -1) {
            this.coyoteRequest.action(ActionCode.REQ_LOCALPORT_ATTRIBUTE, (Object)this.coyoteRequest);
            this.localPort = this.coyoteRequest.getLocalPort();
        }
        return this.localPort;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        String string2;
        Context context = this.getContext();
        if (context == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        int n = string.indexOf(35);
        if (n > -1) {
            log.warn((Object)sm.getString("request.fragmentInDispatchPath", new Object[]{string}));
            string = string.substring(0, n);
        }
        if (string.startsWith("/")) {
            return context.getServletContext().getRequestDispatcher(string);
        }
        String string3 = (String)this.getAttribute("jakarta.servlet.include.servlet_path");
        if (string3 == null) {
            string3 = this.getServletPath();
        }
        Object object = (string2 = this.getPathInfo()) == null ? string3 : string3 + string2;
        int n2 = ((String)object).lastIndexOf(47);
        String string4 = context.getDispatchersUseEncodedPaths() ? (n2 >= 0 ? URLEncoder.DEFAULT.encode(((String)object).substring(0, n2 + 1), StandardCharsets.UTF_8) + string : URLEncoder.DEFAULT.encode((String)object, StandardCharsets.UTF_8) + string) : (n2 >= 0 ? ((String)object).substring(0, n2 + 1) + string : (String)object + string);
        return context.getServletContext().getRequestDispatcher(string4);
    }

    public String getScheme() {
        return this.coyoteRequest.scheme().toStringType();
    }

    public String getServerName() {
        return this.coyoteRequest.serverName().toString();
    }

    public int getServerPort() {
        return this.coyoteRequest.getServerPort();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void removeAttribute(String string) {
        boolean bl;
        if (string.startsWith("org.apache.tomcat.")) {
            this.coyoteRequest.getAttributes().remove(string);
        }
        if (bl = this.attributes.containsKey(string)) {
            Object object = this.attributes.get(string);
            this.attributes.remove(string);
            this.notifyAttributeRemoved(string, object);
        }
    }

    public void setAttribute(String string, Object object) {
        Object object2;
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("coyoteRequest.setAttribute.namenull"));
        }
        if (object == null) {
            this.removeAttribute(string);
            return;
        }
        SpecialAttributeAdapter specialAttributeAdapter = specialAttributes.get(string);
        if (specialAttributeAdapter != null) {
            specialAttributeAdapter.set(this, string, object);
            return;
        }
        if (Globals.IS_SECURITY_ENABLED && string.equals("org.apache.tomcat.sendfile.filename")) {
            try {
                object2 = new File(object.toString()).getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new SecurityException(sm.getString("coyoteRequest.sendfileNotCanonical", new Object[]{object}), iOException);
            }
            System.getSecurityManager().checkRead((String)object2);
            object = object2;
        }
        object2 = this.attributes.put(string, object);
        if (string.startsWith("org.apache.tomcat.")) {
            this.coyoteRequest.setAttribute(string, object);
        }
        this.notifyAttributeAssigned(string, object, object2);
    }

    private void notifyAttributeAssigned(String string, Object object, Object object2) {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        Object[] objectArray = context.getApplicationEventListeners();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        boolean bl = object2 != null;
        ServletRequestAttributeEvent servletRequestAttributeEvent = bl ? new ServletRequestAttributeEvent(context.getServletContext(), (ServletRequest)this.getRequest(), string, object2) : new ServletRequestAttributeEvent(context.getServletContext(), (ServletRequest)this.getRequest(), string, object);
        for (Object object3 : objectArray) {
            if (!(object3 instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener servletRequestAttributeListener = (ServletRequestAttributeListener)object3;
            try {
                if (bl) {
                    servletRequestAttributeListener.attributeReplaced(servletRequestAttributeEvent);
                    continue;
                }
                servletRequestAttributeListener.attributeAdded(servletRequestAttributeEvent);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.attributes.put("jakarta.servlet.error.exception", throwable);
                context.getLogger().error((Object)sm.getString("coyoteRequest.attributeEvent"), throwable);
            }
        }
    }

    private void notifyAttributeRemoved(String string, Object object) {
        Context context = this.getContext();
        Object[] objectArray = context.getApplicationEventListeners();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(context.getServletContext(), (ServletRequest)this.getRequest(), string, object);
        for (Object object2 : objectArray) {
            if (!(object2 instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener servletRequestAttributeListener = (ServletRequestAttributeListener)object2;
            try {
                servletRequestAttributeListener.attributeRemoved(servletRequestAttributeEvent);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.attributes.put("jakarta.servlet.error.exception", throwable);
                context.getLogger().error((Object)sm.getString("coyoteRequest.attributeEvent"), throwable);
            }
        }
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        if (this.usingReader) {
            return;
        }
        Charset charset = B2CConverter.getCharset((String)string);
        this.coyoteRequest.setCharset(charset);
    }

    public ServletContext getServletContext() {
        return this.getContext().getServletContext();
    }

    public AsyncContext startAsync() {
        return this.startAsync((ServletRequest)this.getRequest(), (ServletResponse)this.response.getResponse());
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        if (!this.isAsyncSupported()) {
            IllegalStateException illegalStateException = new IllegalStateException(sm.getString("request.asyncNotSupported"));
            log.warn((Object)sm.getString("coyoteRequest.noAsync", new Object[]{StringUtils.join(this.getNonAsyncClassNames())}), (Throwable)illegalStateException);
            throw illegalStateException;
        }
        if (this.asyncContext == null) {
            this.asyncContext = new AsyncContextImpl(this);
        }
        this.asyncContext.setStarted(this.getContext(), servletRequest, servletResponse, servletRequest == this.getRequest() && servletResponse == this.getResponse().getResponse());
        this.asyncContext.setTimeout(this.getConnector().getAsyncTimeout());
        return this.asyncContext;
    }

    private Set<String> getNonAsyncClassNames() {
        FilterChain filterChain;
        HashSet<String> hashSet = new HashSet<String>();
        Wrapper wrapper = this.getWrapper();
        if (!wrapper.isAsyncSupported()) {
            hashSet.add(wrapper.getServletClass());
        }
        if ((filterChain = this.getFilterChain()) instanceof ApplicationFilterChain) {
            ((ApplicationFilterChain)filterChain).findNonAsyncFilters(hashSet);
        } else {
            hashSet.add(sm.getString("coyoteRequest.filterAsyncSupportUnknown"));
        }
        for (Container container = wrapper; container != null; container = container.getParent()) {
            container.getPipeline().findNonAsyncValves(hashSet);
        }
        return hashSet;
    }

    public boolean isAsyncStarted() {
        if (this.asyncContext == null) {
            return false;
        }
        return this.asyncContext.isStarted();
    }

    public boolean isAsyncDispatching() {
        if (this.asyncContext == null) {
            return false;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.coyoteRequest.action(ActionCode.ASYNC_IS_DISPATCHING, (Object)atomicBoolean);
        return atomicBoolean.get();
    }

    public boolean isAsyncCompleting() {
        if (this.asyncContext == null) {
            return false;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.coyoteRequest.action(ActionCode.ASYNC_IS_COMPLETING, (Object)atomicBoolean);
        return atomicBoolean.get();
    }

    public boolean isAsync() {
        if (this.asyncContext == null) {
            return false;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.coyoteRequest.action(ActionCode.ASYNC_IS_ASYNC, (Object)atomicBoolean);
        return atomicBoolean.get();
    }

    public boolean isAsyncSupported() {
        if (this.asyncSupported == null) {
            return true;
        }
        return this.asyncSupported;
    }

    public AsyncContext getAsyncContext() {
        if (!this.isAsyncStarted()) {
            throw new IllegalStateException(sm.getString("request.notAsync"));
        }
        return this.asyncContext;
    }

    public AsyncContextImpl getAsyncContextInternal() {
        return this.asyncContext;
    }

    public DispatcherType getDispatcherType() {
        return Objects.requireNonNullElse(this.internalDispatcherType, DispatcherType.REQUEST);
    }

    public String getRequestId() {
        return this.coyoteRequest.getRequestId();
    }

    public String getProtocolRequestId() {
        return this.coyoteRequest.getProtocolRequestId();
    }

    public ServletConnection getServletConnection() {
        return this.coyoteRequest.getServletConnection();
    }

    public void addCookie(Cookie cookie) {
        if (!this.cookiesConverted) {
            this.convertCookies();
        }
        int n = 0;
        if (this.cookies != null) {
            n = this.cookies.length;
        }
        Cookie[] cookieArray = new Cookie[n + 1];
        if (this.cookies != null) {
            System.arraycopy(this.cookies, 0, cookieArray, 0, n);
        }
        cookieArray[n] = cookie;
        this.cookies = cookieArray;
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void clearCookies() {
        this.cookiesParsed = true;
        this.cookiesConverted = true;
        this.cookies = null;
    }

    public void clearLocales() {
        this.locales.clear();
    }

    public void setAuthType(String string) {
        this.authType = string;
    }

    public void setPathInfo(String string) {
        this.mappingData.pathInfo.setString(string);
    }

    public void setRequestedSessionCookie(boolean bl) {
        this.requestedSessionCookie = bl;
    }

    public void setRequestedSessionId(String string) {
        this.requestedSessionId = string;
    }

    public void setRequestedSessionURL(boolean bl) {
        this.requestedSessionURL = bl;
    }

    public void setRequestedSessionSSL(boolean bl) {
        this.requestedSessionSSL = bl;
    }

    public String getDecodedRequestURI() {
        return this.coyoteRequest.decodedURI().toString();
    }

    public MessageBytes getDecodedRequestURIMB() {
        return this.coyoteRequest.decodedURI();
    }

    public void setUserPrincipal(Principal principal) {
        if (Globals.IS_SECURITY_ENABLED && principal != null) {
            if (this.subject == null) {
                HttpSession httpSession = this.getSession(false);
                if (httpSession == null) {
                    this.subject = this.newSubject(principal);
                } else {
                    this.subject = (Subject)httpSession.getAttribute("javax.security.auth.subject");
                    if (this.subject == null) {
                        this.subject = this.newSubject(principal);
                        httpSession.setAttribute("javax.security.auth.subject", (Object)this.subject);
                    } else {
                        this.subject.getPrincipals().add(principal);
                    }
                }
            } else {
                this.subject.getPrincipals().add(principal);
            }
        }
        this.userPrincipal = principal;
    }

    private Subject newSubject(Principal principal) {
        Subject subject = new Subject();
        subject.getPrincipals().add(principal);
        return subject;
    }

    public boolean isTrailerFieldsReady() {
        return this.coyoteRequest.isTrailerFieldsReady();
    }

    public Map<String, String> getTrailerFields() {
        if (!this.isTrailerFieldsReady()) {
            throw new IllegalStateException(sm.getString("coyoteRequest.trailersNotReady"));
        }
        return this.coyoteRequest.getTrailerFields();
    }

    public PushBuilder newPushBuilder() {
        return this.newPushBuilder(this);
    }

    public PushBuilder newPushBuilder(HttpServletRequest httpServletRequest) {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        this.coyoteRequest.action(ActionCode.IS_PUSH_SUPPORTED, (Object)atomicBoolean);
        if (atomicBoolean.get()) {
            return new ApplicationPushBuilder(this, httpServletRequest);
        }
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> clazz) throws IOException, ServletException {
        HttpUpgradeHandler httpUpgradeHandler;
        InstanceManager instanceManager = null;
        try {
            if (InternalHttpUpgradeHandler.class.isAssignableFrom(clazz)) {
                httpUpgradeHandler = (HttpUpgradeHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                instanceManager = this.getContext().getInstanceManager();
                httpUpgradeHandler = (HttpUpgradeHandler)instanceManager.newInstance(clazz);
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException | NamingException exception) {
            throw new ServletException((Throwable)exception);
        }
        UpgradeToken upgradeToken = new UpgradeToken(httpUpgradeHandler, (ContextBind)this.getContext(), instanceManager, this.getUpgradeProtocolName(clazz));
        this.coyoteRequest.action(ActionCode.UPGRADE, (Object)upgradeToken);
        this.response.setStatus(101);
        return (T)httpUpgradeHandler;
    }

    private String getUpgradeProtocolName(Class<? extends HttpUpgradeHandler> clazz) {
        List list;
        String string = this.response.getHeader(HTTP_UPGRADE_HEADER_NAME);
        if (string == null && (list = Upgrade.parse(this.getHeaders(HTTP_UPGRADE_HEADER_NAME))) != null && list.size() == 1) {
            string = ((Upgrade)list.get(0)).toString();
        }
        if (string == null) {
            string = clazz.getName();
        }
        return string;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        int n = this.mappingData.contextSlashCount;
        if (n == 0) {
            return "";
        }
        String string = this.getServletContext().getContextPath();
        String string2 = this.getRequestURI();
        int n2 = 0;
        if (!this.getContext().getAllowMultipleLeadingForwardSlashInPath()) {
            while (++n2 < string2.length() && string2.charAt(n2) == '/') {
            }
            string2 = string2.substring(--n2);
        }
        char[] cArray = string2.toCharArray();
        while (n > 0 && (n2 = this.nextSlash(cArray, n2 + 1)) != -1) {
            --n;
        }
        String string3 = n2 == -1 ? string2 : string2.substring(0, n2);
        string3 = this.removePathParameters(string3);
        string3 = UDecoder.URLDecode((String)string3, (Charset)this.connector.getURICharset());
        string3 = org.apache.tomcat.util.http.RequestUtil.normalize((String)string3);
        boolean bl = string.equals(string3);
        while (!bl && n2 != -1) {
            string3 = (n2 = this.nextSlash(cArray, n2 + 1)) == -1 ? string2 : string2.substring(0, n2);
            string3 = this.removePathParameters(string3);
            string3 = UDecoder.URLDecode((String)string3, (Charset)this.connector.getURICharset());
            string3 = org.apache.tomcat.util.http.RequestUtil.normalize((String)string3);
            bl = string.equals(string3);
        }
        if (bl) {
            if (n2 == -1) {
                return string2;
            }
            return string2.substring(0, n2);
        }
        throw new IllegalStateException(sm.getString("coyoteRequest.getContextPath.ise", new Object[]{string, string2}));
    }

    private String removePathParameters(String string) {
        int n;
        int n2 = string.indexOf(59);
        if (n2 == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(string, 0, n2);
        while ((n = string.indexOf(47, n2)) != -1) {
            n2 = string.indexOf(59, n);
            if (n2 == -1) {
                stringBuilder.append(string.substring(n));
                break;
            }
            stringBuilder.append(string, n, n2);
        }
        return stringBuilder.toString();
    }

    private int nextSlash(char[] cArray, int n) {
        int n2 = cArray.length;
        for (int i = n; i < n2; ++i) {
            if (cArray[i] == '/') {
                return i;
            }
            if (this.connector.getEncodedSolidusHandlingInternal() != EncodedSolidusHandling.DECODE || cArray[i] != '%' || i + 2 >= n2 || cArray[i + 1] != '2' || cArray[i + 2] != 'f' && cArray[i + 2] != 'F') continue;
            return i;
        }
        return -1;
    }

    public Cookie[] getCookies() {
        if (!this.cookiesConverted) {
            this.convertCookies();
        }
        return this.cookies;
    }

    public ServerCookies getServerCookies() {
        this.parseCookies();
        return this.coyoteRequest.getCookies();
    }

    public long getDateHeader(String string) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return -1L;
        }
        long l = FastHttpDateFormat.parseDate((String)string2);
        if (l != -1L) {
            return l;
        }
        throw new IllegalArgumentException(string2);
    }

    public String getHeader(String string) {
        return this.coyoteRequest.getHeader(string);
    }

    public Enumeration<String> getHeaders(String string) {
        return this.coyoteRequest.getMimeHeaders().values(string);
    }

    public Enumeration<String> getHeaderNames() {
        return this.coyoteRequest.getMimeHeaders().names();
    }

    public int getIntHeader(String string) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public HttpServletMapping getHttpServletMapping() {
        return this.applicationMapping.getHttpServletMapping();
    }

    public String getMethod() {
        return this.coyoteRequest.method().toStringType();
    }

    public String getPathInfo() {
        return this.mappingData.pathInfo.toStringType();
    }

    public String getPathTranslated() {
        Context context = this.getContext();
        if (context == null) {
            return null;
        }
        if (this.getPathInfo() == null) {
            return null;
        }
        return context.getServletContext().getRealPath(this.getPathInfo());
    }

    public String getQueryString() {
        return this.coyoteRequest.queryString().toString();
    }

    public String getRemoteUser() {
        if (this.userPrincipal == null) {
            return null;
        }
        return this.userPrincipal.getName();
    }

    public MessageBytes getRequestPathMB() {
        return this.mappingData.requestPath;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.coyoteRequest.requestURI().toStringType();
    }

    public StringBuffer getRequestURL() {
        return RequestUtil.getRequestURL(this);
    }

    public String getServletPath() {
        return this.mappingData.wrapperPath.toStringType();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        Session session = this.doGetSession(bl);
        if (session == null) {
            return null;
        }
        return session.getSession();
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId == null) {
            return false;
        }
        return this.requestedSessionCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId == null) {
            return false;
        }
        return this.requestedSessionURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        ClassLoader classLoader = context.bind(Globals.IS_SECURITY_ENABLED, null);
        try {
            Manager manager = context.getManager();
            if (manager == null) {
                boolean bl = false;
                return bl;
            }
            Session session = null;
            try {
                session = manager.findSession(this.requestedSessionId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (session == null || !session.isValid()) {
                if (this.getMappingData().contexts != null) {
                    for (int i = this.getMappingData().contexts.length; i > 0; --i) {
                        Context context2 = this.getMappingData().contexts[i - 1];
                        try {
                            if (context2.getManager().findSession(this.requestedSessionId) != null) {
                                boolean bl = true;
                                return bl;
                            }
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            context.unbind(Globals.IS_SECURITY_ENABLED, classLoader);
        }
    }

    public boolean isUserInRole(String string) {
        if (this.userPrincipal == null) {
            return false;
        }
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        if ("*".equals(string)) {
            return false;
        }
        if ("**".equals(string) && !context.findSecurityRole("**")) {
            return this.userPrincipal != null;
        }
        Realm realm = context.getRealm();
        if (realm == null) {
            return false;
        }
        return realm.hasRole(this.getWrapper(), this.userPrincipal, string);
    }

    public Principal getPrincipal() {
        return this.userPrincipal;
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal instanceof TomcatPrincipal) {
            GSSCredential gSSCredential = ((TomcatPrincipal)this.userPrincipal).getGssCredential();
            if (gSSCredential != null) {
                int n = -1;
                try {
                    n = gSSCredential.getRemainingLifetime();
                }
                catch (IllegalStateException | GSSException exception) {
                    log.warn((Object)sm.getString("coyoteRequest.gssLifetimeFail", new Object[]{this.userPrincipal.getName()}), (Throwable)exception);
                }
                if (n <= 0) {
                    try {
                        this.logout();
                    }
                    catch (ServletException servletException) {
                        // empty catch block
                    }
                    return null;
                }
            }
            return ((TomcatPrincipal)this.userPrincipal).getUserPrincipal();
        }
        return this.userPrincipal;
    }

    public Session getSessionInternal() {
        return this.doGetSession(true);
    }

    public void changeSessionId(String string) {
        Context context;
        if (this.requestedSessionId != null && !this.requestedSessionId.isEmpty()) {
            this.requestedSessionId = string;
        }
        if ((context = this.getContext()) != null && !context.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.COOKIE)) {
            return;
        }
        if (this.response != null && context != null) {
            Cookie cookie = ApplicationSessionCookieConfig.createSessionCookie(context, string, this.isSecure());
            this.response.addSessionCookieInternal(cookie);
        }
    }

    public String changeSessionId() {
        Session session = this.getSessionInternal(false);
        if (session == null) {
            throw new IllegalStateException(sm.getString("coyoteRequest.changeSessionId"));
        }
        Manager manager = this.getContext().getManager();
        String string = manager.rotateSessionId(session);
        this.changeSessionId(string);
        return string;
    }

    public Session getSessionInternal(boolean bl) {
        return this.doGetSession(bl);
    }

    public boolean isParametersParsed() {
        return this.parametersParsed;
    }

    public boolean isFinished() {
        return this.coyoteRequest.isFinished();
    }

    protected void checkSwallowInput() {
        Context context = this.getContext();
        if (context != null && !context.getSwallowAbortedUploads()) {
            this.coyoteRequest.action(ActionCode.DISABLE_SWALLOW_INPUT, null);
        }
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (httpServletResponse.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteRequest.authenticate.ise"));
        }
        return this.getContext().getAuthenticator().authenticate(this, httpServletResponse);
    }

    public void login(String string, String string2) throws ServletException {
        if (this.getAuthType() != null || this.getRemoteUser() != null || this.getUserPrincipal() != null) {
            throw new ServletException(sm.getString("coyoteRequest.alreadyAuthenticated"));
        }
        this.getContext().getAuthenticator().login(string, string2, this);
    }

    public void logout() throws ServletException {
        this.getContext().getAuthenticator().logout(this);
    }

    public Collection<Part> getParts() throws IOException, IllegalStateException, ServletException {
        this.parseParts(true);
        if (this.partsParseException != null) {
            Context context = this.getContext();
            if (context != null && context.getLogger().isDebugEnabled()) {
                context.getLogger().debug((Object)sm.getString("coyoteRequest.partsParseException", new Object[]{this.partsParseException.getMessage()}));
            }
            if (this.partsParseException instanceof IOException) {
                throw (IOException)this.partsParseException;
            }
            if (this.partsParseException instanceof IllegalStateException) {
                throw (IllegalStateException)this.partsParseException;
            }
            if (this.partsParseException instanceof ServletException) {
                throw (ServletException)((Object)this.partsParseException);
            }
        }
        return this.parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseParts(boolean bl) {
        if (this.parts != null || this.partsParseException != null) {
            return;
        }
        Context context = this.getContext();
        MultipartConfigElement multipartConfigElement = this.getWrapper().getMultipartConfigElement();
        if (multipartConfigElement == null) {
            if (context.getAllowCasualMultipartParsing()) {
                multipartConfigElement = new MultipartConfigElement(null, (long)this.connector.getMaxPostSize(), (long)this.connector.getMaxPostSize(), this.connector.getMaxPostSize());
            } else {
                if (bl) {
                    this.partsParseException = new IllegalStateException(sm.getString("coyoteRequest.noMultipartConfig"));
                } else {
                    this.parts = Collections.emptyList();
                }
                return;
            }
        }
        Parameters parameters = this.coyoteRequest.getParameters();
        parameters.setLimit(this.maxParameterCount);
        boolean bl2 = false;
        try {
            int n;
            File file;
            String string = multipartConfigElement.getLocation();
            if (string == null || string.length() == 0) {
                file = (File)context.getServletContext().getAttribute("jakarta.servlet.context.tempdir");
            } else {
                file = new File(string);
                if (!file.isAbsolute()) {
                    file = new File((File)context.getServletContext().getAttribute("jakarta.servlet.context.tempdir"), string).getAbsoluteFile();
                }
            }
            if (!file.exists() && context.getCreateUploadTargets()) {
                log.warn((Object)sm.getString("coyoteRequest.uploadCreate", new Object[]{file.getAbsolutePath(), this.getMappingData().wrapper.getName()}));
                if (!file.mkdirs()) {
                    log.warn((Object)sm.getString("coyoteRequest.uploadCreateFail", new Object[]{file.getAbsolutePath()}));
                }
            }
            if (!file.isDirectory()) {
                parameters.setParseFailedReason(Parameters.FailReason.MULTIPART_CONFIG_INVALID);
                this.partsParseException = new IOException(sm.getString("coyoteRequest.uploadLocationInvalid", new Object[]{file}));
                return;
            }
            DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
            try {
                diskFileItemFactory.setRepository(file.getCanonicalFile());
            }
            catch (IOException iOException) {
                parameters.setParseFailedReason(Parameters.FailReason.IO_ERROR);
                this.partsParseException = iOException;
                if (this.partsParseException != null || !bl2) {
                    parameters.setParseFailedReason(Parameters.FailReason.UNKNOWN);
                }
                return;
            }
            diskFileItemFactory.setSizeThreshold(multipartConfigElement.getFileSizeThreshold());
            FileUpload fileUpload = new FileUpload();
            fileUpload.setFileItemFactory((FileItemFactory)diskFileItemFactory);
            fileUpload.setFileSizeMax(multipartConfigElement.getMaxFileSize());
            fileUpload.setSizeMax(multipartConfigElement.getMaxRequestSize());
            fileUpload.setPartHeaderSizeMax(this.maxPartHeaderSize);
            int n2 = this.maxParameterCount;
            if (n2 > -1) {
                n2 -= parameters.size();
            }
            if ((n = this.maxPartCount) > -1 && (n2 < 0 || n2 > n)) {
                n2 = n;
            }
            fileUpload.setFileCountMax((long)n2);
            this.parts = new ArrayList<Part>();
            try {
                List list = fileUpload.parseRequest((RequestContext)new ServletRequestContext((HttpServletRequest)this));
                int n3 = this.getConnector().getMaxPostSize();
                long l = 0L;
                Charset charset = this.getCharset();
                for (FileItem fileItem : list) {
                    ApplicationPart applicationPart = new ApplicationPart(fileItem, file);
                    if (applicationPart.getSubmittedFileName() == null) {
                        String string2 = applicationPart.getName();
                        if (n3 >= 0) {
                            l = Math.addExact(l, (long)string2.getBytes(charset).length);
                            l = Math.addExact(l, 1L);
                            l = Math.addExact(l, applicationPart.getSize());
                            if ((l = Math.addExact(l, 1L)) > (long)n3) {
                                parameters.setParseFailedReason(Parameters.FailReason.POST_TOO_LARGE);
                                throw new IllegalStateException(sm.getString("coyoteRequest.maxPostSizeExceeded"));
                            }
                        }
                        String string3 = null;
                        try {
                            string3 = applicationPart.getString(charset.name());
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        parameters.addParameter(string2, string3);
                    } else {
                        --this.maxParameterCount;
                    }
                    this.parts.add(applicationPart);
                }
                bl2 = true;
            }
            catch (InvalidContentTypeException invalidContentTypeException) {
                parameters.setParseFailedReason(Parameters.FailReason.INVALID_CONTENT_TYPE);
                this.partsParseException = new ServletException((Throwable)invalidContentTypeException);
            }
            catch (FileCountLimitExceededException | SizeException throwable) {
                parameters.setParseFailedReason(Parameters.FailReason.POST_TOO_LARGE);
                this.checkSwallowInput();
                this.partsParseException = new IllegalStateException(throwable);
            }
            catch (IOException iOException) {
                parameters.setParseFailedReason(Parameters.FailReason.IO_ERROR);
                this.partsParseException = iOException;
            }
            catch (IllegalStateException illegalStateException) {
                this.checkSwallowInput();
                this.partsParseException = illegalStateException;
            }
        }
        finally {
            if (this.partsParseException != null || !bl2) {
                parameters.setParseFailedReason(Parameters.FailReason.UNKNOWN);
            }
        }
    }

    public Part getPart(String string) throws IOException, IllegalStateException, ServletException {
        for (Part part : this.getParts()) {
            if (!string.equals(part.getName())) continue;
            return part;
        }
        return null;
    }

    protected Session doGetSession(boolean bl) {
        Context context = this.getContext();
        if (context == null) {
            return null;
        }
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session;
        }
        Manager manager = context.getManager();
        if (manager == null) {
            return null;
        }
        if (this.requestedSessionId != null) {
            try {
                this.session = manager.findSession(this.requestedSessionId);
            }
            catch (IOException iOException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("request.session.failed", new Object[]{this.requestedSessionId, iOException.getMessage()}), (Throwable)iOException);
                } else {
                    log.info((Object)sm.getString("request.session.failed", new Object[]{this.requestedSessionId, iOException.getMessage()}));
                }
                this.session = null;
            }
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                this.session.access();
                return this.session;
            }
        }
        if (!bl) {
            return null;
        }
        boolean bl2 = context.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.COOKIE);
        if (bl2 && this.response.getResponse().isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteRequest.sessionCreateCommitted"));
        }
        String string = this.getRequestedSessionId();
        if (!this.requestedSessionSSL) {
            if ("/".equals(context.getSessionCookiePath()) && this.isRequestedSessionIdFromCookie()) {
                if (context.getValidateClientProvidedNewSessionId()) {
                    boolean bl3 = false;
                    for (Container container : this.getHost().findChildren()) {
                        Manager manager2 = ((Context)container).getManager();
                        if (manager2 == null) continue;
                        try {
                            if (manager2.findSession(string) == null) continue;
                            bl3 = true;
                            break;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!bl3) {
                        string = null;
                    }
                }
            } else {
                string = null;
            }
        }
        this.session = manager.createSession(string);
        if (this.session != null && bl2) {
            Cookie cookie = ApplicationSessionCookieConfig.createSessionCookie(context, this.session.getIdInternal(), this.isSecure());
            this.response.addSessionCookieInternal(cookie);
        }
        if (this.session == null) {
            return null;
        }
        this.session.access();
        return this.session;
    }

    protected String unescape(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(92) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\\') {
                stringBuilder.append(c);
                continue;
            }
            if (++i >= string.length()) {
                throw new IllegalArgumentException();
            }
            c = string.charAt(i);
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private CookieProcessor getCookieProcessor() {
        Context context = this.getContext();
        if (context == null) {
            return new Rfc6265CookieProcessor();
        }
        return context.getCookieProcessor();
    }

    protected void parseCookies() {
        if (this.cookiesParsed) {
            return;
        }
        this.cookiesParsed = true;
        ServerCookies serverCookies = this.coyoteRequest.getCookies();
        serverCookies.setLimit(this.connector.getMaxCookieCount());
        this.getCookieProcessor().parseCookieHeader(this.coyoteRequest.getMimeHeaders(), serverCookies);
    }

    protected void convertCookies() {
        if (this.cookiesConverted) {
            return;
        }
        this.cookiesConverted = true;
        this.parseCookies();
        ServerCookies serverCookies = this.coyoteRequest.getCookies();
        int n = serverCookies.getCookieCount();
        if (n <= 0) {
            return;
        }
        this.cookies = new Cookie[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ServerCookie serverCookie = serverCookies.getCookie(i);
            try {
                Cookie cookie = new Cookie(serverCookie.getName().toString(), null);
                serverCookie.getValue().getByteChunk().setCharset(this.getCookieProcessor().getCharset());
                cookie.setValue(this.unescape(serverCookie.getValue().toString()));
                this.cookies[n2++] = cookie;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (n2 < n) {
            Cookie[] cookieArray = new Cookie[n2];
            System.arraycopy(this.cookies, 0, cookieArray, 0, n2);
            this.cookies = cookieArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void parseParameters() {
        block37: {
            this.parametersParsed = true;
            Parameters parameters = this.coyoteRequest.getParameters();
            boolean bl = false;
            try {
                parameters.setLimit(this.maxParameterCount);
                Charset charset = this.getCharset();
                boolean bl2 = this.connector.getUseBodyEncodingForURI();
                parameters.setCharset(charset);
                if (bl2) {
                    parameters.setQueryStringCharset(charset);
                }
                parameters.handleQueryParameters();
                if (this.usingInputStream || this.usingReader) {
                    bl = true;
                    return;
                }
                String string = MediaType.parseMediaTypeOnly((String)this.getContentType());
                if ("multipart/form-data".equals(string)) {
                    this.parseParts(false);
                    bl = true;
                    return;
                }
                if (!this.getConnector().isParseBodyMethod(this.getMethod())) {
                    bl = true;
                    return;
                }
                if (!"application/x-www-form-urlencoded".equals(string)) {
                    bl = true;
                    return;
                }
                int n = this.getContentLength();
                if (n > 0) {
                    int n2 = this.connector.getMaxPostSize();
                    if (n2 >= 0 && n > n2) {
                        Context context = this.getContext();
                        if (context != null && context.getLogger().isDebugEnabled()) {
                            context.getLogger().debug((Object)sm.getString("coyoteRequest.postTooLarge"));
                        }
                        this.checkSwallowInput();
                        parameters.setParseFailedReason(Parameters.FailReason.POST_TOO_LARGE);
                        return;
                    }
                    byte[] byArray = null;
                    if (n < 8192) {
                        if (this.postData == null) {
                            this.postData = new byte[8192];
                        }
                        byArray = this.postData;
                    } else {
                        byArray = new byte[n];
                    }
                    try {
                        this.readPostBodyFully(byArray, n);
                    }
                    catch (IOException iOException) {
                        Context context = this.getContext();
                        if (context != null && context.getLogger().isDebugEnabled()) {
                            context.getLogger().debug((Object)sm.getString("coyoteRequest.parseParameters"), (Throwable)iOException);
                        }
                        parameters.setParseFailedReason(Parameters.FailReason.CLIENT_DISCONNECT);
                        if (!bl) {
                            parameters.setParseFailedReason(Parameters.FailReason.UNKNOWN);
                        }
                        return;
                    }
                    parameters.processParameters(byArray, 0, n);
                } else if ("chunked".equalsIgnoreCase(this.coyoteRequest.getHeader("transfer-encoding"))) {
                    byte[] byArray = null;
                    try {
                        byArray = this.readChunkedPostBody();
                    }
                    catch (IllegalStateException illegalStateException) {
                        parameters.setParseFailedReason(Parameters.FailReason.POST_TOO_LARGE);
                        Context context = this.getContext();
                        if (context != null && context.getLogger().isDebugEnabled()) {
                            context.getLogger().debug((Object)sm.getString("coyoteRequest.parseParameters"), (Throwable)illegalStateException);
                        }
                        if (!bl) {
                            parameters.setParseFailedReason(Parameters.FailReason.UNKNOWN);
                        }
                        return;
                    }
                    catch (IOException iOException) {
                        block36: {
                            parameters.setParseFailedReason(Parameters.FailReason.CLIENT_DISCONNECT);
                            Context context = this.getContext();
                            if (context != null && context.getLogger().isDebugEnabled()) {
                                context.getLogger().debug((Object)sm.getString("coyoteRequest.parseParameters"), (Throwable)iOException);
                            }
                            if (bl) break block36;
                            parameters.setParseFailedReason(Parameters.FailReason.UNKNOWN);
                        }
                        return;
                    }
                    if (byArray != null) {
                        parameters.processParameters(byArray, 0, byArray.length);
                    }
                }
                bl = true;
                break block37;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (!bl) {
                    parameters.setParseFailedReason(Parameters.FailReason.UNKNOWN);
                }
            }
        }
    }

    @Deprecated
    protected int readPostBody(byte[] byArray, int n) throws IOException {
        int n2;
        int n3 = 0;
        do {
            if ((n2 = this.getStream().read(byArray, n3, n - n3)) > 0) continue;
            return n3;
        } while (n - (n3 += n2) > 0);
        return n;
    }

    protected void readPostBodyFully(byte[] byArray, int n) throws IOException {
        int n2;
        int n3 = 0;
        do {
            if ((n2 = this.getStream().read(byArray, n3, n - n3)) > 0) continue;
            throw new EOFException();
        } while (n - (n3 += n2) > 0);
    }

    protected byte[] readChunkedPostBody() throws IOException {
        ByteChunk byteChunk = new ByteChunk();
        byte[] byArray = new byte[8192];
        int n = 0;
        while (n > -1) {
            n = this.getStream().read(byArray, 0, 8192);
            if (this.connector.getMaxPostSize() >= 0 && byteChunk.getLength() + n > this.connector.getMaxPostSize()) {
                this.checkSwallowInput();
                throw new IllegalStateException(sm.getString("coyoteRequest.chunkedPostTooLarge"));
            }
            if (n <= 0) continue;
            byteChunk.append(byArray, 0, n);
        }
        if (byteChunk.getLength() == 0) {
            return null;
        }
        if (byteChunk.getLength() < byteChunk.getBuffer().length) {
            int n2 = byteChunk.getLength();
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byteChunk.getBuffer(), 0, byArray2, 0, n2);
            return byArray2;
        }
        return byteChunk.getBuffer();
    }

    protected void parseLocales() {
        this.localesParsed = true;
        TreeMap<Double, ArrayList<Locale>> treeMap = new TreeMap<Double, ArrayList<Locale>>();
        Enumeration<String> enumeration = this.getHeaders("accept-language");
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.parseLocalesHeader(string, treeMap);
        }
        for (ArrayList arrayList : treeMap.values()) {
            for (Locale locale : arrayList) {
                this.addLocale(locale);
            }
        }
    }

    protected void parseLocalesHeader(String string, TreeMap<Double, ArrayList<Locale>> treeMap) {
        List list;
        try {
            list = AcceptLanguage.parse((StringReader)new StringReader(string));
        }
        catch (IOException iOException) {
            return;
        }
        for (AcceptLanguage acceptLanguage : list) {
            Double d2 = -acceptLanguage.getQuality();
            treeMap.computeIfAbsent(d2, d -> new ArrayList()).add(acceptLanguage.getLocale());
        }
    }

    static {
        specialAttributes.put("org.apache.catalina.core.DISPATCHER_TYPE", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                return request.internalDispatcherType == null ? DispatcherType.REQUEST : request.internalDispatcherType;
            }

            @Override
            public void set(Request request, String string, Object object) {
                request.internalDispatcherType = (DispatcherType)object;
            }
        });
        specialAttributes.put("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                return request.requestDispatcherPath == null ? request.getRequestPathMB().toString() : request.requestDispatcherPath.toString();
            }

            @Override
            public void set(Request request, String string, Object object) {
                request.requestDispatcherPath = object;
            }
        });
        specialAttributes.put("org.apache.catalina.ASYNC_SUPPORTED", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                return request.asyncSupported;
            }

            @Override
            public void set(Request request, String string, Object object) {
                Boolean bl = request.asyncSupported;
                request.asyncSupported = (Boolean)object;
                request.notifyAttributeAssigned(string, object, bl);
            }
        });
        specialAttributes.put("org.apache.catalina.realm.GSS_CREDENTIAL", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                if (request.userPrincipal instanceof TomcatPrincipal) {
                    return ((TomcatPrincipal)request.userPrincipal).getGssCredential();
                }
                return null;
            }

            @Override
            public void set(Request request, String string, Object object) {
            }
        });
        specialAttributes.put("org.apache.catalina.parameter_parse_failed", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                if (request.getCoyoteRequest().getParameters().isParseFailed()) {
                    return Boolean.TRUE;
                }
                return null;
            }

            @Override
            public void set(Request request, String string, Object object) {
            }
        });
        specialAttributes.put("org.apache.catalina.parameter_parse_failed_reason", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                return request.getCoyoteRequest().getParameters().getParseFailedReason();
            }

            @Override
            public void set(Request request, String string, Object object) {
            }
        });
        specialAttributes.put("org.apache.tomcat.sendfile.support", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                return request.getConnector().getProtocolHandler().isSendfileSupported() && request.getCoyoteRequest().getSendfile();
            }

            @Override
            public void set(Request request, String string, Object object) {
            }
        });
        specialAttributes.put("org.apache.catalina.filters.RemoteIpFilter.secure", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                return request.isSecure();
            }

            @Override
            public void set(Request request, String string, Object object) {
                if (object instanceof Boolean) {
                    request.setSecure((Boolean)object);
                }
            }
        });
    }

    private static interface SpecialAttributeAdapter {
        public Object get(Request var1, String var2);

        public void set(Request var1, String var2, Object var3);
    }
}

