# Developer Tools Code of Conduct

This file describes the Developer Tools (aka "DevTools") code of conduct.

# Conduct

We are committed to providing a friendly, safe and welcoming
environment for all, regardless of level of experience, gender, gender
identity and expression, sexual orientation, disability, personal
appearance, body size, race, ethnicity, age, religion, nationality, or
other similar characteristic.

On IRC, please avoid using overtly sexual nicknames or other nicknames
that might detract from a friendly, safe and welcoming environment for
all.

Please be kind and courteous. There’s no need to be mean or rude.

Respect that people have differences of opinion and that every design
or implementation choice carries a trade-off and numerous costs. There
is seldom a right answer.

We will exclude you from interaction if you insult, demean or harass
anyone. That is not welcome behaviour. We interpret the term
“harassment” as including the definition in the
[Citizen Code of Conduct](http://citizencodeofconduct.org/); if you
have any lack of clarity about what might be included in that concept,
please read their definition. In particular, we don’t tolerate
behavior that excludes people in socially marginalized groups.

Private harassment is also unacceptable. No matter who you are, if you
feel you have been or are being harassed or made uncomfortable by a
community member, please contact one of the moderators (see below)
immediately. Whether you’re a regular contributor or a newcomer, we
care about making this community a safe place for you and we’ve got
your back.

Likewise any spamming, trolling, flaming, baiting or other
attention-stealing behaviour is not welcome.

# Moderation

These are the policies for upholding our community’s standards of
conduct. If you feel that a thread needs moderation, please use the
point of contact for the medium in which you're communicating:

* For one of the IRC channels, contact a channel operator (they
  have an "@" in front of their names);
* Bugzilla and the dev-developer-tools mailing list, contact
  [inclusion@mozilla.com](mailto:inclusion@mozilla.com);
* The debugger.html repository on GitHub has [its own code of conduct](https://github.com/firefox-devtools/debugger.html/blob/master/CODE_OF_CONDUCT.md), but you can also
  email [inclusion@mozilla.com](mailto:inclusion@mozilla.com).

Remarks that violate these standards of conduct, including hateful,
hurtful, oppressive, or exclusionary remarks, are not
allowed. (Cursing is allowed, but never targeting another user, and
never in a hateful manner.)

Remarks that moderators find inappropriate, whether listed in the code
of conduct or not, are also not allowed.

Moderators will first respond to such remarks with a warning.

If the warning is unheeded, then on IRC the user will be “kicked,”
i.e., kicked out of the communication channel to cool off.

If the user comes back and continues to make trouble, they will be
banned, i.e., indefinitely excluded.  On other communications media,
such as bugzilla or mailing lists, it will be up to the moderator's
discretion whether a user will be banned after the first warning.

Moderators may choose at their discretion to un-ban the user if it was
a first offense and they offer the offended party a genuine apology.

If a moderator bans someone and you think it was unjustified, please
take it up with that moderator, or with a different moderator, in
private. Complaints about bans in-channel (or on the mailing list or
in the bug tracker) are not allowed.

Moderators are held to a higher standard than other community
members. If a moderator creates an inappropriate situation, they
should expect less leeway than others.

In this community we strive to go the extra step to look out for
each other. Don’t just aim to be technically unimpeachable, try to be
your best self. In particular, avoid flirting with offensive or
sensitive issues, particularly if they’re off-topic; this all too
often leads to unnecessary fights, hurt feelings, and damaged trust;
worse, it can drive people away from the community entirely.

And if someone takes issue with something you said or did, resist the
urge to be defensive. Just stop doing what it was they complained
about and apologize. Even if you feel you were misinterpreted or
unfairly accused, chances are good there was something you could’ve
communicated better — remember that it’s your responsibility to make
your fellow devtoolers comfortable. Everyone wants to get along and we
are all here first and foremost because we want to talk about cool
technology. You will find that people will be eager to assume good
intent and forgive as long as you earn their trust.

The enforcement policies listed above apply to all official DevTools
venues; including official IRC channels (those starting with
"#devtools"); GitHub repositories associated with DevTools; and
DevTools bugs in bugzilla.

# Also Applicable

The
[Mozilla Community Participation Guidelines](https://www.mozilla.org/en-US/about/governance/policies/participation/)
also apply.  Please read these as well.

# History

This was derived from the
[Rust Code of Conduct](https://www.rust-lang.org/en-US/conduct.html).

See [bug 1315344](https://bugzilla.mozilla.org/show_bug.cgi?id=1315344) if
you are curious about the genesis of this document.
