/**
 * Exposes a function that demangles function names.
 * Can be found at: https://github.com/kripken/cxx_demangle
 */
var demangle = (function() {
  // In Firefox CommonJS environment, the module boilerplate thinks it's node,
  // but `process` does not exist.
  if (typeof process !== "object" && typeof window !== "object" && typeof require === "function") {
    // null out `require` since no filesystem is necessary in this module, and this
    // way the boilerplate thinks its in a shell.
    require = null;
    // The `print` function only exists in scope when in a node environment,
    // and there doesn't seem to account for when in a shell environment and NOT node.js,
    // so just stub out the print function.
    var print = function(){}
  }

var Module = function(Module) {
  Module = Module || {};

var Module;if(!Module)Module=(typeof Module!=="undefined"?Module:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=require("fs");var nodePath=require("path");Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){eval.call(null,x)}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){DYNAMICTOP=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){try{func=eval("_"+ident)}catch(e){}}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){if(opts&&opts.async){EmterpreterAsync.asyncFinalizers.push((function(){Runtime.stackRestore(stack)}));return}Runtime.stackRestore(stack)}return ret};var sourceRegex=/^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}cwrap=function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){funcstr+="var stack = "+JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"=("+convertCode.returnValue+");"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){funcstr+=JSsource["stackRestore"].body.replace("()","(stack)")+";"}funcstr+="return ret})";return eval(funcstr)}}))();function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[typeof _malloc==="function"?_malloc:null,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(typeof _sbrk!=="undefined"&&!_sbrk.called||!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}function UTF8ArrayToString(u8Array,idx){var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}function stringToUTF16(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<2)return 0;maxBytesToWrite-=2;var startPtr=outPtr;var numCharsToWrite=maxBytesToWrite<str.length*2?maxBytesToWrite/2:str.length;for(var i=0;i<numCharsToWrite;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr>>1]=codeUnit;outPtr+=2}HEAP16[outPtr>>1]=0;return outPtr-startPtr}function lengthBytesUTF16(str){return str.length*2}function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}function stringToUTF32(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<4)return 0;var startPtr=outPtr;var endPtr=startPtr+maxBytesToWrite-4;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++i);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr>>2]=codeUnit;outPtr+=4;if(outPtr+4>endPtr)break}HEAP32[outPtr>>2]=0;return outPtr-startPtr}function lengthBytesUTF32(str){var len=0;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343)++i;len+=4}return len}function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}var parsed=func;try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}parsed=parse()}catch(e){parsed+="?"}if(parsed.includes("?")&&!hasLibcxxabi){Runtime.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling")}return parsed}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}var PAGE_SIZE=4096;function alignMemoryPage(x){if(x%4096>0){x+=4096-x%4096}return x}var HEAP;var buffer;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBuffer(buf){Module["buffer"]=buffer=buf}function updateGlobalBufferViews(){Module["HEAP8"]=HEAP8=new Int8Array(buffer);Module["HEAP16"]=HEAP16=new Int16Array(buffer);Module["HEAP32"]=HEAP32=new Int32Array(buffer);Module["HEAPU8"]=HEAPU8=new Uint8Array(buffer);Module["HEAPU16"]=HEAPU16=new Uint16Array(buffer);Module["HEAPU32"]=HEAPU32=new Uint32Array(buffer);Module["HEAPF32"]=HEAPF32=new Float32Array(buffer);Module["HEAPF64"]=HEAPF64=new Float64Array(buffer)}var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which adjusts the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}function enlargeMemory(){abortOnCannotGrowMemory()}var TOTAL_STACK=Module["TOTAL_STACK"]||65536;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||1048576;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");if(Module["buffer"]){buffer=Module["buffer"];assert(buffer.byteLength===TOTAL_MEMORY,"provided buffer should be "+TOTAL_MEMORY+" bytes, but it is "+buffer.byteLength)}else{buffer=new ArrayBuffer(TOTAL_MEMORY)}updateGlobalBufferViews();HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}function addOnInit(cb){__ATINIT__.unshift(cb)}function addOnPreMain(cb){__ATMAIN__.unshift(cb)}function addOnExit(cb){__ATEXIT__.unshift(cb)}function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer++>>0]=array[i]}}function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var Math_clz32=Math.clz32;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var ASM_CONSTS=[];STATIC_BASE=8;STATICTOP=STATIC_BASE+5360;__ATINIT__.push();allocate([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,34,118,101,99,116,111,114,32,108,101,110,103,116,104,95,101,114,114,111,114,34,0,47,109,101,100,105,97,47,97,108,111,110,47,100,54,57,100,100,57,98,50,45,52,55,57,49,45,52,98,56,101,45,97,101,98,51,45,102,54,51,53,51,98,52,53,100,55,49,48,47,104,111,109,101,47,97,108,111,110,47,68,101,118,47,101,109,115,99,114,105,112,116,101,110,47,115,121,115,116,101,109,47,105,110,99,108,117,100,101,47,108,105,98,99,120,120,47,118,101,99,116,111,114,0,95,95,116,104,114,111,119,95,108,101,110,103,116,104,95,101,114,114,111,114,0,32,99,111,110,115,116,0,33,34,98,97,115,105,99,95,115,116,114,105,110,103,32,111,117,116,95,111,102,95,114,97,110,103,101,34,0,47,109,101,100,105,97,47,97,108,111,110,47,100,54,57,100,100,57,98,50,45,52,55,57,49,45,52,98,56,101,45,97,101,98,51,45,102,54,51,53,51,98,52,53,100,55,49,48,47,104,111,109,101,47,97,108,111,110,47,68,101,118,47,101,109,115,99,114,105,112,116,101,110,47,115,121,115,116,101,109,47,105,110,99,108,117,100,101,47,108,105,98,99,120,120,47,115,116,114,105,110,103,0,95,95,116,104,114,111,119,95,111,117,116,95,111,102,95,114,97,110,103,101,0,33,34,98,97,115,105,99,95,115,116,114,105,110,103,32,108,101,110,103,116,104,95,101,114,114,111,114,34,0,32,118,111,108,97,116,105,108,101,0,32,114,101,115,116,114,105,99,116,0,118,111,105,100,0,119,99,104,97,114,95,116,0,98,111,111,108,0,99,104,97,114,0,115,105,103,110,101,100,32,99,104,97,114,0,117,110,115,105,103,110,101,100,32,99,104,97,114,0,115,104,111,114,116,0,117,110,115,105,103,110,101,100,32,115,104,111,114,116,0,105,110,116,0,117,110,115,105,103,110,101,100,32,105,110,116,0,108,111,110,103,0,117,110,115,105,103,110,101,100,32,108,111,110,103,0,108,111,110,103,32,108,111,110,103,0,117,110,115,105,103,110,101,100,32,108,111,110,103,32,108,111,110,103,0,95,95,105,110,116,49,50,56,0,117,110,115,105,103,110,101,100,32,95,95,105,110,116,49,50,56,0,102,108,111,97,116,0,100,111,117,98,108,101,0,108,111,110,103,32,100,111,117,98,108,101,0,95,95,102,108,111,97,116,49,50,56,0,46,46,46,0,95,71,76,79,66,65,76,95,95,78,0,40,97,110,111,110,121,109,111,117,115,32,110,97,109,101,115,112,97,99,101,41,0,100,101,99,105,109,97,108,54,52,0,100,101,99,105,109,97,108,49,50,56,0,100,101,99,105,109,97,108,51,50,0,100,101,99,105,109,97,108,49,54,0,99,104,97,114,51,50,95,116,0,99,104,97,114,49,54,95,116,0,97,117,116,111,0,115,116,100,58,58,110,117,108,108,112,116,114,95,116,0,32,91,0,32,91,93,0,40,0,41,0,102,97,108,115,101,0,116,114,117,101,0,117,0,108,0,117,108,0,108,108,0,117,108,108,0,37,97,102,0,37,97,0,37,76,97,76,0,102,112,0,38,38,0,62,0,41,32,0,32,40,0,38,0,38,61,0,61,0,97,108,105,103,110,111,102,32,40,0,99,111,110,115,116,95,99,97,115,116,60,0,62,40,0,44,0,126,0,41,40,0,58,58,0,100,101,108,101,116,101,91,93,32,0,100,121,110,97,109,105,99,95,99,97,115,116,60,0,100,101,108,101,116,101,32,0,111,112,101,114,97,116,111,114,38,38,0,111,112,101,114,97,116,111,114,38,0,111,112,101,114,97,116,111,114,38,61,0,111,112,101,114,97,116,111,114,61,0,111,112,101,114,97,116,111,114,40,41,0,111,112,101,114,97,116,111,114,44,0,111,112,101,114,97,116,111,114,126,0,111,112,101,114,97,116,111,114,32,0,111,112,101,114,97,116,111,114,32,100,101,108,101,116,101,91,93,0,111,112,101,114,97,116,111,114,42,0,111,112,101,114,97,116,111,114,32,100,101,108,101,116,101,0,111,112,101,114,97,116,111,114,47,0,111,112,101,114,97,116,111,114,47,61,0,111,112,101,114,97,116,111,114,94,0,111,112,101,114,97,116,111,114,94,61,0,111,112,101,114,97,116,111,114,61,61,0,111,112,101,114,97,116,111,114,62,61,0,111,112,101,114,97,116,111,114,62,0,111,112,101,114,97,116,111,114,91,93,0,111,112,101,114,97,116,111,114,60,61,0,111,112,101,114,97,116,111,114,34,34,32,0,111,112,101,114,97,116,111,114,60,60,0,111,112,101,114,97,116,111,114,60,60,61,0,111,112,101,114,97,116,111,114,60,0,111,112,101,114,97,116,111,114,45,0,111,112,101,114,97,116,111,114,45,61,0,111,112,101,114,97,116,111,114,42,61,0,111,112,101,114,97,116,111,114,45,45,0,111,112,101,114,97,116,111,114,32,110,101,119,91,93,0,111,112,101,114,97,116,111,114,33,61,0,111,112,101,114,97,116,111,114,33,0,111,112,101,114,97,116,111,114,32,110,101,119,0,111,112,101,114,97,116,111,114,124,124,0,111,112,101,114,97,116,111,114,124,0,111,112,101,114,97,116,111,114,124,61,0,111,112,101,114,97,116,111,114,45,62,42,0,111,112,101,114,97,116,111,114,43,0,111,112,101,114,97,116,111,114,43,61,0,111,112,101,114,97,116,111,114,43,43,0,111,112,101,114,97,116,111,114,45,62,0,111,112,101,114,97,116,111,114,63,0,111,112,101,114,97,116,111,114,37,0,111,112,101,114,97,116,111,114,37,61,0,111,112,101,114,97,116,111,114,62,62,0,111,112,101,114,97,116,111,114,62,62,61,0,60,0,44,32,0,32,62,0,100,101,99,108,116,121,112,101,40,0,115,116,100,58,58,97,108,108,111,99,97,116,111,114,0,115,116,100,58,58,98,97,115,105,99,95,115,116,114,105,110,103,0,115,116,100,58,58,115,116,114,105,110,103,0,115,116,100,58,58,105,115,116,114,101,97,109,0,115,116,100,58,58,111,115,116,114,101,97,109,0,115,116,100,58,58,105,111,115,116,114,101,97,109,0,115,116,100,58,58,98,97,115,105,99,95,115,116,114,105,110,103,60,99,104,97,114,44,32,115,116,100,58,58,99,104,97,114,95,116,114,97,105,116,115,60,99,104,97,114,62,44,32,115,116,100,58,58,97,108,108,111,99,97,116,111,114,60,99,104,97,114,62,32,62,0,98,97,115,105,99,95,115,116,114,105,110,103,0,115,116,100,58,58,98,97,115,105,99,95,105,115,116,114,101,97,109,60,99,104,97,114,44,32,115,116,100,58,58,99,104,97,114,95,116,114,97,105,116,115,60,99,104,97,114,62,32,62,0,98,97,115,105,99,95,105,115,116,114,101,97,109,0,115,116,100,58,58,98,97,115,105,99,95,111,115,116,114,101,97,109,60,99,104,97,114,44,32,115,116,100,58,58,99,104,97,114,95,116,114,97,105,116,115,60,99,104,97,114,62,32,62,0,98,97,115,105,99,95,111,115,116,114,101,97,109,0,115,116,100,58,58,98,97,115,105,99,95,105,111,115,116,114,101,97,109,60,99,104,97,114,44,32,115,116,100,58,58,99,104,97,114,95,116,114,97,105,116,115,60,99,104,97,114,62,32,62,0,98,97,115,105,99,95,105,111,115,116,114,101,97,109,0,39,117,110,110,97,109,101,100,0,39,108,97,109,98,100,97,39,40,0,115,116,100,58,58,0,46,42,0,47,61,0,94,0,94,61,0,61,61,0,62,61,0,41,91,0,60,61,0,60,60,0,60,60,61,0,45,0,45,61,0,42,61,0,45,45,0,41,45,45,0,91,93,32,0,32,0,33,61,0,33,0,110,111,101,120,99,101,112,116,32,40,0,124,124,0,124,0,124,61,0,45,62,42,0,43,0,43,61,0,43,43,0,41,43,43,0,45,62,0,41,32,63,32,40,0,41,32,58,32,40,0,114,101,105,110,116,101,114,112,114,101,116,95,99,97,115,116,60,0,37,0,37,61,0,62,62,0,62,62,61,0,115,116,97,116,105,99,95,99,97,115,116,60,0,115,105,122,101,111,102,32,40,0,115,105,122,101,111,102,46,46,46,40,0,116,121,112,101,105,100,40,0,116,104,114,111,119,0,116,104,114,111,119,32,0,32,99,111,109,112,108,101,120,0,32,38,0,32,38,38,0,32,105,109,97,103,105,110,97,114,121,0,58,58,42,0,111,98,106,99,95,111,98,106,101,99,116,60,0,105,100,0,111,98,106,99,112,114,111,116,111,0,115,116,100,0,58,58,115,116,114,105,110,103,32,108,105,116,101,114,97,108,0,32,118,101,99,116,111,114,91,0,112,105,120,101,108,32,118,101,99,116,111,114,91,0,118,116,97,98,108,101,32,102,111,114,32,0,86,84,84,32,102,111,114,32,0,116,121,112,101,105,110,102,111,32,102,111,114,32,0,116,121,112,101,105,110,102,111,32,110,97,109,101,32,102,111,114,32,0,99,111,118,97,114,105,97,110,116,32,114,101,116,117,114,110,32,116,104,117,110,107,32,116,111,32,0,99,111,110,115,116,114,117,99,116,105,111,110,32,118,116,97,98,108,101,32,102,111,114,32,0,45,105,110,45,0,118,105,114,116,117,97,108,32,116,104,117,110,107,32,116,111,32,0,110,111,110,45,118,105,114,116,117,97,108,32,116,104,117,110,107,32,116,111,32,0,103,117,97,114,100,32,118,97,114,105,97,98,108,101,32,102,111,114,32,0,114,101,102,101,114,101,110,99,101,32,116,101,109,112,111,114,97,114,121,32,102,111,114,32,0,95,98,108,111,99,107,95,105,110,118,111,107,101,0,105,110,118,111,99,97,116,105,111,110,32,102,117,110,99,116,105,111,110,32,102,111,114,32,98,108,111,99,107,32,105,110,32,0,47,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,42,0,93,0,17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,46,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}Module["_memset"]=_memset;Module["_i64Subtract"]=_i64Subtract;function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 85:return totalMemory/PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}var _BDtoIHigh=true;var _BDtoILow=true;Module["_bitshift64Lshr"]=_bitshift64Lshr;var _BItoD=true;Module["_bitshift64Shl"]=_bitshift64Shl;function _abort(){Module["abort"]()}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;Module["_i64Add"]=_i64Add;function ___assert_fail(condition,filename,line,func){ABORT=true;throw"Assertion failed: "+Pointer_stringify(condition)+", at: "+[filename?Pointer_stringify(filename):"unknown filename",line,func?Pointer_stringify(func):"unknown function"]+" at "+stackTrace()}function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0){var success=self.alloc(bytes);if(!success)return-1>>>0}return ret}Module["_memmove"]=_memmove;function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0){if(info.destructor){Runtime.dynCall("vi",info.destructor,[ptr])}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(asm["setTempRet0"](0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(asm["setTempRet0"](0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(asm["setTempRet0"](typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(asm["setTempRet0"](throwntype),thrown)|0}function ___gxx_personality_v0(){}function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}function _pthread_self(){return 0}STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"invoke_iiii":invoke_iiii,"_sysconf":_sysconf,"_pthread_self":_pthread_self,"_abort":_abort,"___setErrNo":___setErrNo,"_sbrk":_sbrk,"_time":_time,"_emscripten_memcpy_big":_emscripten_memcpy_big,"___gxx_personality_v0":___gxx_personality_v0,"___resumeException":___resumeException,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"___assert_fail":___assert_fail,"___cxa_find_matching_catch":___cxa_find_matching_catch,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=0;var o=0;var p=0;var q=0;var r=global.NaN,s=global.Infinity;var t=0,u=0,v=0,w=0,x=0.0,y=0,z=0,A=0,B=0.0;var C=0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=global.Math.floor;var N=global.Math.abs;var O=global.Math.sqrt;var P=global.Math.pow;var Q=global.Math.cos;var R=global.Math.sin;var S=global.Math.tan;var T=global.Math.acos;var U=global.Math.asin;var V=global.Math.atan;var W=global.Math.atan2;var X=global.Math.exp;var Y=global.Math.log;var Z=global.Math.ceil;var _=global.Math.imul;var $=global.Math.min;var aa=global.Math.clz32;var ba=env.abort;var ca=env.assert;var da=env.invoke_iiii;var ea=env._sysconf;var fa=env._pthread_self;var ga=env._abort;var ha=env.___setErrNo;var ia=env._sbrk;var ja=env._time;var ka=env._emscripten_memcpy_big;var la=env.___gxx_personality_v0;var ma=env.___resumeException;var na=env.__ZSt18uncaught_exceptionv;var oa=env.___assert_fail;var pa=env.___cxa_find_matching_catch;var qa=0.0;
// EMSCRIPTEN_START_FUNCS
function ub(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ka=0,La=0,Ma=0,Oa=0,Qa=0,Ra=0,Sa=0,Ua=0,Va=0,Wa=0,Xa=0,_a=0,eb=0,fb=0,gb=0,hb=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,sb=0,tb=0,wb=0,yb=0,zb=0,Ab=0,Bb=0,Ib=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Vb=0,Wb=0,Xb=0,Yb=0,Zb=0,_b=0,$b=0,ac=0,bc=0,cc=0,dc=0,ec=0,fc=0;fc=i;i=i+1104|0;dc=fc+1072|0;ec=fc+1048|0;cc=fc+1032|0;bc=fc+1020|0;$b=fc+1008|0;_b=fc+984|0;ac=fc+972|0;Sb=fc+596|0;Tb=fc+572|0;Xb=fc+548|0;Wb=fc+524|0;Yb=fc+488|0;Zb=fc+460|0;f=fc+960|0;k=fc+948|0;n=fc+936|0;r=fc+924|0;u=fc+912|0;w=fc+900|0;x=fc+888|0;Ib=fc+876|0;Kb=fc+864|0;Lb=fc+852|0;Mb=fc+840|0;y=fc+828|0;Nb=fc+816|0;Ob=fc+804|0;Pb=fc+792|0;Qb=fc+780|0;B=fc+768|0;C=fc+756|0;D=fc+744|0;F=fc+732|0;G=fc+720|0;H=fc+708|0;I=fc+696|0;fb=fc+672|0;gb=fc+656|0;hb=fc+644|0;jb=fc+632|0;kb=fc+620|0;J=fc+608|0;K=fc+584|0;L=fc+560|0;M=fc+536|0;N=fc+512|0;O=fc+472|0;P=fc+448|0;Q=fc+436|0;na=fc+424|0;Ga=fc+400|0;Ha=fc+384|0;Ka=fc+372|0;La=fc+360|0;R=fc+348|0;S=fc+336|0;T=fc+324|0;U=fc+312|0;V=fc+300|0;W=fc+288|0;X=fc+276|0;_=fc+264|0;$=fc+252|0;oa=fc+240|0;Ma=fc+216|0;Oa=fc+204|0;Qa=fc+192|0;Ra=fc+180|0;aa=fc+168|0;sb=fc+144|0;tb=fc+132|0;wb=fc+120|0;yb=fc+108|0;zb=fc+96|0;Ab=fc+84|0;Bb=fc+72|0;da=fc+60|0;fa=fc+48|0;ha=fc+36|0;ia=fc+24|0;Sa=fc;lb=d;ja=lb-b|0;a:do if((ja|0)>1){ka=(ja|0)>3;if(ka?(a[b>>0]|0)==103:0){la=(a[b+1>>0]|0)==115;Ua=la;la=la?b+2|0:b}else{Ua=0;la=b}do switch(a[la>>0]|0){case 76:{b=vb(b,d,e)|0;break a}case 84:{b=Eb(b,d,e)|0;break a}case 102:{b=Fb(b,d,e)|0;break a}case 97:switch(a[la+1>>0]|0){case 97:{dc=b+2|0;$a(f,841,2);ec=Gb(dc,d,f,e)|0;Ja(f);b=(ec|0)==(dc|0)?b:ec;break a}case 100:{dc=b+2|0;$a(k,852,1);ec=Hb(dc,d,k,e)|0;Ja(k);b=(ec|0)==(dc|0)?b:ec;break a}case 110:{dc=b+2|0;$a(n,852,1);ec=Gb(dc,d,n,e)|0;Ja(n);b=(ec|0)==(dc|0)?b:ec;break a}case 78:{dc=b+2|0;$a(r,854,2);ec=Gb(dc,d,r,e)|0;Ja(r);b=(ec|0)==(dc|0)?b:ec;break a}case 83:{dc=b+2|0;$a(u,857,1);ec=Gb(dc,d,u,e)|0;Ja(u);b=(ec|0)==(dc|0)?b:ec;break a}case 116:{if(((((ja|0)>2?(a[b>>0]|0)==97:0)?(a[b+1>>0]|0)==116:0)?(bc=b+2|0,nb=Na(bc,d,e)|0,(nb|0)!=(bc|0)):0)?(Da=c[e+4>>2]|0,(c[e>>2]|0)!=(Da|0)):0){o=Da+-24|0;Cb(cc,o);b=Ta(cc,0,859)|0;c[ec>>2]=c[b>>2];c[ec+4>>2]=c[b+4>>2];c[ec+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(ec,799)|0;c[dc>>2]=c[b>>2];c[dc+4>>2]=c[b+4>>2];c[dc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}do if(a[o>>0]&1){n=Da+-16|0;a[c[n>>2]>>0]=0;k=Da+-20|0;c[k>>2]=0;b=a[o>>0]|0;if(!(b&1))j=10;else{j=c[o>>2]|0;b=j&255;j=(j&-2)+-1|0}if(!(b&1)){f=(b&255)>>>1;if((b&255)<22){h=10;m=1;l=f}else{h=(f+16&240)+-1|0;m=1;l=f}}else{h=10;m=0;l=0}if((h|0)!=(j|0)){if((h|0)==10){g=o+1|0;f=c[n>>2]|0;if(m){Fc(g|0,f|0,((b&255)>>>1)+1|0)|0;wc(f)}else{a[g>>0]=a[f>>0]|0;wc(f)}a[o>>0]=l<<1;break}f=h+1|0;g=vc(f)|0;if(!(h>>>0<=j>>>0&(g|0)==0)){if(m)Fc(g|0,o+1|0,((b&255)>>>1)+1|0)|0;else{bc=c[n>>2]|0;a[g>>0]=a[bc>>0]|0;wc(bc)}c[o>>2]=f|1;c[k>>2]=l;c[n>>2]=g}}}else{a[o+1>>0]=0;a[o>>0]=0}while(0);c[o>>2]=c[dc>>2];c[o+4>>2]=c[dc+4>>2];c[o+8>>2]=c[dc+8>>2];b=0;while(1){if((b|0)==3)break;c[dc+(b<<2)>>2]=0;b=b+1|0}Ja(dc);Ja(ec);Ja(cc);b=nb}break a}case 122:{if(((((ja|0)>2?(a[b>>0]|0)==97:0)?(a[b+1>>0]|0)==122:0)?(bc=b+2|0,ob=ub(bc,d,e)|0,(ob|0)!=(bc|0)):0)?(Ea=c[e+4>>2]|0,(c[e>>2]|0)!=(Ea|0)):0){o=Ea+-24|0;Cb(cc,o);b=Ta(cc,0,859)|0;c[ec>>2]=c[b>>2];c[ec+4>>2]=c[b+4>>2];c[ec+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(ec,799)|0;c[dc>>2]=c[b>>2];c[dc+4>>2]=c[b+4>>2];c[dc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}do if(a[o>>0]&1){n=Ea+-16|0;a[c[n>>2]>>0]=0;k=Ea+-20|0;c[k>>2]=0;b=a[o>>0]|0;if(!(b&1))j=10;else{j=c[o>>2]|0;b=j&255;j=(j&-2)+-1|0}if(!(b&1)){f=(b&255)>>>1;if((b&255)<22){m=1;h=10;l=f}else{m=1;h=(f+16&240)+-1|0;l=f}}else{m=0;h=10;l=0}if((h|0)!=(j|0)){if((h|0)==10){g=o+1|0;f=c[n>>2]|0;if(m){Fc(g|0,f|0,((b&255)>>>1)+1|0)|0;wc(f)}else{a[g>>0]=a[f>>0]|0;wc(f)}a[o>>0]=l<<1;break}f=h+1|0;g=vc(f)|0;if(!(h>>>0<=j>>>0&(g|0)==0)){if(m)Fc(g|0,o+1|0,((b&255)>>>1)+1|0)|0;else{bc=c[n>>2]|0;a[g>>0]=a[bc>>0]|0;wc(bc)}c[o>>2]=f|1;c[k>>2]=l;c[n>>2]=g}}}else{a[o+1>>0]=0;a[o>>0]=0}while(0);c[o>>2]=c[dc>>2];c[o+4>>2]=c[dc+4>>2];c[o+8>>2]=c[dc+8>>2];b=0;while(1){if((b|0)==3)break;c[dc+(b<<2)>>2]=0;b=b+1|0}Ja(dc);Ja(ec);Ja(cc);b=ob}break a}default:break a}case 99:switch(a[la+1>>0]|0){case 99:{if((((((ja|0)>2?(a[b>>0]|0)==99:0)?(a[b+1>>0]|0)==99:0)?(Zb=b+2|0,z=Na(Zb,d,e)|0,(z|0)!=(Zb|0)):0)?(Xa=ub(z,d,e)|0,(Xa|0)!=(z|0)):0)?(ua=e+4|0,A=c[ua>>2]|0,((A-(c[e>>2]|0)|0)/24|0)>>>0>=2):0){Cb(dc,A+-24|0);b=c[ua>>2]|0;f=b+-24|0;g=b;while(1){if((g|0)==(f|0))break;e=g+-24|0;c[ua>>2]=e;Ia(e);g=c[ua>>2]|0}g=b+-48|0;Cb(ac,g);b=Ta(ac,0,869)|0;c[_b>>2]=c[b>>2];c[_b+4>>2]=c[b+4>>2];c[_b+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(_b,881)|0;c[$b>>2]=c[b>>2];c[$b+4>>2]=c[b+4>>2];c[$b+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=a[dc>>0]|0;f=(b&1)==0;b=Za($b,f?dc+1|0:c[dc+8>>2]|0,f?(b&255)>>>1:c[dc+4>>2]|0)|0;c[bc>>2]=c[b>>2];c[bc+4>>2]=c[b+4>>2];c[bc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(bc,799)|0;c[cc>>2]=c[b>>2];c[cc+4>>2]=c[b+4>>2];c[cc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(ec,cc);Db(g,ec);Ia(ec);Ja(cc);Ja(bc);Ja($b);Ja(_b);Ja(ac);Ja(dc);b=Xa}break a}case 108:{b:do if((((ka?(a[b>>0]|0)==99:0)?(a[b+1>>0]|0)==108:0)?(cc=b+2|0,pb=ub(cc,d,e)|0,!((pb|0)==(cc|0)|(pb|0)==(d|0))):0)?(Rb=e+4|0,E=c[Rb>>2]|0,(c[e>>2]|0)!=(E|0)):0){cc=E+-12|0;g=a[cc>>0]|0;f=(g&1)==0;Za(E+-24|0,f?cc+1|0:c[E+-4>>2]|0,f?(g&255)>>>1:c[E+-8>>2]|0)|0;g=c[Rb>>2]|0;f=0;while(1){if((f|0)==3)break;c[dc+(f<<2)>>2]=0;f=f+1|0}p=g+-12|0;do if(a[p>>0]&1){o=g+-4|0;a[c[o>>2]>>0]=0;l=g+-8|0;c[l>>2]=0;f=a[p>>0]|0;if(!(f&1))k=10;else{k=c[p>>2]|0;f=k&255;k=(k&-2)+-1|0}if(!(f&1)){g=(f&255)>>>1;if((f&255)<22){n=1;j=10;m=g}else{n=1;j=(g+16&240)+-1|0;m=g}}else{n=0;j=10;m=0}if((j|0)!=(k|0)){if((j|0)==10){h=p+1|0;g=c[o>>2]|0;if(n){Fc(h|0,g|0,((f&255)>>>1)+1|0)|0;wc(g)}else{a[h>>0]=a[g>>0]|0;wc(g)}a[p>>0]=m<<1;break}g=j+1|0;h=vc(g)|0;if(!(j>>>0<=k>>>0&(h|0)==0)){if(n)Fc(h|0,p+1|0,((f&255)>>>1)+1|0)|0;else{cc=c[o>>2]|0;a[h>>0]=a[cc>>0]|0;wc(cc)}c[p>>2]=g|1;c[l>>2]=m;c[o>>2]=h}}}else{a[p+1>>0]=0;a[p>>0]=0}while(0);c[p>>2]=c[dc>>2];c[p+4>>2]=c[dc+4>>2];c[p+8>>2]=c[dc+8>>2];f=0;while(1){if((f|0)==3)break;c[dc+(f<<2)>>2]=0;f=f+1|0}Ja(dc);Ya((c[Rb>>2]|0)+-24|0,797)|0;l=ec+4|0;m=ec+8|0;n=ec+1|0;g=pb;while(1){if((a[g>>0]|0)==69)break;k=ub(g,d,e)|0;if((k|0)==(g|0)|(k|0)==(d|0))break b;f=c[Rb>>2]|0;if((c[e>>2]|0)==(f|0))break b;Cb(ec,f+-24|0);h=c[Rb>>2]|0;j=h+-24|0;f=h;while(1){if((f|0)==(j|0))break;dc=f+-24|0;c[Rb>>2]=dc;Ia(dc);f=c[Rb>>2]|0}g=a[ec>>0]|0;f=(g&1)==0;g=f?(g&255)>>>1:c[l>>2]|0;if(g){if((c[e>>2]|0)==(j|0)){Vb=147;break}Za(h+-48|0,f?n:c[m>>2]|0,g)|0}Ja(ec);g=k}if((Vb|0)==147){Ja(ec);break}f=c[Rb>>2]|0;if((c[e>>2]|0)!=(f|0)){Ya(f+-24|0,799)|0;b=g+1|0}}while(0);break a}case 109:{dc=b+2|0;$a(w,884,1);ec=Gb(dc,d,w,e)|0;Ja(w);b=(ec|0)==(dc|0)?b:ec;break a}case 111:{dc=b+2|0;$a(x,886,1);ec=Hb(dc,d,x,e)|0;Ja(x);b=(ec|0)==(dc|0)?b:ec;break a}case 118:{c:do if((((ja|0)>2?(a[b>>0]|0)==99:0)?(a[b+1>>0]|0)==118:0)?(Yb=e+63|0,Xb=a[Yb>>0]|0,a[Yb>>0]=0,Zb=b+2|0,ma=Na(Zb,d,e)|0,a[Yb>>0]=Xb,!((ma|0)==(Zb|0)|(ma|0)==(d|0))):0){if((a[ma>>0]|0)!=95){f=ub(ma,d,e)|0;if((f|0)==(ma|0))break}else{f=ma+1|0;if((f|0)==(d|0))break;g=a[f>>0]|0;d:do if(g<<24>>24==69){j=e+4|0;h=c[j>>2]|0;Zb=c[e+8>>2]|0;k=Zb;if(h>>>0<Zb>>>0){c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[h+20>>2]=0;g=0;while(1){if((g|0)==3)break;c[h+(g<<2)>>2]=0;g=g+1|0}g=h+12|0;h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}c[j>>2]=(c[j>>2]|0)+24;break}g=c[e>>2]|0;Zb=h-g|0;j=(Zb|0)/24|0;h=j+1|0;if((Zb|0)<-24)Pa();g=(k-g|0)/24|0;if(g>>>0<1073741823){g=g<<1;g=g>>>0<h>>>0?h:g}else g=2147483647;ab(dc,g,j,e+12|0);j=dc+8|0;k=c[j>>2]|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;g=0;while(1){if((g|0)==3)break;c[k+(g<<2)>>2]=0;g=g+1|0}g=k+12|0;h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}c[j>>2]=k+24;cb(e,dc);bb(dc)}else while(1){if(g<<24>>24==69)break d;h=ub(f,d,e)|0;if((h|0)==(f|0)|(h|0)==(d|0))break c;g=a[h>>0]|0;f=h}while(0);f=f+1|0}j=e+4|0;g=c[j>>2]|0;if(((g-(c[e>>2]|0)|0)/24|0)>>>0>=2){Cb(dc,g+-24|0);b=c[j>>2]|0;g=b+-24|0;h=b;while(1){if((h|0)==(g|0))break;e=h+-24|0;c[j>>2]=e;Ia(e);h=c[j>>2]|0}h=b+-48|0;Cb(ac,h);b=Ta(ac,0,797)|0;c[_b>>2]=c[b>>2];c[_b+4>>2]=c[b+4>>2];c[_b+8>>2]=c[b+8>>2];g=0;while(1){if((g|0)==3)break;c[b+(g<<2)>>2]=0;g=g+1|0}b=Ya(_b,888)|0;c[$b>>2]=c[b>>2];c[$b+4>>2]=c[b+4>>2];c[$b+8>>2]=c[b+8>>2];g=0;while(1){if((g|0)==3)break;c[b+(g<<2)>>2]=0;g=g+1|0}b=a[dc>>0]|0;g=(b&1)==0;b=Za($b,g?dc+1|0:c[dc+8>>2]|0,g?(b&255)>>>1:c[dc+4>>2]|0)|0;c[bc>>2]=c[b>>2];c[bc+4>>2]=c[b+4>>2];c[bc+8>>2]=c[b+8>>2];g=0;while(1){if((g|0)==3)break;c[b+(g<<2)>>2]=0;g=g+1|0}b=Ya(bc,799)|0;c[cc>>2]=c[b>>2];c[cc+4>>2]=c[b+4>>2];c[cc+8>>2]=c[b+8>>2];g=0;while(1){if((g|0)==3)break;c[b+(g<<2)>>2]=0;g=g+1|0}rb(ec,cc);Db(h,ec);Ia(ec);Ja(cc);Ja(bc);Ja($b);Ja(_b);Ja(ac);Ja(dc);b=f}}while(0);break a}default:break a}case 100:switch(a[la+1>>0]|0){case 97:{ec=la+2|0;p=ub(ec,d,e)|0;if((p|0)==(ec|0))break a;g=e+4|0;h=c[g>>2]|0;if((c[e>>2]|0)==(h|0))break a;o=h+-24|0;e:do if(Ua)$a(Lb,891,2);else{b=0;while(1){if((b|0)==3)break e;c[Lb+(b<<2)>>2]=0;b=b+1|0}}while(0);b=Ya(Lb,894)|0;c[Kb>>2]=c[b>>2];c[Kb+4>>2]=c[b+4>>2];c[Kb+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}Cb(Mb,(c[g>>2]|0)+-24|0);b=a[Mb>>0]|0;f=(b&1)==0;b=Za(Kb,f?Mb+1|0:c[Mb+8>>2]|0,f?(b&255)>>>1:c[Mb+4>>2]|0)|0;c[Ib>>2]=c[b>>2];c[Ib+4>>2]=c[b+4>>2];c[Ib+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}do if(a[o>>0]&1){n=h+-16|0;a[c[n>>2]>>0]=0;k=h+-20|0;c[k>>2]=0;b=a[o>>0]|0;if(!(b&1))j=10;else{j=c[o>>2]|0;b=j&255;j=(j&-2)+-1|0}if(!(b&1)){f=(b&255)>>>1;if((b&255)<22){m=1;h=10;l=f}else{m=1;h=(f+16&240)+-1|0;l=f}}else{m=0;h=10;l=0}if((h|0)!=(j|0)){if((h|0)==10){g=o+1|0;f=c[n>>2]|0;if(m){Fc(g|0,f|0,((b&255)>>>1)+1|0)|0;wc(f)}else{a[g>>0]=a[f>>0]|0;wc(f)}a[o>>0]=l<<1;break}f=h+1|0;g=vc(f)|0;if(!(h>>>0<=j>>>0&(g|0)==0)){if(m)Fc(g|0,o+1|0,((b&255)>>>1)+1|0)|0;else{ec=c[n>>2]|0;a[g>>0]=a[ec>>0]|0;wc(ec)}c[o>>2]=f|1;c[k>>2]=l;c[n>>2]=g}}}else{a[o+1>>0]=0;a[o>>0]=0}while(0);c[o>>2]=c[Ib>>2];c[o+4>>2]=c[Ib+4>>2];c[o+8>>2]=c[Ib+8>>2];b=0;while(1){if((b|0)==3)break;c[Ib+(b<<2)>>2]=0;b=b+1|0}Ja(Ib);Ja(Mb);Ja(Kb);Ja(Lb);b=p;break a}case 99:{if((((((ja|0)>2?(a[b>>0]|0)==100:0)?(a[b+1>>0]|0)==99:0)?(Zb=b+2|0,Y=Na(Zb,d,e)|0,(Y|0)!=(Zb|0)):0)?(_a=ub(Y,d,e)|0,(_a|0)!=(Y|0)):0)?(va=e+4|0,Z=c[va>>2]|0,((Z-(c[e>>2]|0)|0)/24|0)>>>0>=2):0){Cb(dc,Z+-24|0);b=c[va>>2]|0;f=b+-24|0;g=b;while(1){if((g|0)==(f|0))break;e=g+-24|0;c[va>>2]=e;Ia(e);g=c[va>>2]|0}g=b+-48|0;Cb(ac,g);b=Ta(ac,0,904)|0;c[_b>>2]=c[b>>2];c[_b+4>>2]=c[b+4>>2];c[_b+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(_b,881)|0;c[$b>>2]=c[b>>2];c[$b+4>>2]=c[b+4>>2];c[$b+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=a[dc>>0]|0;f=(b&1)==0;b=Za($b,f?dc+1|0:c[dc+8>>2]|0,f?(b&255)>>>1:c[dc+4>>2]|0)|0;c[bc>>2]=c[b>>2];c[bc+4>>2]=c[b+4>>2];c[bc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(bc,799)|0;c[cc>>2]=c[b>>2];c[cc+4>>2]=c[b+4>>2];c[cc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(ec,cc);Db(g,ec);Ia(ec);Ja(cc);Ja(bc);Ja($b);Ja(_b);Ja(ac);Ja(dc);b=_a}break a}case 101:{dc=b+2|0;$a(y,4262,1);ec=Hb(dc,d,y,e)|0;Ja(y);b=(ec|0)==(dc|0)?b:ec;break a}case 108:{ec=la+2|0;p=ub(ec,d,e)|0;if((p|0)==(ec|0))break a;g=e+4|0;h=c[g>>2]|0;if((c[e>>2]|0)==(h|0))break a;o=h+-24|0;f:do if(Ua)$a(Pb,891,2);else{b=0;while(1){if((b|0)==3)break f;c[Pb+(b<<2)>>2]=0;b=b+1|0}}while(0);b=Ya(Pb,918)|0;c[Ob>>2]=c[b>>2];c[Ob+4>>2]=c[b+4>>2];c[Ob+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}Cb(Qb,(c[g>>2]|0)+-24|0);b=a[Qb>>0]|0;f=(b&1)==0;b=Za(Ob,f?Qb+1|0:c[Qb+8>>2]|0,f?(b&255)>>>1:c[Qb+4>>2]|0)|0;c[Nb>>2]=c[b>>2];c[Nb+4>>2]=c[b+4>>2];c[Nb+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}do if(a[o>>0]&1){n=h+-16|0;a[c[n>>2]>>0]=0;k=h+-20|0;c[k>>2]=0;b=a[o>>0]|0;if(!(b&1))j=10;else{j=c[o>>2]|0;b=j&255;j=(j&-2)+-1|0}if(!(b&1)){f=(b&255)>>>1;if((b&255)<22){m=1;h=10;l=f}else{m=1;h=(f+16&240)+-1|0;l=f}}else{m=0;h=10;l=0}if((h|0)!=(j|0)){if((h|0)==10){g=o+1|0;f=c[n>>2]|0;if(m){Fc(g|0,f|0,((b&255)>>>1)+1|0)|0;wc(f)}else{a[g>>0]=a[f>>0]|0;wc(f)}a[o>>0]=l<<1;break}f=h+1|0;g=vc(f)|0;if(!(h>>>0<=j>>>0&(g|0)==0)){if(m)Fc(g|0,o+1|0,((b&255)>>>1)+1|0)|0;else{ec=c[n>>2]|0;a[g>>0]=a[ec>>0]|0;wc(ec)}c[o>>2]=f|1;c[k>>2]=l;c[n>>2]=g}}}else{a[o+1>>0]=0;a[o>>0]=0}while(0);c[o>>2]=c[Nb>>2];c[o+4>>2]=c[Nb+4>>2];c[o+8>>2]=c[Nb+8>>2];b=0;while(1){if((b|0)==3)break;c[Nb+(b<<2)>>2]=0;b=b+1|0}Ja(Nb);Ja(Qb);Ja(Ob);Ja(Pb);b=p;break a}case 110:{b=Jb(b,d,e)|0;break a}case 115:{if((((((ja|0)>2?(a[b>>0]|0)==100:0)?(a[b+1>>0]|0)==115:0)?(cc=b+2|0,ba=ub(cc,d,e)|0,(ba|0)!=(cc|0)):0)?(wa=ub(ba,d,e)|0,(wa|0)!=(ba|0)):0)?(xa=e+4|0,ca=c[xa>>2]|0,((ca-(c[e>>2]|0)|0)/24|0)>>>0>=2):0){Cb(dc,ca+-24|0);b=c[xa>>2]|0;f=b+-24|0;g=b;while(1){if((g|0)==(f|0))break;cc=g+-24|0;c[xa>>2]=cc;Ia(cc);g=c[xa>>2]|0}xb(ec,1833,dc);cc=a[ec>>0]|0;bc=(cc&1)==0;Za(b+-48|0,bc?ec+1|0:c[ec+8>>2]|0,bc?(cc&255)>>>1:c[ec+4>>2]|0)|0;Ja(ec);Ja(dc);b=wa}break a}case 116:{if((((((ja|0)>2?(a[b>>0]|0)==100:0)?(a[b+1>>0]|0)==116:0)?(cc=b+2|0,ea=ub(cc,d,e)|0,(ea|0)!=(cc|0)):0)?(ya=Jb(ea,d,e)|0,(ya|0)!=(ea|0)):0)?(za=e+4|0,ga=c[za>>2]|0,((ga-(c[e>>2]|0)|0)/24|0)>>>0>=2):0){Cb(dc,ga+-24|0);b=c[za>>2]|0;f=b+-24|0;g=b;while(1){if((g|0)==(f|0))break;cc=g+-24|0;c[za>>2]=cc;Ia(cc);g=c[za>>2]|0}xb(ec,4798,dc);cc=a[ec>>0]|0;bc=(cc&1)==0;Za(b+-48|0,bc?ec+1|0:c[ec+8>>2]|0,bc?(cc&255)>>>1:c[ec+4>>2]|0)|0;Ja(ec);Ja(dc);b=ya}break a}case 118:{dc=b+2|0;$a(B,2368,1);ec=Gb(dc,d,B,e)|0;Ja(B);b=(ec|0)==(dc|0)?b:ec;break a}case 86:{dc=b+2|0;$a(C,1836,2);ec=Gb(dc,d,C,e)|0;Ja(C);b=(ec|0)==(dc|0)?b:ec;break a}default:break a}case 101:switch(a[la+1>>0]|0){case 111:{dc=b+2|0;$a(D,1839,1);ec=Gb(dc,d,D,e)|0;Ja(D);b=(ec|0)==(dc|0)?b:ec;break a}case 79:{dc=b+2|0;$a(F,1841,2);ec=Gb(dc,d,F,e)|0;Ja(F);b=(ec|0)==(dc|0)?b:ec;break a}case 113:{dc=b+2|0;$a(G,1844,2);ec=Gb(dc,d,G,e)|0;Ja(G);b=(ec|0)==(dc|0)?b:ec;break a}default:break a}case 103:switch(a[la+1>>0]|0){case 101:{dc=b+2|0;$a(H,1847,2);ec=Gb(dc,d,H,e)|0;Ja(H);b=(ec|0)==(dc|0)?b:ec;break a}case 116:{dc=b+2|0;$a(I,844,1);ec=Gb(dc,d,I,e)|0;Ja(I);b=(ec|0)==(dc|0)?b:ec;break a}default:break a}case 105:{if((a[la+1>>0]|0)!=120)break a;cc=b+2|0;f=ub(cc,d,e)|0;if((f|0)==(cc|0))break a;j=ub(f,d,e)|0;h=e+4|0;if((j|0)==(f|0)){g=c[h>>2]|0;f=g+-24|0;while(1){if((g|0)==(f|0))break a;ec=g+-24|0;c[h>>2]=ec;Ia(ec);g=c[h>>2]|0}}f=c[h>>2]|0;if(((f-(c[e>>2]|0)|0)/24|0)>>>0<2)break a;Cb(dc,f+-24|0);b=c[h>>2]|0;f=b+-24|0;g=b;while(1){if((g|0)==(f|0))break;cc=g+-24|0;c[h>>2]=cc;Ia(cc);g=c[h>>2]|0}Cb(ec,b+-48|0);g=(c[h>>2]|0)+-24|0;xb(kb,797,ec);b=Ya(kb,1850)|0;c[jb>>2]=c[b>>2];c[jb+4>>2]=c[b+4>>2];c[jb+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=a[dc>>0]|0;f=(b&1)==0;b=Za(jb,f?dc+1|0:c[dc+8>>2]|0,f?(b&255)>>>1:c[dc+4>>2]|0)|0;c[hb>>2]=c[b>>2];c[hb+4>>2]=c[b+4>>2];c[hb+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(hb,4264)|0;c[gb>>2]=c[b>>2];c[gb+4>>2]=c[b+4>>2];c[gb+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(fb,gb);Db(g,fb);Ia(fb);Ja(gb);Ja(hb);Ja(jb);Ja(kb);Ja(ec);Ja(dc);b=j;break a}case 108:switch(a[la+1>>0]|0){case 101:{dc=b+2|0;$a(J,1853,2);ec=Gb(dc,d,J,e)|0;Ja(J);b=(ec|0)==(dc|0)?b:ec;break a}case 115:{dc=b+2|0;$a(K,1856,2);ec=Gb(dc,d,K,e)|0;Ja(K);b=(ec|0)==(dc|0)?b:ec;break a}case 83:{dc=b+2|0;$a(L,1859,3);ec=Gb(dc,d,L,e)|0;Ja(L);b=(ec|0)==(dc|0)?b:ec;break a}case 116:{dc=b+2|0;$a(M,1427,1);ec=Gb(dc,d,M,e)|0;Ja(M);b=(ec|0)==(dc|0)?b:ec;break a}default:break a}case 109:switch(a[la+1>>0]|0){case 105:{dc=b+2|0;$a(N,1863,1);ec=Gb(dc,d,N,e)|0;Ja(N);b=(ec|0)==(dc|0)?b:ec;break a}case 73:{dc=b+2|0;$a(O,1865,2);ec=Gb(dc,d,O,e)|0;Ja(O);b=(ec|0)==(dc|0)?b:ec;break a}case 108:{dc=b+2|0;$a(P,4262,1);ec=Gb(dc,d,P,e)|0;Ja(P);b=(ec|0)==(dc|0)?b:ec;break a}case 76:{dc=b+2|0;$a(Q,1868,2);ec=Gb(dc,d,Q,e)|0;Ja(Q);b=(ec|0)==(dc|0)?b:ec;break a}case 109:{f=b+2|0;if((f|0)!=(d|0)?(a[f>>0]|0)==95:0){dc=b+3|0;$a(na,1871,2);ec=Hb(dc,d,na,e)|0;Ja(na);b=(ec|0)==(dc|0)?b:ec;break a}h=ub(f,d,e)|0;if((h|0)==(f|0))break a;f=c[e+4>>2]|0;if((c[e>>2]|0)==(f|0))break a;g=f+-24|0;Cb(La,g);b=Ta(La,0,797)|0;c[Ka>>2]=c[b>>2];c[Ka+4>>2]=c[b+4>>2];c[Ka+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(Ka,1874)|0;c[Ha>>2]=c[b>>2];c[Ha+4>>2]=c[b+4>>2];c[Ha+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(Ga,Ha);Db(g,Ga);Ia(Ga);Ja(Ha);Ja(Ka);Ja(La);b=h;break a}default:break a}case 110:switch(a[la+1>>0]|0){case 119:case 97:{g:do if(ka){f=a[b>>0]|0;if(f<<24>>24==103){s=(a[b+1>>0]|0)==115;g=s?b+2|0:b;f=a[g>>0]|0}else{s=0;g=b}if(f<<24>>24==110){f=a[g+1>>0]|0;switch(f<<24>>24){case 97:case 119:break;default:break g}q=f<<24>>24==97;f=g+2|0;h:do if((f|0)!=(d|0)){p=0;while(1){if((a[f>>0]|0)==95)break;h=ub(f,d,e)|0;f=(h|0)==(f|0);g=(h|0)==(d|0);if(f|g)break h;else{p=p|(f|g)^1;f=h}}Rb=f+1|0;g=Na(Rb,d,e)|0;if(!((g|0)==(Rb|0)|(g|0)==(d|0))){f=a[g>>0]|0;i:do if(!((lb-g|0)>2&f<<24>>24==112))if(f<<24>>24==69){o=0;r=g}else break h;else{if((a[g+1>>0]|0)!=105)break h;f=g+2|0;while(1){if((a[f>>0]|0)==69){o=1;r=f;break i}Rb=f;f=ub(f,d,e)|0;if((f|0)==(Rb|0)|(f|0)==(d|0))break h}}while(0);f=0;while(1){if((f|0)==3)break;c[ec+(f<<2)>>2]=0;f=f+1|0}j:do if(o){n=e+4|0;f=c[n>>2]|0;if((c[e>>2]|0)==(f|0)){g=b;f=1}else{Cb(cc,f+-24|0);k:do if(!(a[ec>>0]&1)){a[ec+1>>0]=0;a[ec>>0]=0}else{k=ec+8|0;g=c[k>>2]|0;a[g>>0]=0;l=ec+4|0;c[l>>2]=0;f=c[ec>>2]|0;m=(f&-2)+-1|0;h=f&255;do if(!(h&1)){f=f>>>1&127;if((h&255)<22){Fc(ec+1|0,g|0,f+1|0)|0;wc(g);break}g=f+16&240;j=g+-1|0;if((j|0)==(m|0))break k;h=vc(g)|0;if(j>>>0<=m>>>0&(h|0)==0)break k;Fc(h|0,ec+1|0,f+1|0)|0;c[ec>>2]=g|1;c[l>>2]=f;c[k>>2]=h;break k}else{a[ec+1>>0]=0;wc(g);f=0}while(0);a[ec>>0]=f<<1}while(0);c[ec>>2]=c[cc>>2];c[ec+4>>2]=c[cc+4>>2];c[ec+8>>2]=c[cc+8>>2];f=0;while(1){if((f|0)==3)break;c[cc+(f<<2)>>2]=0;f=f+1|0}Ja(cc);f=c[n>>2]|0;g=f+-24|0;while(1){if((f|0)==(g|0)){j=e;f=g;Vb=409;break j}cc=f+-24|0;c[n>>2]=cc;Ia(cc);f=c[n>>2]|0}}}else{f=e+4|0;n=f;j=e;f=c[f>>2]|0;Vb=409}while(0);if((Vb|0)==409)if((c[j>>2]|0)==(f|0)){g=b;f=1}else{Cb(bc,f+-24|0);g=c[n>>2]|0;h=g+-24|0;f=g;while(1){if((f|0)==(h|0))break;cc=f+-24|0;c[n>>2]=cc;Ia(cc);f=c[n>>2]|0}f=0;while(1){if((f|0)==3)break;c[$b+(f<<2)>>2]=0;f=f+1|0}l:do if(p)if((c[j>>2]|0)==(h|0)){g=b;f=1}else{Cb(_b,g+-48|0);m:do if(!(a[$b>>0]&1)){a[$b+1>>0]=0;a[$b>>0]=0}else{k=$b+8|0;g=c[k>>2]|0;a[g>>0]=0;l=$b+4|0;c[l>>2]=0;f=c[$b>>2]|0;m=(f&-2)+-1|0;h=f&255;do if(!(h&1)){f=f>>>1&127;if((h&255)<22){Fc($b+1|0,g|0,f+1|0)|0;wc(g);break}g=f+16&240;j=g+-1|0;if((j|0)==(m|0))break m;h=vc(g)|0;if(j>>>0<=m>>>0&(h|0)==0)break m;Fc(h|0,$b+1|0,f+1|0)|0;c[$b>>2]=g|1;c[l>>2]=f;c[k>>2]=h;break m}else{a[$b+1>>0]=0;wc(g);f=0}while(0);a[$b>>0]=f<<1}while(0);c[$b>>2]=c[_b>>2];c[$b+4>>2]=c[_b+4>>2];c[$b+8>>2]=c[_b+8>>2];f=0;while(1){if((f|0)==3)break;c[_b+(f<<2)>>2]=0;f=f+1|0}Ja(_b);g=c[n>>2]|0;f=g+-24|0;while(1){if((g|0)==(f|0)){Vb=434;break l}cc=g+-24|0;c[n>>2]=cc;Ia(cc);g=c[n>>2]|0}}else Vb=434;while(0);if((Vb|0)==434){f=0;while(1){if((f|0)==3)break;c[ac+(f<<2)>>2]=0;f=f+1|0}if(s)Ub(ac,891,2);if(q)Ya(ac,1878)|0;else Ya(ac,1882)|0;if(p){xb(Tb,797,$b);f=Ya(Tb,846)|0;c[Sb>>2]=c[f>>2];c[Sb+4>>2]=c[f+4>>2];c[Sb+8>>2]=c[f+8>>2];g=0;while(1){if((g|0)==3)break;c[f+(g<<2)>>2]=0;g=g+1|0}cc=a[Sb>>0]|0;_b=(cc&1)==0;Za(ac,_b?Sb+1|0:c[Sb+8>>2]|0,_b?(cc&255)>>>1:c[Sb+4>>2]|0)|0;Ja(Sb);Ja(Tb)}cc=a[bc>>0]|0;_b=(cc&1)==0;Za(ac,_b?bc+1|0:c[bc+8>>2]|0,_b?(cc&255)>>>1:c[bc+4>>2]|0)|0;if(o){xb(Wb,849,ec);f=Ya(Wb,799)|0;c[Xb>>2]=c[f>>2];c[Xb+4>>2]=c[f+4>>2];c[Xb+8>>2]=c[f+8>>2];g=0;while(1){if((g|0)==3)break;c[f+(g<<2)>>2]=0;g=g+1|0}cc=a[Xb>>0]|0;_b=(cc&1)==0;Za(ac,_b?Xb+1|0:c[Xb+8>>2]|0,_b?(cc&255)>>>1:c[Xb+4>>2]|0)|0;Ja(Xb);Ja(Wb)};c[Zb>>2]=c[ac>>2];c[Zb+4>>2]=c[ac+4>>2];c[Zb+8>>2]=c[ac+8>>2];f=0;while(1){if((f|0)==3)break;c[ac+(f<<2)>>2]=0;f=f+1|0}rb(Yb,Zb);f=c[n>>2]|0;cc=c[e+8>>2]|0;j=cc;if(f>>>0<cc>>>0){db(f,Yb);c[n>>2]=(c[n>>2]|0)+24}else{g=c[e>>2]|0;cc=f-g|0;k=(cc|0)/24|0;h=k+1|0;if((cc|0)<-24)Pa();f=(j-g|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<h>>>0?h:f}else f=2147483647;ab(dc,f,k,e+12|0);cc=dc+8|0;_b=c[cc>>2]|0;db(_b,Yb);c[cc>>2]=_b+24;cb(e,dc);bb(dc)}Ia(Yb);Ja(Zb);Ja(ac);g=r+1|0;f=0}Ja($b);Ja(bc)}Ja(ec);if(!f){b=g;break g}}}while(0)}}while(0);break a}case 101:{dc=b+2|0;$a(R,1884,2);ec=Gb(dc,d,R,e)|0;Ja(R);b=(ec|0)==(dc|0)?b:ec;break a}case 103:{dc=b+2|0;$a(S,1863,1);ec=Hb(dc,d,S,e)|0;Ja(S);b=(ec|0)==(dc|0)?b:ec;break a}case 116:{dc=b+2|0;$a(T,1887,1);ec=Hb(dc,d,T,e)|0;Ja(T);b=(ec|0)==(dc|0)?b:ec;break a}case 120:{r=b+2|0;f=ub(r,d,e)|0;if((f|0)!=(r|0)?(Fa=c[e+4>>2]|0,(c[e>>2]|0)!=(Fa|0)):0){q=Fa+-24|0;Cb(cc,q);g=Ta(cc,0,1889)|0;c[ec>>2]=c[g>>2];c[ec+4>>2]=c[g+4>>2];c[ec+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}g=Ya(ec,799)|0;c[dc>>2]=c[g>>2];c[dc+4>>2]=c[g+4>>2];c[dc+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}do if(a[q>>0]&1){p=Fa+-16|0;a[c[p>>2]>>0]=0;m=Fa+-20|0;c[m>>2]=0;g=a[q>>0]|0;if(!(g&1))l=10;else{l=c[q>>2]|0;g=l&255;l=(l&-2)+-1|0}if(!(g&1)){h=(g&255)>>>1;if((g&255)<22){k=10;n=h;o=1}else{k=(h+16&240)+-1|0;n=h;o=1}}else{k=10;n=0;o=0}if((k|0)!=(l|0)){if((k|0)==10){j=q+1|0;h=c[p>>2]|0;if(o){Fc(j|0,h|0,((g&255)>>>1)+1|0)|0;wc(h)}else{a[j>>0]=a[h>>0]|0;wc(h)}a[q>>0]=n<<1;break}h=k+1|0;j=vc(h)|0;if(!(k>>>0<=l>>>0&(j|0)==0)){if(o)Fc(j|0,q+1|0,((g&255)>>>1)+1|0)|0;else{bc=c[p>>2]|0;a[j>>0]=a[bc>>0]|0;wc(bc)}c[q>>2]=h|1;c[m>>2]=n;c[p>>2]=j}}}else{a[q+1>>0]=0;a[q>>0]=0}while(0);c[q>>2]=c[dc>>2];c[q+4>>2]=c[dc+4>>2];c[q+8>>2]=c[dc+8>>2];g=0;while(1){if((g|0)==3)break;c[dc+(g<<2)>>2]=0;g=g+1|0}Ja(dc);Ja(ec);Ja(cc)}else f=r;b=(f|0)==(r|0)?b:f;break a}default:break a}case 111:switch(a[la+1>>0]|0){case 110:{b=Jb(b,d,e)|0;break a}case 111:{dc=b+2|0;$a(U,1900,2);ec=Gb(dc,d,U,e)|0;Ja(U);b=(ec|0)==(dc|0)?b:ec;break a}case 114:{dc=b+2|0;$a(V,1903,1);ec=Gb(dc,d,V,e)|0;Ja(V);b=(ec|0)==(dc|0)?b:ec;break a}case 82:{dc=b+2|0;$a(W,1905,2);ec=Gb(dc,d,W,e)|0;Ja(W);b=(ec|0)==(dc|0)?b:ec;break a}default:break a}case 112:switch(a[la+1>>0]|0){case 109:{dc=b+2|0;$a(X,1908,3);ec=Gb(dc,d,X,e)|0;Ja(X);b=(ec|0)==(dc|0)?b:ec;break a}case 108:{dc=b+2|0;$a(_,1912,1);ec=Gb(dc,d,_,e)|0;Ja(_);b=(ec|0)==(dc|0)?b:ec;break a}case 76:{dc=b+2|0;$a($,1914,2);ec=Gb(dc,d,$,e)|0;Ja($);b=(ec|0)==(dc|0)?b:ec;break a}case 112:{f=b+2|0;if((f|0)!=(d|0)?(a[f>>0]|0)==95:0){dc=b+3|0;$a(oa,1917,2);ec=Hb(dc,d,oa,e)|0;Ja(oa);b=(ec|0)==(dc|0)?b:ec;break a}h=ub(f,d,e)|0;if((h|0)==(f|0))break a;f=c[e+4>>2]|0;if((c[e>>2]|0)==(f|0))break a;g=f+-24|0;Cb(Ra,g);b=Ta(Ra,0,797)|0;c[Qa>>2]=c[b>>2];c[Qa+4>>2]=c[b+4>>2];c[Qa+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(Qa,1920)|0;c[Oa>>2]=c[b>>2];c[Oa+4>>2]=c[b+4>>2];c[Oa+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(Ma,Oa);Db(g,Ma);Ia(Ma);Ja(Oa);Ja(Qa);Ja(Ra);b=h;break a}case 115:{dc=b+2|0;$a(aa,1912,1);ec=Hb(dc,d,aa,e)|0;Ja(aa);b=(ec|0)==(dc|0)?b:ec;break a}case 116:{if((ja|0)<=2)break a;if((a[b>>0]|0)!=112)break a;if((a[b+1>>0]|0)!=116)break a;ec=b+2|0;f=ub(ec,d,e)|0;if((f|0)==(ec|0))break a;j=ub(f,d,e)|0;if((j|0)==(f|0))break a;h=e+4|0;f=c[h>>2]|0;if(((f-(c[e>>2]|0)|0)/24|0)>>>0<2)break a;Cb(dc,f+-24|0);b=c[h>>2]|0;f=b+-24|0;g=b;while(1){if((g|0)==(f|0))break;ec=g+-24|0;c[h>>2]=ec;Ia(ec);g=c[h>>2]|0}Ya(b+-48|0,1924)|0;b=a[dc>>0]|0;ec=(b&1)==0;Za((c[h>>2]|0)+-24|0,ec?dc+1|0:c[dc+8>>2]|0,ec?(b&255)>>>1:c[dc+4>>2]|0)|0;Ja(dc);b=j;break a}default:break a}case 113:{if((a[la+1>>0]|0)!=117)break a;bc=b+2|0;f=ub(bc,d,e)|0;if((f|0)==(bc|0))break a;g=ub(f,d,e)|0;if((g|0)==(f|0)){f=e+4|0;h=c[f>>2]|0;g=h+-24|0;while(1){if((h|0)==(g|0))break a;ec=h+-24|0;c[f>>2]=ec;Ia(ec);h=c[f>>2]|0}}h=ub(g,d,e)|0;j=e+4|0;if((h|0)==(g|0)){g=c[j>>2]|0;f=g+-24|0;h=g;while(1){if((h|0)==(f|0))break;ec=h+-24|0;c[j>>2]=ec;Ia(ec);h=c[j>>2]|0}g=g+-48|0;while(1){if((f|0)==(g|0))break a;ec=f+-24|0;c[j>>2]=ec;Ia(ec);f=c[j>>2]|0}}f=c[j>>2]|0;if(((f-(c[e>>2]|0)|0)/24|0)>>>0<3)break a;Cb(dc,f+-24|0);b=c[j>>2]|0;f=b+-24|0;g=b;while(1){if((g|0)==(f|0))break;bc=g+-24|0;c[j>>2]=bc;Ia(bc);g=c[j>>2]|0}Cb(ec,b+-48|0);b=c[j>>2]|0;f=b+-24|0;g=b;while(1){if((g|0)==(f|0))break;bc=g+-24|0;c[j>>2]=bc;Ia(bc);g=c[j>>2]|0}Cb(cc,b+-48|0);g=(c[j>>2]|0)+-24|0;xb(Bb,797,cc);b=Ya(Bb,1927)|0;c[Ab>>2]=c[b>>2];c[Ab+4>>2]=c[b+4>>2];c[Ab+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=a[ec>>0]|0;f=(b&1)==0;b=Za(Ab,f?ec+1|0:c[ec+8>>2]|0,f?(b&255)>>>1:c[ec+4>>2]|0)|0;c[zb>>2]=c[b>>2];c[zb+4>>2]=c[b+4>>2];c[zb+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(zb,1933)|0;c[yb>>2]=c[b>>2];c[yb+4>>2]=c[b+4>>2];c[yb+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=a[dc>>0]|0;f=(b&1)==0;b=Za(yb,f?dc+1|0:c[dc+8>>2]|0,f?(b&255)>>>1:c[dc+4>>2]|0)|0;c[wb>>2]=c[b>>2];c[wb+4>>2]=c[b+4>>2];c[wb+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(wb,799)|0;c[tb>>2]=c[b>>2];c[tb+4>>2]=c[b+4>>2];c[tb+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(sb,tb);Db(g,sb);Ia(sb);Ja(tb);Ja(wb);Ja(yb);Ja(zb);Ja(Ab);Ja(Bb);Ja(cc);Ja(ec);Ja(dc);b=h;break a}case 114:switch(a[la+1>>0]|0){case 99:{if((((((ja|0)>2?(a[b>>0]|0)==114:0)?(a[b+1>>0]|0)==99:0)?(Zb=b+2|0,h=Na(Zb,d,e)|0,(h|0)!=(Zb|0)):0)?(Va=ub(h,d,e)|0,(Va|0)!=(h|0)):0)?(pa=e+4|0,j=c[pa>>2]|0,((j-(c[e>>2]|0)|0)/24|0)>>>0>=2):0){Cb(dc,j+-24|0);b=c[pa>>2]|0;f=b+-24|0;g=b;while(1){if((g|0)==(f|0))break;e=g+-24|0;c[pa>>2]=e;Ia(e);g=c[pa>>2]|0}g=b+-48|0;Cb(ac,g);b=Ta(ac,0,1939)|0;c[_b>>2]=c[b>>2];c[_b+4>>2]=c[b+4>>2];c[_b+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(_b,881)|0;c[$b>>2]=c[b>>2];c[$b+4>>2]=c[b+4>>2];c[$b+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=a[dc>>0]|0;f=(b&1)==0;b=Za($b,f?dc+1|0:c[dc+8>>2]|0,f?(b&255)>>>1:c[dc+4>>2]|0)|0;c[bc>>2]=c[b>>2];c[bc+4>>2]=c[b+4>>2];c[bc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(bc,799)|0;c[cc>>2]=c[b>>2];c[cc+4>>2]=c[b+4>>2];c[cc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(ec,cc);Db(g,ec);Ia(ec);Ja(cc);Ja(bc);Ja($b);Ja(_b);Ja(ac);Ja(dc);b=Va}break a}case 109:{dc=b+2|0;$a(da,1957,1);ec=Gb(dc,d,da,e)|0;Ja(da);b=(ec|0)==(dc|0)?b:ec;break a}case 77:{dc=b+2|0;$a(fa,1959,2);ec=Gb(dc,d,fa,e)|0;Ja(fa);b=(ec|0)==(dc|0)?b:ec;break a}case 115:{dc=b+2|0;$a(ha,1962,2);ec=Gb(dc,d,ha,e)|0;Ja(ha);b=(ec|0)==(dc|0)?b:ec;break a}case 83:{dc=b+2|0;$a(ia,1965,3);ec=Gb(dc,d,ia,e)|0;Ja(ia);b=(ec|0)==(dc|0)?b:ec;break a}default:break a}case 115:switch(a[la+1>>0]|0){case 99:{if((((((ja|0)>2?(a[b>>0]|0)==115:0)?(a[b+1>>0]|0)==99:0)?(Zb=b+2|0,l=Na(Zb,d,e)|0,(l|0)!=(Zb|0)):0)?(Wa=ub(l,d,e)|0,(Wa|0)!=(l|0)):0)?(qa=e+4|0,m=c[qa>>2]|0,((m-(c[e>>2]|0)|0)/24|0)>>>0>=2):0){Cb(dc,m+-24|0);b=c[qa>>2]|0;f=b+-24|0;g=b;while(1){if((g|0)==(f|0))break;e=g+-24|0;c[qa>>2]=e;Ia(e);g=c[qa>>2]|0}g=b+-48|0;Cb(ac,g);b=Ta(ac,0,1969)|0;c[_b>>2]=c[b>>2];c[_b+4>>2]=c[b+4>>2];c[_b+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(_b,881)|0;c[$b>>2]=c[b>>2];c[$b+4>>2]=c[b+4>>2];c[$b+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=a[dc>>0]|0;f=(b&1)==0;b=Za($b,f?dc+1|0:c[dc+8>>2]|0,f?(b&255)>>>1:c[dc+4>>2]|0)|0;c[bc>>2]=c[b>>2];c[bc+4>>2]=c[b+4>>2];c[bc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(bc,799)|0;c[cc>>2]=c[b>>2];c[cc+4>>2]=c[b+4>>2];c[cc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(ec,cc);Db(g,ec);Ia(ec);Ja(cc);Ja(bc);Ja($b);Ja(_b);Ja(ac);Ja(dc);b=Wa}break a}case 112:{if((ja|0)<=2)break a;if((a[b>>0]|0)!=115)break a;if((a[b+1>>0]|0)!=112)break a;dc=b+2|0;ec=ub(dc,d,e)|0;b=(ec|0)==(dc|0)?b:ec;break a}case 114:{b=Jb(b,d,e)|0;break a}case 116:{if(((((ja|0)>2?(a[b>>0]|0)==115:0)?(a[b+1>>0]|0)==116:0)?(ac=b+2|0,Aa=Na(ac,d,e)|0,(Aa|0)!=(ac|0)):0)?(o=c[e+4>>2]|0,(c[e>>2]|0)!=(o|0)):0){g=o+-24|0;Cb(bc,g);b=Ta(bc,0,1982)|0;c[cc>>2]=c[b>>2];c[cc+4>>2]=c[b+4>>2];c[cc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(cc,799)|0;c[ec>>2]=c[b>>2];c[ec+4>>2]=c[b+4>>2];c[ec+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(dc,ec);Db(g,dc);Ia(dc);Ja(ec);Ja(cc);Ja(bc);b=Aa}break a}case 122:{if(((((ja|0)>2?(a[b>>0]|0)==115:0)?(a[b+1>>0]|0)==122:0)?(ac=b+2|0,Ba=ub(ac,d,e)|0,(Ba|0)!=(ac|0)):0)?(p=c[e+4>>2]|0,(c[e>>2]|0)!=(p|0)):0){g=p+-24|0;Cb(bc,g);b=Ta(bc,0,1982)|0;c[cc>>2]=c[b>>2];c[cc+4>>2]=c[b+4>>2];c[cc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(cc,799)|0;c[ec>>2]=c[b>>2];c[ec+4>>2]=c[b+4>>2];c[ec+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(dc,ec);Db(g,dc);Ia(dc);Ja(ec);Ja(cc);Ja(bc);b=Ba}break a}case 90:{if((lb-la|0)<=2)break a;switch(a[la+2>>0]|0){case 84:break;case 102:{if((((((ja|0)>2?(a[b>>0]|0)==115:0)?(a[b+1>>0]|0)==90:0)?(s=b+2|0,(a[s>>0]|0)==102):0)?(Ca=Fb(s,d,e)|0,(Ca|0)!=(s|0)):0)?(t=c[e+4>>2]|0,(c[e>>2]|0)!=(t|0)):0){g=t+-24|0;Cb(bc,g);b=Ta(bc,0,1991)|0;c[cc>>2]=c[b>>2];c[cc+4>>2]=c[b+4>>2];c[cc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(cc,799)|0;c[ec>>2]=c[b>>2];c[ec+4>>2]=c[b+4>>2];c[ec+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(dc,ec);Db(g,dc);Ia(dc);Ja(ec);Ja(cc);Ja(bc);b=Ca}break a}default:break a}if(((((ja|0)>2?(a[b>>0]|0)==115:0)?(a[b+1>>0]|0)==90:0)?(q=b+2|0,(a[q>>0]|0)==84):0)?(mb=e+4|0,eb=((c[mb>>2]|0)-(c[e>>2]|0)|0)/24|0,qb=Eb(q,d,e)|0,ra=c[e>>2]|0,g=((c[mb>>2]|0)-ra|0)/24|0,ra,(qb|0)!=(q|0)):0){a[ec>>0]=20;b=ec+1|0;f=1991;h=b+10|0;do{a[b>>0]=a[f>>0]|0;b=b+1|0;f=f+1|0}while((b|0)<(h|0));a[ec+11>>0]=0;n:do if((eb|0)!=(g|0)){Cb(cc,ra+(eb*24|0)|0);j=a[cc>>0]|0;k=(j&1)==0;Za(ec,k?cc+1|0:c[cc+8>>2]|0,k?(j&255)>>>1:c[cc+4>>2]|0)|0;Ja(cc);j=bc+8|0;k=bc+1|0;l=bc+4|0;b=eb;while(1){b=b+1|0;if((b|0)==(g|0))break n;Cb($b,(c[e>>2]|0)+(b*24|0)|0);f=Ta($b,0,1429)|0;c[bc>>2]=c[f>>2];c[bc+4>>2]=c[f+4>>2];c[bc+8>>2]=c[f+8>>2];h=0;while(1){if((h|0)==3)break;c[f+(h<<2)>>2]=0;h=h+1|0}cc=a[bc>>0]|0;Zb=(cc&1)==0;Za(ec,Zb?k:c[j>>2]|0,Zb?(cc&255)>>>1:c[l>>2]|0)|0;Ja(bc);Ja($b)}}while(0);Ya(ec,799)|0;while(1){if((g|0)==(eb|0))break;f=c[mb>>2]|0;b=f+-24|0;while(1){if((f|0)==(b|0))break;cc=f+-24|0;c[mb>>2]=cc;Ia(cc);f=c[mb>>2]|0}g=g+-1|0}c[ac>>2]=c[ec>>2];c[ac+4>>2]=c[ec+4>>2];c[ac+8>>2]=c[ec+8>>2];b=0;while(1){if((b|0)==3)break;c[ec+(b<<2)>>2]=0;b=b+1|0}rb(_b,ac);b=c[mb>>2]|0;cc=c[e+8>>2]|0;h=cc;if(b>>>0<cc>>>0){db(b,_b);c[mb>>2]=(c[mb>>2]|0)+24}else{f=c[e>>2]|0;cc=b-f|0;j=(cc|0)/24|0;g=j+1|0;if((cc|0)<-24)Pa();b=(h-f|0)/24|0;if(b>>>0<1073741823){b=b<<1;b=b>>>0<g>>>0?g:b}else b=2147483647;ab(dc,b,j,e+12|0);cc=dc+8|0;bc=c[cc>>2]|0;db(bc,_b);c[cc>>2]=bc+24;cb(e,dc);bb(dc)}Ia(_b);Ja(ac);Ja(ec);b=qb}break a}default:break a}case 116:switch(a[la+1>>0]|0){case 105:case 101:{o:do if((ja|0)>2?(a[b>>0]|0)==116:0){f=a[b+1>>0]|0;switch(f<<24>>24){case 105:case 101:break;default:break o}g=b+2|0;if(f<<24>>24==101)h=ub(g,d,e)|0;else h=Na(g,d,e)|0;if((h|0)!=(g|0)?(sa=c[e+4>>2]|0,(c[e>>2]|0)!=(sa|0)):0){g=sa+-24|0;Cb(bc,g);b=Ta(bc,0,2002)|0;c[cc>>2]=c[b>>2];c[cc+4>>2]=c[b+4>>2];c[cc+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(cc,799)|0;c[ec>>2]=c[b>>2];c[ec+4>>2]=c[b+4>>2];c[ec+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(dc,ec);Db(g,dc);Ia(dc);Ja(ec);Ja(cc);Ja(bc);b=h}}while(0);break a}case 114:{ib(Sa,2010);f=e+4|0;g=c[f>>2]|0;ec=c[e+8>>2]|0;h=ec;if(g>>>0<ec>>>0){db(g,Sa);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;ec=g-f|0;j=(ec|0)/24|0;g=j+1|0;if((ec|0)<-24)Pa();f=(h-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<g>>>0?g:f}else f=2147483647;ab(dc,f,j,e+12|0);ec=dc+8|0;cc=c[ec>>2]|0;db(cc,Sa);c[ec>>2]=cc+24;cb(e,dc);bb(dc)}Ia(Sa);b=b+2|0;break a}case 119:{if(((((ja|0)>2?(a[b>>0]|0)==116:0)?(a[b+1>>0]|0)==119:0)?(bc=b+2|0,ta=ub(bc,d,e)|0,(ta|0)!=(bc|0)):0)?(v=c[e+4>>2]|0,(c[e>>2]|0)!=(v|0)):0){b=v+-24|0;Cb(cc,b);f=Ta(cc,0,2016)|0;c[ec>>2]=c[f>>2];c[ec+4>>2]=c[f+4>>2];c[ec+8>>2]=c[f+8>>2];g=0;while(1){if((g|0)==3)break;c[f+(g<<2)>>2]=0;g=g+1|0}rb(dc,ec);Db(b,dc);Ia(dc);Ja(ec);Ja(cc);b=ta}break a}default:break a}case 57:case 56:case 55:case 54:case 53:case 52:case 51:case 50:case 49:{b=Jb(b,d,e)|0;break a}default:break a}while(0)}while(0);i=fc;return b|0}function vb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;O=i;i=i+480|0;J=O+72|0;I=O+48|0;H=O+24|0;L=O;K=O+432|0;M=O+408|0;N=O+384|0;r=O+396|0;y=O+360|0;z=O+336|0;s=O+320|0;t=O+308|0;u=O+296|0;v=O+284|0;f=O+272|0;j=O+260|0;k=O+248|0;l=O+236|0;m=O+224|0;n=O+212|0;o=O+200|0;p=O+188|0;q=O+176|0;A=O+152|0;B=O+140|0;C=O+128|0;D=O+116|0;E=O+104|0;F=O+92|0;x=d;a:do if((x-b|0)>3?(a[b>>0]|0)==76:0){w=b+1|0;do switch(a[w>>0]|0){case 84:break a;case 119:{N=b+2|0;$a(r,481,7);e=wb(N,d,r,e)|0;Ja(r);b=(e|0)==(N|0)?b:e;break a}case 98:{if((a[b+3>>0]|0)!=69)break a;switch(a[b+2>>0]|0){case 48:{ib(y,801);f=e+4|0;j=c[f>>2]|0;N=c[e+8>>2]|0;k=N;if(j>>>0<N>>>0){db(j,y);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;N=j-f|0;l=(N|0)/24|0;j=l+1|0;if((N|0)<-24)Pa();f=(k-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<j>>>0?j:f}else f=2147483647;ab(L,f,l,e+12|0);N=L+8|0;M=c[N>>2]|0;db(M,y);c[N>>2]=M+24;cb(e,L);bb(L)}Ia(y);b=b+4|0;break a}case 49:{fb(z,807);f=e+4|0;j=c[f>>2]|0;N=c[e+8>>2]|0;k=N;if(j>>>0<N>>>0){db(j,z);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;N=j-f|0;l=(N|0)/24|0;j=l+1|0;if((N|0)<-24)Pa();f=(k-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<j>>>0?j:f}else f=2147483647;ab(L,f,l,e+12|0);N=L+8|0;M=c[N>>2]|0;db(M,z);c[N>>2]=M+24;cb(e,L);bb(L)}Ia(z);b=b+4|0;break a}default:break a}}case 99:{N=b+2|0;$a(s,494,4);e=wb(N,d,s,e)|0;Ja(s);b=(e|0)==(N|0)?b:e;break a}case 97:{N=b+2|0;$a(t,499,11);e=wb(N,d,t,e)|0;Ja(t);b=(e|0)==(N|0)?b:e;break a}case 104:{N=b+2|0;$a(u,511,13);e=wb(N,d,u,e)|0;Ja(u);b=(e|0)==(N|0)?b:e;break a}case 115:{N=b+2|0;$a(v,525,5);e=wb(N,d,v,e)|0;Ja(v);b=(e|0)==(N|0)?b:e;break a}case 116:{N=b+2|0;$a(f,531,14);e=wb(N,d,f,e)|0;Ja(f);b=(e|0)==(N|0)?b:e;break a}case 105:{N=b+2|0;$a(j,5344,0);e=wb(N,d,j,e)|0;Ja(j);b=(e|0)==(N|0)?b:e;break a}case 106:{N=b+2|0;$a(k,812,1);e=wb(N,d,k,e)|0;Ja(k);b=(e|0)==(N|0)?b:e;break a}case 108:{N=b+2|0;$a(l,814,1);e=wb(N,d,l,e)|0;Ja(l);b=(e|0)==(N|0)?b:e;break a}case 109:{N=b+2|0;$a(m,816,2);e=wb(N,d,m,e)|0;Ja(m);b=(e|0)==(N|0)?b:e;break a}case 120:{N=b+2|0;$a(n,819,2);e=wb(N,d,n,e)|0;Ja(n);b=(e|0)==(N|0)?b:e;break a}case 121:{N=b+2|0;$a(o,822,3);e=wb(N,d,o,e)|0;Ja(o);b=(e|0)==(N|0)?b:e;break a}case 110:{N=b+2|0;$a(p,611,8);e=wb(N,d,p,e)|0;Ja(p);b=(e|0)==(N|0)?b:e;break a}case 111:{N=b+2|0;$a(q,620,17);e=wb(N,d,q,e)|0;Ja(q);b=(e|0)==(N|0)?b:e;break a}case 102:{m=b+2|0;b:do if((x-m|0)>>>0>8){k=b+10|0;f=L;l=m;while(1){j=a[l>>0]|0;if((l|0)==(k|0)){G=41;break}j=j<<24>>24;if(!(fc(j)|0))break;J=a[l+1>>0]|0;a[f>>0]=(((J<<24>>24)+-48|0)>>>0<10?208:169)+(J&255)+(((j+-48|0)>>>0<10?0:9)+j<<4);f=f+1|0;l=l+2|0}do if((G|0)==41){if(j<<24>>24==69){c:do if((L|0)!=(f|0)){j=L;while(1){f=f+-1|0;if(j>>>0>=f>>>0)break c;J=a[j>>0]|0;a[j>>0]=a[f>>0]|0;a[f>>0]=J;j=j+1|0}}while(0);f=K;j=f+24|0;do{a[f>>0]=0;f=f+1|0}while((f|0)<(j|0));h[H>>3]=+g[L>>2];f=jc(K,24,826,H)|0;if(f>>>0>23)break;$a(N,K,f);rb(M,N);f=e+4|0;j=c[f>>2]|0;L=c[e+8>>2]|0;k=L;if(j>>>0<L>>>0){db(j,M);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=j-f|0;l=(L|0)/24|0;j=l+1|0;if((L|0)<-24)Pa();f=(k-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<j>>>0?j:f}else f=2147483647;ab(H,f,l,e+12|0);L=H+8|0;K=c[L>>2]|0;db(K,M);c[L>>2]=K+24;cb(e,H);bb(H)}Ia(M);Ja(N);f=b+11|0}else f=m;break b}while(0);f=m}else f=m;while(0);b=(f|0)==(m|0)?b:f;break a}case 100:{m=b+2|0;d:do if((x-m|0)>>>0>16){k=b+18|0;f=L;l=m;while(1){j=a[l>>0]|0;if((l|0)==(k|0)){G=63;break}j=j<<24>>24;if(!(fc(j)|0))break;J=a[l+1>>0]|0;a[f>>0]=(((J<<24>>24)+-48|0)>>>0<10?208:169)+(J&255)+(((j+-48|0)>>>0<10?0:9)+j<<4);f=f+1|0;l=l+2|0}do if((G|0)==63){if(j<<24>>24==69){e:do if((L|0)!=(f|0)){j=L;while(1){f=f+-1|0;if(j>>>0>=f>>>0)break e;J=a[j>>0]|0;a[j>>0]=a[f>>0]|0;a[f>>0]=J;j=j+1|0}}while(0);f=K;j=f+32|0;do{a[f>>0]=0;f=f+1|0}while((f|0)<(j|0));h[I>>3]=+h[L>>3];f=jc(K,32,830,I)|0;if(f>>>0>31)break;$a(N,K,f);rb(M,N);f=e+4|0;j=c[f>>2]|0;L=c[e+8>>2]|0;k=L;if(j>>>0<L>>>0){db(j,M);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=j-f|0;l=(L|0)/24|0;j=l+1|0;if((L|0)<-24)Pa();f=(k-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<j>>>0?j:f}else f=2147483647;ab(I,f,l,e+12|0);L=I+8|0;K=c[L>>2]|0;db(K,M);c[L>>2]=K+24;cb(e,I);bb(I)}Ia(M);Ja(N);f=b+19|0}else f=m;break d}while(0);f=m}else f=m;while(0);b=(f|0)==(m|0)?b:f;break a}case 101:{m=b+2|0;f:do if((x-m|0)>>>0>20){k=b+22|0;f=L;l=m;while(1){j=a[l>>0]|0;if((l|0)==(k|0)){G=85;break}j=j<<24>>24;if(!(fc(j)|0))break;I=a[l+1>>0]|0;a[f>>0]=(((I<<24>>24)+-48|0)>>>0<10?208:169)+(I&255)+(((j+-48|0)>>>0<10?0:9)+j<<4);f=f+1|0;l=l+2|0}do if((G|0)==85){if(j<<24>>24==69){g:do if((L|0)!=(f|0)){j=L;while(1){f=f+-1|0;if(j>>>0>=f>>>0)break g;I=a[j>>0]|0;a[j>>0]=a[f>>0]|0;a[f>>0]=I;j=j+1|0}}while(0);f=K;j=f+40|0;do{a[f>>0]=0;f=f+1|0}while((f|0)<(j|0));h[J>>3]=+h[L>>3];f=jc(K,40,833,J)|0;if(f>>>0>39)break;$a(N,K,f);rb(M,N);f=e+4|0;j=c[f>>2]|0;L=c[e+8>>2]|0;k=L;if(j>>>0<L>>>0){db(j,M);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=j-f|0;l=(L|0)/24|0;j=l+1|0;if((L|0)<-24)Pa();f=(k-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<j>>>0?j:f}else f=2147483647;ab(J,f,l,e+12|0);L=J+8|0;K=c[L>>2]|0;db(K,M);c[L>>2]=K+24;cb(e,J);bb(J)}Ia(M);Ja(N);f=b+23|0}else f=m;break f}while(0);f=m}else f=m;while(0);b=(f|0)==(m|0)?b:f;break a}case 95:{if((a[b+2>>0]|0)!=90)break a;N=b+3|0;f=Ma(N,d,e)|0;if((f|0)==(N|0)|(f|0)==(d|0))break a;b=(a[f>>0]|0)==69?f+1|0:b;break a}default:{m=Na(w,d,e)|0;if((m|0)==(w|0)|(m|0)==(d|0))break a;if((a[m>>0]|0)==69){b=m+1|0;break a}else n=m;while(1){if((n|0)==(d|0))break a;f=a[n>>0]|0;if(((f<<24>>24)+-48|0)>>>0>=10)break;n=n+1|0}if(!((n|0)!=(m|0)&f<<24>>24==69))break a;f=c[e+4>>2]|0;if((c[e>>2]|0)==(f|0))break a;l=f+-24|0;Cb(E,l);b=Ta(E,0,797)|0;c[D>>2]=c[b>>2];c[D+4>>2]=c[b+4>>2];c[D+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(D,799)|0;c[C>>2]=c[b>>2];c[C+4>>2]=c[b+4>>2];c[C+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}j=n-m|0;if(j>>>0>4294967279)Xa();if(j>>>0<11){a[F>>0]=j<<1;k=F+1|0}else{e=j+16&-16;k=vc(e)|0;c[F+8>>2]=k;c[F>>2]=e|1;c[F+4>>2]=j}b=m;f=k;while(1){if((b|0)==(n|0))break;a[f>>0]=a[b>>0]|0;b=b+1|0;f=f+1|0}a[k+j>>0]=0;b=a[F>>0]|0;f=(b&1)==0;b=Za(C,f?F+1|0:c[F+8>>2]|0,f?(b&255)>>>1:c[F+4>>2]|0)|0;c[B>>2]=c[b>>2];c[B+4>>2]=c[b+4>>2];c[B+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(A,B);Db(l,A);Ia(A);Ja(B);Ja(F);Ja(C);Ja(D);Ja(E);b=n+1|0;break a}}while(0)}while(0);i=O;return b|0}function wb(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+80|0;p=s+48|0;m=s+24|0;n=s+12|0;o=s;r=tb(b,d)|0;if(!((r|0)==(b|0)|(r|0)==(d|0))?(a[r>>0]|0)==69:0){l=a[e>>0]|0;q=e+4|0;do if(((l&1)==0?(l&255)>>>1:c[q>>2]|0)>>>0>3){xb(o,797,e);d=Ya(o,799)|0;c[n>>2]=c[d>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];g=0;while(1){if((g|0)==3)break;c[d+(g<<2)>>2]=0;g=g+1|0}rb(m,n);g=f+4|0;d=c[g>>2]|0;l=c[f+8>>2]|0;h=l;if(d>>>0<l>>>0){db(d,m);c[g>>2]=(c[g>>2]|0)+24}else{j=c[f>>2]|0;d=d-j|0;l=(d|0)/24|0;k=l+1|0;if((d|0)<-24)Pa();d=(h-j|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<k>>>0?k:d}else d=2147483647;ab(p,d,l,f+12|0);l=p+8|0;k=c[l>>2]|0;db(k,m);c[l>>2]=k+24;cb(f,p);bb(p)}Ia(m);Ja(n);Ja(o)}else{k=f+4|0;g=c[k>>2]|0;o=c[f+8>>2]|0;d=o;if(g>>>0<o>>>0){c[g>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;c[g+16>>2]=0;c[g+20>>2]=0;d=0;while(1){if((d|0)==3)break;c[g+(d<<2)>>2]=0;d=d+1|0}d=g+12|0;g=0;while(1){if((g|0)==3)break;c[d+(g<<2)>>2]=0;g=g+1|0}c[k>>2]=(c[k>>2]|0)+24;g=k;break}h=c[f>>2]|0;o=g-h|0;j=(o|0)/24|0;g=j+1|0;if((o|0)<-24)Pa();d=(d-h|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<g>>>0?g:d}else d=2147483647;ab(p,d,j,f+12|0);h=p+8|0;j=c[h>>2]|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;d=0;while(1){if((d|0)==3)break;c[j+(d<<2)>>2]=0;d=d+1|0}d=j+12|0;g=0;while(1){if((g|0)==3)break;c[d+(g<<2)>>2]=0;g=g+1|0}c[h>>2]=j+24;cb(f,p);bb(p);g=k}while(0);if((a[b>>0]|0)==110){zb((c[g>>2]|0)+-24|0,45);b=b+1|0}Bb((c[g>>2]|0)+-24|0,b,r);b=a[e>>0]|0;d=(b&1)==0;b=d?(b&255)>>>1:c[q>>2]|0;if(b>>>0<4)Za((c[g>>2]|0)+-24|0,d?e+1|0:c[e+8>>2]|0,b)|0;b=r+1|0}i=s;return b|0}function xb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}g=bc(d)|0;f=a[e>>0]|0;f=(f&1)==0?(f&255)>>>1:c[e+4>>2]|0;yb(b,d,g,f+g|0);Za(b,(a[e>>0]&1)==0?e+1|0:c[e+8>>2]|0,f)|0;return}function yb(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;if(f>>>0>4294967279)Xa();if(f>>>0<11){a[b>>0]=e<<1;f=b+1|0}else{g=f+16&-16;f=vc(g)|0;c[b+8>>2]=f;c[b>>2]=g|1;c[b+4>>2]=e}Fc(f|0,d|0,e|0)|0;a[f+e>>0]=0;return}function zb(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=a[b>>0]|0;f=(e&1)!=0;if(f){g=(c[b>>2]&-2)+-1|0;h=c[b+4>>2]|0}else{g=10;h=(e&255)>>>1}if((h|0)==(g|0)){Ab(b,g,1,g,g,0);if(!(a[b>>0]&1))f=7;else f=8}else if(f)f=8;else f=7;if((f|0)==7){a[b>>0]=(h<<1)+2;e=b+1|0}else if((f|0)==8){e=c[b+8>>2]|0;c[b+4>>2]=h+1}b=e+h|0;a[b>>0]=d;a[b+1>>0]=0;return}function Ab(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0;if((-17-d|0)>>>0<e>>>0)Xa();if(!(a[b>>0]&1))j=b+1|0;else j=c[b+8>>2]|0;if(d>>>0<2147483623){e=e+d|0;i=d<<1;e=e>>>0<i>>>0?i:e;e=e>>>0<11?11:e+16&-16}else e=-17;i=vc(e)|0;if(g)Fc(i|0,j|0,g|0)|0;if((f|0)!=(g|0))Fc(i+g+h|0,j+g|0,f-g|0)|0;if((d|0)!=10)wc(j);c[b+8>>2]=i;c[b>>2]=e|1;return}function Bb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;h=d;f=a[b>>0]|0;if(!(f&1)){k=(f&255)>>>1;g=10}else{f=c[b>>2]|0;k=c[b+4>>2]|0;g=(f&-2)+-1|0;f=f&255}j=e-h|0;do if((e|0)!=(d|0)){if((g-k|0)>>>0<j>>>0){Ab(b,g,k+j-g|0,k,k,0);f=a[b>>0]|0}if(!(f&1))i=b+1|0;else i=c[b+8>>2]|0;h=e+(k-h)|0;f=d;g=i+k|0;while(1){if((f|0)==(e|0))break;a[g>>0]=a[f>>0]|0;f=f+1|0;g=g+1|0}a[i+h>>0]=0;f=k+j|0;if(!(a[b>>0]&1)){a[b>>0]=f<<1;break}else{c[b+4>>2]=f;break}}while(0);return}function Cb(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;g=d+12|0;e=a[g>>0]|0;f=(e&1)==0;e=Za(d,f?g+1|0:c[d+20>>2]|0,f?(e&255)>>>1:c[d+16>>2]|0)|0;c[b>>2]=c[e>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];d=0;while(1){if((d|0)==3)break;c[e+(d<<2)>>2]=0;d=d+1|0}return}function Db(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;do if(a[b>>0]&1){m=b+8|0;a[c[m>>2]>>0]=0;k=b+4|0;c[k>>2]=0;e=a[b>>0]|0;if(!(e&1))i=10;else{i=c[b>>2]|0;e=i&255;i=(i&-2)+-1|0}if(!(e&1)){f=(e&255)>>>1;if((e&255)<22){h=10;j=f;l=1}else{h=(f+16&240)+-1|0;j=f;l=1}}else{h=10;j=0;l=0}if((h|0)!=(i|0)){if((h|0)==10){g=b+1|0;f=c[m>>2]|0;if(l){Fc(g|0,f|0,((e&255)>>>1)+1|0)|0;wc(f)}else{a[g>>0]=a[f>>0]|0;wc(f)}a[b>>0]=j<<1;break}f=h+1|0;g=vc(f)|0;if(!(h>>>0<=i>>>0&(g|0)==0)){if(l)Fc(g|0,b+1|0,((e&255)>>>1)+1|0)|0;else{n=c[m>>2]|0;a[g>>0]=a[n>>0]|0;wc(n)}c[b>>2]=f|1;c[k>>2]=j;c[m>>2]=g}}}else{a[b+1>>0]=0;a[b>>0]=0}while(0);c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];e=0;while(1){if((e|0)==3)break;c[d+(e<<2)>>2]=0;e=e+1|0}n=b+12|0;d=d+12|0;do if(a[n>>0]&1){m=b+20|0;a[c[m>>2]>>0]=0;j=b+16|0;c[j>>2]=0;e=a[n>>0]|0;if(!(e&1))i=10;else{i=c[n>>2]|0;e=i&255;i=(i&-2)+-1|0}if(!(e&1)){f=(e&255)>>>1;if((e&255)<22){h=10;k=f;l=1}else{h=(f+16&240)+-1|0;k=f;l=1}}else{h=10;k=0;l=0}if((h|0)!=(i|0)){if((h|0)==10){g=n+1|0;f=c[m>>2]|0;if(l){Fc(g|0,f|0,((e&255)>>>1)+1|0)|0;wc(f)}else{a[g>>0]=a[f>>0]|0;wc(f)}a[n>>0]=k<<1;break}f=h+1|0;g=vc(f)|0;if(!(h>>>0<=i>>>0&(g|0)==0)){if(l)Fc(g|0,n+1|0,((e&255)>>>1)+1|0)|0;else{b=c[m>>2]|0;a[g>>0]=a[b>>0]|0;wc(b)}c[n>>2]=f|1;c[j>>2]=k;c[m>>2]=g}}}else{a[n+1>>0]=0;a[n>>0]=0}while(0);c[n>>2]=c[d>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];e=0;while(1){if((e|0)==3)break;c[d+(e<<2)>>2]=0;e=e+1|0}return}function Eb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+96|0;w=x+64|0;k=x+40|0;u=x+16|0;v=x;t=b;a:do if((d-t|0)>1?(a[b>>0]|0)==84:0){r=a[b+1>>0]|0;if(r<<24>>24==95){f=c[e+36>>2]|0;if((c[e+32>>2]|0)==(f|0)){f=b;break}g=c[f+-16>>2]|0;if((g|0)!=(c[f+-12>>2]|0)){m=c[g+4>>2]|0;n=e+4|0;o=e+8|0;p=e+12|0;q=w+8|0;l=c[g>>2]|0;while(1){if((l|0)==(m|0)){f=8;break}f=c[n>>2]|0;k=c[o>>2]|0;g=k;if((f|0)==(k|0)){h=c[e>>2]|0;f=f-h|0;k=(f|0)/24|0;j=k+1|0;if((f|0)<-24){f=12;break}f=(g-h|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<j>>>0?j:f}else f=2147483647;ab(w,f,k,p);k=c[q>>2]|0;_a(k,l);_a(k+12|0,l+12|0);c[q>>2]=k+24;cb(e,w);bb(w)}else{_a(f,l);_a(f+12|0,l+12|0);c[n>>2]=(c[n>>2]|0)+24}l=l+24|0}if((f|0)==8){f=b+2|0;break}else if((f|0)==12)Pa()}else{a[k>>0]=4;f=k+1|0;a[f>>0]=84;a[f+1>>0]=95;a[k+3>>0]=0;f=k+12|0;g=0;while(1){if((g|0)==3)break;c[f+(g<<2)>>2]=0;g=g+1|0}f=e+4|0;g=c[f>>2]|0;v=c[e+8>>2]|0;h=v;if(g>>>0<v>>>0){db(g,k);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;v=g-f|0;j=(v|0)/24|0;g=j+1|0;if((v|0)<-24)Pa();f=(h-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<g>>>0?g:f}else f=2147483647;ab(w,f,j,e+12|0);v=w+8|0;u=c[v>>2]|0;db(u,k);c[v>>2]=u+24;cb(e,w);bb(w)}Ia(k);a[e+62>>0]=1;f=b+2|0;break}}f=(r<<24>>24)+-48|0;if(f>>>0<10){r=b+2|0;while(1){if((r|0)==(d|0)){f=b;break a}g=a[r>>0]|0;h=(g<<24>>24)+-48|0;if(h>>>0>=10)break;f=h+(f*10|0)|0;r=r+1|0}if(g<<24>>24==95?(s=c[e+36>>2]|0,(c[e+32>>2]|0)!=(s|0)):0){f=f+1|0;d=c[s+-16>>2]|0;g=d;if(f>>>0<(c[s+-12>>2]|0)-d>>4>>>0){m=c[g+(f<<4)+4>>2]|0;n=e+4|0;o=e+8|0;p=e+12|0;q=w+8|0;l=c[g+(f<<4)>>2]|0;while(1){if((l|0)==(m|0)){f=38;break}f=c[n>>2]|0;s=c[o>>2]|0;g=s;if((f|0)==(s|0)){h=c[e>>2]|0;s=f-h|0;k=(s|0)/24|0;j=k+1|0;if((s|0)<-24){f=42;break}f=(g-h|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<j>>>0?j:f}else f=2147483647;ab(w,f,k,p);s=c[q>>2]|0;_a(s,l);_a(s+12|0,l+12|0);c[q>>2]=s+24;cb(e,w);bb(w)}else{_a(f,l);_a(f+12|0,l+12|0);c[n>>2]=(c[n>>2]|0)+24}l=l+24|0}if((f|0)==38){f=r+1|0;break}else if((f|0)==42)Pa()}f=r+1|0;j=f-t|0;if(j>>>0>4294967279)Xa();if(j>>>0<11){a[v>>0]=j<<1;k=v+1|0}else{t=j+16&-16;k=vc(t)|0;c[v+8>>2]=k;c[v>>2]=t|1;c[v+4>>2]=j}g=b;h=k;while(1){if((g|0)==(f|0))break;a[h>>0]=a[g>>0]|0;g=g+1|0;h=h+1|0}a[k+j>>0]=0;rb(u,v);g=e+4|0;h=c[g>>2]|0;b=c[e+8>>2]|0;j=b;if(h>>>0<b>>>0){db(h,u);c[g>>2]=(c[g>>2]|0)+24}else{g=c[e>>2]|0;b=h-g|0;k=(b|0)/24|0;h=k+1|0;if((b|0)<-24)Pa();g=(j-g|0)/24|0;if(g>>>0<1073741823){g=g<<1;g=g>>>0<h>>>0?h:g}else g=2147483647;ab(w,g,k,e+12|0);b=w+8|0;t=c[b>>2]|0;db(t,u);c[b>>2]=t+24;cb(e,w);bb(w)}Ia(u);Ja(v);a[e+62>>0]=1}else f=b}else f=b}else f=b;while(0);i=x;return f|0}function Fb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+128|0;q=r+104|0;g=r+72|0;n=r+80|0;o=r+60|0;p=r+48|0;j=r+24|0;k=r+12|0;l=r;a:do if((d-b|0)>2?(a[b>>0]|0)==102:0){switch(a[b+1>>0]|0){case 112:{f=Oa(b+2|0,d,g)|0;h=tb(f,d)|0;if((h|0)!=(d|0)?(a[h>>0]|0)==95:0){g=h-f|0;if(g>>>0>4294967279)Xa();if(g>>>0<11){a[p>>0]=g<<1;d=p+1|0}else{m=g+16&-16;d=vc(m)|0;c[p+8>>2]=d;c[p>>2]=m|1;c[p+4>>2]=g}b=f;f=d;while(1){if((b|0)==(h|0))break;a[f>>0]=a[b>>0]|0;b=b+1|0;f=f+1|0}a[d+g>>0]=0;b=Ta(p,0,838)|0;c[o>>2]=c[b>>2];c[o+4>>2]=c[b+4>>2];c[o+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(n,o);b=e+4|0;f=c[b>>2]|0;m=c[e+8>>2]|0;g=m;if(f>>>0<m>>>0){db(f,n);c[b>>2]=(c[b>>2]|0)+24}else{b=c[e>>2]|0;m=f-b|0;d=(m|0)/24|0;f=d+1|0;if((m|0)<-24)Pa();b=(g-b|0)/24|0;if(b>>>0<1073741823){b=b<<1;b=b>>>0<f>>>0?f:b}else b=2147483647;ab(q,b,d,e+12|0);m=q+8|0;l=c[m>>2]|0;db(l,n);c[m>>2]=l+24;cb(e,q);bb(q)}Ia(n);Ja(o);Ja(p);b=h+1|0}break a}case 76:break;default:break a}f=tb(b+2|0,d)|0;if((((f|0)!=(d|0)?(a[f>>0]|0)==112:0)?(h=Oa(f+1|0,d,g)|0,m=tb(h,d)|0,(m|0)!=(d|0)):0)?(a[m>>0]|0)==95:0){g=m-h|0;if(g>>>0>4294967279)Xa();if(g>>>0<11){a[l>>0]=g<<1;d=l+1|0}else{p=g+16&-16;d=vc(p)|0;c[l+8>>2]=d;c[l>>2]=p|1;c[l+4>>2]=g}b=h;f=d;while(1){if((b|0)==(m|0))break;a[f>>0]=a[b>>0]|0;b=b+1|0;f=f+1|0}a[d+g>>0]=0;b=Ta(l,0,838)|0;c[k>>2]=c[b>>2];c[k+4>>2]=c[b+4>>2];c[k+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(j,k);b=e+4|0;f=c[b>>2]|0;p=c[e+8>>2]|0;g=p;if(f>>>0<p>>>0){db(f,j);c[b>>2]=(c[b>>2]|0)+24}else{b=c[e>>2]|0;p=f-b|0;d=(p|0)/24|0;f=d+1|0;if((p|0)<-24)Pa();b=(g-b|0)/24|0;if(b>>>0<1073741823){b=b<<1;b=b>>>0<f>>>0?f:b}else b=2147483647;ab(q,b,d,e+12|0);p=q+8|0;o=c[p>>2]|0;db(o,j);c[p>>2]=o+24;cb(e,q);bb(q)}Ia(j);Ja(k);Ja(l);b=m+1|0}}while(0);i=r;return b|0}function Gb(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;t=i;i=i+96|0;s=t+84|0;r=t+72|0;l=t+60|0;m=t+48|0;n=t+36|0;o=t+24|0;p=t+12|0;q=t;g=ub(b,d,f)|0;a:do if((g|0)!=(b|0)){d=ub(g,d,f)|0;h=f+4|0;if((d|0)==(g|0)){g=c[h>>2]|0;d=g+-24|0;while(1){if((g|0)==(d|0)){d=b;break a}s=g+-24|0;c[h>>2]=s;Ia(s);g=c[h>>2]|0}}g=c[h>>2]|0;if(((g-(c[f>>2]|0)|0)/24|0)>>>0>=2){Cb(s,g+-24|0);g=c[h>>2]|0;f=g+-24|0;b=g;while(1){if((b|0)==(f|0))break;k=b+-24|0;c[h>>2]=k;Ia(k);b=c[h>>2]|0}Cb(r,g+-48|0);g=c[h>>2]|0;k=g+-24|0;if(!(a[k>>0]&1)){a[k+1>>0]=0;a[k>>0]=0}else{a[c[g+-16>>2]>>0]=0;c[g+-20>>2]=0}u=a[e>>0]|0;f=(u&1)==0;b=e+4|0;u=f?(u&255)>>>1:c[b>>2]|0;h=e+8|0;j=e+1|0;g=u>>>0>1;f=ac(f?j:c[h>>2]|0,844,g?1:u)|0;if(!(((f|0)==0?((u|0)==0?-1:g&1):f)|0))zb(k,40);xb(q,797,r);g=Ya(q,846)|0;c[p>>2]=c[g>>2];c[p+4>>2]=c[g+4>>2];c[p+8>>2]=c[g+8>>2];f=0;while(1){if((f|0)==3)break;c[g+(f<<2)>>2]=0;f=f+1|0}g=a[e>>0]|0;f=(g&1)==0;g=Za(p,f?j:c[h>>2]|0,f?(g&255)>>>1:c[b>>2]|0)|0;c[o>>2]=c[g>>2];c[o+4>>2]=c[g+4>>2];c[o+8>>2]=c[g+8>>2];f=0;while(1){if((f|0)==3)break;c[g+(f<<2)>>2]=0;f=f+1|0}g=Ya(o,849)|0;c[n>>2]=c[g>>2];c[n+4>>2]=c[g+4>>2];c[n+8>>2]=c[g+8>>2];f=0;while(1){if((f|0)==3)break;c[g+(f<<2)>>2]=0;f=f+1|0}g=a[s>>0]|0;f=(g&1)==0;g=Za(n,f?s+1|0:c[s+8>>2]|0,f?(g&255)>>>1:c[s+4>>2]|0)|0;c[m>>2]=c[g>>2];c[m+4>>2]=c[g+4>>2];c[m+8>>2]=c[g+8>>2];f=0;while(1){if((f|0)==3)break;c[g+(f<<2)>>2]=0;f=f+1|0}g=Ya(m,799)|0;c[l>>2]=c[g>>2];c[l+4>>2]=c[g+4>>2];c[l+8>>2]=c[g+8>>2];f=0;while(1){if((f|0)==3)break;c[g+(f<<2)>>2]=0;f=f+1|0}u=a[l>>0]|0;f=(u&1)==0;Za(k,f?l+1|0:c[l+8>>2]|0,f?(u&255)>>>1:c[l+4>>2]|0)|0;Ja(l);Ja(m);Ja(n);Ja(o);Ja(p);Ja(q);q=a[e>>0]|0;u=(q&1)==0;q=u?(q&255)>>>1:c[b>>2]|0;e=q>>>0>1;u=ac(u?j:c[h>>2]|0,844,e?1:q)|0;if(!(((u|0)==0?((q|0)==0?-1:e&1):u)|0))zb(k,41);Ja(r);Ja(s)}else d=b}else d=b;while(0);i=t;return d|0}function Hb(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+48|0;o=s+36|0;p=s+24|0;q=s+12|0;r=s;d=ub(b,d,f)|0;if((d|0)!=(b|0)?(g=f+4|0,h=c[g>>2]|0,(c[f>>2]|0)!=(h|0)):0){n=h+-24|0;Ib(q,e,797);Cb(r,(c[g>>2]|0)+-24|0);f=a[r>>0]|0;b=(f&1)==0;f=Za(q,b?r+1|0:c[r+8>>2]|0,b?(f&255)>>>1:c[r+4>>2]|0)|0;c[p>>2]=c[f>>2];c[p+4>>2]=c[f+4>>2];c[p+8>>2]=c[f+8>>2];b=0;while(1){if((b|0)==3)break;c[f+(b<<2)>>2]=0;b=b+1|0}f=Ya(p,799)|0;c[o>>2]=c[f>>2];c[o+4>>2]=c[f+4>>2];c[o+8>>2]=c[f+8>>2];b=0;while(1){if((b|0)==3)break;c[f+(b<<2)>>2]=0;b=b+1|0}do if(a[n>>0]&1){m=h+-16|0;a[c[m>>2]>>0]=0;j=h+-20|0;c[j>>2]=0;f=a[n>>0]|0;if(!(f&1))h=10;else{h=c[n>>2]|0;f=h&255;h=(h&-2)+-1|0}if(!(f&1)){b=(f&255)>>>1;if((f&255)<22){e=10;k=b;l=1}else{e=(b+16&240)+-1|0;k=b;l=1}}else{e=10;k=0;l=0}if((e|0)!=(h|0)){if((e|0)==10){g=n+1|0;b=c[m>>2]|0;if(l){Fc(g|0,b|0,((f&255)>>>1)+1|0)|0;wc(b)}else{a[g>>0]=a[b>>0]|0;wc(b)}a[n>>0]=k<<1;break}b=e+1|0;g=vc(b)|0;if(!(e>>>0<=h>>>0&(g|0)==0)){if(l)Fc(g|0,n+1|0,((f&255)>>>1)+1|0)|0;else{l=c[m>>2]|0;a[g>>0]=a[l>>0]|0;wc(l)}c[n>>2]=b|1;c[j>>2]=k;c[m>>2]=g}}}else{a[n+1>>0]=0;a[n>>0]=0}while(0);c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];f=0;while(1){if((f|0)==3)break;c[o+(f<<2)>>2]=0;f=f+1|0}Ja(o);Ja(p);Ja(r);Ja(q)}else d=b;i=s;return d|0}function Ib(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}g=a[d>>0]|0;h=(g&1)==0;g=h?(g&255)>>>1:c[d+4>>2]|0;f=bc(e)|0;yb(b,h?d+1|0:c[d+8>>2]|0,g,g+f|0);Za(b,e,f)|0;return}function Jb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+80|0;s=t+60|0;p=t+48|0;r=t+36|0;l=t+24|0;o=t+12|0;q=t;g=d;a:do if((g-b|0)>2){if((a[b>>0]|0)==103){h=(a[b+1>>0]|0)==115;j=h;h=h?b+2|0:b}else{j=0;h=b}f=Kb(h,d,e)|0;if((f|0)!=(h|0)){if(!j)break;g=c[e+4>>2]|0;if((c[e>>2]|0)==(g|0)){f=b;break}Ta(g+-24|0,0,891)|0;break}if(((g-h|0)>2?(a[h>>0]|0)==115:0)?(a[h+1>>0]|0)==114:0){f=h+2|0;if((a[f>>0]|0)==78){q=h+3|0;f=Ob(q,d,e)|0;if((f|0)==(q|0)|(f|0)==(d|0)){f=b;break}j=Mb(f,d,e)|0;o=e+4|0;do if((j|0)==(f|0))n=e;else{f=c[o>>2]|0;if(((f-(c[e>>2]|0)|0)/24|0)>>>0<2){f=b;break a}Cb(s,f+-24|0);f=c[o>>2]|0;g=f+-24|0;h=f;while(1){if((h|0)==(g|0))break;q=h+-24|0;c[o>>2]=q;Ia(q);h=c[o>>2]|0}q=a[s>>0]|0;n=(q&1)==0;Za(f+-48|0,n?s+1|0:c[s+8>>2]|0,n?(q&255)>>>1:c[s+4>>2]|0)|0;if((j|0)!=(d|0)){Ja(s);n=e;f=j;break}g=c[o>>2]|0;f=g+-24|0;while(1){if((g|0)==(f|0))break;e=g+-24|0;c[o>>2]=e;Ia(e);g=c[o>>2]|0}Ja(s);f=b;break a}while(0);k=p+8|0;l=p+1|0;m=p+4|0;while(1){if((a[f>>0]|0)==69)break;j=Vb(f,d,e)|0;if((j|0)==(f|0)|(j|0)==(d|0)){f=b;break a}f=c[o>>2]|0;if(((f-(c[n>>2]|0)|0)/24|0)>>>0<2){f=b;break a}Cb(s,f+-24|0);h=c[o>>2]|0;f=h+-24|0;g=h;while(1){if((g|0)==(f|0))break;q=g+-24|0;c[o>>2]=q;Ia(q);g=c[o>>2]|0}f=Ta(s,0,891)|0;c[p>>2]=c[f>>2];c[p+4>>2]=c[f+4>>2];c[p+8>>2]=c[f+8>>2];g=0;while(1){if((g|0)==3)break;c[f+(g<<2)>>2]=0;g=g+1|0}f=a[p>>0]|0;q=(f&1)==0;Za(h+-48|0,q?l:c[k>>2]|0,q?(f&255)>>>1:c[m>>2]|0)|0;Ja(p);Ja(s);f=j}q=f+1|0;f=Kb(q,d,e)|0;if((f|0)==(q|0)){f=c[o>>2]|0;if((c[e>>2]|0)==(f|0)){f=b;break}g=f+-24|0;while(1){if((f|0)==(g|0)){f=b;break a}s=f+-24|0;c[o>>2]=s;Ia(s);f=c[o>>2]|0}}g=c[o>>2]|0;if(((g-(c[n>>2]|0)|0)/24|0)>>>0<2){f=b;break}Cb(s,g+-24|0);j=c[o>>2]|0;g=j+-24|0;h=j;while(1){if((h|0)==(g|0))break;b=h+-24|0;c[o>>2]=b;Ia(b);h=c[o>>2]|0}g=Ta(s,0,891)|0;c[r>>2]=c[g>>2];c[r+4>>2]=c[g+4>>2];c[r+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}b=a[r>>0]|0;e=(b&1)==0;Za(j+-48|0,e?r+1|0:c[r+8>>2]|0,e?(b&255)>>>1:c[r+4>>2]|0)|0;Ja(r);Ja(s);break}g=Ob(f,d,e)|0;if((g|0)!=(f|0)){k=Mb(g,d,e)|0;if((k|0)!=(g|0)){j=e+4|0;f=c[j>>2]|0;if(((f-(c[e>>2]|0)|0)/24|0)>>>0<2){f=b;break}Cb(s,f+-24|0);f=c[j>>2]|0;g=f+-24|0;h=f;while(1){if((h|0)==(g|0))break;r=h+-24|0;c[j>>2]=r;Ia(r);h=c[j>>2]|0}g=a[s>>0]|0;r=(g&1)==0;Za(f+-48|0,r?s+1|0:c[s+8>>2]|0,r?(g&255)>>>1:c[s+4>>2]|0)|0;Ja(s);g=k}f=Kb(g,d,e)|0;if((f|0)==(g|0)){h=e+4|0;f=c[h>>2]|0;if((c[e>>2]|0)==(f|0)){f=b;break}g=f+-24|0;while(1){if((f|0)==(g|0)){f=b;break a}s=f+-24|0;c[h>>2]=s;Ia(s);f=c[h>>2]|0}}k=e+4|0;g=c[k>>2]|0;if(((g-(c[e>>2]|0)|0)/24|0)>>>0<2){f=b;break}Cb(s,g+-24|0);j=c[k>>2]|0;g=j+-24|0;h=j;while(1){if((h|0)==(g|0))break;b=h+-24|0;c[k>>2]=b;Ia(b);h=c[k>>2]|0}g=Ta(s,0,891)|0;c[l>>2]=c[g>>2];c[l+4>>2]=c[g+4>>2];c[l+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}b=a[l>>0]|0;e=(b&1)==0;Za(j+-48|0,e?l+1|0:c[l+8>>2]|0,e?(b&255)>>>1:c[l+4>>2]|0)|0;Ja(l);Ja(s);break}h=Vb(f,d,e)|0;if(!((h|0)==(f|0)|(h|0)==(d|0))){if(j){f=e+4|0;g=c[f>>2]|0;if((c[e>>2]|0)==(g|0)){f=b;break}Ta(g+-24|0,0,891)|0;n=f}else n=e+4|0;k=o+8|0;l=o+1|0;m=o+4|0;f=h;while(1){if((a[f>>0]|0)==69)break;j=Vb(f,d,e)|0;if((j|0)==(f|0)|(j|0)==(d|0)){f=b;break a}f=c[n>>2]|0;if(((f-(c[e>>2]|0)|0)/24|0)>>>0<2){f=b;break a}Cb(s,f+-24|0);h=c[n>>2]|0;f=h+-24|0;g=h;while(1){if((g|0)==(f|0))break;r=g+-24|0;c[n>>2]=r;Ia(r);g=c[n>>2]|0}f=Ta(s,0,891)|0;c[o>>2]=c[f>>2];c[o+4>>2]=c[f+4>>2];c[o+8>>2]=c[f+8>>2];g=0;while(1){if((g|0)==3)break;c[f+(g<<2)>>2]=0;g=g+1|0}f=a[o>>0]|0;r=(f&1)==0;Za(h+-48|0,r?l:c[k>>2]|0,r?(f&255)>>>1:c[m>>2]|0)|0;Ja(o);Ja(s);f=j}r=f+1|0;f=Kb(r,d,e)|0;if((f|0)==(r|0)){f=c[n>>2]|0;if((c[e>>2]|0)==(f|0)){f=b;break}g=f+-24|0;while(1){if((f|0)==(g|0)){f=b;break a}s=f+-24|0;c[n>>2]=s;Ia(s);f=c[n>>2]|0}}g=c[n>>2]|0;if(((g-(c[e>>2]|0)|0)/24|0)>>>0>=2){Cb(s,g+-24|0);j=c[n>>2]|0;g=j+-24|0;h=j;while(1){if((h|0)==(g|0))break;b=h+-24|0;c[n>>2]=b;Ia(b);h=c[n>>2]|0}g=Ta(s,0,891)|0;c[q>>2]=c[g>>2];c[q+4>>2]=c[g+4>>2];c[q+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}b=a[q>>0]|0;e=(b&1)==0;Za(j+-48|0,e?q+1|0:c[q+8>>2]|0,e?(b&255)>>>1:c[q+4>>2]|0)|0;Ja(q);Ja(s)}else f=b}else f=b}else f=b}else f=b;while(0);i=t;return f|0}function Kb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;k=i;i=i+16|0;j=k;a:do if((d-b|0)>1){f=a[b>>0]|0;switch(f<<24>>24){case 100:case 111:{if((a[b+1>>0]|0)==110){h=b+2|0;if(f<<24>>24==111){f=Lb(h,d,e)|0;if((f|0)==(h|0)){f=b;break a}b=Mb(f,d,e)|0;if((b|0)==(f|0))break a;d=e+4|0;f=c[d>>2]|0;if(((f-(c[e>>2]|0)|0)/24|0)>>>0<2){f=b;break a}Cb(j,f+-24|0);f=c[d>>2]|0;g=f+-24|0;h=f;while(1){if((h|0)==(g|0))break;e=h+-24|0;c[d>>2]=e;Ia(e);h=c[d>>2]|0}e=a[j>>0]|0;d=(e&1)==0;Za(f+-48|0,d?j+1|0:c[j+8>>2]|0,d?(e&255)>>>1:c[j+4>>2]|0)|0;Ja(j);f=b;break a}else{if((h|0)!=(d|0)){f=Ob(h,d,e)|0;if((f|0)==(h|0))f=Vb(h,d,e)|0;if((f|0)!=(h|0)?(g=c[e+4>>2]|0,(c[e>>2]|0)!=(g|0)):0)Ta(g+-24|0,0,886)|0;else f=h}else f=d;f=(f|0)==(h|0)?b:f;break a}}break}default:{}}f=Vb(b,d,e)|0;if((f|0)==(b|0)){f=Lb(b,d,e)|0;if((f|0)!=(b|0)){b=Mb(f,d,e)|0;if((b|0)!=(f|0)){d=e+4|0;f=c[d>>2]|0;if(((f-(c[e>>2]|0)|0)/24|0)>>>0<2)f=b;else{Cb(j,f+-24|0);f=c[d>>2]|0;g=f+-24|0;h=f;while(1){if((h|0)==(g|0))break;e=h+-24|0;c[d>>2]=e;Ia(e);h=c[d>>2]|0}e=a[j>>0]|0;d=(e&1)==0;Za(f+-48|0,d?j+1|0:c[j+8>>2]|0,d?(e&255)>>>1:c[j+4>>2]|0)|0;Ja(j);f=b}}}else f=b}}else f=b;while(0);i=k;return f|0}function Lb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0;ca=i;i=i+1136|0;ba=ca+1104|0;j=ca+1080|0;k=ca+1056|0;v=ca+1032|0;G=ca+1008|0;R=ca+984|0;Y=ca+960|0;Z=ca+936|0;_=ca+912|0;$=ca+888|0;aa=ca+864|0;l=ca+840|0;m=ca+816|0;n=ca+792|0;o=ca+768|0;p=ca+744|0;q=ca+720|0;r=ca+696|0;s=ca+672|0;t=ca+648|0;u=ca+624|0;w=ca+600|0;x=ca+576|0;y=ca+552|0;z=ca+528|0;A=ca+504|0;B=ca+480|0;C=ca+456|0;D=ca+432|0;E=ca+408|0;F=ca+384|0;H=ca+360|0;I=ca+336|0;J=ca+312|0;K=ca+288|0;L=ca+264|0;M=ca+240|0;N=ca+216|0;O=ca+192|0;P=ca+168|0;Q=ca+144|0;S=ca+120|0;T=ca+96|0;U=ca+72|0;V=ca+48|0;W=ca+24|0;X=ca;a:do if((d-b|0)>1)do switch(a[b>>0]|0){case 97:switch(a[b+1>>0]|0){case 97:{pb(j,926);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,j);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,j);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(j);d=b+2|0;break a}case 110:case 100:{mb(k,937);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,k);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,k);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(k);d=b+2|0;break a}case 78:{pb(v,947);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,v);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,v);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(v);d=b+2|0;break a}case 83:{mb(G,958);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,G);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,G);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(G);d=b+2|0;break a}default:{d=b;break a}}case 99:switch(a[b+1>>0]|0){case 108:{pb(R,968);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,R);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,R);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(R);d=b+2|0;break a}case 109:{mb(Y,979);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,Y);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,Y);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(Y);d=b+2|0;break a}case 111:{mb(Z,989);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,Z);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,Z);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(Z);d=b+2|0;break a}case 118:{aa=e+63|0;$=a[aa>>0]|0;a[aa>>0]=0;ba=b+2|0;d=Na(ba,d,e)|0;a[aa>>0]=$;if((d|0)==(ba|0)){d=b;break a}f=c[e+4>>2]|0;if((c[e>>2]|0)==(f|0)){d=b;break a}Ta(f+-24|0,0,999)|0;a[e+60>>0]=1;break a}default:{d=b;break a}}case 100:switch(a[b+1>>0]|0){case 97:{ob(_,1009);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,_);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,_);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(_);d=b+2|0;break a}case 101:{mb($,1027);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,$);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;_=c[aa>>2]|0;db(_,$);c[aa>>2]=_+24;cb(e,ba);bb(ba)}Ia($);d=b+2|0;break a}case 108:{d=vc(16)|0;c[aa+8>>2]=d;c[aa>>2]=17;c[aa+4>>2]=15;f=d;g=1037;h=f+15|0;do{a[f>>0]=a[g>>0]|0;f=f+1|0;g=g+1|0}while((f|0)<(h|0));a[d+15>>0]=0;d=aa+12|0;f=0;while(1){if((f|0)==3)break;c[d+(f<<2)>>2]=0;f=f+1|0}d=e+4|0;f=c[d>>2]|0;$=c[e+8>>2]|0;g=$;if(f>>>0<$>>>0){db(f,aa);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;$=f-d|0;h=($|0)/24|0;f=h+1|0;if(($|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);$=ba+8|0;_=c[$>>2]|0;db(_,aa);c[$>>2]=_+24;cb(e,ba);bb(ba)}Ia(aa);d=b+2|0;break a}case 118:{mb(l,1053);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,l);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,l);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(l);d=b+2|0;break a}case 86:{pb(m,1063);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,m);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,m);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(m);d=b+2|0;break a}default:{d=b;break a}}case 101:switch(a[b+1>>0]|0){case 111:{mb(n,1074);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,n);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,n);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(n);d=b+2|0;break a}case 79:{pb(o,1084);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,o);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,o);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(o);d=b+2|0;break a}case 113:{pb(p,1095);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,p);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,p);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(p);d=b+2|0;break a}default:{d=b;break a}}case 103:switch(a[b+1>>0]|0){case 101:{pb(q,1106);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,q);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,q);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(q);d=b+2|0;break a}case 116:{mb(r,1117);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,r);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,r);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(r);d=b+2|0;break a}default:{d=b;break a}}case 105:{if((a[b+1>>0]|0)!=120){d=b;break a}pb(s,1127);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,s);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,s);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(s);d=b+2|0;break a}case 108:switch(a[b+1>>0]|0){case 101:{pb(t,1138);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,t);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,t);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(t);d=b+2|0;break a}case 105:{ba=b+2|0;d=qb(ba,d,e)|0;if((d|0)==(ba|0)){d=b;break a}f=c[e+4>>2]|0;if((c[e>>2]|0)==(f|0)){d=b;break a}Ta(f+-24|0,0,1149)|0;break a}case 115:{pb(u,1161);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,u);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,u);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(u);d=b+2|0;break a}case 83:{gb(w,1172);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,w);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,w);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(w);d=b+2|0;break a}case 116:{mb(x,1184);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,x);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,x);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(x);d=b+2|0;break a}default:{d=b;break a}}case 109:switch(a[b+1>>0]|0){case 105:{mb(y,1194);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,y);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,y);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(y);d=b+2|0;break a}case 73:{pb(z,1204);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,z);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,z);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(z);d=b+2|0;break a}case 108:{mb(A,1027);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,A);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,A);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(A);d=b+2|0;break a}case 76:{pb(B,1215);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,B);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,B);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(B);d=b+2|0;break a}case 109:{pb(C,1226);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,C);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,C);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(C);d=b+2|0;break a}default:{d=b;break a}}case 110:switch(a[b+1>>0]|0){case 97:{jb(D,1237);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,D);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,D);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(D);d=b+2|0;break a}case 101:{pb(E,1252);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,E);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,E);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(E);d=b+2|0;break a}case 103:{mb(F,1194);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,F);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,F);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(F);d=b+2|0;break a}case 116:{mb(H,1263);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,H);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,H);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(H);d=b+2|0;break a}case 119:{lb(I,1273);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,I);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,I);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(I);d=b+2|0;break a}default:{d=b;break a}}case 111:switch(a[b+1>>0]|0){case 111:{pb(J,1286);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,J);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,J);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(J);d=b+2|0;break a}case 114:{mb(K,1297);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,K);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,K);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(K);d=b+2|0;break a}case 82:{pb(L,1307);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,L);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,L);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(L);d=b+2|0;break a}default:{d=b;break a}}case 112:switch(a[b+1>>0]|0){case 109:{gb(M,1318);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,M);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,M);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(M);d=b+2|0;break a}case 108:{mb(N,1330);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,N);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,N);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(N);d=b+2|0;break a}case 76:{pb(O,1340);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,O);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,O);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(O);d=b+2|0;break a}case 112:{pb(P,1351);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,P);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,P);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(P);d=b+2|0;break a}case 115:{mb(Q,1330);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,Q);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,Q);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(Q);d=b+2|0;break a}case 116:{pb(S,1362);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,S);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,S);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(S);d=b+2|0;break a}default:{d=b;break a}}case 113:{if((a[b+1>>0]|0)!=117){d=b;break a}mb(T,1373);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,T);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,T);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(T);d=b+2|0;break a}case 114:switch(a[b+1>>0]|0){case 109:{mb(U,1383);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,U);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,U);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(U);d=b+2|0;break a}case 77:{pb(V,1393);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,V);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,V);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(V);d=b+2|0;break a}case 115:{pb(W,1404);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,W);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,W);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(W);d=b+2|0;break a}case 83:{gb(X,1415);d=e+4|0;f=c[d>>2]|0;aa=c[e+8>>2]|0;g=aa;if(f>>>0<aa>>>0){db(f,X);c[d>>2]=(c[d>>2]|0)+24}else{d=c[e>>2]|0;aa=f-d|0;h=(aa|0)/24|0;f=h+1|0;if((aa|0)<-24)Pa();d=(g-d|0)/24|0;if(d>>>0<1073741823){d=d<<1;d=d>>>0<f>>>0?f:d}else d=2147483647;ab(ba,d,h,e+12|0);aa=ba+8|0;$=c[aa>>2]|0;db($,X);c[aa>>2]=$+24;cb(e,ba);bb(ba)}Ia(X);d=b+2|0;break a}default:{d=b;break a}}case 118:{if(((a[b+1>>0]|0)+-48|0)>>>0>=10){d=b;break a}ba=b+2|0;d=qb(ba,d,e)|0;if((d|0)==(ba|0)){d=b;break a}f=c[e+4>>2]|0;if((c[e>>2]|0)==(f|0)){d=b;break a}Ta(f+-24|0,0,999)|0;break a}default:{d=b;break a}}while(0);else d=b;while(0);i=ca;return d|0}function Mb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;M=i;i=i+80|0;K=M+60|0;L=M;F=M+48|0;I=M+24|0;J=M+12|0;do if((d-b|0)>1?(a[b>>0]|0)==73:0){G=e+61|0;E=e+36|0;a:do if(a[G>>0]|0){g=c[E>>2]|0;f=c[g+-16>>2]|0;g=g+-12|0;while(1){h=c[g>>2]|0;if((h|0)==(f|0))break a;H=h+-16|0;c[g>>2]=H;Ha(H)}}while(0);$a(L,1427,1);H=e+4|0;t=e+12|0;u=K+8|0;v=K+8|0;D=L+4|0;w=F+8|0;x=F+1|0;y=F+4|0;z=e+32|0;A=e+40|0;B=e+44|0;C=K+8|0;n=b+1|0;b:while(1){if((a[n>>0]|0)==69){f=48;break}do if(a[G>>0]|0){m=c[t>>2]|0;f=c[E>>2]|0;g=c[A>>2]|0;if(f>>>0<g>>>0){c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=m;c[E>>2]=(c[E>>2]|0)+16;break}h=c[z>>2]|0;s=f-h|0;k=s>>4;j=k+1|0;if((s|0)<-16){f=13;break b}f=g-h|0;if(f>>4>>>0<1073741823){f=f>>3;f=f>>>0<j>>>0?j:f}else f=2147483647;Ca(K,f,k,B);s=c[C>>2]|0;c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=m;c[C>>2]=s+16;Ea(z,K);Fa(K)}while(0);r=((c[H>>2]|0)-(c[e>>2]|0)|0)/24|0;s=Nb(n,d,e)|0;h=((c[H>>2]|0)-(c[e>>2]|0)|0)/24|0;c:do if(a[G>>0]|0){g=c[E>>2]|0;f=g+-16|0;while(1){if((g|0)==(f|0))break c;q=g+-16|0;c[E>>2]=q;Ga(q);g=c[E>>2]|0}}while(0);if((s|0)==(n|0)|(s|0)==(d|0)){f=62;break}d:do if(!(a[G>>0]|0))f=r;else{m=c[E>>2]|0;n=m+-16|0;o=c[t>>2]|0;f=m+-12|0;g=c[f>>2]|0;q=c[m+-8>>2]|0;k=q;if(g>>>0<q>>>0){c[g>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=o;c[f>>2]=(c[f>>2]|0)+16;q=r}else{f=c[n>>2]|0;q=g-f|0;j=q>>4;g=j+1|0;if((q|0)<-16){f=26;break b}f=k-f|0;if(f>>4>>>0<1073741823){f=f>>3;f=f>>>0<g>>>0?g:f}else f=2147483647;Qa(K,f,j,m+-4|0);q=c[u>>2]|0;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=o;c[u>>2]=q+16;Ra(n,K);Sa(K);q=r}while(1){if(q>>>0>=h>>>0){f=r;break d}m=c[(c[E>>2]|0)+-12>>2]|0;n=m+-16|0;o=c[e>>2]|0;p=o+(q*24|0)|0;f=m+-12|0;g=c[f>>2]|0;k=c[m+-8>>2]|0;j=k;if((g|0)==(k|0)){f=c[n>>2]|0;N=g-f|0;k=(N|0)/24|0;g=k+1|0;if((N|0)<-24){f=34;break b}f=(j-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<g>>>0?g:f}else f=2147483647;ab(K,f,k,m+-4|0);N=c[v>>2]|0;_a(N,p);_a(N+12|0,o+(q*24|0)+12|0);c[v>>2]=N+24;cb(n,K);bb(K)}else{_a(g,p);_a(g+12|0,o+(q*24|0)+12|0);c[f>>2]=(c[f>>2]|0)+24}q=q+1|0}}while(0);while(1){if(f>>>0>=h>>>0)break;N=a[L>>0]|0;if(((N&1)==0?(N&255)>>>1:c[D>>2]|0)>>>0>1)Ya(L,1429)|0;Cb(F,(c[e>>2]|0)+(f*24|0)|0);N=a[F>>0]|0;q=(N&1)==0;Za(L,q?x:c[w>>2]|0,q?(N&255)>>>1:c[y>>2]|0)|0;Ja(F);f=f+1|0}while(1){if((h|0)==(r|0)){n=s;continue b}g=c[H>>2]|0;f=g+-24|0;while(1){if((g|0)==(f|0))break;N=g+-24|0;c[H>>2]=N;Ia(N);g=c[H>>2]|0}h=h+-1|0}}if((f|0)==13)Pa();else if((f|0)==26)Pa();else if((f|0)==34)Pa();else if((f|0)==48){l=n+1|0;N=a[L>>0]|0;b=(N&1)==0;if((a[(b?L+1|0:c[L+8>>2]|0)+(b?(N&255)>>>1:c[D>>2]|0)+-1>>0]|0)==62)Ya(L,1432)|0;else Ya(L,844)|0;c[J>>2]=c[L>>2];c[J+4>>2]=c[L+4>>2];c[J+8>>2]=c[L+8>>2];f=0;while(1){if((f|0)==3)break;c[L+(f<<2)>>2]=0;f=f+1|0}rb(I,J);f=c[H>>2]|0;N=c[e+8>>2]|0;j=N;if(f>>>0<N>>>0){db(f,I);c[H>>2]=(c[H>>2]|0)+24}else{g=c[e>>2]|0;N=f-g|0;k=(N|0)/24|0;h=k+1|0;if((N|0)<-24)Pa();f=(j-g|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<h>>>0?h:f}else f=2147483647;ab(K,f,k,e+12|0);N=K+8|0;H=c[N>>2]|0;db(H,I);c[N>>2]=H+24;cb(e,K);bb(K)}Ia(I);Ja(J);Ja(L);break}else if((f|0)==62){Ja(L);l=b;break}}else l=b;while(0);i=M;return l|0}function Nb(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0;a:do if((b|0)!=(c|0))switch(a[b>>0]|0){case 88:{f=b+1|0;e=ub(f,c,d)|0;if((e|0)==(f|0)|(e|0)==(c|0))break a;b=(a[e>>0]|0)==69?e+1|0:b;break a}case 74:{e=b+1|0;if((e|0)==(c|0))break a;while(1){if((a[e>>0]|0)==69)break;f=Nb(e,c,d)|0;if((f|0)==(e|0))break a;else e=f}b=e+1|0;break a}case 76:{f=b+1|0;if((f|0)!=(c|0)?(a[f>>0]|0)==90:0){f=b+2|0;e=Ma(f,c,d)|0;if((e|0)==(f|0)|(e|0)==(c|0))break a;b=(a[e>>0]|0)==69?e+1|0:b;break a}b=vb(b,c,d)|0;break a}default:{b=Na(b,c,d)|0;break a}}while(0);return b|0}function Ob(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+96|0;o=p+72|0;n=p+56|0;k=p+48|0;l=p+32|0;g=p+24|0;m=p+8|0;h=p;a:do if((b|0)==(d|0))f=b;else switch(a[b>>0]|0){case 84:{j=e+4|0;h=((c[j>>2]|0)-(c[e>>2]|0)|0)/24|0;f=Eb(b,d,e)|0;d=c[j>>2]|0;g=(d-(c[e>>2]|0)|0)/24|0;if(!((f|0)!=(b|0)&(g|0)==(h+1|0))){f=d;while(1){if((g|0)==(h|0)){f=b;break a}d=f+-24|0;while(1){if((f|0)==(d|0))break;e=f+-24|0;c[j>>2]=e;Ia(e);f=c[j>>2]|0}f=d;g=g+-1|0}}b=e+16|0;c[k>>2]=c[e+12>>2];Pb(n,d+-24|0,k);d=e+20|0;g=c[d>>2]|0;m=c[e+24>>2]|0;h=m;if(g>>>0<m>>>0){c[g+12>>2]=c[n+12>>2];c[g>>2]=c[n>>2];e=n+4|0;c[g+4>>2]=c[e>>2];o=n+8|0;c[g+8>>2]=c[o>>2];c[o>>2]=0;c[e>>2]=0;c[n>>2]=0;c[d>>2]=(c[d>>2]|0)+16}else{d=c[b>>2]|0;m=g-d|0;j=m>>4;g=j+1|0;if((m|0)<-16)Pa();d=h-d|0;if(d>>4>>>0<1073741823){d=d>>3;d=d>>>0<g>>>0?g:d}else d=2147483647;Qa(o,d,j,e+28|0);e=o+8|0;m=c[e>>2]|0;c[m+12>>2]=c[n+12>>2];c[m>>2]=c[n>>2];l=n+4|0;c[m+4>>2]=c[l>>2];k=n+8|0;c[m+8>>2]=c[k>>2];c[k>>2]=0;c[l>>2]=0;c[n>>2]=0;c[e>>2]=m+16;Ra(b,o);Sa(o)}Ha(n);break a}case 68:{f=Qb(b,d,e)|0;if((f|0)==(b|0)){f=b;break a}d=c[e+4>>2]|0;if((c[e>>2]|0)==(d|0)){f=b;break a}b=e+16|0;c[g>>2]=c[e+12>>2];Pb(l,d+-24|0,g);d=e+20|0;g=c[d>>2]|0;n=c[e+24>>2]|0;j=n;if(g>>>0<n>>>0){c[g+12>>2]=c[l+12>>2];c[g>>2]=c[l>>2];e=l+4|0;c[g+4>>2]=c[e>>2];o=l+8|0;c[g+8>>2]=c[o>>2];c[o>>2]=0;c[e>>2]=0;c[l>>2]=0;c[d>>2]=(c[d>>2]|0)+16}else{d=c[b>>2]|0;n=g-d|0;h=n>>4;g=h+1|0;if((n|0)<-16)Pa();d=j-d|0;if(d>>4>>>0<1073741823){d=d>>3;d=d>>>0<g>>>0?g:d}else d=2147483647;Qa(o,d,h,e+28|0);e=o+8|0;n=c[e>>2]|0;c[n+12>>2]=c[l+12>>2];c[n>>2]=c[l>>2];m=l+4|0;c[n+4>>2]=c[m>>2];k=l+8|0;c[n+8>>2]=c[k>>2];c[k>>2]=0;c[m>>2]=0;c[l>>2]=0;c[e>>2]=n+16;Ra(b,o);Sa(o)}Ha(l);break a}case 83:{f=Rb(b,d,e)|0;if((f|0)!=(b|0))break a;if((d-b|0)<=2){f=b;break a}if((a[b+1>>0]|0)!=116){f=b;break a}n=b+2|0;f=Sb(n,d,e)|0;if((f|0)==(n|0)){f=b;break a}g=e+4|0;d=c[g>>2]|0;if((c[e>>2]|0)==(d|0)){f=b;break a}Ta(d+-24|0,0,1827)|0;b=e+16|0;d=(c[g>>2]|0)+-24|0;c[h>>2]=c[e+12>>2];Pb(m,d,h);d=e+20|0;g=c[d>>2]|0;n=c[e+24>>2]|0;h=n;if(g>>>0<n>>>0){c[g+12>>2]=c[m+12>>2];c[g>>2]=c[m>>2];e=m+4|0;c[g+4>>2]=c[e>>2];o=m+8|0;c[g+8>>2]=c[o>>2];c[o>>2]=0;c[e>>2]=0;c[m>>2]=0;c[d>>2]=(c[d>>2]|0)+16}else{d=c[b>>2]|0;n=g-d|0;j=n>>4;g=j+1|0;if((n|0)<-16)Pa();d=h-d|0;if(d>>4>>>0<1073741823){d=d>>3;d=d>>>0<g>>>0?g:d}else d=2147483647;Qa(o,d,j,e+28|0);e=o+8|0;n=c[e>>2]|0;c[n+12>>2]=c[m+12>>2];c[n>>2]=c[m>>2];l=m+4|0;c[n+4>>2]=c[l>>2];k=m+8|0;c[n+8>>2]=c[k>>2];c[k>>2]=0;c[l>>2]=0;c[m>>2]=0;c[e>>2]=n+16;Ra(b,o);Sa(o)}Ha(m);break a}default:{f=b;break a}}while(0);i=p;return f|0}function Pb(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[a>>2]=0;e=a+4|0;c[e>>2]=0;d=c[d>>2]|0;c[a+8>>2]=0;c[a+12>>2]=d;d=Da(d,24)|0;c[e>>2]=d;c[a>>2]=d;c[a+8>>2]=d+24;_a(d,b);_a(d+12|0,b+12|0);c[e>>2]=(c[e>>2]|0)+24;return}function Qb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;m=i;i=i+64|0;g=m+40|0;h=m+24|0;k=m+12|0;l=m;a:do if((d-b|0)>3?(a[b>>0]|0)==68:0){switch(a[b+1>>0]|0){case 84:case 116:break;default:break a}n=b+2|0;j=ub(n,d,e)|0;if((!((j|0)==(n|0)|(j|0)==(d|0))?(a[j>>0]|0)==69:0)?(f=c[e+4>>2]|0,(c[e>>2]|0)!=(f|0)):0){e=f+-24|0;Cb(l,e);b=Ta(l,0,1435)|0;c[k>>2]=c[b>>2];c[k+4>>2]=c[b+4>>2];c[k+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=Ya(k,799)|0;c[h>>2]=c[b>>2];c[h+4>>2]=c[b+4>>2];c[h+8>>2]=c[b+8>>2];f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}rb(g,h);Db(e,g);Ia(g);Ja(h);Ja(k);Ja(l);b=j+1|0}}while(0);i=m;return b|0}function Rb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+176|0;s=t+144|0;k=t+120|0;l=t+96|0;m=t+72|0;n=t+48|0;o=t+24|0;p=t;a:do if((d-b|0)>1?(a[b>>0]|0)==83:0){h=a[b+1>>0]|0;switch(h|0){case 97:{jb(k,1445);f=e+4|0;g=c[f>>2]|0;r=c[e+8>>2]|0;h=r;if(g>>>0<r>>>0){db(g,k);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;r=g-f|0;j=(r|0)/24|0;g=j+1|0;if((r|0)<-24)Pa();f=(h-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<g>>>0?g:f}else f=2147483647;ab(s,f,j,e+12|0);r=s+8|0;q=c[r>>2]|0;db(q,k);c[r>>2]=q+24;cb(e,s);bb(s)}Ia(k);r=b+2|0;break a}case 98:{ob(l,1460);f=e+4|0;g=c[f>>2]|0;r=c[e+8>>2]|0;h=r;if(g>>>0<r>>>0){db(g,l);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;r=g-f|0;j=(r|0)/24|0;g=j+1|0;if((r|0)<-24)Pa();f=(h-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<g>>>0?g:f}else f=2147483647;ab(s,f,j,e+12|0);r=s+8|0;q=c[r>>2]|0;db(q,l);c[r>>2]=q+24;cb(e,s);bb(s)}Ia(l);r=b+2|0;break a}case 115:{gb(m,1478);f=e+4|0;g=c[f>>2]|0;r=c[e+8>>2]|0;h=r;if(g>>>0<r>>>0){db(g,m);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;r=g-f|0;j=(r|0)/24|0;g=j+1|0;if((r|0)<-24)Pa();f=(h-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<g>>>0?g:f}else f=2147483647;ab(s,f,j,e+12|0);r=s+8|0;q=c[r>>2]|0;db(q,m);c[r>>2]=q+24;cb(e,s);bb(s)}Ia(m);r=b+2|0;break a}case 105:{lb(n,1490);f=e+4|0;g=c[f>>2]|0;r=c[e+8>>2]|0;j=r;if(g>>>0<r>>>0){db(g,n);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;r=g-f|0;h=(r|0)/24|0;g=h+1|0;if((r|0)<-24)Pa();f=(j-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<g>>>0?g:f}else f=2147483647;ab(s,f,h,e+12|0);r=s+8|0;q=c[r>>2]|0;db(q,n);c[r>>2]=q+24;cb(e,s);bb(s)}Ia(n);r=b+2|0;break a}case 111:{lb(o,1503);f=e+4|0;g=c[f>>2]|0;r=c[e+8>>2]|0;h=r;if(g>>>0<r>>>0){db(g,o);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;r=g-f|0;j=(r|0)/24|0;g=j+1|0;if((r|0)<-24)Pa();f=(h-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<g>>>0?g:f}else f=2147483647;ab(s,f,j,e+12|0);r=s+8|0;q=c[r>>2]|0;db(q,o);c[r>>2]=q+24;cb(e,s);bb(s)}Ia(o);r=b+2|0;break a}case 100:{hb(p,1516);f=e+4|0;g=c[f>>2]|0;r=c[e+8>>2]|0;h=r;if(g>>>0<r>>>0){db(g,p);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;r=g-f|0;j=(r|0)/24|0;g=j+1|0;if((r|0)<-24)Pa();f=(h-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<g>>>0?g:f}else f=2147483647;ab(s,f,j,e+12|0);r=s+8|0;q=c[r>>2]|0;db(q,p);c[r>>2]=q+24;cb(e,s);bb(s)}Ia(p);r=b+2|0;break a}case 95:{f=c[e+16>>2]|0;if((f|0)==(c[e+20>>2]|0)){r=b;break a}m=c[f+4>>2]|0;n=e+4|0;o=e+8|0;p=e+12|0;d=s+8|0;l=c[f>>2]|0;while(1){if((l|0)==(m|0)){f=55;break}f=c[n>>2]|0;q=c[o>>2]|0;g=q;if((f|0)==(q|0)){h=c[e>>2]|0;q=f-h|0;k=(q|0)/24|0;j=k+1|0;if((q|0)<-24){f=59;break}f=(g-h|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<j>>>0?j:f}else f=2147483647;ab(s,f,k,p);q=c[d>>2]|0;_a(q,l);_a(q+12|0,l+12|0);c[d>>2]=q+24;cb(e,s);bb(s)}else{_a(f,l);_a(f+12|0,l+12|0);c[n>>2]=(c[n>>2]|0)+24}l=l+24|0}if((f|0)==55){r=b+2|0;break a}else if((f|0)==59)Pa();break}default:{g=h+-48|0;f=g>>>0<10;if(!f?(gc(h)|0)==0:0){r=b;break a}k=f?g:h+-55|0;q=b+2|0;while(1){if((q|0)==(d|0)){r=b;break a}f=a[q>>0]|0;g=f<<24>>24;j=g+-48|0;h=j>>>0<10;if(!h?(gc(g)|0)==0:0)break;k=(h?j:g+-55|0)+(k*36|0)|0;q=q+1|0}if(f<<24>>24!=95){r=b;break a}f=k+1|0;d=c[e+16>>2]|0;g=d;if(f>>>0>=(c[e+20>>2]|0)-d>>4>>>0){r=b;break a}m=c[g+(f<<4)+4>>2]|0;n=e+4|0;o=e+8|0;p=e+12|0;d=s+8|0;l=c[g+(f<<4)>>2]|0;while(1){if((l|0)==(m|0)){f=75;break}f=c[n>>2]|0;b=c[o>>2]|0;g=b;if((f|0)==(b|0)){h=c[e>>2]|0;b=f-h|0;k=(b|0)/24|0;j=k+1|0;if((b|0)<-24){f=79;break}f=(g-h|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<j>>>0?j:f}else f=2147483647;ab(s,f,k,p);b=c[d>>2]|0;_a(b,l);_a(b+12|0,l+12|0);c[d>>2]=b+24;cb(e,s);bb(s)}else{_a(f,l);_a(f+12|0,l+12|0);c[n>>2]=(c[n>>2]|0)+24}l=l+24|0}if((f|0)==75){r=q+1|0;break a}else if((f|0)==79)Pa()}}}else r=b;while(0);i=t;return r|0}
function sa(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+15&-16;return b|0}function ta(){return i|0}function ua(a){a=a|0;i=a}function va(a,b){a=a|0;b=b|0;i=a;j=b}function wa(a,b){a=a|0;b=b|0;if(!n){n=a;o=b}}function xa(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function ya(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function za(a){a=a|0;C=a}function Aa(){return C|0}function Ba(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;v=i;i=i+4208|0;t=v+4176|0;h=v;u=v+4112|0;if((b|0)!=0?(g=(d|0)!=0,s=(e|0)==0,!(g&s)):0){if(g)q=c[e>>2]|0;else q=0;c[h+4096>>2]=h;g=h;c[u>>2]=0;r=u+4|0;c[r>>2]=0;c[u+8>>2]=0;c[u+12>>2]=g;l=u+16|0;c[l>>2]=0;m=u+20|0;c[m>>2]=0;c[u+24>>2]=0;c[u+28>>2]=g;c[u+32>>2]=0;h=u+36|0;c[h>>2]=0;c[u+40>>2]=0;n=u+44|0;c[n>>2]=g;k=u+48|0;j=u+61|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;a[k+12>>0]=0;a[j>>0]=1;k=u+32|0;Ca(t,1,0,n);n=t+8|0;o=c[n>>2]|0;c[o>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=g;c[n>>2]=o+16;Ea(k,t);Fa(t);n=u+62|0;a[n>>0]=0;a[u+63>>0]=1;c[t>>2]=0;o=b+(bc(b)|0)|0;La(b,o,u,t);g=c[t>>2]|0;do if(!((g|0)!=0|(a[n>>0]|0)==0)){k=c[k>>2]|0;if((k|0)!=(c[h>>2]|0)?(c[k>>2]|0)!=(c[k+4>>2]|0):0){a[n>>0]=0;a[j>>0]=0;g=c[u>>2]|0;while(1){h=c[r>>2]|0;if((h|0)==(g|0))break;k=h+-24|0;c[r>>2]=k;Ia(k)}g=c[l>>2]|0;while(1){h=c[m>>2]|0;if((h|0)==(g|0))break;l=h+-16|0;c[m>>2]=l;Ha(l)}La(b,o,u,t);if(!(a[n>>0]|0)){g=c[t>>2]|0;p=19;break}else{c[t>>2]=-2;d=0;g=-2;break}}else p=20}else p=19;while(0);if((p|0)==19)if(!g)p=20;else d=0;do if((p|0)==20){h=c[r>>2]|0;g=a[h+-24>>0]|0;if(!(g&1))j=(g&255)>>>1;else j=c[h+-20>>2]|0;g=a[h+-12>>0]|0;if(!(g&1))g=(g&255)>>>1;else g=c[h+-8>>2]|0;j=g+j|0;g=j+1|0;if(g>>>0>q>>>0){d=xc(d,g)|0;if(!d){c[t>>2]=-1;d=0;g=-1;break}if(!s)c[e>>2]=g}else if(!d){d=0;g=0;break}g=c[r>>2]|0;t=g+-12|0;h=a[t>>0]|0;e=(h&1)==0;Za(g+-24|0,e?t+1|0:c[g+-4>>2]|0,e?(h&255)>>>1:c[g+-8>>2]|0)|0;g=c[r>>2]|0;h=g+-24|0;if(!(a[h>>0]&1))g=h+1|0;else g=c[g+-16>>2]|0;Fc(d|0,g|0,j|0)|0;a[d+j>>0]=0;g=0}while(0);if(f)c[f>>2]=g;_b(u)}else if(!f)d=0;else{c[f>>2]=-3;d=0}i=v;return d|0}function Ca(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Da(c[e>>2]|0,b<<4)|0;c[a>>2]=e;d=e+(d<<4)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<4);return}function Da(a,b){a=a|0;b=b|0;var d=0,e=0;d=b+15&-16;e=a+4096|0;b=c[e>>2]|0;if((a+4096-b|0)>>>0<d>>>0)b=vc(d)|0;else c[e>>2]=b+d;return b|0}function Ea(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=c[a>>2]|0;f=a+4|0;g=b+4|0;d=c[f>>2]|0;while(1){if((d|0)==(e|0))break;k=c[g>>2]|0;i=k+-16|0;h=d+-16|0;c[i>>2]=0;j=k+-12|0;c[j>>2]=0;l=c[d+-4>>2]|0;c[k+-8>>2]=0;c[k+-4>>2]=l;c[i>>2]=c[h>>2];i=d+-12|0;c[j>>2]=c[i>>2];j=d+-8|0;c[k+-8>>2]=c[j>>2];c[j>>2]=0;c[i>>2]=0;c[h>>2]=0;c[g>>2]=(c[g>>2]|0)+-16;d=h}j=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=j;j=b+8|0;l=c[f>>2]|0;c[f>>2]=c[j>>2];c[j>>2]=l;j=a+8|0;l=b+12|0;k=c[j>>2]|0;c[j>>2]=c[l>>2];c[l>>2]=k;c[b>>2]=c[g>>2];return}function Fa(a){a=a|0;var b=0,d=0,e=0;b=c[a+4>>2]|0;d=a+8|0;while(1){e=c[d>>2]|0;if((e|0)==(b|0))break;e=e+-16|0;c[d>>2]=e;Ga(e)}b=c[a>>2]|0;if(b)Ka(c[c[a+16>>2]>>2]|0,b,(c[a+12>>2]|0)-b|0);return}function Ga(a){a=a|0;var b=0,d=0,e=0;b=c[a>>2]|0;if(b){d=a+4|0;while(1){e=c[d>>2]|0;if((e|0)==(b|0))break;e=e+-16|0;c[d>>2]=e;Ha(e)}e=c[a>>2]|0;Ka(c[a+12>>2]|0,e,(c[a+8>>2]|0)-e|0)}return}function Ha(a){a=a|0;var b=0,d=0,e=0;b=c[a>>2]|0;if(b){d=a+4|0;while(1){e=c[d>>2]|0;if((e|0)==(b|0))break;e=e+-24|0;c[d>>2]=e;Ia(e)}e=c[a>>2]|0;Ka(c[a+12>>2]|0,e,(c[a+8>>2]|0)-e|0)}return}function Ia(a){a=a|0;Ja(a+12|0);Ja(a);return}function Ja(b){b=b|0;if(a[b>>0]&1)wc(c[b+8>>2]|0);return}function Ka(a,b,d){a=a|0;b=b|0;d=d|0;if(a>>>0<=b>>>0&(a+4096|0)>>>0>=b>>>0){a=a+4096|0;if((b+(d+15&-16)|0)==(c[a>>2]|0))c[a>>2]=b}else wc(b);return}function La(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+48|0;l=o+24|0;m=o+12|0;n=o;a:do if(b>>>0<d>>>0){b:do if((a[b>>0]|0)!=95){if((Na(b,d,e)|0)!=(d|0)){c[f>>2]=-2;break a}}else{h=d;if((h-b|0)<=3){c[f>>2]=-2;break a}switch(a[b+1>>0]|0){case 90:{k=b+2|0;b=Ma(k,d,e)|0;if(!((b|0)==(k|0)|(b|0)==(d|0))?(a[b>>0]|0)==46:0){g=c[e+4>>2]|0;if((c[e>>2]|0)!=(g|0)){k=g+-24|0;h=h-b|0;if(h>>>0>4294967279)Xa();if(h>>>0<11){a[n>>0]=h<<1;j=n+1|0}else{g=h+16&-16;j=vc(g)|0;c[n+8>>2]=j;c[n>>2]=g|1;c[n+4>>2]=h}g=j;while(1){if((b|0)==(d|0))break;a[g>>0]=a[b>>0]|0;b=b+1|0;g=g+1|0}a[j+h>>0]=0;b=Ta(n,0,849)|0;c[m>>2]=c[b>>2];c[m+4>>2]=c[b+4>>2];c[m+8>>2]=c[b+8>>2];g=0;while(1){if((g|0)==3)break;c[b+(g<<2)>>2]=0;g=g+1|0}b=Ya(m,799)|0;c[l>>2]=c[b>>2];c[l+4>>2]=c[b+4>>2];c[l+8>>2]=c[b+8>>2];g=0;while(1){if((g|0)==3)break;c[b+(g<<2)>>2]=0;g=g+1|0}b=a[l>>0]|0;j=(b&1)==0;Za(k,j?l+1|0:c[l+8>>2]|0,j?(b&255)>>>1:c[l+4>>2]|0)|0;Ja(l);Ja(m);Ja(n);b=d}}if((b|0)==(d|0))break b;c[f>>2]=-2;break a}case 95:{if((a[b+2>>0]|0)==95?(a[b+3>>0]|0)==90:0){n=b+4|0;b=Ma(n,d,e)|0;if((b|0)==(n|0)|(b|0)==(d|0)){c[f>>2]=-2;break a}c:do if((h-b|0)>12){h=0;g=b;while(1){if((h|0)>=13)break;if((a[g>>0]|0)!=(a[2320+h>>0]|0))break c;h=h+1|0;g=g+1|0}d:do if((g|0)==(d|0))g=d;else{if((a[g>>0]|0)==95){h=g+1|0;if((h|0)==(d|0))break c;if(((a[h>>0]|0)+-48|0)>>>0>=10)break c;g=g+2|0}while(1){if((g|0)==(d|0)){g=d;break d}if(((a[g>>0]|0)+-48|0)>>>0>=10)break d;g=g+1|0}}while(0);h=c[e+4>>2]|0;if((c[e>>2]|0)!=(h|0)){Ta(h+-24|0,0,2334)|0;b=g}}while(0);if((b|0)==(d|0))break b;c[f>>2]=-2;break a}break}default:{}}c[f>>2]=-2;break a}while(0);if((c[f>>2]|0)==0?(c[e>>2]|0)==(c[e+4>>2]|0):0)c[f>>2]=-2}else c[f>>2]=-2;while(0);i=o;return}function Ma(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;E=i;i=i+80|0;z=E+60|0;y=E+48|0;r=E+36|0;s=E+24|0;t=E+12|0;w=E;a:do if((b|0)==(d|0))f=b;else{B=e+56|0;C=c[B>>2]|0;x=C+1|0;c[B>>2]=x;D=e+61|0;A=a[D>>0]|0;if(x>>>0>1)a[D>>0]=1;f=a[b>>0]|0;b:do switch(f|0){case 84:case 71:{c:do if((d-b|0)>2){switch(f|0){case 84:break;case 71:switch(a[b+1>>0]|0){case 86:{z=b+2|0;f=Wb(z,d,e)|0;if((f|0)==(z|0)){f=b;break c}g=c[e+4>>2]|0;if((c[e>>2]|0)==(g|0)){f=b;break c}Ta(g+-24|0,0,2275)|0;break c}case 82:{z=b+2|0;f=Wb(z,d,e)|0;if((f|0)==(z|0)){f=b;break c}g=c[e+4>>2]|0;if((c[e>>2]|0)==(g|0)){f=b;break c}Ta(g+-24|0,0,2295)|0;break c}default:{f=b;break c}}default:{f=b;break c}}f=b+1|0;switch(a[f>>0]|0){case 86:{z=b+2|0;f=Na(z,d,e)|0;if((f|0)==(z|0)){f=b;break c}g=c[e+4>>2]|0;if((c[e>>2]|0)==(g|0)){f=b;break c}Ta(g+-24|0,0,2124)|0;break c}case 84:{z=b+2|0;f=Na(z,d,e)|0;if((f|0)==(z|0)){f=b;break c}g=c[e+4>>2]|0;if((c[e>>2]|0)==(g|0)){f=b;break c}Ta(g+-24|0,0,2136)|0;break c}case 73:{z=b+2|0;f=Na(z,d,e)|0;if((f|0)==(z|0)){f=b;break c}g=c[e+4>>2]|0;if((c[e>>2]|0)==(g|0)){f=b;break c}Ta(g+-24|0,0,2145)|0;break c}case 83:{z=b+2|0;f=Na(z,d,e)|0;if((f|0)==(z|0)){f=b;break c}g=c[e+4>>2]|0;if((c[e>>2]|0)==(g|0)){f=b;break c}Ta(g+-24|0,0,2159)|0;break c}case 99:{z=b+2|0;f=Zb(z,d)|0;if((f|0)==(z|0)){f=b;break c}g=Zb(f,d)|0;if((g|0)==(f|0)){f=b;break c}f=Ma(g,d,e)|0;if((f|0)==(g|0)){f=b;break c}g=c[e+4>>2]|0;if((c[e>>2]|0)==(g|0)){f=b;break c}Ta(g+-24|0,0,2178)|0;break c}case 67:{x=b+2|0;f=Na(x,d,e)|0;if((f|0)==(x|0)){f=b;break c}g=tb(f,d)|0;if((g|0)==(f|0)|(g|0)==(d|0)){f=b;break c}if((a[g>>0]|0)!=95){f=b;break c}x=g+1|0;f=Na(x,d,e)|0;if((f|0)==(x|0)){f=b;break c}j=e+4|0;g=c[j>>2]|0;if(((g-(c[e>>2]|0)|0)/24|0)>>>0<2){f=b;break c}Cb(z,g+-24|0);k=c[j>>2]|0;g=k+-24|0;h=k;while(1){if((h|0)==(g|0))break;b=h+-24|0;c[j>>2]=b;Ia(b);h=c[j>>2]|0}q=k+-48|0;g=Ta(z,0,2205)|0;c[s>>2]=c[g>>2];c[s+4>>2]=c[g+4>>2];c[s+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}g=Ya(s,2230)|0;c[r>>2]=c[g>>2];c[r+4>>2]=c[g+4>>2];c[r+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}Cb(t,(c[j>>2]|0)+-24|0);g=a[t>>0]|0;h=(g&1)==0;g=Za(r,h?t+1|0:c[t+8>>2]|0,h?(g&255)>>>1:c[t+4>>2]|0)|0;c[y>>2]=c[g>>2];c[y+4>>2]=c[g+4>>2];c[y+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}do if(a[q>>0]&1){p=k+-40|0;a[c[p>>2]>>0]=0;m=k+-44|0;c[m>>2]=0;g=a[q>>0]|0;if(!(g&1))l=10;else{l=c[q>>2]|0;g=l&255;l=(l&-2)+-1|0}if(!(g&1)){h=(g&255)>>>1;if((g&255)<22){k=10;n=h;o=1}else{k=(h+16&240)+-1|0;n=h;o=1}}else{k=10;n=0;o=0}if((k|0)!=(l|0)){if((k|0)==10){j=q+1|0;h=c[p>>2]|0;if(o){Fc(j|0,h|0,((g&255)>>>1)+1|0)|0;wc(h)}else{a[j>>0]=a[h>>0]|0;wc(h)}a[q>>0]=n<<1;break}h=k+1|0;j=vc(h)|0;if(!(k>>>0<=l>>>0&(j|0)==0)){if(o)Fc(j|0,q+1|0,((g&255)>>>1)+1|0)|0;else{b=c[p>>2]|0;a[j>>0]=a[b>>0]|0;wc(b)}c[q>>2]=h|1;c[m>>2]=n;c[p>>2]=j}}}else{a[q+1>>0]=0;a[q>>0]=0}while(0);c[q>>2]=c[y>>2];c[q+4>>2]=c[y+4>>2];c[q+8>>2]=c[y+8>>2];g=0;while(1){if((g|0)==3)break;c[y+(g<<2)>>2]=0;g=g+1|0}Ja(y);Ja(t);Ja(r);Ja(s);Ja(z);break c}default:{g=Zb(f,d)|0;if((g|0)==(f|0)){f=b;break c}f=Ma(g,d,e)|0;if((f|0)==(g|0)){f=b;break c}g=c[e+4>>2]|0;if((c[e>>2]|0)==(g|0)){f=b;break c}g=g+-24|0;if((a[b+2>>0]|0)==118){Ta(g,0,2235)|0;break c}else{Ta(g,0,2253)|0;break c}}}}else f=b;while(0);break}default:{f=Wb(b,d,e)|0;u=c[e+48>>2]|0;v=c[e+52>>2]|0;if((f|0)!=(b|0))if((f|0)!=(d|0)){switch(a[f>>0]|0){case 46:case 69:break b;default:{}}x=a[D>>0]|0;a[D>>0]=0;g=0;while(1){if((g|0)==3)break;c[z+(g<<2)>>2]=0;g=g+1|0}t=e+4|0;m=c[t>>2]|0;d:do if((c[e>>2]|0)!=(m|0)){l=m+-24|0;j=a[l>>0]|0;k=(j&1)==0;if(k)g=(j&255)>>>1;else g=c[m+-20>>2]|0;if(g){if(!(a[e+60>>0]|0)){if(k){g=l+1|0;h=(j&255)>>>1}else{g=c[m+-16>>2]|0;h=c[m+-20>>2]|0}if((a[g+h+-1>>0]|0)==62){if(k){g=(j&255)>>>1;h=l+1|0}else{g=c[m+-20>>2]|0;h=c[m+-16>>2]|0}if((a[h+(g+-2)>>0]|0)!=45){if(k){h=(j&255)>>>1;g=l+1|0}else{h=c[m+-20>>2]|0;g=c[m+-16>>2]|0}if((a[g+(h+-2)>>0]|0)!=62){o=Na(f,d,e)|0;if((o|0)==(f|0)){f=b;g=0;break}s=c[t>>2]|0;f=s;if(((s-(c[e>>2]|0)|0)/24|0)>>>0<2){f=b;g=0;break}g=f+-24|0;c[y>>2]=c[g>>2];c[y+4>>2]=c[g+4>>2];c[y+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}n=f+-12|0;e:do if(!(a[z>>0]&1)){a[z+1>>0]=0;a[z>>0]=0}else{k=z+8|0;g=c[k>>2]|0;a[g>>0]=0;l=z+4|0;c[l>>2]=0;f=c[z>>2]|0;m=(f&-2)+-1|0;h=f&255;do if(!(h&1)){f=f>>>1&127;if((h&255)<22){Fc(z+1|0,g|0,f+1|0)|0;wc(g);break}g=f+16&240;j=g+-1|0;if((j|0)==(m|0))break e;h=vc(g)|0;if(j>>>0<=m>>>0&(h|0)==0)break e;Fc(h|0,z+1|0,f+1|0)|0;c[z>>2]=g|1;c[l>>2]=f;c[k>>2]=h;break e}else{a[z+1>>0]=0;wc(g);f=0}while(0);a[z>>0]=f<<1}while(0);c[z>>2]=c[n>>2];c[z+4>>2]=c[n+4>>2];c[z+8>>2]=c[n+8>>2];f=0;while(1){if((f|0)==3)break;c[n+(f<<2)>>2]=0;f=f+1|0}s=a[z>>0]|0;if(!(((s&1)==0?(s&255)>>>1:c[z+4>>2]|0)|0))zb(y,32);f=c[t>>2]|0;g=f+-24|0;h=f;while(1){if((h|0)==(g|0))break;s=h+-24|0;c[t>>2]=s;Ia(s);h=c[t>>2]|0}g=a[y>>0]|0;s=(g&1)==0;Ua(f+-48|0,0,s?y+1|0:c[y+8>>2]|0,s?(g&255)>>>1:c[y+4>>2]|0)|0;Ja(y);g=c[t>>2]|0;f=o}else g=m}else g=m}else g=m}else g=m;zb(g+-24|0,40);if((f|0)!=(d|0)?(a[f>>0]|0)==118:0){h=c[e>>2]|0;g=c[t>>2]|0;f=f+1|0}else p=128;do if((p|0)==128){n=y+4|0;o=w+8|0;p=w+1|0;q=w+4|0;r=y+8|0;s=y+1|0;l=1;f:while(1){h=c[e>>2]|0;g=c[t>>2]|0;while(1){j=(g-h|0)/24|0;m=Na(f,d,e)|0;g=c[t>>2]|0;h=c[e>>2]|0;k=(g-h|0)/24|0;if((m|0)==(f|0)){p=151;break f}if(k>>>0>j>>>0)break;else f=m}f=0;while(1){if((f|0)==3){f=j;break}c[y+(f<<2)>>2]=0;f=f+1|0}while(1){if(f>>>0>=k>>>0){h=j;break}h=a[y>>0]|0;if(((h&1)==0?(h&255)>>>1:c[n>>2]|0)|0)Ya(y,1429)|0;Cb(w,(c[e>>2]|0)+(f*24|0)|0);h=a[w>>0]|0;g=(h&1)==0;Za(y,g?p:c[o>>2]|0,g?(h&255)>>>1:c[q>>2]|0)|0;Ja(w);f=f+1|0}while(1){if(h>>>0>=k>>>0)break;g=c[t>>2]|0;f=g+-24|0;while(1){if((g|0)==(f|0))break;j=g+-24|0;c[t>>2]=j;Ia(j);g=c[t>>2]|0}h=h+1|0}h=a[y>>0]|0;f=c[n>>2]|0;if(!(((h&1)==0?(h&255)>>>1:f)|0))f=l;else{g=c[t>>2]|0;if((c[e>>2]|0)==(g|0)){p=163;break}if(!l){Ya(g+-24|0,1429)|0;g=c[t>>2]|0;h=a[y>>0]|0;f=c[n>>2]|0}l=(h&1)==0;Za(g+-24|0,l?s:c[r>>2]|0,l?(h&255)>>>1:f)|0;f=0}Ja(y);l=f;f=m}if((p|0)==151)break;else if((p|0)==163){Ja(y);f=b;g=0;break d}}while(0);if((h|0)!=(g|0)){zb(g+-24|0,41);if(u&1)Ya((c[t>>2]|0)+-24|0,267)|0;if(u&2)Ya((c[t>>2]|0)+-24|0,456)|0;if(u&4)Ya((c[t>>2]|0)+-24|0,466)|0;switch(v|0){case 1:{Ya((c[t>>2]|0)+-24|0,2032)|0;break}case 2:{Ya((c[t>>2]|0)+-24|0,2035)|0;break}default:{}}g=a[z>>0]|0;y=(g&1)==0;Za((c[t>>2]|0)+-24|0,y?z+1|0:c[z+8>>2]|0,y?(g&255)>>>1:c[z+4>>2]|0)|0;g=1}else{f=b;g=0}}else{f=b;g=0}}else{f=b;g=0}while(0);Ja(z);a[D>>0]=x;if(!g){a[D>>0]=A;c[B>>2]=C;f=b;break a}}else f=d;else f=b}}while(0);a[D>>0]=A;c[B>>2]=C}while(0);i=E;return f|0}function Na(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0;za=i;i=i+736|0;ya=za+704|0;xa=za+680|0;la=za+668|0;ca=za+656|0;fa=za+632|0;pa=za+608|0;sa=za+584|0;ia=za+572|0;oa=za+560|0;qa=za+548|0;ra=za+536|0;$=za+384|0;ja=za+520|0;ha=za+512|0;A=za+496|0;o=za+488|0;S=za+472|0;O=za+464|0;B=za+448|0;p=za+440|0;na=za+424|0;ma=za+420|0;T=za+408|0;da=za+396|0;ea=za+372|0;U=za+360|0;X=za+344|0;V=za+340|0;t=za+328|0;v=za+304|0;w=za+288|0;x=za+276|0;y=za+264|0;E=za+240|0;F=za+228|0;G=za+216|0;H=za+204|0;I=za+192|0;L=za+168|0;M=za+156|0;N=za+144|0;W=za+128|0;R=za+120|0;z=za+104|0;n=za+96|0;D=za+80|0;s=za+72|0;C=za+56|0;r=za+48|0;ga=za+32|0;ba=za+24|0;wa=za+8|0;va=za;a:do if((d|0)!=(e|0)){switch(a[d>>0]|0){case 75:case 86:case 114:{c[xa>>2]=0;h=Oa(d,e,xa)|0;b:do if((h|0)!=(d|0)?(j=a[h>>0]|0,Z=f+4|0,q=((c[Z>>2]|0)-(c[f>>2]|0)|0)/24|0,Y=Na(h,e,f)|0,Z=((c[Z>>2]|0)-(c[f>>2]|0)|0)/24|0,(Y|0)!=(h|0)):0){v=j<<24>>24==70;w=f+20|0;h=c[w>>2]|0;c:do if(v){j=h+-16|0;while(1){if((h|0)==(j|0)){h=j;break c}d=h+-16|0;c[w>>2]=d;Ha(d);h=c[w>>2]|0}}while(0);n=f+16|0;o=c[f+12>>2]|0;d=c[f+24>>2]|0;j=d;if(h>>>0<d>>>0){c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=o;c[w>>2]=(c[w>>2]|0)+16}else{k=c[n>>2]|0;d=h-k|0;m=d>>4;l=m+1|0;if((d|0)<-16)Pa();h=j-k|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<l>>>0?l:h}else h=2147483647;Qa(ya,h,m,f+28|0);d=ya+8|0;e=c[d>>2]|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=o;c[d>>2]=e+16;Ra(n,ya);Sa(ya)}t=c[xa>>2]|0;r=(t&1|0)==0;s=(t&2|0)==0;t=(t&4|0)==0;u=ya+8|0;while(1){if(q>>>0>=Z>>>0){g=Y;break b}if(v){k=c[f>>2]|0;o=k+(q*24|0)+12|0;l=a[o>>0]|0;h=(l&1)==0;if(h){m=(l&255)>>>1;j=o+1|0}else{m=c[k+(q*24|0)+16>>2]|0;j=c[k+(q*24|0)+20>>2]|0}n=m+-2|0;if((a[j+n>>0]|0)==38)h=m+-3|0;else{if(h){j=o+1|0;h=(l&255)>>>1}else{j=c[k+(q*24|0)+20>>2]|0;h=c[k+(q*24|0)+16>>2]|0}h=(a[j+h+-1>>0]|0)==38?n:m}if(!r){Ta(o,h,267)|0;h=h+6|0}if(!s){Ta((c[f>>2]|0)+(q*24|0)+12|0,h,456)|0;h=h+9|0}if(!t)Ta((c[f>>2]|0)+(q*24|0)+12|0,h,466)|0}else{if(!r)Ya((c[f>>2]|0)+(q*24|0)|0,267)|0;if(!s)Ya((c[f>>2]|0)+(q*24|0)|0,456)|0;if(!t)Ya((c[f>>2]|0)+(q*24|0)|0,466)|0}m=c[w>>2]|0;n=m+-16|0;o=c[f>>2]|0;p=o+(q*24|0)|0;h=m+-12|0;j=c[h>>2]|0;d=c[m+-8>>2]|0;k=d;if((j|0)==(d|0)){h=c[n>>2]|0;d=j-h|0;l=(d|0)/24|0;j=l+1|0;if((d|0)<-24)break;h=(k-h|0)/24|0;if(h>>>0<1073741823){h=h<<1;h=h>>>0<j>>>0?j:h}else h=2147483647;ab(ya,h,l,m+-4|0);d=c[u>>2]|0;_a(d,p);_a(d+12|0,o+(q*24|0)+12|0);c[u>>2]=d+24;cb(n,ya);bb(ya)}else{_a(j,p);_a(j+12|0,o+(q*24|0)+12|0);c[h>>2]=(c[h>>2]|0)+24}q=q+1|0}Pa()}else g=d;while(0);break a}default:{}}g=eb(d,e,f)|0;if((g|0)==(d|0)){h=a[d>>0]|0;d:do switch(h<<24>>24|0){case 65:{do if(h<<24>>24==65?(u=d+1|0,(u|0)!=(e|0)):0){g=a[u>>0]|0;if(g<<24>>24==95){xa=d+2|0;g=Na(xa,e,f)|0;if((g|0)==(xa|0)){g=d;break}h=f+4|0;j=c[h>>2]|0;if((c[f>>2]|0)==(j|0)){g=d;break}e=j+-12|0;wa=a[e>>0]|0;xa=(wa&1)==0;wa=xa?(wa&255)>>>1:c[j+-8>>2]|0;$a(ya,xa?e+1|0:c[j+-4>>2]|0,wa>>>0<2?wa:2);wa=a[ya>>0]|0;e=(wa&1)==0;wa=e?(wa&255)>>>1:c[ya+4>>2]|0;xa=wa>>>0>2;e=ac(e?ya+1|0:c[ya+8>>2]|0,790,xa?2:wa)|0;Ja(ya);if(!(((e|0)==0?(wa>>>0<2?-1:xa&1):e)|0))sb((c[h>>2]|0)+-12|0);Ta((c[h>>2]|0)+-12|0,0,793)|0;break}if((g+-49&255)<9){m=tb(u,e)|0;if((m|0)==(e|0)){g=d;break}if((a[m>>0]|0)!=95){g=d;break}wa=m+1|0;g=Na(wa,e,f)|0;if((g|0)==(wa|0)){g=d;break}h=f+4|0;j=c[h>>2]|0;if((c[f>>2]|0)==(j|0)){g=d;break}e=j+-12|0;va=a[e>>0]|0;wa=(va&1)==0;va=wa?(va&255)>>>1:c[j+-8>>2]|0;$a(xa,wa?e+1|0:c[j+-4>>2]|0,va>>>0<2?va:2);va=a[xa>>0]|0;e=(va&1)==0;va=e?(va&255)>>>1:c[xa+4>>2]|0;wa=va>>>0>2;e=ac(e?xa+1|0:c[xa+8>>2]|0,790,wa?2:va)|0;Ja(xa);if(!(((e|0)==0?(va>>>0<2?-1:wa&1):e)|0))sb((c[h>>2]|0)+-12|0);n=(c[h>>2]|0)+-12|0;k=m-u|0;if(k>>>0>4294967279)Xa();if(k>>>0<11){a[fa>>0]=k<<1;l=fa+1|0}else{e=k+16&-16;l=vc(e)|0;c[fa+8>>2]=l;c[fa>>2]=e|1;c[fa+4>>2]=k}h=u;j=l;while(1){if((h|0)==(m|0))break;a[j>>0]=a[h>>0]|0;h=h+1|0;j=j+1|0}a[l+k>>0]=0;h=Ta(fa,0,790)|0;c[ca>>2]=c[h>>2];c[ca+4>>2]=c[h+4>>2];c[ca+8>>2]=c[h+8>>2];j=0;while(1){if((j|0)==3)break;c[h+(j<<2)>>2]=0;j=j+1|0}h=Ya(ca,4264)|0;c[la>>2]=c[h>>2];c[la+4>>2]=c[h+4>>2];c[la+8>>2]=c[h+8>>2];j=0;while(1){if((j|0)==3)break;c[h+(j<<2)>>2]=0;j=j+1|0}e=a[la>>0]|0;xa=(e&1)==0;Ua(n,0,xa?la+1|0:c[la+8>>2]|0,xa?(e&255)>>>1:c[la+4>>2]|0)|0;Ja(la);Ja(ca);Ja(fa);break}g=ub(u,e,f)|0;if(((!((g|0)==(u|0)|(g|0)==(e|0))?(a[g>>0]|0)==95:0)?(xa=g+1|0,aa=Na(xa,e,f)|0,(aa|0)!=(xa|0)):0)?(P=f+4|0,m=c[P>>2]|0,((m-(c[f>>2]|0)|0)/24|0)>>>0>=2):0){db(pa,m+-24|0);g=c[P>>2]|0;h=g+-24|0;j=g;while(1){if((j|0)==(h|0))break;e=j+-24|0;c[P>>2]=e;Ia(e);j=c[P>>2]|0}db(sa,g+-48|0);g=c[P>>2]|0;q=g+-24|0;do if(a[q>>0]&1){p=g+-16|0;a[c[p>>2]>>0]=0;m=g+-20|0;c[m>>2]=0;g=a[q>>0]|0;if(!(g&1))l=10;else{l=c[q>>2]|0;g=l&255;l=(l&-2)+-1|0}if(!(g&1)){h=(g&255)>>>1;if((g&255)<22){o=1;k=10;n=h}else{o=1;k=(h+16&240)+-1|0;n=h}}else{o=0;k=10;n=0}if((k|0)!=(l|0)){if((k|0)==10){j=q+1|0;h=c[p>>2]|0;if(o){Fc(j|0,h|0,((g&255)>>>1)+1|0)|0;wc(h)}else{a[j>>0]=a[h>>0]|0;wc(h)}a[q>>0]=n<<1;break}h=k+1|0;j=vc(h)|0;if(!(k>>>0<=l>>>0&(j|0)==0)){if(o)Fc(j|0,q+1|0,((g&255)>>>1)+1|0)|0;else{e=c[p>>2]|0;a[j>>0]=a[e>>0]|0;wc(e)}c[q>>2]=h|1;c[m>>2]=n;c[p>>2]=j}}}else{a[q+1>>0]=0;a[q>>0]=0}while(0);c[q>>2]=c[pa>>2];c[q+4>>2]=c[pa+4>>2];c[q+8>>2]=c[pa+8>>2];g=0;while(1){if((g|0)==3)break;c[pa+(g<<2)>>2]=0;g=g+1|0}j=pa+12|0;wa=a[j>>0]|0;e=(wa&1)==0;k=pa+16|0;wa=e?(wa&255)>>>1:c[k>>2]|0;l=pa+20|0;m=j+1|0;$a(ia,e?m:c[l>>2]|0,wa>>>0<2?wa:2);wa=a[ia>>0]|0;e=(wa&1)==0;wa=e?(wa&255)>>>1:c[ia+4>>2]|0;xa=wa>>>0>2;e=ac(e?ia+1|0:c[ia+8>>2]|0,790,xa?2:wa)|0;Ja(ia);if(!(((e|0)==0?(wa>>>0<2?-1:xa&1):e)|0))sb(j);n=c[P>>2]|0;q=n+-12|0;Cb($,sa);g=Ta($,0,790)|0;c[ra>>2]=c[g>>2];c[ra+4>>2]=c[g+4>>2];c[ra+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}g=Ya(ra,4264)|0;c[qa>>2]=c[g>>2];c[qa+4>>2]=c[g+4>>2];c[qa+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}g=a[j>>0]|0;h=(g&1)==0;g=Za(qa,h?m:c[l>>2]|0,h?(g&255)>>>1:c[k>>2]|0)|0;c[oa>>2]=c[g>>2];c[oa+4>>2]=c[g+4>>2];c[oa+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}do if(a[q>>0]&1){p=n+-4|0;a[c[p>>2]>>0]=0;m=n+-8|0;c[m>>2]=0;g=a[q>>0]|0;if(!(g&1))l=10;else{l=c[q>>2]|0;g=l&255;l=(l&-2)+-1|0}do if(!(g&1)){h=(g&255)>>>1;if((g&255)<22){o=1;k=10;n=h;break}o=1;k=(h+16&240)+-1|0;n=h}else{o=0;k=10;n=0}while(0);if((k|0)!=(l|0)){if((k|0)==10){j=q+1|0;h=c[p>>2]|0;if(o){Fc(j|0,h|0,((g&255)>>>1)+1|0)|0;wc(h)}else{a[j>>0]=a[h>>0]|0;wc(h)}a[q>>0]=n<<1;break}h=k+1|0;j=vc(h)|0;if(k>>>0<=l>>>0&(j|0)==0)break;if(o)Fc(j|0,q+1|0,((g&255)>>>1)+1|0)|0;else{e=c[p>>2]|0;a[j>>0]=a[e>>0]|0;wc(e)}c[q>>2]=h|1;c[m>>2]=n;c[p>>2]=j}}else{a[q+1>>0]=0;a[q>>0]=0}while(0);c[q>>2]=c[oa>>2];c[q+4>>2]=c[oa+4>>2];c[q+8>>2]=c[oa+8>>2];g=0;while(1){if((g|0)==3)break;c[oa+(g<<2)>>2]=0;g=g+1|0}Ja(oa);Ja(qa);Ja(ra);Ja($);Ia(sa);Ia(pa);g=aa}else g=d}else g=d;while(0);if((g|0)==(d|0)){g=d;break a}h=c[f+4>>2]|0;if((c[f>>2]|0)==(h|0)){g=d;break a}m=f+16|0;c[ha>>2]=c[f+12>>2];Pb(ja,h+-24|0,ha);h=f+20|0;j=c[h>>2]|0;d=c[f+24>>2]|0;k=d;if(j>>>0<d>>>0){c[j+12>>2]=c[ja+12>>2];c[j>>2]=c[ja>>2];ya=ja+4|0;c[j+4>>2]=c[ya>>2];f=ja+8|0;c[j+8>>2]=c[f>>2];c[f>>2]=0;c[ya>>2]=0;c[ja>>2]=0;c[h>>2]=(c[h>>2]|0)+16}else{h=c[m>>2]|0;d=j-h|0;l=d>>4;j=l+1|0;if((d|0)<-16)Pa();h=k-h|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<j>>>0?j:h}else h=2147483647;Qa(ya,h,l,f+28|0);f=ya+8|0;d=c[f>>2]|0;c[d+12>>2]=c[ja+12>>2];c[d>>2]=c[ja>>2];e=ja+4|0;c[d+4>>2]=c[e>>2];xa=ja+8|0;c[d+8>>2]=c[xa>>2];c[xa>>2]=0;c[e>>2]=0;c[ja>>2]=0;c[f>>2]=d+16;Ra(m,ya);Sa(ya)}Ha(ja);break a}case 67:{xa=d+1|0;g=Na(xa,e,f)|0;if((g|0)==(xa|0)){g=d;break a}j=f+4|0;h=c[j>>2]|0;if((c[f>>2]|0)==(h|0)){g=d;break a}Ya(h+-24|0,2023)|0;m=f+16|0;h=(c[j>>2]|0)+-24|0;c[o>>2]=c[f+12>>2];Pb(A,h,o);h=f+20|0;j=c[h>>2]|0;d=c[f+24>>2]|0;k=d;if(j>>>0<d>>>0){c[j+12>>2]=c[A+12>>2];c[j>>2]=c[A>>2];ya=A+4|0;c[j+4>>2]=c[ya>>2];f=A+8|0;c[j+8>>2]=c[f>>2];c[f>>2]=0;c[ya>>2]=0;c[A>>2]=0;c[h>>2]=(c[h>>2]|0)+16}else{h=c[m>>2]|0;d=j-h|0;l=d>>4;j=l+1|0;if((d|0)<-16)Pa();h=k-h|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<j>>>0?j:h}else h=2147483647;Qa(ya,h,l,f+28|0);f=ya+8|0;d=c[f>>2]|0;c[d+12>>2]=c[A+12>>2];c[d>>2]=c[A>>2];e=A+4|0;c[d+4>>2]=c[e>>2];xa=A+8|0;c[d+8>>2]=c[xa>>2];c[xa>>2]=0;c[e>>2]=0;c[A>>2]=0;c[f>>2]=d+16;Ra(m,ya);Sa(ya)}Ha(A);break a}case 70:{do if(h<<24>>24==70){g=d+1|0;if((g|0)!=(e|0)){if((a[g>>0]|0)==89){g=d+2|0;if((g|0)==(e|0))break}h=Na(g,e,f)|0;if((h|0)!=(g|0)){$a(ya,797,1);r=f+4|0;q=ya+4|0;m=xa+8|0;n=xa+1|0;o=xa+4|0;p=0;g=h;e:while(1){j=g;f:while(1){if((j|0)==(e|0)){ta=170;break e}switch(a[j>>0]|0){case 69:{ta=174;break e}case 118:{j=j+1|0;continue f}case 82:{g=j+1|0;if((g|0)!=(e|0)?(a[g>>0]|0)==69:0){p=1;continue e}break}case 79:{g=j+1|0;if((g|0)!=(e|0)?(a[g>>0]|0)==69:0){p=2;continue e}break}default:{}}h=((c[r>>2]|0)-(c[f>>2]|0)|0)/24|0;k=Na(j,e,f)|0;l=((c[r>>2]|0)-(c[f>>2]|0)|0)/24|0;if((k|0)==(j|0)|(k|0)==(e|0))break e;else g=h;while(1){if(g>>>0>=l>>>0)break;wa=a[ya>>0]|0;if(((wa&1)==0?(wa&255)>>>1:c[q>>2]|0)>>>0>1)Ya(ya,1429)|0;Cb(xa,(c[f>>2]|0)+(g*24|0)|0);wa=a[xa>>0]|0;va=(wa&1)==0;Za(ya,va?n:c[m>>2]|0,va?(wa&255)>>>1:c[o>>2]|0)|0;Ja(xa);g=g+1|0}while(1){if(h>>>0>=l>>>0){j=k;continue f}j=c[r>>2]|0;g=j+-24|0;while(1){if((j|0)==(g|0))break;wa=j+-24|0;c[r>>2]=wa;Ia(wa);j=c[r>>2]|0}h=h+1|0}}}g:do if((ta|0)==170){h=c[r>>2]|0;g=h+-24|0;while(1){if((h|0)==(g|0))break g;f=h+-24|0;c[r>>2]=f;Ia(f);h=c[r>>2]|0}}else if((ta|0)==174){g=j+1|0;Ya(ya,799)|0;switch(p|0){case 1:{Ya(ya,2032)|0;break}case 2:{Ya(ya,2035)|0;break}default:{}}h=c[r>>2]|0;if((c[f>>2]|0)!=(h|0)){Ya(h+-24|0,1882)|0;e=a[ya>>0]|0;xa=(e&1)==0;Ua((c[r>>2]|0)+-12|0,0,xa?ya+1|0:c[ya+8>>2]|0,xa?(e&255)>>>1:c[q>>2]|0)|0;Ja(ya);if((g|0)==(d|0)){g=d;break a}h=c[r>>2]|0;if((c[f>>2]|0)==(h|0)){g=d;break a}m=f+16|0;c[O>>2]=c[f+12>>2];Pb(S,h+-24|0,O);h=f+20|0;j=c[h>>2]|0;d=c[f+24>>2]|0;k=d;if(j>>>0<d>>>0){c[j+12>>2]=c[S+12>>2];c[j>>2]=c[S>>2];ya=S+4|0;c[j+4>>2]=c[ya>>2];f=S+8|0;c[j+8>>2]=c[f>>2];c[f>>2]=0;c[ya>>2]=0;c[S>>2]=0;c[h>>2]=(c[h>>2]|0)+16}else{h=c[m>>2]|0;d=j-h|0;l=d>>4;j=l+1|0;if((d|0)<-16)Pa();h=k-h|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<j>>>0?j:h}else h=2147483647;Qa(ya,h,l,f+28|0);f=ya+8|0;d=c[f>>2]|0;c[d+12>>2]=c[S+12>>2];c[d>>2]=c[S>>2];e=S+4|0;c[d+4>>2]=c[e>>2];xa=S+8|0;c[d+8>>2]=c[xa>>2];c[xa>>2]=0;c[e>>2]=0;c[S>>2]=0;c[f>>2]=d+16;Ra(m,ya);Sa(ya)}Ha(S);break a}}while(0);Ja(ya);break}}g=d;break a}while(0);g=d;break a}case 71:{xa=d+1|0;g=Na(xa,e,f)|0;if((g|0)==(xa|0)){g=d;break a}j=f+4|0;h=c[j>>2]|0;if((c[f>>2]|0)==(h|0)){g=d;break a}Ya(h+-24|0,2039)|0;m=f+16|0;h=(c[j>>2]|0)+-24|0;c[p>>2]=c[f+12>>2];Pb(B,h,p);h=f+20|0;j=c[h>>2]|0;d=c[f+24>>2]|0;k=d;if(j>>>0<d>>>0){c[j+12>>2]=c[B+12>>2];c[j>>2]=c[B>>2];ya=B+4|0;c[j+4>>2]=c[ya>>2];f=B+8|0;c[j+8>>2]=c[f>>2];c[f>>2]=0;c[ya>>2]=0;c[B>>2]=0;c[h>>2]=(c[h>>2]|0)+16}else{h=c[m>>2]|0;d=j-h|0;l=d>>4;j=l+1|0;if((d|0)<-16)Pa();h=k-h|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<j>>>0?j:h}else h=2147483647;Qa(ya,h,l,f+28|0);f=ya+8|0;d=c[f>>2]|0;c[d+12>>2]=c[B+12>>2];c[d>>2]=c[B>>2];e=B+4|0;c[d+4>>2]=c[e>>2];xa=B+8|0;c[d+8>>2]=c[xa>>2];c[xa>>2]=0;c[e>>2]=0;c[B>>2]=0;c[f>>2]=d+16;Ra(m,ya);Sa(ya)}Ha(B);break a}case 77:{if(((h<<24>>24==77?(wa=d+1|0,k=Na(wa,e,f)|0,(k|0)!=(wa|0)):0)?(ka=Na(k,e,f)|0,(ka|0)!=(k|0)):0)?(_=f+4|0,l=c[_>>2]|0,((l-(c[f>>2]|0)|0)/24|0)>>>0>=2):0){db(ya,l+-24|0);g=c[_>>2]|0;h=g+-24|0;j=g;while(1){if((j|0)==(h|0))break;e=j+-24|0;c[_>>2]=e;Ia(e);j=c[_>>2]|0}db(xa,g+-48|0);r=ya+12|0;j=c[_>>2]|0;q=j+-24|0;h:do if((a[((a[r>>0]&1)==0?r+1|0:c[ya+20>>2]|0)>>0]|0)==40){g=Ya(ya,797)|0;c[fa>>2]=c[g>>2];c[fa+4>>2]=c[g+4>>2];c[fa+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}Cb(pa,xa);g=a[pa>>0]|0;h=(g&1)==0;g=Za(fa,h?pa+1|0:c[pa+8>>2]|0,h?(g&255)>>>1:c[pa+4>>2]|0)|0;c[ca>>2]=c[g>>2];c[ca+4>>2]=c[g+4>>2];c[ca+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}g=Ya(ca,2050)|0;c[la>>2]=c[g>>2];c[la+4>>2]=c[g+4>>2];c[la+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}do if(a[q>>0]&1){p=j+-16|0;a[c[p>>2]>>0]=0;m=j+-20|0;c[m>>2]=0;g=a[q>>0]|0;if(!(g&1))l=10;else{l=c[q>>2]|0;g=l&255;l=(l&-2)+-1|0}if(!(g&1)){h=(g&255)>>>1;if((g&255)<22){o=1;k=10;n=h}else{o=1;k=(h+16&240)+-1|0;n=h}}else{o=0;k=10;n=0}if((k|0)!=(l|0)){if((k|0)==10){j=q+1|0;h=c[p>>2]|0;if(o){Fc(j|0,h|0,((g&255)>>>1)+1|0)|0;wc(h)}else{a[j>>0]=a[h>>0]|0;wc(h)}a[q>>0]=n<<1;break}h=k+1|0;j=vc(h)|0;if(!(k>>>0<=l>>>0&(j|0)==0)){if(o)Fc(j|0,q+1|0,((g&255)>>>1)+1|0)|0;else{e=c[p>>2]|0;a[j>>0]=a[e>>0]|0;wc(e)}c[q>>2]=h|1;c[m>>2]=n;c[p>>2]=j}}}else{a[q+1>>0]=0;a[q>>0]=0}while(0);c[q>>2]=c[la>>2];c[q+4>>2]=c[la+4>>2];c[q+8>>2]=c[la+8>>2];g=0;while(1){if((g|0)==3)break;c[la+(g<<2)>>2]=0;g=g+1|0}Ja(la);Ja(ca);Ja(pa);Ja(fa);j=c[_>>2]|0;g=Ta(r,0,799)|0;c[sa>>2]=c[g>>2];c[sa+4>>2]=c[g+4>>2];c[sa+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}q=j+-12|0;do if(a[q>>0]&1){p=j+-4|0;a[c[p>>2]>>0]=0;m=j+-8|0;c[m>>2]=0;g=a[q>>0]|0;if(!(g&1))l=10;else{l=c[q>>2]|0;g=l&255;l=(l&-2)+-1|0}if(!(g&1)){h=(g&255)>>>1;if((g&255)<22){o=1;k=10;n=h}else{o=1;k=(h+16&240)+-1|0;n=h}}else{o=0;k=10;n=0}if((k|0)!=(l|0)){if((k|0)==10){j=q+1|0;h=c[p>>2]|0;if(o){Fc(j|0,h|0,((g&255)>>>1)+1|0)|0;wc(h)}else{a[j>>0]=a[h>>0]|0;wc(h)}a[q>>0]=n<<1;break}h=k+1|0;j=vc(h)|0;if(!(k>>>0<=l>>>0&(j|0)==0)){if(o)Fc(j|0,q+1|0,((g&255)>>>1)+1|0)|0;else{e=c[p>>2]|0;a[j>>0]=a[e>>0]|0;wc(e)}c[q>>2]=h|1;c[m>>2]=n;c[p>>2]=j}}}else{a[q+1>>0]=0;a[q>>0]=0}while(0);c[q>>2]=c[sa>>2];c[q+4>>2]=c[sa+4>>2];c[q+8>>2]=c[sa+8>>2];g=0;while(1){if((g|0)==3)break;c[sa+(g<<2)>>2]=0;g=g+1|0}Ja(sa)}else{g=Ya(ya,1882)|0;c[qa>>2]=c[g>>2];c[qa+4>>2]=c[g+4>>2];c[qa+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}Cb(ra,xa);g=a[ra>>0]|0;h=(g&1)==0;g=Za(qa,h?ra+1|0:c[ra+8>>2]|0,h?(g&255)>>>1:c[ra+4>>2]|0)|0;c[oa>>2]=c[g>>2];c[oa+4>>2]=c[g+4>>2];c[oa+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}g=Ya(oa,2050)|0;c[ia>>2]=c[g>>2];c[ia+4>>2]=c[g+4>>2];c[ia+8>>2]=c[g+8>>2];h=0;while(1){if((h|0)==3)break;c[g+(h<<2)>>2]=0;h=h+1|0}do if(a[q>>0]&1){p=j+-16|0;a[c[p>>2]>>0]=0;m=j+-20|0;c[m>>2]=0;g=a[q>>0]|0;if(!(g&1))l=10;else{g=c[q>>2]|0;l=(g&-2)+-1|0;g=g&255}if(!(g&1)){h=(g&255)>>>1;if((g&255)<22){n=h;o=1;k=10}else{n=h;o=1;k=(h+16&240)+-1|0}}else{n=0;o=0;k=10}if((k|0)!=(l|0)){if((k|0)==10){j=q+1|0;h=c[p>>2]|0;if(o){Fc(j|0,h|0,((g&255)>>>1)+1|0)|0;wc(h)}else{a[j>>0]=a[h>>0]|0;wc(h)}a[q>>0]=n<<1;break}h=k+1|0;j=vc(h)|0;if(!(k>>>0<=l>>>0&(j|0)==0)){if(o)Fc(j|0,q+1|0,((g&255)>>>1)+1|0)|0;else{e=c[p>>2]|0;a[j>>0]=a[e>>0]|0;wc(e)}c[q>>2]=h|1;c[m>>2]=n;c[p>>2]=j}}}else{a[q+1>>0]=0;a[q>>0]=0}while(0);c[q>>2]=c[ia>>2];c[q+4>>2]=c[ia+4>>2];c[q+8>>2]=c[ia+8>>2];g=0;while(1){if((g|0)==3)break;c[ia+(g<<2)>>2]=0;g=g+1|0}Ja(ia);Ja(oa);Ja(ra);Ja(qa);g=c[_>>2]|0;q=g+-12|0;do if(a[q>>0]&1){p=g+-4|0;a[c[p>>2]>>0]=0;m=g+-8|0;c[m>>2]=0;g=a[q>>0]|0;if(!(g&1))l=10;else{l=c[q>>2]|0;g=l&255;l=(l&-2)+-1|0}if(!(g&1)){h=(g&255)>>>1;if((g&255)<22){k=10;n=h;o=1}else{k=(h+16&240)+-1|0;n=h;o=1}}else{k=10;n=0;o=0}if((k|0)!=(l|0)){if((k|0)==10){j=q+1|0;h=c[p>>2]|0;if(o){Fc(j|0,h|0,((g&255)>>>1)+1|0)|0;wc(h)}else{a[j>>0]=a[h>>0]|0;wc(h)}a[q>>0]=n<<1;break}h=k+1|0;j=vc(h)|0;if(!(k>>>0<=l>>>0&(j|0)==0)){if(o)Fc(j|0,q+1|0,((g&255)>>>1)+1|0)|0;else{e=c[p>>2]|0;a[j>>0]=a[e>>0]|0;wc(e)}c[q>>2]=h|1;c[m>>2]=n;c[p>>2]=j}}}else{a[q+1>>0]=0;a[q>>0]=0}while(0);c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];g=0;while(1){if((g|0)==3)break h;c[r+(g<<2)>>2]=0;g=g+1|0}}while(0);Ia(xa);Ia(ya);g=ka}else g=d;if((g|0)==(d|0)){g=d;break a}h=c[f+4>>2]|0;if((c[f>>2]|0)==(h|0)){g=d;break a}m=f+16|0;c[ma>>2]=c[f+12>>2];Pb(na,h+-24|0,ma);h=f+20|0;j=c[h>>2]|0;d=c[f+24>>2]|0;k=d;if(j>>>0<d>>>0){c[j+12>>2]=c[na+12>>2];c[j>>2]=c[na>>2];ya=na+4|0;c[j+4>>2]=c[ya>>2];f=na+8|0;c[j+8>>2]=c[f>>2];c[f>>2]=0;c[ya>>2]=0;c[na>>2]=0;c[h>>2]=(c[h>>2]|0)+16}else{h=c[m>>2]|0;d=j-h|0;l=d>>4;j=l+1|0;if((d|0)<-16)Pa();h=k-h|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<j>>>0?j:h}else h=2147483647;Qa(ya,h,l,f+28|0);f=ya+8|0;d=c[f>>2]|0;c[d+12>>2]=c[na+12>>2];c[d>>2]=c[na>>2];e=na+4|0;c[d+4>>2]=c[e>>2];xa=na+8|0;c[d+8>>2]=c[xa>>2];c[xa>>2]=0;c[e>>2]=0;c[na>>2]=0;c[f>>2]=d+16;Ra(m,ya);Sa(ya)}Ha(na);break a}case 79:{v=f+4|0;p=((c[v>>2]|0)-(c[f>>2]|0)|0)/24|0;xa=d+1|0;g=Na(xa,e,f)|0;v=((c[v>>2]|0)-(c[f>>2]|0)|0)/24|0;if((g|0)==(xa|0)){g=d;break a}n=f+16|0;o=c[f+12>>2]|0;w=f+20|0;h=c[w>>2]|0;xa=c[f+24>>2]|0;j=xa;if(h>>>0<xa>>>0){c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=o;c[w>>2]=(c[w>>2]|0)+16}else{k=c[n>>2]|0;xa=h-k|0;m=xa>>4;l=m+1|0;if((xa|0)<-16)Pa();h=j-k|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<l>>>0?l:h}else h=2147483647;Qa(ya,h,m,f+28|0);xa=ya+8|0;ta=c[xa>>2]|0;c[ta>>2]=0;c[ta+4>>2]=0;c[ta+8>>2]=0;c[ta+12>>2]=o;c[xa>>2]=ta+16;Ra(n,ya);Sa(ya)}r=T+4|0;s=T+8|0;t=T+1|0;u=ya+8|0;while(1){if(p>>>0>=v>>>0)break a;xa=c[f>>2]|0;ta=xa+(p*24|0)+12|0;sa=a[ta>>0]|0;j=(sa&1)==0;sa=j?(sa&255)>>>1:c[xa+(p*24|0)+16>>2]|0;$a(T,j?ta+1|0:c[xa+(p*24|0)+20>>2]|0,sa>>>0<2?sa:2);sa=a[T>>0]|0;xa=(sa&1)==0;sa=xa?(sa&255)>>>1:c[r>>2]|0;ta=sa>>>0>2;xa=ac(xa?t:c[s>>2]|0,790,ta?2:sa)|0;Ja(T);j=c[f>>2]|0;if(((xa|0)==0?(sa>>>0<2?-1:ta&1):xa)|0){h=b[j+(p*24|0)+12>>1]|0;if(!(h&1))h=(h&65535)>>>8&255;else h=a[c[j+(p*24|0)+20>>2]>>0]|0;if(h<<24>>24==40){Ya(j+(p*24|0)|0,797)|0;Ta((c[f>>2]|0)+(p*24|0)+12|0,0,799)|0}}else{Ya(j+(p*24|0)|0,849)|0;Ta((c[f>>2]|0)+(p*24|0)+12|0,0,799)|0}Ya((c[f>>2]|0)+(p*24|0)|0,841)|0;m=c[w>>2]|0;n=m+-16|0;o=c[f>>2]|0;q=o+(p*24|0)|0;h=m+-12|0;j=c[h>>2]|0;xa=c[m+-8>>2]|0;k=xa;if((j|0)==(xa|0)){h=c[n>>2]|0;xa=j-h|0;l=(xa|0)/24|0;j=l+1|0;if((xa|0)<-24)break;h=(k-h|0)/24|0;if(h>>>0<1073741823){h=h<<1;h=h>>>0<j>>>0?j:h}else h=2147483647;ab(ya,h,l,m+-4|0);xa=c[u>>2]|0;_a(xa,q);_a(xa+12|0,o+(p*24|0)+12|0);c[u>>2]=xa+24;cb(n,ya);bb(ya)}else{_a(j,q);_a(j+12|0,o+(p*24|0)+12|0);c[h>>2]=(c[h>>2]|0)+24}p=p+1|0}Pa();break}case 80:{B=f+4|0;p=((c[B>>2]|0)-(c[f>>2]|0)|0)/24|0;A=d+1|0;g=Na(A,e,f)|0;B=((c[B>>2]|0)-(c[f>>2]|0)|0)/24|0;if((g|0)==(A|0)){g=d;break a}n=f+16|0;o=c[f+12>>2]|0;C=f+20|0;h=c[C>>2]|0;xa=c[f+24>>2]|0;j=xa;if(h>>>0<xa>>>0){c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=o;c[C>>2]=(c[C>>2]|0)+16}else{k=c[n>>2]|0;xa=h-k|0;m=xa>>4;l=m+1|0;if((xa|0)<-16)Pa();h=j-k|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<l>>>0?l:h}else h=2147483647;Qa(ya,h,m,f+28|0);xa=ya+8|0;sa=c[xa>>2]|0;c[sa>>2]=0;c[sa+4>>2]=0;c[sa+8>>2]=0;c[sa+12>>2]=o;c[xa>>2]=sa+16;Ra(n,ya);Sa(ya)}t=da+4|0;u=da+8|0;v=da+1|0;w=ea+4|0;x=ea+8|0;y=ea+1|0;z=ya+8|0;while(1){if(p>>>0>=B>>>0)break a;xa=c[f>>2]|0;sa=xa+(p*24|0)+12|0;ra=a[sa>>0]|0;j=(ra&1)==0;ra=j?(ra&255)>>>1:c[xa+(p*24|0)+16>>2]|0;$a(da,j?sa+1|0:c[xa+(p*24|0)+20>>2]|0,ra>>>0<2?ra:2);ra=a[da>>0]|0;xa=(ra&1)==0;ra=xa?(ra&255)>>>1:c[t>>2]|0;sa=ra>>>0>2;xa=ac(xa?v:c[u>>2]|0,790,sa?2:ra)|0;Ja(da);j=c[f>>2]|0;if(((xa|0)==0?(ra>>>0<2?-1:sa&1):xa)|0){h=b[j+(p*24|0)+12>>1]|0;if(!(h&1))h=(h&65535)>>>8&255;else h=a[c[j+(p*24|0)+20>>2]>>0]|0;if(h<<24>>24==40){Ya(j+(p*24|0)|0,797)|0;Ta((c[f>>2]|0)+(p*24|0)+12|0,0,799)|0}}else{Ya(j+(p*24|0)|0,849)|0;Ta((c[f>>2]|0)+(p*24|0)+12|0,0,799)|0}j=c[f>>2]|0;h=j+(p*24|0)|0;do if((a[A>>0]|0)==85){ra=a[h>>0]|0;xa=(ra&1)==0;ra=xa?(ra&255)>>>1:c[j+(p*24|0)+4>>2]|0;$a(ea,xa?h+1|0:c[j+(p*24|0)+8>>2]|0,ra>>>0<12?ra:12);ra=a[ea>>0]|0;xa=(ra&1)==0;ra=xa?(ra&255)>>>1:c[w>>2]|0;sa=ra>>>0>12;xa=ac(xa?y:c[x>>2]|0,2054,sa?12:ra)|0;Ja(ea);s=c[f>>2]|0;h=s+(p*24|0)|0;if(!(((xa|0)==0?(ra>>>0<12?-1:sa&1):xa)|0)){j=a[h>>0]|0;if(!(j&1)){o=(j&255)>>>1;r=o;o=o>>>0<11?o:11;k=10}else{o=c[s+(p*24|0)+4>>2]|0;j=c[h>>2]|0;r=o;o=o>>>0<11?o:11;k=(j&-2)+-1|0;j=j&255}if((o-r+k|0)>>>0<2){Wa(h,k,2-o+r-k|0,r,0,o,2,2067);break}if(!(j&1))q=h+1|0;else q=c[s+(p*24|0)+8>>2]|0;do if((o|0)!=2){n=r-o|0;if((r|0)==(o|0)){k=o;m=0;l=2067;j=2;ta=402}else{if(o>>>0>2){a[q>>0]=105;a[q+1>>0]=100;Hc(q+2|0,q+o|0,n|0)|0;k=o;j=2;break}do if(q>>>0<2067>>>0&(q+r|0)>>>0>2067>>>0)if((q+o|0)>>>0>2067>>>0){Fc(q|0,2067,o|0)|0;m=o;l=2069;k=0;j=2-o|0;break}else{m=0;l=2067+(2-o)|0;k=o;j=2;break}else{m=0;l=2067;k=o;j=2}while(0);ta=q+m|0;Hc(ta+j|0,ta+k|0,n|0)|0;ta=402}}else{k=2;m=0;l=2067;j=2;ta=402}while(0);if((ta|0)==402){ta=0;Hc(q+m|0,l|0,j|0)|0}j=j-k+r|0;if(!(a[h>>0]&1))a[h>>0]=j<<1;else c[s+(p*24|0)+4>>2]=j;a[q+j>>0]=0}else ta=385}else ta=385;while(0);if((ta|0)==385){ta=0;Ya(h,4262)|0}m=c[C>>2]|0;n=m+-16|0;o=c[f>>2]|0;q=o+(p*24|0)|0;h=m+-12|0;j=c[h>>2]|0;xa=c[m+-8>>2]|0;k=xa;if((j|0)==(xa|0)){h=c[n>>2]|0;xa=j-h|0;l=(xa|0)/24|0;j=l+1|0;if((xa|0)<-24)break;h=(k-h|0)/24|0;if(h>>>0<1073741823){h=h<<1;h=h>>>0<j>>>0?j:h}else h=2147483647;ab(ya,h,l,m+-4|0);xa=c[z>>2]|0;_a(xa,q);_a(xa+12|0,o+(p*24|0)+12|0);c[z>>2]=xa+24;cb(n,ya);bb(ya)}else{_a(j,q);_a(j+12|0,o+(p*24|0)+12|0);c[h>>2]=(c[h>>2]|0)+24}p=p+1|0}Pa();break}case 82:{v=f+4|0;p=((c[v>>2]|0)-(c[f>>2]|0)|0)/24|0;xa=d+1|0;g=Na(xa,e,f)|0;v=((c[v>>2]|0)-(c[f>>2]|0)|0)/24|0;if((g|0)==(xa|0)){g=d;break a}n=f+16|0;o=c[f+12>>2]|0;w=f+20|0;h=c[w>>2]|0;xa=c[f+24>>2]|0;j=xa;if(h>>>0<xa>>>0){c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=o;c[w>>2]=(c[w>>2]|0)+16}else{k=c[n>>2]|0;xa=h-k|0;m=xa>>4;l=m+1|0;if((xa|0)<-16)Pa();h=j-k|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<l>>>0?l:h}else h=2147483647;Qa(ya,h,m,f+28|0);xa=ya+8|0;ta=c[xa>>2]|0;c[ta>>2]=0;c[ta+4>>2]=0;c[ta+8>>2]=0;c[ta+12>>2]=o;c[xa>>2]=ta+16;Ra(n,ya);Sa(ya)}r=U+4|0;s=U+8|0;t=U+1|0;u=ya+8|0;while(1){if(p>>>0>=v>>>0)break a;xa=c[f>>2]|0;ta=xa+(p*24|0)+12|0;sa=a[ta>>0]|0;j=(sa&1)==0;sa=j?(sa&255)>>>1:c[xa+(p*24|0)+16>>2]|0;$a(U,j?ta+1|0:c[xa+(p*24|0)+20>>2]|0,sa>>>0<2?sa:2);sa=a[U>>0]|0;xa=(sa&1)==0;sa=xa?(sa&255)>>>1:c[r>>2]|0;ta=sa>>>0>2;xa=ac(xa?t:c[s>>2]|0,790,ta?2:sa)|0;Ja(U);j=c[f>>2]|0;if(((xa|0)==0?(sa>>>0<2?-1:ta&1):xa)|0){h=b[j+(p*24|0)+12>>1]|0;if(!(h&1))h=(h&65535)>>>8&255;else h=a[c[j+(p*24|0)+20>>2]>>0]|0;if(h<<24>>24==40){Ya(j+(p*24|0)|0,797)|0;Ta((c[f>>2]|0)+(p*24|0)+12|0,0,799)|0}}else{Ya(j+(p*24|0)|0,849)|0;Ta((c[f>>2]|0)+(p*24|0)+12|0,0,799)|0}Ya((c[f>>2]|0)+(p*24|0)|0,852)|0;m=c[w>>2]|0;n=m+-16|0;o=c[f>>2]|0;q=o+(p*24|0)|0;h=m+-12|0;j=c[h>>2]|0;xa=c[m+-8>>2]|0;k=xa;if((j|0)==(xa|0)){h=c[n>>2]|0;xa=j-h|0;l=(xa|0)/24|0;j=l+1|0;if((xa|0)<-24)break;h=(k-h|0)/24|0;if(h>>>0<1073741823){h=h<<1;h=h>>>0<j>>>0?j:h}else h=2147483647;ab(ya,h,l,m+-4|0);xa=c[u>>2]|0;_a(xa,q);_a(xa+12|0,o+(p*24|0)+12|0);c[u>>2]=xa+24;cb(n,ya);bb(ya)}else{_a(j,q);_a(j+12|0,o+(p*24|0)+12|0);c[h>>2]=(c[h>>2]|0)+24}p=p+1|0}Pa();break}case 84:{v=f+4|0;s=((c[v>>2]|0)-(c[f>>2]|0)|0)/24|0;g=Eb(d,e,f)|0;t=((c[v>>2]|0)-(c[f>>2]|0)|0)/24|0;if((g|0)==(d|0)){g=d;break a}y=f+16|0;u=f+12|0;n=c[u>>2]|0;x=f+20|0;h=c[x>>2]|0;w=f+24|0;d=c[w>>2]|0;j=d;if(h>>>0<d>>>0){c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=n;c[x>>2]=(c[x>>2]|0)+16}else{k=c[y>>2]|0;d=h-k|0;m=d>>4;l=m+1|0;if((d|0)<-16)Pa();h=j-k|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<l>>>0?l:h}else h=2147483647;Qa(ya,h,m,f+28|0);d=ya+8|0;wa=c[d>>2]|0;c[wa>>2]=0;c[wa+4>>2]=0;c[wa+8>>2]=0;c[wa+12>>2]=n;c[d>>2]=wa+16;Ra(y,ya);Sa(ya)}m=ya+8|0;r=s;while(1){if(r>>>0>=t>>>0)break;n=c[x>>2]|0;o=n+-16|0;p=c[f>>2]|0;q=p+(r*24|0)|0;h=n+-12|0;j=c[h>>2]|0;d=c[n+-8>>2]|0;k=d;if((j|0)==(d|0)){h=c[o>>2]|0;d=j-h|0;l=(d|0)/24|0;j=l+1|0;if((d|0)<-24){ta=455;break}h=(k-h|0)/24|0;if(h>>>0<1073741823){h=h<<1;h=h>>>0<j>>>0?j:h}else h=2147483647;ab(ya,h,l,n+-4|0);d=c[m>>2]|0;_a(d,q);_a(d+12|0,p+(r*24|0)+12|0);c[m>>2]=d+24;cb(o,ya);bb(ya)}else{_a(j,q);_a(j+12|0,p+(r*24|0)+12|0);c[h>>2]=(c[h>>2]|0)+24}r=r+1|0}if((ta|0)==455)Pa();if(!((t|0)==(s+1|0)&(a[f+63>>0]|0)!=0))break a;m=Mb(g,e,f)|0;if((m|0)==(g|0))break a;Cb(xa,(c[v>>2]|0)+-24|0);g=c[v>>2]|0;h=g+-24|0;j=g;while(1){if((j|0)==(h|0))break;d=j+-24|0;c[v>>2]=d;Ia(d);j=c[v>>2]|0}d=a[xa>>0]|0;k=(d&1)==0;Za(g+-48|0,k?xa+1|0:c[xa+8>>2]|0,k?(d&255)>>>1:c[xa+4>>2]|0)|0;g=(c[v>>2]|0)+-24|0;c[V>>2]=c[u>>2];Pb(X,g,V);g=c[x>>2]|0;d=c[w>>2]|0;k=d;if(g>>>0<d>>>0){c[g+12>>2]=c[X+12>>2];c[g>>2]=c[X>>2];ya=X+4|0;c[g+4>>2]=c[ya>>2];f=X+8|0;c[g+8>>2]=c[f>>2];c[f>>2]=0;c[ya>>2]=0;c[X>>2]=0;c[x>>2]=(c[x>>2]|0)+16}else{h=c[y>>2]|0;d=g-h|0;l=d>>4;j=l+1|0;if((d|0)<-16)Pa();g=k-h|0;if(g>>4>>>0<1073741823){g=g>>3;g=g>>>0<j>>>0?j:g}else g=2147483647;Qa(ya,g,l,f+28|0);f=ya+8|0;d=c[f>>2]|0;c[d+12>>2]=c[X+12>>2];c[d>>2]=c[X>>2];e=X+4|0;c[d+4>>2]=c[e>>2];wa=X+8|0;c[d+8>>2]=c[wa>>2];c[wa>>2]=0;c[e>>2]=0;c[X>>2]=0;c[f>>2]=d+16;Ra(y,ya);Sa(ya)}Ha(X);Ja(xa);g=m;break a}case 85:{g=d+1|0;if((g|0)==(e|0)){g=d;break a}h=qb(g,e,f)|0;if((h|0)==(g|0)){g=d;break a}g=Na(h,e,f)|0;if((g|0)==(h|0)){g=d;break a}n=f+4|0;h=c[n>>2]|0;if(((h-(c[f>>2]|0)|0)/24|0)>>>0<2){g=d;break a}Cb(xa,h+-24|0);h=c[n>>2]|0;j=h+-24|0;k=h;while(1){if((k|0)==(j|0))break;d=k+-24|0;c[n>>2]=d;Ia(d);k=c[n>>2]|0}d=h+-48|0;wa=a[d>>0]|0;e=(wa&1)==0;wa=e?(wa&255)>>>1:c[h+-44>>2]|0;$a(t,e?d+1|0:c[h+-40>>2]|0,wa>>>0<9?wa:9);wa=a[t>>0]|0;d=(wa&1)==0;wa=d?(wa&255)>>>1:c[t+4>>2]|0;e=wa>>>0>9;d=ac(d?t+1|0:c[t+8>>2]|0,2070,e?9:wa)|0;Ja(t);if(!(((d|0)==0?(wa>>>0<9?-1:e&1):d)|0)){Cb(la,(c[n>>2]|0)+-24|0);j=c[n>>2]|0;h=j+-24|0;while(1){if((j|0)==(h|0))break;d=j+-24|0;c[n>>2]=d;Ia(d);j=c[n>>2]|0}d=a[la>>0]|0;e=(d&1)==0;h=la+8|0;j=la+1|0;wa=e?j:c[h>>2]|0;k=la+4|0;d=qb(wa+9|0,wa+(e?(d&255)>>>1:c[k>>2]|0)|0,f)|0;if((d|0)==(((a[la>>0]&1)==0?j:c[h>>2]|0)+9|0)){Ib(N,xa,1882);d=a[la>>0]|0;e=(d&1)==0;h=Za(N,e?j:c[h>>2]|0,e?(d&255)>>>1:c[k>>2]|0)|0;c[M>>2]=c[h>>2];c[M+4>>2]=c[h+4>>2];c[M+8>>2]=c[h+8>>2];j=0;while(1){if((j|0)==3)break;c[h+(j<<2)>>2]=0;j=j+1|0}rb(L,M);h=c[n>>2]|0;d=c[f+8>>2]|0;j=d;if(h>>>0<d>>>0){db(h,L);c[n>>2]=(c[n>>2]|0)+24}else{k=c[f>>2]|0;d=h-k|0;m=(d|0)/24|0;l=m+1|0;if((d|0)<-24)Pa();h=(j-k|0)/24|0;if(h>>>0<1073741823){h=h<<1;h=h>>>0<l>>>0?l:h}else h=2147483647;ab(ya,h,m,f+12|0);d=ya+8|0;e=c[d>>2]|0;db(e,L);c[d>>2]=e+24;cb(f,ya);bb(ya)}Ia(L);Ja(M);Ja(N)}else{k=(c[n>>2]|0)+-24|0;Ib(H,xa,1427);Cb(I,(c[n>>2]|0)+-24|0);h=a[I>>0]|0;j=(h&1)==0;h=Za(H,j?I+1|0:c[I+8>>2]|0,j?(h&255)>>>1:c[I+4>>2]|0)|0;c[G>>2]=c[h>>2];c[G+4>>2]=c[h+4>>2];c[G+8>>2]=c[h+8>>2];j=0;while(1){if((j|0)==3)break;c[h+(j<<2)>>2]=0;j=j+1|0}h=Ya(G,844)|0;c[F>>2]=c[h>>2];c[F+4>>2]=c[h+4>>2];c[F+8>>2]=c[h+8>>2];j=0;while(1){if((j|0)==3)break;c[h+(j<<2)>>2]=0;j=j+1|0}rb(E,F);Db(k,E);Ia(E);Ja(F);Ja(G);Ja(I);Ja(H)}Ja(la)}else{h=(c[n>>2]|0)+-24|0;Ib(x,xa,1882);Cb(y,(c[n>>2]|0)+-24|0);j=a[y>>0]|0;k=(j&1)==0;j=Za(x,k?y+1|0:c[y+8>>2]|0,k?(j&255)>>>1:c[y+4>>2]|0)|0;c[w>>2]=c[j>>2];c[w+4>>2]=c[j+4>>2];c[w+8>>2]=c[j+8>>2];k=0;while(1){if((k|0)==3)break;c[j+(k<<2)>>2]=0;k=k+1|0}rb(v,w);Db(h,v);Ia(v);Ja(w);Ja(y);Ja(x)}m=(c[n>>2]|0)+-24|0;c[R>>2]=c[f+12>>2];Pb(W,m,R);m=f+16|0;h=f+20|0;j=c[h>>2]|0;d=c[f+24>>2]|0;k=d;if(j>>>0<d>>>0){c[j+12>>2]=c[W+12>>2];c[j>>2]=c[W>>2];ya=W+4|0;c[j+4>>2]=c[ya>>2];f=W+8|0;c[j+8>>2]=c[f>>2];c[f>>2]=0;c[ya>>2]=0;c[W>>2]=0;c[h>>2]=(c[h>>2]|0)+16}else{h=c[m>>2]|0;d=j-h|0;l=d>>4;j=l+1|0;if((d|0)<-16)Pa();h=k-h|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<j>>>0?j:h}else h=2147483647;Qa(ya,h,l,f+28|0);f=ya+8|0;d=c[f>>2]|0;c[d+12>>2]=c[W+12>>2];c[d>>2]=c[W>>2];e=W+4|0;c[d+4>>2]=c[e>>2];wa=W+8|0;c[d+8>>2]=c[wa>>2];c[wa>>2]=0;c[e>>2]=0;c[W>>2]=0;c[f>>2]=d+16;Ra(m,ya);Sa(ya)}Ha(W);Ja(xa);break a}case 83:{wa=d+1|0;if((wa|0)!=(e|0)?(a[wa>>0]|0)==116:0){g=Wb(d,e,f)|0;if((g|0)==(d|0)){g=d;break a}h=c[f+4>>2]|0;if((c[f>>2]|0)==(h|0)){g=d;break a}m=f+16|0;c[n>>2]=c[f+12>>2];Pb(z,h+-24|0,n);h=f+20|0;j=c[h>>2]|0;d=c[f+24>>2]|0;k=d;if(j>>>0<d>>>0){c[j+12>>2]=c[z+12>>2];c[j>>2]=c[z>>2];ya=z+4|0;c[j+4>>2]=c[ya>>2];f=z+8|0;c[j+8>>2]=c[f>>2];c[f>>2]=0;c[ya>>2]=0;c[z>>2]=0;c[h>>2]=(c[h>>2]|0)+16}else{h=c[m>>2]|0;d=j-h|0;l=d>>4;j=l+1|0;if((d|0)<-16)Pa();h=k-h|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<j>>>0?j:h}else h=2147483647;Qa(ya,h,l,f+28|0);f=ya+8|0;d=c[f>>2]|0;c[d+12>>2]=c[z+12>>2];c[d>>2]=c[z>>2];e=z+4|0;c[d+4>>2]=c[e>>2];xa=z+8|0;c[d+8>>2]=c[xa>>2];c[xa>>2]=0;c[e>>2]=0;c[z>>2]=0;c[f>>2]=d+16;Ra(m,ya);Sa(ya)}Ha(z);break a}g=Rb(d,e,f)|0;if((g|0)==(d|0)){g=d;break a}m=Mb(g,e,f)|0;if((m|0)==(g|0))break a;k=f+4|0;h=c[k>>2]|0;if(((h-(c[f>>2]|0)|0)/24|0)>>>0<2)break a;Cb(xa,h+-24|0);g=c[k>>2]|0;h=g+-24|0;j=g;while(1){if((j|0)==(h|0))break;d=j+-24|0;c[k>>2]=d;Ia(d);j=c[k>>2]|0}l=a[xa>>0]|0;h=(l&1)==0;Za(g+-48|0,h?xa+1|0:c[xa+8>>2]|0,h?(l&255)>>>1:c[xa+4>>2]|0)|0;l=(c[k>>2]|0)+-24|0;c[s>>2]=c[f+12>>2];Pb(D,l,s);l=f+16|0;g=f+20|0;h=c[g>>2]|0;d=c[f+24>>2]|0;j=d;if(h>>>0<d>>>0){c[h+12>>2]=c[D+12>>2];c[h>>2]=c[D>>2];ya=D+4|0;c[h+4>>2]=c[ya>>2];f=D+8|0;c[h+8>>2]=c[f>>2];c[f>>2]=0;c[ya>>2]=0;c[D>>2]=0;c[g>>2]=(c[g>>2]|0)+16}else{g=c[l>>2]|0;d=h-g|0;k=d>>4;h=k+1|0;if((d|0)<-16)Pa();g=j-g|0;if(g>>4>>>0<1073741823){g=g>>3;g=g>>>0<h>>>0?h:g}else g=2147483647;Qa(ya,g,k,f+28|0);f=ya+8|0;d=c[f>>2]|0;c[d+12>>2]=c[D+12>>2];c[d>>2]=c[D>>2];e=D+4|0;c[d+4>>2]=c[e>>2];wa=D+8|0;c[d+8>>2]=c[wa>>2];c[wa>>2]=0;c[e>>2]=0;c[D>>2]=0;c[f>>2]=d+16;Ra(l,ya);Sa(ya)}Ha(D);Ja(xa);g=m;break a}case 68:{g=d+1|0;if((g|0)!=(e|0)){g=a[g>>0]|0;switch(g<<24>>24|0){case 112:{s=f+4|0;p=((c[s>>2]|0)-(c[f>>2]|0)|0)/24|0;xa=d+2|0;g=Na(xa,e,f)|0;s=((c[s>>2]|0)-(c[f>>2]|0)|0)/24|0;if((g|0)==(xa|0))break d;n=f+16|0;o=c[f+12>>2]|0;t=f+20|0;h=c[t>>2]|0;xa=c[f+24>>2]|0;j=xa;if(h>>>0<xa>>>0){c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=o;c[t>>2]=(c[t>>2]|0)+16}else{k=c[n>>2]|0;xa=h-k|0;m=xa>>4;l=m+1|0;if((xa|0)<-16)Pa();h=j-k|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<l>>>0?l:h}else h=2147483647;Qa(ya,h,m,f+28|0);xa=ya+8|0;ta=c[xa>>2]|0;c[ta>>2]=0;c[ta+4>>2]=0;c[ta+8>>2]=0;c[ta+12>>2]=o;c[xa>>2]=ta+16;Ra(n,ya);Sa(ya)}r=ya+8|0;while(1){if(p>>>0>=s>>>0)break a;m=c[t>>2]|0;n=m+-16|0;o=c[f>>2]|0;q=o+(p*24|0)|0;h=m+-12|0;j=c[h>>2]|0;xa=c[m+-8>>2]|0;k=xa;if((j|0)==(xa|0)){h=c[n>>2]|0;xa=j-h|0;l=(xa|0)/24|0;j=l+1|0;if((xa|0)<-24)break;h=(k-h|0)/24|0;if(h>>>0<1073741823){h=h<<1;h=h>>>0<j>>>0?j:h}else h=2147483647;ab(ya,h,l,m+-4|0);xa=c[r>>2]|0;_a(xa,q);_a(xa+12|0,o+(p*24|0)+12|0);c[r>>2]=xa+24;cb(n,ya);bb(ya)}else{_a(j,q);_a(j+12|0,o+(p*24|0)+12|0);c[h>>2]=(c[h>>2]|0)+24}p=p+1|0}Pa();break}case 84:case 116:{g=Qb(d,e,f)|0;if((g|0)==(d|0))break d;h=c[f+4>>2]|0;if((c[f>>2]|0)==(h|0)){g=d;break a}m=f+16|0;c[r>>2]=c[f+12>>2];Pb(C,h+-24|0,r);h=f+20|0;j=c[h>>2]|0;d=c[f+24>>2]|0;k=d;if(j>>>0<d>>>0){c[j+12>>2]=c[C+12>>2];c[j>>2]=c[C>>2];ya=C+4|0;c[j+4>>2]=c[ya>>2];f=C+8|0;c[j+8>>2]=c[f>>2];c[f>>2]=0;c[ya>>2]=0;c[C>>2]=0;c[h>>2]=(c[h>>2]|0)+16}else{h=c[m>>2]|0;d=j-h|0;l=d>>4;j=l+1|0;if((d|0)<-16)Pa();h=k-h|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<j>>>0?j:h}else h=2147483647;Qa(ya,h,l,f+28|0);f=ya+8|0;d=c[f>>2]|0;c[d+12>>2]=c[C+12>>2];c[d>>2]=c[C>>2];e=C+4|0;c[d+4>>2]=c[e>>2];xa=C+8|0;c[d+8>>2]=c[xa>>2];c[xa>>2]=0;c[e>>2]=0;c[C>>2]=0;c[f>>2]=d+16;Ra(m,ya);Sa(ya)}Ha(C);break a}case 118:{i:do if((e-d|0)>3&h<<24>>24==68&g<<24>>24==118){l=d+2|0;h=a[l>>0]|0;if((h+-49&255)<9){g=tb(l,e)|0;if((g|0)==(e|0)){g=d;break}if((a[g>>0]|0)!=95){g=d;break}j=g-l|0;h=g+1|0;if((h|0)==(e|0)){g=d;break}if((a[h>>0]|0)!=112){g=Na(h,e,f)|0;if((g|0)==(h|0)){g=d;break}h=c[f+4>>2]|0;if((c[f>>2]|0)==(h|0)){g=d;break}k=h+-24|0;$a(ca,l,j);h=Ta(ca,0,2101)|0;c[la>>2]=c[h>>2];c[la+4>>2]=c[h+4>>2];c[la+8>>2]=c[h+8>>2];j=0;while(1){if((j|0)==3)break;c[h+(j<<2)>>2]=0;j=j+1|0}h=Ya(la,4264)|0;c[xa>>2]=c[h>>2];c[xa+4>>2]=c[h+4>>2];c[xa+8>>2]=c[h+8>>2];j=0;while(1){if((j|0)==3)break;c[h+(j<<2)>>2]=0;j=j+1|0}ta=a[xa>>0]|0;sa=(ta&1)==0;Za(k,sa?xa+1|0:c[xa+8>>2]|0,sa?(ta&255)>>>1:c[xa+4>>2]|0)|0;Ja(xa);Ja(la);Ja(ca);break}g=g+2|0;$a(ia,l,j);h=Ta(ia,0,2110)|0;c[sa>>2]=c[h>>2];c[sa+4>>2]=c[h+4>>2];c[sa+8>>2]=c[h+8>>2];j=0;while(1){if((j|0)==3)break;c[h+(j<<2)>>2]=0;j=j+1|0}h=Ya(sa,4264)|0;c[pa>>2]=c[h>>2];c[pa+4>>2]=c[h+4>>2];c[pa+8>>2]=c[h+8>>2];j=0;while(1){if((j|0)==3)break;c[h+(j<<2)>>2]=0;j=j+1|0}rb(fa,pa);h=f+4|0;j=c[h>>2]|0;xa=c[f+8>>2]|0;k=xa;if(j>>>0<xa>>>0){db(j,fa);c[h>>2]=(c[h>>2]|0)+24}else{h=c[f>>2]|0;xa=j-h|0;l=(xa|0)/24|0;j=l+1|0;if((xa|0)<-24)Pa();h=(k-h|0)/24|0;if(h>>>0<1073741823){h=h<<1;h=h>>>0<j>>>0?j:h}else h=2147483647;ab(ya,h,l,f+12|0);xa=ya+8|0;ta=c[xa>>2]|0;db(ta,fa);c[xa>>2]=ta+24;cb(f,ya);bb(ya)}Ia(fa);Ja(pa);Ja(sa);Ja(ia);break}g=0;while(1){if((g|0)==3)break;c[ya+(g<<2)>>2]=0;g=g+1|0}j:do if(h<<24>>24!=95?(J=ub(l,e,f)|0,(J|0)!=(l|0)):0){o=f+4|0;g=c[o>>2]|0;if((c[f>>2]|0)!=(g|0)){Cb(oa,g+-24|0);k:do if(!(a[ya>>0]&1)){a[ya+1>>0]=0;a[ya>>0]=0}else{l=ya+8|0;h=c[l>>2]|0;a[h>>0]=0;m=ya+4|0;c[m>>2]=0;g=c[ya>>2]|0;n=(g&-2)+-1|0;j=g&255;do if(!(j&1)){g=g>>>1&127;if((j&255)<22){Fc(ya+1|0,h|0,g+1|0)|0;wc(h);break}h=g+16&240;k=h+-1|0;if((k|0)==(n|0))break k;j=vc(h)|0;if(k>>>0<=n>>>0&(j|0)==0)break k;Fc(j|0,ya+1|0,g+1|0)|0;c[ya>>2]=h|1;c[m>>2]=g;c[l>>2]=j;break k}else{a[ya+1>>0]=0;wc(h);g=0}while(0);a[ya>>0]=g<<1}while(0);c[ya>>2]=c[oa>>2];c[ya+4>>2]=c[oa+4>>2];c[ya+8>>2]=c[oa+8>>2];g=0;while(1){if((g|0)==3)break;c[oa+(g<<2)>>2]=0;g=g+1|0}Ja(oa);h=c[o>>2]|0;g=h+-24|0;while(1){if((h|0)==(g|0)){g=J;ta=622;break j}xa=h+-24|0;c[o>>2]=xa;Ia(xa);h=c[o>>2]|0}}}else{g=l;ta=622}while(0);do if((ta|0)==622){if((((g|0)!=(e|0)?(a[g>>0]|0)==95:0)?(K=g+1|0,(K|0)!=(e|0)):0)?(Q=Na(K,e,f)|0,(Q|0)!=(K|0)):0){g=c[f+4>>2]|0;if((c[f>>2]|0)==(g|0))break;g=g+-24|0;xb(ra,2101,ya);h=Ya(ra,4264)|0;c[qa>>2]=c[h>>2];c[qa+4>>2]=c[h+4>>2];c[qa+8>>2]=c[h+8>>2];j=0;while(1){if((j|0)==3)break;c[h+(j<<2)>>2]=0;j=j+1|0}xa=a[qa>>0]|0;ta=(xa&1)==0;Za(g,ta?qa+1|0:c[qa+8>>2]|0,ta?(xa&255)>>>1:c[qa+4>>2]|0)|0;Ja(qa);Ja(ra);g=Q}else g=d;Ja(ya);break i}while(0);Ja(ya);g=d}else g=d;while(0);if((g|0)==(d|0))break d;h=c[f+4>>2]|0;if((c[f>>2]|0)==(h|0)){g=d;break a}m=f+16|0;c[ba>>2]=c[f+12>>2];Pb(ga,h+-24|0,ba);h=f+20|0;j=c[h>>2]|0;d=c[f+24>>2]|0;k=d;if(j>>>0<d>>>0){c[j+12>>2]=c[ga+12>>2];c[j>>2]=c[ga>>2];ya=ga+4|0;c[j+4>>2]=c[ya>>2];f=ga+8|0;c[j+8>>2]=c[f>>2];c[f>>2]=0;c[ya>>2]=0;c[ga>>2]=0;c[h>>2]=(c[h>>2]|0)+16}else{h=c[m>>2]|0;d=j-h|0;l=d>>4;j=l+1|0;if((d|0)<-16)Pa();h=k-h|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<j>>>0?j:h}else h=2147483647;Qa(ya,h,l,f+28|0);f=ya+8|0;d=c[f>>2]|0;c[d+12>>2]=c[ga+12>>2];c[d>>2]=c[ga>>2];e=ga+4|0;c[d+4>>2]=c[e>>2];xa=ga+8|0;c[d+8>>2]=c[xa>>2];c[xa>>2]=0;c[e>>2]=0;c[ga>>2]=0;c[f>>2]=d+16;Ra(m,ya);Sa(ya)}Ha(ga);break a}default:break d}}break}default:{}}while(0);g=eb(d,e,f)|0;if((g|0)==(d|0)){g=Wb(d,e,f)|0;if((g|0)!=(d|0)?(ua=c[f+4>>2]|0,(c[f>>2]|0)!=(ua|0)):0){m=f+16|0;c[va>>2]=c[f+12>>2];Pb(wa,ua+-24|0,va);h=f+20|0;j=c[h>>2]|0;d=c[f+24>>2]|0;k=d;if(j>>>0<d>>>0){c[j+12>>2]=c[wa+12>>2];c[j>>2]=c[wa>>2];ya=wa+4|0;c[j+4>>2]=c[ya>>2];f=wa+8|0;c[j+8>>2]=c[f>>2];c[f>>2]=0;c[ya>>2]=0;c[wa>>2]=0;c[h>>2]=(c[h>>2]|0)+16}else{h=c[m>>2]|0;d=j-h|0;l=d>>4;j=l+1|0;if((d|0)<-16)Pa();h=k-h|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<j>>>0?j:h}else h=2147483647;Qa(ya,h,l,f+28|0);f=ya+8|0;d=c[f>>2]|0;c[d+12>>2]=c[wa+12>>2];c[d>>2]=c[wa>>2];e=wa+4|0;c[d+4>>2]=c[e>>2];xa=wa+8|0;c[d+8>>2]=c[xa>>2];c[xa>>2]=0;c[e>>2]=0;c[wa>>2]=0;c[f>>2]=d+16;Ra(m,ya);Sa(ya)}Ha(wa)}else g=d}}}else g=d;while(0);i=za;return g|0}function Oa(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;c[e>>2]=0;if((b|0)!=(d|0)){d=a[b>>0]|0;if(d<<24>>24==114){c[e>>2]=4;d=b+1|0;b=d;d=a[d>>0]|0;f=4}else f=0;if(d<<24>>24==86){f=f|2;c[e>>2]=f;d=b+1|0;b=d;d=a[d>>0]|0}if(d<<24>>24==75){c[e>>2]=f|1;b=b+1|0}}return b|0}function Pa(){oa(120,143,303,246)}function Qa(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Da(c[e>>2]|0,b<<4)|0;c[a>>2]=e;d=e+(d<<4)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<4);return}function Ra(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=c[a>>2]|0;f=a+4|0;g=b+4|0;d=c[f>>2]|0;while(1){if((d|0)==(e|0))break;k=c[g>>2]|0;i=k+-16|0;h=d+-16|0;c[i>>2]=0;j=k+-12|0;c[j>>2]=0;l=c[d+-4>>2]|0;c[k+-8>>2]=0;c[k+-4>>2]=l;c[i>>2]=c[h>>2];i=d+-12|0;c[j>>2]=c[i>>2];j=d+-8|0;c[k+-8>>2]=c[j>>2];c[j>>2]=0;c[i>>2]=0;c[h>>2]=0;c[g>>2]=(c[g>>2]|0)+-16;d=h}j=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=j;j=b+8|0;l=c[f>>2]|0;c[f>>2]=c[j>>2];c[j>>2]=l;j=a+8|0;l=b+12|0;k=c[j>>2]|0;c[j>>2]=c[l>>2];c[l>>2]=k;c[b>>2]=c[g>>2];return}function Sa(a){a=a|0;var b=0,d=0,e=0;b=c[a+4>>2]|0;d=a+8|0;while(1){e=c[d>>2]|0;if((e|0)==(b|0))break;e=e+-16|0;c[d>>2]=e;Ha(e)}b=c[a>>2]|0;if(b)Ka(c[c[a+16>>2]>>2]|0,b,(c[a+12>>2]|0)-b|0);return}function Ta(a,b,c){a=a|0;b=b|0;c=c|0;return Ua(a,b,c,bc(c)|0)|0}function Ua(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;g=a[b>>0]|0;h=(g&1)==0;if(h)i=(g&255)>>>1;else i=c[b+4>>2]|0;if(i>>>0<d>>>0)Va();if(h)h=10;else{g=c[b>>2]|0;h=(g&-2)+-1|0;g=g&255}if((h-i|0)>>>0>=f>>>0){if(f){if(!(g&1))h=b+1|0;else h=c[b+8>>2]|0;if((i|0)==(d|0))g=h+d|0;else{g=h+d|0;Hc(g+f|0,g|0,i-d|0)|0;e=g>>>0<=e>>>0&(h+i|0)>>>0>e>>>0?e+f|0:e}Hc(g|0,e|0,f|0)|0;g=i+f|0;if(!(a[b>>0]&1))a[b>>0]=g<<1;else c[b+4>>2]=g;a[h+g>>0]=0}}else Wa(b,h,i+f-h|0,i,d,0,f,e);return b|0}function Va(){oa(274,303,1175,406)}function Wa(b,d,e,f,g,h,i,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0;if((-18-d|0)>>>0<e>>>0)Xa();if(!(a[b>>0]&1))m=b+1|0;else m=c[b+8>>2]|0;if(d>>>0<2147483623){k=e+d|0;l=d<<1;k=k>>>0<l>>>0?l:k;k=k>>>0<11?11:k+16&-16}else k=-17;l=vc(k)|0;if(g)Fc(l|0,m|0,g|0)|0;if(i)Fc(l+g|0,j|0,i|0)|0;e=f-h|0;if((e|0)!=(g|0))Fc(l+g+i|0,m+g+h|0,e-g|0)|0;if((d|0)!=10)wc(m);c[b+8>>2]=l;c[b>>2]=k|1;d=e+i|0;c[b+4>>2]=d;a[l+d>>0]=0;return}function Xa(){oa(427,303,1164,246)}function Ya(a,b){a=a|0;b=b|0;return Za(a,b,bc(b)|0)|0}function Za(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=a[b>>0]|0;if(!(f&1))h=10;else{f=c[b>>2]|0;h=(f&-2)+-1|0;f=f&255}g=(f&1)==0;if(g)f=(f&255)>>>1;else f=c[b+4>>2]|0;if((h-f|0)>>>0>=e>>>0){if(e){if(g)g=b+1|0;else g=c[b+8>>2]|0;Fc(g+f|0,d|0,e|0)|0;f=f+e|0;if(!(a[b>>0]&1))a[b>>0]=f<<1;else c[b+4>>2]=f;a[g+f>>0]=0}}else Wa(b,h,e-h+f|0,f,f,0,e,d);return b|0}function _a(b,d){b=b|0;d=d|0;if(!(a[d>>0]&1)){c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2]}else $a(b,c[d+8>>2]|0,c[d+4>>2]|0);return}function $a(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if(e>>>0>4294967279)Xa();if(e>>>0<11){a[b>>0]=e<<1;b=b+1|0}else{g=e+16&-16;f=vc(g)|0;c[b+8>>2]=f;c[b>>2]=g|1;c[b+4>>2]=e;b=f}Fc(b|0,d|0,e|0)|0;a[b+e>>0]=0;return}function ab(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Da(c[e>>2]|0,b*24|0)|0;c[a>>2]=e;d=e+(d*24|0)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b*24|0);return}function bb(a){a=a|0;var b=0,d=0,e=0;b=c[a+4>>2]|0;d=a+8|0;while(1){e=c[d>>2]|0;if((e|0)==(b|0))break;e=e+-24|0;c[d>>2]=e;Ia(e)}b=c[a>>2]|0;if(b)Ka(c[c[a+16>>2]>>2]|0,b,(c[a+12>>2]|0)-b|0);return}function cb(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;e=c[a>>2]|0;f=a+4|0;g=b+4|0;d=c[f>>2]|0;while(1){if((d|0)==(e|0))break;h=d+-24|0;db((c[g>>2]|0)+-24|0,h);c[g>>2]=(c[g>>2]|0)+-24;d=h}h=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=h;h=b+8|0;e=c[f>>2]|0;c[f>>2]=c[h>>2];c[h>>2]=e;f=a+8|0;h=b+12|0;a=c[f>>2]|0;c[f>>2]=c[h>>2];c[h>>2]=a;c[b>>2]=c[g>>2];return}function db(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];d=0;while(1){if((d|0)==3)break;c[b+(d<<2)>>2]=0;d=d+1|0}d=a+12|0;b=b+12|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];d=0;while(1){if((d|0)==3)break;c[b+(d<<2)>>2]=0;d=d+1|0}return}function eb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;N=i;i=i+720|0;M=N+696|0;j=N+672|0;J=N+648|0;s=N+624|0;u=N+600|0;v=N+576|0;w=N+552|0;x=N+528|0;y=N+504|0;z=N+480|0;A=N+456|0;k=N+432|0;l=N+408|0;m=N+384|0;L=N+360|0;n=N+336|0;o=N+312|0;p=N+288|0;K=N+264|0;q=N+240|0;r=N+216|0;t=N+192|0;B=N+168|0;C=N+144|0;D=N+120|0;E=N+96|0;F=N+72|0;G=N+48|0;H=N+24|0;I=N;a:do if((b|0)!=(d|0))do switch(a[b>>0]|0){case 118:{fb(j,476);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,j);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,j);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(j);b=b+1|0;break a}case 119:{a[J>>0]=14;f=J+1|0;a[f>>0]=a[481]|0;a[f+1>>0]=a[482]|0;a[f+2>>0]=a[483]|0;a[f+3>>0]=a[484]|0;a[f+4>>0]=a[485]|0;a[f+5>>0]=a[486]|0;a[f+6>>0]=a[487]|0;a[J+8>>0]=0;f=J+12|0;d=0;while(1){if((d|0)==3)break;c[f+(d<<2)>>2]=0;d=d+1|0}f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,J);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,J);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(J);b=b+1|0;break a}case 98:{fb(s,489);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,s);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,s);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(s);b=b+1|0;break a}case 99:{fb(u,494);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,u);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,u);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(u);b=b+1|0;break a}case 97:{gb(v,499);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,v);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,v);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(v);b=b+1|0;break a}case 104:{hb(w,511);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,w);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,w);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(w);b=b+1|0;break a}case 115:{ib(x,525);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,x);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,x);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(x);b=b+1|0;break a}case 116:{jb(y,531);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,y);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,y);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(y);b=b+1|0;break a}case 105:{kb(z,546);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,z);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,z);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(z);b=b+1|0;break a}case 106:{lb(A,550);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,A);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,A);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(A);b=b+1|0;break a}case 108:{fb(k,563);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,k);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,k);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(k);b=b+1|0;break a}case 109:{hb(l,568);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,l);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,l);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(l);b=b+1|0;break a}case 120:{mb(m,582);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,m);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,m);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(m);b=b+1|0;break a}case 121:{f=vc(32)|0;c[L+8>>2]=f;c[L>>2]=33;c[L+4>>2]=18;d=f;g=592;h=d+18|0;do{a[d>>0]=a[g>>0]|0;d=d+1|0;g=g+1|0}while((d|0)<(h|0));a[f+18>>0]=0;f=L+12|0;d=0;while(1){if((d|0)==3)break;c[f+(d<<2)>>2]=0;d=d+1|0}f=e+4|0;d=c[f>>2]|0;K=c[e+8>>2]|0;g=K;if(d>>>0<K>>>0){db(d,L);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;K=d-f|0;h=(K|0)/24|0;d=h+1|0;if((K|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);K=M+8|0;J=c[K>>2]|0;db(J,L);c[K>>2]=J+24;cb(e,M);bb(M)}Ia(L);b=b+1|0;break a}case 110:{nb(n,611);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,n);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,n);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(n);b=b+1|0;break a}case 111:{ob(o,620);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,o);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,o);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(o);b=b+1|0;break a}case 102:{ib(p,638);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,p);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,p);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(p);b=b+1|0;break a}case 100:{a[K>>0]=12;f=K+1|0;a[f>>0]=a[644]|0;a[f+1>>0]=a[645]|0;a[f+2>>0]=a[646]|0;a[f+3>>0]=a[647]|0;a[f+4>>0]=a[648]|0;a[f+5>>0]=a[649]|0;a[K+7>>0]=0;f=K+12|0;d=0;while(1){if((d|0)==3)break;c[f+(d<<2)>>2]=0;d=d+1|0}f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,K);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;J=c[L>>2]|0;db(J,K);c[L>>2]=J+24;cb(e,M);bb(M)}Ia(K);b=b+1|0;break a}case 101:{gb(q,651);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,q);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,q);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(q);b=b+1|0;break a}case 103:{pb(r,663);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,r);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,r);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(r);b=b+1|0;break a}case 122:{kb(t,674);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,t);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,t);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(t);b=b+1|0;break a}case 117:{M=b+1|0;e=qb(M,d,e)|0;b=(e|0)==(M|0)?b:e;break a}case 68:{f=b+1|0;if((f|0)==(d|0))break a;switch(a[f>>0]|0){case 100:{mb(B,711);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,B);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,B);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(B);b=b+2|0;break a}case 101:{pb(C,721);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,C);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,C);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(C);b=b+2|0;break a}case 102:{mb(D,732);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,D);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,D);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(D);b=b+2|0;break a}case 104:{mb(E,742);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,E);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,E);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(E);b=b+2|0;break a}case 105:{nb(F,752);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,F);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,F);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(F);b=b+2|0;break a}case 115:{nb(G,761);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,G);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,G);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(G);b=b+2|0;break a}case 97:{fb(H,770);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,H);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,H);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(H);b=b+2|0;break a}case 110:{jb(I,775);f=e+4|0;d=c[f>>2]|0;L=c[e+8>>2]|0;g=L;if(d>>>0<L>>>0){db(d,I);c[f>>2]=(c[f>>2]|0)+24}else{f=c[e>>2]|0;L=d-f|0;h=(L|0)/24|0;d=h+1|0;if((L|0)<-24)Pa();f=(g-f|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<d>>>0?d:f}else f=2147483647;ab(M,f,h,e+12|0);L=M+8|0;K=c[L>>2]|0;db(K,I);c[L>>2]=K+24;cb(e,M);bb(M)}Ia(I);b=b+2|0;break a}default:break a}}default:break a}while(0);while(0);i=N;return b|0}function fb(b,e){b=b|0;e=e|0;var f=0;a[b>>0]=8;f=b+1|0;e=d[e>>0]|d[e+1>>0]<<8|d[e+2>>0]<<16|d[e+3>>0]<<24;a[f>>0]=e;a[f+1>>0]=e>>8;a[f+2>>0]=e>>16;a[f+3>>0]=e>>24;a[b+5>>0]=0;e=b+12|0;b=0;while(1){if((b|0)==3)break;c[e+(b<<2)>>2]=0;b=b+1|0}return}function gb(a,b){a=a|0;b=b|0;$a(a,b,11);b=a+12|0;a=0;while(1){if((a|0)==3)break;c[b+(a<<2)>>2]=0;a=a+1|0}return}function hb(a,b){a=a|0;b=b|0;$a(a,b,13);b=a+12|0;a=0;while(1){if((a|0)==3)break;c[b+(a<<2)>>2]=0;a=a+1|0}return}function ib(b,d){b=b|0;d=d|0;var e=0;a[b>>0]=10;e=b+1|0;a[e>>0]=a[d>>0]|0;a[e+1>>0]=a[d+1>>0]|0;a[e+2>>0]=a[d+2>>0]|0;a[e+3>>0]=a[d+3>>0]|0;a[e+4>>0]=a[d+4>>0]|0;a[b+6>>0]=0;d=b+12|0;b=0;while(1){if((b|0)==3)break;c[d+(b<<2)>>2]=0;b=b+1|0}return}function jb(a,b){a=a|0;b=b|0;$a(a,b,14);b=a+12|0;a=0;while(1){if((a|0)==3)break;c[b+(a<<2)>>2]=0;a=a+1|0}return}function kb(b,d){b=b|0;d=d|0;var e=0;a[b>>0]=6;e=b+1|0;a[e>>0]=a[d>>0]|0;a[e+1>>0]=a[d+1>>0]|0;a[e+2>>0]=a[d+2>>0]|0;a[b+4>>0]=0;d=b+12|0;b=0;while(1){if((b|0)==3)break;c[d+(b<<2)>>2]=0;b=b+1|0}return}function lb(a,b){a=a|0;b=b|0;$a(a,b,12);b=a+12|0;a=0;while(1){if((a|0)==3)break;c[b+(a<<2)>>2]=0;a=a+1|0}return}function mb(b,d){b=b|0;d=d|0;var e=0,f=0;a[b>>0]=18;f=b+1|0;e=f+9|0;do{a[f>>0]=a[d>>0]|0;f=f+1|0;d=d+1|0}while((f|0)<(e|0));a[b+10>>0]=0;d=b+12|0;e=0;while(1){if((e|0)==3)break;c[d+(e<<2)>>2]=0;e=e+1|0}return}function nb(b,e){b=b|0;e=e|0;var f=0,g=0,h=0;a[b>>0]=16;f=e;h=f;h=d[h>>0]|d[h+1>>0]<<8|d[h+2>>0]<<16|d[h+3>>0]<<24;f=f+4|0;f=d[f>>0]|d[f+1>>0]<<8|d[f+2>>0]<<16|d[f+3>>0]<<24;e=b+1|0;g=e;a[g>>0]=h;a[g+1>>0]=h>>8;a[g+2>>0]=h>>16;a[g+3>>0]=h>>24;e=e+4|0;a[e>>0]=f;a[e+1>>0]=f>>8;a[e+2>>0]=f>>16;a[e+3>>0]=f>>24;a[b+9>>0]=0;e=b+12|0;b=0;while(1){if((b|0)==3)break;c[e+(b<<2)>>2]=0;b=b+1|0}return}function ob(a,b){a=a|0;b=b|0;$a(a,b,17);b=a+12|0;a=0;while(1){if((a|0)==3)break;c[b+(a<<2)>>2]=0;a=a+1|0}return}function pb(b,d){b=b|0;d=d|0;var e=0,f=0;a[b>>0]=20;f=b+1|0;e=f+10|0;do{a[f>>0]=a[d>>0]|0;f=f+1|0;d=d+1|0}while((f|0)<(e|0));a[b+11>>0]=0;d=b+12|0;e=0;while(1){if((e|0)==3)break;c[d+(e<<2)>>2]=0;e=e+1|0}return}function qb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+112|0;o=q+88|0;p=q+64|0;h=q+76|0;l=q+40|0;j=q+16|0;k=q;a:do if(((b|0)!=(d|0)?(g=(a[b>>0]|0)+-48|0,g>>>0<10):0)?(f=b+1|0,(f|0)!=(d|0)):0){m=f;n=g;while(1){g=(a[m>>0]|0)+-48|0;if(g>>>0>=10)break;f=m+1|0;if((f|0)==(d|0))break a;m=f;n=g+(n*10|0)|0}if((d-m|0)>>>0>=n>>>0){$a(p,m,n);f=a[p>>0]|0;d=(f&1)==0;f=d?(f&255)>>>1:c[p+4>>2]|0;$a(h,d?p+1|0:c[p+8>>2]|0,f>>>0<10?f:10);f=a[h>>0]|0;d=(f&1)==0;f=d?(f&255)>>>1:c[h+4>>2]|0;g=f>>>0>10;d=ac(d?h+1|0:c[h+8>>2]|0,678,g?10:f)|0;Ja(h);if(!(((d|0)==0?(f>>>0<10?-1:g&1):d)|0)){b=vc(32)|0;c[l+8>>2]=b;c[l>>2]=33;c[l+4>>2]=21;f=b;g=689;h=f+21|0;do{a[f>>0]=a[g>>0]|0;f=f+1|0;g=g+1|0}while((f|0)<(h|0));a[b+21>>0]=0;b=l+12|0;f=0;while(1){if((f|0)==3)break;c[b+(f<<2)>>2]=0;f=f+1|0}b=e+4|0;f=c[b>>2]|0;k=c[e+8>>2]|0;g=k;if(f>>>0<k>>>0){db(f,l);c[b>>2]=(c[b>>2]|0)+24}else{b=c[e>>2]|0;k=f-b|0;h=(k|0)/24|0;f=h+1|0;if((k|0)<-24)Pa();b=(g-b|0)/24|0;if(b>>>0<1073741823){b=b<<1;b=b>>>0<f>>>0?f:b}else b=2147483647;ab(o,b,h,e+12|0);k=o+8|0;j=c[k>>2]|0;db(j,l);c[k>>2]=j+24;cb(e,o);bb(o)}Ia(l)}else{c[k>>2]=c[p>>2];c[k+4>>2]=c[p+4>>2];c[k+8>>2]=c[p+8>>2];b=0;while(1){if((b|0)==3)break;c[p+(b<<2)>>2]=0;b=b+1|0}rb(j,k);b=e+4|0;f=c[b>>2]|0;l=c[e+8>>2]|0;g=l;if(f>>>0<l>>>0){db(f,j);c[b>>2]=(c[b>>2]|0)+24}else{b=c[e>>2]|0;l=f-b|0;h=(l|0)/24|0;f=h+1|0;if((l|0)<-24)Pa();b=(g-b|0)/24|0;if(b>>>0<1073741823){b=b<<1;b=b>>>0<f>>>0?f:b}else b=2147483647;ab(o,b,h,e+12|0);l=o+8|0;d=c[l>>2]|0;db(d,j);c[l>>2]=d+24;cb(e,o);bb(o)}Ia(j);Ja(k)}Ja(p);b=m+n|0}}while(0);i=q;return b|0}function rb(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];d=0;while(1){if((d|0)==3)break;c[b+(d<<2)>>2]=0;d=d+1|0}d=a+12|0;b=0;while(1){if((b|0)==3)break;c[d+(b<<2)>>2]=0;b=b+1|0}return}function sb(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=a[b>>0]|0;if(!(d&1)){e=(d&255)>>>1;h=b+1|0}else{e=c[b+4>>2]|0;h=c[b+8>>2]|0}f=(e|0)!=0&1;g=e-f|0;if((e|0)!=(f|0)){Hc(h|0,h+f|0,g|0)|0;d=a[b>>0]|0}if(!(d&1))a[b>>0]=g<<1;else c[b+4>>2]=g;a[h+g>>0]=0;return}function tb(b,c){b=b|0;c=c|0;var d=0,e=0;a:do if((b|0)!=(c|0)?(d=(a[b>>0]|0)==110?b+1|0:b,(d|0)!=(c|0)):0){e=a[d>>0]|0;if(e<<24>>24==48){d=d+1|0;break}if((e+-49&255)<9)do{d=d+1|0;if((d|0)==(c|0)){d=c;break a}}while(((a[d>>0]|0)+-48|0)>>>0<10);else d=b}else d=b;while(0);return d|0}
function Sb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+112|0;r=s+88|0;m=s+64|0;n=s+48|0;l=s+24|0;o=s+12|0;p=s;a:do if((b|0)!=(d|0)){g=a[b>>0]|0;h=g<<24>>24;switch(h|0){case 68:case 67:{b:do if((d-b|0)>1?(k=e+4|0,f=c[k>>2]|0,(c[e>>2]|0)!=(f|0)):0){switch(h|0){case 67:{switch(a[b+1>>0]|0){case 53:case 51:case 50:case 49:break;default:break b}Tb(n,f+-24|0);rb(m,n);f=c[k>>2]|0;d=c[e+8>>2]|0;j=d;if(f>>>0<d>>>0){db(f,m);c[k>>2]=(c[k>>2]|0)+24}else{g=c[e>>2]|0;d=f-g|0;k=(d|0)/24|0;h=k+1|0;if((d|0)<-24)Pa();f=(j-g|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<h>>>0?h:f}else f=2147483647;ab(r,f,k,e+12|0);d=r+8|0;q=c[d>>2]|0;db(q,m);c[d>>2]=q+24;cb(e,r);bb(r)}Ia(m);Ja(n);a[e+60>>0]=1;b=b+2|0;break b}case 68:break;default:break b}switch(a[b+1>>0]|0){case 53:case 50:case 49:case 48:break;default:break b}Tb(p,f+-24|0);f=Ta(p,0,886)|0;c[o>>2]=c[f>>2];c[o+4>>2]=c[f+4>>2];c[o+8>>2]=c[f+8>>2];g=0;while(1){if((g|0)==3)break;c[f+(g<<2)>>2]=0;g=g+1|0}rb(l,o);f=c[k>>2]|0;d=c[e+8>>2]|0;j=d;if(f>>>0<d>>>0){db(f,l);c[k>>2]=(c[k>>2]|0)+24}else{g=c[e>>2]|0;d=f-g|0;k=(d|0)/24|0;h=k+1|0;if((d|0)<-24)Pa();f=(j-g|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<h>>>0?h:f}else f=2147483647;ab(r,f,k,e+12|0);d=r+8|0;q=c[d>>2]|0;db(q,l);c[d>>2]=q+24;cb(e,r);bb(r)}Ia(l);Ja(o);Ja(p);a[e+60>>0]=1;b=b+2|0}while(0);break a}case 85:{c:do if((d-b|0)>2&g<<24>>24==85){switch(a[b+1>>0]|0){case 116:{$a(n,1808,8);rb(m,n);l=e+4|0;f=c[l>>2]|0;q=c[e+8>>2]|0;g=q;if(f>>>0<q>>>0){db(f,m);c[l>>2]=(c[l>>2]|0)+24}else{h=c[e>>2]|0;q=f-h|0;k=(q|0)/24|0;j=k+1|0;if((q|0)<-24)Pa();f=(g-h|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<j>>>0?j:f}else f=2147483647;ab(r,f,k,e+12|0);q=r+8|0;p=c[q>>2]|0;db(p,m);c[q>>2]=p+24;cb(e,r);bb(r)}Ia(m);Ja(n);f=b+2|0;if((f|0)==(d|0)){g=c[l>>2]|0;f=g+-24|0;while(1){if((g|0)==(f|0))break c;d=g+-24|0;c[l>>2]=d;Ia(d);g=c[l>>2]|0}}if(((a[f>>0]|0)+-48|0)>>>0<10){g=b+3|0;while(1){if((g|0)==(d|0)){g=d;break}if(((a[g>>0]|0)+-48|0)>>>0>=10)break;g=g+1|0}Bb((c[l>>2]|0)+-24|0,f,g);f=g}zb((c[l>>2]|0)+-24|0,39);if((f|0)!=(d|0)?(a[f>>0]|0)==95:0){b=f+1|0;break c}g=c[l>>2]|0;f=g+-24|0;while(1){if((g|0)==(f|0))break c;d=g+-24|0;c[l>>2]=d;Ia(d);g=c[l>>2]|0}}case 108:break;default:break c}$a(o,1817,9);rb(l,o);q=e+4|0;f=c[q>>2]|0;n=c[e+8>>2]|0;g=n;if(f>>>0<n>>>0){db(f,l);c[q>>2]=(c[q>>2]|0)+24}else{h=c[e>>2]|0;n=f-h|0;k=(n|0)/24|0;j=k+1|0;if((n|0)<-24)Pa();f=(g-h|0)/24|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<j>>>0?j:f}else f=2147483647;ab(r,f,k,e+12|0);n=r+8|0;m=c[n>>2]|0;db(m,l);c[n>>2]=m+24;cb(e,r);bb(r)}Ia(l);Ja(o);f=b+2|0;do if((a[f>>0]|0)!=118){g=Na(f,d,e)|0;if((g|0)==(f|0)){g=c[q>>2]|0;f=g+-24|0;while(1){if((g|0)==(f|0))break c;d=g+-24|0;c[q>>2]=d;Ia(d);g=c[q>>2]|0}}f=c[q>>2]|0;if(((f-(c[e>>2]|0)|0)/24|0)>>>0<2)break c;Cb(r,f+-24|0);j=c[q>>2]|0;f=j+-24|0;h=j;while(1){if((h|0)==(f|0))break;o=h+-24|0;c[q>>2]=o;Ia(o);h=c[q>>2]|0}h=a[r>>0]|0;l=(h&1)==0;m=r+8|0;n=r+1|0;o=r+4|0;Za(j+-48|0,l?n:c[m>>2]|0,l?(h&255)>>>1:c[o>>2]|0)|0;while(1){l=Na(g,d,e)|0;if((l|0)==(g|0)){f=91;break}f=c[q>>2]|0;if(((f-(c[e>>2]|0)|0)/24|0)>>>0<2){f=129;break}Cb(p,f+-24|0);d:do if(!(h&1)){a[n>>0]=0;a[r>>0]=0}else{g=c[m>>2]|0;a[g>>0]=0;c[o>>2]=0;f=c[r>>2]|0;k=(f&-2)+-1|0;h=f&255;do if(!(h&1)){f=f>>>1&127;if((h&255)<22){Fc(n|0,g|0,f+1|0)|0;wc(g);break}g=f+16&240;j=g+-1|0;if((j|0)==(k|0))break d;h=vc(g)|0;if(j>>>0<=k>>>0&(h|0)==0)break d;Fc(h|0,n|0,f+1|0)|0;c[r>>2]=g|1;c[o>>2]=f;c[m>>2]=h;break d}else{a[n>>0]=0;wc(g);f=0}while(0);a[r>>0]=f<<1}while(0);c[r>>2]=c[p>>2];c[r+4>>2]=c[p+4>>2];c[r+8>>2]=c[p+8>>2];f=0;while(1){if((f|0)==3)break;c[p+(f<<2)>>2]=0;f=f+1|0}Ja(p);j=c[q>>2]|0;f=j+-24|0;g=j;while(1){if((g|0)==(f|0))break;k=g+-24|0;c[q>>2]=k;Ia(k);g=c[q>>2]|0}h=a[r>>0]|0;f=(h&1)==0;g=f?(h&255)>>>1:c[o>>2]|0;if(!g){g=l;continue}Ya(j+-48|0,1429)|0;Za((c[q>>2]|0)+-24|0,f?n:c[m>>2]|0,g)|0;g=l}if((f|0)==91){Ya((c[q>>2]|0)+-24|0,799)|0;Ja(r);break}else if((f|0)==129){Ja(r);break c}}else{zb((c[q>>2]|0)+-24|0,41);g=b+3|0}while(0);if((g|0)!=(d|0)?(a[g>>0]|0)==69:0){f=g+1|0;if((f|0)==(d|0)){g=c[q>>2]|0;f=g+-24|0;while(1){if((g|0)==(f|0))break c;d=g+-24|0;c[q>>2]=d;Ia(d);g=c[q>>2]|0}}e:do if(((a[f>>0]|0)+-48|0)>>>0<10){g=g+2|0;while(1){if((g|0)==(d|0)){g=d;break}if(((a[g>>0]|0)+-48|0)>>>0>=10)break;g=g+1|0}p=c[q>>2]|0;e=p+-24|0;h=a[e>>0]|0;l=p+-16|0;if(!(h&1)){j=l;k=e+1|0;o=(h&255)>>>1;m=10}else{k=c[l>>2]|0;h=c[e>>2]|0;j=k+7|0;o=c[p+-20>>2]|0;m=(h&-2)+-1|0;h=h&255}n=j-k|0;k=g-f|0;if((g|0)!=(f|0)){if((m-o|0)>>>0>=k>>>0){if(!(h&1))h=e+1|0;else h=c[l>>2]|0;if((o|0)==(n|0))j=h;else{j=h+n|0;Hc(j+k|0,j|0,o-n|0)|0;j=h}}else{Ab(e,m,o+k-m|0,o,n,k);j=c[l>>2]|0}h=o+k|0;if(!(a[e>>0]&1))a[e>>0]=h<<1;else c[p+-20>>2]=h;a[j+h>>0]=0;h=j+n|0;while(1){if((f|0)==(g|0)){f=g;break e}a[h>>0]=a[f>>0]|0;f=f+1|0;h=h+1|0}}}while(0);if((f|0)!=(d|0)?(a[f>>0]|0)==95:0){b=f+1|0;break}g=c[q>>2]|0;f=g+-24|0;while(1){if((g|0)==(f|0))break c;d=g+-24|0;c[q>>2]=d;Ia(d);g=c[q>>2]|0}}g=c[q>>2]|0;f=g+-24|0;while(1){if((g|0)==(f|0))break c;d=g+-24|0;c[q>>2]=d;Ia(d);g=c[q>>2]|0}}while(0);break a}case 57:case 56:case 55:case 54:case 53:case 52:case 51:case 50:case 49:{b=qb(b,d,e)|0;break a}default:{d=Lb(b,d,e)|0;i=s;return d|0}}}while(0);i=s;return b|0}function Tb(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;h=a[d>>0]|0;e=(h&1)==0;h=e?(h&255)>>>1:c[d+4>>2]|0;a:do if(!h)_a(b,d);else{f=e?d+1|0:c[d+8>>2]|0;e=h>>>0>11;g=ac(f,1478,e?11:h)|0;if(!(((g|0)==0?(h>>>0<11?-1:e&1):g)|0)){Ub(d,1530,70);$a(b,1601,12);break}e=h>>>0>12;g=e?12:h;i=ac(f,1490,g)|0;e=h>>>0<12?-1:e&1;if(!(((i|0)==0?e:i)|0)){Ub(d,1614,49);$a(b,1664,13);break}i=ac(f,1503,g)|0;if(!(((i|0)==0?e:i)|0)){Ub(d,1678,49);$a(b,1728,13);break}g=h>>>0>13;i=ac(f,1516,g?13:h)|0;if(!(((i|0)==0?(h>>>0<13?-1:g&1):i)|0)){Ub(d,1742,50);$a(b,1793,14);break}e=f+h|0;b:do if((a[e+-1>>0]|0)==62){g=1;c:while(1){h=e;d:while(1){e=h+-1|0;if((e|0)==(f|0))break c;h=h+-2|0;switch(a[h>>0]|0){case 60:{d=18;break d}case 62:{d=19;break d}default:h=e}}if((d|0)==18){g=g+-1|0;if(!g){e=h;break b}else continue}else if((d|0)==19){g=g+1|0;continue}}e=0;while(1){if((e|0)==3)break a;c[b+(e<<2)>>2]=0;e=e+1|0}}while(0);h=e;while(1){g=h+-1|0;if((g|0)==(f|0))break;if((a[g>>0]|0)==58){f=h;break}else h=g}d=e-f|0;if(d>>>0>4294967279)Xa();if(d>>>0<11){a[b>>0]=d<<1;h=b+1|0}else{i=d+16&-16;h=vc(i)|0;c[b+8>>2]=h;c[b>>2]=i|1;c[b+4>>2]=d}g=h;while(1){if((f|0)==(e|0))break;a[g>>0]=a[f>>0]|0;f=f+1|0;g=g+1|0}a[h+d>>0]=0}while(0);return}function Ub(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=a[b>>0]|0;if(!(f&1))h=10;else{f=c[b>>2]|0;h=(f&-2)+-1|0;f=f&255}g=(f&1)==0;do if(h>>>0>=e>>>0){if(g)f=b+1|0;else f=c[b+8>>2]|0;Hc(f|0,d|0,e|0)|0;a[f+e>>0]=0;if(!(a[b>>0]&1)){a[b>>0]=e<<1;break}else{c[b+4>>2]=e;break}}else{if(g)f=(f&255)>>>1;else f=c[b+4>>2]|0;Wa(b,h,e-h|0,f,0,f,e,d)}while(0);return}function Vb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;k=i;i=i+16|0;j=k;if((b|0)!=(d|0)?(f=qb(b,d,e)|0,(f|0)!=(b|0)):0){h=Mb(f,d,e)|0;if((h|0)!=(f|0)){g=e+4|0;f=c[g>>2]|0;if(((f-(c[e>>2]|0)|0)/24|0)>>>0<2)f=b;else{Cb(j,f+-24|0);f=c[g>>2]|0;d=f+-24|0;e=f;while(1){if((e|0)==(d|0))break;b=e+-24|0;c[g>>2]=b;Ia(b);e=c[g>>2]|0}g=a[j>>0]|0;b=(g&1)==0;Za(f+-48|0,b?j+1|0:c[j+8>>2]|0,b?(g&255)>>>1:c[j+4>>2]|0)|0;Ja(j);f=h}}}else f=b;i=k;return f|0}function Wb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0;ua=i;i=i+208|0;ta=ua+188|0;ra=ua+184|0;pa=ua+172|0;ba=ua+160|0;ca=ua+144|0;ha=ua+140|0;ia=ua+128|0;ja=ua+112|0;ka=ua+108|0;la=ua+96|0;ma=ua+64|0;na=ua+56|0;oa=ua+40|0;da=ua+36|0;ea=ua+24|0;fa=ua+8|0;ga=ua;n=ua+80|0;k=ua+60|0;m=d;a:do if((m-b|0)>1){sa=(a[b>>0]|0)==76?b+1|0:b;f=a[sa>>0]|0;switch(f<<24>>24|0){case 78:{b:do if((sa|0)!=(d|0))if(f<<24>>24==78){f=Oa(sa+1|0,d,ra)|0;c:do if((f|0)!=(d|0)){h=e+52|0;c[h>>2]=0;switch(a[f>>0]|0){case 82:{c[h>>2]=1;f=f+1|0;break}case 79:{c[h>>2]=2;f=f+1|0;break}default:{}}aa=e+4|0;j=c[aa>>2]|0;$=c[e+8>>2]|0;h=$;if(j>>>0<$>>>0){c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;h=0;while(1){if((h|0)==3)break;c[j+(h<<2)>>2]=0;h=h+1|0}h=j+12|0;j=0;while(1){if((j|0)==3)break;c[h+(j<<2)>>2]=0;j=j+1|0}c[aa>>2]=(c[aa>>2]|0)+24}else{k=c[e>>2]|0;$=j-k|0;l=($|0)/24|0;j=l+1|0;if(($|0)<-24)Pa();h=(h-k|0)/24|0;if(h>>>0<1073741823){h=h<<1;h=h>>>0<j>>>0?j:h}else h=2147483647;ab(ta,h,l,e+12|0);k=ta+8|0;l=c[k>>2]|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;c[l+20>>2]=0;h=0;while(1){if((h|0)==3)break;c[l+(h<<2)>>2]=0;h=h+1|0}h=l+12|0;j=0;while(1){if((j|0)==3)break;c[h+(j<<2)>>2]=0;j=j+1|0}c[k>>2]=l+24;cb(e,ta);bb(ta)}if(((m-f|0)>1?(a[f>>0]|0)==83:0)?(a[f+1>>0]|0)==116:0){Ub((c[aa>>2]|0)+-24|0,2080,3);f=f+2|0}if((f|0)==(d|0)){g=c[aa>>2]|0;f=g+-24|0;while(1){if((g|0)==(f|0))break c;ta=g+-24|0;c[aa>>2]=ta;Ia(ta);g=c[aa>>2]|0}}I=pa+8|0;J=pa+1|0;K=pa+4|0;L=e+12|0;M=e+16|0;$=e+20|0;N=e+24|0;O=oa+12|0;P=oa+4|0;Q=oa+8|0;R=e+28|0;S=ta+8|0;T=fa+12|0;U=fa+4|0;V=fa+8|0;W=ta+8|0;X=ea+8|0;Y=ea+1|0;Z=ea+4|0;_=ba+8|0;o=ba+1|0;p=ba+4|0;q=ca+12|0;r=ca+4|0;s=ca+8|0;t=ta+8|0;u=ja+12|0;v=ja+4|0;w=ja+8|0;x=ta+8|0;y=ia+8|0;z=ia+1|0;A=ia+4|0;B=ma+12|0;C=ma+4|0;D=ma+8|0;E=ta+8|0;F=la+8|0;G=la+1|0;H=la+4|0;n=0;d:while(1){h=f;e:while(1){f=a[h>>0]|0;if(f<<24>>24==69){qa=129;break d}switch(f<<24>>24|0){case 83:{qa=39;break e}case 84:{qa=59;break e}case 68:{qa=77;break e}case 73:break;case 76:{f=h+1|0;if((f|0)==(d|0))break c;else{h=f;continue e}}default:break e}m=Mb(h,d,e)|0;if((m|0)==(h|0)|(m|0)==(d|0))break c;Cb(pa,(c[aa>>2]|0)+-24|0);f=c[aa>>2]|0;h=f+-24|0;j=f;while(1){if((j|0)==(h|0))break;l=j+-24|0;c[aa>>2]=l;Ia(l);j=c[aa>>2]|0}l=a[pa>>0]|0;h=(l&1)==0;Za(f+-48|0,h?J:c[I>>2]|0,h?(l&255)>>>1:c[K>>2]|0)|0;f=(c[aa>>2]|0)+-24|0;c[da>>2]=c[L>>2];Pb(oa,f,da);f=c[$>>2]|0;l=c[N>>2]|0;h=l;if(f>>>0<l>>>0){c[f+12>>2]=c[O>>2];c[f>>2]=c[oa>>2];c[f+4>>2]=c[P>>2];c[f+8>>2]=c[Q>>2];c[Q>>2]=0;c[P>>2]=0;c[oa>>2]=0;c[$>>2]=(c[$>>2]|0)+16}else{j=c[M>>2]|0;f=f-j|0;l=f>>4;k=l+1|0;if((f|0)<-16){qa=104;break d}f=h-j|0;if(f>>4>>>0<1073741823){f=f>>3;f=f>>>0<k>>>0?k:f}else f=2147483647;Qa(ta,f,l,R);l=c[S>>2]|0;c[l+12>>2]=c[O>>2];c[l>>2]=c[oa>>2];c[l+4>>2]=c[P>>2];c[l+8>>2]=c[Q>>2];c[Q>>2]=0;c[P>>2]=0;c[oa>>2]=0;c[S>>2]=l+16;Ra(M,ta);Sa(ta)}Ha(oa);Ja(pa);h=m}f:do if((qa|0)==39){qa=0;n=h+1|0;if((n|0)!=(d|0)?(a[n>>0]|0)==116:0)break;f=Rb(h,d,e)|0;if((f|0)==(h|0)|(f|0)==(d|0))break c;Cb(pa,(c[aa>>2]|0)+-24|0);k=c[aa>>2]|0;h=k+-24|0;j=k;while(1){if((j|0)==(h|0))break;n=j+-24|0;c[aa>>2]=n;Ia(n);j=c[aa>>2]|0}j=k+-48|0;h=a[j>>0]|0;if(!(h&1))h=(h&255)>>>1;else h=c[k+-44>>2]|0;if(!h)Xb(j,pa);else{xb(ba,891,pa);h=a[ba>>0]|0;n=(h&1)==0;Za(j,n?o:c[_>>2]|0,n?(h&255)>>>1:c[p>>2]|0)|0;Ja(ba);h=(c[aa>>2]|0)+-24|0;c[ha>>2]=c[L>>2];Pb(ca,h,ha);h=c[$>>2]|0;n=c[N>>2]|0;j=n;if(h>>>0<n>>>0){c[h+12>>2]=c[q>>2];c[h>>2]=c[ca>>2];c[h+4>>2]=c[r>>2];c[h+8>>2]=c[s>>2];c[s>>2]=0;c[r>>2]=0;c[ca>>2]=0;c[$>>2]=(c[$>>2]|0)+16}else{k=c[M>>2]|0;n=h-k|0;m=n>>4;l=m+1|0;if((n|0)<-16){qa=52;break d}h=j-k|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<l>>>0?l:h}else h=2147483647;Qa(ta,h,m,R);n=c[t>>2]|0;c[n+12>>2]=c[q>>2];c[n>>2]=c[ca>>2];c[n+4>>2]=c[r>>2];c[n+8>>2]=c[s>>2];c[s>>2]=0;c[r>>2]=0;c[ca>>2]=0;c[t>>2]=n+16;Ra(M,ta);Sa(ta)}Ha(ca)}Ja(pa);n=1;continue d}else if((qa|0)==59){qa=0;f=Eb(h,d,e)|0;if((f|0)==(h|0)|(f|0)==(d|0))break c;Cb(pa,(c[aa>>2]|0)+-24|0);k=c[aa>>2]|0;h=k+-24|0;j=k;while(1){if((j|0)==(h|0))break;n=j+-24|0;c[aa>>2]=n;Ia(n);j=c[aa>>2]|0}j=k+-48|0;h=a[j>>0]|0;if(!(h&1))h=(h&255)>>>1;else h=c[k+-44>>2]|0;if(!h)Xb(j,pa);else{xb(ia,891,pa);n=a[ia>>0]|0;m=(n&1)==0;Za(j,m?z:c[y>>2]|0,m?(n&255)>>>1:c[A>>2]|0)|0;Ja(ia)}h=(c[aa>>2]|0)+-24|0;c[ka>>2]=c[L>>2];Pb(ja,h,ka);h=c[$>>2]|0;n=c[N>>2]|0;j=n;if(h>>>0<n>>>0){c[h+12>>2]=c[u>>2];c[h>>2]=c[ja>>2];c[h+4>>2]=c[v>>2];c[h+8>>2]=c[w>>2];c[w>>2]=0;c[v>>2]=0;c[ja>>2]=0;c[$>>2]=(c[$>>2]|0)+16}else{k=c[M>>2]|0;n=h-k|0;m=n>>4;l=m+1|0;if((n|0)<-16){qa=72;break d}h=j-k|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<l>>>0?l:h}else h=2147483647;Qa(ta,h,m,R);n=c[x>>2]|0;c[n+12>>2]=c[u>>2];c[n>>2]=c[ja>>2];c[n+4>>2]=c[v>>2];c[n+8>>2]=c[w>>2];c[w>>2]=0;c[v>>2]=0;c[ja>>2]=0;c[x>>2]=n+16;Ra(M,ta);Sa(ta)}Ha(ja);Ja(pa);n=1;continue d}else if((qa|0)==77){qa=0;f=h+1|0;if((f|0)!=(d|0))switch(a[f>>0]|0){case 84:case 116:break;default:break f}f=Qb(h,d,e)|0;if((f|0)==(h|0)|(f|0)==(d|0))break c;Cb(pa,(c[aa>>2]|0)+-24|0);k=c[aa>>2]|0;h=k+-24|0;j=k;while(1){if((j|0)==(h|0))break;n=j+-24|0;c[aa>>2]=n;Ia(n);j=c[aa>>2]|0}j=k+-48|0;h=a[j>>0]|0;if(!(h&1))h=(h&255)>>>1;else h=c[k+-44>>2]|0;if(!h)Xb(j,pa);else{xb(la,891,pa);n=a[la>>0]|0;m=(n&1)==0;Za(j,m?G:c[F>>2]|0,m?(n&255)>>>1:c[H>>2]|0)|0;Ja(la)}h=(c[aa>>2]|0)+-24|0;c[na>>2]=c[L>>2];Pb(ma,h,na);h=c[$>>2]|0;n=c[N>>2]|0;j=n;if(h>>>0<n>>>0){c[h+12>>2]=c[B>>2];c[h>>2]=c[ma>>2];c[h+4>>2]=c[C>>2];c[h+8>>2]=c[D>>2];c[D>>2]=0;c[C>>2]=0;c[ma>>2]=0;c[$>>2]=(c[$>>2]|0)+16}else{k=c[M>>2]|0;n=h-k|0;m=n>>4;l=m+1|0;if((n|0)<-16){qa=92;break d}h=j-k|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<l>>>0?l:h}else h=2147483647;Qa(ta,h,m,R);n=c[E>>2]|0;c[n+12>>2]=c[B>>2];c[n>>2]=c[ma>>2];c[n+4>>2]=c[C>>2];c[n+8>>2]=c[D>>2];c[D>>2]=0;c[C>>2]=0;c[ma>>2]=0;c[E>>2]=n+16;Ra(M,ta);Sa(ta)}Ha(ma);Ja(pa);n=1;continue d}while(0);f=Sb(h,d,e)|0;if((f|0)==(h|0)|(f|0)==(d|0))break c;Cb(pa,(c[aa>>2]|0)+-24|0);k=c[aa>>2]|0;h=k+-24|0;j=k;while(1){if((j|0)==(h|0))break;n=j+-24|0;c[aa>>2]=n;Ia(n);j=c[aa>>2]|0}j=k+-48|0;h=a[j>>0]|0;if(!(h&1))h=(h&255)>>>1;else h=c[k+-44>>2]|0;if(!h)Xb(j,pa);else{xb(ea,891,pa);n=a[ea>>0]|0;m=(n&1)==0;Za(j,m?Y:c[X>>2]|0,m?(n&255)>>>1:c[Z>>2]|0)|0;Ja(ea)}h=(c[aa>>2]|0)+-24|0;c[ga>>2]=c[L>>2];Pb(fa,h,ga);h=c[$>>2]|0;n=c[N>>2]|0;j=n;if(h>>>0<n>>>0){c[h+12>>2]=c[T>>2];c[h>>2]=c[fa>>2];c[h+4>>2]=c[U>>2];c[h+8>>2]=c[V>>2];c[V>>2]=0;c[U>>2]=0;c[fa>>2]=0;c[$>>2]=(c[$>>2]|0)+16}else{k=c[M>>2]|0;n=h-k|0;m=n>>4;l=m+1|0;if((n|0)<-16){qa=123;break}h=j-k|0;if(h>>4>>>0<1073741823){h=h>>3;h=h>>>0<l>>>0?l:h}else h=2147483647;Qa(ta,h,m,R);n=c[W>>2]|0;c[n+12>>2]=c[T>>2];c[n>>2]=c[fa>>2];c[n+4>>2]=c[U>>2];c[n+8>>2]=c[V>>2];c[V>>2]=0;c[U>>2]=0;c[fa>>2]=0;c[W>>2]=n+16;Ra(M,ta);Sa(ta)}Ha(fa);Ja(pa);n=1}if((qa|0)==52)Pa();else if((qa|0)==72)Pa();else if((qa|0)==92)Pa();else if((qa|0)==104)Pa();else if((qa|0)==123)Pa();else if((qa|0)==129){f=h+1|0;c[e+48>>2]=c[ra>>2];g:do if(n?(g=c[$>>2]|0,(c[e+16>>2]|0)!=(g|0)):0){h=g+-16|0;while(1){if((g|0)==(h|0))break g;ta=g+-16|0;c[$>>2]=ta;Ha(ta);g=c[$>>2]|0}}while(0);break b}}while(0);f=sa}else f=sa;else f=d;while(0);f=(f|0)==(sa|0)?b:f;break a}case 90:{h:do if(((f<<24>>24==90&(sa|0)!=(d|0)?(ra=sa+1|0,h=Ma(ra,d,e)|0,!((h|0)==(ra|0)|(h|0)==(d|0))):0)?(a[h>>0]|0)==69:0)?(j=h+1|0,(j|0)!=(d|0)):0)switch(a[j>>0]|0){case 115:{f=Yb(h+2|0,d)|0;g=c[e+4>>2]|0;if((c[e>>2]|0)==(g|0))break h;Ya(g+-24|0,2084)|0;break h}case 100:{f=h+2|0;if((f|0)==(d|0)){f=sa;break h}f=tb(f,d)|0;if((f|0)==(d|0)){f=sa;break h}if((a[f>>0]|0)!=95){f=sa;break h}ra=f+1|0;f=Wb(ra,d,e)|0;k=e+4|0;if((f|0)==(ra|0)){g=c[k>>2]|0;f=g+-24|0;while(1){if((g|0)==(f|0)){f=sa;break h}ta=g+-24|0;c[k>>2]=ta;Ia(ta);g=c[k>>2]|0}}g=c[k>>2]|0;if(((g-(c[e>>2]|0)|0)/24|0)>>>0<2){f=sa;break h}Cb(ta,g+-24|0);g=c[k>>2]|0;h=g+-24|0;j=g;while(1){if((j|0)==(h|0))break;e=j+-24|0;c[k>>2]=e;Ia(e);j=c[k>>2]|0}Ya(g+-48|0,891)|0;e=a[ta>>0]|0;d=(e&1)==0;Za((c[k>>2]|0)+-24|0,d?ta+1|0:c[ta+8>>2]|0,d?(e&255)>>>1:c[ta+4>>2]|0)|0;Ja(ta);break h}default:{f=Wb(j,d,e)|0;if((f|0)==(j|0)){f=e+4|0;h=c[f>>2]|0;g=h+-24|0;while(1){if((h|0)==(g|0)){f=sa;break h}ta=h+-24|0;c[f>>2]=ta;Ia(ta);h=c[f>>2]|0}}f=Yb(f,d)|0;k=e+4|0;g=c[k>>2]|0;if(((g-(c[e>>2]|0)|0)/24|0)>>>0<2)break h;Cb(ta,g+-24|0);g=c[k>>2]|0;h=g+-24|0;j=g;while(1){if((j|0)==(h|0))break;e=j+-24|0;c[k>>2]=e;Ia(e);j=c[k>>2]|0}Ya(g+-48|0,891)|0;e=a[ta>>0]|0;d=(e&1)==0;Za((c[k>>2]|0)+-24|0,d?ta+1|0:c[ta+8>>2]|0,d?(e&255)>>>1:c[ta+4>>2]|0)|0;Ja(ta);break h}}else f=sa;while(0);f=(f|0)==(sa|0)?b:f;break a}default:{do if((m-sa|0)>1){if(f<<24>>24==83?(a[sa+1>>0]|0)==116:0){f=sa+2|0;if((f|0)==(d|0)){h=0;g=d}else{h=0;g=(a[f>>0]|0)==76?sa+3|0:f}}else{h=1;g=sa}f=Sb(g,d,e)|0;g=(f|0)==(g|0);if(h|g)f=g?sa:f;else{g=c[e+4>>2]|0;if((c[e>>2]|0)==(g|0))break;Ta(g+-24|0,0,1827)|0}if((f|0)!=(sa|0)){if((f|0)==(d|0)){f=d;break a}if((a[f>>0]|0)!=73)break a;m=e+4|0;g=c[m>>2]|0;if((c[e>>2]|0)==(g|0)){f=b;break a}l=e+16|0;c[k>>2]=c[e+12>>2];Pb(n,g+-24|0,k);g=e+20|0;h=c[g>>2]|0;sa=c[e+24>>2]|0;j=sa;if(h>>>0<sa>>>0){c[h+12>>2]=c[n+12>>2];c[h>>2]=c[n>>2];sa=n+4|0;c[h+4>>2]=c[sa>>2];ra=n+8|0;c[h+8>>2]=c[ra>>2];c[ra>>2]=0;c[sa>>2]=0;c[n>>2]=0;c[g>>2]=(c[g>>2]|0)+16}else{g=c[l>>2]|0;sa=h-g|0;k=sa>>4;h=k+1|0;if((sa|0)<-16)Pa();g=j-g|0;if(g>>4>>>0<1073741823){g=g>>3;g=g>>>0<h>>>0?h:g}else g=2147483647;Qa(ta,g,k,e+28|0);sa=ta+8|0;ra=c[sa>>2]|0;c[ra+12>>2]=c[n+12>>2];c[ra>>2]=c[n>>2];qa=n+4|0;c[ra+4>>2]=c[qa>>2];pa=n+8|0;c[ra+8>>2]=c[pa>>2];c[pa>>2]=0;c[qa>>2]=0;c[n>>2]=0;c[sa>>2]=ra+16;Ra(l,ta);Sa(ta)}Ha(n);j=Mb(f,d,e)|0;if((j|0)==(f|0)){f=b;break a}f=c[m>>2]|0;if(((f-(c[e>>2]|0)|0)/24|0)>>>0<2){f=b;break a}Cb(ta,f+-24|0);f=c[m>>2]|0;g=f+-24|0;h=f;while(1){if((h|0)==(g|0))break;b=h+-24|0;c[m>>2]=b;Ia(b);h=c[m>>2]|0}b=a[ta>>0]|0;sa=(b&1)==0;Za(f+-48|0,sa?ta+1|0:c[ta+8>>2]|0,sa?(b&255)>>>1:c[ta+4>>2]|0)|0;Ja(ta);f=j;break a}}while(0);g=Rb(sa,d,e)|0;if((g|0)==(sa|0)|(g|0)==(d|0)){f=b;break a}if((a[g>>0]|0)!=73){f=b;break a}f=Mb(g,d,e)|0;if((f|0)==(g|0)){f=b;break a}k=e+4|0;g=c[k>>2]|0;if(((g-(c[e>>2]|0)|0)/24|0)>>>0<2){f=b;break a}Cb(ta,g+-24|0);g=c[k>>2]|0;h=g+-24|0;j=g;while(1){if((j|0)==(h|0))break;b=j+-24|0;c[k>>2]=b;Ia(b);j=c[k>>2]|0}b=a[ta>>0]|0;sa=(b&1)==0;Za(g+-48|0,sa?ta+1|0:c[ta+8>>2]|0,sa?(b&255)>>>1:c[ta+4>>2]|0)|0;Ja(ta);break a}}}else f=b;while(0);i=ua;return f|0}function Xb(b,d){b=b|0;d=d|0;var e=0,f=0;if((b|0)!=(d|0)){e=a[d>>0]|0;f=(e&1)==0;Ub(b,f?d+1|0:c[d+8>>2]|0,f?(e&255)>>>1:c[d+4>>2]|0)}return}function Yb(b,c){b=b|0;c=c|0;var d=0,e=0;a:do if((b|0)!=(c|0)){d=a[b>>0]|0;if(d<<24>>24!=95){if(((d<<24>>24)+-48|0)>>>0>=10)break;while(1){b=b+1|0;if((b|0)==(c|0)){b=c;break a}if(((a[b>>0]|0)+-48|0)>>>0>=10)break a}}d=b+1|0;if((d|0)!=(c|0)){d=a[d>>0]|0;if(((d<<24>>24)+-48|0)>>>0<10){b=b+2|0;break}if(d<<24>>24==95){e=b+2|0;while(1){if((e|0)==(c|0))break a;d=a[e>>0]|0;if(((d<<24>>24)+-48|0)>>>0>=10)break;e=e+1|0}return (d<<24>>24==95?e+1|0:b)|0}}}while(0);return b|0}function Zb(b,c){b=b|0;c=c|0;var d=0,e=0,f=0;a:do if((b|0)!=(c|0)){switch(a[b>>0]|0){case 104:{e=b+1|0;d=tb(e,c)|0;if((d|0)==(e|0)|(d|0)==(c|0))break a;return ((a[d>>0]|0)==95?d+1|0:b)|0}case 118:break;default:break a}f=b+1|0;d=tb(f,c)|0;if((!((d|0)==(f|0)|(d|0)==(c|0))?(a[d>>0]|0)==95:0)?(f=d+1|0,e=tb(f,c)|0,!((e|0)==(f|0)|(e|0)==(c|0))):0)b=(a[e>>0]|0)==95?e+1|0:b}while(0);return b|0}function _b(a){a=a|0;$b(a+32|0);Ga(a+16|0);Ha(a);return}function $b(a){a=a|0;var b=0,d=0,e=0;b=c[a>>2]|0;if(b){d=a+4|0;while(1){e=c[d>>2]|0;if((e|0)==(b|0))break;e=e+-16|0;c[d>>2]=e;Ga(e)}e=c[a>>2]|0;Ka(c[a+12>>2]|0,e,(c[a+8>>2]|0)-e|0)}return}function ac(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0;a:do if(!d)d=0;else{while(1){e=a[b>>0]|0;f=a[c>>0]|0;if(e<<24>>24!=f<<24>>24)break;d=d+-1|0;if(!d){d=0;break a}else{b=b+1|0;c=c+1|0}}d=(e&255)-(f&255)|0}while(0);return d|0}function bc(b){b=b|0;var d=0,e=0,f=0;f=b;a:do if(!(f&3))e=4;else{d=b;b=f;while(1){if(!(a[d>>0]|0))break a;d=d+1|0;b=d;if(!(b&3)){b=d;e=4;break}}}while(0);if((e|0)==4){while(1){d=c[b>>2]|0;if(!((d&-2139062144^-2139062144)&d+-16843009))b=b+4|0;else break}if((d&255)<<24>>24)do b=b+1|0;while((a[b>>0]|0)!=0)}return b-f|0}function cc(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;h=d&255;f=(e|0)!=0;a:do if(f&(b&3|0)!=0){g=d&255;while(1){if((a[b>>0]|0)==g<<24>>24)break a;b=b+1|0;e=e+-1|0;f=(e|0)!=0;if(!(f&(b&3|0)!=0)){i=5;break}}}else i=5;while(0);b:do if((i|0)==5)if(f){g=d&255;if((a[b>>0]|0)!=g<<24>>24){f=_(h,16843009)|0;c:do if(e>>>0>3)while(1){h=c[b>>2]^f;if((h&-2139062144^-2139062144)&h+-16843009)break;b=b+4|0;e=e+-4|0;if(e>>>0<=3){i=11;break c}}else i=11;while(0);if((i|0)==11)if(!e){e=0;break}while(1){if((a[b>>0]|0)==g<<24>>24)break b;b=b+1|0;e=e+-1|0;if(!e){e=0;break}}}}else e=0;while(0);return ((e|0)!=0?b:0)|0}function dc(b){b=b|0;var c=0,e=0;c=0;while(1){if((d[2370+c>>0]|0)==(b|0)){e=2;break}c=c+1|0;if((c|0)==87){c=87;b=2458;e=5;break}}if((e|0)==2)if(!c)c=2458;else{b=2458;e=5}if((e|0)==5)while(1){do{e=b;b=b+1|0}while((a[e>>0]|0)!=0);c=c+-1|0;if(!c){c=b;break}else e=5}return c|0}function ec(){var a=0;if(!(c[1200]|0))a=4844;else a=c[(fa()|0)+60>>2]|0;return a|0}function fc(a){a=a|0;if((a+-48|0)>>>0<10)a=1;else a=((a|32)+-97|0)>>>0<6;return a&1|0}function gc(a){a=a|0;return (a+-65|0)>>>0<26|0}function hc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+128|0;g=n+112|0;m=n;h=m;j=8;k=h+112|0;do{c[h>>2]=c[j>>2];h=h+4|0;j=j+4|0}while((h|0)<(k|0));if((d+-1|0)>>>0>2147483646)if(!d){d=1;l=4}else{c[(ec()|0)>>2]=75;d=-1}else{g=b;l=4}if((l|0)==4){l=-2-g|0;l=d>>>0>l>>>0?l:d;c[m+48>>2]=l;b=m+20|0;c[b>>2]=g;c[m+44>>2]=g;d=g+l|0;g=m+16|0;c[g>>2]=d;c[m+28>>2]=d;d=lc(m,e,f)|0;if(l){e=c[b>>2]|0;a[e+(((e|0)==(c[g>>2]|0))<<31>>31)>>0]=0}}i=n;return d|0}function ic(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=e+16|0;g=c[f>>2]|0;if(!g)if(!(kc(e)|0)){g=c[f>>2]|0;h=5}else f=0;else h=5;a:do if((h|0)==5){i=e+20|0;f=c[i>>2]|0;h=f;if((g-f|0)>>>0<d>>>0){f=ra[c[e+36>>2]&1](e,b,d)|0;break}b:do if((a[e+75>>0]|0)>-1){f=d;while(1){if(!f){g=h;f=0;break b}g=f+-1|0;if((a[b+g>>0]|0)==10)break;else f=g}if((ra[c[e+36>>2]&1](e,b,f)|0)>>>0<f>>>0)break a;d=d-f|0;b=b+f|0;g=c[i>>2]|0}else{g=h;f=0}while(0);Fc(g|0,b|0,d|0)|0;c[i>>2]=(c[i>>2]|0)+d;f=f+d|0}while(0);return f|0}function jc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;c[g>>2]=e;e=hc(a,b,d,g)|0;i=f;return e|0}function kc(b){b=b|0;var d=0,e=0;d=b+74|0;e=a[d>>0]|0;a[d>>0]=e+255|e;d=c[b>>2]|0;if(!(d&8)){c[b+8>>2]=0;c[b+4>>2]=0;d=c[b+44>>2]|0;c[b+28>>2]=d;c[b+20>>2]=d;c[b+16>>2]=d+(c[b+48>>2]|0);d=0}else{c[b>>2]=d|32;d=-1}return d|0}function lc(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+224|0;n=r+120|0;q=r+80|0;p=r;o=r+136|0;f=q;g=f+40|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));c[n>>2]=c[e>>2];if((rc(0,d,n,p,q)|0)<0)e=-1;else{e=c[b>>2]|0;m=e&32;if((a[b+74>>0]|0)<1)c[b>>2]=e&-33;l=b+48|0;if(!(c[l>>2]|0)){f=b+44|0;g=c[f>>2]|0;c[f>>2]=o;h=b+28|0;c[h>>2]=o;j=b+20|0;c[j>>2]=o;c[l>>2]=80;k=b+16|0;c[k>>2]=o+80;e=rc(b,d,n,p,q)|0;if(g){ra[c[b+36>>2]&1](b,0,0)|0;e=(c[j>>2]|0)==0?-1:e;c[f>>2]=g;c[l>>2]=0;c[k>>2]=0;c[h>>2]=0;c[j>>2]=0}}else e=rc(b,d,n,p,q)|0;q=c[b>>2]|0;c[b>>2]=q|m;e=(q&32|0)==0?e:-1}i=r;return e|0}function mc(b,d){b=b|0;d=d|0;do if(b){if(d>>>0<128){a[b>>0]=d;b=1;break}if(d>>>0<2048){a[b>>0]=d>>>6|192;a[b+1>>0]=d&63|128;b=2;break}if(d>>>0<55296|(d&-8192|0)==57344){a[b>>0]=d>>>12|224;a[b+1>>0]=d>>>6&63|128;a[b+2>>0]=d&63|128;b=3;break}if((d+-65536|0)>>>0<1048576){a[b>>0]=d>>>18|240;a[b+1>>0]=d>>>12&63|128;a[b+2>>0]=d>>>6&63|128;a[b+3>>0]=d&63|128;b=4;break}else{c[(ec()|0)>>2]=84;b=-1;break}}else b=1;while(0);return b|0}function nc(a,b){a=a|0;b=b|0;if(!a)a=0;else a=mc(a,b)|0;return a|0}function oc(a,b){a=+a;b=b|0;return +(+pc(a,b))}function pc(a,b){a=+a;b=b|0;var d=0,e=0,f=0;h[k>>3]=a;d=c[k>>2]|0;e=c[k+4>>2]|0;f=Dc(d|0,e|0,52)|0;f=f&2047;switch(f|0){case 0:{if(a!=0.0){a=+pc(a*18446744073709551616.0,b);d=(c[b>>2]|0)+-64|0}else d=0;c[b>>2]=d;break}case 2047:break;default:{c[b>>2]=f+-1022;c[k>>2]=d;c[k+4>>2]=e&-2146435073|1071644672;a=+h[k>>3]}}return +a}function qc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=a+20|0;f=c[e>>2]|0;a=(c[a+16>>2]|0)-f|0;a=a>>>0>d>>>0?d:a;Fc(f|0,b|0,a|0)|0;c[e>>2]=(c[e>>2]|0)+a;return d|0}function rc(e,f,g,j,l){e=e|0;f=f|0;g=g|0;j=j|0;l=l|0;var m=0,n=0,o=0,p=0.0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0;ia=i;i=i+624|0;da=ia+24|0;fa=ia+16|0;ea=ia+588|0;aa=ia+576|0;ca=ia;W=ia+536|0;ha=ia+8|0;ga=ia+528|0;M=(e|0)!=0;N=W+40|0;V=N;W=W+39|0;X=ha+4|0;Y=ea;Z=0-Y|0;$=aa+12|0;aa=aa+11|0;ba=$;O=ba-Y|0;P=-2-Y|0;Q=ba+2|0;R=da+288|0;S=ea+9|0;T=S;U=ea+8|0;m=0;n=0;r=0;x=f;a:while(1){do if((m|0)>-1)if((n|0)>(2147483647-m|0)){c[(ec()|0)>>2]=75;m=-1;break}else{m=n+m|0;break}while(0);f=a[x>>0]|0;if(!(f<<24>>24)){L=244;break}else n=x;b:while(1){switch(f<<24>>24){case 37:{f=n;L=9;break b}case 0:{f=n;break b}default:{}}K=n+1|0;f=a[K>>0]|0;n=K}c:do if((L|0)==9)while(1){L=0;if((a[f+1>>0]|0)!=37)break c;n=n+1|0;f=f+2|0;if((a[f>>0]|0)==37)L=9;else break}while(0);v=n-x|0;if(M?(c[e>>2]&32|0)==0:0)ic(x,v,e)|0;if((n|0)!=(x|0)){n=v;x=f;continue}q=f+1|0;n=a[q>>0]|0;o=(n<<24>>24)+-48|0;if(o>>>0<10){K=(a[f+2>>0]|0)==36;q=K?f+3|0:q;n=a[q>>0]|0;t=K?o:-1;r=K?1:r}else t=-1;f=n<<24>>24;d:do if((f&-32|0)==32){o=0;do{if(!(1<<f+-32&75913))break d;o=1<<(n<<24>>24)+-32|o;q=q+1|0;n=a[q>>0]|0;f=n<<24>>24}while((f&-32|0)==32)}else o=0;while(0);do if(n<<24>>24==42){n=q+1|0;f=(a[n>>0]|0)+-48|0;if(f>>>0<10?(a[q+2>>0]|0)==36:0){c[l+(f<<2)>>2]=10;f=1;q=q+3|0;n=c[j+((a[n>>0]|0)+-48<<3)>>2]|0}else{if(r){m=-1;break a}if(!M){u=o;K=0;q=n;J=0;break}f=(c[g>>2]|0)+(4-1)&~(4-1);K=c[f>>2]|0;c[g>>2]=f+4;f=0;q=n;n=K}if((n|0)<0){u=o|8192;K=f;J=0-n|0}else{u=o;K=f;J=n}}else{f=(n<<24>>24)+-48|0;if(f>>>0<10){n=0;do{n=(n*10|0)+f|0;q=q+1|0;f=(a[q>>0]|0)+-48|0}while(f>>>0<10);if((n|0)<0){m=-1;break a}else{u=o;K=r;J=n}}else{u=o;K=r;J=0}}while(0);e:do if((a[q>>0]|0)==46){f=q+1|0;n=a[f>>0]|0;if(n<<24>>24!=42){o=(n<<24>>24)+-48|0;if(o>>>0<10)n=0;else{r=0;break}while(1){n=(n*10|0)+o|0;f=f+1|0;o=(a[f>>0]|0)+-48|0;if(o>>>0>=10){r=n;break e}}}f=q+2|0;n=(a[f>>0]|0)+-48|0;if(n>>>0<10?(a[q+3>>0]|0)==36:0){c[l+(n<<2)>>2]=10;r=c[j+((a[f>>0]|0)+-48<<3)>>2]|0;f=q+4|0;break}if(K){m=-1;break a}if(M){I=(c[g>>2]|0)+(4-1)&~(4-1);r=c[I>>2]|0;c[g>>2]=I+4}else r=0}else{r=-1;f=q}while(0);s=0;while(1){n=(a[f>>0]|0)+-65|0;if(n>>>0>57){m=-1;break a}I=f+1|0;n=a[4266+(s*58|0)+n>>0]|0;o=n&255;if((o+-1|0)>>>0<8){f=I;s=o}else break}if(!(n<<24>>24)){m=-1;break}q=(t|0)>-1;do if(n<<24>>24==19)if(q){m=-1;break a}else L=52;else{if(q){c[l+(t<<2)>>2]=o;G=j+(t<<3)|0;H=c[G+4>>2]|0;L=ca;c[L>>2]=c[G>>2];c[L+4>>2]=H;L=52;break}if(!M){m=0;break a}sc(ca,o,g)}while(0);if((L|0)==52?(L=0,!M):0){n=v;r=K;x=I;continue}t=a[f>>0]|0;t=(s|0)!=0&(t&15|0)==3?t&-33:t;o=u&-65537;H=(u&8192|0)==0?u:o;f:do switch(t|0){case 110:switch(s|0){case 0:{c[c[ca>>2]>>2]=m;n=v;r=K;x=I;continue a}case 1:{c[c[ca>>2]>>2]=m;n=v;r=K;x=I;continue a}case 2:{n=c[ca>>2]|0;c[n>>2]=m;c[n+4>>2]=((m|0)<0)<<31>>31;n=v;r=K;x=I;continue a}case 3:{b[c[ca>>2]>>1]=m;n=v;r=K;x=I;continue a}case 4:{a[c[ca>>2]>>0]=m;n=v;r=K;x=I;continue a}case 6:{c[c[ca>>2]>>2]=m;n=v;r=K;x=I;continue a}case 7:{n=c[ca>>2]|0;c[n>>2]=m;c[n+4>>2]=((m|0)<0)<<31>>31;n=v;r=K;x=I;continue a}default:{n=v;r=K;x=I;continue a}}case 112:{s=H|8;r=r>>>0>8?r:8;t=120;L=64;break}case 88:case 120:{s=H;L=64;break}case 111:{o=ca;n=c[o>>2]|0;o=c[o+4>>2]|0;if((n|0)==0&(o|0)==0)f=N;else{f=N;do{f=f+-1|0;a[f>>0]=n&7|48;n=Dc(n|0,o|0,3)|0;o=C}while(!((n|0)==0&(o|0)==0))}if(!(H&8)){n=H;s=0;q=4746;L=77}else{s=V-f|0;n=H;r=(r|0)>(s|0)?r:s+1|0;s=0;q=4746;L=77}break}case 105:case 100:{n=ca;f=c[n>>2]|0;n=c[n+4>>2]|0;if((n|0)<0){f=Cc(0,0,f|0,n|0)|0;n=C;o=ca;c[o>>2]=f;c[o+4>>2]=n;o=1;q=4746;L=76;break f}if(!(H&2048)){q=H&1;o=q;q=(q|0)==0?4746:4748;L=76}else{o=1;q=4747;L=76}break}case 117:{n=ca;f=c[n>>2]|0;n=c[n+4>>2]|0;o=0;q=4746;L=76;break}case 99:{a[W>>0]=c[ca>>2];f=W;t=1;v=0;u=4746;n=N;break}case 109:{n=dc(c[(ec()|0)>>2]|0)|0;L=82;break}case 115:{n=c[ca>>2]|0;n=(n|0)!=0?n:4756;L=82;break}case 67:{c[ha>>2]=c[ca>>2];c[X>>2]=0;c[ca>>2]=ha;f=ha;r=-1;L=86;break}case 83:{f=c[ca>>2]|0;if(!r){uc(e,32,J,0,H);f=0;L=97}else L=86;break}case 65:case 71:case 70:case 69:case 97:case 103:case 102:case 101:{p=+h[ca>>3];c[fa>>2]=0;h[k>>3]=p;if((c[k+4>>2]|0)>=0)if(!(H&2048)){G=H&1;F=G;G=(G|0)==0?4764:4769}else{F=1;G=4766}else{p=-p;F=1;G=4763}h[k>>3]=p;E=c[k+4>>2]&2146435072;do if(E>>>0<2146435072|(E|0)==2146435072&0<0){w=+oc(p,fa)*2.0;n=w!=0.0;if(n)c[fa>>2]=(c[fa>>2]|0)+-1;B=t|32;if((B|0)==97){u=t&32;x=(u|0)==0?G:G+9|0;v=F|2;f=12-r|0;do if(!(r>>>0>11|(f|0)==0)){p=8.0;do{f=f+-1|0;p=p*16.0}while((f|0)!=0);if((a[x>>0]|0)==45){p=-(p+(-w-p));break}else{p=w+p-p;break}}else p=w;while(0);n=c[fa>>2]|0;f=(n|0)<0?0-n|0:n;f=tc(f,((f|0)<0)<<31>>31,$)|0;if((f|0)==($|0)){a[aa>>0]=48;f=aa}a[f+-1>>0]=(n>>31&2)+43;s=f+-2|0;a[s>>0]=t+15;q=(r|0)<1;o=(H&8|0)==0;n=ea;while(1){G=~~p;f=n+1|0;a[n>>0]=d[4730+G>>0]|u;p=(p-+(G|0))*16.0;do if((f-Y|0)==1){if(o&(q&p==0.0))break;a[f>>0]=46;f=n+2|0}while(0);if(!(p!=0.0))break;else n=f}o=s;r=(r|0)!=0&(P+f|0)<(r|0)?Q+r-o|0:O-o+f|0;q=r+v|0;uc(e,32,J,q,H);if(!(c[e>>2]&32))ic(x,v,e)|0;uc(e,48,J,q,H^65536);n=f-Y|0;if(!(c[e>>2]&32))ic(ea,n,e)|0;f=ba-o|0;uc(e,48,r-(n+f)|0,0,0);if(!(c[e>>2]&32))ic(s,f,e)|0;uc(e,32,J,q,H^8192);f=(q|0)<(J|0)?J:q;break}f=(r|0)<0?6:r;if(n){n=(c[fa>>2]|0)+-28|0;c[fa>>2]=n;p=w*268435456.0}else{p=w;n=c[fa>>2]|0}E=(n|0)<0?da:R;D=E;o=E;do{A=~~p>>>0;c[o>>2]=A;o=o+4|0;p=(p-+(A>>>0))*1.0e9}while(p!=0.0);n=c[fa>>2]|0;if((n|0)>0){q=E;r=o;while(1){s=(n|0)>29?29:n;n=r+-4|0;do if(n>>>0>=q>>>0){o=0;do{z=Ec(c[n>>2]|0,0,s|0)|0;z=Gc(z|0,C|0,o|0,0)|0;A=C;y=Pc(z|0,A|0,1e9,0)|0;c[n>>2]=y;o=Oc(z|0,A|0,1e9,0)|0;n=n+-4|0}while(n>>>0>=q>>>0);if(!o)break;q=q+-4|0;c[q>>2]=o}while(0);o=r;while(1){if(o>>>0<=q>>>0)break;n=o+-4|0;if(!(c[n>>2]|0))o=n;else break}n=(c[fa>>2]|0)-s|0;c[fa>>2]=n;if((n|0)>0)r=o;else break}}else q=E;if((n|0)<0){x=((f+25|0)/9|0)+1|0;y=(B|0)==102;do{v=0-n|0;v=(v|0)>9?9:v;do if(q>>>0<o>>>0){n=(1<<v)+-1|0;r=1e9>>>v;u=0;s=q;do{A=c[s>>2]|0;c[s>>2]=(A>>>v)+u;u=_(A&n,r)|0;s=s+4|0}while(s>>>0<o>>>0);n=(c[q>>2]|0)==0?q+4|0:q;if(!u){q=n;n=o;break}c[o>>2]=u;q=n;n=o+4|0}else{q=(c[q>>2]|0)==0?q+4|0:q;n=o}while(0);o=y?E:q;o=(n-o>>2|0)>(x|0)?o+(x<<2)|0:n;n=(c[fa>>2]|0)+v|0;c[fa>>2]=n}while((n|0)<0);x=q;y=o}else{x=q;y=o}do if(x>>>0<y>>>0){n=(D-x>>2)*9|0;q=c[x>>2]|0;if(q>>>0<10)break;else o=10;do{o=o*10|0;n=n+1|0}while(q>>>0>=o>>>0)}else n=0;while(0);z=(B|0)==103;A=(f|0)!=0;o=f-((B|0)!=102?n:0)+((A&z)<<31>>31)|0;if((o|0)<(((y-D>>2)*9|0)+-9|0)){r=o+9216|0;o=E+4+(((r|0)/9|0)+-1024<<2)|0;r=((r|0)%9|0)+1|0;if((r|0)<9){q=10;do{q=q*10|0;r=r+1|0}while((r|0)!=9)}else q=10;u=c[o>>2]|0;v=(u>>>0)%(q>>>0)|0;r=(o+4|0)==(y|0);do if(r&(v|0)==0)q=x;else{w=(((u>>>0)/(q>>>0)|0)&1|0)==0?9007199254740992.0:9007199254740994.0;s=(q|0)/2|0;if(v>>>0<s>>>0)p=.5;else p=r&(v|0)==(s|0)?1.0:1.5;do if(F){if((a[G>>0]|0)!=45)break;w=-w;p=-p}while(0);r=u-v|0;c[o>>2]=r;if(!(w+p!=w)){q=x;break}B=r+q|0;c[o>>2]=B;if(B>>>0>999999999){n=x;while(1){q=o+-4|0;c[o>>2]=0;if(q>>>0<n>>>0){n=n+-4|0;c[n>>2]=0}B=(c[q>>2]|0)+1|0;c[q>>2]=B;if(B>>>0>999999999)o=q;else{s=n;o=q;break}}}else s=x;n=(D-s>>2)*9|0;r=c[s>>2]|0;if(r>>>0<10){q=s;break}else q=10;do{q=q*10|0;n=n+1|0}while(r>>>0>=q>>>0);q=s}while(0);o=o+4|0;x=q;o=y>>>0>o>>>0?o:y}else o=y;v=0-n|0;B=o;while(1){if(B>>>0<=x>>>0){y=0;break}o=B+-4|0;if(!(c[o>>2]|0))B=o;else{y=1;break}}do if(z){f=(A&1^1)+f|0;if((f|0)>(n|0)&(n|0)>-5){t=t+-1|0;f=f+-1-n|0}else{t=t+-2|0;f=f+-1|0}o=H&8;if(o)break;do if(y){o=c[B+-4>>2]|0;if(!o){q=9;break}if(!((o>>>0)%10|0)){r=10;q=0}else{q=0;break}do{r=r*10|0;q=q+1|0}while(((o>>>0)%(r>>>0)|0|0)==0)}else q=9;while(0);o=((B-D>>2)*9|0)+-9|0;if((t|32|0)==102){o=o-q|0;o=(o|0)<0?0:o;f=(f|0)<(o|0)?f:o;o=0;break}else{o=o+n-q|0;o=(o|0)<0?0:o;f=(f|0)<(o|0)?f:o;o=0;break}}else o=H&8;while(0);u=f|o;r=(u|0)!=0&1;s=(t|32|0)==102;if(s){n=(n|0)>0?n:0;t=0}else{q=(n|0)<0?v:n;q=tc(q,((q|0)<0)<<31>>31,$)|0;if((ba-q|0)<2)do{q=q+-1|0;a[q>>0]=48}while((ba-q|0)<2);a[q+-1>>0]=(n>>31&2)+43;D=q+-2|0;a[D>>0]=t;n=ba-D|0;t=D}v=F+1+f+r+n|0;uc(e,32,J,v,H);if(!(c[e>>2]&32))ic(G,F,e)|0;uc(e,48,J,v,H^65536);do if(s){q=x>>>0>E>>>0?E:x;o=q;do{n=tc(c[o>>2]|0,0,S)|0;do if((o|0)==(q|0)){if((n|0)!=(S|0))break;a[U>>0]=48;n=U}else{if(n>>>0<=ea>>>0)break;Bc(ea|0,48,n-Y|0)|0;do n=n+-1|0;while(n>>>0>ea>>>0)}while(0);if(!(c[e>>2]&32))ic(n,T-n|0,e)|0;o=o+4|0}while(o>>>0<=E>>>0);do if(u){if(c[e>>2]&32)break;ic(4798,1,e)|0}while(0);if((f|0)>0&o>>>0<B>>>0)while(1){n=tc(c[o>>2]|0,0,S)|0;if(n>>>0>ea>>>0){Bc(ea|0,48,n-Y|0)|0;do n=n+-1|0;while(n>>>0>ea>>>0)}if(!(c[e>>2]&32))ic(n,(f|0)>9?9:f,e)|0;o=o+4|0;n=f+-9|0;if(!((f|0)>9&o>>>0<B>>>0)){f=n;break}else f=n}uc(e,48,f+9|0,9,0)}else{s=y?B:x+4|0;if((f|0)>-1){r=(o|0)==0;q=x;do{n=tc(c[q>>2]|0,0,S)|0;if((n|0)==(S|0)){a[U>>0]=48;n=U}do if((q|0)==(x|0)){o=n+1|0;if(!(c[e>>2]&32))ic(n,1,e)|0;if(r&(f|0)<1){n=o;break}if(c[e>>2]&32){n=o;break}ic(4798,1,e)|0;n=o}else{if(n>>>0<=ea>>>0)break;Bc(ea|0,48,n+Z|0)|0;do n=n+-1|0;while(n>>>0>ea>>>0)}while(0);o=T-n|0;if(!(c[e>>2]&32))ic(n,(f|0)>(o|0)?o:f,e)|0;f=f-o|0;q=q+4|0}while(q>>>0<s>>>0&(f|0)>-1)}uc(e,48,f+18|0,18,0);if(c[e>>2]&32)break;ic(t,ba-t|0,e)|0}while(0);uc(e,32,J,v,H^8192);f=(v|0)<(J|0)?J:v}else{s=(t&32|0)!=0;r=p!=p|0.0!=0.0;n=r?0:F;q=n+3|0;uc(e,32,J,q,o);f=c[e>>2]|0;if(!(f&32)){ic(G,n,e)|0;f=c[e>>2]|0}if(!(f&32))ic(r?(s?4790:4794):s?4782:4786,3,e)|0;uc(e,32,J,q,H^8192);f=(q|0)<(J|0)?J:q}while(0);n=f;r=K;x=I;continue a}default:{f=x;o=H;t=r;v=0;u=4746;n=N}}while(0);g:do if((L|0)==64){o=ca;n=c[o>>2]|0;o=c[o+4>>2]|0;q=t&32;if(!((n|0)==0&(o|0)==0)){f=N;do{f=f+-1|0;a[f>>0]=d[4730+(n&15)>>0]|q;n=Dc(n|0,o|0,4)|0;o=C}while(!((n|0)==0&(o|0)==0));L=ca;if((s&8|0)==0|(c[L>>2]|0)==0&(c[L+4>>2]|0)==0){n=s;s=0;q=4746;L=77}else{n=s;s=2;q=4746+(t>>4)|0;L=77}}else{f=N;n=s;s=0;q=4746;L=77}}else if((L|0)==76){f=tc(f,n,N)|0;n=H;s=o;L=77}else if((L|0)==82){L=0;H=cc(n,0,r)|0;G=(H|0)==0;f=n;t=G?r:H-n|0;v=0;u=4746;n=G?n+r|0:H}else if((L|0)==86){L=0;o=0;n=0;s=f;while(1){q=c[s>>2]|0;if(!q)break;n=nc(ga,q)|0;if((n|0)<0|n>>>0>(r-o|0)>>>0)break;o=n+o|0;if(r>>>0>o>>>0)s=s+4|0;else break}if((n|0)<0){m=-1;break a}uc(e,32,J,o,H);if(!o){f=0;L=97}else{q=0;while(1){n=c[f>>2]|0;if(!n){f=o;L=97;break g}n=nc(ga,n)|0;q=n+q|0;if((q|0)>(o|0)){f=o;L=97;break g}if(!(c[e>>2]&32))ic(ga,n,e)|0;if(q>>>0>=o>>>0){f=o;L=97;break}else f=f+4|0}}}while(0);if((L|0)==97){L=0;uc(e,32,J,f,H^8192);n=(J|0)>(f|0)?J:f;r=K;x=I;continue}if((L|0)==77){L=0;o=(r|0)>-1?n&-65537:n;n=ca;n=(c[n>>2]|0)!=0|(c[n+4>>2]|0)!=0;if((r|0)!=0|n){t=(n&1^1)+(V-f)|0;t=(r|0)>(t|0)?r:t;v=s;u=q;n=N}else{f=N;t=0;v=s;u=q;n=N}}s=n-f|0;q=(t|0)<(s|0)?s:t;r=v+q|0;n=(J|0)<(r|0)?r:J;uc(e,32,n,r,o);if(!(c[e>>2]&32))ic(u,v,e)|0;uc(e,48,n,r,o^65536);uc(e,48,q,s,0);if(!(c[e>>2]&32))ic(f,s,e)|0;uc(e,32,n,r,o^8192);r=K;x=I}h:do if((L|0)==244)if(!e)if(!r)m=0;else{m=1;while(1){f=c[l+(m<<2)>>2]|0;if(!f){f=0;break}sc(j+(m<<3)|0,f,g);m=m+1|0;if((m|0)>=10){m=1;break h}}while(1){m=m+1|0;if(f){m=-1;break h}if((m|0)>=10){m=1;break h}f=c[l+(m<<2)>>2]|0}}while(0);i=ia;return m|0}function sc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0.0;a:do if(b>>>0<=20)do switch(b|0){case 9:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=b;break a}case 10:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;e=a;c[e>>2]=b;c[e+4>>2]=((b|0)<0)<<31>>31;break a}case 11:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;e=a;c[e>>2]=b;c[e+4>>2]=0;break a}case 12:{e=(c[d>>2]|0)+(8-1)&~(8-1);b=e;f=c[b>>2]|0;b=c[b+4>>2]|0;c[d>>2]=e+8;e=a;c[e>>2]=f;c[e+4>>2]=b;break a}case 13:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;e=(e&65535)<<16>>16;f=a;c[f>>2]=e;c[f+4>>2]=((e|0)<0)<<31>>31;break a}case 14:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;f=a;c[f>>2]=e&65535;c[f+4>>2]=0;break a}case 15:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;e=(e&255)<<24>>24;f=a;c[f>>2]=e;c[f+4>>2]=((e|0)<0)<<31>>31;break a}case 16:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;f=a;c[f>>2]=e&255;c[f+4>>2]=0;break a}case 17:{f=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[f>>3];c[d>>2]=f+8;h[a>>3]=g;break a}case 18:{f=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[f>>3];c[d>>2]=f+8;h[a>>3]=g;break a}default:break a}while(0);while(0);return}function tc(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if(c>>>0>0|(c|0)==0&b>>>0>4294967295)while(1){e=Pc(b|0,c|0,10,0)|0;d=d+-1|0;a[d>>0]=e|48;e=b;b=Oc(b|0,c|0,10,0)|0;if(!(c>>>0>9|(c|0)==9&e>>>0>4294967295))break;else c=C}if(b)while(1){d=d+-1|0;a[d>>0]=(b>>>0)%10|0|48;if(b>>>0<10)break;else b=(b>>>0)/10|0}return d|0}function uc(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;h=i;i=i+256|0;g=h;do if((d|0)>(e|0)&(f&73728|0)==0){f=d-e|0;Bc(g|0,b|0,(f>>>0>256?256:f)|0)|0;e=c[a>>2]|0;d=(e&32|0)==0;if(f>>>0>255){b=f;do{if(d){ic(g,256,a)|0;e=c[a>>2]|0}b=b+-256|0;d=(e&32|0)==0}while(b>>>0>255);if(d)f=f&255;else break}else if(!d)break;ic(g,f,a)|0}while(0);i=h;return}function vc(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;do if(a>>>0<245){o=a>>>0<11?16:a+11&-8;a=o>>>3;j=c[1212]|0;b=j>>>a;if(b&3){b=(b&1^1)+a|0;d=4888+(b<<1<<2)|0;e=d+8|0;f=c[e>>2]|0;g=f+8|0;h=c[g>>2]|0;do if((d|0)!=(h|0)){if(h>>>0<(c[1216]|0)>>>0)ga();a=h+12|0;if((c[a>>2]|0)==(f|0)){c[a>>2]=d;c[e>>2]=h;break}else ga()}else c[1212]=j&~(1<<b);while(0);G=b<<3;c[f+4>>2]=G|3;G=f+G+4|0;c[G>>2]=c[G>>2]|1;G=g;return G|0}h=c[1214]|0;if(o>>>0>h>>>0){if(b){d=2<<a;d=b<<a&(d|0-d);d=(d&0-d)+-1|0;i=d>>>12&16;d=d>>>i;f=d>>>5&8;d=d>>>f;g=d>>>2&4;d=d>>>g;e=d>>>1&2;d=d>>>e;b=d>>>1&1;b=(f|i|g|e|b)+(d>>>b)|0;d=4888+(b<<1<<2)|0;e=d+8|0;g=c[e>>2]|0;i=g+8|0;f=c[i>>2]|0;do if((d|0)!=(f|0)){if(f>>>0<(c[1216]|0)>>>0)ga();a=f+12|0;if((c[a>>2]|0)==(g|0)){c[a>>2]=d;c[e>>2]=f;k=c[1214]|0;break}else ga()}else{c[1212]=j&~(1<<b);k=h}while(0);h=(b<<3)-o|0;c[g+4>>2]=o|3;e=g+o|0;c[e+4>>2]=h|1;c[e+h>>2]=h;if(k){f=c[1217]|0;b=k>>>3;d=4888+(b<<1<<2)|0;a=c[1212]|0;b=1<<b;if(a&b){a=d+8|0;b=c[a>>2]|0;if(b>>>0<(c[1216]|0)>>>0)ga();else{l=a;m=b}}else{c[1212]=a|b;l=d+8|0;m=d}c[l>>2]=f;c[m+12>>2]=f;c[f+8>>2]=m;c[f+12>>2]=d}c[1214]=h;c[1217]=e;G=i;return G|0}a=c[1213]|0;if(a){i=(a&0-a)+-1|0;F=i>>>12&16;i=i>>>F;E=i>>>5&8;i=i>>>E;G=i>>>2&4;i=i>>>G;b=i>>>1&2;i=i>>>b;j=i>>>1&1;j=c[5152+((E|F|G|b|j)+(i>>>j)<<2)>>2]|0;i=(c[j+4>>2]&-8)-o|0;b=j;while(1){a=c[b+16>>2]|0;if(!a){a=c[b+20>>2]|0;if(!a)break}b=(c[a+4>>2]&-8)-o|0;G=b>>>0<i>>>0;i=G?b:i;b=a;j=G?a:j}f=c[1216]|0;if(j>>>0<f>>>0)ga();h=j+o|0;if(j>>>0>=h>>>0)ga();g=c[j+24>>2]|0;d=c[j+12>>2]|0;do if((d|0)==(j|0)){b=j+20|0;a=c[b>>2]|0;if(!a){b=j+16|0;a=c[b>>2]|0;if(!a){n=0;break}}while(1){d=a+20|0;e=c[d>>2]|0;if(e){a=e;b=d;continue}d=a+16|0;e=c[d>>2]|0;if(!e)break;else{a=e;b=d}}if(b>>>0<f>>>0)ga();else{c[b>>2]=0;n=a;break}}else{e=c[j+8>>2]|0;if(e>>>0<f>>>0)ga();a=e+12|0;if((c[a>>2]|0)!=(j|0))ga();b=d+8|0;if((c[b>>2]|0)==(j|0)){c[a>>2]=d;c[b>>2]=e;n=d;break}else ga()}while(0);do if(g){a=c[j+28>>2]|0;b=5152+(a<<2)|0;if((j|0)==(c[b>>2]|0)){c[b>>2]=n;if(!n){c[1213]=c[1213]&~(1<<a);break}}else{if(g>>>0<(c[1216]|0)>>>0)ga();a=g+16|0;if((c[a>>2]|0)==(j|0))c[a>>2]=n;else c[g+20>>2]=n;if(!n)break}b=c[1216]|0;if(n>>>0<b>>>0)ga();c[n+24>>2]=g;a=c[j+16>>2]|0;do if(a)if(a>>>0<b>>>0)ga();else{c[n+16>>2]=a;c[a+24>>2]=n;break}while(0);a=c[j+20>>2]|0;if(a)if(a>>>0<(c[1216]|0)>>>0)ga();else{c[n+20>>2]=a;c[a+24>>2]=n;break}}while(0);if(i>>>0<16){G=i+o|0;c[j+4>>2]=G|3;G=j+G+4|0;c[G>>2]=c[G>>2]|1}else{c[j+4>>2]=o|3;c[h+4>>2]=i|1;c[h+i>>2]=i;a=c[1214]|0;if(a){e=c[1217]|0;b=a>>>3;d=4888+(b<<1<<2)|0;a=c[1212]|0;b=1<<b;if(a&b){a=d+8|0;b=c[a>>2]|0;if(b>>>0<(c[1216]|0)>>>0)ga();else{p=a;q=b}}else{c[1212]=a|b;p=d+8|0;q=d}c[p>>2]=e;c[q+12>>2]=e;c[e+8>>2]=q;c[e+12>>2]=d}c[1214]=i;c[1217]=h}G=j+8|0;return G|0}}}else if(a>>>0<=4294967231){a=a+11|0;o=a&-8;k=c[1213]|0;if(k){d=0-o|0;a=a>>>8;if(a)if(o>>>0>16777215)j=31;else{q=(a+1048320|0)>>>16&8;z=a<<q;p=(z+520192|0)>>>16&4;z=z<<p;j=(z+245760|0)>>>16&2;j=14-(p|q|j)+(z<<j>>>15)|0;j=o>>>(j+7|0)&1|j<<1}else j=0;b=c[5152+(j<<2)>>2]|0;a:do if(!b){a=0;b=0;z=86}else{f=d;a=0;h=o<<((j|0)==31?0:25-(j>>>1)|0);i=b;b=0;while(1){e=c[i+4>>2]&-8;d=e-o|0;if(d>>>0<f>>>0)if((e|0)==(o|0)){a=i;b=i;z=90;break a}else b=i;else d=f;e=c[i+20>>2]|0;i=c[i+16+(h>>>31<<2)>>2]|0;a=(e|0)==0|(e|0)==(i|0)?a:e;e=(i|0)==0;if(e){z=86;break}else{f=d;h=h<<(e&1^1)}}}while(0);if((z|0)==86){if((a|0)==0&(b|0)==0){a=2<<j;a=k&(a|0-a);if(!a)break;q=(a&0-a)+-1|0;m=q>>>12&16;q=q>>>m;l=q>>>5&8;q=q>>>l;n=q>>>2&4;q=q>>>n;p=q>>>1&2;q=q>>>p;a=q>>>1&1;a=c[5152+((l|m|n|p|a)+(q>>>a)<<2)>>2]|0}if(!a){i=d;j=b}else z=90}if((z|0)==90)while(1){z=0;q=(c[a+4>>2]&-8)-o|0;e=q>>>0<d>>>0;d=e?q:d;b=e?a:b;e=c[a+16>>2]|0;if(e){a=e;z=90;continue}a=c[a+20>>2]|0;if(!a){i=d;j=b;break}else z=90}if((j|0)!=0?i>>>0<((c[1214]|0)-o|0)>>>0:0){f=c[1216]|0;if(j>>>0<f>>>0)ga();h=j+o|0;if(j>>>0>=h>>>0)ga();g=c[j+24>>2]|0;d=c[j+12>>2]|0;do if((d|0)==(j|0)){b=j+20|0;a=c[b>>2]|0;if(!a){b=j+16|0;a=c[b>>2]|0;if(!a){s=0;break}}while(1){d=a+20|0;e=c[d>>2]|0;if(e){a=e;b=d;continue}d=a+16|0;e=c[d>>2]|0;if(!e)break;else{a=e;b=d}}if(b>>>0<f>>>0)ga();else{c[b>>2]=0;s=a;break}}else{e=c[j+8>>2]|0;if(e>>>0<f>>>0)ga();a=e+12|0;if((c[a>>2]|0)!=(j|0))ga();b=d+8|0;if((c[b>>2]|0)==(j|0)){c[a>>2]=d;c[b>>2]=e;s=d;break}else ga()}while(0);do if(g){a=c[j+28>>2]|0;b=5152+(a<<2)|0;if((j|0)==(c[b>>2]|0)){c[b>>2]=s;if(!s){c[1213]=c[1213]&~(1<<a);break}}else{if(g>>>0<(c[1216]|0)>>>0)ga();a=g+16|0;if((c[a>>2]|0)==(j|0))c[a>>2]=s;else c[g+20>>2]=s;if(!s)break}b=c[1216]|0;if(s>>>0<b>>>0)ga();c[s+24>>2]=g;a=c[j+16>>2]|0;do if(a)if(a>>>0<b>>>0)ga();else{c[s+16>>2]=a;c[a+24>>2]=s;break}while(0);a=c[j+20>>2]|0;if(a)if(a>>>0<(c[1216]|0)>>>0)ga();else{c[s+20>>2]=a;c[a+24>>2]=s;break}}while(0);do if(i>>>0>=16){c[j+4>>2]=o|3;c[h+4>>2]=i|1;c[h+i>>2]=i;a=i>>>3;if(i>>>0<256){d=4888+(a<<1<<2)|0;b=c[1212]|0;a=1<<a;if(b&a){a=d+8|0;b=c[a>>2]|0;if(b>>>0<(c[1216]|0)>>>0)ga();else{t=a;v=b}}else{c[1212]=b|a;t=d+8|0;v=d}c[t>>2]=h;c[v+12>>2]=h;c[h+8>>2]=v;c[h+12>>2]=d;break}a=i>>>8;if(a)if(i>>>0>16777215)d=31;else{F=(a+1048320|0)>>>16&8;G=a<<F;E=(G+520192|0)>>>16&4;G=G<<E;d=(G+245760|0)>>>16&2;d=14-(E|F|d)+(G<<d>>>15)|0;d=i>>>(d+7|0)&1|d<<1}else d=0;e=5152+(d<<2)|0;c[h+28>>2]=d;a=h+16|0;c[a+4>>2]=0;c[a>>2]=0;a=c[1213]|0;b=1<<d;if(!(a&b)){c[1213]=a|b;c[e>>2]=h;c[h+24>>2]=e;c[h+12>>2]=h;c[h+8>>2]=h;break}d=i<<((d|0)==31?0:25-(d>>>1)|0);e=c[e>>2]|0;while(1){if((c[e+4>>2]&-8|0)==(i|0)){z=148;break}b=e+16+(d>>>31<<2)|0;a=c[b>>2]|0;if(!a){z=145;break}else{d=d<<1;e=a}}if((z|0)==145)if(b>>>0<(c[1216]|0)>>>0)ga();else{c[b>>2]=h;c[h+24>>2]=e;c[h+12>>2]=h;c[h+8>>2]=h;break}else if((z|0)==148){a=e+8|0;b=c[a>>2]|0;G=c[1216]|0;if(b>>>0>=G>>>0&e>>>0>=G>>>0){c[b+12>>2]=h;c[a>>2]=h;c[h+8>>2]=b;c[h+12>>2]=e;c[h+24>>2]=0;break}else ga()}}else{G=i+o|0;c[j+4>>2]=G|3;G=j+G+4|0;c[G>>2]=c[G>>2]|1}while(0);G=j+8|0;return G|0}}}else o=-1;while(0);d=c[1214]|0;if(d>>>0>=o>>>0){a=d-o|0;b=c[1217]|0;if(a>>>0>15){G=b+o|0;c[1217]=G;c[1214]=a;c[G+4>>2]=a|1;c[G+a>>2]=a;c[b+4>>2]=o|3}else{c[1214]=0;c[1217]=0;c[b+4>>2]=d|3;G=b+d+4|0;c[G>>2]=c[G>>2]|1}G=b+8|0;return G|0}a=c[1215]|0;if(a>>>0>o>>>0){E=a-o|0;c[1215]=E;G=c[1218]|0;F=G+o|0;c[1218]=F;c[F+4>>2]=E|1;c[G+4>>2]=o|3;G=G+8|0;return G|0}do if(!(c[1330]|0)){a=ea(30)|0;if(!(a+-1&a)){c[1332]=a;c[1331]=a;c[1333]=-1;c[1334]=-1;c[1335]=0;c[1323]=0;c[1330]=(ja(0)|0)&-16^1431655768;break}else ga()}while(0);h=o+48|0;e=c[1332]|0;i=o+47|0;d=e+i|0;e=0-e|0;j=d&e;if(j>>>0<=o>>>0){G=0;return G|0}a=c[1322]|0;if((a|0)!=0?(t=c[1320]|0,v=t+j|0,v>>>0<=t>>>0|v>>>0>a>>>0):0){G=0;return G|0}b:do if(!(c[1323]&4)){b=c[1218]|0;c:do if(b){f=5296;while(1){a=c[f>>2]|0;if(a>>>0<=b>>>0?(r=f+4|0,(a+(c[r>>2]|0)|0)>>>0>b>>>0):0)break;a=c[f+8>>2]|0;if(!a){z=173;break c}else f=a}a=d-(c[1215]|0)&e;if(a>>>0<2147483647){b=ia(a|0)|0;if((b|0)==((c[f>>2]|0)+(c[r>>2]|0)|0)){if((b|0)!=(-1|0)){h=b;g=a;z=193;break b}}else z=183}}else z=173;while(0);do if((z|0)==173?(u=ia(0)|0,(u|0)!=(-1|0)):0){a=u;b=c[1331]|0;d=b+-1|0;if(!(d&a))a=j;else a=j-a+(d+a&0-b)|0;b=c[1320]|0;d=b+a|0;if(a>>>0>o>>>0&a>>>0<2147483647){v=c[1322]|0;if((v|0)!=0?d>>>0<=b>>>0|d>>>0>v>>>0:0)break;b=ia(a|0)|0;if((b|0)==(u|0)){h=u;g=a;z=193;break b}else z=183}}while(0);d:do if((z|0)==183){d=0-a|0;do if(h>>>0>a>>>0&(a>>>0<2147483647&(b|0)!=(-1|0))?(w=c[1332]|0,w=i-a+w&0-w,w>>>0<2147483647):0)if((ia(w|0)|0)==(-1|0)){ia(d|0)|0;break d}else{a=w+a|0;break}while(0);if((b|0)!=(-1|0)){h=b;g=a;z=193;break b}}while(0);c[1323]=c[1323]|4;z=190}else z=190;while(0);if((((z|0)==190?j>>>0<2147483647:0)?(x=ia(j|0)|0,y=ia(0)|0,x>>>0<y>>>0&((x|0)!=(-1|0)&(y|0)!=(-1|0))):0)?(g=y-x|0,g>>>0>(o+40|0)>>>0):0){h=x;z=193}if((z|0)==193){a=(c[1320]|0)+g|0;c[1320]=a;if(a>>>0>(c[1321]|0)>>>0)c[1321]=a;k=c[1218]|0;do if(k){f=5296;while(1){a=c[f>>2]|0;b=f+4|0;d=c[b>>2]|0;if((h|0)==(a+d|0)){z=203;break}e=c[f+8>>2]|0;if(!e)break;else f=e}if(((z|0)==203?(c[f+12>>2]&8|0)==0:0)?k>>>0<h>>>0&k>>>0>=a>>>0:0){c[b>>2]=d+g;G=k+8|0;G=(G&7|0)==0?0:0-G&7;F=k+G|0;G=g-G+(c[1215]|0)|0;c[1218]=F;c[1215]=G;c[F+4>>2]=G|1;c[F+G+4>>2]=40;c[1219]=c[1334];break}a=c[1216]|0;if(h>>>0<a>>>0){c[1216]=h;i=h}else i=a;b=h+g|0;a=5296;while(1){if((c[a>>2]|0)==(b|0)){z=211;break}a=c[a+8>>2]|0;if(!a){b=5296;break}}if((z|0)==211)if(!(c[a+12>>2]&8)){c[a>>2]=h;m=a+4|0;c[m>>2]=(c[m>>2]|0)+g;m=h+8|0;m=h+((m&7|0)==0?0:0-m&7)|0;a=b+8|0;a=b+((a&7|0)==0?0:0-a&7)|0;l=m+o|0;j=a-m-o|0;c[m+4>>2]=o|3;do if((a|0)!=(k|0)){if((a|0)==(c[1217]|0)){G=(c[1214]|0)+j|0;c[1214]=G;c[1217]=l;c[l+4>>2]=G|1;c[l+G>>2]=G;break}b=c[a+4>>2]|0;if((b&3|0)==1){h=b&-8;f=b>>>3;e:do if(b>>>0>=256){g=c[a+24>>2]|0;e=c[a+12>>2]|0;do if((e|0)==(a|0)){e=a+16|0;d=e+4|0;b=c[d>>2]|0;if(!b){b=c[e>>2]|0;if(!b){E=0;break}else d=e}while(1){e=b+20|0;f=c[e>>2]|0;if(f){b=f;d=e;continue}e=b+16|0;f=c[e>>2]|0;if(!f)break;else{b=f;d=e}}if(d>>>0<i>>>0)ga();else{c[d>>2]=0;E=b;break}}else{f=c[a+8>>2]|0;if(f>>>0<i>>>0)ga();b=f+12|0;if((c[b>>2]|0)!=(a|0))ga();d=e+8|0;if((c[d>>2]|0)==(a|0)){c[b>>2]=e;c[d>>2]=f;E=e;break}else ga()}while(0);if(!g)break;b=c[a+28>>2]|0;d=5152+(b<<2)|0;do if((a|0)!=(c[d>>2]|0)){if(g>>>0<(c[1216]|0)>>>0)ga();b=g+16|0;if((c[b>>2]|0)==(a|0))c[b>>2]=E;else c[g+20>>2]=E;if(!E)break e}else{c[d>>2]=E;if(E)break;c[1213]=c[1213]&~(1<<b);break e}while(0);e=c[1216]|0;if(E>>>0<e>>>0)ga();c[E+24>>2]=g;b=a+16|0;d=c[b>>2]|0;do if(d)if(d>>>0<e>>>0)ga();else{c[E+16>>2]=d;c[d+24>>2]=E;break}while(0);b=c[b+4>>2]|0;if(!b)break;if(b>>>0<(c[1216]|0)>>>0)ga();else{c[E+20>>2]=b;c[b+24>>2]=E;break}}else{d=c[a+8>>2]|0;e=c[a+12>>2]|0;b=4888+(f<<1<<2)|0;do if((d|0)!=(b|0)){if(d>>>0<i>>>0)ga();if((c[d+12>>2]|0)==(a|0))break;ga()}while(0);if((e|0)==(d|0)){c[1212]=c[1212]&~(1<<f);break}do if((e|0)==(b|0))B=e+8|0;else{if(e>>>0<i>>>0)ga();b=e+8|0;if((c[b>>2]|0)==(a|0)){B=b;break}ga()}while(0);c[d+12>>2]=e;c[B>>2]=d}while(0);a=a+h|0;f=h+j|0}else f=j;a=a+4|0;c[a>>2]=c[a>>2]&-2;c[l+4>>2]=f|1;c[l+f>>2]=f;a=f>>>3;if(f>>>0<256){d=4888+(a<<1<<2)|0;b=c[1212]|0;a=1<<a;do if(!(b&a)){c[1212]=b|a;F=d+8|0;G=d}else{a=d+8|0;b=c[a>>2]|0;if(b>>>0>=(c[1216]|0)>>>0){F=a;G=b;break}ga()}while(0);c[F>>2]=l;c[G+12>>2]=l;c[l+8>>2]=G;c[l+12>>2]=d;break}a=f>>>8;do if(!a)d=0;else{if(f>>>0>16777215){d=31;break}F=(a+1048320|0)>>>16&8;G=a<<F;E=(G+520192|0)>>>16&4;G=G<<E;d=(G+245760|0)>>>16&2;d=14-(E|F|d)+(G<<d>>>15)|0;d=f>>>(d+7|0)&1|d<<1}while(0);e=5152+(d<<2)|0;c[l+28>>2]=d;a=l+16|0;c[a+4>>2]=0;c[a>>2]=0;a=c[1213]|0;b=1<<d;if(!(a&b)){c[1213]=a|b;c[e>>2]=l;c[l+24>>2]=e;c[l+12>>2]=l;c[l+8>>2]=l;break}d=f<<((d|0)==31?0:25-(d>>>1)|0);e=c[e>>2]|0;while(1){if((c[e+4>>2]&-8|0)==(f|0)){z=281;break}b=e+16+(d>>>31<<2)|0;a=c[b>>2]|0;if(!a){z=278;break}else{d=d<<1;e=a}}if((z|0)==278)if(b>>>0<(c[1216]|0)>>>0)ga();else{c[b>>2]=l;c[l+24>>2]=e;c[l+12>>2]=l;c[l+8>>2]=l;break}else if((z|0)==281){a=e+8|0;b=c[a>>2]|0;G=c[1216]|0;if(b>>>0>=G>>>0&e>>>0>=G>>>0){c[b+12>>2]=l;c[a>>2]=l;c[l+8>>2]=b;c[l+12>>2]=e;c[l+24>>2]=0;break}else ga()}}else{G=(c[1215]|0)+j|0;c[1215]=G;c[1218]=l;c[l+4>>2]=G|1}while(0);G=m+8|0;return G|0}else b=5296;while(1){a=c[b>>2]|0;if(a>>>0<=k>>>0?(A=a+(c[b+4>>2]|0)|0,A>>>0>k>>>0):0)break;b=c[b+8>>2]|0}f=A+-47|0;b=f+8|0;b=f+((b&7|0)==0?0:0-b&7)|0;f=k+16|0;b=b>>>0<f>>>0?k:b;a=b+8|0;d=h+8|0;d=(d&7|0)==0?0:0-d&7;G=h+d|0;d=g+-40-d|0;c[1218]=G;c[1215]=d;c[G+4>>2]=d|1;c[G+d+4>>2]=40;c[1219]=c[1334];d=b+4|0;c[d>>2]=27;c[a>>2]=c[1324];c[a+4>>2]=c[1325];c[a+8>>2]=c[1326];c[a+12>>2]=c[1327];c[1324]=h;c[1325]=g;c[1327]=0;c[1326]=a;a=b+24|0;do{a=a+4|0;c[a>>2]=7}while((a+4|0)>>>0<A>>>0);if((b|0)!=(k|0)){g=b-k|0;c[d>>2]=c[d>>2]&-2;c[k+4>>2]=g|1;c[b>>2]=g;a=g>>>3;if(g>>>0<256){d=4888+(a<<1<<2)|0;b=c[1212]|0;a=1<<a;if(b&a){a=d+8|0;b=c[a>>2]|0;if(b>>>0<(c[1216]|0)>>>0)ga();else{C=a;D=b}}else{c[1212]=b|a;C=d+8|0;D=d}c[C>>2]=k;c[D+12>>2]=k;c[k+8>>2]=D;c[k+12>>2]=d;break}a=g>>>8;if(a)if(g>>>0>16777215)d=31;else{F=(a+1048320|0)>>>16&8;G=a<<F;E=(G+520192|0)>>>16&4;G=G<<E;d=(G+245760|0)>>>16&2;d=14-(E|F|d)+(G<<d>>>15)|0;d=g>>>(d+7|0)&1|d<<1}else d=0;e=5152+(d<<2)|0;c[k+28>>2]=d;c[k+20>>2]=0;c[f>>2]=0;a=c[1213]|0;b=1<<d;if(!(a&b)){c[1213]=a|b;c[e>>2]=k;c[k+24>>2]=e;c[k+12>>2]=k;c[k+8>>2]=k;break}d=g<<((d|0)==31?0:25-(d>>>1)|0);e=c[e>>2]|0;while(1){if((c[e+4>>2]&-8|0)==(g|0)){z=307;break}b=e+16+(d>>>31<<2)|0;a=c[b>>2]|0;if(!a){z=304;break}else{d=d<<1;e=a}}if((z|0)==304)if(b>>>0<(c[1216]|0)>>>0)ga();else{c[b>>2]=k;c[k+24>>2]=e;c[k+12>>2]=k;c[k+8>>2]=k;break}else if((z|0)==307){a=e+8|0;b=c[a>>2]|0;G=c[1216]|0;if(b>>>0>=G>>>0&e>>>0>=G>>>0){c[b+12>>2]=k;c[a>>2]=k;c[k+8>>2]=b;c[k+12>>2]=e;c[k+24>>2]=0;break}else ga()}}}else{G=c[1216]|0;if((G|0)==0|h>>>0<G>>>0)c[1216]=h;c[1324]=h;c[1325]=g;c[1327]=0;c[1221]=c[1330];c[1220]=-1;a=0;do{G=4888+(a<<1<<2)|0;c[G+12>>2]=G;c[G+8>>2]=G;a=a+1|0}while((a|0)!=32);G=h+8|0;G=(G&7|0)==0?0:0-G&7;F=h+G|0;G=g+-40-G|0;c[1218]=F;c[1215]=G;c[F+4>>2]=G|1;c[F+G+4>>2]=40;c[1219]=c[1334]}while(0);a=c[1215]|0;if(a>>>0>o>>>0){E=a-o|0;c[1215]=E;G=c[1218]|0;F=G+o|0;c[1218]=F;c[F+4>>2]=E|1;c[G+4>>2]=o|3;G=G+8|0;return G|0}}c[(ec()|0)>>2]=12;G=0;return G|0}function wc(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if(!a)return;d=a+-8|0;h=c[1216]|0;if(d>>>0<h>>>0)ga();a=c[a+-4>>2]|0;b=a&3;if((b|0)==1)ga();e=a&-8;m=d+e|0;do if(!(a&1)){a=c[d>>2]|0;if(!b)return;k=d+(0-a)|0;j=a+e|0;if(k>>>0<h>>>0)ga();if((k|0)==(c[1217]|0)){a=m+4|0;b=c[a>>2]|0;if((b&3|0)!=3){q=k;f=j;break}c[1214]=j;c[a>>2]=b&-2;c[k+4>>2]=j|1;c[k+j>>2]=j;return}e=a>>>3;if(a>>>0<256){b=c[k+8>>2]|0;d=c[k+12>>2]|0;a=4888+(e<<1<<2)|0;if((b|0)!=(a|0)){if(b>>>0<h>>>0)ga();if((c[b+12>>2]|0)!=(k|0))ga()}if((d|0)==(b|0)){c[1212]=c[1212]&~(1<<e);q=k;f=j;break}if((d|0)!=(a|0)){if(d>>>0<h>>>0)ga();a=d+8|0;if((c[a>>2]|0)==(k|0))g=a;else ga()}else g=d+8|0;c[b+12>>2]=d;c[g>>2]=b;q=k;f=j;break}g=c[k+24>>2]|0;d=c[k+12>>2]|0;do if((d|0)==(k|0)){d=k+16|0;b=d+4|0;a=c[b>>2]|0;if(!a){a=c[d>>2]|0;if(!a){i=0;break}else b=d}while(1){d=a+20|0;e=c[d>>2]|0;if(e){a=e;b=d;continue}d=a+16|0;e=c[d>>2]|0;if(!e)break;else{a=e;b=d}}if(b>>>0<h>>>0)ga();else{c[b>>2]=0;i=a;break}}else{e=c[k+8>>2]|0;if(e>>>0<h>>>0)ga();a=e+12|0;if((c[a>>2]|0)!=(k|0))ga();b=d+8|0;if((c[b>>2]|0)==(k|0)){c[a>>2]=d;c[b>>2]=e;i=d;break}else ga()}while(0);if(g){a=c[k+28>>2]|0;b=5152+(a<<2)|0;if((k|0)==(c[b>>2]|0)){c[b>>2]=i;if(!i){c[1213]=c[1213]&~(1<<a);q=k;f=j;break}}else{if(g>>>0<(c[1216]|0)>>>0)ga();a=g+16|0;if((c[a>>2]|0)==(k|0))c[a>>2]=i;else c[g+20>>2]=i;if(!i){q=k;f=j;break}}d=c[1216]|0;if(i>>>0<d>>>0)ga();c[i+24>>2]=g;a=k+16|0;b=c[a>>2]|0;do if(b)if(b>>>0<d>>>0)ga();else{c[i+16>>2]=b;c[b+24>>2]=i;break}while(0);a=c[a+4>>2]|0;if(a)if(a>>>0<(c[1216]|0)>>>0)ga();else{c[i+20>>2]=a;c[a+24>>2]=i;q=k;f=j;break}else{q=k;f=j}}else{q=k;f=j}}else{q=d;f=e}while(0);if(q>>>0>=m>>>0)ga();a=m+4|0;b=c[a>>2]|0;if(!(b&1))ga();if(!(b&2)){if((m|0)==(c[1218]|0)){p=(c[1215]|0)+f|0;c[1215]=p;c[1218]=q;c[q+4>>2]=p|1;if((q|0)!=(c[1217]|0))return;c[1217]=0;c[1214]=0;return}if((m|0)==(c[1217]|0)){p=(c[1214]|0)+f|0;c[1214]=p;c[1217]=q;c[q+4>>2]=p|1;c[q+p>>2]=p;return}f=(b&-8)+f|0;e=b>>>3;do if(b>>>0>=256){g=c[m+24>>2]|0;a=c[m+12>>2]|0;do if((a|0)==(m|0)){d=m+16|0;b=d+4|0;a=c[b>>2]|0;if(!a){a=c[d>>2]|0;if(!a){n=0;break}else b=d}while(1){d=a+20|0;e=c[d>>2]|0;if(e){a=e;b=d;continue}d=a+16|0;e=c[d>>2]|0;if(!e)break;else{a=e;b=d}}if(b>>>0<(c[1216]|0)>>>0)ga();else{c[b>>2]=0;n=a;break}}else{b=c[m+8>>2]|0;if(b>>>0<(c[1216]|0)>>>0)ga();d=b+12|0;if((c[d>>2]|0)!=(m|0))ga();e=a+8|0;if((c[e>>2]|0)==(m|0)){c[d>>2]=a;c[e>>2]=b;n=a;break}else ga()}while(0);if(g){a=c[m+28>>2]|0;b=5152+(a<<2)|0;if((m|0)==(c[b>>2]|0)){c[b>>2]=n;if(!n){c[1213]=c[1213]&~(1<<a);break}}else{if(g>>>0<(c[1216]|0)>>>0)ga();a=g+16|0;if((c[a>>2]|0)==(m|0))c[a>>2]=n;else c[g+20>>2]=n;if(!n)break}d=c[1216]|0;if(n>>>0<d>>>0)ga();c[n+24>>2]=g;a=m+16|0;b=c[a>>2]|0;do if(b)if(b>>>0<d>>>0)ga();else{c[n+16>>2]=b;c[b+24>>2]=n;break}while(0);a=c[a+4>>2]|0;if(a)if(a>>>0<(c[1216]|0)>>>0)ga();else{c[n+20>>2]=a;c[a+24>>2]=n;break}}}else{b=c[m+8>>2]|0;d=c[m+12>>2]|0;a=4888+(e<<1<<2)|0;if((b|0)!=(a|0)){if(b>>>0<(c[1216]|0)>>>0)ga();if((c[b+12>>2]|0)!=(m|0))ga()}if((d|0)==(b|0)){c[1212]=c[1212]&~(1<<e);break}if((d|0)!=(a|0)){if(d>>>0<(c[1216]|0)>>>0)ga();a=d+8|0;if((c[a>>2]|0)==(m|0))l=a;else ga()}else l=d+8|0;c[b+12>>2]=d;c[l>>2]=b}while(0);c[q+4>>2]=f|1;c[q+f>>2]=f;if((q|0)==(c[1217]|0)){c[1214]=f;return}}else{c[a>>2]=b&-2;c[q+4>>2]=f|1;c[q+f>>2]=f}a=f>>>3;if(f>>>0<256){d=4888+(a<<1<<2)|0;b=c[1212]|0;a=1<<a;if(b&a){a=d+8|0;b=c[a>>2]|0;if(b>>>0<(c[1216]|0)>>>0)ga();else{o=a;p=b}}else{c[1212]=b|a;o=d+8|0;p=d}c[o>>2]=q;c[p+12>>2]=q;c[q+8>>2]=p;c[q+12>>2]=d;return}a=f>>>8;if(a)if(f>>>0>16777215)d=31;else{o=(a+1048320|0)>>>16&8;p=a<<o;n=(p+520192|0)>>>16&4;p=p<<n;d=(p+245760|0)>>>16&2;d=14-(n|o|d)+(p<<d>>>15)|0;d=f>>>(d+7|0)&1|d<<1}else d=0;e=5152+(d<<2)|0;c[q+28>>2]=d;c[q+20>>2]=0;c[q+16>>2]=0;a=c[1213]|0;b=1<<d;do if(a&b){d=f<<((d|0)==31?0:25-(d>>>1)|0);e=c[e>>2]|0;while(1){if((c[e+4>>2]&-8|0)==(f|0)){a=130;break}b=e+16+(d>>>31<<2)|0;a=c[b>>2]|0;if(!a){a=127;break}else{d=d<<1;e=a}}if((a|0)==127)if(b>>>0<(c[1216]|0)>>>0)ga();else{c[b>>2]=q;c[q+24>>2]=e;c[q+12>>2]=q;c[q+8>>2]=q;break}else if((a|0)==130){a=e+8|0;b=c[a>>2]|0;p=c[1216]|0;if(b>>>0>=p>>>0&e>>>0>=p>>>0){c[b+12>>2]=q;c[a>>2]=q;c[q+8>>2]=b;c[q+12>>2]=e;c[q+24>>2]=0;break}else ga()}}else{c[1213]=a|b;c[e>>2]=q;c[q+24>>2]=e;c[q+12>>2]=q;c[q+8>>2]=q}while(0);q=(c[1220]|0)+-1|0;c[1220]=q;if(!q)a=5304;else return;while(1){a=c[a>>2]|0;if(!a)break;else a=a+8|0}c[1220]=-1;return}function xc(a,b){a=a|0;b=b|0;var d=0,e=0;if(!a){a=vc(b)|0;return a|0}if(b>>>0>4294967231){c[(ec()|0)>>2]=12;a=0;return a|0}d=yc(a+-8|0,b>>>0<11?16:b+11&-8)|0;if(d){a=d+8|0;return a|0}d=vc(b)|0;if(!d){a=0;return a|0}e=c[a+-4>>2]|0;e=(e&-8)-((e&3|0)==0?8:4)|0;Fc(d|0,a|0,(e>>>0<b>>>0?e:b)|0)|0;wc(a);a=d;return a|0}function yc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;n=a+4|0;o=c[n>>2]|0;d=o&-8;k=a+d|0;i=c[1216]|0;e=o&3;if(!((e|0)!=1&a>>>0>=i>>>0&a>>>0<k>>>0))ga();f=c[k+4>>2]|0;if(!(f&1))ga();if(!e){if(b>>>0<256){a=0;return a|0}if(d>>>0>=(b+4|0)>>>0?(d-b|0)>>>0<=c[1332]<<1>>>0:0)return a|0;a=0;return a|0}if(d>>>0>=b>>>0){d=d-b|0;if(d>>>0<=15)return a|0;m=a+b|0;c[n>>2]=o&1|b|2;c[m+4>>2]=d|3;b=m+d+4|0;c[b>>2]=c[b>>2]|1;zc(m,d);return a|0}if((k|0)==(c[1218]|0)){d=(c[1215]|0)+d|0;if(d>>>0<=b>>>0){a=0;return a|0}m=d-b|0;l=a+b|0;c[n>>2]=o&1|b|2;c[l+4>>2]=m|1;c[1218]=l;c[1215]=m;return a|0}if((k|0)==(c[1217]|0)){e=(c[1214]|0)+d|0;if(e>>>0<b>>>0){a=0;return a|0}d=e-b|0;if(d>>>0>15){e=a+b|0;m=e+d|0;c[n>>2]=o&1|b|2;c[e+4>>2]=d|1;c[m>>2]=d;b=m+4|0;c[b>>2]=c[b>>2]&-2}else{c[n>>2]=o&1|e|2;e=a+e+4|0;c[e>>2]=c[e>>2]|1;e=0;d=0}c[1214]=d;c[1217]=e;return a|0}if(f&2){a=0;return a|0}l=(f&-8)+d|0;if(l>>>0<b>>>0){a=0;return a|0}m=l-b|0;g=f>>>3;do if(f>>>0>=256){h=c[k+24>>2]|0;f=c[k+12>>2]|0;do if((f|0)==(k|0)){f=k+16|0;e=f+4|0;d=c[e>>2]|0;if(!d){d=c[f>>2]|0;if(!d){j=0;break}else e=f}while(1){f=d+20|0;g=c[f>>2]|0;if(g){d=g;e=f;continue}f=d+16|0;g=c[f>>2]|0;if(!g)break;else{d=g;e=f}}if(e>>>0<i>>>0)ga();else{c[e>>2]=0;j=d;break}}else{g=c[k+8>>2]|0;if(g>>>0<i>>>0)ga();d=g+12|0;if((c[d>>2]|0)!=(k|0))ga();e=f+8|0;if((c[e>>2]|0)==(k|0)){c[d>>2]=f;c[e>>2]=g;j=f;break}else ga()}while(0);if(h){d=c[k+28>>2]|0;e=5152+(d<<2)|0;if((k|0)==(c[e>>2]|0)){c[e>>2]=j;if(!j){c[1213]=c[1213]&~(1<<d);break}}else{if(h>>>0<(c[1216]|0)>>>0)ga();d=h+16|0;if((c[d>>2]|0)==(k|0))c[d>>2]=j;else c[h+20>>2]=j;if(!j)break}f=c[1216]|0;if(j>>>0<f>>>0)ga();c[j+24>>2]=h;d=k+16|0;e=c[d>>2]|0;do if(e)if(e>>>0<f>>>0)ga();else{c[j+16>>2]=e;c[e+24>>2]=j;break}while(0);d=c[d+4>>2]|0;if(d)if(d>>>0<(c[1216]|0)>>>0)ga();else{c[j+20>>2]=d;c[d+24>>2]=j;break}}}else{e=c[k+8>>2]|0;f=c[k+12>>2]|0;d=4888+(g<<1<<2)|0;if((e|0)!=(d|0)){if(e>>>0<i>>>0)ga();if((c[e+12>>2]|0)!=(k|0))ga()}if((f|0)==(e|0)){c[1212]=c[1212]&~(1<<g);break}if((f|0)!=(d|0)){if(f>>>0<i>>>0)ga();d=f+8|0;if((c[d>>2]|0)==(k|0))h=d;else ga()}else h=f+8|0;c[e+12>>2]=f;c[h>>2]=e}while(0);if(m>>>0<16){c[n>>2]=l|o&1|2;b=a+l+4|0;c[b>>2]=c[b>>2]|1;return a|0}else{l=a+b|0;c[n>>2]=o&1|b|2;c[l+4>>2]=m|3;b=l+m+4|0;c[b>>2]=c[b>>2]|1;zc(l,m);return a|0}return 0}function zc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;o=a+b|0;d=c[a+4>>2]|0;do if(!(d&1)){g=c[a>>2]|0;if(!(d&3))return;l=a+(0-g)|0;k=g+b|0;i=c[1216]|0;if(l>>>0<i>>>0)ga();if((l|0)==(c[1217]|0)){a=o+4|0;d=c[a>>2]|0;if((d&3|0)!=3){r=l;f=k;break}c[1214]=k;c[a>>2]=d&-2;c[l+4>>2]=k|1;c[l+k>>2]=k;return}e=g>>>3;if(g>>>0<256){a=c[l+8>>2]|0;b=c[l+12>>2]|0;d=4888+(e<<1<<2)|0;if((a|0)!=(d|0)){if(a>>>0<i>>>0)ga();if((c[a+12>>2]|0)!=(l|0))ga()}if((b|0)==(a|0)){c[1212]=c[1212]&~(1<<e);r=l;f=k;break}if((b|0)!=(d|0)){if(b>>>0<i>>>0)ga();d=b+8|0;if((c[d>>2]|0)==(l|0))h=d;else ga()}else h=b+8|0;c[a+12>>2]=b;c[h>>2]=a;r=l;f=k;break}g=c[l+24>>2]|0;b=c[l+12>>2]|0;do if((b|0)==(l|0)){b=l+16|0;a=b+4|0;d=c[a>>2]|0;if(!d){d=c[b>>2]|0;if(!d){j=0;break}else a=b}while(1){b=d+20|0;e=c[b>>2]|0;if(e){d=e;a=b;continue}b=d+16|0;e=c[b>>2]|0;if(!e)break;else{d=e;a=b}}if(a>>>0<i>>>0)ga();else{c[a>>2]=0;j=d;break}}else{e=c[l+8>>2]|0;if(e>>>0<i>>>0)ga();d=e+12|0;if((c[d>>2]|0)!=(l|0))ga();a=b+8|0;if((c[a>>2]|0)==(l|0)){c[d>>2]=b;c[a>>2]=e;j=b;break}else ga()}while(0);if(g){d=c[l+28>>2]|0;a=5152+(d<<2)|0;if((l|0)==(c[a>>2]|0)){c[a>>2]=j;if(!j){c[1213]=c[1213]&~(1<<d);r=l;f=k;break}}else{if(g>>>0<(c[1216]|0)>>>0)ga();d=g+16|0;if((c[d>>2]|0)==(l|0))c[d>>2]=j;else c[g+20>>2]=j;if(!j){r=l;f=k;break}}b=c[1216]|0;if(j>>>0<b>>>0)ga();c[j+24>>2]=g;d=l+16|0;a=c[d>>2]|0;do if(a)if(a>>>0<b>>>0)ga();else{c[j+16>>2]=a;c[a+24>>2]=j;break}while(0);d=c[d+4>>2]|0;if(d)if(d>>>0<(c[1216]|0)>>>0)ga();else{c[j+20>>2]=d;c[d+24>>2]=j;r=l;f=k;break}else{r=l;f=k}}else{r=l;f=k}}else{r=a;f=b}while(0);h=c[1216]|0;if(o>>>0<h>>>0)ga();d=o+4|0;a=c[d>>2]|0;if(!(a&2)){if((o|0)==(c[1218]|0)){q=(c[1215]|0)+f|0;c[1215]=q;c[1218]=r;c[r+4>>2]=q|1;if((r|0)!=(c[1217]|0))return;c[1217]=0;c[1214]=0;return}if((o|0)==(c[1217]|0)){q=(c[1214]|0)+f|0;c[1214]=q;c[1217]=r;c[r+4>>2]=q|1;c[r+q>>2]=q;return}f=(a&-8)+f|0;e=a>>>3;do if(a>>>0>=256){g=c[o+24>>2]|0;b=c[o+12>>2]|0;do if((b|0)==(o|0)){b=o+16|0;a=b+4|0;d=c[a>>2]|0;if(!d){d=c[b>>2]|0;if(!d){n=0;break}else a=b}while(1){b=d+20|0;e=c[b>>2]|0;if(e){d=e;a=b;continue}b=d+16|0;e=c[b>>2]|0;if(!e)break;else{d=e;a=b}}if(a>>>0<h>>>0)ga();else{c[a>>2]=0;n=d;break}}else{e=c[o+8>>2]|0;if(e>>>0<h>>>0)ga();d=e+12|0;if((c[d>>2]|0)!=(o|0))ga();a=b+8|0;if((c[a>>2]|0)==(o|0)){c[d>>2]=b;c[a>>2]=e;n=b;break}else ga()}while(0);if(g){d=c[o+28>>2]|0;a=5152+(d<<2)|0;if((o|0)==(c[a>>2]|0)){c[a>>2]=n;if(!n){c[1213]=c[1213]&~(1<<d);break}}else{if(g>>>0<(c[1216]|0)>>>0)ga();d=g+16|0;if((c[d>>2]|0)==(o|0))c[d>>2]=n;else c[g+20>>2]=n;if(!n)break}b=c[1216]|0;if(n>>>0<b>>>0)ga();c[n+24>>2]=g;d=o+16|0;a=c[d>>2]|0;do if(a)if(a>>>0<b>>>0)ga();else{c[n+16>>2]=a;c[a+24>>2]=n;break}while(0);d=c[d+4>>2]|0;if(d)if(d>>>0<(c[1216]|0)>>>0)ga();else{c[n+20>>2]=d;c[d+24>>2]=n;break}}}else{a=c[o+8>>2]|0;b=c[o+12>>2]|0;d=4888+(e<<1<<2)|0;if((a|0)!=(d|0)){if(a>>>0<h>>>0)ga();if((c[a+12>>2]|0)!=(o|0))ga()}if((b|0)==(a|0)){c[1212]=c[1212]&~(1<<e);break}if((b|0)!=(d|0)){if(b>>>0<h>>>0)ga();d=b+8|0;if((c[d>>2]|0)==(o|0))m=d;else ga()}else m=b+8|0;c[a+12>>2]=b;c[m>>2]=a}while(0);c[r+4>>2]=f|1;c[r+f>>2]=f;if((r|0)==(c[1217]|0)){c[1214]=f;return}}else{c[d>>2]=a&-2;c[r+4>>2]=f|1;c[r+f>>2]=f}d=f>>>3;if(f>>>0<256){b=4888+(d<<1<<2)|0;a=c[1212]|0;d=1<<d;if(a&d){d=b+8|0;a=c[d>>2]|0;if(a>>>0<(c[1216]|0)>>>0)ga();else{p=d;q=a}}else{c[1212]=a|d;p=b+8|0;q=b}c[p>>2]=r;c[q+12>>2]=r;c[r+8>>2]=q;c[r+12>>2]=b;return}d=f>>>8;if(d)if(f>>>0>16777215)b=31;else{p=(d+1048320|0)>>>16&8;q=d<<p;o=(q+520192|0)>>>16&4;q=q<<o;b=(q+245760|0)>>>16&2;b=14-(o|p|b)+(q<<b>>>15)|0;b=f>>>(b+7|0)&1|b<<1}else b=0;e=5152+(b<<2)|0;c[r+28>>2]=b;c[r+20>>2]=0;c[r+16>>2]=0;d=c[1213]|0;a=1<<b;if(!(d&a)){c[1213]=d|a;c[e>>2]=r;c[r+24>>2]=e;c[r+12>>2]=r;c[r+8>>2]=r;return}b=f<<((b|0)==31?0:25-(b>>>1)|0);e=c[e>>2]|0;while(1){if((c[e+4>>2]&-8|0)==(f|0)){d=127;break}a=e+16+(b>>>31<<2)|0;d=c[a>>2]|0;if(!d){d=124;break}else{b=b<<1;e=d}}if((d|0)==124){if(a>>>0<(c[1216]|0)>>>0)ga();c[a>>2]=r;c[r+24>>2]=e;c[r+12>>2]=r;c[r+8>>2]=r;return}else if((d|0)==127){d=e+8|0;a=c[d>>2]|0;q=c[1216]|0;if(!(a>>>0>=q>>>0&e>>>0>=q>>>0))ga();c[a+12>>2]=r;c[d>>2]=r;c[r+8>>2]=a;c[r+12>>2]=e;c[r+24>>2]=0;return}}function Ac(){}function Bc(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=b+e|0;if((e|0)>=20){d=d&255;h=b&3;i=d|d<<8|d<<16|d<<24;g=f&~3;if(h){h=b+4-h|0;while((b|0)<(h|0)){a[b>>0]=d;b=b+1|0}}while((b|0)<(g|0)){c[b>>2]=i;b=b+4|0}}while((b|0)<(f|0)){a[b>>0]=d;b=b+1|0}return b-e|0}function Cc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;d=b-d-(c>>>0>a>>>0|0)>>>0;return (C=d,a-c>>>0|0)|0}function Dc(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){C=b>>>c;return a>>>c|(b&(1<<c)-1)<<32-c}C=0;return b>>>c-32|0}function Ec(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){C=b<<c|(a&(1<<c)-1<<32-c)>>>32-c;return a<<c}C=a<<c-32;return 0}function Fc(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;if((e|0)>=4096)return ka(b|0,d|0,e|0)|0;f=b|0;if((b&3)==(d&3)){while(b&3){if(!e)return f|0;a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}while((e|0)>=4){c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0;e=e-4|0}}while((e|0)>0){a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}return f|0}function Gc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;c=a+c>>>0;return (C=b+d+(c>>>0<a>>>0|0)>>>0,c|0)|0}function Hc(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if((c|0)<(b|0)&(b|0)<(c+d|0)){e=b;c=c+d|0;b=b+d|0;while((d|0)>0){b=b-1|0;c=c-1|0;d=d-1|0;a[b>>0]=a[c>>0]|0}b=e}else Fc(b,c,d)|0;return b|0}function Ic(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){C=b>>c;return a>>>c|(b&(1<<c)-1)<<32-c}C=(b|0)<0?-1:0;return b>>c-32|0}function Jc(b){b=b|0;var c=0;c=a[m+(b&255)>>0]|0;if((c|0)<8)return c|0;c=a[m+(b>>8&255)>>0]|0;if((c|0)<8)return c+8|0;c=a[m+(b>>16&255)>>0]|0;if((c|0)<8)return c+16|0;return (a[m+(b>>>24)>>0]|0)+24|0}function Kc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0;f=a&65535;e=b&65535;c=_(e,f)|0;d=a>>>16;a=(c>>>16)+(_(e,d)|0)|0;e=b>>>16;b=_(e,f)|0;return (C=(a>>>16)+(_(e,d)|0)+(((a&65535)+b|0)>>>16)|0,a+b<<16|c&65535|0)|0}function Lc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;j=b>>31|((b|0)<0?-1:0)<<1;i=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;f=d>>31|((d|0)<0?-1:0)<<1;e=((d|0)<0?-1:0)>>31|((d|0)<0?-1:0)<<1;h=Cc(j^a,i^b,j,i)|0;g=C;a=f^j;b=e^i;return Cc((Qc(h,g,Cc(f^c,e^d,f,e)|0,C,0)|0)^a,C^b,a,b)|0}function Mc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;j=f|0;h=b>>31|((b|0)<0?-1:0)<<1;g=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;l=e>>31|((e|0)<0?-1:0)<<1;k=((e|0)<0?-1:0)>>31|((e|0)<0?-1:0)<<1;a=Cc(h^a,g^b,h,g)|0;b=C;Qc(a,b,Cc(l^d,k^e,l,k)|0,C,j)|0;e=Cc(c[j>>2]^h,c[j+4>>2]^g,h,g)|0;d=C;i=f;return (C=d,e)|0}function Nc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=a;f=c;c=Kc(e,f)|0;a=C;return (C=(_(b,f)|0)+(_(d,e)|0)+a|a&0,c|0|0)|0}function Oc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Qc(a,b,c,d,0)|0}function Pc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;i=i+16|0;f=g|0;Qc(a,b,d,e,f)|0;i=g;return (C=c[f+4>>2]|0,c[f>>2]|0)|0}function Qc(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=a;j=b;k=j;h=d;n=e;i=n;if(!k){g=(f|0)!=0;if(!i){if(g){c[f>>2]=(l>>>0)%(h>>>0);c[f+4>>2]=0}n=0;f=(l>>>0)/(h>>>0)>>>0;return (C=n,f)|0}else{if(!g){n=0;f=0;return (C=n,f)|0}c[f>>2]=a|0;c[f+4>>2]=b&0;n=0;f=0;return (C=n,f)|0}}g=(i|0)==0;do if(h){if(!g){g=(aa(i|0)|0)-(aa(k|0)|0)|0;if(g>>>0<=31){m=g+1|0;i=31-g|0;b=g-31>>31;h=m;a=l>>>(m>>>0)&b|k<<i;b=k>>>(m>>>0)&b;g=0;i=l<<i;break}if(!f){n=0;f=0;return (C=n,f)|0}c[f>>2]=a|0;c[f+4>>2]=j|b&0;n=0;f=0;return (C=n,f)|0}g=h-1|0;if(g&h){i=(aa(h|0)|0)+33-(aa(k|0)|0)|0;p=64-i|0;m=32-i|0;j=m>>31;o=i-32|0;b=o>>31;h=i;a=m-1>>31&k>>>(o>>>0)|(k<<m|l>>>(i>>>0))&b;b=b&k>>>(i>>>0);g=l<<p&j;i=(k<<p|l>>>(o>>>0))&j|l<<m&i-33>>31;break}if(f){c[f>>2]=g&l;c[f+4>>2]=0}if((h|0)==1){o=j|b&0;p=a|0|0;return (C=o,p)|0}else{p=Jc(h|0)|0;o=k>>>(p>>>0)|0;p=k<<32-p|l>>>(p>>>0)|0;return (C=o,p)|0}}else{if(g){if(f){c[f>>2]=(k>>>0)%(h>>>0);c[f+4>>2]=0}o=0;p=(k>>>0)/(h>>>0)>>>0;return (C=o,p)|0}if(!l){if(f){c[f>>2]=0;c[f+4>>2]=(k>>>0)%(i>>>0)}o=0;p=(k>>>0)/(i>>>0)>>>0;return (C=o,p)|0}g=i-1|0;if(!(g&i)){if(f){c[f>>2]=a|0;c[f+4>>2]=g&k|b&0}o=0;p=k>>>((Jc(i|0)|0)>>>0);return (C=o,p)|0}g=(aa(i|0)|0)-(aa(k|0)|0)|0;if(g>>>0<=30){b=g+1|0;i=31-g|0;h=b;a=k<<i|l>>>(b>>>0);b=k>>>(b>>>0);g=0;i=l<<i;break}if(!f){o=0;p=0;return (C=o,p)|0}c[f>>2]=a|0;c[f+4>>2]=j|b&0;o=0;p=0;return (C=o,p)|0}while(0);if(!h){k=i;j=0;i=0}else{m=d|0|0;l=n|e&0;k=Gc(m|0,l|0,-1,-1)|0;d=C;j=i;i=0;do{e=j;j=g>>>31|j<<1;g=i|g<<1;e=a<<1|e>>>31|0;n=a>>>31|b<<1|0;Cc(k,d,e,n)|0;p=C;o=p>>31|((p|0)<0?-1:0)<<1;i=o&1;a=Cc(e,n,o&m,(((p|0)<0?-1:0)>>31|((p|0)<0?-1:0)<<1)&l)|0;b=C;h=h-1|0}while((h|0)!=0);k=j;j=0}h=0;if(f){c[f>>2]=a;c[f+4>>2]=b}o=(g|0)>>>31|(k|h)<<1|(h<<1|g>>>31)&0|j;p=(g<<1|0>>>31)&-2|i;return (C=o,p)|0}function Rc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return ra[a&1](b|0,c|0,d|0)|0}function Sc(a,b,c){a=a|0;b=b|0;c=c|0;ba(0);return 0}

// EMSCRIPTEN_END_FUNCS
var ra=[Sc,qc];return{_malloc:vc,_i64Subtract:Cc,_free:wc,_i64Add:Gc,_memmove:Hc,_memset:Bc,___cxa_demangle:Ba,_memcpy:Fc,_bitshift64Lshr:Dc,_bitshift64Shl:Ec,runPostSets:Ac,stackAlloc:sa,stackSave:ta,stackRestore:ua,establishStackSpace:va,setThrew:wa,setTempRet0:za,getTempRet0:Aa,dynCall_iiii:Rc}})


// EMSCRIPTEN_END_ASM
(Module.asmGlobalArg,Module.asmLibraryArg,buffer);var ___cxa_demangle=Module["___cxa_demangle"]=asm["___cxa_demangle"];var _i64Subtract=Module["_i64Subtract"]=asm["_i64Subtract"];var _free=Module["_free"]=asm["_free"];var runPostSets=Module["runPostSets"]=asm["runPostSets"];var _i64Add=Module["_i64Add"]=asm["_i64Add"];var _memmove=Module["_memmove"]=asm["_memmove"];var _memset=Module["_memset"]=asm["_memset"];var _malloc=Module["_malloc"]=asm["_malloc"];var _memcpy=Module["_memcpy"]=asm["_memcpy"];var _bitshift64Lshr=Module["_bitshift64Lshr"]=asm["_bitshift64Lshr"];var _bitshift64Shl=Module["_bitshift64Shl"]=asm["_bitshift64Shl"];var dynCall_iiii=Module["dynCall_iiii"]=asm["dynCall_iiii"];Runtime.stackAlloc=asm["stackAlloc"];Runtime.stackSave=asm["stackSave"];Runtime.stackRestore=asm["stackRestore"];Runtime.establishStackSpace=asm["establishStackSpace"];Runtime.setTempRet0=asm["setTempRet0"];Runtime.getTempRet0=asm["getTempRet0"];function ExitStatus(status){this.name="ExitStatus";this.message="Program terminated with exit("+status+")";this.status=status}ExitStatus.prototype=new Error;ExitStatus.prototype.constructor=ExitStatus;var initialStackTop;var preloadStartTime=null;var calledMain=false;dependenciesFulfilled=function runCaller(){if(!Module["calledRun"])run();if(!Module["calledRun"])dependenciesFulfilled=runCaller};Module["callMain"]=Module.callMain=function callMain(args){assert(runDependencies==0,"cannot call main when async dependencies remain! (listen on __ATMAIN__)");assert(__ATPRERUN__.length==0,"cannot call main when preRun functions remain to be called");args=args||[];ensureInitRuntime();var argc=args.length+1;function pad(){for(var i=0;i<4-1;i++){argv.push(0)}}var argv=[allocate(intArrayFromString(Module["thisProgram"]),"i8",ALLOC_NORMAL)];pad();for(var i=0;i<argc-1;i=i+1){argv.push(allocate(intArrayFromString(args[i]),"i8",ALLOC_NORMAL));pad()}argv.push(0);argv=allocate(argv,"i32",ALLOC_NORMAL);try{var ret=Module["_main"](argc,argv,0);exit(ret,true)}catch(e){if(e instanceof ExitStatus){return}else if(e=="SimulateInfiniteLoop"){Module["noExitRuntime"]=true;return}else{if(e&&typeof e==="object"&&e.stack)Module.printErr("exception thrown: "+[e,e.stack]);throw e}}finally{calledMain=true}};function run(args){args=args||Module["arguments"];if(preloadStartTime===null)preloadStartTime=Date.now();if(runDependencies>0){return}preRun();if(runDependencies>0)return;if(Module["calledRun"])return;function doRun(){if(Module["calledRun"])return;Module["calledRun"]=true;if(ABORT)return;ensureInitRuntime();preMain();if(Module["onRuntimeInitialized"])Module["onRuntimeInitialized"]();if(Module["_main"]&&shouldRunNow)Module["callMain"](args);postRun()}if(Module["setStatus"]){Module["setStatus"]("Running...");setTimeout((function(){setTimeout((function(){Module["setStatus"]("")}),1);doRun()}),1)}else{doRun()}}Module["run"]=Module.run=run;function exit(status,implicit){if(implicit&&Module["noExitRuntime"]){return}if(Module["noExitRuntime"]){}else{ABORT=true;EXITSTATUS=status;STACKTOP=initialStackTop;exitRuntime();if(Module["onExit"])Module["onExit"](status)}if(ENVIRONMENT_IS_NODE){process["stdout"]["once"]("drain",(function(){process["exit"](status)}));console.log(" ");setTimeout((function(){process["exit"](status)}),500)}else if(ENVIRONMENT_IS_SHELL&&typeof quit==="function"){quit(status)}throw new ExitStatus(status)}Module["exit"]=Module.exit=exit;var abortDecorators=[];function abort(what){if(what!==undefined){Module.print(what);Module.printErr(what);what=JSON.stringify(what)}else{what=""}ABORT=true;EXITSTATUS=1;var extra="\nIf this abort() is unexpected, build with -s ASSERTIONS=1 which can give more information.";var output="abort("+what+") at "+stackTrace()+extra;if(abortDecorators){abortDecorators.forEach((function(decorator){output=decorator(output,what)}))}throw output}Module["abort"]=Module.abort=abort;if(Module["preInit"]){if(typeof Module["preInit"]=="function")Module["preInit"]=[Module["preInit"]];while(Module["preInit"].length>0){Module["preInit"].pop()()}}var shouldRunNow=true;if(Module["noInitialRun"]){shouldRunNow=false}run()





  return Module;
};

  var m = Module();
  var status = m._malloc(4);
  var buf = m._malloc(2048);

  return function(func) {
    if (func.length >= 2048) return null;
    m.writeStringToMemory(func.substr(1), buf);
    var ret = m['___cxa_demangle'](buf, 0, 0, status);
    var result = null;
    if (m.HEAP32[status >> 2] === 0 && ret) {
      result = m.Pointer_stringify(ret);
      m._free(ret);
    }
    return result;
  };
})();

// The emscripten compiler exports the Module object; we just want
// the demangle function
if (typeof module === "object" && typeof module.exports === "object") {
  module.exports = demangle;
}
