/*
 * Copyright 2016 Megh Parikh
 *
 * This file is part of LibGamepad.
 *
 * LibGamepad is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LibGamepad is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 */

// This file is part of GNOME Games. License: GPLv3

public enum LibGamepad.StandardGamepadButton {
	/**
	 * The button at the bottom of the action pad.
	 */
	A,

	/**
	 * The button at the right of the action pad.
	 */
	B,

	/**
	 * The button at the left of the action pad.
	 */
	X,

	/**
	 * The button at the top of the action pad.
	 */
	Y,

	/**
	 * The button at the left of the top of the gamepad.
	 */
	SHOULDER_L,

	/**
	 * The button at the right of the top of the gamepad.
	 */
	SHOULDER_R,

	/**
	 * The trigger at the left of the top of the gamepad.
	 */
	TRIGGER_L,

	/**
	 * The trigger at the right of the top of the gamepad.
	 */
	TRIGGER_R,

	/**
	 * The button at the left of the menu pad.
	 */
	SELECT,

	/**
	 * The button at the right of the menu pad.
	 */
	START,

	/**
	 * The button under the left stick.
	 */
	STICK_L,

	/**
	 * The button under the right stick.
	 */
	STICK_R,

	/**
	 * The button at the top of the directional pad.
	 */
	DPAD_UP,

	/**
	 * The button at the bottom of the directional pad.
	 */
	DPAD_DOWN,

	/**
	 * The button at the left of the directional pad.
	 */
	DPAD_LEFT,

	/**
	 * The button at the right of the directional pad.
	 */
	DPAD_RIGHT,

	/**
	 * The button at the center of the menu pad.
	 */
	HOME,

	/**
	 * An unknown button
	 */
	UNKNOWN,
}
