/*__________________________________________________________________________

	strlen           strlen c-string function
						
    Copyright (C) 2003 jan schacher

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
    
    initial build 20030507
    
____________________________________________________________________________*/

#include "m_pd.h"
#include <string.h>

typedef struct strlen 		
{
	t_object		ob;		
	void 			*s_outlet;
	float			s_length;	
} t_strlen;

void *strlen_class;
void *strlen_new(t_symbol *s, long n);
void strlen_anything(t_strlen *x, t_symbol *s, long argc, t_atom *argv);
void strlen_free(t_strlen *x);

void strlen_setup(void)
{	
	strlen_class = class_new(gensym("strlen"), (t_newmethod)strlen_new, 
			(t_method)strlen_free, sizeof(t_strlen), 0, A_GIMME, 0);
	class_addsymbol(strlen_class, (t_method)strlen_anything);
	post(".    strlen    .    jasch    .    "__DATE__" ",0);
}

void *strlen_new(t_symbol *s, long n)
{
	t_strlen	*x;
	x = (t_strlen *)pd_new(strlen_class);
	x->s_outlet = outlet_new(&x->ob, gensym("float"));
	return (x);									
}

void strlen_anything(t_strlen *x, t_symbol *s, long argc, t_atom *argv)
{
	x->s_length = strlen(s->s_name);
	outlet_float(x->s_outlet,x->s_length);
}

void strlen_free(t_strlen *x)
{
		// notify_free((t_object *)x);
}
