
--echo #
--echo # Show how Mixed Case identifiers are handled for each OS type
--echo #

SHOW VARIABLES LIKE 'lower_case_table_names';

CREATE SCHEMA MixedCaseSchema;
CREATE TABLE MixedCaseSchema.MixedCaseTable (MixedCaseColumn INT);
INSERT INTO MixedCaseSchema.MixedCaseTable (MixedCaseColumn) VALUES (1), (2);
SELECT * FROM MixedCaseSchema.MixedCaseTable;

USE MixedCaseSchema;
SHOW TABLES;
USE test;

SHOW CREATE TABLE MixedCaseSchema.MixedCaseTable;

SELECT TABLE_NAME, TABLE_SCHEMA, TABLE_TYPE, ENGINE FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME LIKE '%ixed%';
SELECT FILE_NAME, FILE_TYPE, TABLESPACE_NAME, TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.FILES WHERE FILE_NAME LIKE '%ixed%';
SELECT NAME, SPACE_TYPE FROM INFORMATION_SCHEMA.INNODB_TABLES WHERE NAME LIKE '%ixed%';
SELECT NAME, SPACE_TYPE FROM INFORMATION_SCHEMA.INNODB_TABLESPACES WHERE NAME LIKE '%ixed%';

--source include/restart_mysqld.inc

INSERT INTO MixedCaseSchema.MixedCaseTable (MixedCaseColumn) VALUES (3), (4);
SELECT * FROM MixedCaseSchema.MixedCaseTable;

USE MixedCaseSchema;
SHOW TABLES;
USE test;

SHOW CREATE TABLE MixedCaseSchema.MixedCaseTable;

SELECT TABLE_NAME, TABLE_SCHEMA, TABLE_TYPE, ENGINE FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME LIKE '%ixed%';
SELECT FILE_NAME, FILE_TYPE, TABLESPACE_NAME, TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.FILES WHERE FILE_NAME LIKE '%ixed%';
SELECT NAME, SPACE_TYPE FROM INFORMATION_SCHEMA.INNODB_TABLES WHERE NAME LIKE '%ixed%';
SELECT NAME, SPACE_TYPE FROM INFORMATION_SCHEMA.INNODB_TABLESPACES WHERE NAME LIKE '%ixed%';

DROP TABLE MixedCaseSchema.MixedCaseTable;
DROP SCHEMA MixedCaseSchema;
