-- test https://github.com/percona/pg_tde/issues/63
CREATE EXTENSION pg_tde;

SELECT pg_tde_add_key_provider_file('file-vault','/tmp/pg_tde_test_keyring.per');
SELECT pg_tde_set_principal_key('test-db-principal-key','file-vault');

CREATE TEMP TABLE src (f1 text) USING :tde_am;
-- Crash on INSERT
INSERT INTO src
VALUES('0.55859909742449630.44658969494913570.54075930161272720.173117157913014630.61483029376206380.65764492874377220.341317552838924730.367982528684053230.175345977931963270.168412839608874880.00154803678245296620.82706532396263290.74748634462447190.090831815264683650.390919315685386960.99951082699941550.9977981693287330.6988579613645320.310754450662202640.90325242484683190.75374800591547490.26680100643896230.55751915566773990.57902456214791110.36183153154123460.63524053266029830.78389378855711180.19584445869629020.199333924650425760.82155191593829560.7371944732869880.183910466357891660.0147813222233452720.3747022411129810.49101561236565550.95483453706535880.35594888092451550.43381965349401440.46361549602747920.50604155870332760.86586716524835540.63478889357891990.77509493569207090.86665305443338790.64852060828658550.50280760242256580.21800585609741340.096173392125813220.0261400320036884180.33800342276157360.485498510272187160.69492885593869610.14719438590370170.57633710730539910.6854376608363930.162803430883830650.28902094699378880.93884121928877070.4124819510126210.69895400258256470.61386295568035320.019902272612943640.85235316437206570.0940431968488260.272794218757168140.61549039934229780.422575394607501930.67002314675933960.465323258961145570.163191821055387760.0126060416991824460.40893698240906830.31893797439819460.15469713662310670.55528689194077320.66788769570588440.71025660771475390.38117379415620990.0220335908759561330.107673951160519810.71950609969184590.54341042925206180.024053937929693570.74203099973156790.035064651259838710.86887319172737380.335093303911782050.7483180995321150.97612135845236070.084654394261215680.76508793255901520.68191364158327270.64505339286832350.448618338317764650.335092422718133550.55149498651635520.9413160253094210.9168195414285170.98684856309613790.60400653549636750.85646368669913330.58837858335250370.9799739681795840.48079146876587030.218616079813109820.9302335200895790.4780449500011730.424050492872935840.063479437634682330.98094393207488960.335273138834828230.48560551700566790.139203310225991970.62595627061874380.71122415168232940.152848330691444540.89199132936279750.27800941859127290.95439564372772280.84837555269067490.75100083734460510.362767538265398760.235976384421268110.61187422491548470.9495830853409060.89514971758309940.26872924068443680.74626444803809160.139587450203541460.302395254482703770.78411327172089250.38966191620694680.198917136896949340.64377926785777470.293260719678428260.44648764937475450.37420519795286180.92220518748025750.0073108929093146370.93143459249930790.61565949670551650.95409849589104280.70559701135921380.80911223952124960.78688763724234260.0143429787186462040.47314838377612680.220085013432371750.74895079799389160.34241785580036590.377476662711184960.55856596798903090.72300200663394070.93372512510565420.48213601319131170.98122442024471220.346628953420145660.74820202768550950.36134870838736320.53096217018068880.91813333111021930.16912775074741670.37503790891484610.9532471869686030.125924225709406650.481359293779658250.49808987733380960.292530386328931250.87891128070888010.190872215535672130.8880398891158570.312849610687170760.83382258936561130.88683286703304340.54819728672968980.55198306885689990.94518489093830830.82370179536934040.39422249429194810.88920643110698830.100781813305392380.156896688655811630.176728786940858470.418953555096873260.49179322828441930.6482244643731250.50630017133792920.96824089562929780.48649962422895390.224128640753047840.65318604085187480.0277597024087572470.269592268429819760.078229807252904630.12959218454427490.76024146340840760.53005245019718040.208874546770384530.55257426353213910.5937585938899110.80002298982932360.176800500254526760.80793461098073150.73215202402765760.89330730727462560.0317516822834684740.160090174689148550.51532774354845980.70921991745912830.138735433408188950.57752467002560.403150487295366840.40749394747573110.66251587358165880.35063881167575020.9599596099677250.445932818660210060.287245889223862740.8257369856611840.70400052356170930.30353378134511090.393039351875958730.362370380599912560.388471172945746850.365472631694610860.54200112719970450.314895026881156560.95277396387790940.65717791763685370.190656024871326270.97805817247168080.82424428074710860.90092118424733720.87158730600807480.92974051731450720.65817976419118640.53290189661821690.39921764010135830.437371129418732130.54880953388242660.68460757473144040.79353167169486190.76018043252842250.86776754557471510.154812009703990.43513822113626890.27237032901240730.319453093144346440.71805913046337030.36559454463692820.744352905917590.104333806358574810.436173275549234240.32527834767622110.267847234273361550.57084377650998520.104177751155159590.33089495199934650.63225317492672660.74723541122747060.494332985433825640.69567541211602820.25175339015164710.63155410904344930.85261979776189520.213947072087478540.116500925662627930.0179480357425600980.174284134096331030.033176454827700930.74261681843758920.87530858693430760.7475446944895350.94056404731337580.63391517780623240.19782412222947120.294298476924694350.078590228180988490.94544551154725580.309740808480930330.58151178351223430.54279813541957210.15899402561489050.220517609114043940.87020048815449540.453872032347550470.152859165096062450.61074979931058640.144888238626858620.99041812532331260.54156908920795370.04165813661344120.52106850675663050.70979862294325490.309423192717801940.104759377449733520.100241108871801820.57623244475946890.89685838695066630.090179331203737560.459757127631922560.91055597599411020.062652892151061620.3957549469001820.20930474506823660.100267794939050910.088485558336314440.48902516637998940.28887564989109650.57153819581046220.55892890575540880.0560891728851322660.7344804208424660.148907757489083360.76957143272000830.154868098317315180.81159315420869630.44133537433804590.37278761862448160.60591287657588920.063302672508175340.053306086212437710.46220266749901540.128985239698984570.85633874521839260.067996420502524520.0284232841636806730.29836261032579190.39154315471529990.222267341457545120.263539428271130970.62778609185857850.60776229183174580.77080401415726360.265763132444866160.242504428121770750.96329054224533460.97762540147621140.89131212200180630.60898765857225670.67429141511349160.60523963808397350.246266851399476350.403945416969184070.57685155716036270.0057898216945795330.461298136292183970.109095726379537130.64108109155126210.52729468037839820.429250823991674140.0461429365458496670.78701739169339650.486744604809777660.67408253928102060.245631501779759680.97499790194550550.85293571370140420.67698635446231050.412067250333180370.97482534007991070.76365268652784390.60843248596980670.325432520881775430.53749708721485770.355229569948804170.42115127519206050.90879701384812690.32908069089866520.33023841256557950.77756498707736620.18756301506162210.52706375281054750.73173435691423450.00241391828323744840.251433710269416850.80702906815626530.2638196814093130.38270953033148090.118473162701491220.83001470395355550.85223182629553640.033022814590289110.9965499529438340.67054036405993680.68755543955027210.208611605942402580.87914323433706860.165905178807298270.182595893077931450.21513996146425130.089552155874880410.314779054365917240.79612735879776710.42602975925430940.90633195438770240.74836824537341370.36821330725304760.56473312465489340.301758528313859740.257557183799996150.52175015048395750.34437531739733030.12803644333956510.58152344614280870.81024139869387970.92151339563803970.9419794316846240.14518928800493570.51509222411904320.88433839509613280.7043713958444770.57844071347444470.82142787881797560.361182666192116030.401080783630624940.00360516170878111280.50992311937912050.48592820943372070.049224043025032140.33757691441461060.63122825460216840.217143314204432780.075532976986801610.88692098500172280.3939705645440310.76987032912433540.42978415521497990.39660803881931270.195834795264905770.68952908520953130.64390116049496760.283061853701023660.75959274948839410.115863202690749350.62027371986814180.61505352340231130.475082412351449430.055534471845069430.36852323404335950.94079455836769110.378262424582432640.76888703633139490.40316203479605360.0618512243941680140.410221022783130660.166202503621515780.77605355493809180.0238360080265551670.58146598984882970.5724057644768230.98836532669660770.317241629857772930.6076338271910620.169824116669973660.235329859686410180.89812158420926110.91911037909535540.89566442642084640.96017124223141990.136805494040843630.29922151617189940.084129285069876050.142322258309026670.331958796010522360.77195152983670480.28065178532813340.34929560908190840.36412919524028410.20623600253013440.98231558166537920.109411601043275520.420751361534868140.25398188076793350.73210274229522860.35523027622504390.56017854324865990.035906773682321980.458594285249765750.429186356476820130.29376322396731270.28620072549417430.81755145809453760.7648289441362690.107720329547366770.312164929559409550.98654986130775990.240209261278337750.71102263928954420.025219566132762550.347013891045537150.94806739585158150.033290356497574390.37228908363793820.50679372610177960.42006058974112090.88192213558663360.9608866193956920.58474979630793890.042227994641621080.0252720756429745120.33045360424017420.073186012566550.51188944632792530.88119389097831840.62135241206234930.273771472557474250.0521672174874079350.221245186496503930.24687691656478240.147320124390813770.190792370597731240.69355122216463560.086056706966926690.82310172842897770.32887183166387790.6268252443986260.63323066430150310.303226019288216350.64636790914559760.62172489249387520.8906208337615320.53724750507000230.91256347427921550.105726509492241270.234224425962393120.59141778297622790.46983523949980890.65062949305891320.8405190258421960.204788284824616750.48877759819797960.206091190201679760.41069264808958360.81763373366381420.5084606548014940.0287355170596057530.262703166966945960.69636550335784660.296805576443307740.33823549021164090.55206402049435740.048599135591500310.180280693104786230.39809430050236940.85783149110582780.59856943049089170.73083898331960610.39115620101771540.97510738320707180.49832685663478360.83969482573285580.81263903325462290.175900457406543480.25362717481604390.4086176886942350.94859118189175340.72728673793949540.86000363710178670.72991922087398780.144146361114049880.137307127131112820.95837138870799480.30464143430607680.60549385299218940.25589131494997110.202879664003428270.64344113573378990.086028307747932020.2162077473738040.133179303093533540.63276918975496830.223612877608330820.090979780540967560.47248850309212910.42497534390669990.54265927351340330.78026452844579630.47617580145072560.52025111760824120.455497539401685140.84750943622097340.209294366697259760.16819707470244150.48476513425161640.57983872920100280.474382158984199660.254874470253334540.52585380692307830.25590342041928180.53444932407398720.2467763723907610.3873669403624920.95841821859258450.63836466385929370.416529458114704760.5385547032325060.55113853218554860.78536228490082220.0423541444084443160.61104340251074580.25024327522581060.8968304236004010.91708646839265830.89986432305046280.244670466125564980.91990842319302280.61089716025359750.64165798316833510.150486815632834280.302656874235680550.77299688751490070.06442465730779690.170187735350043170.96092925877515610.073569446403604080.71566156948489470.41688213041932330.106009564676631920.77772746604669680.40420283080528850.53720781701369490.80248755232571470.9067255270263550.66110396909102160.74198258125295680.100036449910233530.53372181079229670.195456372245575770.36778542134467540.52677015412378260.0046158429404739020.3573129258646650.70710429286692180.7590453334083040.080069319066503390.13645177032718280.75294433071330950.30623120284457350.124939879649973660.74666367922779210.27283546392438620.0249682284310672740.231418455110220080.18240016991642350.94835900483274790.8185585957416810.88227138571932670.5763656518909330.041425729831589430.156495692422954140.383434359444130960.33191761135630470.73429826375351340.70196127414686390.4176693994178480.51798783115477140.133000437723328920.99183781995588590.62038035159226260.70230630180648260.48149294093471930.071032611375611680.316692539064261650.72180762218821220.33585192016184260.2450197225961710.381209315857462760.86065931604870150.20926776488396760.150989235950110820.034414934269560330.202697791930762650.256674769360348830.83792620592924920.115132877456959550.99550359751178990.96660022265996550.215495131403689920.56092083988834850.5414241305269070.94699295816500210.57836049825443240.126634069691756950.34139212995839420.81123452422299750.395502066337996670.02784202585389850.70054461921525820.0251629273855515920.400088495101414750.042343479053726930.255385456379162430.115323214180639290.86052868405649410.80679786790456510.185724249636432410.70225407591357740.58488866880594670.78797295634420.060463509837799690.94239615039764080.390925469140910530.61930394909062090.00242977964733892550.03832342462305660.236127432526586520.85665946639165140.63819586647921330.41918198781161540.8806863111437020.30998197088794630.5091071836721230.85148740830823380.479261121128822240.5493687561286420.406746809922069460.67766155839030540.68582761943917790.6213998619846040.40003951756032510.50012334946657160.86347241702015310.498562514425627160.43387154606222890.43072796203442290.84431096858734240.91556206059139990.075531540204718530.34637779857456620.09803193830141810.113257180770137910.471363081925707750.386860589489405270.84006043516887830.147215521084850480.99494822829120370.8993747317254130.28745440228503780.61276005847955250.472781788642338440.276861272513734940.117763298225837860.215988090000936550.55739417150262690.82256884249839920.24319530989306770.65012212094836630.200740656294019710.94765111093963530.41269728851781330.71225577084735250.400411906058890.95872905170228840.34550901391959330.153222305223898130.95864777832062950.70017440926415330.74467979235810430.96637701524562810.95769716263556770.67722900525357280.277538733464677060.25299627181338760.49175435775497920.444808352839532350.95159141856708640.3290512494095710.261643308927478340.58005405681136550.81668091542356950.5806116903806480.45714437436937770.0562933316045919340.6300438974448530.188623906862750880.21760948467363360.89388938998057510.116537571134564640.95150737833507870.04176692770659640.33629030272703230.90835370155068820.71473766853785060.63270822261999630.093062154612900240.020562706895957740.66910006911490850.211929290423362280.055661110765969690.39836223634887480.94083417838387410.55424792517495880.470869449244478270.87337609853183710.103244217533338570.55321869490207120.54172435809406090.25695314878723720.16631015046142150.76331973383241340.1899178641120980.56554122983082840.89321305405550010.55793973112074410.251214203805392170.88801755321451090.126348423024250640.51313501961726040.71355373012135170.2438577330041840.35699645637431330.67578064396352120.276489256552760350.33298881202684960.00126232159337602570.91768198017511730.389940479426011950.0071034111941941090.485440276060289830.99044697362439730.28868605183053340.092549576897248410.67042684484907470.107407998478450620.386642394768174750.6602118447246730.87454861233932890.17018753511598960.94127747210143740.80321960491334640.97873131544938460.69885414797191640.491085091427780.0256061015472428540.98781509496584550.78234026806900130.77366145515249270.86292229329185880.18141135788276520.53115418675967780.0204720611536368670.78466124297385130.79878337673937040.64676938370403090.66340028659503990.0172587732682336630.50643826587851070.304259859706085050.231148535265845560.72913383643661760.96056196839458270.103726581164883540.723319718296590.96256253881580080.84915058756499540.29326902056361060.060498267997478150.233590322887418770.82394353907746120.35836913871068310.42868318857439360.92620906123748360.428856383380940.0128858422895083980.5897482329242330.74346123509463720.71392134263184510.7922870515385190.45034578460346420.220713070657383660.50036576077936770.33315150965670970.153791141264383760.081628549271551610.50269544524849260.79871301529344190.62880130752812930.61514733085654270.133290598379500750.98622715267453280.236064344707098250.96733120263385030.474023712962884370.31380358511415230.424555265473760770.467924922792159360.0251235794683071220.6759587091182420.182943144737917730.403016682666544670.91099124492879270.282707871188664140.60257089242009630.41189844877838810.24765897575224960.87111564743408910.441703916151838570.224931920602724930.11202177846435290.074042088708803360.73892123885173520.1665949066403940.061017078562687120.47880792614354870.66027786637404670.8643395969145260.372093701089625030.81660163351184290.227518457861348060.81823518538645380.6354593624513880.130643509274014360.49431668684029950.151986269119320340.37132344164127120.7617103369919940.056864798294056440.73540879564125850.65732925913024020.7251631704649990.91258109596924930.80117253974860940.133379923360126050.69118582098829440.87788183388539290.78718370446488680.5781924355256240.72830873052270830.418725353291123260.113458368474375740.72741570241218830.246127795989631970.52988627694727030.52435244304811570.416120042667790240.78792656042796350.67466269717410140.48713989424384320.99027893964726040.57471525724853150.207240278538425530.94860445376822540.38937980296276420.85939650190469960.227749538284571780.91513558546019280.83968344275887110.81636768367206390.89891236927292930.05689027675212710.362862092800543270.86873922271553240.72174266199009860.73772646324074520.82771531001742020.27083109056695510.41648068011031960.089699268759771970.215544913134742220.5868214136880710.310309893365539270.417081436339563850.41264633416121030.94632759256888210.52903739330871650.156591953331768560.63323741807498650.028415091408658720.67147107229582550.237939421790171360.71193150247025860.30796382253117940.4538868452261180.0082861042382491590.83517541288095280.175955384389067770.307543514998160460.382878090844856130.6418790117085420.86507915169740610.94224842628676790.164135522294932780.09486941194495690.157102263729585360.5742678522826350.50625991475584970.131334532205562130.78874937990440010.78110607600549380.7682254095530070.032657183065025520.004936553383318110.6419535543045420.410641505575076060.213250252801446160.54995289118616460.22467936776999430.245124565834815340.8678620340425454');
SELECT * FROM src;

DROP TABLE src;

CREATE TABLE src2 (f1 TEXT) USING :tde_am;
INSERT INTO src2
VALUES('0.55859909742449630.44658969494913570.54075930161272720.173117157913014630.61483029376206380.65764492874377220.341317552838924730.367982528684053230.175345977931963270.168412839608874880.00154803678245296620.82706532396263290.74748634462447190.090831815264683650.390919315685386960.99951082699941550.9977981693287330.6988579613645320.310754450662202640.90325242484683190.75374800591547490.26680100643896230.55751915566773990.57902456214791110.36183153154123460.63524053266029830.78389378855711180.19584445869629020.199333924650425760.82155191593829560.7371944732869880.183910466357891660.0147813222233452720.3747022411129810.49101561236565550.95483453706535880.35594888092451550.43381965349401440.46361549602747920.50604155870332760.86586716524835540.63478889357891990.77509493569207090.86665305443338790.64852060828658550.50280760242256580.21800585609741340.096173392125813220.0261400320036884180.33800342276157360.485498510272187160.69492885593869610.14719438590370170.57633710730539910.6854376608363930.162803430883830650.28902094699378880.93884121928877070.4124819510126210.69895400258256470.61386295568035320.019902272612943640.85235316437206570.0940431968488260.272794218757168140.61549039934229780.422575394607501930.67002314675933960.465323258961145570.163191821055387760.0126060416991824460.40893698240906830.31893797439819460.15469713662310670.55528689194077320.66788769570588440.71025660771475390.38117379415620990.0220335908759561330.107673951160519810.71950609969184590.54341042925206180.024053937929693570.74203099973156790.035064651259838710.86887319172737380.335093303911782050.7483180995321150.97612135845236070.084654394261215680.76508793255901520.68191364158327270.64505339286832350.448618338317764650.335092422718133550.55149498651635520.9413160253094210.9168195414285170.98684856309613790.60400653549636750.85646368669913330.58837858335250370.9799739681795840.48079146876587030.218616079813109820.9302335200895790.4780449500011730.424050492872935840.063479437634682330.98094393207488960.335273138834828230.48560551700566790.139203310225991970.62595627061874380.71122415168232940.152848330691444540.89199132936279750.27800941859127290.95439564372772280.84837555269067490.75100083734460510.362767538265398760.235976384421268110.61187422491548470.9495830853409060.89514971758309940.26872924068443680.74626444803809160.139587450203541460.302395254482703770.78411327172089250.38966191620694680.198917136896949340.64377926785777470.293260719678428260.44648764937475450.37420519795286180.92220518748025750.0073108929093146370.93143459249930790.61565949670551650.95409849589104280.70559701135921380.80911223952124960.78688763724234260.0143429787186462040.47314838377612680.220085013432371750.74895079799389160.34241785580036590.377476662711184960.55856596798903090.72300200663394070.93372512510565420.48213601319131170.98122442024471220.346628953420145660.74820202768550950.36134870838736320.53096217018068880.91813333111021930.16912775074741670.37503790891484610.9532471869686030.125924225709406650.481359293779658250.49808987733380960.292530386328931250.87891128070888010.190872215535672130.8880398891158570.312849610687170760.83382258936561130.88683286703304340.54819728672968980.55198306885689990.94518489093830830.82370179536934040.39422249429194810.88920643110698830.100781813305392380.156896688655811630.176728786940858470.418953555096873260.49179322828441930.6482244643731250.50630017133792920.96824089562929780.48649962422895390.224128640753047840.65318604085187480.0277597024087572470.269592268429819760.078229807252904630.12959218454427490.76024146340840760.53005245019718040.208874546770384530.55257426353213910.5937585938899110.80002298982932360.176800500254526760.80793461098073150.73215202402765760.89330730727462560.0317516822834684740.160090174689148550.51532774354845980.70921991745912830.138735433408188950.57752467002560.403150487295366840.40749394747573110.66251587358165880.35063881167575020.9599596099677250.445932818660210060.287245889223862740.8257369856611840.70400052356170930.30353378134511090.393039351875958730.362370380599912560.388471172945746850.365472631694610860.54200112719970450.314895026881156560.95277396387790940.65717791763685370.190656024871326270.97805817247168080.82424428074710860.90092118424733720.87158730600807480.92974051731450720.65817976419118640.53290189661821690.39921764010135830.437371129418732130.54880953388242660.68460757473144040.79353167169486190.76018043252842250.86776754557471510.154812009703990.43513822113626890.27237032901240730.319453093144346440.71805913046337030.36559454463692820.744352905917590.104333806358574810.436173275549234240.32527834767622110.267847234273361550.57084377650998520.104177751155159590.33089495199934650.63225317492672660.74723541122747060.494332985433825640.69567541211602820.25175339015164710.63155410904344930.85261979776189520.213947072087478540.116500925662627930.0179480357425600980.174284134096331030.033176454827700930.74261681843758920.87530858693430760.7475446944895350.94056404731337580.63391517780623240.19782412222947120.294298476924694350.078590228180988490.94544551154725580.309740808480930330.58151178351223430.54279813541957210.15899402561489050.220517609114043940.87020048815449540.453872032347550470.152859165096062450.61074979931058640.144888238626858620.99041812532331260.54156908920795370.04165813661344120.52106850675663050.70979862294325490.309423192717801940.104759377449733520.100241108871801820.57623244475946890.89685838695066630.090179331203737560.459757127631922560.91055597599411020.062652892151061620.3957549469001820.20930474506823660.100267794939050910.088485558336314440.48902516637998940.28887564989109650.57153819581046220.55892890575540880.0560891728851322660.7344804208424660.148907757489083360.76957143272000830.154868098317315180.81159315420869630.44133537433804590.37278761862448160.60591287657588920.063302672508175340.053306086212437710.46220266749901540.128985239698984570.85633874521839260.067996420502524520.0284232841636806730.29836261032579190.39154315471529990.222267341457545120.263539428271130970.62778609185857850.60776229183174580.77080401415726360.265763132444866160.242504428121770750.96329054224533460.97762540147621140.89131212200180630.60898765857225670.67429141511349160.60523963808397350.246266851399476350.403945416969184070.57685155716036270.0057898216945795330.461298136292183970.109095726379537130.64108109155126210.52729468037839820.429250823991674140.0461429365458496670.78701739169339650.486744604809777660.67408253928102060.245631501779759680.97499790194550550.85293571370140420.67698635446231050.412067250333180370.97482534007991070.76365268652784390.60843248596980670.325432520881775430.53749708721485770.355229569948804170.42115127519206050.90879701384812690.32908069089866520.33023841256557950.77756498707736620.18756301506162210.52706375281054750.73173435691423450.00241391828323744840.251433710269416850.80702906815626530.2638196814093130.38270953033148090.118473162701491220.83001470395355550.85223182629553640.033022814590289110.9965499529438340.67054036405993680.68755543955027210.208611605942402580.87914323433706860.165905178807298270.182595893077931450.21513996146425130.089552155874880410.314779054365917240.79612735879776710.42602975925430940.90633195438770240.74836824537341370.36821330725304760.56473312465489340.301758528313859740.257557183799996150.52175015048395750.34437531739733030.12803644333956510.58152344614280870.81024139869387970.92151339563803970.9419794316846240.14518928800493570.51509222411904320.88433839509613280.7043713958444770.57844071347444470.82142787881797560.361182666192116030.401080783630624940.00360516170878111280.50992311937912050.48592820943372070.049224043025032140.33757691441461060.63122825460216840.217143314204432780.075532976986801610.88692098500172280.3939705645440310.76987032912433540.42978415521497990.39660803881931270.195834795264905770.68952908520953130.64390116049496760.283061853701023660.75959274948839410.115863202690749350.62027371986814180.61505352340231130.475082412351449430.055534471845069430.36852323404335950.94079455836769110.378262424582432640.76888703633139490.40316203479605360.0618512243941680140.410221022783130660.166202503621515780.77605355493809180.0238360080265551670.58146598984882970.5724057644768230.98836532669660770.317241629857772930.6076338271910620.169824116669973660.235329859686410180.89812158420926110.91911037909535540.89566442642084640.96017124223141990.136805494040843630.29922151617189940.084129285069876050.142322258309026670.331958796010522360.77195152983670480.28065178532813340.34929560908190840.36412919524028410.20623600253013440.98231558166537920.109411601043275520.420751361534868140.25398188076793350.73210274229522860.35523027622504390.56017854324865990.035906773682321980.458594285249765750.429186356476820130.29376322396731270.28620072549417430.81755145809453760.7648289441362690.107720329547366770.312164929559409550.98654986130775990.240209261278337750.71102263928954420.025219566132762550.347013891045537150.94806739585158150.033290356497574390.37228908363793820.50679372610177960.42006058974112090.88192213558663360.9608866193956920.58474979630793890.042227994641621080.0252720756429745120.33045360424017420.073186012566550.51188944632792530.88119389097831840.62135241206234930.273771472557474250.0521672174874079350.221245186496503930.24687691656478240.147320124390813770.190792370597731240.69355122216463560.086056706966926690.82310172842897770.32887183166387790.6268252443986260.63323066430150310.303226019288216350.64636790914559760.62172489249387520.8906208337615320.53724750507000230.91256347427921550.105726509492241270.234224425962393120.59141778297622790.46983523949980890.65062949305891320.8405190258421960.204788284824616750.48877759819797960.206091190201679760.41069264808958360.81763373366381420.5084606548014940.0287355170596057530.262703166966945960.69636550335784660.296805576443307740.33823549021164090.55206402049435740.048599135591500310.180280693104786230.39809430050236940.85783149110582780.59856943049089170.73083898331960610.39115620101771540.97510738320707180.49832685663478360.83969482573285580.81263903325462290.175900457406543480.25362717481604390.4086176886942350.94859118189175340.72728673793949540.86000363710178670.72991922087398780.144146361114049880.137307127131112820.95837138870799480.30464143430607680.60549385299218940.25589131494997110.202879664003428270.64344113573378990.086028307747932020.2162077473738040.133179303093533540.63276918975496830.223612877608330820.090979780540967560.47248850309212910.42497534390669990.54265927351340330.78026452844579630.47617580145072560.52025111760824120.455497539401685140.84750943622097340.209294366697259760.16819707470244150.48476513425161640.57983872920100280.474382158984199660.254874470253334540.52585380692307830.25590342041928180.53444932407398720.2467763723907610.3873669403624920.95841821859258450.63836466385929370.416529458114704760.5385547032325060.55113853218554860.78536228490082220.0423541444084443160.61104340251074580.25024327522581060.8968304236004010.91708646839265830.89986432305046280.244670466125564980.91990842319302280.61089716025359750.64165798316833510.150486815632834280.302656874235680550.77299688751490070.06442465730779690.170187735350043170.96092925877515610.073569446403604080.71566156948489470.41688213041932330.106009564676631920.77772746604669680.40420283080528850.53720781701369490.80248755232571470.9067255270263550.66110396909102160.74198258125295680.100036449910233530.53372181079229670.195456372245575770.36778542134467540.52677015412378260.0046158429404739020.3573129258646650.70710429286692180.7590453334083040.080069319066503390.13645177032718280.75294433071330950.30623120284457350.124939879649973660.74666367922779210.27283546392438620.0249682284310672740.231418455110220080.18240016991642350.94835900483274790.8185585957416810.88227138571932670.5763656518909330.041425729831589430.156495692422954140.383434359444130960.33191761135630470.73429826375351340.70196127414686390.4176693994178480.51798783115477140.133000437723328920.99183781995588590.62038035159226260.70230630180648260.48149294093471930.071032611375611680.316692539064261650.72180762218821220.33585192016184260.2450197225961710.381209315857462760.86065931604870150.20926776488396760.150989235950110820.034414934269560330.202697791930762650.256674769360348830.83792620592924920.115132877456959550.99550359751178990.96660022265996550.215495131403689920.56092083988834850.5414241305269070.94699295816500210.57836049825443240.126634069691756950.34139212995839420.81123452422299750.395502066337996670.02784202585389850.70054461921525820.0251629273855515920.400088495101414750.042343479053726930.255385456379162430.115323214180639290.86052868405649410.80679786790456510.185724249636432410.70225407591357740.58488866880594670.78797295634420.060463509837799690.94239615039764080.390925469140910530.61930394909062090.00242977964733892550.03832342462305660.236127432526586520.85665946639165140.63819586647921330.41918198781161540.8806863111437020.30998197088794630.5091071836721230.85148740830823380.479261121128822240.5493687561286420.406746809922069460.67766155839030540.68582761943917790.6213998619846040.40003951756032510.50012334946657160.86347241702015310.498562514425627160.43387154606222890.43072796203442290.84431096858734240.91556206059139990.075531540204718530.34637779857456620.09803193830141810.113257180770137910.471363081925707750.386860589489405270.84006043516887830.147215521084850480.99494822829120370.8993747317254130.28745440228503780.61276005847955250.472781788642338440.276861272513734940.117763298225837860.215988090000936550.55739417150262690.82256884249839920.24319530989306770.65012212094836630.200740656294019710.94765111093963530.41269728851781330.71225577084735250.400411906058890.95872905170228840.34550901391959330.153222305223898130.95864777832062950.70017440926415330.74467979235810430.96637701524562810.95769716263556770.67722900525357280.277538733464677060.25299627181338760.49175435775497920.444808352839532350.95159141856708640.3290512494095710.261643308927478340.58005405681136550.81668091542356950.5806116903806480.45714437436937770.0562933316045919340.6300438974448530.188623906862750880.21760948467363360.89388938998057510.116537571134564640.95150737833507870.04176692770659640.33629030272703230.90835370155068820.71473766853785060.63270822261999630.093062154612900240.020562706895957740.66910006911490850.211929290423362280.055661110765969690.39836223634887480.94083417838387410.55424792517495880.470869449244478270.87337609853183710.103244217533338570.55321869490207120.54172435809406090.25695314878723720.16631015046142150.76331973383241340.1899178641120980.56554122983082840.89321305405550010.55793973112074410.251214203805392170.88801755321451090.126348423024250640.51313501961726040.71355373012135170.2438577330041840.35699645637431330.67578064396352120.276489256552760350.33298881202684960.00126232159337602570.91768198017511730.389940479426011950.0071034111941941090.485440276060289830.99044697362439730.28868605183053340.092549576897248410.67042684484907470.107407998478450620.386642394768174750.6602118447246730.87454861233932890.17018753511598960.94127747210143740.80321960491334640.97873131544938460.69885414797191640.491085091427780.0256061015472428540.98781509496584550.78234026806900130.77366145515249270.86292229329185880.18141135788276520.53115418675967780.0204720611536368670.78466124297385130.79878337673937040.64676938370403090.66340028659503990.0172587732682336630.50643826587851070.304259859706085050.231148535265845560.72913383643661760.96056196839458270.103726581164883540.723319718296590.96256253881580080.84915058756499540.29326902056361060.060498267997478150.233590322887418770.82394353907746120.35836913871068310.42868318857439360.92620906123748360.428856383380940.0128858422895083980.5897482329242330.74346123509463720.71392134263184510.7922870515385190.45034578460346420.220713070657383660.50036576077936770.33315150965670970.153791141264383760.081628549271551610.50269544524849260.79871301529344190.62880130752812930.61514733085654270.133290598379500750.98622715267453280.236064344707098250.96733120263385030.474023712962884370.31380358511415230.424555265473760770.467924922792159360.0251235794683071220.6759587091182420.182943144737917730.403016682666544670.91099124492879270.282707871188664140.60257089242009630.41189844877838810.24765897575224960.87111564743408910.441703916151838570.224931920602724930.11202177846435290.074042088708803360.73892123885173520.1665949066403940.061017078562687120.47880792614354870.66027786637404670.8643395969145260.372093701089625030.81660163351184290.227518457861348060.81823518538645380.6354593624513880.130643509274014360.49431668684029950.151986269119320340.37132344164127120.7617103369919940.056864798294056440.73540879564125850.65732925913024020.7251631704649990.91258109596924930.80117253974860940.133379923360126050.69118582098829440.87788183388539290.78718370446488680.5781924355256240.72830873052270830.418725353291123260.113458368474375740.72741570241218830.246127795989631970.52988627694727030.52435244304811570.416120042667790240.78792656042796350.67466269717410140.48713989424384320.99027893964726040.57471525724853150.207240278538425530.94860445376822540.38937980296276420.85939650190469960.227749538284571780.91513558546019280.83968344275887110.81636768367206390.89891236927292930.05689027675212710.362862092800543270.86873922271553240.72174266199009860.73772646324074520.82771531001742020.27083109056695510.41648068011031960.089699268759771970.215544913134742220.5868214136880710.310309893365539270.417081436339563850.41264633416121030.94632759256888210.52903739330871650.156591953331768560.63323741807498650.028415091408658720.67147107229582550.237939421790171360.71193150247025860.30796382253117940.4538868452261180.0082861042382491590.83517541288095280.175955384389067770.307543514998160460.382878090844856130.6418790117085420.86507915169740610.94224842628676790.164135522294932780.09486941194495690.157102263729585360.5742678522826350.50625991475584970.131334532205562130.78874937990440010.78110607600549380.7682254095530070.032657183065025520.004936553383318110.6419535543045420.410641505575076060.213250252801446160.54995289118616460.22467936776999430.245124565834815340.8678620340425454');
SELECT * FROM src2;

DROP TABLE src2;

-- https://github.com/percona/pg_tde/issues/82 
CREATE TABLE indtoasttest(descr text, cnt int DEFAULT 0, f1 text, f2 text) using :tde_am;

INSERT INTO indtoasttest(descr, f1, f2) VALUES('two-compressed', repeat('1234567890',1000), repeat('1234567890',1000));
INSERT INTO indtoasttest(descr, f1, f2) VALUES('two-toasted', repeat('1234567890',30000), repeat('1234567890',50000));
INSERT INTO indtoasttest(descr, f1, f2) VALUES('one-compressed,one-null', NULL, repeat('1234567890',1000));
INSERT INTO indtoasttest(descr, f1, f2) VALUES('one-toasted,one-null', NULL, repeat('1234567890',50000));

UPDATE indtoasttest SET cnt = cnt +1 RETURNING substring(indtoasttest::text, 1, 200);
UPDATE indtoasttest SET cnt = cnt +1, f1 = f1 RETURNING substring(indtoasttest::text, 1, 200);
UPDATE indtoasttest SET cnt = cnt +1, f1 = f1||'' RETURNING substring(indtoasttest::text, 1, 200);
UPDATE indtoasttest SET cnt = cnt +1, f1 = f1||'' RETURNING substring(indtoasttest::text, 1, 200);
UPDATE indtoasttest SET  f2 = '+'||f2||'-' ;

DROP TABLE indtoasttest;

-- Test substr with toasted externalized bytea values
CREATE TABLE toasttest(t bytea STORAGE EXTERNAL) using :tde_am;
INSERT INTO toasttest VALUES (decode(repeat('1234567890',10000), 'escape'));

SET bytea_output = 'escape';
SELECT substring(t, 1, 10) FROM toasttest;
SELECT substring(t, 50001, 10) FROM toasttest;
SELECT substring(t, 99991) FROM toasttest;

DROP TABLE toasttest;

DROP EXTENSION pg_tde;
