﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/kinesisanalytics/model/ListApplicationsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::KinesisAnalytics::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

ListApplicationsRequest::ListApplicationsRequest() : 
    m_limit(0),
    m_limitHasBeenSet(false),
    m_exclusiveStartApplicationNameHasBeenSet(false)
{
}

Aws::String ListApplicationsRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_limitHasBeenSet)
  {
   payload.WithInteger("Limit", m_limit);

  }

  if(m_exclusiveStartApplicationNameHasBeenSet)
  {
   payload.WithString("ExclusiveStartApplicationName", m_exclusiveStartApplicationName);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection ListApplicationsRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "KinesisAnalytics_20150814.ListApplications"));
  return headers;

}




