#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Generate trace/generated-helpers.h.
"""

__author__     = "Lluís Vilanova <vilanova@ac.upc.edu>"
__copyright__  = "Copyright 2012-2014, Lluís Vilanova <vilanova@ac.upc.edu>"
__license__    = "GPL version 2 or (at your option) any later version"

__maintainer__ = "Stefan Hajnoczi"
__email__      = "stefanha@linux.vnet.ibm.com"


from tracetool import out
from tracetool.transform import *


def generate(events, backend):
    events = [e for e in events
              if "disable" not in e.properties]

    out('/* This file is autogenerated by tracetool, do not edit. */',
        '',
        )

    for e in events:
        if "tcg-exec" not in e.properties:
            continue

        # tracetool.generate always transforms types to host
        e_args = e.original.args

        # TCG helper proxy declaration
        fmt = "DEF_HELPER_FLAGS_%(argc)d(%(name)s, %(flags)svoid%(types)s)"
        args = e_args.transform(HOST_2_TCG_COMPAT, HOST_2_TCG,
                                TCG_2_TCG_HELPER_DECL)
        types = ", ".join(args.types())
        if types != "":
            types = ", " + types

        flags = "TCG_CALL_NO_RWG, "

        out(fmt,
            flags=flags,
            argc=len(args),
            name=e.api() + "_proxy",
            types=types,
            )
