/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.LaunchPermission;
import com.amazonaws.services.ec2.model.ProductCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImageAttribute {
    private String imageId;
    private List<LaunchPermission> launchPermissions;
    private List<ProductCode> productCodes;
    private String kernelId;
    private String ramdiskId;
    private String description;
    private String sriovNetSupport;
    private List<BlockDeviceMapping> blockDeviceMappings;

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public ImageAttribute withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public List<LaunchPermission> getLaunchPermissions() {
        if (this.launchPermissions == null) {
            this.launchPermissions = new ArrayList<LaunchPermission>();
        }
        return this.launchPermissions;
    }

    public void setLaunchPermissions(Collection<LaunchPermission> launchPermissions) {
        if (launchPermissions == null) {
            this.launchPermissions = null;
            return;
        }
        ArrayList<LaunchPermission> launchPermissionsCopy = new ArrayList<LaunchPermission>(launchPermissions.size());
        launchPermissionsCopy.addAll(launchPermissions);
        this.launchPermissions = launchPermissionsCopy;
    }

    public ImageAttribute withLaunchPermissions(LaunchPermission ... launchPermissions) {
        if (this.getLaunchPermissions() == null) {
            this.setLaunchPermissions(new ArrayList<LaunchPermission>(launchPermissions.length));
        }
        for (LaunchPermission value : launchPermissions) {
            this.getLaunchPermissions().add(value);
        }
        return this;
    }

    public ImageAttribute withLaunchPermissions(Collection<LaunchPermission> launchPermissions) {
        if (launchPermissions == null) {
            this.launchPermissions = null;
        } else {
            ArrayList<LaunchPermission> launchPermissionsCopy = new ArrayList<LaunchPermission>(launchPermissions.size());
            launchPermissionsCopy.addAll(launchPermissions);
            this.launchPermissions = launchPermissionsCopy;
        }
        return this;
    }

    public List<ProductCode> getProductCodes() {
        if (this.productCodes == null) {
            this.productCodes = new ArrayList<ProductCode>();
        }
        return this.productCodes;
    }

    public void setProductCodes(Collection<ProductCode> productCodes) {
        if (productCodes == null) {
            this.productCodes = null;
            return;
        }
        ArrayList<ProductCode> productCodesCopy = new ArrayList<ProductCode>(productCodes.size());
        productCodesCopy.addAll(productCodes);
        this.productCodes = productCodesCopy;
    }

    public ImageAttribute withProductCodes(ProductCode ... productCodes) {
        if (this.getProductCodes() == null) {
            this.setProductCodes(new ArrayList<ProductCode>(productCodes.length));
        }
        for (ProductCode value : productCodes) {
            this.getProductCodes().add(value);
        }
        return this;
    }

    public ImageAttribute withProductCodes(Collection<ProductCode> productCodes) {
        if (productCodes == null) {
            this.productCodes = null;
        } else {
            ArrayList<ProductCode> productCodesCopy = new ArrayList<ProductCode>(productCodes.size());
            productCodesCopy.addAll(productCodes);
            this.productCodes = productCodesCopy;
        }
        return this;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public ImageAttribute withKernelId(String kernelId) {
        this.kernelId = kernelId;
        return this;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public ImageAttribute withRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImageAttribute withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getSriovNetSupport() {
        return this.sriovNetSupport;
    }

    public void setSriovNetSupport(String sriovNetSupport) {
        this.sriovNetSupport = sriovNetSupport;
    }

    public ImageAttribute withSriovNetSupport(String sriovNetSupport) {
        this.sriovNetSupport = sriovNetSupport;
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>(blockDeviceMappings.size());
        blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        this.blockDeviceMappings = blockDeviceMappingsCopy;
    }

    public ImageAttribute withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.getBlockDeviceMappings() == null) {
            this.setBlockDeviceMappings(new ArrayList<BlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping value : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(value);
        }
        return this;
    }

    public ImageAttribute withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
        } else {
            ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>(blockDeviceMappings.size());
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
            this.blockDeviceMappings = blockDeviceMappingsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageId != null) {
            sb.append("ImageId: " + this.imageId + ", ");
        }
        if (this.launchPermissions != null) {
            sb.append("LaunchPermissions: " + this.launchPermissions + ", ");
        }
        if (this.productCodes != null) {
            sb.append("ProductCodes: " + this.productCodes + ", ");
        }
        if (this.kernelId != null) {
            sb.append("KernelId: " + this.kernelId + ", ");
        }
        if (this.ramdiskId != null) {
            sb.append("RamdiskId: " + this.ramdiskId + ", ");
        }
        if (this.description != null) {
            sb.append("Description: " + this.description + ", ");
        }
        if (this.sriovNetSupport != null) {
            sb.append("SriovNetSupport: " + this.sriovNetSupport + ", ");
        }
        if (this.blockDeviceMappings != null) {
            sb.append("BlockDeviceMappings: " + this.blockDeviceMappings + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchPermissions() == null ? 0 : ((Object)this.getLaunchPermissions()).hashCode());
        hashCode = 31 * hashCode + (this.getProductCodes() == null ? 0 : ((Object)this.getProductCodes()).hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSriovNetSupport() == null ? 0 : this.getSriovNetSupport().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : ((Object)this.getBlockDeviceMappings()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageAttribute)) {
            return false;
        }
        ImageAttribute other = (ImageAttribute)obj;
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getLaunchPermissions() == null ^ this.getLaunchPermissions() == null) {
            return false;
        }
        if (other.getLaunchPermissions() != null && !((Object)other.getLaunchPermissions()).equals(this.getLaunchPermissions())) {
            return false;
        }
        if (other.getProductCodes() == null ^ this.getProductCodes() == null) {
            return false;
        }
        if (other.getProductCodes() != null && !((Object)other.getProductCodes()).equals(this.getProductCodes())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSriovNetSupport() == null ^ this.getSriovNetSupport() == null) {
            return false;
        }
        if (other.getSriovNetSupport() != null && !other.getSriovNetSupport().equals(this.getSriovNetSupport())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        return other.getBlockDeviceMappings() == null || ((Object)other.getBlockDeviceMappings()).equals(this.getBlockDeviceMappings());
    }
}

