/* Logging.c generated by valac 0.16.1, the Vala compiler
 * generated from Logging.vala, do not modify */

/*
 * Copyright (C) 2011 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gee.h>


#define DVB_LOGGING_TYPE_LOG_LEVEL (dvb_logging_log_level_get_type ())

#define DVB_LOGGING_TYPE_FORMATTER (dvb_logging_formatter_get_type ())
#define DVB_LOGGING_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_FORMATTER, DVBLoggingFormatter))
#define DVB_LOGGING_IS_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_FORMATTER))
#define DVB_LOGGING_FORMATTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_LOGGING_TYPE_FORMATTER, DVBLoggingFormatterIface))

typedef struct _DVBLoggingFormatter DVBLoggingFormatter;
typedef struct _DVBLoggingFormatterIface DVBLoggingFormatterIface;

#define DVB_LOGGING_TYPE_HANDLER (dvb_logging_handler_get_type ())
#define DVB_LOGGING_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_HANDLER, DVBLoggingHandler))
#define DVB_LOGGING_IS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_HANDLER))
#define DVB_LOGGING_HANDLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_LOGGING_TYPE_HANDLER, DVBLoggingHandlerIface))

typedef struct _DVBLoggingHandler DVBLoggingHandler;
typedef struct _DVBLoggingHandlerIface DVBLoggingHandlerIface;

#define DVB_LOGGING_TYPE_DEFAULT_FORMATTER (dvb_logging_default_formatter_get_type ())
#define DVB_LOGGING_DEFAULT_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_DEFAULT_FORMATTER, DVBLoggingDefaultFormatter))
#define DVB_LOGGING_DEFAULT_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_DEFAULT_FORMATTER, DVBLoggingDefaultFormatterClass))
#define DVB_LOGGING_IS_DEFAULT_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_DEFAULT_FORMATTER))
#define DVB_LOGGING_IS_DEFAULT_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_DEFAULT_FORMATTER))
#define DVB_LOGGING_DEFAULT_FORMATTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_DEFAULT_FORMATTER, DVBLoggingDefaultFormatterClass))

typedef struct _DVBLoggingDefaultFormatter DVBLoggingDefaultFormatter;
typedef struct _DVBLoggingDefaultFormatterClass DVBLoggingDefaultFormatterClass;
typedef struct _DVBLoggingDefaultFormatterPrivate DVBLoggingDefaultFormatterPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_LOGGING_TYPE_COLOR_FORMATTER (dvb_logging_color_formatter_get_type ())
#define DVB_LOGGING_COLOR_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_COLOR_FORMATTER, DVBLoggingColorFormatter))
#define DVB_LOGGING_COLOR_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_COLOR_FORMATTER, DVBLoggingColorFormatterClass))
#define DVB_LOGGING_IS_COLOR_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_COLOR_FORMATTER))
#define DVB_LOGGING_IS_COLOR_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_COLOR_FORMATTER))
#define DVB_LOGGING_COLOR_FORMATTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_COLOR_FORMATTER, DVBLoggingColorFormatterClass))

typedef struct _DVBLoggingColorFormatter DVBLoggingColorFormatter;
typedef struct _DVBLoggingColorFormatterClass DVBLoggingColorFormatterClass;
typedef struct _DVBLoggingColorFormatterPrivate DVBLoggingColorFormatterPrivate;

#define DVB_LOGGING_TYPE_CONSOLE_HANDLER (dvb_logging_console_handler_get_type ())
#define DVB_LOGGING_CONSOLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandler))
#define DVB_LOGGING_CONSOLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandlerClass))
#define DVB_LOGGING_IS_CONSOLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_CONSOLE_HANDLER))
#define DVB_LOGGING_IS_CONSOLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_CONSOLE_HANDLER))
#define DVB_LOGGING_CONSOLE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandlerClass))

typedef struct _DVBLoggingConsoleHandler DVBLoggingConsoleHandler;
typedef struct _DVBLoggingConsoleHandlerClass DVBLoggingConsoleHandlerClass;
typedef struct _DVBLoggingConsoleHandlerPrivate DVBLoggingConsoleHandlerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_LOGGING_TYPE_FILE_HANDLER (dvb_logging_file_handler_get_type ())
#define DVB_LOGGING_FILE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandler))
#define DVB_LOGGING_FILE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandlerClass))
#define DVB_LOGGING_IS_FILE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_FILE_HANDLER))
#define DVB_LOGGING_IS_FILE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_FILE_HANDLER))
#define DVB_LOGGING_FILE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandlerClass))

typedef struct _DVBLoggingFileHandler DVBLoggingFileHandler;
typedef struct _DVBLoggingFileHandlerClass DVBLoggingFileHandlerClass;
typedef struct _DVBLoggingFileHandlerPrivate DVBLoggingFileHandlerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;
typedef struct _DVBLoggingLoggerPrivate DVBLoggingLoggerPrivate;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
typedef struct _DVBLoggingLogManagerPrivate DVBLoggingLogManagerPrivate;

typedef enum  {
	DVB_LOGGING_LOG_LEVEL_LOG,
	DVB_LOGGING_LOG_LEVEL_DEBUG,
	DVB_LOGGING_LOG_LEVEL_INFO,
	DVB_LOGGING_LOG_LEVEL_WARNING,
	DVB_LOGGING_LOG_LEVEL_ERROR
} DVBLoggingLogLevel;

struct _DVBLoggingFormatterIface {
	GTypeInterface parent_iface;
	gchar* (*format) (DVBLoggingFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
};

struct _DVBLoggingHandlerIface {
	GTypeInterface parent_iface;
	void (*publish) (DVBLoggingHandler* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args);
	void (*close) (DVBLoggingHandler* self);
	DVBLoggingFormatter* (*get_formatter) (DVBLoggingHandler* self);
	void (*set_formatter) (DVBLoggingHandler* self, DVBLoggingFormatter* value);
	DVBLoggingLogLevel (*get_threshold) (DVBLoggingHandler* self);
	void (*set_threshold) (DVBLoggingHandler* self, DVBLoggingLogLevel value);
};

struct _DVBLoggingDefaultFormatter {
	GObject parent_instance;
	DVBLoggingDefaultFormatterPrivate * priv;
};

struct _DVBLoggingDefaultFormatterClass {
	GObjectClass parent_class;
	gchar* (*get_level_name) (DVBLoggingDefaultFormatter* self, DVBLoggingLogLevel level);
	gchar* (*format) (DVBLoggingDefaultFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
};

struct _DVBLoggingColorFormatter {
	DVBLoggingDefaultFormatter parent_instance;
	DVBLoggingColorFormatterPrivate * priv;
};

struct _DVBLoggingColorFormatterClass {
	DVBLoggingDefaultFormatterClass parent_class;
};

struct _DVBLoggingConsoleHandler {
	GObject parent_instance;
	DVBLoggingConsoleHandlerPrivate * priv;
};

struct _DVBLoggingConsoleHandlerClass {
	GObjectClass parent_class;
};

struct _DVBLoggingConsoleHandlerPrivate {
	DVBLoggingFormatter* _formatter;
	DVBLoggingLogLevel _threshold;
};

struct _DVBLoggingFileHandler {
	GObject parent_instance;
	DVBLoggingFileHandlerPrivate * priv;
};

struct _DVBLoggingFileHandlerClass {
	GObjectClass parent_class;
};

struct _DVBLoggingFileHandlerPrivate {
	DVBLoggingFormatter* _formatter;
	DVBLoggingLogLevel _threshold;
	gint _limit;
	gint _count;
	gchar* _pattern;
	GOutputStream* os;
	gint file_size;
	gint file_index;
};

struct _DVBLoggingLogger {
	GObject parent_instance;
	DVBLoggingLoggerPrivate * priv;
};

struct _DVBLoggingLoggerClass {
	GObjectClass parent_class;
};

struct _DVBLoggingLoggerPrivate {
	gchar* _name;
	GeeHashSet* handlers;
	GStaticRecMutex __lock_handlers;
};

struct _DVBLoggingLogManager {
	GObject parent_instance;
	DVBLoggingLogManagerPrivate * priv;
};

struct _DVBLoggingLogManagerClass {
	GObjectClass parent_class;
};

struct _DVBLoggingLogManagerPrivate {
	GeeHashMap* loggers;
	GStaticRecMutex __lock_loggers;
};


static gpointer dvb_logging_default_formatter_parent_class = NULL;
static DVBLoggingFormatterIface* dvb_logging_default_formatter_dvb_logging_formatter_parent_iface = NULL;
static gpointer dvb_logging_color_formatter_parent_class = NULL;
static gchar** dvb_logging_color_formatter_colormap;
static gint dvb_logging_color_formatter_colormap_length1;
static gchar** dvb_logging_color_formatter_colormap = NULL;
static gint dvb_logging_color_formatter_colormap_length1 = 0;
static gint _dvb_logging_color_formatter_colormap_size_ = 0;
static gpointer dvb_logging_console_handler_parent_class = NULL;
static DVBLoggingHandlerIface* dvb_logging_console_handler_dvb_logging_handler_parent_iface = NULL;
static gpointer dvb_logging_file_handler_parent_class = NULL;
static DVBLoggingHandlerIface* dvb_logging_file_handler_dvb_logging_handler_parent_iface = NULL;
static gpointer dvb_logging_logger_parent_class = NULL;
static gpointer dvb_logging_log_manager_parent_class = NULL;
static DVBLoggingLogManager* dvb_logging_log_manager_instance;
static DVBLoggingLogManager* dvb_logging_log_manager_instance = NULL;
static GRecMutex dvb_logging_log_manager_instance_mutex;
static GRecMutex dvb_logging_log_manager_instance_mutex = {0};

GType dvb_logging_log_level_get_type (void) G_GNUC_CONST;
GType dvb_logging_formatter_get_type (void) G_GNUC_CONST;
gchar* dvb_logging_formatter_format (DVBLoggingFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
GType dvb_logging_handler_get_type (void) G_GNUC_CONST;
void dvb_logging_handler_publish (DVBLoggingHandler* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args);
void dvb_logging_handler_close (DVBLoggingHandler* self);
DVBLoggingFormatter* dvb_logging_handler_get_formatter (DVBLoggingHandler* self);
void dvb_logging_handler_set_formatter (DVBLoggingHandler* self, DVBLoggingFormatter* value);
DVBLoggingLogLevel dvb_logging_handler_get_threshold (DVBLoggingHandler* self);
void dvb_logging_handler_set_threshold (DVBLoggingHandler* self, DVBLoggingLogLevel value);
GType dvb_logging_default_formatter_get_type (void) G_GNUC_CONST;
enum  {
	DVB_LOGGING_DEFAULT_FORMATTER_DUMMY_PROPERTY
};
gchar* dvb_logging_default_formatter_get_level_name (DVBLoggingDefaultFormatter* self, DVBLoggingLogLevel level);
static gchar* dvb_logging_default_formatter_real_get_level_name (DVBLoggingDefaultFormatter* self, DVBLoggingLogLevel level);
gchar* dvb_logging_default_formatter_format (DVBLoggingDefaultFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
static gchar* dvb_logging_default_formatter_real_format (DVBLoggingDefaultFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
DVBLoggingDefaultFormatter* dvb_logging_default_formatter_new (void);
DVBLoggingDefaultFormatter* dvb_logging_default_formatter_construct (GType object_type);
GType dvb_logging_color_formatter_get_type (void) G_GNUC_CONST;
enum  {
	DVB_LOGGING_COLOR_FORMATTER_DUMMY_PROPERTY
};
#define DVB_LOGGING_COLOR_FORMATTER_clear "\033[00m"
static gchar* dvb_logging_color_formatter_real_get_level_name (DVBLoggingDefaultFormatter* base, DVBLoggingLogLevel level);
static gchar* dvb_logging_color_formatter_real_format (DVBLoggingDefaultFormatter* base, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
DVBLoggingColorFormatter* dvb_logging_color_formatter_new (void);
DVBLoggingColorFormatter* dvb_logging_color_formatter_construct (GType object_type);
static void dvb_logging_color_formatter_finalize (GObject* obj);
GType dvb_logging_console_handler_get_type (void) G_GNUC_CONST;
#define DVB_LOGGING_CONSOLE_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandlerPrivate))
enum  {
	DVB_LOGGING_CONSOLE_HANDLER_DUMMY_PROPERTY,
	DVB_LOGGING_CONSOLE_HANDLER_FORMATTER,
	DVB_LOGGING_CONSOLE_HANDLER_THRESHOLD
};
static void dvb_logging_console_handler_real_publish (DVBLoggingHandler* base, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args);
static void dvb_logging_console_handler_real_close (DVBLoggingHandler* base);
DVBLoggingConsoleHandler* dvb_logging_console_handler_new (void);
DVBLoggingConsoleHandler* dvb_logging_console_handler_construct (GType object_type);
static void dvb_logging_console_handler_finalize (GObject* obj);
static void _vala_dvb_logging_console_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_logging_console_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dvb_logging_file_handler_get_type (void) G_GNUC_CONST;
#define DVB_LOGGING_FILE_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandlerPrivate))
enum  {
	DVB_LOGGING_FILE_HANDLER_DUMMY_PROPERTY,
	DVB_LOGGING_FILE_HANDLER_FORMATTER,
	DVB_LOGGING_FILE_HANDLER_THRESHOLD,
	DVB_LOGGING_FILE_HANDLER_LIMIT,
	DVB_LOGGING_FILE_HANDLER_COUNT,
	DVB_LOGGING_FILE_HANDLER_PATTERN
};
DVBLoggingFileHandler* dvb_logging_file_handler_new (const gchar* file_pattern, GError** error);
DVBLoggingFileHandler* dvb_logging_file_handler_construct (GType object_type, const gchar* file_pattern, GError** error);
static void dvb_logging_file_handler_rotate (DVBLoggingFileHandler* self, GError** error);
static void dvb_logging_file_handler_real_publish (DVBLoggingHandler* base, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args);
gint dvb_logging_file_handler_get_limit (DVBLoggingFileHandler* self);
static void dvb_logging_file_handler_real_close (DVBLoggingHandler* base);
static GFile* dvb_logging_file_handler_get_next_file (DVBLoggingFileHandler* self);
gint dvb_logging_file_handler_get_count (DVBLoggingFileHandler* self);
const gchar* dvb_logging_file_handler_get_pattern (DVBLoggingFileHandler* self);
void dvb_logging_file_handler_set_limit (DVBLoggingFileHandler* self, gint value);
void dvb_logging_file_handler_set_count (DVBLoggingFileHandler* self, gint value);
static void dvb_logging_file_handler_set_pattern (DVBLoggingFileHandler* self, const gchar* value);
static void dvb_logging_file_handler_finalize (GObject* obj);
static void _vala_dvb_logging_file_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_logging_file_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
#define DVB_LOGGING_LOGGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerPrivate))
enum  {
	DVB_LOGGING_LOGGER_DUMMY_PROPERTY,
	DVB_LOGGING_LOGGER_NAME
};
void dvb_logging_logger_addHandler (DVBLoggingLogger* self, DVBLoggingHandler* handler);
void dvb_logging_logger_removeHandler (DVBLoggingLogger* self, DVBLoggingHandler* handler);
GeeHashSet* dvb_logging_logger_getHandlers (DVBLoggingLogger* self);
static inline void dvb_logging_logger_log_full (DVBLoggingLogger* self, DVBLoggingLogLevel level, const gchar* format, va_list args);
const gchar* dvb_logging_logger_get_name (DVBLoggingLogger* self);
void dvb_logging_logger_log (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
DVBLoggingLogger* dvb_logging_logger_new (void);
DVBLoggingLogger* dvb_logging_logger_construct (GType object_type);
void dvb_logging_logger_set_name (DVBLoggingLogger* self, const gchar* value);
static GObject * dvb_logging_logger_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_logging_logger_finalize (GObject* obj);
static void _vala_dvb_logging_logger_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_logging_logger_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
#define DVB_LOGGING_LOG_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerPrivate))
enum  {
	DVB_LOGGING_LOG_MANAGER_DUMMY_PROPERTY
};
#define DVB_LOGGING_LOG_MANAGER_DEFAULT_NAME "default"
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogManager* dvb_logging_log_manager_new (void);
DVBLoggingLogManager* dvb_logging_log_manager_construct (GType object_type);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBLoggingLogger* dvb_logging_log_manager_getLogger (DVBLoggingLogManager* self, const gchar* name);
static DVBLoggingLogger* dvb_logging_log_manager_createLogger (DVBLoggingLogManager* self, const gchar* name);
void dvb_logging_log_manager_cleanup (DVBLoggingLogManager* self);
static GObject * dvb_logging_log_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_logging_log_manager_finalize (GObject* obj);


GType dvb_logging_log_level_get_type (void) {
	static volatile gsize dvb_logging_log_level_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_log_level_type_id__volatile)) {
		static const GEnumValue values[] = {{DVB_LOGGING_LOG_LEVEL_LOG, "DVB_LOGGING_LOG_LEVEL_LOG", "log"}, {DVB_LOGGING_LOG_LEVEL_DEBUG, "DVB_LOGGING_LOG_LEVEL_DEBUG", "debug"}, {DVB_LOGGING_LOG_LEVEL_INFO, "DVB_LOGGING_LOG_LEVEL_INFO", "info"}, {DVB_LOGGING_LOG_LEVEL_WARNING, "DVB_LOGGING_LOG_LEVEL_WARNING", "warning"}, {DVB_LOGGING_LOG_LEVEL_ERROR, "DVB_LOGGING_LOG_LEVEL_ERROR", "error"}, {0, NULL, NULL}};
		GType dvb_logging_log_level_type_id;
		dvb_logging_log_level_type_id = g_enum_register_static ("DVBLoggingLogLevel", values);
		g_once_init_leave (&dvb_logging_log_level_type_id__volatile, dvb_logging_log_level_type_id);
	}
	return dvb_logging_log_level_type_id__volatile;
}


gchar* dvb_logging_formatter_format (DVBLoggingFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_LOGGING_FORMATTER_GET_INTERFACE (self)->format (self, logger_name, level, format);
}


static void dvb_logging_formatter_base_init (DVBLoggingFormatterIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType dvb_logging_formatter_get_type (void) {
	static volatile gsize dvb_logging_formatter_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_formatter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingFormatterIface), (GBaseInitFunc) dvb_logging_formatter_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dvb_logging_formatter_type_id;
		dvb_logging_formatter_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBLoggingFormatter", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_logging_formatter_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&dvb_logging_formatter_type_id__volatile, dvb_logging_formatter_type_id);
	}
	return dvb_logging_formatter_type_id__volatile;
}


void dvb_logging_handler_publish (DVBLoggingHandler* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args) {
	g_return_if_fail (self != NULL);
	DVB_LOGGING_HANDLER_GET_INTERFACE (self)->publish (self, logger_name, level, format, args);
}


void dvb_logging_handler_close (DVBLoggingHandler* self) {
	g_return_if_fail (self != NULL);
	DVB_LOGGING_HANDLER_GET_INTERFACE (self)->close (self);
}


DVBLoggingFormatter* dvb_logging_handler_get_formatter (DVBLoggingHandler* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_LOGGING_HANDLER_GET_INTERFACE (self)->get_formatter (self);
}


void dvb_logging_handler_set_formatter (DVBLoggingHandler* self, DVBLoggingFormatter* value) {
	g_return_if_fail (self != NULL);
	DVB_LOGGING_HANDLER_GET_INTERFACE (self)->set_formatter (self, value);
}


DVBLoggingLogLevel dvb_logging_handler_get_threshold (DVBLoggingHandler* self) {
	g_return_val_if_fail (self != NULL, 0);
	return DVB_LOGGING_HANDLER_GET_INTERFACE (self)->get_threshold (self);
}


void dvb_logging_handler_set_threshold (DVBLoggingHandler* self, DVBLoggingLogLevel value) {
	g_return_if_fail (self != NULL);
	DVB_LOGGING_HANDLER_GET_INTERFACE (self)->set_threshold (self, value);
}


static void dvb_logging_handler_base_init (DVBLoggingHandlerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_object ("formatter", "formatter", "formatter", DVB_LOGGING_TYPE_FORMATTER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_enum ("threshold", "threshold", "threshold", DVB_LOGGING_TYPE_LOG_LEVEL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


GType dvb_logging_handler_get_type (void) {
	static volatile gsize dvb_logging_handler_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingHandlerIface), (GBaseInitFunc) dvb_logging_handler_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dvb_logging_handler_type_id;
		dvb_logging_handler_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBLoggingHandler", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_logging_handler_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&dvb_logging_handler_type_id__volatile, dvb_logging_handler_type_id);
	}
	return dvb_logging_handler_type_id__volatile;
}


static gchar* dvb_logging_default_formatter_real_get_level_name (DVBLoggingDefaultFormatter* self, DVBLoggingLogLevel level) {
	gchar* result = NULL;
	gchar* lvlstr;
	DVBLoggingLogLevel _tmp0_;
	lvlstr = NULL;
	_tmp0_ = level;
	switch (_tmp0_) {
		case DVB_LOGGING_LOG_LEVEL_LOG:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("LOG");
			_g_free0 (lvlstr);
			lvlstr = _tmp1_;
			break;
		}
		case DVB_LOGGING_LOG_LEVEL_DEBUG:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("DEBUG");
			_g_free0 (lvlstr);
			lvlstr = _tmp2_;
			break;
		}
		case DVB_LOGGING_LOG_LEVEL_INFO:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("INFO");
			_g_free0 (lvlstr);
			lvlstr = _tmp3_;
			break;
		}
		case DVB_LOGGING_LOG_LEVEL_WARNING:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("WARNING");
			_g_free0 (lvlstr);
			lvlstr = _tmp4_;
			break;
		}
		case DVB_LOGGING_LOG_LEVEL_ERROR:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("ERROR");
			_g_free0 (lvlstr);
			lvlstr = _tmp5_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	result = lvlstr;
	return result;
}


gchar* dvb_logging_default_formatter_get_level_name (DVBLoggingDefaultFormatter* self, DVBLoggingLogLevel level) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_LOGGING_DEFAULT_FORMATTER_GET_CLASS (self)->get_level_name (self, level);
}


static gchar* dvb_logging_default_formatter_real_format (DVBLoggingDefaultFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format) {
	gchar* result = NULL;
	DVBLoggingLogLevel _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* lvlstr;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* msg;
	g_return_val_if_fail (logger_name != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = level;
	_tmp1_ = dvb_logging_default_formatter_get_level_name (self, _tmp0_);
	lvlstr = _tmp1_;
	_tmp2_ = logger_name;
	_tmp3_ = format;
	_tmp4_ = g_strdup_printf ("%-12s %-12s %s\n", _tmp2_, lvlstr, _tmp3_);
	msg = _tmp4_;
	result = msg;
	_g_free0 (lvlstr);
	return result;
}


gchar* dvb_logging_default_formatter_format (DVBLoggingDefaultFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_LOGGING_DEFAULT_FORMATTER_GET_CLASS (self)->format (self, logger_name, level, format);
}


DVBLoggingDefaultFormatter* dvb_logging_default_formatter_construct (GType object_type) {
	DVBLoggingDefaultFormatter * self = NULL;
	self = (DVBLoggingDefaultFormatter*) g_object_new (object_type, NULL);
	return self;
}


DVBLoggingDefaultFormatter* dvb_logging_default_formatter_new (void) {
	return dvb_logging_default_formatter_construct (DVB_LOGGING_TYPE_DEFAULT_FORMATTER);
}


static void dvb_logging_default_formatter_class_init (DVBLoggingDefaultFormatterClass * klass) {
	dvb_logging_default_formatter_parent_class = g_type_class_peek_parent (klass);
	DVB_LOGGING_DEFAULT_FORMATTER_CLASS (klass)->get_level_name = dvb_logging_default_formatter_real_get_level_name;
	DVB_LOGGING_DEFAULT_FORMATTER_CLASS (klass)->format = dvb_logging_default_formatter_real_format;
}


static void dvb_logging_default_formatter_dvb_logging_formatter_interface_init (DVBLoggingFormatterIface * iface) {
	dvb_logging_default_formatter_dvb_logging_formatter_parent_iface = g_type_interface_peek_parent (iface);
	iface->format = (gchar* (*)(DVBLoggingFormatter*, const gchar*, DVBLoggingLogLevel, const gchar*)) dvb_logging_default_formatter_format;
}


static void dvb_logging_default_formatter_instance_init (DVBLoggingDefaultFormatter * self) {
}


GType dvb_logging_default_formatter_get_type (void) {
	static volatile gsize dvb_logging_default_formatter_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_default_formatter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingDefaultFormatterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_logging_default_formatter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBLoggingDefaultFormatter), 0, (GInstanceInitFunc) dvb_logging_default_formatter_instance_init, NULL };
		static const GInterfaceInfo dvb_logging_formatter_info = { (GInterfaceInitFunc) dvb_logging_default_formatter_dvb_logging_formatter_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_logging_default_formatter_type_id;
		dvb_logging_default_formatter_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBLoggingDefaultFormatter", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_logging_default_formatter_type_id, DVB_LOGGING_TYPE_FORMATTER, &dvb_logging_formatter_info);
		g_once_init_leave (&dvb_logging_default_formatter_type_id__volatile, dvb_logging_default_formatter_type_id);
	}
	return dvb_logging_default_formatter_type_id__volatile;
}


static gchar* dvb_logging_color_formatter_real_get_level_name (DVBLoggingDefaultFormatter* base, DVBLoggingLogLevel level) {
	DVBLoggingColorFormatter * self;
	gchar* result = NULL;
	DVBLoggingLogLevel _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* lvlstr;
	gchar** _tmp2_;
	gint _tmp2__length1;
	DVBLoggingLogLevel _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	self = (DVBLoggingColorFormatter*) base;
	_tmp0_ = level;
	_tmp1_ = DVB_LOGGING_DEFAULT_FORMATTER_CLASS (dvb_logging_color_formatter_parent_class)->get_level_name (DVB_LOGGING_DEFAULT_FORMATTER (self), _tmp0_);
	lvlstr = _tmp1_;
	_tmp2_ = dvb_logging_color_formatter_colormap;
	_tmp2__length1 = dvb_logging_color_formatter_colormap_length1;
	_tmp3_ = level;
	_tmp4_ = _tmp2_[_tmp3_];
	_tmp5_ = g_strdup_printf ("%s%s%s", _tmp4_, lvlstr, DVB_LOGGING_COLOR_FORMATTER_clear);
	result = _tmp5_;
	_g_free0 (lvlstr);
	return result;
}


static gchar* dvb_logging_color_formatter_real_format (DVBLoggingDefaultFormatter* base, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format) {
	DVBLoggingColorFormatter * self;
	gchar* result = NULL;
	DVBLoggingLogLevel _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* lvlstr;
	gchar* msg = NULL;
	DVBLoggingLogLevel _tmp2_;
	self = (DVBLoggingColorFormatter*) base;
	g_return_val_if_fail (logger_name != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = level;
	_tmp1_ = dvb_logging_default_formatter_get_level_name ((DVBLoggingDefaultFormatter*) self, _tmp0_);
	lvlstr = _tmp1_;
	_tmp2_ = level;
	if (_tmp2_ < DVB_LOGGING_LOG_LEVEL_INFO) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		_tmp3_ = logger_name;
		_tmp4_ = lvlstr;
		_tmp5_ = format;
		_tmp6_ = g_strdup_printf ("%-12s %-20s %s\n", _tmp3_, _tmp4_, _tmp5_);
		_g_free0 (msg);
		msg = _tmp6_;
	} else {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		_tmp7_ = logger_name;
		_tmp8_ = lvlstr;
		_tmp9_ = format;
		_tmp10_ = g_strdup_printf ("%-12s %-23s %s\n", _tmp7_, _tmp8_, _tmp9_);
		_g_free0 (msg);
		msg = _tmp10_;
	}
	result = msg;
	_g_free0 (lvlstr);
	return result;
}


DVBLoggingColorFormatter* dvb_logging_color_formatter_construct (GType object_type) {
	DVBLoggingColorFormatter * self = NULL;
	self = (DVBLoggingColorFormatter*) dvb_logging_default_formatter_construct (object_type);
	return self;
}


DVBLoggingColorFormatter* dvb_logging_color_formatter_new (void) {
	return dvb_logging_color_formatter_construct (DVB_LOGGING_TYPE_COLOR_FORMATTER);
}


static void dvb_logging_color_formatter_class_init (DVBLoggingColorFormatterClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	dvb_logging_color_formatter_parent_class = g_type_class_peek_parent (klass);
	DVB_LOGGING_DEFAULT_FORMATTER_CLASS (klass)->get_level_name = dvb_logging_color_formatter_real_get_level_name;
	DVB_LOGGING_DEFAULT_FORMATTER_CLASS (klass)->format = dvb_logging_color_formatter_real_format;
	G_OBJECT_CLASS (klass)->finalize = dvb_logging_color_formatter_finalize;
	_tmp0_ = g_strdup ("\033[37m");
	_tmp1_ = g_strdup ("\033[36m");
	_tmp2_ = g_strdup ("\033[32;01m");
	_tmp3_ = g_strdup ("\033[33;01m");
	_tmp4_ = g_strdup ("\033[31;01m");
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	dvb_logging_color_formatter_colormap = _tmp5_;
	dvb_logging_color_formatter_colormap_length1 = 5;
}


static void dvb_logging_color_formatter_instance_init (DVBLoggingColorFormatter * self) {
}


static void dvb_logging_color_formatter_finalize (GObject* obj) {
	DVBLoggingColorFormatter * self;
	self = DVB_LOGGING_COLOR_FORMATTER (obj);
	G_OBJECT_CLASS (dvb_logging_color_formatter_parent_class)->finalize (obj);
}


GType dvb_logging_color_formatter_get_type (void) {
	static volatile gsize dvb_logging_color_formatter_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_color_formatter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingColorFormatterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_logging_color_formatter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBLoggingColorFormatter), 0, (GInstanceInitFunc) dvb_logging_color_formatter_instance_init, NULL };
		GType dvb_logging_color_formatter_type_id;
		dvb_logging_color_formatter_type_id = g_type_register_static (DVB_LOGGING_TYPE_DEFAULT_FORMATTER, "DVBLoggingColorFormatter", &g_define_type_info, 0);
		g_once_init_leave (&dvb_logging_color_formatter_type_id__volatile, dvb_logging_color_formatter_type_id);
	}
	return dvb_logging_color_formatter_type_id__volatile;
}


static void dvb_logging_console_handler_real_publish (DVBLoggingHandler* base, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args) {
	DVBLoggingConsoleHandler * self;
	DVBLoggingLogLevel _tmp0_;
	DVBLoggingLogLevel _tmp1_;
	DVBLoggingLogLevel _tmp2_;
	DVBLoggingFormatter* _tmp3_;
	DVBLoggingFormatter* _tmp4_;
	const gchar* _tmp5_;
	DVBLoggingLogLevel _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* msg;
	DVBLoggingLogLevel _tmp9_;
	self = (DVBLoggingConsoleHandler*) base;
	g_return_if_fail (logger_name != NULL);
	g_return_if_fail (format != NULL);
	_tmp0_ = level;
	_tmp1_ = dvb_logging_handler_get_threshold ((DVBLoggingHandler*) self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ < _tmp2_) {
		return;
	}
	_tmp3_ = dvb_logging_handler_get_formatter ((DVBLoggingHandler*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = logger_name;
	_tmp6_ = level;
	_tmp7_ = format;
	_tmp8_ = dvb_logging_formatter_format (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
	msg = _tmp8_;
	_tmp9_ = level;
	if (_tmp9_ > DVB_LOGGING_LOG_LEVEL_INFO) {
		FILE* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = stderr;
		_tmp11_ = msg;
		vfprintf (_tmp10_, _tmp11_, args);
	} else {
		FILE* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = stdout;
		_tmp13_ = msg;
		vfprintf (_tmp12_, _tmp13_, args);
	}
	_g_free0 (msg);
}


static void dvb_logging_console_handler_real_close (DVBLoggingHandler* base) {
	DVBLoggingConsoleHandler * self;
	self = (DVBLoggingConsoleHandler*) base;
}


DVBLoggingConsoleHandler* dvb_logging_console_handler_construct (GType object_type) {
	DVBLoggingConsoleHandler * self = NULL;
	self = (DVBLoggingConsoleHandler*) g_object_new (object_type, NULL);
	return self;
}


DVBLoggingConsoleHandler* dvb_logging_console_handler_new (void) {
	return dvb_logging_console_handler_construct (DVB_LOGGING_TYPE_CONSOLE_HANDLER);
}


static DVBLoggingFormatter* dvb_logging_console_handler_real_get_formatter (DVBLoggingHandler* base) {
	DVBLoggingFormatter* result;
	DVBLoggingConsoleHandler* self;
	DVBLoggingFormatter* _tmp0_;
	self = (DVBLoggingConsoleHandler*) base;
	_tmp0_ = self->priv->_formatter;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_logging_console_handler_real_set_formatter (DVBLoggingHandler* base, DVBLoggingFormatter* value) {
	DVBLoggingConsoleHandler* self;
	DVBLoggingFormatter* _tmp0_;
	DVBLoggingFormatter* _tmp1_;
	self = (DVBLoggingConsoleHandler*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_formatter);
	self->priv->_formatter = _tmp1_;
	g_object_notify ((GObject *) self, "formatter");
}


static DVBLoggingLogLevel dvb_logging_console_handler_real_get_threshold (DVBLoggingHandler* base) {
	DVBLoggingLogLevel result;
	DVBLoggingConsoleHandler* self;
	DVBLoggingLogLevel _tmp0_;
	self = (DVBLoggingConsoleHandler*) base;
	_tmp0_ = self->priv->_threshold;
	result = _tmp0_;
	return result;
}


static void dvb_logging_console_handler_real_set_threshold (DVBLoggingHandler* base, DVBLoggingLogLevel value) {
	DVBLoggingConsoleHandler* self;
	DVBLoggingLogLevel _tmp0_;
	self = (DVBLoggingConsoleHandler*) base;
	_tmp0_ = value;
	self->priv->_threshold = _tmp0_;
	g_object_notify ((GObject *) self, "threshold");
}


static void dvb_logging_console_handler_class_init (DVBLoggingConsoleHandlerClass * klass) {
	dvb_logging_console_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBLoggingConsoleHandlerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_logging_console_handler_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_logging_console_handler_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_logging_console_handler_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_LOGGING_CONSOLE_HANDLER_FORMATTER, g_param_spec_object ("formatter", "formatter", "formatter", DVB_LOGGING_TYPE_FORMATTER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_LOGGING_CONSOLE_HANDLER_THRESHOLD, g_param_spec_enum ("threshold", "threshold", "threshold", DVB_LOGGING_TYPE_LOG_LEVEL, DVB_LOGGING_LOG_LEVEL_LOG, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_logging_console_handler_dvb_logging_handler_interface_init (DVBLoggingHandlerIface * iface) {
	dvb_logging_console_handler_dvb_logging_handler_parent_iface = g_type_interface_peek_parent (iface);
	iface->publish = (void (*)(DVBLoggingHandler*, const gchar*, DVBLoggingLogLevel, const gchar*, va_list)) dvb_logging_console_handler_real_publish;
	iface->close = (void (*)(DVBLoggingHandler*)) dvb_logging_console_handler_real_close;
	iface->get_formatter = dvb_logging_console_handler_real_get_formatter;
	iface->set_formatter = dvb_logging_console_handler_real_set_formatter;
	iface->get_threshold = dvb_logging_console_handler_real_get_threshold;
	iface->set_threshold = dvb_logging_console_handler_real_set_threshold;
}


static void dvb_logging_console_handler_instance_init (DVBLoggingConsoleHandler * self) {
	DVBLoggingDefaultFormatter* _tmp0_;
	self->priv = DVB_LOGGING_CONSOLE_HANDLER_GET_PRIVATE (self);
	_tmp0_ = dvb_logging_default_formatter_new ();
	self->priv->_formatter = (DVBLoggingFormatter*) _tmp0_;
	self->priv->_threshold = DVB_LOGGING_LOG_LEVEL_LOG;
}


static void dvb_logging_console_handler_finalize (GObject* obj) {
	DVBLoggingConsoleHandler * self;
	self = DVB_LOGGING_CONSOLE_HANDLER (obj);
	_g_object_unref0 (self->priv->_formatter);
	G_OBJECT_CLASS (dvb_logging_console_handler_parent_class)->finalize (obj);
}


GType dvb_logging_console_handler_get_type (void) {
	static volatile gsize dvb_logging_console_handler_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_console_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingConsoleHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_logging_console_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBLoggingConsoleHandler), 0, (GInstanceInitFunc) dvb_logging_console_handler_instance_init, NULL };
		static const GInterfaceInfo dvb_logging_handler_info = { (GInterfaceInitFunc) dvb_logging_console_handler_dvb_logging_handler_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_logging_console_handler_type_id;
		dvb_logging_console_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBLoggingConsoleHandler", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_logging_console_handler_type_id, DVB_LOGGING_TYPE_HANDLER, &dvb_logging_handler_info);
		g_once_init_leave (&dvb_logging_console_handler_type_id__volatile, dvb_logging_console_handler_type_id);
	}
	return dvb_logging_console_handler_type_id__volatile;
}


static void _vala_dvb_logging_console_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBLoggingConsoleHandler * self;
	self = DVB_LOGGING_CONSOLE_HANDLER (object);
	switch (property_id) {
		case DVB_LOGGING_CONSOLE_HANDLER_FORMATTER:
		g_value_set_object (value, dvb_logging_handler_get_formatter ((DVBLoggingHandler*) self));
		break;
		case DVB_LOGGING_CONSOLE_HANDLER_THRESHOLD:
		g_value_set_enum (value, dvb_logging_handler_get_threshold ((DVBLoggingHandler*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_logging_console_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBLoggingConsoleHandler * self;
	self = DVB_LOGGING_CONSOLE_HANDLER (object);
	switch (property_id) {
		case DVB_LOGGING_CONSOLE_HANDLER_FORMATTER:
		dvb_logging_handler_set_formatter ((DVBLoggingHandler*) self, g_value_get_object (value));
		break;
		case DVB_LOGGING_CONSOLE_HANDLER_THRESHOLD:
		dvb_logging_handler_set_threshold ((DVBLoggingHandler*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBLoggingFileHandler* dvb_logging_file_handler_construct (GType object_type, const gchar* file_pattern, GError** error) {
	DVBLoggingFileHandler * self = NULL;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file_pattern != NULL, NULL);
	_tmp0_ = file_pattern;
	self = (DVBLoggingFileHandler*) g_object_new (object_type, "pattern", _tmp0_, NULL);
	self->priv->file_index = 0;
	dvb_logging_file_handler_rotate (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


DVBLoggingFileHandler* dvb_logging_file_handler_new (const gchar* file_pattern, GError** error) {
	return dvb_logging_file_handler_construct (DVB_LOGGING_TYPE_FILE_HANDLER, file_pattern, error);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void dvb_logging_file_handler_real_publish (DVBLoggingHandler* base, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args) {
	DVBLoggingFileHandler * self;
	DVBLoggingLogLevel _tmp0_;
	DVBLoggingLogLevel _tmp1_;
	DVBLoggingLogLevel _tmp2_;
	DVBLoggingFormatter* _tmp3_;
	DVBLoggingFormatter* _tmp4_;
	const gchar* _tmp5_;
	DVBLoggingLogLevel _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* msg;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* txt;
	GError * _inner_error_ = NULL;
	self = (DVBLoggingFileHandler*) base;
	g_return_if_fail (logger_name != NULL);
	g_return_if_fail (format != NULL);
	_tmp0_ = level;
	_tmp1_ = dvb_logging_handler_get_threshold ((DVBLoggingHandler*) self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ < _tmp2_) {
		return;
	}
	_tmp3_ = dvb_logging_handler_get_formatter ((DVBLoggingHandler*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = logger_name;
	_tmp6_ = level;
	_tmp7_ = format;
	_tmp8_ = dvb_logging_formatter_format (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
	msg = _tmp8_;
	_tmp9_ = msg;
	_tmp10_ = g_strdup_vprintf (_tmp9_, args);
	txt = _tmp10_;
	{
		gint _tmp11_;
		GOutputStream* _tmp18_;
		const gchar* _tmp19_;
		guint8* _tmp20_;
		gint _tmp20__length1;
		guint8* _tmp21_;
		gint _tmp21__length1;
		_tmp11_ = self->priv->_limit;
		if (_tmp11_ > 0) {
			gint _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_tmp12_ = self->priv->file_size;
			_tmp13_ = txt;
			_tmp14_ = strlen (_tmp13_);
			_tmp15_ = _tmp14_;
			self->priv->file_size = _tmp12_ + _tmp15_;
			_tmp16_ = self->priv->file_size;
			_tmp17_ = self->priv->_limit;
			if (_tmp16_ > _tmp17_) {
				dvb_logging_file_handler_rotate (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch75_g_error;
				}
			}
		}
		_tmp18_ = self->priv->os;
		_tmp19_ = txt;
		_tmp20_ = string_get_data (_tmp19_, &_tmp20__length1);
		_tmp21_ = _tmp20_;
		_tmp21__length1 = _tmp20__length1;
		g_output_stream_write (_tmp18_, _tmp21_, (gsize) _tmp21__length1, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch75_g_error;
		}
	}
	goto __finally75;
	__catch75_g_error:
	{
		GError* e = NULL;
		FILE* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = stderr;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		fprintf (_tmp22_, "Error in FileHandler.publish: %s\n", _tmp24_);
		_g_error_free0 (e);
	}
	__finally75:
	if (_inner_error_ != NULL) {
		_g_free0 (txt);
		_g_free0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (txt);
	_g_free0 (msg);
}


static void dvb_logging_file_handler_real_close (DVBLoggingHandler* base) {
	DVBLoggingFileHandler * self;
	GError * _inner_error_ = NULL;
	self = (DVBLoggingFileHandler*) base;
	{
		GOutputStream* _tmp0_;
		_tmp0_ = self->priv->os;
		g_output_stream_close (_tmp0_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch76_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally76;
	__catch76_g_io_error:
	{
		GError* e = NULL;
		FILE* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "Error in FileHandler.close: %s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally76:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void dvb_logging_file_handler_rotate (DVBLoggingFileHandler* self, GError** error) {
	GOutputStream* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFileOutputStream* fos = NULL;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFileOutputStream* _tmp10_;
	GBufferedOutputStream* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->os;
	if (_tmp0_ != NULL) {
		dvb_logging_handler_close ((DVBLoggingHandler*) self);
	}
	_tmp1_ = dvb_logging_file_handler_get_next_file (self);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (_tmp3_) {
		GFile* _tmp4_;
		GFileOutputStream* _tmp5_ = NULL;
		GFileOutputStream* _tmp6_;
		_tmp4_ = file;
		_tmp5_ = g_file_replace (_tmp4_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (fos);
			_g_object_unref0 (file);
			return;
		}
		_g_object_unref0 (fos);
		fos = _tmp6_;
	} else {
		GFile* _tmp7_;
		GFileOutputStream* _tmp8_ = NULL;
		GFileOutputStream* _tmp9_;
		_tmp7_ = file;
		_tmp8_ = g_file_create (_tmp7_, G_FILE_CREATE_NONE, NULL, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (fos);
			_g_object_unref0 (file);
			return;
		}
		_g_object_unref0 (fos);
		fos = _tmp9_;
	}
	_tmp10_ = fos;
	_tmp11_ = (GBufferedOutputStream*) g_buffered_output_stream_new ((GOutputStream*) _tmp10_);
	_g_object_unref0 (self->priv->os);
	self->priv->os = (GOutputStream*) _tmp11_;
	self->priv->file_size = 0;
	_g_object_unref0 (fos);
	_g_object_unref0 (file);
}


static GFile* dvb_logging_file_handler_get_next_file (DVBLoggingFileHandler* self) {
	GFile* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* filename;
	GFile* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file_index;
	_tmp1_ = self->priv->_count;
	if (_tmp0_ == _tmp1_) {
		self->priv->file_index = 0;
	}
	_tmp2_ = self->priv->_pattern;
	_tmp3_ = self->priv->file_index;
	self->priv->file_index = _tmp3_ + 1;
	_tmp4_ = g_strdup_printf (_tmp2_, _tmp3_);
	filename = _tmp4_;
	_tmp5_ = g_file_new_for_path (filename);
	result = _tmp5_;
	_g_free0 (filename);
	return result;
}


static DVBLoggingFormatter* dvb_logging_file_handler_real_get_formatter (DVBLoggingHandler* base) {
	DVBLoggingFormatter* result;
	DVBLoggingFileHandler* self;
	DVBLoggingFormatter* _tmp0_;
	self = (DVBLoggingFileHandler*) base;
	_tmp0_ = self->priv->_formatter;
	result = _tmp0_;
	return result;
}


static void dvb_logging_file_handler_real_set_formatter (DVBLoggingHandler* base, DVBLoggingFormatter* value) {
	DVBLoggingFileHandler* self;
	DVBLoggingFormatter* _tmp0_;
	DVBLoggingFormatter* _tmp1_;
	self = (DVBLoggingFileHandler*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_formatter);
	self->priv->_formatter = _tmp1_;
	g_object_notify ((GObject *) self, "formatter");
}


static DVBLoggingLogLevel dvb_logging_file_handler_real_get_threshold (DVBLoggingHandler* base) {
	DVBLoggingLogLevel result;
	DVBLoggingFileHandler* self;
	DVBLoggingLogLevel _tmp0_;
	self = (DVBLoggingFileHandler*) base;
	_tmp0_ = self->priv->_threshold;
	result = _tmp0_;
	return result;
}


static void dvb_logging_file_handler_real_set_threshold (DVBLoggingHandler* base, DVBLoggingLogLevel value) {
	DVBLoggingFileHandler* self;
	DVBLoggingLogLevel _tmp0_;
	self = (DVBLoggingFileHandler*) base;
	_tmp0_ = value;
	self->priv->_threshold = _tmp0_;
	g_object_notify ((GObject *) self, "threshold");
}


gint dvb_logging_file_handler_get_limit (DVBLoggingFileHandler* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_limit;
	result = _tmp0_;
	return result;
}


void dvb_logging_file_handler_set_limit (DVBLoggingFileHandler* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_limit = _tmp0_;
	g_object_notify ((GObject *) self, "limit");
}


gint dvb_logging_file_handler_get_count (DVBLoggingFileHandler* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_count;
	result = _tmp0_;
	return result;
}


void dvb_logging_file_handler_set_count (DVBLoggingFileHandler* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_count = _tmp0_;
	g_object_notify ((GObject *) self, "count");
}


const gchar* dvb_logging_file_handler_get_pattern (DVBLoggingFileHandler* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pattern;
	result = _tmp0_;
	return result;
}


static void dvb_logging_file_handler_set_pattern (DVBLoggingFileHandler* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_pattern);
	self->priv->_pattern = _tmp1_;
	g_object_notify ((GObject *) self, "pattern");
}


static void dvb_logging_file_handler_class_init (DVBLoggingFileHandlerClass * klass) {
	dvb_logging_file_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBLoggingFileHandlerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_logging_file_handler_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_logging_file_handler_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_logging_file_handler_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_LOGGING_FILE_HANDLER_FORMATTER, g_param_spec_object ("formatter", "formatter", "formatter", DVB_LOGGING_TYPE_FORMATTER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_LOGGING_FILE_HANDLER_THRESHOLD, g_param_spec_enum ("threshold", "threshold", "threshold", DVB_LOGGING_TYPE_LOG_LEVEL, DVB_LOGGING_LOG_LEVEL_LOG, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_LOGGING_FILE_HANDLER_LIMIT, g_param_spec_int ("limit", "limit", "limit", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_LOGGING_FILE_HANDLER_COUNT, g_param_spec_int ("count", "count", "count", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_LOGGING_FILE_HANDLER_PATTERN, g_param_spec_string ("pattern", "pattern", "pattern", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_logging_file_handler_dvb_logging_handler_interface_init (DVBLoggingHandlerIface * iface) {
	dvb_logging_file_handler_dvb_logging_handler_parent_iface = g_type_interface_peek_parent (iface);
	iface->publish = (void (*)(DVBLoggingHandler*, const gchar*, DVBLoggingLogLevel, const gchar*, va_list)) dvb_logging_file_handler_real_publish;
	iface->close = (void (*)(DVBLoggingHandler*)) dvb_logging_file_handler_real_close;
	iface->get_formatter = dvb_logging_file_handler_real_get_formatter;
	iface->set_formatter = dvb_logging_file_handler_real_set_formatter;
	iface->get_threshold = dvb_logging_file_handler_real_get_threshold;
	iface->set_threshold = dvb_logging_file_handler_real_set_threshold;
}


static void dvb_logging_file_handler_instance_init (DVBLoggingFileHandler * self) {
	DVBLoggingDefaultFormatter* _tmp0_;
	self->priv = DVB_LOGGING_FILE_HANDLER_GET_PRIVATE (self);
	_tmp0_ = dvb_logging_default_formatter_new ();
	self->priv->_formatter = (DVBLoggingFormatter*) _tmp0_;
	self->priv->_threshold = DVB_LOGGING_LOG_LEVEL_LOG;
	self->priv->_limit = 0;
	self->priv->_count = 1;
}


static void dvb_logging_file_handler_finalize (GObject* obj) {
	DVBLoggingFileHandler * self;
	self = DVB_LOGGING_FILE_HANDLER (obj);
	_g_object_unref0 (self->priv->_formatter);
	_g_free0 (self->priv->_pattern);
	_g_object_unref0 (self->priv->os);
	G_OBJECT_CLASS (dvb_logging_file_handler_parent_class)->finalize (obj);
}


GType dvb_logging_file_handler_get_type (void) {
	static volatile gsize dvb_logging_file_handler_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_file_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingFileHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_logging_file_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBLoggingFileHandler), 0, (GInstanceInitFunc) dvb_logging_file_handler_instance_init, NULL };
		static const GInterfaceInfo dvb_logging_handler_info = { (GInterfaceInitFunc) dvb_logging_file_handler_dvb_logging_handler_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_logging_file_handler_type_id;
		dvb_logging_file_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBLoggingFileHandler", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_logging_file_handler_type_id, DVB_LOGGING_TYPE_HANDLER, &dvb_logging_handler_info);
		g_once_init_leave (&dvb_logging_file_handler_type_id__volatile, dvb_logging_file_handler_type_id);
	}
	return dvb_logging_file_handler_type_id__volatile;
}


static void _vala_dvb_logging_file_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBLoggingFileHandler * self;
	self = DVB_LOGGING_FILE_HANDLER (object);
	switch (property_id) {
		case DVB_LOGGING_FILE_HANDLER_FORMATTER:
		g_value_set_object (value, dvb_logging_handler_get_formatter ((DVBLoggingHandler*) self));
		break;
		case DVB_LOGGING_FILE_HANDLER_THRESHOLD:
		g_value_set_enum (value, dvb_logging_handler_get_threshold ((DVBLoggingHandler*) self));
		break;
		case DVB_LOGGING_FILE_HANDLER_LIMIT:
		g_value_set_int (value, dvb_logging_file_handler_get_limit (self));
		break;
		case DVB_LOGGING_FILE_HANDLER_COUNT:
		g_value_set_int (value, dvb_logging_file_handler_get_count (self));
		break;
		case DVB_LOGGING_FILE_HANDLER_PATTERN:
		g_value_set_string (value, dvb_logging_file_handler_get_pattern (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_logging_file_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBLoggingFileHandler * self;
	self = DVB_LOGGING_FILE_HANDLER (object);
	switch (property_id) {
		case DVB_LOGGING_FILE_HANDLER_FORMATTER:
		dvb_logging_handler_set_formatter ((DVBLoggingHandler*) self, g_value_get_object (value));
		break;
		case DVB_LOGGING_FILE_HANDLER_THRESHOLD:
		dvb_logging_handler_set_threshold ((DVBLoggingHandler*) self, g_value_get_enum (value));
		break;
		case DVB_LOGGING_FILE_HANDLER_LIMIT:
		dvb_logging_file_handler_set_limit (self, g_value_get_int (value));
		break;
		case DVB_LOGGING_FILE_HANDLER_COUNT:
		dvb_logging_file_handler_set_count (self, g_value_get_int (value));
		break;
		case DVB_LOGGING_FILE_HANDLER_PATTERN:
		dvb_logging_file_handler_set_pattern (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void dvb_logging_logger_addHandler (DVBLoggingLogger* self, DVBLoggingHandler* handler) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handler != NULL);
	{
		GeeHashSet* _tmp0_;
		_tmp0_ = self->priv->handlers;
		g_static_rec_mutex_lock (&self->priv->__lock_handlers);
		{
			GeeHashSet* _tmp1_;
			DVBLoggingHandler* _tmp2_;
			_tmp1_ = self->priv->handlers;
			_tmp2_ = handler;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp2_);
		}
		__finally77:
		{
			GeeHashSet* _tmp3_;
			_tmp3_ = self->priv->handlers;
			g_static_rec_mutex_unlock (&self->priv->__lock_handlers);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_logging_logger_removeHandler (DVBLoggingLogger* self, DVBLoggingHandler* handler) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handler != NULL);
	{
		GeeHashSet* _tmp0_;
		_tmp0_ = self->priv->handlers;
		g_static_rec_mutex_lock (&self->priv->__lock_handlers);
		{
			GeeHashSet* _tmp1_;
			DVBLoggingHandler* _tmp2_;
			_tmp1_ = self->priv->handlers;
			_tmp2_ = handler;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, _tmp2_);
		}
		__finally78:
		{
			GeeHashSet* _tmp3_;
			_tmp3_ = self->priv->handlers;
			g_static_rec_mutex_unlock (&self->priv->__lock_handlers);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


GeeHashSet* dvb_logging_logger_getHandlers (DVBLoggingLogger* self) {
	GeeHashSet* result = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->handlers;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static inline void dvb_logging_logger_log_full (DVBLoggingLogger* self, DVBLoggingLogLevel level, const gchar* format, va_list args) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	{
		GeeHashSet* _tmp0_;
		_tmp0_ = self->priv->handlers;
		g_static_rec_mutex_lock (&self->priv->__lock_handlers);
		{
			{
				GeeHashSet* _tmp1_;
				GeeIterator* _tmp2_ = NULL;
				GeeIterator* _handler_it;
				_tmp1_ = self->priv->handlers;
				_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp1_);
				_handler_it = _tmp2_;
				while (TRUE) {
					GeeIterator* _tmp3_;
					gboolean _tmp4_ = FALSE;
					GeeIterator* _tmp5_;
					gpointer _tmp6_ = NULL;
					DVBLoggingHandler* handler;
					va_list l = {0};
					DVBLoggingHandler* _tmp7_;
					const gchar* _tmp8_;
					DVBLoggingLogLevel _tmp9_;
					const gchar* _tmp10_;
					_tmp3_ = _handler_it;
					_tmp4_ = gee_iterator_next (_tmp3_);
					if (!_tmp4_) {
						break;
					}
					_tmp5_ = _handler_it;
					_tmp6_ = gee_iterator_get (_tmp5_);
					handler = (DVBLoggingHandler*) _tmp6_;
					va_copy (l, args);
					_tmp7_ = handler;
					_tmp8_ = self->priv->_name;
					_tmp9_ = level;
					_tmp10_ = format;
					dvb_logging_handler_publish (_tmp7_, _tmp8_, _tmp9_, _tmp10_, l);
					va_end (l);
					_g_object_unref0 (handler);
				}
				_g_object_unref0 (_handler_it);
			}
		}
		__finally79:
		{
			GeeHashSet* _tmp11_;
			_tmp11_ = self->priv->handlers;
			g_static_rec_mutex_unlock (&self->priv->__lock_handlers);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_logging_logger_log (DVBLoggingLogger* self, const gchar* format, ...) {
	va_list l = {0};
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	va_start (l, format);
	_tmp0_ = format;
	dvb_logging_logger_log_full (self, DVB_LOGGING_LOG_LEVEL_LOG, _tmp0_, l);
	va_end (l);
}


void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...) {
	va_list l = {0};
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	va_start (l, format);
	_tmp0_ = format;
	dvb_logging_logger_log_full (self, DVB_LOGGING_LOG_LEVEL_DEBUG, _tmp0_, l);
	va_end (l);
}


void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...) {
	va_list l = {0};
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	va_start (l, format);
	_tmp0_ = format;
	dvb_logging_logger_log_full (self, DVB_LOGGING_LOG_LEVEL_INFO, _tmp0_, l);
	va_end (l);
}


void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...) {
	va_list l = {0};
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	va_start (l, format);
	_tmp0_ = format;
	dvb_logging_logger_log_full (self, DVB_LOGGING_LOG_LEVEL_WARNING, _tmp0_, l);
	va_end (l);
}


void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...) {
	va_list l = {0};
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	va_start (l, format);
	_tmp0_ = format;
	dvb_logging_logger_log_full (self, DVB_LOGGING_LOG_LEVEL_ERROR, _tmp0_, l);
	va_end (l);
}


DVBLoggingLogger* dvb_logging_logger_construct (GType object_type) {
	DVBLoggingLogger * self = NULL;
	self = (DVBLoggingLogger*) g_object_new (object_type, NULL);
	return self;
}


DVBLoggingLogger* dvb_logging_logger_new (void) {
	return dvb_logging_logger_construct (DVB_LOGGING_TYPE_LOGGER);
}


const gchar* dvb_logging_logger_get_name (DVBLoggingLogger* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void dvb_logging_logger_set_name (DVBLoggingLogger* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


static GObject * dvb_logging_logger_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBLoggingLogger * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeHashSet* _tmp2_;
	parent_class = G_OBJECT_CLASS (dvb_logging_logger_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_LOGGING_LOGGER (obj);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = gee_hash_set_new (DVB_LOGGING_TYPE_HANDLER, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp0_, _tmp1_);
	_g_object_unref0 (self->priv->handlers);
	self->priv->handlers = _tmp2_;
	return obj;
}


static void dvb_logging_logger_class_init (DVBLoggingLoggerClass * klass) {
	dvb_logging_logger_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBLoggingLoggerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_logging_logger_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_logging_logger_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_logging_logger_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_logging_logger_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_LOGGING_LOGGER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_logging_logger_instance_init (DVBLoggingLogger * self) {
	self->priv = DVB_LOGGING_LOGGER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_handlers);
}


static void dvb_logging_logger_finalize (GObject* obj) {
	DVBLoggingLogger * self;
	self = DVB_LOGGING_LOGGER (obj);
	_g_free0 (self->priv->_name);
	g_static_rec_mutex_free (&self->priv->__lock_handlers);
	_g_object_unref0 (self->priv->handlers);
	G_OBJECT_CLASS (dvb_logging_logger_parent_class)->finalize (obj);
}


GType dvb_logging_logger_get_type (void) {
	static volatile gsize dvb_logging_logger_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_logging_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBLoggingLogger), 0, (GInstanceInitFunc) dvb_logging_logger_instance_init, NULL };
		GType dvb_logging_logger_type_id;
		dvb_logging_logger_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBLoggingLogger", &g_define_type_info, 0);
		g_once_init_leave (&dvb_logging_logger_type_id__volatile, dvb_logging_logger_type_id);
	}
	return dvb_logging_logger_type_id__volatile;
}


static void _vala_dvb_logging_logger_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBLoggingLogger * self;
	self = DVB_LOGGING_LOGGER (object);
	switch (property_id) {
		case DVB_LOGGING_LOGGER_NAME:
		g_value_set_string (value, dvb_logging_logger_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_logging_logger_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBLoggingLogger * self;
	self = DVB_LOGGING_LOGGER (object);
	switch (property_id) {
		case DVB_LOGGING_LOGGER_NAME:
		dvb_logging_logger_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void) {
	DVBLoggingLogManager* result = NULL;
	DVBLoggingLogManager* _tmp0_;
	DVBLoggingLogManager* _tmp2_;
	g_rec_mutex_lock (&dvb_logging_log_manager_instance_mutex);
	_tmp0_ = dvb_logging_log_manager_instance;
	if (_tmp0_ == NULL) {
		DVBLoggingLogManager* _tmp1_;
		_tmp1_ = dvb_logging_log_manager_new ();
		_g_object_unref0 (dvb_logging_log_manager_instance);
		dvb_logging_log_manager_instance = _tmp1_;
	}
	g_rec_mutex_unlock (&dvb_logging_log_manager_instance_mutex);
	_tmp2_ = dvb_logging_log_manager_instance;
	result = _tmp2_;
	return result;
}


DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self) {
	DVBLoggingLogger* result = NULL;
	DVBLoggingLogger* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_logging_log_manager_getLogger (self, DVB_LOGGING_LOG_MANAGER_DEFAULT_NAME);
	result = _tmp0_;
	return result;
}


DVBLoggingLogger* dvb_logging_log_manager_getLogger (DVBLoggingLogManager* self, const gchar* name) {
	DVBLoggingLogger* result = NULL;
	DVBLoggingLogger* l = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->loggers;
		g_static_rec_mutex_lock (&self->priv->__lock_loggers);
		{
			GeeHashMap* _tmp1_;
			const gchar* _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->loggers;
			_tmp2_ = name;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
			if (_tmp3_) {
				GeeHashMap* _tmp4_;
				const gchar* _tmp5_;
				gpointer _tmp6_ = NULL;
				_tmp4_ = self->priv->loggers;
				_tmp5_ = name;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
				_g_object_unref0 (l);
				l = (DVBLoggingLogger*) _tmp6_;
			} else {
				const gchar* _tmp7_;
				DVBLoggingLogger* _tmp8_ = NULL;
				_tmp7_ = name;
				_tmp8_ = dvb_logging_log_manager_createLogger (self, _tmp7_);
				_g_object_unref0 (l);
				l = _tmp8_;
			}
		}
		__finally80:
		{
			GeeHashMap* _tmp9_;
			_tmp9_ = self->priv->loggers;
			g_static_rec_mutex_unlock (&self->priv->__lock_loggers);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (l);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = l;
	return result;
}


static DVBLoggingLogger* dvb_logging_log_manager_createLogger (DVBLoggingLogManager* self, const gchar* name) {
	DVBLoggingLogger* result = NULL;
	DVBLoggingLogger* _tmp0_;
	DVBLoggingLogger* l;
	const gchar* _tmp1_;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = dvb_logging_logger_new ();
	l = _tmp0_;
	_tmp1_ = name;
	dvb_logging_logger_set_name (l, _tmp1_);
	_tmp2_ = self->priv->loggers;
	_tmp3_ = name;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, _tmp3_, l);
	result = l;
	return result;
}


void dvb_logging_log_manager_cleanup (DVBLoggingLogManager* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->loggers;
		g_static_rec_mutex_lock (&self->priv->__lock_loggers);
		{
			GeeHashMap* _tmp21_;
			{
				GeeHashMap* _tmp1_;
				GeeCollection* _tmp2_;
				GeeCollection* _tmp3_;
				GeeCollection* _tmp4_;
				GeeIterator* _tmp5_ = NULL;
				GeeIterator* _tmp6_;
				GeeIterator* _logger_it;
				_tmp1_ = self->priv->loggers;
				_tmp2_ = gee_abstract_map_get_values ((GeeMap*) _tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tmp3_;
				_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp4_);
				_logger_it = _tmp6_;
				while (TRUE) {
					GeeIterator* _tmp7_;
					gboolean _tmp8_ = FALSE;
					GeeIterator* _tmp9_;
					gpointer _tmp10_ = NULL;
					DVBLoggingLogger* logger;
					_tmp7_ = _logger_it;
					_tmp8_ = gee_iterator_next (_tmp7_);
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = _logger_it;
					_tmp10_ = gee_iterator_get (_tmp9_);
					logger = (DVBLoggingLogger*) _tmp10_;
					{
						DVBLoggingLogger* _tmp11_;
						GeeHashSet* _tmp12_ = NULL;
						GeeHashSet* _tmp13_;
						GeeIterator* _tmp14_ = NULL;
						GeeIterator* _tmp15_;
						GeeIterator* _handler_it;
						_tmp11_ = logger;
						_tmp12_ = dvb_logging_logger_getHandlers (_tmp11_);
						_tmp13_ = _tmp12_;
						_tmp14_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp13_);
						_tmp15_ = _tmp14_;
						_g_object_unref0 (_tmp13_);
						_handler_it = _tmp15_;
						while (TRUE) {
							GeeIterator* _tmp16_;
							gboolean _tmp17_ = FALSE;
							GeeIterator* _tmp18_;
							gpointer _tmp19_ = NULL;
							DVBLoggingHandler* handler;
							DVBLoggingHandler* _tmp20_;
							_tmp16_ = _handler_it;
							_tmp17_ = gee_iterator_next (_tmp16_);
							if (!_tmp17_) {
								break;
							}
							_tmp18_ = _handler_it;
							_tmp19_ = gee_iterator_get (_tmp18_);
							handler = (DVBLoggingHandler*) _tmp19_;
							_tmp20_ = handler;
							dvb_logging_handler_close (_tmp20_);
							_g_object_unref0 (handler);
						}
						_g_object_unref0 (_handler_it);
					}
					_g_object_unref0 (logger);
				}
				_g_object_unref0 (_logger_it);
			}
			_tmp21_ = self->priv->loggers;
			gee_abstract_map_clear ((GeeAbstractMap*) _tmp21_);
		}
		__finally81:
		{
			GeeHashMap* _tmp22_;
			_tmp22_ = self->priv->loggers;
			g_static_rec_mutex_unlock (&self->priv->__lock_loggers);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


DVBLoggingLogManager* dvb_logging_log_manager_construct (GType object_type) {
	DVBLoggingLogManager * self = NULL;
	self = (DVBLoggingLogManager*) g_object_new (object_type, NULL);
	return self;
}


DVBLoggingLogManager* dvb_logging_log_manager_new (void) {
	return dvb_logging_log_manager_construct (DVB_LOGGING_TYPE_LOG_MANAGER);
}


static GObject * dvb_logging_log_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBLoggingLogManager * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	GeeHashMap* _tmp3_;
	parent_class = G_OBJECT_CLASS (dvb_logging_log_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_LOGGING_LOG_MANAGER (obj);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, DVB_LOGGING_TYPE_LOGGER, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp0_, _tmp1_, _tmp2_);
	_g_object_unref0 (self->priv->loggers);
	self->priv->loggers = _tmp3_;
	return obj;
}


static void dvb_logging_log_manager_class_init (DVBLoggingLogManagerClass * klass) {
	GRecMutex _tmp0_ = {0};
	dvb_logging_log_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBLoggingLogManagerPrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_logging_log_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_logging_log_manager_finalize;
	g_rec_mutex_init (&_tmp0_);
	dvb_logging_log_manager_instance_mutex = _tmp0_;
}


static void dvb_logging_log_manager_instance_init (DVBLoggingLogManager * self) {
	self->priv = DVB_LOGGING_LOG_MANAGER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_loggers);
}


static void dvb_logging_log_manager_finalize (GObject* obj) {
	DVBLoggingLogManager * self;
	self = DVB_LOGGING_LOG_MANAGER (obj);
	g_static_rec_mutex_free (&self->priv->__lock_loggers);
	_g_object_unref0 (self->priv->loggers);
	G_OBJECT_CLASS (dvb_logging_log_manager_parent_class)->finalize (obj);
}


GType dvb_logging_log_manager_get_type (void) {
	static volatile gsize dvb_logging_log_manager_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_logging_log_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBLoggingLogManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_logging_log_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBLoggingLogManager), 0, (GInstanceInitFunc) dvb_logging_log_manager_instance_init, NULL };
		GType dvb_logging_log_manager_type_id;
		dvb_logging_log_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBLoggingLogManager", &g_define_type_info, 0);
		g_once_init_leave (&dvb_logging_log_manager_type_id__volatile, dvb_logging_log_manager_type_id);
	}
	return dvb_logging_log_manager_type_id__volatile;
}



