#if   !defined(__ACCOUNTPROXY_HPP)
#define __ACCOUNTPROXY_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__PROXY_HPP)
#include <Proxy.hpp>
#endif

#if   !defined(__ABSTRACTBANKACCOUNT_HPP)
#include <AbstractBankAccount.hpp>
#endif

DECLARE_CLASS( AccountProxy );

/**
AccountProxy is a read/write access proxy that enables
all of the methods for the underlying subject. It is
derived from AbstractBankAccount as well so that the
proxy can be used as a Account in the application.

Another option would have been to "realize" the
interface only, somewhat like a bridge, but this
would have meant the application is aware of the
Proxy type.
*/

class AccountProxy : public AbstractBankAccount, 
   public CORELINUX(Proxy)<AbstractBankAccount>
{
public:

   //
   // Constructors and destructor
   //
   
                        /// Default constructor
      
                        AccountProxy( void );
      
                        /// Initializing constructor
      
                        AccountProxy( AbstractBankAccountPtr );
      
                        /// Copy constructor
      
                        AccountProxy( AccountProxyCref );
      
                        /// Virtual Destructor
   
   virtual              ~AccountProxy( void );
   
   //
   // Operator overloads
   //
   
            /**
            Assignment operator
            @param AccountProxy const reference
            @return AccountProxy reference
            */
   
            AccountProxyRef   operator=( AccountProxyCref );
   
            /**
            Equality operator compares the
            subject pointers
            @param AccountProxy const reference
            @return bool if subjects match
            */
   
            bool  operator==( AccountProxyCref ) const;
   
   //
   // Accessors
   //
            /**
            Retrieve the account balance
            @return Amount const reference to balance
            */
   
   virtual  AmountCref getBalance(void) const;
   
   //
   // Mutators
   //
            /**
            Withdraw an amount of funds from the account
            @param Amount - amount to withdraw
            @exception InsufficientFundsException if the
            amount requested to withdraw is not available
            in the account funds
            */
   
   virtual  void withdrawFunds(Amount) 
                     throw(InsufficientFundsException);
   
            /**
            Deposit funds into the account
            @param Amount - to deposit
            */
   
   virtual  void depositFunds(Amount) 
                     throw(InsufficientFundsException);
      

};

#endif // if   !defined(__ACCOUNTPROXY_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/02/10 14:32:20 $
   $Locker:  $
*/


