/*
 * @(#)XmlReportGeneratorUTest.java
 *
 * Copyright (C) 2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.report;

import junit.framework.Test;
import junit.framework.TestCase;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.junit.v1.iftc.CxFactory;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestSuite;


/**
 * Tests the XmlReportGenerator class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:29 $
 * @since     January 22, 2003
 */
public class XmlReportGeneratorUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = XmlReportGeneratorUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public XmlReportGeneratorUTest( String name )
    {
        super( name );
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1()
    {
        new XmlReportGenerator();
    }
    
    
    public void testTranslate1()
    {
        assertEquals(
            "Does not translate null.",
            null,
            XmlReportGenerator.translate( null ) );
    }
    
    
    public void testTranslate2()
    {
        assertEquals(
            "Does not translate empty string.",
            "",
            XmlReportGenerator.translate( "" ) );
    }
    
    
    public void testTranslate3()
    {
        assertEquals(
            "Does not translate no parms.",
            "x",
            XmlReportGenerator.translate( "x" ) );
    }
    
    
    public void testTranslate4()
    {
        assertEquals(
            "Does not translate bad parms.",
            "x(",
            XmlReportGenerator.translate( "x(" ) );
    }
    
    
    public void testTranslate5()
    {
        assertEquals(
            "Does not translate only parms.",
            "(boolean)",
            XmlReportGenerator.translate( "(Z)" ) );
    }
    
    
    public void testTranslate6()
    {
        assertEquals(
            "Does not translate empty parms.",
            "x()",
            XmlReportGenerator.translate( "x()" ) );
    }
    
    
    public void testTranslate7()
    {
        assertEquals(
            "Does not translate object.",
            "x(me.my.Oh)",
            XmlReportGenerator.translate( "x(Lme/my/Oh;)" ) );
    }
    
    
    public void testTranslate8()
    {
        assertEquals(
            "Does not translate object.",
            "x(me.my.Oh, boolean)",
            XmlReportGenerator.translate( "x(Lme/my/Oh;Z)" ) );
    }
    
    
    public void testTranslate9()
    {
        assertEquals(
            "Does not strip return.",
            "x()",
            XmlReportGenerator.translate( "x()V" ) );
    }
    
    
    public void testTranslate10()
    {
        assertEquals(
            "Does not strip return.",
            "x(boolean)",
            XmlReportGenerator.translate( "x(Z)V" ) );
    }
    
    
    public void testTranslate11()
    {
        assertEquals(
            "Does not keep <init> as is.",
            "<init>",
            XmlReportGenerator.translate( "<init>" ) );
    }
    
    
    public void testTranslate12()
    {
        assertEquals(
            "Does not keep <init>( as is.",
            "<init>(",
            XmlReportGenerator.translate( "<init>(" ) );
    }
    
    
    public void testTranslate13()
    {
        assertEquals(
            "Does not translate <init>() right.",
            "[constructor]()",
            XmlReportGenerator.translate( "<init>()" ) );
    }
    
    
    public void testTranslate14()
    {
        assertEquals(
            "Does not translate <init>(ZZ) right.",
            "[constructor](boolean, boolean)",
            XmlReportGenerator.translate( "<init>(ZZ)" ) );
    }
    
    
    public void testTranslate15()
    {
        assertEquals(
            "Does not keep <clinit> as is.",
            "<clinit>",
            XmlReportGenerator.translate( "<clinit>" ) );
    }
    
    
    public void testTranslate16()
    {
        assertEquals(
            "Does not keep <clinit>( as is.",
            "<clinit>(",
            XmlReportGenerator.translate( "<clinit>(" ) );
    }
    
    
    public void testTranslate17()
    {
        assertEquals(
            "Does not translate <clinit>() right.",
            "[static initializer]",
            XmlReportGenerator.translate( "<clinit>()" ) );
    }
    
    
    public void testTranslate18()
    {
        assertEquals(
            "Does not translate <clinit>(Z) right.",
            "[static initializer]",
            XmlReportGenerator.translate( "<clinit>(Z)" ) );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = IReportGeneratorUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return new XmlReportGenerator();
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();

       
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

