/*
 *  @(#)DefaultParserCollator.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.itf.parser;

import net.sourceforge.groboutils.pmti.v1.itf.ITestIssueRecord;
import net.sourceforge.groboutils.pmti.v1.itf.ITestIssueRecordSet;
import net.sourceforge.groboutils.pmti.v1.itf.impl.DefaultTestIssueRecordSet;

import java.util.Vector;
import java.util.Enumeration;

/**
 * Logic to extract parser parsed test-issue records into logically separated
 * sets of records.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:01 $
 * @since      July 7, 2002
 */
public class DefaultParserCollator implements IParserCollator
{
    
    private Vector parsers = new Vector();
    private ITestIssueRecordSet parsed;
    
    /**
     * Adds a new parser to the internal collection.  It is up to the
     * individual collator to lazily parse the records or parse the records
     * at the time of this invocation.
     * <P>
     * It is illegal to invoke this method after a call to
     * <tt>getRecords()</tt>.
     *
     * @param p parser to add, which may be <tt>null</tt> (which should never
     *      cause an error).
     * @exception IllegalStateException thrown if this is called after the
     *      <tt>getRecords()</tt> method has been invoked.
     */
    public void addParser( IParser p )
    {
        if (this.parsers == null)
        {
            throw new IllegalStateException("already called getRecords()");
        }
        if (p != null)
        {
            this.parsers.addElement( p );
        }
    }
    
    
    /**
     * Returns the parsed test-issue records, divided into logically separated
     * collections.
     */
    public synchronized ITestIssueRecordSet getRecords()
    {
        if (this.parsers == null)
        {
            return this.parsed;
        }
        
        Vector records = new Vector();
        Enumeration enum = this.parsers.elements();
        this.parsers = null;
        while (enum.hasMoreElements())
        {
            ITestIssueRecord[] r = ((IParser)enum.nextElement()).parse();
            if (r != null)
            {
                for (int i = 0; i < r.length; ++i)
                {
                    if (r[i] != null)
                    {
                        records.addElement( r[i] );
                    }
                }
            }
        }
        
        
        ITestIssueRecord[] r = new ITestIssueRecord[ records.size() ];
        records.copyInto( r );
        this.parsed = new DefaultTestIssueRecordSet( r );
        return this.parsed;
    }
}

