/*
 * @(#)DefaultFocusedWindowFinder.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.uicapture.v1;

import java.awt.Rectangle;
import java.awt.Toolkit;


/**
 * Default implementation, which always returns <tt>null</tt>.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   Jan 7, 2002
 */
public class DefaultFocusedWindowFinder implements IFocusedWindowFinder
{
    
    /**
     * Default constructor.
     */
    public DefaultFocusedWindowFinder()
    {
        // do nothing
    }
    
    
    
    //-------------------------------------------------------------------------
    // Public methods
    
    
    
    /**
     * Find the current native UI focused window's bounds.
     * If the class cannot determine
     * the focused window, or there isn't a focused window, then the class
     * should return <tt>null</tt>, in which case the framework should default
     * to the screen size.
     *
     * @return the focused window's bounds, or <tt>null</tt> if it cannot be
     *		found.
     */
    public Rectangle getFocusedWindowBounds()
    {
        return null;
    }
}

