# How to contribute

We welcome code contributions to Plaso, whether they're bug fixes, new parsers,
plugins, output modules, core improvements or anything else! To make things as
easy, reliable and maintainable as possible, we have some specific resources
and procedures you should refer to.

## Bug reports

We're also keen to hear about bugs, crashes or hangs you might experience with
Plaso. Feel free to open a [GitHub issue](https://github.com/log2timeline/plaso/issues).
We'll almost certainly ask you how you installed Plaso, and for relevant debug output,
so save us all some time, and include that first up!

## Code Review

All code for Plaso goes through [code review](https://github.com/log2timeline/plaso/wiki/Codereview),
and conforms with the Plaso [style guide](https://github.com/log2timeline/plaso/wiki/Style-guide).
Please don't send a pull request without creating a code review issue first!

If you're adding a new feature or have some code fix a bug, please also open a
[GitHub issue](https://github.com/log2timeline/plaso/issues) so that we can
track progress, and discuss any broader ramifications.

## Getting started

* Make sure you have a [GitHub account](https://github.com/signup/free), then create your own Plaso fork
* Join the development [mailing list](log2timeline-dev@googlegroups.com)
* Read through the [developers guide](https://github.com/log2timeline/plaso/wiki/Developers-Guide) for detailed instructions and tips.
