% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crps.R
\name{crps}
\alias{crps}
\alias{scrps}
\alias{loo_crps}
\alias{loo_scrps}
\alias{crps.matrix}
\alias{crps.numeric}
\alias{loo_crps.matrix}
\alias{scrps.matrix}
\alias{scrps.numeric}
\alias{loo_scrps.matrix}
\title{Continuously ranked probability score}
\usage{
crps(x, ...)

scrps(x, ...)

loo_crps(x, ...)

loo_scrps(x, ...)

\method{crps}{matrix}(x, x2, y, ..., permutations = 1)

\method{crps}{numeric}(x, x2, y, ..., permutations = 1)

\method{loo_crps}{matrix}(
  x,
  x2,
  y,
  log_lik,
  ...,
  permutations = 1,
  r_eff = 1,
  cores = getOption("mc.cores", 1)
)

\method{scrps}{matrix}(x, x2, y, ..., permutations = 1)

\method{scrps}{numeric}(x, x2, y, ..., permutations = 1)

\method{loo_scrps}{matrix}(
  x,
  x2,
  y,
  log_lik,
  ...,
  permutations = 1,
  r_eff = 1,
  cores = getOption("mc.cores", 1)
)
}
\arguments{
\item{x}{A \code{S} by \code{N} matrix (draws by observations), or a vector of length
\code{S} when only single observation is provided in \code{y}.}

\item{...}{Passed on to \code{\link[=E_loo]{E_loo()}} in the \verb{loo_*()} version of these
functions.}

\item{x2}{Independent draws from the same distribution as draws in \code{x}.
Should be of the identical dimension.}

\item{y}{A vector of observations or a single value.}

\item{permutations}{An integer, with default value of 1,  specifying how many
times the expected value of  |X - X'| (\verb{|x - x2|}) is computed. The row
order of \code{x2} is shuffled as elements \code{x} and \code{x2} are typically drawn
given the same values of parameters. This happens, e.g., when one calls
\code{posterior_predict()} twice for a fitted \pkg{rstanarm} or \pkg{brms}
model. Generating more permutations is expected to decrease the variance of
the computed expected value.}

\item{log_lik}{A log-likelihood matrix the same size as \code{x}.}

\item{r_eff}{An optional vector of relative effective sample size estimates
containing one element per observation. See \code{\link[=psis]{psis()}} for details.}

\item{cores}{The number of cores to use for parallelization of \verb{[psis()]}.
See \code{\link[=psis]{psis()}} for details.}
}
\value{
A list containing two elements: \code{estimates} and \code{pointwise}.
The former reports estimator and standard error and latter the pointwise
values.
}
\description{
The \code{crps()} and \code{scrps()} functions and their \verb{loo_*()} counterparts can be
used to compute the continuously ranked probability score (CRPS) and scaled
CRPS (SCRPS) (see Bolin and Wallin, 2022). CRPS is a proper scoring rule, and
strictly proper when the first moment of the predictive distribution is
finite. Both can be expressed in terms of samples form the predictive
distribution. See e.g. Gneiting and Raftery (2007) for a comprehensive
discussion on CRPS.
}
\details{
To compute (S)CRPS, the user needs to provide two sets of draws, \code{x} and
\code{x2}, from the predictive distribution. This is due to the fact that formulas
used to compute CRPS involve an expectation of the absolute difference of \code{x}
and \code{x2}, both having the same distribution. See the \code{permutations} argument,
as well as Gneiting and Raftery (2007) for details.
}
\examples{
\dontrun{
# An example using rstanarm
library(rstanarm)
data("kidiq")
fit <- stan_glm(kid_score ~ mom_hs + mom_iq, data = kidiq)
ypred1 <- posterior_predict(fit)
ypred2 <- posterior_predict(fit)
crps(ypred1, ypred2, y = fit$y)
loo_crps(ypred1, ypred2, y = fit$y, log_lik = log_lik(fit))
}

}
\references{
Bolin, D., & Wallin, J. (2022). Local scale invariance and robustness of
proper scoring rules. arXiv. \doi{10.48550/arXiv.1912.05642}

Gneiting, T., & Raftery, A. E. (2007). Strictly Proper Scoring Rules,
Prediction, and Estimation. Journal of the American Statistical Association,
102(477), 359–378.
}
