% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_parameters.R
\name{format_parameters}
\alias{format_parameters}
\alias{format_parameters.default}
\title{Parameter names formatting}
\usage{
format_parameters(model, ...)

\method{format_parameters}{default}(model, brackets = c("[", "]"), ...)
}
\arguments{
\item{model}{A statistical model.}

\item{...}{Currently not used.}

\item{brackets}{A character vector of length two, indicating the opening and closing brackets.}
}
\value{
A (names) character vector with formatted parameter names. The value
names refer to the original names of the coefficients.
}
\description{
This functions formats the names of model parameters (coefficients)
to make them more human-readable.
}
\section{Interpretation of Interaction Terms}{

Note that the \emph{interpretation} of interaction terms depends on many
characteristics of the model. The number of parameters, and overall
performance of the model, can differ \emph{or not} between \code{a * b}
\code{a : b}, and \code{a / b}, suggesting that sometimes interaction terms
give different parameterizations of the same model, but other times it gives
completely different models (depending on \code{a} or \code{b} being factors
of covariates, included as main effects or not, etc.). Their interpretation
depends of the full context of the model, which should not be inferred
from the parameters table alone - rather, we recommend to use packages
that calculate estimated marginal means or marginal effects, such as
\CRANpkg{modelbased}, \CRANpkg{emmeans}, \CRANpkg{ggeffects}, or
\CRANpkg{marginaleffects}. To raise awareness for this issue, you may use
\code{print(...,show_formula=TRUE)} to add the model-specification to the output
of the \code{\link[=print.parameters_model]{print()}} method for \code{model_parameters()}.
}

\examples{
model <- lm(Sepal.Length ~ Species * Sepal.Width, data = iris)
format_parameters(model)

model <- lm(Sepal.Length ~ Petal.Length + (Species / Sepal.Width), data = iris)
format_parameters(model)

model <- lm(Sepal.Length ~ Species + poly(Sepal.Width, 2), data = iris)
format_parameters(model)

model <- lm(Sepal.Length ~ Species + poly(Sepal.Width, 2, raw = TRUE), data = iris)
format_parameters(model)
}
