% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permuteMeasEq.R
\docType{class}
\name{permuteMeasEq-class}
\alias{permuteMeasEq-class}
\alias{show,permuteMeasEq-method}
\alias{summary,permuteMeasEq-method}
\alias{hist,permuteMeasEq-method}
\title{Class for the Results of Permutation Randomization Tests of Measurement
Equivalence and DIF}
\usage{
\S4method{show}{permuteMeasEq}(object)

\S4method{summary}{permuteMeasEq}(object, alpha = 0.05, nd = 3,
  extra = FALSE)

\S4method{hist}{permuteMeasEq}(x, ..., AFI, alpha = 0.05, nd = 3,
  printLegend = TRUE, legendArgs = list(x = "topleft"))
}
\arguments{
\item{object, x}{object of class \code{permuteMeasEq}}

\item{alpha}{alpha level used to draw confidence limits in \code{hist} and
flag significant statistics in \code{summary} output}

\item{nd}{number of digits to display}

\item{extra}{\code{logical} indicating whether the \code{summary} output
should return permutation-based \emph{p} values for each statistic returned
by the \code{extra} function.  If \code{FALSE} (default), \code{summary}
will return permutation-based \emph{p} values for each modification index.}

\item{...}{Additional arguments to pass to \code{\link[graphics]{hist}}}

\item{AFI}{\code{character} indicating the fit measure whose permutation
distribution should be plotted}

\item{printLegend}{\code{logical}. If \code{TRUE} (default), a legend will
be printed with the histogram}

\item{legendArgs}{\code{list} of arguments passed to the
\code{\link[graphics]{legend}} function.  The default argument is a list
placing the legend at the top-left of the figure.}
}
\value{
\itemize{
\item The \code{show} method prints a summary of the multiparameter
  omnibus test results, using the user-specified AFIs. The parametric
 (\eqn{\Delta})\eqn{\chi^2} test is also displayed.
\item The \code{summary} method prints the same information from the
  \code{show} method, but when \code{extra = FALSE} (the default) it also
  provides a table summarizing any requested follow-up tests of DIF using
  modification indices in slot \code{MI.obs}. The user can also specify an
  \code{alpha} level for flagging modification indices as significant, as
  well as \code{nd} (the number of digits displayed). For each modification
  index, the \emph{p} value is displayed using a central \eqn{\chi^2}
  distribution with the \emph{df} shown in that column. Additionally, a
  \emph{p} value is displayed using the permutation distribution of the
  maximum index, which controls the familywise Type I error rate in a manner
  similar to Tukey's studentized range test. If any indices are flagged as
  significant using the \code{tukey.p.value}, then a message is displayed for
  each flagged index. The invisibly returned \code{data.frame} is the
  displayed table of modification indices, unless
  \code{\link[semTools]{permuteMeasEq}} was called with \code{param = NULL},
  in which case the invisibly returned object is \code{object}. If
  \code{extra = TRUE}, the permutation-based \emph{p} values for each
  statistic returned by the \code{extra} function are displayed and returned
  in a \code{data.frame} instead of the modification indices requested in the
  \code{param} argument.
\item The \code{hist} method returns a list of \code{length == 2},
   containing the arguments for the call to \code{hist} and the arguments
   to the call for \code{legend}, respectively. This list may facilitate
   creating a customized histogram of \code{AFI.dist}, \code{MI.dist}, or
   \code{extra.dist}
}
}
\description{
This class contains the results of tests of Measurement Equivalence and
Differential Item Functioning (DIF).
}
\section{Slots}{

\describe{
\item{\code{PT}}{A \code{data.frame} returned by a call to
\code{\link[lavaan]{parTable}} on the constrained model}

\item{\code{modelType}}{A character indicating the specified \code{modelType} in the
call to \code{permuteMeasEq}}

\item{\code{ANOVA}}{A \code{numeric} vector indicating the results of the observed
(\eqn{\Delta})\eqn{\chi^2} test, based on the central \eqn{\chi^2}
distribution}

\item{\code{AFI.obs}}{A vector of observed (changes in) user-selected fit measures}

\item{\code{AFI.dist}}{The permutation distribution(s) of user-selected fit measures.
A \code{data.frame} with \code{n.Permutations} rows and one column for each
\code{AFI.obs}.}

\item{\code{AFI.pval}}{A vector of \emph{p} values (one for each element in slot
\code{AFI.obs}) calculated using slot \code{AFI.dist}, indicating the
probability of observing a change at least as extreme as \code{AFI.obs}
if the null hypothesis were true}

\item{\code{MI.obs}}{A \code{data.frame} of observed Lagrange Multipliers
(modification indices) associated with the equality constraints or fixed
parameters specified in the \code{param} argument. This is a subset of the
output returned by a call to \code{\link[lavaan]{lavTestScore}} on the
constrained model.}

\item{\code{MI.dist}}{The permutation distribution of the maximum modification index
(among those seen in slot \code{MI.obs$X2}) at each permutation of group
assignment or of \code{covariates}}

\item{\code{extra.obs}}{If \code{permuteMeasEq} was called with an \code{extra}
function, the output when applied to the original data is concatenated
into this vector}

\item{\code{extra.dist}}{A \code{data.frame}, each column of which contains the
permutation distribution of the corresponding statistic in slot
\code{extra.obs}}

\item{\code{n.Permutations}}{An \code{integer} indicating the number of permutations
requested by the user}

\item{\code{n.Converged}}{An \code{integer} indicating the number of permuation
iterations which yielded a converged solution}

\item{\code{n.nonConverged}}{An \code{integer} vector of length
\code{n.Permutations} indicating how many times group assignment was
randomly permuted (at each iteration) before converging on a solution}

\item{\code{n.Sparse}}{Only relevant with \code{ordered} indicators when
\code{modelType == "mgcfa"}. An \code{integer} vector of length
\code{n.Permutations} indicating how many times group assignment was
randomly permuted (at each iteration) before obtaining a sample with all
categories observed in all groups.}

\item{\code{oldSeed}}{An \code{integer} vector storing the value of
\code{.Random.seed} before running \code{permuteMeasEq}. Only relevant
when using a parallel/multicore option and the original
\code{RNGkind() != "L'Ecuyer-CMRG"}. This enables users to restore their
previous \code{.Random.seed} state, if desired, by running:
\code{.Random.seed[-1] <- permutedResults@oldSeed[-1]}}
}}

\section{Objects from the Class}{
 Objects can be created via the
  \code{\link[semTools]{permuteMeasEq}} function.
}

\examples{

# See the example from the permuteMeasEq function

}
\seealso{
\code{\link[semTools]{permuteMeasEq}}
}
\author{
Terrence D. Jorgensen (University of Amsterdam;
  \email{TJorgensen314@gmail.com})
}
