# coding: binary
# Generated by generate-specs
require 'helper'

describe_moneta "cache_file_memory" do
  def features
    [:create, :increment]
  end

  def new_store
    Moneta.build do
      use(:Cache) do
        adapter { adapter :File, :dir => File.join(make_tempdir, "cache_file_memory") }
        cache { adapter :Memory }
      end
    end
  end

  def load_value(value)
    Marshal.load(value)
  end

  include_context 'setup_store'
  it_should_behave_like 'concurrent_create'
  it_should_behave_like 'concurrent_increment'
  it_should_behave_like 'create'
  it_should_behave_like 'features'
  it_should_behave_like 'increment'
  it_should_behave_like 'multiprocess'
  it_should_behave_like 'null_stringkey_stringvalue'
  it_should_behave_like 'null_pathkey_stringvalue'
  it_should_behave_like 'persist_stringkey_stringvalue'
  it_should_behave_like 'persist_pathkey_stringvalue'
  it_should_behave_like 'returnsame_stringkey_stringvalue'
  it_should_behave_like 'returnsame_pathkey_stringvalue'
  it_should_behave_like 'store_stringkey_stringvalue'
  it_should_behave_like 'store_pathkey_stringvalue'
  it_should_behave_like 'store_large'
  it 'stores loaded values in cache' do
    store.adapter['foo'] = 'bar'
    store.cache['foo'].should be_nil
    store['foo'].should == 'bar'
    store.cache['foo'].should == 'bar'
    store.adapter.delete('foo')
    store['foo'].should == 'bar'
    store.delete('foo')
    store['foo'].should be_nil
  end

end
