# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceRateCardInfo(Model):
    """Price and Metadata information for resources.

    :param currency: The currency in which the rates are provided.
    :type currency: str
    :param locale: The culture in which the resource information is localized.
    :type locale: str
    :param is_tax_included: All rates are pretax, so this will always be
     returned as 'false'.
    :type is_tax_included: bool
    :param offer_terms: A list of offer terms.
    :type offer_terms: list of :class:`OfferTermInfo
     <azure.mgmt.commerce.models.OfferTermInfo>`
    :param meters: A list of meters.
    :type meters: list of :class:`MeterInfo
     <azure.mgmt.commerce.models.MeterInfo>`
    """

    _attribute_map = {
        'currency': {'key': 'Currency', 'type': 'str'},
        'locale': {'key': 'Locale', 'type': 'str'},
        'is_tax_included': {'key': 'IsTaxIncluded', 'type': 'bool'},
        'offer_terms': {'key': 'OfferTerms', 'type': '[OfferTermInfo]'},
        'meters': {'key': 'Meters', 'type': '[MeterInfo]'},
    }

    def __init__(self, currency=None, locale=None, is_tax_included=None, offer_terms=None, meters=None):
        self.currency = currency
        self.locale = locale
        self.is_tax_included = is_tax_included
        self.offer_terms = offer_terms
        self.meters = meters
