# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CertificateInformation(Model):
    """SSL certificate information.

    All required parameters must be populated in order to send to Azure.

    :param expiry: Required. Expiration date of the certificate. The date
     conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by
     the ISO 8601 standard.
    :type expiry: datetime
    :param thumbprint: Required. Thumbprint of the certificate.
    :type thumbprint: str
    :param subject: Required. Subject of the certificate.
    :type subject: str
    """

    _validation = {
        'expiry': {'required': True},
        'thumbprint': {'required': True},
        'subject': {'required': True},
    }

    _attribute_map = {
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
    }

    def __init__(self, *, expiry, thumbprint: str, subject: str, **kwargs) -> None:
        super(CertificateInformation, self).__init__(**kwargs)
        self.expiry = expiry
        self.thumbprint = thumbprint
        self.subject = subject
