# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationInsightsComponentAPIKey(Model):
    """Properties that define an API key of an Application Insights Component.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique ID of the API key inside an Application Insights
     component. It is auto generated when the API key is created.
    :vartype id: str
    :ivar api_key: The API key value. It will be only return once when the API
     Key was created.
    :vartype api_key: str
    :param created_date: The create date of this API key.
    :type created_date: str
    :param name: The name of the API key.
    :type name: str
    :param linked_read_properties: The read access rights of this API Key.
    :type linked_read_properties: list[str]
    :param linked_write_properties: The write access rights of this API Key.
    :type linked_write_properties: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'api_key': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'api_key': {'key': 'apiKey', 'type': 'str'},
        'created_date': {'key': 'createdDate', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'linked_read_properties': {'key': 'linkedReadProperties', 'type': '[str]'},
        'linked_write_properties': {'key': 'linkedWriteProperties', 'type': '[str]'},
    }

    def __init__(self, *, created_date: str=None, name: str=None, linked_read_properties=None, linked_write_properties=None, **kwargs) -> None:
        super(ApplicationInsightsComponentAPIKey, self).__init__(**kwargs)
        self.id = None
        self.api_key = None
        self.created_date = created_date
        self.name = name
        self.linked_read_properties = linked_read_properties
        self.linked_write_properties = linked_write_properties
