# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationInsightsComponentDataVolumeCap(Model):
    """An Application Insights component daily data volume cap.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param cap: Daily data volume cap in GB.
    :type cap: float
    :ivar reset_time: Daily data volume cap UTC reset hour.
    :vartype reset_time: int
    :param warning_threshold: Reserved, not used for now.
    :type warning_threshold: int
    :param stop_send_notification_when_hit_threshold: Reserved, not used for
     now.
    :type stop_send_notification_when_hit_threshold: bool
    :param stop_send_notification_when_hit_cap: Do not send a notification
     email when the daily data volume cap is met.
    :type stop_send_notification_when_hit_cap: bool
    :ivar max_history_cap: Maximum daily data volume cap that the user can set
     for this component.
    :vartype max_history_cap: float
    """

    _validation = {
        'reset_time': {'readonly': True},
        'max_history_cap': {'readonly': True},
    }

    _attribute_map = {
        'cap': {'key': 'Cap', 'type': 'float'},
        'reset_time': {'key': 'ResetTime', 'type': 'int'},
        'warning_threshold': {'key': 'WarningThreshold', 'type': 'int'},
        'stop_send_notification_when_hit_threshold': {'key': 'StopSendNotificationWhenHitThreshold', 'type': 'bool'},
        'stop_send_notification_when_hit_cap': {'key': 'StopSendNotificationWhenHitCap', 'type': 'bool'},
        'max_history_cap': {'key': 'MaxHistoryCap', 'type': 'float'},
    }

    def __init__(self, *, cap: float=None, warning_threshold: int=None, stop_send_notification_when_hit_threshold: bool=None, stop_send_notification_when_hit_cap: bool=None, **kwargs) -> None:
        super(ApplicationInsightsComponentDataVolumeCap, self).__init__(**kwargs)
        self.cap = cap
        self.reset_time = None
        self.warning_threshold = warning_threshold
        self.stop_send_notification_when_hit_threshold = stop_send_notification_when_hit_threshold
        self.stop_send_notification_when_hit_cap = stop_send_notification_when_hit_cap
        self.max_history_cap = None
