# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class SubResource(Model):
    """Reference to another subresource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(SubResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AgentPool(SubResource):
    """Agent Pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param count: Number of agents (VMs) to host docker containers. Allowed
     values must be in the range of 1 to 100 (inclusive). The default value is
     1.
    :type count: int
    :param vm_size: Size of agent VMs. Possible values include: 'Standard_A1',
     'Standard_A10', 'Standard_A11', 'Standard_A1_v2', 'Standard_A2',
     'Standard_A2_v2', 'Standard_A2m_v2', 'Standard_A3', 'Standard_A4',
     'Standard_A4_v2', 'Standard_A4m_v2', 'Standard_A5', 'Standard_A6',
     'Standard_A7', 'Standard_A8', 'Standard_A8_v2', 'Standard_A8m_v2',
     'Standard_A9', 'Standard_B2ms', 'Standard_B2s', 'Standard_B4ms',
     'Standard_B8ms', 'Standard_D1', 'Standard_D11', 'Standard_D11_v2',
     'Standard_D11_v2_Promo', 'Standard_D12', 'Standard_D12_v2',
     'Standard_D12_v2_Promo', 'Standard_D13', 'Standard_D13_v2',
     'Standard_D13_v2_Promo', 'Standard_D14', 'Standard_D14_v2',
     'Standard_D14_v2_Promo', 'Standard_D15_v2', 'Standard_D16_v3',
     'Standard_D16s_v3', 'Standard_D1_v2', 'Standard_D2', 'Standard_D2_v2',
     'Standard_D2_v2_Promo', 'Standard_D2_v3', 'Standard_D2s_v3',
     'Standard_D3', 'Standard_D32_v3', 'Standard_D32s_v3', 'Standard_D3_v2',
     'Standard_D3_v2_Promo', 'Standard_D4', 'Standard_D4_v2',
     'Standard_D4_v2_Promo', 'Standard_D4_v3', 'Standard_D4s_v3',
     'Standard_D5_v2', 'Standard_D5_v2_Promo', 'Standard_D64_v3',
     'Standard_D64s_v3', 'Standard_D8_v3', 'Standard_D8s_v3', 'Standard_DS1',
     'Standard_DS11', 'Standard_DS11_v2', 'Standard_DS11_v2_Promo',
     'Standard_DS12', 'Standard_DS12_v2', 'Standard_DS12_v2_Promo',
     'Standard_DS13', 'Standard_DS13-2_v2', 'Standard_DS13-4_v2',
     'Standard_DS13_v2', 'Standard_DS13_v2_Promo', 'Standard_DS14',
     'Standard_DS14-4_v2', 'Standard_DS14-8_v2', 'Standard_DS14_v2',
     'Standard_DS14_v2_Promo', 'Standard_DS15_v2', 'Standard_DS1_v2',
     'Standard_DS2', 'Standard_DS2_v2', 'Standard_DS2_v2_Promo',
     'Standard_DS3', 'Standard_DS3_v2', 'Standard_DS3_v2_Promo',
     'Standard_DS4', 'Standard_DS4_v2', 'Standard_DS4_v2_Promo',
     'Standard_DS5_v2', 'Standard_DS5_v2_Promo', 'Standard_E16_v3',
     'Standard_E16s_v3', 'Standard_E2_v3', 'Standard_E2s_v3',
     'Standard_E32-16s_v3', 'Standard_E32-8s_v3', 'Standard_E32_v3',
     'Standard_E32s_v3', 'Standard_E4_v3', 'Standard_E4s_v3',
     'Standard_E64-16s_v3', 'Standard_E64-32s_v3', 'Standard_E64_v3',
     'Standard_E64s_v3', 'Standard_E8_v3', 'Standard_E8s_v3', 'Standard_F1',
     'Standard_F16', 'Standard_F16s', 'Standard_F16s_v2', 'Standard_F1s',
     'Standard_F2', 'Standard_F2s', 'Standard_F2s_v2', 'Standard_F32s_v2',
     'Standard_F4', 'Standard_F4s', 'Standard_F4s_v2', 'Standard_F64s_v2',
     'Standard_F72s_v2', 'Standard_F8', 'Standard_F8s', 'Standard_F8s_v2',
     'Standard_G1', 'Standard_G2', 'Standard_G3', 'Standard_G4', 'Standard_G5',
     'Standard_GS1', 'Standard_GS2', 'Standard_GS3', 'Standard_GS4',
     'Standard_GS4-4', 'Standard_GS4-8', 'Standard_GS5', 'Standard_GS5-16',
     'Standard_GS5-8', 'Standard_H16', 'Standard_H16m', 'Standard_H16mr',
     'Standard_H16r', 'Standard_H8', 'Standard_H8m', 'Standard_L16s',
     'Standard_L32s', 'Standard_L4s', 'Standard_L8s', 'Standard_M128-32ms',
     'Standard_M128-64ms', 'Standard_M128ms', 'Standard_M128s',
     'Standard_M64-16ms', 'Standard_M64-32ms', 'Standard_M64ms',
     'Standard_M64s', 'Standard_NC12', 'Standard_NC12s_v2',
     'Standard_NC12s_v3', 'Standard_NC24', 'Standard_NC24r',
     'Standard_NC24rs_v2', 'Standard_NC24rs_v3', 'Standard_NC24s_v2',
     'Standard_NC24s_v3', 'Standard_NC6', 'Standard_NC6s_v2',
     'Standard_NC6s_v3', 'Standard_ND12s', 'Standard_ND24rs', 'Standard_ND24s',
     'Standard_ND6s', 'Standard_NV12', 'Standard_NV24', 'Standard_NV6'
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk
     size for every machine in this master/agent pool. If you specify 0, it
     will apply the default osDisk size according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet
     identifier.
    :type vnet_subnet_id: str
    :param max_pods: Maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: OsType to be used to specify os type. Choose from Linux
     and Windows. Default to Linux. Possible values include: 'Linux',
     'Windows'. Default value: "Linux" .
    :type os_type: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.OSType
    :param max_count: Maximum number of nodes for auto-scaling
    :type max_count: int
    :param min_count: Minimum number of nodes for auto-scaling
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler
    :type enable_auto_scaling: bool
    :param agent_pool_type: AgentPoolType represents types of an agent pool.
     Possible values include: 'VirtualMachineScaleSets', 'AvailabilitySet'
    :type agent_pool_type: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.AgentPoolType
    :param orchestrator_version: Version of orchestrator specified when
     creating the managed cluster.
    :type orchestrator_version: str
    :ivar provisioning_state: The current deployment or provisioning state,
     which only appears in the response.
    :vartype provisioning_state: str
    :param availability_zones: (PREVIEW) Availability zones for nodes. Must
     use VirtualMachineScaleSets AgentPoolType.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Enable public IP for nodes
    :type enable_node_public_ip: bool
    :param scale_set_priority: ScaleSetPriority to be used to specify virtual
     machine scale set priority. Default to regular. Possible values include:
     'Low', 'Regular'. Default value: "Regular" .
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to
     specify eviction policy for low priority virtual machine scale set.
     Default to Delete. Possible values include: 'Delete', 'Deallocate'.
     Default value: "Delete" .
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.ScaleSetEvictionPolicy
    :param node_taints: Taints added to new nodes during node pool create and
     scale. For example, key=value:NoSchedule.
    :type node_taints: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'count': {'key': 'properties.count', 'type': 'int'},
        'vm_size': {'key': 'properties.vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'properties.osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'properties.vnetSubnetID', 'type': 'str'},
        'max_pods': {'key': 'properties.maxPods', 'type': 'int'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'max_count': {'key': 'properties.maxCount', 'type': 'int'},
        'min_count': {'key': 'properties.minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'properties.enableAutoScaling', 'type': 'bool'},
        'agent_pool_type': {'key': 'properties.type', 'type': 'str'},
        'orchestrator_version': {'key': 'properties.orchestratorVersion', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'availability_zones': {'key': 'properties.availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'properties.enableNodePublicIP', 'type': 'bool'},
        'scale_set_priority': {'key': 'properties.scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'properties.scaleSetEvictionPolicy', 'type': 'str'},
        'node_taints': {'key': 'properties.nodeTaints', 'type': '[str]'},
    }

    def __init__(self, *, count: int=None, vm_size=None, os_disk_size_gb: int=None, vnet_subnet_id: str=None, max_pods: int=None, os_type="Linux", max_count: int=None, min_count: int=None, enable_auto_scaling: bool=None, agent_pool_type=None, orchestrator_version: str=None, availability_zones=None, enable_node_public_ip: bool=None, scale_set_priority="Regular", scale_set_eviction_policy="Delete", node_taints=None, **kwargs) -> None:
        super(AgentPool, self).__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.vnet_subnet_id = vnet_subnet_id
        self.max_pods = max_pods
        self.os_type = os_type
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.agent_pool_type = agent_pool_type
        self.orchestrator_version = orchestrator_version
        self.provisioning_state = None
        self.availability_zones = availability_zones
        self.enable_node_public_ip = enable_node_public_ip
        self.scale_set_priority = scale_set_priority
        self.scale_set_eviction_policy = scale_set_eviction_policy
        self.node_taints = node_taints


class AgentPoolAvailableVersions(Model):
    """The list of available versions for an agent pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Id of the agent pool available versions.
    :vartype id: str
    :ivar name: Name of the agent pool available versions.
    :vartype name: str
    :ivar type: Type of the agent pool  available versions.
    :vartype type: str
    :param agent_pool_versions: List of versions available for agent pool.
    :type agent_pool_versions:
     list[~azure.mgmt.containerservice.v2019_08_01.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'agent_pool_versions': {'key': 'properties.agentPoolVersions', 'type': '[AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]'},
    }

    def __init__(self, *, agent_pool_versions=None, **kwargs) -> None:
        super(AgentPoolAvailableVersions, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.agent_pool_versions = agent_pool_versions


class AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem(Model):
    """AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem.

    :param default: Whether this version is the default agent pool version.
    :type default: bool
    :param kubernetes_version: Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'default': {'key': 'default', 'type': 'bool'},
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(self, *, default: bool=None, kubernetes_version: str=None, is_preview: bool=None, **kwargs) -> None:
        super(AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem, self).__init__(**kwargs)
        self.default = default
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class AgentPoolUpgradeProfile(Model):
    """The list of available upgrades for an agent pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Id of the agent pool upgrade profile.
    :vartype id: str
    :ivar name: Name of the agent pool upgrade profile.
    :vartype name: str
    :ivar type: Type of the agent pool upgrade profile.
    :vartype type: str
    :param kubernetes_version: Required. Kubernetes version (major, minor,
     patch).
    :type kubernetes_version: str
    :param os_type: Required. OsType to be used to specify os type. Choose
     from Linux and Windows. Default to Linux. Possible values include:
     'Linux', 'Windows'. Default value: "Linux" .
    :type os_type: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.OSType
    :param upgrades: List of orchestrator types and versions available for
     upgrade.
    :type upgrades:
     list[~azure.mgmt.containerservice.v2019_08_01.models.AgentPoolUpgradeProfilePropertiesUpgradesItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kubernetes_version': {'required': True},
        'os_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'upgrades': {'key': 'properties.upgrades', 'type': '[AgentPoolUpgradeProfilePropertiesUpgradesItem]'},
    }

    def __init__(self, *, kubernetes_version: str, os_type="Linux", upgrades=None, **kwargs) -> None:
        super(AgentPoolUpgradeProfile, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kubernetes_version = kubernetes_version
        self.os_type = os_type
        self.upgrades = upgrades


class AgentPoolUpgradeProfilePropertiesUpgradesItem(Model):
    """AgentPoolUpgradeProfilePropertiesUpgradesItem.

    :param kubernetes_version: Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(self, *, kubernetes_version: str=None, is_preview: bool=None, **kwargs) -> None:
        super(AgentPoolUpgradeProfilePropertiesUpgradesItem, self).__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class CloudError(Model):
    """An error response from the Container service.

    :param error: Details about the error.
    :type error:
     ~azure.mgmt.containerservice.v2019_08_01.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(CloudError, self).__init__(**kwargs)
        self.error = error


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """An error response from the Container service.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name
     of the property in error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details:
     list[~azure.mgmt.containerservice.v2019_08_01.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(self, *, code: str=None, message: str=None, target: str=None, details=None, **kwargs) -> None:
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ContainerServiceDiagnosticsProfile(Model):
    """Profile for diagnostics on the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param vm_diagnostics: Required. Profile for diagnostics on the container
     service VMs.
    :type vm_diagnostics:
     ~azure.mgmt.containerservice.v2019_08_01.models.ContainerServiceVMDiagnostics
    """

    _validation = {
        'vm_diagnostics': {'required': True},
    }

    _attribute_map = {
        'vm_diagnostics': {'key': 'vmDiagnostics', 'type': 'ContainerServiceVMDiagnostics'},
    }

    def __init__(self, *, vm_diagnostics, **kwargs) -> None:
        super(ContainerServiceDiagnosticsProfile, self).__init__(**kwargs)
        self.vm_diagnostics = vm_diagnostics


class ContainerServiceLinuxProfile(Model):
    """Profile for Linux VMs in the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param admin_username: Required. The administrator username to use for
     Linux VMs.
    :type admin_username: str
    :param ssh: Required. SSH configuration for Linux-based VMs running on
     Azure.
    :type ssh:
     ~azure.mgmt.containerservice.v2019_08_01.models.ContainerServiceSshConfiguration
    """

    _validation = {
        'admin_username': {'required': True, 'pattern': r'^[A-Za-z][-A-Za-z0-9_]*$'},
        'ssh': {'required': True},
    }

    _attribute_map = {
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'ssh': {'key': 'ssh', 'type': 'ContainerServiceSshConfiguration'},
    }

    def __init__(self, *, admin_username: str, ssh, **kwargs) -> None:
        super(ContainerServiceLinuxProfile, self).__init__(**kwargs)
        self.admin_username = admin_username
        self.ssh = ssh


class ContainerServiceMasterProfile(Model):
    """Profile for the container service master.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param count: Number of masters (VMs) in the container service cluster.
     Allowed values are 1, 3, and 5. The default value is 1. Default value: 1 .
    :type count: int
    :param dns_prefix: Required. DNS prefix to be used to create the FQDN for
     the master pool.
    :type dns_prefix: str
    :param vm_size: Required. Size of agent VMs. Possible values include:
     'Standard_A1', 'Standard_A10', 'Standard_A11', 'Standard_A1_v2',
     'Standard_A2', 'Standard_A2_v2', 'Standard_A2m_v2', 'Standard_A3',
     'Standard_A4', 'Standard_A4_v2', 'Standard_A4m_v2', 'Standard_A5',
     'Standard_A6', 'Standard_A7', 'Standard_A8', 'Standard_A8_v2',
     'Standard_A8m_v2', 'Standard_A9', 'Standard_B2ms', 'Standard_B2s',
     'Standard_B4ms', 'Standard_B8ms', 'Standard_D1', 'Standard_D11',
     'Standard_D11_v2', 'Standard_D11_v2_Promo', 'Standard_D12',
     'Standard_D12_v2', 'Standard_D12_v2_Promo', 'Standard_D13',
     'Standard_D13_v2', 'Standard_D13_v2_Promo', 'Standard_D14',
     'Standard_D14_v2', 'Standard_D14_v2_Promo', 'Standard_D15_v2',
     'Standard_D16_v3', 'Standard_D16s_v3', 'Standard_D1_v2', 'Standard_D2',
     'Standard_D2_v2', 'Standard_D2_v2_Promo', 'Standard_D2_v3',
     'Standard_D2s_v3', 'Standard_D3', 'Standard_D32_v3', 'Standard_D32s_v3',
     'Standard_D3_v2', 'Standard_D3_v2_Promo', 'Standard_D4', 'Standard_D4_v2',
     'Standard_D4_v2_Promo', 'Standard_D4_v3', 'Standard_D4s_v3',
     'Standard_D5_v2', 'Standard_D5_v2_Promo', 'Standard_D64_v3',
     'Standard_D64s_v3', 'Standard_D8_v3', 'Standard_D8s_v3', 'Standard_DS1',
     'Standard_DS11', 'Standard_DS11_v2', 'Standard_DS11_v2_Promo',
     'Standard_DS12', 'Standard_DS12_v2', 'Standard_DS12_v2_Promo',
     'Standard_DS13', 'Standard_DS13-2_v2', 'Standard_DS13-4_v2',
     'Standard_DS13_v2', 'Standard_DS13_v2_Promo', 'Standard_DS14',
     'Standard_DS14-4_v2', 'Standard_DS14-8_v2', 'Standard_DS14_v2',
     'Standard_DS14_v2_Promo', 'Standard_DS15_v2', 'Standard_DS1_v2',
     'Standard_DS2', 'Standard_DS2_v2', 'Standard_DS2_v2_Promo',
     'Standard_DS3', 'Standard_DS3_v2', 'Standard_DS3_v2_Promo',
     'Standard_DS4', 'Standard_DS4_v2', 'Standard_DS4_v2_Promo',
     'Standard_DS5_v2', 'Standard_DS5_v2_Promo', 'Standard_E16_v3',
     'Standard_E16s_v3', 'Standard_E2_v3', 'Standard_E2s_v3',
     'Standard_E32-16s_v3', 'Standard_E32-8s_v3', 'Standard_E32_v3',
     'Standard_E32s_v3', 'Standard_E4_v3', 'Standard_E4s_v3',
     'Standard_E64-16s_v3', 'Standard_E64-32s_v3', 'Standard_E64_v3',
     'Standard_E64s_v3', 'Standard_E8_v3', 'Standard_E8s_v3', 'Standard_F1',
     'Standard_F16', 'Standard_F16s', 'Standard_F16s_v2', 'Standard_F1s',
     'Standard_F2', 'Standard_F2s', 'Standard_F2s_v2', 'Standard_F32s_v2',
     'Standard_F4', 'Standard_F4s', 'Standard_F4s_v2', 'Standard_F64s_v2',
     'Standard_F72s_v2', 'Standard_F8', 'Standard_F8s', 'Standard_F8s_v2',
     'Standard_G1', 'Standard_G2', 'Standard_G3', 'Standard_G4', 'Standard_G5',
     'Standard_GS1', 'Standard_GS2', 'Standard_GS3', 'Standard_GS4',
     'Standard_GS4-4', 'Standard_GS4-8', 'Standard_GS5', 'Standard_GS5-16',
     'Standard_GS5-8', 'Standard_H16', 'Standard_H16m', 'Standard_H16mr',
     'Standard_H16r', 'Standard_H8', 'Standard_H8m', 'Standard_L16s',
     'Standard_L32s', 'Standard_L4s', 'Standard_L8s', 'Standard_M128-32ms',
     'Standard_M128-64ms', 'Standard_M128ms', 'Standard_M128s',
     'Standard_M64-16ms', 'Standard_M64-32ms', 'Standard_M64ms',
     'Standard_M64s', 'Standard_NC12', 'Standard_NC12s_v2',
     'Standard_NC12s_v3', 'Standard_NC24', 'Standard_NC24r',
     'Standard_NC24rs_v2', 'Standard_NC24rs_v3', 'Standard_NC24s_v2',
     'Standard_NC24s_v3', 'Standard_NC6', 'Standard_NC6s_v2',
     'Standard_NC6s_v3', 'Standard_ND12s', 'Standard_ND24rs', 'Standard_ND24s',
     'Standard_ND6s', 'Standard_NV12', 'Standard_NV24', 'Standard_NV6'
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk
     size for every machine in this master/agent pool. If you specify 0, it
     will apply the default osDisk size according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet
     identifier.
    :type vnet_subnet_id: str
    :param first_consecutive_static_ip: FirstConsecutiveStaticIP used to
     specify the first static ip of masters. Default value: "10.240.255.5" .
    :type first_consecutive_static_ip: str
    :param storage_profile: Storage profile specifies what kind of storage
     used. Choose from StorageAccount and ManagedDisks. Leave it empty, we will
     choose for you based on the orchestrator choice. Possible values include:
     'StorageAccount', 'ManagedDisks'
    :type storage_profile: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.ContainerServiceStorageProfileTypes
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    """

    _validation = {
        'dns_prefix': {'required': True},
        'vm_size': {'required': True},
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'dns_prefix': {'key': 'dnsPrefix', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'first_consecutive_static_ip': {'key': 'firstConsecutiveStaticIP', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
    }

    def __init__(self, *, dns_prefix: str, vm_size, count: int=1, os_disk_size_gb: int=None, vnet_subnet_id: str=None, first_consecutive_static_ip: str="10.240.255.5", storage_profile=None, **kwargs) -> None:
        super(ContainerServiceMasterProfile, self).__init__(**kwargs)
        self.count = count
        self.dns_prefix = dns_prefix
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.vnet_subnet_id = vnet_subnet_id
        self.first_consecutive_static_ip = first_consecutive_static_ip
        self.storage_profile = storage_profile
        self.fqdn = None


class ContainerServiceNetworkProfile(Model):
    """Profile of network configuration.

    :param network_plugin: Network plugin used for building Kubernetes
     network. Possible values include: 'azure', 'kubenet'. Default value:
     "kubenet" .
    :type network_plugin: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.NetworkPlugin
    :param network_policy: Network policy used for building Kubernetes
     network. Possible values include: 'calico', 'azure'
    :type network_policy: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.NetworkPolicy
    :param pod_cidr: A CIDR notation IP range from which to assign pod IPs
     when kubenet is used. Default value: "10.244.0.0/16" .
    :type pod_cidr: str
    :param service_cidr: A CIDR notation IP range from which to assign service
     cluster IPs. It must not overlap with any Subnet IP ranges. Default value:
     "10.0.0.0/16" .
    :type service_cidr: str
    :param dns_service_ip: An IP address assigned to the Kubernetes DNS
     service. It must be within the Kubernetes service address range specified
     in serviceCidr. Default value: "10.0.0.10" .
    :type dns_service_ip: str
    :param docker_bridge_cidr: A CIDR notation IP range assigned to the Docker
     bridge network. It must not overlap with any Subnet IP ranges or the
     Kubernetes service address range. Default value: "172.17.0.1/16" .
    :type docker_bridge_cidr: str
    :param load_balancer_sku: The load balancer sku for the managed cluster.
     Possible values include: 'standard', 'basic'
    :type load_balancer_sku: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.LoadBalancerSku
    :param load_balancer_profile: Profile of the cluster load balancer.
    :type load_balancer_profile:
     ~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterLoadBalancerProfile
    """

    _validation = {
        'pod_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'service_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'dns_service_ip': {'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$'},
        'docker_bridge_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
    }

    _attribute_map = {
        'network_plugin': {'key': 'networkPlugin', 'type': 'str'},
        'network_policy': {'key': 'networkPolicy', 'type': 'str'},
        'pod_cidr': {'key': 'podCidr', 'type': 'str'},
        'service_cidr': {'key': 'serviceCidr', 'type': 'str'},
        'dns_service_ip': {'key': 'dnsServiceIP', 'type': 'str'},
        'docker_bridge_cidr': {'key': 'dockerBridgeCidr', 'type': 'str'},
        'load_balancer_sku': {'key': 'loadBalancerSku', 'type': 'str'},
        'load_balancer_profile': {'key': 'loadBalancerProfile', 'type': 'ManagedClusterLoadBalancerProfile'},
    }

    def __init__(self, *, network_plugin="kubenet", network_policy=None, pod_cidr: str="10.244.0.0/16", service_cidr: str="10.0.0.0/16", dns_service_ip: str="10.0.0.10", docker_bridge_cidr: str="172.17.0.1/16", load_balancer_sku=None, load_balancer_profile=None, **kwargs) -> None:
        super(ContainerServiceNetworkProfile, self).__init__(**kwargs)
        self.network_plugin = network_plugin
        self.network_policy = network_policy
        self.pod_cidr = pod_cidr
        self.service_cidr = service_cidr
        self.dns_service_ip = dns_service_ip
        self.docker_bridge_cidr = docker_bridge_cidr
        self.load_balancer_sku = load_balancer_sku
        self.load_balancer_profile = load_balancer_profile


class ContainerServiceSshConfiguration(Model):
    """SSH configuration for Linux-based VMs running on Azure.

    All required parameters must be populated in order to send to Azure.

    :param public_keys: Required. The list of SSH public keys used to
     authenticate with Linux-based VMs. Only expect one key specified.
    :type public_keys:
     list[~azure.mgmt.containerservice.v2019_08_01.models.ContainerServiceSshPublicKey]
    """

    _validation = {
        'public_keys': {'required': True},
    }

    _attribute_map = {
        'public_keys': {'key': 'publicKeys', 'type': '[ContainerServiceSshPublicKey]'},
    }

    def __init__(self, *, public_keys, **kwargs) -> None:
        super(ContainerServiceSshConfiguration, self).__init__(**kwargs)
        self.public_keys = public_keys


class ContainerServiceSshPublicKey(Model):
    """Contains information about SSH certificate public key data.

    All required parameters must be populated in order to send to Azure.

    :param key_data: Required. Certificate public key used to authenticate
     with VMs through SSH. The certificate must be in PEM format with or
     without headers.
    :type key_data: str
    """

    _validation = {
        'key_data': {'required': True},
    }

    _attribute_map = {
        'key_data': {'key': 'keyData', 'type': 'str'},
    }

    def __init__(self, *, key_data: str, **kwargs) -> None:
        super(ContainerServiceSshPublicKey, self).__init__(**kwargs)
        self.key_data = key_data


class ContainerServiceVMDiagnostics(Model):
    """Profile for diagnostics on the container service VMs.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the VM diagnostic agent is provisioned
     on the VM.
    :type enabled: bool
    :ivar storage_uri: The URI of the storage account where diagnostics are
     stored.
    :vartype storage_uri: str
    """

    _validation = {
        'enabled': {'required': True},
        'storage_uri': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
    }

    def __init__(self, *, enabled: bool, **kwargs) -> None:
        super(ContainerServiceVMDiagnostics, self).__init__(**kwargs)
        self.enabled = enabled
        self.storage_uri = None


class CredentialResult(Model):
    """The credential result response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the credential.
    :vartype name: str
    :ivar value: Base64-encoded Kubernetes configuration file.
    :vartype value: bytearray
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'bytearray'},
    }

    def __init__(self, **kwargs) -> None:
        super(CredentialResult, self).__init__(**kwargs)
        self.name = None
        self.value = None


class CredentialResults(Model):
    """The list of credential result response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar kubeconfigs: Base64-encoded Kubernetes configuration file.
    :vartype kubeconfigs:
     list[~azure.mgmt.containerservice.v2019_08_01.models.CredentialResult]
    """

    _validation = {
        'kubeconfigs': {'readonly': True},
    }

    _attribute_map = {
        'kubeconfigs': {'key': 'kubeconfigs', 'type': '[CredentialResult]'},
    }

    def __init__(self, **kwargs) -> None:
        super(CredentialResults, self).__init__(**kwargs)
        self.kubeconfigs = None


class Resource(Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ManagedCluster(Resource):
    """Managed cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar provisioning_state: The current deployment or provisioning state,
     which only appears in the response.
    :vartype provisioning_state: str
    :ivar max_agent_pools: The max number of agent pools for the managed
     cluster.
    :vartype max_agent_pools: int
    :param kubernetes_version: Version of Kubernetes specified when creating
     the managed cluster.
    :type kubernetes_version: str
    :param dns_prefix: DNS prefix specified when creating the managed cluster.
    :type dns_prefix: str
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    :param agent_pool_profiles: Properties of the agent pool.
    :type agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterAgentPoolProfile]
    :param linux_profile: Profile for Linux VMs in the container service
     cluster.
    :type linux_profile:
     ~azure.mgmt.containerservice.v2019_08_01.models.ContainerServiceLinuxProfile
    :param windows_profile: Profile for Windows VMs in the container service
     cluster.
    :type windows_profile:
     ~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterWindowsProfile
    :param service_principal_profile: Information about a service principal
     identity for the cluster to use for manipulating Azure APIs.
    :type service_principal_profile:
     ~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterServicePrincipalProfile
    :param addon_profiles: Profile of managed cluster add-on.
    :type addon_profiles: dict[str,
     ~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterAddonProfile]
    :param node_resource_group: Name of the resource group containing agent
     pool nodes.
    :type node_resource_group: str
    :param enable_rbac: Whether to enable Kubernetes Role-Based Access
     Control.
    :type enable_rbac: bool
    :param enable_pod_security_policy: (PREVIEW) Whether to enable Kubernetes
     Pod security policy.
    :type enable_pod_security_policy: bool
    :param network_profile: Profile of network configuration.
    :type network_profile:
     ~azure.mgmt.containerservice.v2019_08_01.models.ContainerServiceNetworkProfile
    :param aad_profile: Profile of Azure Active Directory configuration.
    :type aad_profile:
     ~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterAADProfile
    :param api_server_access_profile: Access profile for managed cluster API
     server.
    :type api_server_access_profile:
     ~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterAPIServerAccessProfile
    :param identity: The identity of the managed cluster, if configured.
    :type identity:
     ~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'max_agent_pools': {'readonly': True},
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'max_agent_pools': {'key': 'properties.maxAgentPools', 'type': 'int'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'dns_prefix': {'key': 'properties.dnsPrefix', 'type': 'str'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'agent_pool_profiles': {'key': 'properties.agentPoolProfiles', 'type': '[ManagedClusterAgentPoolProfile]'},
        'linux_profile': {'key': 'properties.linuxProfile', 'type': 'ContainerServiceLinuxProfile'},
        'windows_profile': {'key': 'properties.windowsProfile', 'type': 'ManagedClusterWindowsProfile'},
        'service_principal_profile': {'key': 'properties.servicePrincipalProfile', 'type': 'ManagedClusterServicePrincipalProfile'},
        'addon_profiles': {'key': 'properties.addonProfiles', 'type': '{ManagedClusterAddonProfile}'},
        'node_resource_group': {'key': 'properties.nodeResourceGroup', 'type': 'str'},
        'enable_rbac': {'key': 'properties.enableRBAC', 'type': 'bool'},
        'enable_pod_security_policy': {'key': 'properties.enablePodSecurityPolicy', 'type': 'bool'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'ContainerServiceNetworkProfile'},
        'aad_profile': {'key': 'properties.aadProfile', 'type': 'ManagedClusterAADProfile'},
        'api_server_access_profile': {'key': 'properties.apiServerAccessProfile', 'type': 'ManagedClusterAPIServerAccessProfile'},
        'identity': {'key': 'identity', 'type': 'ManagedClusterIdentity'},
    }

    def __init__(self, *, location: str, tags=None, kubernetes_version: str=None, dns_prefix: str=None, agent_pool_profiles=None, linux_profile=None, windows_profile=None, service_principal_profile=None, addon_profiles=None, node_resource_group: str=None, enable_rbac: bool=None, enable_pod_security_policy: bool=None, network_profile=None, aad_profile=None, api_server_access_profile=None, identity=None, **kwargs) -> None:
        super(ManagedCluster, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.max_agent_pools = None
        self.kubernetes_version = kubernetes_version
        self.dns_prefix = dns_prefix
        self.fqdn = None
        self.agent_pool_profiles = agent_pool_profiles
        self.linux_profile = linux_profile
        self.windows_profile = windows_profile
        self.service_principal_profile = service_principal_profile
        self.addon_profiles = addon_profiles
        self.node_resource_group = node_resource_group
        self.enable_rbac = enable_rbac
        self.enable_pod_security_policy = enable_pod_security_policy
        self.network_profile = network_profile
        self.aad_profile = aad_profile
        self.api_server_access_profile = api_server_access_profile
        self.identity = identity


class ManagedClusterAADProfile(Model):
    """AADProfile specifies attributes for Azure Active Directory integration.

    All required parameters must be populated in order to send to Azure.

    :param client_app_id: Required. The client AAD application ID.
    :type client_app_id: str
    :param server_app_id: Required. The server AAD application ID.
    :type server_app_id: str
    :param server_app_secret: The server AAD application secret.
    :type server_app_secret: str
    :param tenant_id: The AAD tenant ID to use for authentication. If not
     specified, will use the tenant of the deployment subscription.
    :type tenant_id: str
    """

    _validation = {
        'client_app_id': {'required': True},
        'server_app_id': {'required': True},
    }

    _attribute_map = {
        'client_app_id': {'key': 'clientAppID', 'type': 'str'},
        'server_app_id': {'key': 'serverAppID', 'type': 'str'},
        'server_app_secret': {'key': 'serverAppSecret', 'type': 'str'},
        'tenant_id': {'key': 'tenantID', 'type': 'str'},
    }

    def __init__(self, *, client_app_id: str, server_app_id: str, server_app_secret: str=None, tenant_id: str=None, **kwargs) -> None:
        super(ManagedClusterAADProfile, self).__init__(**kwargs)
        self.client_app_id = client_app_id
        self.server_app_id = server_app_id
        self.server_app_secret = server_app_secret
        self.tenant_id = tenant_id


class ManagedClusterAccessProfile(Resource):
    """Managed cluster Access Profile.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param kube_config: Base64-encoded Kubernetes configuration file.
    :type kube_config: bytearray
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kube_config': {'key': 'properties.kubeConfig', 'type': 'bytearray'},
    }

    def __init__(self, *, location: str, tags=None, kube_config: bytearray=None, **kwargs) -> None:
        super(ManagedClusterAccessProfile, self).__init__(location=location, tags=tags, **kwargs)
        self.kube_config = kube_config


class ManagedClusterAddonProfile(Model):
    """A Kubernetes add-on profile for a managed cluster.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the add-on is enabled or not.
    :type enabled: bool
    :param config: Key-value pairs for configuring an add-on.
    :type config: dict[str, str]
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'config': {'key': 'config', 'type': '{str}'},
    }

    def __init__(self, *, enabled: bool, config=None, **kwargs) -> None:
        super(ManagedClusterAddonProfile, self).__init__(**kwargs)
        self.enabled = enabled
        self.config = config


class ManagedClusterAgentPoolProfileProperties(Model):
    """Properties for the container service agent pool profile.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param count: Number of agents (VMs) to host docker containers. Allowed
     values must be in the range of 1 to 100 (inclusive). The default value is
     1.
    :type count: int
    :param vm_size: Size of agent VMs. Possible values include: 'Standard_A1',
     'Standard_A10', 'Standard_A11', 'Standard_A1_v2', 'Standard_A2',
     'Standard_A2_v2', 'Standard_A2m_v2', 'Standard_A3', 'Standard_A4',
     'Standard_A4_v2', 'Standard_A4m_v2', 'Standard_A5', 'Standard_A6',
     'Standard_A7', 'Standard_A8', 'Standard_A8_v2', 'Standard_A8m_v2',
     'Standard_A9', 'Standard_B2ms', 'Standard_B2s', 'Standard_B4ms',
     'Standard_B8ms', 'Standard_D1', 'Standard_D11', 'Standard_D11_v2',
     'Standard_D11_v2_Promo', 'Standard_D12', 'Standard_D12_v2',
     'Standard_D12_v2_Promo', 'Standard_D13', 'Standard_D13_v2',
     'Standard_D13_v2_Promo', 'Standard_D14', 'Standard_D14_v2',
     'Standard_D14_v2_Promo', 'Standard_D15_v2', 'Standard_D16_v3',
     'Standard_D16s_v3', 'Standard_D1_v2', 'Standard_D2', 'Standard_D2_v2',
     'Standard_D2_v2_Promo', 'Standard_D2_v3', 'Standard_D2s_v3',
     'Standard_D3', 'Standard_D32_v3', 'Standard_D32s_v3', 'Standard_D3_v2',
     'Standard_D3_v2_Promo', 'Standard_D4', 'Standard_D4_v2',
     'Standard_D4_v2_Promo', 'Standard_D4_v3', 'Standard_D4s_v3',
     'Standard_D5_v2', 'Standard_D5_v2_Promo', 'Standard_D64_v3',
     'Standard_D64s_v3', 'Standard_D8_v3', 'Standard_D8s_v3', 'Standard_DS1',
     'Standard_DS11', 'Standard_DS11_v2', 'Standard_DS11_v2_Promo',
     'Standard_DS12', 'Standard_DS12_v2', 'Standard_DS12_v2_Promo',
     'Standard_DS13', 'Standard_DS13-2_v2', 'Standard_DS13-4_v2',
     'Standard_DS13_v2', 'Standard_DS13_v2_Promo', 'Standard_DS14',
     'Standard_DS14-4_v2', 'Standard_DS14-8_v2', 'Standard_DS14_v2',
     'Standard_DS14_v2_Promo', 'Standard_DS15_v2', 'Standard_DS1_v2',
     'Standard_DS2', 'Standard_DS2_v2', 'Standard_DS2_v2_Promo',
     'Standard_DS3', 'Standard_DS3_v2', 'Standard_DS3_v2_Promo',
     'Standard_DS4', 'Standard_DS4_v2', 'Standard_DS4_v2_Promo',
     'Standard_DS5_v2', 'Standard_DS5_v2_Promo', 'Standard_E16_v3',
     'Standard_E16s_v3', 'Standard_E2_v3', 'Standard_E2s_v3',
     'Standard_E32-16s_v3', 'Standard_E32-8s_v3', 'Standard_E32_v3',
     'Standard_E32s_v3', 'Standard_E4_v3', 'Standard_E4s_v3',
     'Standard_E64-16s_v3', 'Standard_E64-32s_v3', 'Standard_E64_v3',
     'Standard_E64s_v3', 'Standard_E8_v3', 'Standard_E8s_v3', 'Standard_F1',
     'Standard_F16', 'Standard_F16s', 'Standard_F16s_v2', 'Standard_F1s',
     'Standard_F2', 'Standard_F2s', 'Standard_F2s_v2', 'Standard_F32s_v2',
     'Standard_F4', 'Standard_F4s', 'Standard_F4s_v2', 'Standard_F64s_v2',
     'Standard_F72s_v2', 'Standard_F8', 'Standard_F8s', 'Standard_F8s_v2',
     'Standard_G1', 'Standard_G2', 'Standard_G3', 'Standard_G4', 'Standard_G5',
     'Standard_GS1', 'Standard_GS2', 'Standard_GS3', 'Standard_GS4',
     'Standard_GS4-4', 'Standard_GS4-8', 'Standard_GS5', 'Standard_GS5-16',
     'Standard_GS5-8', 'Standard_H16', 'Standard_H16m', 'Standard_H16mr',
     'Standard_H16r', 'Standard_H8', 'Standard_H8m', 'Standard_L16s',
     'Standard_L32s', 'Standard_L4s', 'Standard_L8s', 'Standard_M128-32ms',
     'Standard_M128-64ms', 'Standard_M128ms', 'Standard_M128s',
     'Standard_M64-16ms', 'Standard_M64-32ms', 'Standard_M64ms',
     'Standard_M64s', 'Standard_NC12', 'Standard_NC12s_v2',
     'Standard_NC12s_v3', 'Standard_NC24', 'Standard_NC24r',
     'Standard_NC24rs_v2', 'Standard_NC24rs_v3', 'Standard_NC24s_v2',
     'Standard_NC24s_v3', 'Standard_NC6', 'Standard_NC6s_v2',
     'Standard_NC6s_v3', 'Standard_ND12s', 'Standard_ND24rs', 'Standard_ND24s',
     'Standard_ND6s', 'Standard_NV12', 'Standard_NV24', 'Standard_NV6'
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk
     size for every machine in this master/agent pool. If you specify 0, it
     will apply the default osDisk size according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet
     identifier.
    :type vnet_subnet_id: str
    :param max_pods: Maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: OsType to be used to specify os type. Choose from Linux
     and Windows. Default to Linux. Possible values include: 'Linux',
     'Windows'. Default value: "Linux" .
    :type os_type: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.OSType
    :param max_count: Maximum number of nodes for auto-scaling
    :type max_count: int
    :param min_count: Minimum number of nodes for auto-scaling
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler
    :type enable_auto_scaling: bool
    :param type: AgentPoolType represents types of an agent pool. Possible
     values include: 'VirtualMachineScaleSets', 'AvailabilitySet'
    :type type: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.AgentPoolType
    :param orchestrator_version: Version of orchestrator specified when
     creating the managed cluster.
    :type orchestrator_version: str
    :ivar provisioning_state: The current deployment or provisioning state,
     which only appears in the response.
    :vartype provisioning_state: str
    :param availability_zones: (PREVIEW) Availability zones for nodes. Must
     use VirtualMachineScaleSets AgentPoolType.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Enable public IP for nodes
    :type enable_node_public_ip: bool
    :param scale_set_priority: ScaleSetPriority to be used to specify virtual
     machine scale set priority. Default to regular. Possible values include:
     'Low', 'Regular'. Default value: "Regular" .
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to
     specify eviction policy for low priority virtual machine scale set.
     Default to Delete. Possible values include: 'Delete', 'Deallocate'.
     Default value: "Delete" .
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.ScaleSetEvictionPolicy
    :param node_taints: Taints added to new nodes during node pool create and
     scale. For example, key=value:NoSchedule.
    :type node_taints: list[str]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'max_pods': {'key': 'maxPods', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'max_count': {'key': 'maxCount', 'type': 'int'},
        'min_count': {'key': 'minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'enableAutoScaling', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'availability_zones': {'key': 'availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'enableNodePublicIP', 'type': 'bool'},
        'scale_set_priority': {'key': 'scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'scaleSetEvictionPolicy', 'type': 'str'},
        'node_taints': {'key': 'nodeTaints', 'type': '[str]'},
    }

    def __init__(self, *, count: int=None, vm_size=None, os_disk_size_gb: int=None, vnet_subnet_id: str=None, max_pods: int=None, os_type="Linux", max_count: int=None, min_count: int=None, enable_auto_scaling: bool=None, type=None, orchestrator_version: str=None, availability_zones=None, enable_node_public_ip: bool=None, scale_set_priority="Regular", scale_set_eviction_policy="Delete", node_taints=None, **kwargs) -> None:
        super(ManagedClusterAgentPoolProfileProperties, self).__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.vnet_subnet_id = vnet_subnet_id
        self.max_pods = max_pods
        self.os_type = os_type
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.type = type
        self.orchestrator_version = orchestrator_version
        self.provisioning_state = None
        self.availability_zones = availability_zones
        self.enable_node_public_ip = enable_node_public_ip
        self.scale_set_priority = scale_set_priority
        self.scale_set_eviction_policy = scale_set_eviction_policy
        self.node_taints = node_taints


class ManagedClusterAgentPoolProfile(ManagedClusterAgentPoolProfileProperties):
    """Profile for the container service agent pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param count: Number of agents (VMs) to host docker containers. Allowed
     values must be in the range of 1 to 100 (inclusive). The default value is
     1.
    :type count: int
    :param vm_size: Size of agent VMs. Possible values include: 'Standard_A1',
     'Standard_A10', 'Standard_A11', 'Standard_A1_v2', 'Standard_A2',
     'Standard_A2_v2', 'Standard_A2m_v2', 'Standard_A3', 'Standard_A4',
     'Standard_A4_v2', 'Standard_A4m_v2', 'Standard_A5', 'Standard_A6',
     'Standard_A7', 'Standard_A8', 'Standard_A8_v2', 'Standard_A8m_v2',
     'Standard_A9', 'Standard_B2ms', 'Standard_B2s', 'Standard_B4ms',
     'Standard_B8ms', 'Standard_D1', 'Standard_D11', 'Standard_D11_v2',
     'Standard_D11_v2_Promo', 'Standard_D12', 'Standard_D12_v2',
     'Standard_D12_v2_Promo', 'Standard_D13', 'Standard_D13_v2',
     'Standard_D13_v2_Promo', 'Standard_D14', 'Standard_D14_v2',
     'Standard_D14_v2_Promo', 'Standard_D15_v2', 'Standard_D16_v3',
     'Standard_D16s_v3', 'Standard_D1_v2', 'Standard_D2', 'Standard_D2_v2',
     'Standard_D2_v2_Promo', 'Standard_D2_v3', 'Standard_D2s_v3',
     'Standard_D3', 'Standard_D32_v3', 'Standard_D32s_v3', 'Standard_D3_v2',
     'Standard_D3_v2_Promo', 'Standard_D4', 'Standard_D4_v2',
     'Standard_D4_v2_Promo', 'Standard_D4_v3', 'Standard_D4s_v3',
     'Standard_D5_v2', 'Standard_D5_v2_Promo', 'Standard_D64_v3',
     'Standard_D64s_v3', 'Standard_D8_v3', 'Standard_D8s_v3', 'Standard_DS1',
     'Standard_DS11', 'Standard_DS11_v2', 'Standard_DS11_v2_Promo',
     'Standard_DS12', 'Standard_DS12_v2', 'Standard_DS12_v2_Promo',
     'Standard_DS13', 'Standard_DS13-2_v2', 'Standard_DS13-4_v2',
     'Standard_DS13_v2', 'Standard_DS13_v2_Promo', 'Standard_DS14',
     'Standard_DS14-4_v2', 'Standard_DS14-8_v2', 'Standard_DS14_v2',
     'Standard_DS14_v2_Promo', 'Standard_DS15_v2', 'Standard_DS1_v2',
     'Standard_DS2', 'Standard_DS2_v2', 'Standard_DS2_v2_Promo',
     'Standard_DS3', 'Standard_DS3_v2', 'Standard_DS3_v2_Promo',
     'Standard_DS4', 'Standard_DS4_v2', 'Standard_DS4_v2_Promo',
     'Standard_DS5_v2', 'Standard_DS5_v2_Promo', 'Standard_E16_v3',
     'Standard_E16s_v3', 'Standard_E2_v3', 'Standard_E2s_v3',
     'Standard_E32-16s_v3', 'Standard_E32-8s_v3', 'Standard_E32_v3',
     'Standard_E32s_v3', 'Standard_E4_v3', 'Standard_E4s_v3',
     'Standard_E64-16s_v3', 'Standard_E64-32s_v3', 'Standard_E64_v3',
     'Standard_E64s_v3', 'Standard_E8_v3', 'Standard_E8s_v3', 'Standard_F1',
     'Standard_F16', 'Standard_F16s', 'Standard_F16s_v2', 'Standard_F1s',
     'Standard_F2', 'Standard_F2s', 'Standard_F2s_v2', 'Standard_F32s_v2',
     'Standard_F4', 'Standard_F4s', 'Standard_F4s_v2', 'Standard_F64s_v2',
     'Standard_F72s_v2', 'Standard_F8', 'Standard_F8s', 'Standard_F8s_v2',
     'Standard_G1', 'Standard_G2', 'Standard_G3', 'Standard_G4', 'Standard_G5',
     'Standard_GS1', 'Standard_GS2', 'Standard_GS3', 'Standard_GS4',
     'Standard_GS4-4', 'Standard_GS4-8', 'Standard_GS5', 'Standard_GS5-16',
     'Standard_GS5-8', 'Standard_H16', 'Standard_H16m', 'Standard_H16mr',
     'Standard_H16r', 'Standard_H8', 'Standard_H8m', 'Standard_L16s',
     'Standard_L32s', 'Standard_L4s', 'Standard_L8s', 'Standard_M128-32ms',
     'Standard_M128-64ms', 'Standard_M128ms', 'Standard_M128s',
     'Standard_M64-16ms', 'Standard_M64-32ms', 'Standard_M64ms',
     'Standard_M64s', 'Standard_NC12', 'Standard_NC12s_v2',
     'Standard_NC12s_v3', 'Standard_NC24', 'Standard_NC24r',
     'Standard_NC24rs_v2', 'Standard_NC24rs_v3', 'Standard_NC24s_v2',
     'Standard_NC24s_v3', 'Standard_NC6', 'Standard_NC6s_v2',
     'Standard_NC6s_v3', 'Standard_ND12s', 'Standard_ND24rs', 'Standard_ND24s',
     'Standard_ND6s', 'Standard_NV12', 'Standard_NV24', 'Standard_NV6'
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk
     size for every machine in this master/agent pool. If you specify 0, it
     will apply the default osDisk size according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet
     identifier.
    :type vnet_subnet_id: str
    :param max_pods: Maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: OsType to be used to specify os type. Choose from Linux
     and Windows. Default to Linux. Possible values include: 'Linux',
     'Windows'. Default value: "Linux" .
    :type os_type: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.OSType
    :param max_count: Maximum number of nodes for auto-scaling
    :type max_count: int
    :param min_count: Minimum number of nodes for auto-scaling
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler
    :type enable_auto_scaling: bool
    :param type: AgentPoolType represents types of an agent pool. Possible
     values include: 'VirtualMachineScaleSets', 'AvailabilitySet'
    :type type: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.AgentPoolType
    :param orchestrator_version: Version of orchestrator specified when
     creating the managed cluster.
    :type orchestrator_version: str
    :ivar provisioning_state: The current deployment or provisioning state,
     which only appears in the response.
    :vartype provisioning_state: str
    :param availability_zones: (PREVIEW) Availability zones for nodes. Must
     use VirtualMachineScaleSets AgentPoolType.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Enable public IP for nodes
    :type enable_node_public_ip: bool
    :param scale_set_priority: ScaleSetPriority to be used to specify virtual
     machine scale set priority. Default to regular. Possible values include:
     'Low', 'Regular'. Default value: "Regular" .
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to
     specify eviction policy for low priority virtual machine scale set.
     Default to Delete. Possible values include: 'Delete', 'Deallocate'.
     Default value: "Delete" .
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.ScaleSetEvictionPolicy
    :param node_taints: Taints added to new nodes during node pool create and
     scale. For example, key=value:NoSchedule.
    :type node_taints: list[str]
    :param name: Required. Unique name of the agent pool profile in the
     context of the subscription and resource group.
    :type name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'name': {'required': True, 'pattern': r'^[a-z][a-z0-9]{0,11}$'},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'max_pods': {'key': 'maxPods', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'max_count': {'key': 'maxCount', 'type': 'int'},
        'min_count': {'key': 'minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'enableAutoScaling', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'availability_zones': {'key': 'availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'enableNodePublicIP', 'type': 'bool'},
        'scale_set_priority': {'key': 'scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'scaleSetEvictionPolicy', 'type': 'str'},
        'node_taints': {'key': 'nodeTaints', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str, count: int=None, vm_size=None, os_disk_size_gb: int=None, vnet_subnet_id: str=None, max_pods: int=None, os_type="Linux", max_count: int=None, min_count: int=None, enable_auto_scaling: bool=None, type=None, orchestrator_version: str=None, availability_zones=None, enable_node_public_ip: bool=None, scale_set_priority="Regular", scale_set_eviction_policy="Delete", node_taints=None, **kwargs) -> None:
        super(ManagedClusterAgentPoolProfile, self).__init__(count=count, vm_size=vm_size, os_disk_size_gb=os_disk_size_gb, vnet_subnet_id=vnet_subnet_id, max_pods=max_pods, os_type=os_type, max_count=max_count, min_count=min_count, enable_auto_scaling=enable_auto_scaling, type=type, orchestrator_version=orchestrator_version, availability_zones=availability_zones, enable_node_public_ip=enable_node_public_ip, scale_set_priority=scale_set_priority, scale_set_eviction_policy=scale_set_eviction_policy, node_taints=node_taints, **kwargs)
        self.name = name


class ManagedClusterAPIServerAccessProfile(Model):
    """Access profile for managed cluster API server.

    :param authorized_ip_ranges: Authorized IP Ranges to kubernetes API
     server.
    :type authorized_ip_ranges: list[str]
    :param enable_private_cluster: Whether to create the cluster as a private
     cluster or not.
    :type enable_private_cluster: bool
    """

    _attribute_map = {
        'authorized_ip_ranges': {'key': 'authorizedIPRanges', 'type': '[str]'},
        'enable_private_cluster': {'key': 'enablePrivateCluster', 'type': 'bool'},
    }

    def __init__(self, *, authorized_ip_ranges=None, enable_private_cluster: bool=None, **kwargs) -> None:
        super(ManagedClusterAPIServerAccessProfile, self).__init__(**kwargs)
        self.authorized_ip_ranges = authorized_ip_ranges
        self.enable_private_cluster = enable_private_cluster


class ManagedClusterIdentity(Model):
    """Identity for the managed cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal id of the system assigned identity which
     is used by master components.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity which is
     used by master components.
    :vartype tenant_id: str
    :param type: The type of identity used for the managed cluster. Type
     'SystemAssigned' will use an implicitly created identity in master
     components and an auto-created user assigned identity in MC_ resource
     group in agent nodes. Type 'None' will not use MSI for the managed
     cluster, service principal will be used instead. Possible values include:
     'SystemAssigned', 'None'
    :type type: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ResourceIdentityType'},
    }

    def __init__(self, *, type=None, **kwargs) -> None:
        super(ManagedClusterIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ManagedClusterLoadBalancerProfile(Model):
    """Profile of the managed cluster load balancer.

    :param managed_outbound_ips: Desired managed outbound IPs for the cluster
     load balancer.
    :type managed_outbound_ips:
     ~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterLoadBalancerProfileManagedOutboundIPs
    :param outbound_ip_prefixes: Desired outbound IP Prefix resources for the
     cluster load balancer.
    :type outbound_ip_prefixes:
     ~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes
    :param outbound_ips: Desired outbound IP resources for the cluster load
     balancer.
    :type outbound_ips:
     ~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterLoadBalancerProfileOutboundIPs
    :param effective_outbound_ips: The effective outbound IP resources of the
     cluster load balancer.
    :type effective_outbound_ips:
     list[~azure.mgmt.containerservice.v2019_08_01.models.ResourceReference]
    """

    _attribute_map = {
        'managed_outbound_ips': {'key': 'managedOutboundIPs', 'type': 'ManagedClusterLoadBalancerProfileManagedOutboundIPs'},
        'outbound_ip_prefixes': {'key': 'outboundIPPrefixes', 'type': 'ManagedClusterLoadBalancerProfileOutboundIPPrefixes'},
        'outbound_ips': {'key': 'outboundIPs', 'type': 'ManagedClusterLoadBalancerProfileOutboundIPs'},
        'effective_outbound_ips': {'key': 'effectiveOutboundIPs', 'type': '[ResourceReference]'},
    }

    def __init__(self, *, managed_outbound_ips=None, outbound_ip_prefixes=None, outbound_ips=None, effective_outbound_ips=None, **kwargs) -> None:
        super(ManagedClusterLoadBalancerProfile, self).__init__(**kwargs)
        self.managed_outbound_ips = managed_outbound_ips
        self.outbound_ip_prefixes = outbound_ip_prefixes
        self.outbound_ips = outbound_ips
        self.effective_outbound_ips = effective_outbound_ips


class ManagedClusterLoadBalancerProfileManagedOutboundIPs(Model):
    """Desired managed outbound IPs for the cluster load balancer.

    :param count: Desired number of outbound IP created/managed by Azure for
     the cluster load balancer. Allowed values must be in the range of 1 to 100
     (inclusive). The default value is 1. . Default value: 1 .
    :type count: int
    """

    _validation = {
        'count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(self, *, count: int=1, **kwargs) -> None:
        super(ManagedClusterLoadBalancerProfileManagedOutboundIPs, self).__init__(**kwargs)
        self.count = count


class ManagedClusterLoadBalancerProfileOutboundIPPrefixes(Model):
    """Desired outbound IP Prefix resources for the cluster load balancer.

    :param public_ip_prefixes: A list of public IP prefix resources.
    :type public_ip_prefixes:
     list[~azure.mgmt.containerservice.v2019_08_01.models.ResourceReference]
    """

    _attribute_map = {
        'public_ip_prefixes': {'key': 'publicIPPrefixes', 'type': '[ResourceReference]'},
    }

    def __init__(self, *, public_ip_prefixes=None, **kwargs) -> None:
        super(ManagedClusterLoadBalancerProfileOutboundIPPrefixes, self).__init__(**kwargs)
        self.public_ip_prefixes = public_ip_prefixes


class ManagedClusterLoadBalancerProfileOutboundIPs(Model):
    """Desired outbound IP resources for the cluster load balancer.

    :param public_ips: A list of public IP resources.
    :type public_ips:
     list[~azure.mgmt.containerservice.v2019_08_01.models.ResourceReference]
    """

    _attribute_map = {
        'public_ips': {'key': 'publicIPs', 'type': '[ResourceReference]'},
    }

    def __init__(self, *, public_ips=None, **kwargs) -> None:
        super(ManagedClusterLoadBalancerProfileOutboundIPs, self).__init__(**kwargs)
        self.public_ips = public_ips


class ManagedClusterPoolUpgradeProfile(Model):
    """The list of available upgrade versions.

    All required parameters must be populated in order to send to Azure.

    :param kubernetes_version: Required. Kubernetes version (major, minor,
     patch).
    :type kubernetes_version: str
    :param name: Pool name.
    :type name: str
    :param os_type: Required. OsType to be used to specify os type. Choose
     from Linux and Windows. Default to Linux. Possible values include:
     'Linux', 'Windows'. Default value: "Linux" .
    :type os_type: str or
     ~azure.mgmt.containerservice.v2019_08_01.models.OSType
    :param upgrades: List of orchestrator types and versions available for
     upgrade.
    :type upgrades:
     list[~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterPoolUpgradeProfileUpgradesItem]
    """

    _validation = {
        'kubernetes_version': {'required': True},
        'os_type': {'required': True},
    }

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'upgrades': {'key': 'upgrades', 'type': '[ManagedClusterPoolUpgradeProfileUpgradesItem]'},
    }

    def __init__(self, *, kubernetes_version: str, name: str=None, os_type="Linux", upgrades=None, **kwargs) -> None:
        super(ManagedClusterPoolUpgradeProfile, self).__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.name = name
        self.os_type = os_type
        self.upgrades = upgrades


class ManagedClusterPoolUpgradeProfileUpgradesItem(Model):
    """ManagedClusterPoolUpgradeProfileUpgradesItem.

    :param kubernetes_version: Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(self, *, kubernetes_version: str=None, is_preview: bool=None, **kwargs) -> None:
        super(ManagedClusterPoolUpgradeProfileUpgradesItem, self).__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class ManagedClusterServicePrincipalProfile(Model):
    """Information about a service principal identity for the cluster to use for
    manipulating Azure APIs.

    All required parameters must be populated in order to send to Azure.

    :param client_id: Required. The ID for the service principal.
    :type client_id: str
    :param secret: The secret password associated with the service principal
     in plain text.
    :type secret: str
    """

    _validation = {
        'client_id': {'required': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
    }

    def __init__(self, *, client_id: str, secret: str=None, **kwargs) -> None:
        super(ManagedClusterServicePrincipalProfile, self).__init__(**kwargs)
        self.client_id = client_id
        self.secret = secret


class ManagedClusterUpgradeProfile(Model):
    """The list of available upgrades for compute pools.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Id of upgrade profile.
    :vartype id: str
    :ivar name: Name of upgrade profile.
    :vartype name: str
    :ivar type: Type of upgrade profile.
    :vartype type: str
    :param control_plane_profile: Required. The list of available upgrade
     versions for the control plane.
    :type control_plane_profile:
     ~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterPoolUpgradeProfile
    :param agent_pool_profiles: Required. The list of available upgrade
     versions for agent pools.
    :type agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2019_08_01.models.ManagedClusterPoolUpgradeProfile]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'control_plane_profile': {'required': True},
        'agent_pool_profiles': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'control_plane_profile': {'key': 'properties.controlPlaneProfile', 'type': 'ManagedClusterPoolUpgradeProfile'},
        'agent_pool_profiles': {'key': 'properties.agentPoolProfiles', 'type': '[ManagedClusterPoolUpgradeProfile]'},
    }

    def __init__(self, *, control_plane_profile, agent_pool_profiles, **kwargs) -> None:
        super(ManagedClusterUpgradeProfile, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.control_plane_profile = control_plane_profile
        self.agent_pool_profiles = agent_pool_profiles


class ManagedClusterWindowsProfile(Model):
    """Profile for Windows VMs in the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param admin_username: Required. The administrator username to use for
     Windows VMs.
    :type admin_username: str
    :param admin_password: The administrator password to use for Windows VMs.
    :type admin_password: str
    """

    _validation = {
        'admin_username': {'required': True, 'pattern': r'^[a-zA-Z0-9]+([._]?[a-zA-Z0-9]+)*$'},
        'admin_password': {'pattern': r'^(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#$%\^&\*\(\)])[a-zA-Z\d!@#$%\^&\*\(\)]{12,123}$'},
    }

    _attribute_map = {
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
    }

    def __init__(self, *, admin_username: str, admin_password: str=None, **kwargs) -> None:
        super(ManagedClusterWindowsProfile, self).__init__(**kwargs)
        self.admin_username = admin_username
        self.admin_password = admin_password


class OperationValue(Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        'origin': {'readonly': True},
        'name': {'readonly': True},
        'operation': {'readonly': True},
        'resource': {'readonly': True},
        'description': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'operation': {'key': 'display.operation', 'type': 'str'},
        'resource': {'key': 'display.resource', 'type': 'str'},
        'description': {'key': 'display.description', 'type': 'str'},
        'provider': {'key': 'display.provider', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(OperationValue, self).__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class ResourceReference(Model):
    """A reference to an Azure resource.

    :param id: The fully qualified Azure resource id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(ResourceReference, self).__init__(**kwargs)
        self.id = id


class TagsObject(Model):
    """Tags object for patch operations.

    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(TagsObject, self).__init__(**kwargs)
        self.tags = tags
