# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models
from ._configuration import BillingManagementClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    AddressOperations,
    AgreementsOperations,
    AvailableBalancesOperations,
    BillingAccountsOperations,
    BillingPeriodsOperations,
    BillingPermissionsOperations,
    BillingProfilesOperations,
    BillingPropertyOperations,
    BillingRoleAssignmentsOperations,
    BillingRoleDefinitionsOperations,
    BillingSubscriptionsOperations,
    CustomersOperations,
    EnrollmentAccountsOperations,
    InstructionsOperations,
    InvoiceSectionsOperations,
    InvoicesOperations,
    Operations,
    PoliciesOperations,
    ProductsOperations,
    ReservationsOperations,
    TransactionsOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class BillingManagementClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Billing client provides access to billing resources for Azure subscriptions.

    :ivar billing_accounts: BillingAccountsOperations operations
    :vartype billing_accounts: azure.mgmt.billing.operations.BillingAccountsOperations
    :ivar address: AddressOperations operations
    :vartype address: azure.mgmt.billing.operations.AddressOperations
    :ivar available_balances: AvailableBalancesOperations operations
    :vartype available_balances: azure.mgmt.billing.operations.AvailableBalancesOperations
    :ivar instructions: InstructionsOperations operations
    :vartype instructions: azure.mgmt.billing.operations.InstructionsOperations
    :ivar billing_profiles: BillingProfilesOperations operations
    :vartype billing_profiles: azure.mgmt.billing.operations.BillingProfilesOperations
    :ivar customers: CustomersOperations operations
    :vartype customers: azure.mgmt.billing.operations.CustomersOperations
    :ivar invoice_sections: InvoiceSectionsOperations operations
    :vartype invoice_sections: azure.mgmt.billing.operations.InvoiceSectionsOperations
    :ivar billing_permissions: BillingPermissionsOperations operations
    :vartype billing_permissions: azure.mgmt.billing.operations.BillingPermissionsOperations
    :ivar billing_subscriptions: BillingSubscriptionsOperations operations
    :vartype billing_subscriptions: azure.mgmt.billing.operations.BillingSubscriptionsOperations
    :ivar products: ProductsOperations operations
    :vartype products: azure.mgmt.billing.operations.ProductsOperations
    :ivar invoices: InvoicesOperations operations
    :vartype invoices: azure.mgmt.billing.operations.InvoicesOperations
    :ivar transactions: TransactionsOperations operations
    :vartype transactions: azure.mgmt.billing.operations.TransactionsOperations
    :ivar policies: PoliciesOperations operations
    :vartype policies: azure.mgmt.billing.operations.PoliciesOperations
    :ivar billing_property: BillingPropertyOperations operations
    :vartype billing_property: azure.mgmt.billing.operations.BillingPropertyOperations
    :ivar billing_role_definitions: BillingRoleDefinitionsOperations operations
    :vartype billing_role_definitions:
     azure.mgmt.billing.operations.BillingRoleDefinitionsOperations
    :ivar billing_role_assignments: BillingRoleAssignmentsOperations operations
    :vartype billing_role_assignments:
     azure.mgmt.billing.operations.BillingRoleAssignmentsOperations
    :ivar agreements: AgreementsOperations operations
    :vartype agreements: azure.mgmt.billing.operations.AgreementsOperations
    :ivar reservations: ReservationsOperations operations
    :vartype reservations: azure.mgmt.billing.operations.ReservationsOperations
    :ivar enrollment_accounts: EnrollmentAccountsOperations operations
    :vartype enrollment_accounts: azure.mgmt.billing.operations.EnrollmentAccountsOperations
    :ivar billing_periods: BillingPeriodsOperations operations
    :vartype billing_periods: azure.mgmt.billing.operations.BillingPeriodsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.billing.operations.Operations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID that uniquely identifies an Azure subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = BillingManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.billing_accounts = BillingAccountsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.address = AddressOperations(self._client, self._config, self._serialize, self._deserialize)
        self.available_balances = AvailableBalancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.instructions = InstructionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.billing_profiles = BillingProfilesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.customers = CustomersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.invoice_sections = InvoiceSectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.billing_permissions = BillingPermissionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.billing_subscriptions = BillingSubscriptionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.products = ProductsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.invoices = InvoicesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.transactions = TransactionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.policies = PoliciesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.billing_property = BillingPropertyOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.billing_role_definitions = BillingRoleDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.billing_role_assignments = BillingRoleAssignmentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.agreements = AgreementsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.reservations = ReservationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.enrollment_accounts = EnrollmentAccountsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.billing_periods = BillingPeriodsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> BillingManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
