# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.containerinstance import ContainerInstanceManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-containerinstance
# USAGE
    python container_groups_create_priority.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ContainerInstanceManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.container_groups.begin_create_or_update(
        resource_group_name="demo",
        container_group_name="demo1",
        container_group={
            "location": "eastus",
            "properties": {
                "containers": [
                    {
                        "name": "test-container-001",
                        "properties": {
                            "command": ["/bin/sh", "-c", "sleep 10"],
                            "image": "alpine:latest",
                            "resources": {"requests": {"cpu": 1, "memoryInGB": 1}},
                        },
                    }
                ],
                "osType": "Linux",
                "priority": "Spot",
                "restartPolicy": "Never",
                "sku": "Standard",
            },
        },
    ).result()
    print(response)


# x-ms-original-file: specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupsCreatePriority.json
if __name__ == "__main__":
    main()
