# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AADProperties(_serialization.Model):
    """AADProperties.

    :ivar service_principal_client_id:
    :vartype service_principal_client_id: str
    :ivar tenant_id:
    :vartype tenant_id: str
    :ivar authority:
    :vartype authority: str
    :ivar audience:
    :vartype audience: str
    :ivar service_principal_object_id:
    :vartype service_principal_object_id: str
    """

    _attribute_map = {
        "service_principal_client_id": {"key": "servicePrincipalClientId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "authority": {"key": "authority", "type": "str"},
        "audience": {"key": "audience", "type": "str"},
        "service_principal_object_id": {"key": "servicePrincipalObjectId", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_principal_client_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        authority: Optional[str] = None,
        audience: Optional[str] = None,
        service_principal_object_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_principal_client_id:
        :paramtype service_principal_client_id: str
        :keyword tenant_id:
        :paramtype tenant_id: str
        :keyword authority:
        :paramtype authority: str
        :keyword audience:
        :paramtype audience: str
        :keyword service_principal_object_id:
        :paramtype service_principal_object_id: str
        """
        super().__init__(**kwargs)
        self.service_principal_client_id = service_principal_client_id
        self.tenant_id = tenant_id
        self.authority = authority
        self.audience = audience
        self.service_principal_object_id = service_principal_object_id


class Resource(_serialization.Model):
    """ARM Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.e_tag = e_tag


class AADPropertiesResource(Resource):
    """AADPropertiesResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: AADPropertiesResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AADProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "AADProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.AADProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: AADPropertiesResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AADProperties
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ProtectedItem(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Base class for backup items.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFileshareProtectedItem, AzureIaaSVMProtectedItem, AzureVmWorkloadProtectedItem,
    DPMProtectedItem, GenericProtectedItem, MabFileFolderProtectedItem, AzureSqlProtectedItem

    All required parameters must be populated in order to send to server.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    """

    _validation = {
        "protected_item_type": {"required": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
    }

    _subtype_map = {
        "protected_item_type": {
            "AzureFileShareProtectedItem": "AzureFileshareProtectedItem",
            "AzureIaaSVMProtectedItem": "AzureIaaSVMProtectedItem",
            "AzureVmWorkloadProtectedItem": "AzureVmWorkloadProtectedItem",
            "DPMProtectedItem": "DPMProtectedItem",
            "GenericProtectedItem": "GenericProtectedItem",
            "MabFileFolderProtectedItem": "MabFileFolderProtectedItem",
            "Microsoft.Sql/servers/databases": "AzureSqlProtectedItem",
        }
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword workload_type: Type of workload this item represents. Known values are: "Invalid",
         "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        """
        super().__init__(**kwargs)
        self.protected_item_type: Optional[str] = None
        self.backup_management_type = backup_management_type
        self.workload_type = workload_type
        self.container_name = container_name
        self.source_resource_id = source_resource_id
        self.policy_id = policy_id
        self.last_recovery_point = last_recovery_point
        self.backup_set_name = backup_set_name
        self.create_mode = create_mode
        self.deferred_delete_time_in_utc = deferred_delete_time_in_utc
        self.is_scheduled_for_deferred_delete = is_scheduled_for_deferred_delete
        self.deferred_delete_time_remaining = deferred_delete_time_remaining
        self.is_deferred_delete_schedule_upcoming = is_deferred_delete_schedule_upcoming
        self.is_rehydrate = is_rehydrate
        self.resource_guard_operation_requests = resource_guard_operation_requests


class AzureFileshareProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """Azure File Share workload-specific backup item.

    All required parameters must be populated in order to send to server.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar friendly_name: Friendly name of the fileshare represented by this backup item.
    :vartype friendly_name: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
    :ivar health_status: backups running status for this backup item. Known values are: "Passed",
     "ActionRequired", "ActionSuggested", and "Invalid".
    :vartype health_status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.HealthStatus
    :ivar last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
    :vartype last_backup_status: str
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
    :ivar extended_info: Additional information with this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureFileshareProtectedItemExtendedInfo
    """

    _validation = {
        "protected_item_type": {"required": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
        "extended_info": {"key": "extendedInfo", "type": "AzureFileshareProtectedItemExtendedInfo"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        friendly_name: Optional[str] = None,
        protection_status: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        health_status: Optional[Union[str, "_models.HealthStatus"]] = None,
        last_backup_status: Optional[str] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        extended_info: Optional["_models.AzureFileshareProtectedItemExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword workload_type: Type of workload this item represents. Known values are: "Invalid",
         "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword friendly_name: Friendly name of the fileshare represented by this backup item.
        :paramtype friendly_name: str
        :keyword protection_status: Backup status of this backup item.
        :paramtype protection_status: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
        :keyword health_status: backups running status for this backup item. Known values are:
         "Passed", "ActionRequired", "ActionSuggested", and "Invalid".
        :paramtype health_status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.HealthStatus
        :keyword last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :paramtype last_backup_status: str
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
        :keyword extended_info: Additional information with this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureFileshareProtectedItemExtendedInfo
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            **kwargs
        )
        self.protected_item_type: str = "AzureFileShareProtectedItem"
        self.friendly_name = friendly_name
        self.protection_status = protection_status
        self.protection_state = protection_state
        self.health_status = health_status
        self.last_backup_status = last_backup_status
        self.last_backup_time = last_backup_time
        self.kpis_healths = kpis_healths
        self.extended_info = extended_info


class AzureFileshareProtectedItemExtendedInfo(_serialization.Model):
    """Additional information about Azure File Share backup item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar oldest_recovery_point: The oldest backup copy available for this item in the service.
    :vartype oldest_recovery_point: ~datetime.datetime
    :ivar recovery_point_count: Number of available backup copies associated with this backup item.
    :vartype recovery_point_count: int
    :ivar policy_state: Indicates consistency of policy object and policy applied to this backup
     item.
    :vartype policy_state: str
    :ivar resource_state: Indicates the state of this resource. Possible values are from enum
     ResourceState {Invalid, Active, SoftDeleted, Deleted}.
    :vartype resource_state: str
    :ivar resource_state_sync_time: The resource state sync time for this backup item.
    :vartype resource_state_sync_time: ~datetime.datetime
    """

    _validation = {
        "resource_state": {"readonly": True},
        "resource_state_sync_time": {"readonly": True},
    }

    _attribute_map = {
        "oldest_recovery_point": {"key": "oldestRecoveryPoint", "type": "iso-8601"},
        "recovery_point_count": {"key": "recoveryPointCount", "type": "int"},
        "policy_state": {"key": "policyState", "type": "str"},
        "resource_state": {"key": "resourceState", "type": "str"},
        "resource_state_sync_time": {"key": "resourceStateSyncTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        oldest_recovery_point: Optional[datetime.datetime] = None,
        recovery_point_count: Optional[int] = None,
        policy_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword oldest_recovery_point: The oldest backup copy available for this item in the service.
        :paramtype oldest_recovery_point: ~datetime.datetime
        :keyword recovery_point_count: Number of available backup copies associated with this backup
         item.
        :paramtype recovery_point_count: int
        :keyword policy_state: Indicates consistency of policy object and policy applied to this backup
         item.
        :paramtype policy_state: str
        """
        super().__init__(**kwargs)
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.policy_state = policy_state
        self.resource_state = None
        self.resource_state_sync_time = None


class RecoveryPoint(_serialization.Model):
    """Base class for backup copies. Workload-specific backup copies are derived from this class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFileShareRecoveryPoint, AzureWorkloadRecoveryPoint, GenericRecoveryPoint,
    IaasVMRecoveryPoint

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "AzureFileShareRecoveryPoint": "AzureFileShareRecoveryPoint",
            "AzureWorkloadRecoveryPoint": "AzureWorkloadRecoveryPoint",
            "GenericRecoveryPoint": "GenericRecoveryPoint",
            "IaasVMRecoveryPoint": "IaasVMRecoveryPoint",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None


class AzureFileShareRecoveryPoint(RecoveryPoint):
    """Azure File Share workload specific backup copy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_type: Type of the backup copy. Specifies whether it is a crash consistent
     backup or app consistent.
    :vartype recovery_point_type: str
    :ivar recovery_point_time: Time at which this backup copy was created.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar file_share_snapshot_uri: Contains Url to the snapshot of fileshare, if applicable.
    :vartype file_share_snapshot_uri: str
    :ivar recovery_point_size_in_gb: Contains recovery point size.
    :vartype recovery_point_size_in_gb: int
    """

    _validation = {
        "object_type": {"required": True},
        "recovery_point_type": {"readonly": True},
        "recovery_point_time": {"readonly": True},
        "file_share_snapshot_uri": {"readonly": True},
        "recovery_point_size_in_gb": {"readonly": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "recovery_point_time": {"key": "recoveryPointTime", "type": "iso-8601"},
        "file_share_snapshot_uri": {"key": "fileShareSnapshotUri", "type": "str"},
        "recovery_point_size_in_gb": {"key": "recoveryPointSizeInGB", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_type: str = "AzureFileShareRecoveryPoint"
        self.recovery_point_type = None
        self.recovery_point_time = None
        self.file_share_snapshot_uri = None
        self.recovery_point_size_in_gb = None


class RestoreRequest(_serialization.Model):
    """Base class for restore request. Workload-specific restore requests are derived from this class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFileShareRestoreRequest, AzureWorkloadRestoreRequest, IaasVMRestoreRequest

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "AzureFileShareRestoreRequest": "AzureFileShareRestoreRequest",
            "AzureWorkloadRestoreRequest": "AzureWorkloadRestoreRequest",
            "IaasVMRestoreRequest": "IaasVMRestoreRequest",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None


class AzureFileShareRestoreRequest(RestoreRequest):
    """AzureFileShare Restore Request.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
    :ivar source_resource_id: Source storage account ARM Id.
    :vartype source_resource_id: str
    :ivar copy_options: Options to resolve copy conflicts. Known values are: "Invalid",
     "CreateCopy", "Skip", "Overwrite", and "FailOnConflict".
    :vartype copy_options: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CopyOptions
    :ivar restore_request_type: Restore Type (FullShareRestore or ItemLevelRestore). Known values
     are: "Invalid", "FullShareRestore", and "ItemLevelRestore".
    :vartype restore_request_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestoreRequestType
    :ivar restore_file_specs: List of Source Files/Folders(which need to recover) and
     TargetFolderPath details.
    :vartype restore_file_specs:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestoreFileSpecs]
    :ivar target_details: Target File Share Details.
    :vartype target_details:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetAFSRestoreInfo
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "copy_options": {"key": "copyOptions", "type": "str"},
        "restore_request_type": {"key": "restoreRequestType", "type": "str"},
        "restore_file_specs": {"key": "restoreFileSpecs", "type": "[RestoreFileSpecs]"},
        "target_details": {"key": "targetDetails", "type": "TargetAFSRestoreInfo"},
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        copy_options: Optional[Union[str, "_models.CopyOptions"]] = None,
        restore_request_type: Optional[Union[str, "_models.RestoreRequestType"]] = None,
        restore_file_specs: Optional[List["_models.RestoreFileSpecs"]] = None,
        target_details: Optional["_models.TargetAFSRestoreInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
        :keyword source_resource_id: Source storage account ARM Id.
        :paramtype source_resource_id: str
        :keyword copy_options: Options to resolve copy conflicts. Known values are: "Invalid",
         "CreateCopy", "Skip", "Overwrite", and "FailOnConflict".
        :paramtype copy_options: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CopyOptions
        :keyword restore_request_type: Restore Type (FullShareRestore or ItemLevelRestore). Known
         values are: "Invalid", "FullShareRestore", and "ItemLevelRestore".
        :paramtype restore_request_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestoreRequestType
        :keyword restore_file_specs: List of Source Files/Folders(which need to recover) and
         TargetFolderPath details.
        :paramtype restore_file_specs:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestoreFileSpecs]
        :keyword target_details: Target File Share Details.
        :paramtype target_details:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetAFSRestoreInfo
        """
        super().__init__(**kwargs)
        self.object_type: str = "AzureFileShareRestoreRequest"
        self.recovery_type = recovery_type
        self.source_resource_id = source_resource_id
        self.copy_options = copy_options
        self.restore_request_type = restore_request_type
        self.restore_file_specs = restore_file_specs
        self.target_details = target_details


class AzureIaaSVMProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """IaaS VM workload-specific backup item.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureIaaSClassicComputeVMProtectedItem, AzureIaaSComputeVMProtectedItem

    All required parameters must be populated in order to send to server.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar friendly_name: Friendly name of the VM represented by this backup item.
    :vartype friendly_name: str
    :ivar virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this
     item.
    :vartype virtual_machine_id: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
    :ivar health_status: Health status of protected item. Known values are: "Passed",
     "ActionRequired", "ActionSuggested", and "Invalid".
    :vartype health_status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.HealthStatus
    :ivar health_details: Health details on this backup item.
    :vartype health_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMHealthDetails]
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
    :ivar last_backup_status: Last backup operation status.
    :vartype last_backup_status: str
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar protected_item_data_id: Data ID of the protected item.
    :vartype protected_item_data_id: str
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMProtectedItemExtendedInfo
    :ivar extended_properties: Extended Properties for Azure IaasVM Backup.
    :vartype extended_properties:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ExtendedProperties
    """

    _validation = {
        "protected_item_type": {"required": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "health_details": {"key": "healthDetails", "type": "[AzureIaaSVMHealthDetails]"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "protected_item_data_id": {"key": "protectedItemDataId", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureIaaSVMProtectedItemExtendedInfo"},
        "extended_properties": {"key": "extendedProperties", "type": "ExtendedProperties"},
    }

    _subtype_map = {
        "protected_item_type": {
            "Microsoft.ClassicCompute/virtualMachines": "AzureIaaSClassicComputeVMProtectedItem",
            "Microsoft.Compute/virtualMachines": "AzureIaaSComputeVMProtectedItem",
        }
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        friendly_name: Optional[str] = None,
        virtual_machine_id: Optional[str] = None,
        protection_status: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        health_status: Optional[Union[str, "_models.HealthStatus"]] = None,
        health_details: Optional[List["_models.AzureIaaSVMHealthDetails"]] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        last_backup_status: Optional[str] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        protected_item_data_id: Optional[str] = None,
        extended_info: Optional["_models.AzureIaaSVMProtectedItemExtendedInfo"] = None,
        extended_properties: Optional["_models.ExtendedProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword workload_type: Type of workload this item represents. Known values are: "Invalid",
         "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword friendly_name: Friendly name of the VM represented by this backup item.
        :paramtype friendly_name: str
        :keyword virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this
         item.
        :paramtype virtual_machine_id: str
        :keyword protection_status: Backup status of this backup item.
        :paramtype protection_status: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
        :keyword health_status: Health status of protected item. Known values are: "Passed",
         "ActionRequired", "ActionSuggested", and "Invalid".
        :paramtype health_status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.HealthStatus
        :keyword health_details: Health details on this backup item.
        :paramtype health_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMHealthDetails]
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
        :keyword last_backup_status: Last backup operation status.
        :paramtype last_backup_status: str
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword protected_item_data_id: Data ID of the protected item.
        :paramtype protected_item_data_id: str
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMProtectedItemExtendedInfo
        :keyword extended_properties: Extended Properties for Azure IaasVM Backup.
        :paramtype extended_properties:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ExtendedProperties
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            **kwargs
        )
        self.protected_item_type: str = "AzureIaaSVMProtectedItem"
        self.friendly_name = friendly_name
        self.virtual_machine_id = virtual_machine_id
        self.protection_status = protection_status
        self.protection_state = protection_state
        self.health_status = health_status
        self.health_details = health_details
        self.kpis_healths = kpis_healths
        self.last_backup_status = last_backup_status
        self.last_backup_time = last_backup_time
        self.protected_item_data_id = protected_item_data_id
        self.extended_info = extended_info
        self.extended_properties = extended_properties


class AzureIaaSClassicComputeVMProtectedItem(AzureIaaSVMProtectedItem):  # pylint: disable=too-many-instance-attributes
    """IaaS VM workload-specific backup item representing the Classic Compute VM.

    All required parameters must be populated in order to send to server.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar friendly_name: Friendly name of the VM represented by this backup item.
    :vartype friendly_name: str
    :ivar virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this
     item.
    :vartype virtual_machine_id: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
    :ivar health_status: Health status of protected item. Known values are: "Passed",
     "ActionRequired", "ActionSuggested", and "Invalid".
    :vartype health_status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.HealthStatus
    :ivar health_details: Health details on this backup item.
    :vartype health_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMHealthDetails]
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
    :ivar last_backup_status: Last backup operation status.
    :vartype last_backup_status: str
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar protected_item_data_id: Data ID of the protected item.
    :vartype protected_item_data_id: str
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMProtectedItemExtendedInfo
    :ivar extended_properties: Extended Properties for Azure IaasVM Backup.
    :vartype extended_properties:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ExtendedProperties
    """

    _validation = {
        "protected_item_type": {"required": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "health_details": {"key": "healthDetails", "type": "[AzureIaaSVMHealthDetails]"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "protected_item_data_id": {"key": "protectedItemDataId", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureIaaSVMProtectedItemExtendedInfo"},
        "extended_properties": {"key": "extendedProperties", "type": "ExtendedProperties"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        friendly_name: Optional[str] = None,
        virtual_machine_id: Optional[str] = None,
        protection_status: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        health_status: Optional[Union[str, "_models.HealthStatus"]] = None,
        health_details: Optional[List["_models.AzureIaaSVMHealthDetails"]] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        last_backup_status: Optional[str] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        protected_item_data_id: Optional[str] = None,
        extended_info: Optional["_models.AzureIaaSVMProtectedItemExtendedInfo"] = None,
        extended_properties: Optional["_models.ExtendedProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword workload_type: Type of workload this item represents. Known values are: "Invalid",
         "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword friendly_name: Friendly name of the VM represented by this backup item.
        :paramtype friendly_name: str
        :keyword virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this
         item.
        :paramtype virtual_machine_id: str
        :keyword protection_status: Backup status of this backup item.
        :paramtype protection_status: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
        :keyword health_status: Health status of protected item. Known values are: "Passed",
         "ActionRequired", "ActionSuggested", and "Invalid".
        :paramtype health_status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.HealthStatus
        :keyword health_details: Health details on this backup item.
        :paramtype health_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMHealthDetails]
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
        :keyword last_backup_status: Last backup operation status.
        :paramtype last_backup_status: str
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword protected_item_data_id: Data ID of the protected item.
        :paramtype protected_item_data_id: str
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMProtectedItemExtendedInfo
        :keyword extended_properties: Extended Properties for Azure IaasVM Backup.
        :paramtype extended_properties:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ExtendedProperties
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            friendly_name=friendly_name,
            virtual_machine_id=virtual_machine_id,
            protection_status=protection_status,
            protection_state=protection_state,
            health_status=health_status,
            health_details=health_details,
            kpis_healths=kpis_healths,
            last_backup_status=last_backup_status,
            last_backup_time=last_backup_time,
            protected_item_data_id=protected_item_data_id,
            extended_info=extended_info,
            extended_properties=extended_properties,
            **kwargs
        )
        self.protected_item_type: str = "Microsoft.ClassicCompute/virtualMachines"


class AzureIaaSComputeVMProtectedItem(AzureIaaSVMProtectedItem):  # pylint: disable=too-many-instance-attributes
    """IaaS VM workload-specific backup item representing the Azure Resource Manager VM.

    All required parameters must be populated in order to send to server.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar friendly_name: Friendly name of the VM represented by this backup item.
    :vartype friendly_name: str
    :ivar virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this
     item.
    :vartype virtual_machine_id: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
    :ivar health_status: Health status of protected item. Known values are: "Passed",
     "ActionRequired", "ActionSuggested", and "Invalid".
    :vartype health_status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.HealthStatus
    :ivar health_details: Health details on this backup item.
    :vartype health_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMHealthDetails]
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
    :ivar last_backup_status: Last backup operation status.
    :vartype last_backup_status: str
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar protected_item_data_id: Data ID of the protected item.
    :vartype protected_item_data_id: str
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMProtectedItemExtendedInfo
    :ivar extended_properties: Extended Properties for Azure IaasVM Backup.
    :vartype extended_properties:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ExtendedProperties
    """

    _validation = {
        "protected_item_type": {"required": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "health_details": {"key": "healthDetails", "type": "[AzureIaaSVMHealthDetails]"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "protected_item_data_id": {"key": "protectedItemDataId", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureIaaSVMProtectedItemExtendedInfo"},
        "extended_properties": {"key": "extendedProperties", "type": "ExtendedProperties"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        friendly_name: Optional[str] = None,
        virtual_machine_id: Optional[str] = None,
        protection_status: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        health_status: Optional[Union[str, "_models.HealthStatus"]] = None,
        health_details: Optional[List["_models.AzureIaaSVMHealthDetails"]] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        last_backup_status: Optional[str] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        protected_item_data_id: Optional[str] = None,
        extended_info: Optional["_models.AzureIaaSVMProtectedItemExtendedInfo"] = None,
        extended_properties: Optional["_models.ExtendedProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword workload_type: Type of workload this item represents. Known values are: "Invalid",
         "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword friendly_name: Friendly name of the VM represented by this backup item.
        :paramtype friendly_name: str
        :keyword virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this
         item.
        :paramtype virtual_machine_id: str
        :keyword protection_status: Backup status of this backup item.
        :paramtype protection_status: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
        :keyword health_status: Health status of protected item. Known values are: "Passed",
         "ActionRequired", "ActionSuggested", and "Invalid".
        :paramtype health_status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.HealthStatus
        :keyword health_details: Health details on this backup item.
        :paramtype health_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMHealthDetails]
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
        :keyword last_backup_status: Last backup operation status.
        :paramtype last_backup_status: str
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword protected_item_data_id: Data ID of the protected item.
        :paramtype protected_item_data_id: str
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMProtectedItemExtendedInfo
        :keyword extended_properties: Extended Properties for Azure IaasVM Backup.
        :paramtype extended_properties:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ExtendedProperties
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            friendly_name=friendly_name,
            virtual_machine_id=virtual_machine_id,
            protection_status=protection_status,
            protection_state=protection_state,
            health_status=health_status,
            health_details=health_details,
            kpis_healths=kpis_healths,
            last_backup_status=last_backup_status,
            last_backup_time=last_backup_time,
            protected_item_data_id=protected_item_data_id,
            extended_info=extended_info,
            extended_properties=extended_properties,
            **kwargs
        )
        self.protected_item_type: str = "Microsoft.Compute/virtualMachines"


class AzureIaaSVMErrorInfo(_serialization.Model):
    """Azure IaaS VM workload-specific error information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: Error code.
    :vartype error_code: int
    :ivar error_title: Title: Typically, the entity that the error pertains to.
    :vartype error_title: str
    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar recommendations: List of localized recommendations for above error code.
    :vartype recommendations: list[str]
    """

    _validation = {
        "error_code": {"readonly": True},
        "error_title": {"readonly": True},
        "error_string": {"readonly": True},
        "recommendations": {"readonly": True},
    }

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "int"},
        "error_title": {"key": "errorTitle", "type": "str"},
        "error_string": {"key": "errorString", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error_code = None
        self.error_title = None
        self.error_string = None
        self.recommendations = None


class ResourceHealthDetails(_serialization.Model):
    """Health Details for backup items.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Health Code.
    :vartype code: int
    :ivar title: Health Title.
    :vartype title: str
    :ivar message: Health Message.
    :vartype message: str
    :ivar recommendations: Health Recommended Actions.
    :vartype recommendations: list[str]
    """

    _validation = {
        "code": {"readonly": True},
        "title": {"readonly": True},
        "message": {"readonly": True},
        "recommendations": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "int"},
        "title": {"key": "title", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.title = None
        self.message = None
        self.recommendations = None


class AzureIaaSVMHealthDetails(ResourceHealthDetails):
    """Azure IaaS VM workload-specific Health Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Health Code.
    :vartype code: int
    :ivar title: Health Title.
    :vartype title: str
    :ivar message: Health Message.
    :vartype message: str
    :ivar recommendations: Health Recommended Actions.
    :vartype recommendations: list[str]
    """


class Job(_serialization.Model):
    """Defines workload agnostic properties for a job.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureIaaSVMJob, AzureStorageJob, AzureWorkloadJob, DpmJob, MabJob

    All required parameters must be populated in order to send to server.

    :ivar entity_friendly_name: Friendly name of the entity on which the current job is executing.
    :vartype entity_friendly_name: str
    :ivar backup_management_type: Backup management type to execute the current job. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar status: Job status.
    :vartype status: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar activity_id: ActivityId of job.
    :vartype activity_id: str
    :ivar job_type: This property will be used as the discriminator for deciding the specific types
     in the polymorphic chain of types. Required.
    :vartype job_type: str
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "entity_friendly_name": {"key": "entityFriendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "activity_id": {"key": "activityId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
    }

    _subtype_map = {
        "job_type": {
            "AzureIaaSVMJob": "AzureIaaSVMJob",
            "AzureStorageJob": "AzureStorageJob",
            "AzureWorkloadJob": "AzureWorkloadJob",
            "DpmJob": "DpmJob",
            "MabJob": "MabJob",
        }
    }

    def __init__(
        self,
        *,
        entity_friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        activity_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity_friendly_name: Friendly name of the entity on which the current job is
         executing.
        :paramtype entity_friendly_name: str
        :keyword backup_management_type: Backup management type to execute the current job. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword operation: The operation name.
        :paramtype operation: str
        :keyword status: Job status.
        :paramtype status: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword activity_id: ActivityId of job.
        :paramtype activity_id: str
        """
        super().__init__(**kwargs)
        self.entity_friendly_name = entity_friendly_name
        self.backup_management_type = backup_management_type
        self.operation = operation
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.activity_id = activity_id
        self.job_type: Optional[str] = None


class AzureIaaSVMJob(Job):  # pylint: disable=too-many-instance-attributes
    """Azure IaaS VM workload-specific job object.

    All required parameters must be populated in order to send to server.

    :ivar entity_friendly_name: Friendly name of the entity on which the current job is executing.
    :vartype entity_friendly_name: str
    :ivar backup_management_type: Backup management type to execute the current job. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar status: Job status.
    :vartype status: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar activity_id: ActivityId of job.
    :vartype activity_id: str
    :ivar job_type: This property will be used as the discriminator for deciding the specific types
     in the polymorphic chain of types. Required.
    :vartype job_type: str
    :ivar duration: Time elapsed during the execution of this job.
    :vartype duration: ~datetime.timedelta
    :ivar actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
    :vartype actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobSupportedAction]
    :ivar error_details: Error details on execution of this job.
    :vartype error_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMErrorInfo]
    :ivar virtual_machine_version: Specifies whether the backup item is a Classic or an Azure
     Resource Manager VM.
    :vartype virtual_machine_version: str
    :ivar extended_info: Additional information for this job.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMJobExtendedInfo
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "entity_friendly_name": {"key": "entityFriendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "activity_id": {"key": "activityId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "actions_info": {"key": "actionsInfo", "type": "[str]"},
        "error_details": {"key": "errorDetails", "type": "[AzureIaaSVMErrorInfo]"},
        "virtual_machine_version": {"key": "virtualMachineVersion", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureIaaSVMJobExtendedInfo"},
    }

    def __init__(
        self,
        *,
        entity_friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        activity_id: Optional[str] = None,
        duration: Optional[datetime.timedelta] = None,
        actions_info: Optional[List[Union[str, "_models.JobSupportedAction"]]] = None,
        error_details: Optional[List["_models.AzureIaaSVMErrorInfo"]] = None,
        virtual_machine_version: Optional[str] = None,
        extended_info: Optional["_models.AzureIaaSVMJobExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity_friendly_name: Friendly name of the entity on which the current job is
         executing.
        :paramtype entity_friendly_name: str
        :keyword backup_management_type: Backup management type to execute the current job. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword operation: The operation name.
        :paramtype operation: str
        :keyword status: Job status.
        :paramtype status: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword activity_id: ActivityId of job.
        :paramtype activity_id: str
        :keyword duration: Time elapsed during the execution of this job.
        :paramtype duration: ~datetime.timedelta
        :keyword actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
        :paramtype actions_info: list[str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobSupportedAction]
        :keyword error_details: Error details on execution of this job.
        :paramtype error_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMErrorInfo]
        :keyword virtual_machine_version: Specifies whether the backup item is a Classic or an Azure
         Resource Manager VM.
        :paramtype virtual_machine_version: str
        :keyword extended_info: Additional information for this job.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMJobExtendedInfo
        """
        super().__init__(
            entity_friendly_name=entity_friendly_name,
            backup_management_type=backup_management_type,
            operation=operation,
            status=status,
            start_time=start_time,
            end_time=end_time,
            activity_id=activity_id,
            **kwargs
        )
        self.job_type: str = "AzureIaaSVMJob"
        self.duration = duration
        self.actions_info = actions_info
        self.error_details = error_details
        self.virtual_machine_version = virtual_machine_version
        self.extended_info = extended_info


class AzureIaaSVMJobExtendedInfo(_serialization.Model):
    """Azure IaaS VM workload-specific additional information for job.

    :ivar tasks_list: List of tasks associated with this job.
    :vartype tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMJobTaskDetails]
    :ivar property_bag: Job properties.
    :vartype property_bag: dict[str, str]
    :ivar internal_property_bag: Job internal properties.
    :vartype internal_property_bag: dict[str, str]
    :ivar progress_percentage: Indicates progress of the job. Null if it has not started or
     completed.
    :vartype progress_percentage: float
    :ivar estimated_remaining_duration: Time remaining for execution of this job.
    :vartype estimated_remaining_duration: str
    :ivar dynamic_error_message: Non localized error message on job execution.
    :vartype dynamic_error_message: str
    """

    _attribute_map = {
        "tasks_list": {"key": "tasksList", "type": "[AzureIaaSVMJobTaskDetails]"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "internal_property_bag": {"key": "internalPropertyBag", "type": "{str}"},
        "progress_percentage": {"key": "progressPercentage", "type": "float"},
        "estimated_remaining_duration": {"key": "estimatedRemainingDuration", "type": "str"},
        "dynamic_error_message": {"key": "dynamicErrorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        tasks_list: Optional[List["_models.AzureIaaSVMJobTaskDetails"]] = None,
        property_bag: Optional[Dict[str, str]] = None,
        internal_property_bag: Optional[Dict[str, str]] = None,
        progress_percentage: Optional[float] = None,
        estimated_remaining_duration: Optional[str] = None,
        dynamic_error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tasks_list: List of tasks associated with this job.
        :paramtype tasks_list:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureIaaSVMJobTaskDetails]
        :keyword property_bag: Job properties.
        :paramtype property_bag: dict[str, str]
        :keyword internal_property_bag: Job internal properties.
        :paramtype internal_property_bag: dict[str, str]
        :keyword progress_percentage: Indicates progress of the job. Null if it has not started or
         completed.
        :paramtype progress_percentage: float
        :keyword estimated_remaining_duration: Time remaining for execution of this job.
        :paramtype estimated_remaining_duration: str
        :keyword dynamic_error_message: Non localized error message on job execution.
        :paramtype dynamic_error_message: str
        """
        super().__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.internal_property_bag = internal_property_bag
        self.progress_percentage = progress_percentage
        self.estimated_remaining_duration = estimated_remaining_duration
        self.dynamic_error_message = dynamic_error_message


class AzureIaaSVMJobTaskDetails(_serialization.Model):
    """Azure IaaS VM workload-specific job task details.

    :ivar task_id: The task display name.
    :vartype task_id: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar instance_id: The instanceId.
    :vartype instance_id: str
    :ivar duration: Time elapsed for task.
    :vartype duration: ~datetime.timedelta
    :ivar status: The status.
    :vartype status: str
    :ivar progress_percentage: Progress of the task.
    :vartype progress_percentage: float
    :ivar task_execution_details: Details about execution of the task.
     eg: number of bytes transferred etc.
    :vartype task_execution_details: str
    """

    _attribute_map = {
        "task_id": {"key": "taskId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "instance_id": {"key": "instanceId", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "status": {"key": "status", "type": "str"},
        "progress_percentage": {"key": "progressPercentage", "type": "float"},
        "task_execution_details": {"key": "taskExecutionDetails", "type": "str"},
    }

    def __init__(
        self,
        *,
        task_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        instance_id: Optional[str] = None,
        duration: Optional[datetime.timedelta] = None,
        status: Optional[str] = None,
        progress_percentage: Optional[float] = None,
        task_execution_details: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword task_id: The task display name.
        :paramtype task_id: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword instance_id: The instanceId.
        :paramtype instance_id: str
        :keyword duration: Time elapsed for task.
        :paramtype duration: ~datetime.timedelta
        :keyword status: The status.
        :paramtype status: str
        :keyword progress_percentage: Progress of the task.
        :paramtype progress_percentage: float
        :keyword task_execution_details: Details about execution of the task.
         eg: number of bytes transferred etc.
        :paramtype task_execution_details: str
        """
        super().__init__(**kwargs)
        self.task_id = task_id
        self.start_time = start_time
        self.end_time = end_time
        self.instance_id = instance_id
        self.duration = duration
        self.status = status
        self.progress_percentage = progress_percentage
        self.task_execution_details = task_execution_details


class AzureIaaSVMProtectedItemExtendedInfo(_serialization.Model):
    """Additional information on Azure IaaS VM specific backup item.

    :ivar oldest_recovery_point: The oldest backup copy available for this backup item.
    :vartype oldest_recovery_point: ~datetime.datetime
    :ivar recovery_point_count: Number of backup copies available for this backup item.
    :vartype recovery_point_count: int
    :ivar policy_inconsistent: Specifies if backup policy associated with the backup item is
     inconsistent.
    :vartype policy_inconsistent: bool
    """

    _attribute_map = {
        "oldest_recovery_point": {"key": "oldestRecoveryPoint", "type": "iso-8601"},
        "recovery_point_count": {"key": "recoveryPointCount", "type": "int"},
        "policy_inconsistent": {"key": "policyInconsistent", "type": "bool"},
    }

    def __init__(
        self,
        *,
        oldest_recovery_point: Optional[datetime.datetime] = None,
        recovery_point_count: Optional[int] = None,
        policy_inconsistent: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword oldest_recovery_point: The oldest backup copy available for this backup item.
        :paramtype oldest_recovery_point: ~datetime.datetime
        :keyword recovery_point_count: Number of backup copies available for this backup item.
        :paramtype recovery_point_count: int
        :keyword policy_inconsistent: Specifies if backup policy associated with the backup item is
         inconsistent.
        :paramtype policy_inconsistent: bool
        """
        super().__init__(**kwargs)
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.policy_inconsistent = policy_inconsistent


class AzureSqlProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """Azure SQL workload-specific backup item.

    All required parameters must be populated in order to send to server.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar protected_item_data_id: Internal ID of a backup item. Used by Azure SQL Backup engine to
     contact Recovery Services.
    :vartype protected_item_data_id: str
    :ivar protection_state: Backup state of the backed up item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemState
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureSqlProtectedItemExtendedInfo
    """

    _validation = {
        "protected_item_type": {"required": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "protected_item_data_id": {"key": "protectedItemDataId", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureSqlProtectedItemExtendedInfo"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        protected_item_data_id: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectedItemState"]] = None,
        extended_info: Optional["_models.AzureSqlProtectedItemExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword workload_type: Type of workload this item represents. Known values are: "Invalid",
         "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword protected_item_data_id: Internal ID of a backup item. Used by Azure SQL Backup engine
         to contact Recovery Services.
        :paramtype protected_item_data_id: str
        :keyword protection_state: Backup state of the backed up item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemState
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureSqlProtectedItemExtendedInfo
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            **kwargs
        )
        self.protected_item_type: str = "Microsoft.Sql/servers/databases"
        self.protected_item_data_id = protected_item_data_id
        self.protection_state = protection_state
        self.extended_info = extended_info


class AzureSqlProtectedItemExtendedInfo(_serialization.Model):
    """Additional information on Azure Sql specific protected item.

    :ivar oldest_recovery_point: The oldest backup copy available for this item in the service.
    :vartype oldest_recovery_point: ~datetime.datetime
    :ivar recovery_point_count: Number of available backup copies associated with this backup item.
    :vartype recovery_point_count: int
    :ivar policy_state: State of the backup policy associated with this backup item.
    :vartype policy_state: str
    """

    _attribute_map = {
        "oldest_recovery_point": {"key": "oldestRecoveryPoint", "type": "iso-8601"},
        "recovery_point_count": {"key": "recoveryPointCount", "type": "int"},
        "policy_state": {"key": "policyState", "type": "str"},
    }

    def __init__(
        self,
        *,
        oldest_recovery_point: Optional[datetime.datetime] = None,
        recovery_point_count: Optional[int] = None,
        policy_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword oldest_recovery_point: The oldest backup copy available for this item in the service.
        :paramtype oldest_recovery_point: ~datetime.datetime
        :keyword recovery_point_count: Number of available backup copies associated with this backup
         item.
        :paramtype recovery_point_count: int
        :keyword policy_state: State of the backup policy associated with this backup item.
        :paramtype policy_state: str
        """
        super().__init__(**kwargs)
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.policy_state = policy_state


class AzureStorageErrorInfo(_serialization.Model):
    """Azure storage specific error information.

    :ivar error_code: Error code.
    :vartype error_code: int
    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar recommendations: List of localized recommendations for above error code.
    :vartype recommendations: list[str]
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "int"},
        "error_string": {"key": "errorString", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        error_code: Optional[int] = None,
        error_string: Optional[str] = None,
        recommendations: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_code: Error code.
        :paramtype error_code: int
        :keyword error_string: Localized error string.
        :paramtype error_string: str
        :keyword recommendations: List of localized recommendations for above error code.
        :paramtype recommendations: list[str]
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.error_string = error_string
        self.recommendations = recommendations


class AzureStorageJob(Job):  # pylint: disable=too-many-instance-attributes
    """Azure storage specific job.

    All required parameters must be populated in order to send to server.

    :ivar entity_friendly_name: Friendly name of the entity on which the current job is executing.
    :vartype entity_friendly_name: str
    :ivar backup_management_type: Backup management type to execute the current job. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar status: Job status.
    :vartype status: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar activity_id: ActivityId of job.
    :vartype activity_id: str
    :ivar job_type: This property will be used as the discriminator for deciding the specific types
     in the polymorphic chain of types. Required.
    :vartype job_type: str
    :ivar duration: Time elapsed during the execution of this job.
    :vartype duration: ~datetime.timedelta
    :ivar actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
    :vartype actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobSupportedAction]
    :ivar error_details: Error details on execution of this job.
    :vartype error_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureStorageErrorInfo]
    :ivar storage_account_name: Specifies friendly name of the storage account.
    :vartype storage_account_name: str
    :ivar storage_account_version: Specifies whether the Storage account is a Classic or an Azure
     Resource Manager Storage account.
    :vartype storage_account_version: str
    :ivar extended_info: Additional information about the job.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureStorageJobExtendedInfo
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "entity_friendly_name": {"key": "entityFriendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "activity_id": {"key": "activityId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "actions_info": {"key": "actionsInfo", "type": "[str]"},
        "error_details": {"key": "errorDetails", "type": "[AzureStorageErrorInfo]"},
        "storage_account_name": {"key": "storageAccountName", "type": "str"},
        "storage_account_version": {"key": "storageAccountVersion", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureStorageJobExtendedInfo"},
    }

    def __init__(
        self,
        *,
        entity_friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        activity_id: Optional[str] = None,
        duration: Optional[datetime.timedelta] = None,
        actions_info: Optional[List[Union[str, "_models.JobSupportedAction"]]] = None,
        error_details: Optional[List["_models.AzureStorageErrorInfo"]] = None,
        storage_account_name: Optional[str] = None,
        storage_account_version: Optional[str] = None,
        extended_info: Optional["_models.AzureStorageJobExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity_friendly_name: Friendly name of the entity on which the current job is
         executing.
        :paramtype entity_friendly_name: str
        :keyword backup_management_type: Backup management type to execute the current job. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword operation: The operation name.
        :paramtype operation: str
        :keyword status: Job status.
        :paramtype status: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword activity_id: ActivityId of job.
        :paramtype activity_id: str
        :keyword duration: Time elapsed during the execution of this job.
        :paramtype duration: ~datetime.timedelta
        :keyword actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
        :paramtype actions_info: list[str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobSupportedAction]
        :keyword error_details: Error details on execution of this job.
        :paramtype error_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureStorageErrorInfo]
        :keyword storage_account_name: Specifies friendly name of the storage account.
        :paramtype storage_account_name: str
        :keyword storage_account_version: Specifies whether the Storage account is a Classic or an
         Azure Resource Manager Storage account.
        :paramtype storage_account_version: str
        :keyword extended_info: Additional information about the job.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureStorageJobExtendedInfo
        """
        super().__init__(
            entity_friendly_name=entity_friendly_name,
            backup_management_type=backup_management_type,
            operation=operation,
            status=status,
            start_time=start_time,
            end_time=end_time,
            activity_id=activity_id,
            **kwargs
        )
        self.job_type: str = "AzureStorageJob"
        self.duration = duration
        self.actions_info = actions_info
        self.error_details = error_details
        self.storage_account_name = storage_account_name
        self.storage_account_version = storage_account_version
        self.extended_info = extended_info


class AzureStorageJobExtendedInfo(_serialization.Model):
    """Azure Storage workload-specific additional information for job.

    :ivar tasks_list: List of tasks for this job.
    :vartype tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureStorageJobTaskDetails]
    :ivar property_bag: Job properties.
    :vartype property_bag: dict[str, str]
    :ivar dynamic_error_message: Non localized error message on job execution.
    :vartype dynamic_error_message: str
    """

    _attribute_map = {
        "tasks_list": {"key": "tasksList", "type": "[AzureStorageJobTaskDetails]"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "dynamic_error_message": {"key": "dynamicErrorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        tasks_list: Optional[List["_models.AzureStorageJobTaskDetails"]] = None,
        property_bag: Optional[Dict[str, str]] = None,
        dynamic_error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tasks_list: List of tasks for this job.
        :paramtype tasks_list:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureStorageJobTaskDetails]
        :keyword property_bag: Job properties.
        :paramtype property_bag: dict[str, str]
        :keyword dynamic_error_message: Non localized error message on job execution.
        :paramtype dynamic_error_message: str
        """
        super().__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.dynamic_error_message = dynamic_error_message


class AzureStorageJobTaskDetails(_serialization.Model):
    """Azure storage workload specific job task details.

    :ivar task_id: The task display name.
    :vartype task_id: str
    :ivar status: The status.
    :vartype status: str
    """

    _attribute_map = {
        "task_id": {"key": "taskId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, task_id: Optional[str] = None, status: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword task_id: The task display name.
        :paramtype task_id: str
        :keyword status: The status.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.task_id = task_id
        self.status = status


class AzureVmWorkloadProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protected item.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureVmWorkloadSAPAseDatabaseProtectedItem, AzureVmWorkloadSAPHanaDatabaseProtectedItem,
    AzureVmWorkloadSQLDatabaseProtectedItem

    All required parameters must be populated in order to send to server.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar friendly_name: Friendly name of the DB represented by this backup item.
    :vartype friendly_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar parent_name: Parent name of the DB such as Instance or Availability Group.
    :vartype parent_name: str
    :ivar parent_type: Parent type of protected item, example: for a DB, standalone server or
     distributed.
    :vartype parent_type: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
    :ivar last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
     Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
    :vartype last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.LastBackupStatus
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar last_backup_error_detail: Error details in last backup.
    :vartype last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ErrorDetail
    :ivar protected_item_data_source_id: Data ID of the protected item.
    :vartype protected_item_data_source_id: str
    :ivar protected_item_health_status: Health status of the backup item, evaluated based on last
     heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable", and
     "IRPending".
    :vartype protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemHealthStatus
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
    """

    _validation = {
        "protected_item_type": {"required": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_type": {"key": "parentType", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "last_backup_error_detail": {"key": "lastBackupErrorDetail", "type": "ErrorDetail"},
        "protected_item_data_source_id": {"key": "protectedItemDataSourceId", "type": "str"},
        "protected_item_health_status": {"key": "protectedItemHealthStatus", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureVmWorkloadProtectedItemExtendedInfo"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
    }

    _subtype_map = {
        "protected_item_type": {
            "AzureVmWorkloadSAPAseDatabase": "AzureVmWorkloadSAPAseDatabaseProtectedItem",
            "AzureVmWorkloadSAPHanaDatabase": "AzureVmWorkloadSAPHanaDatabaseProtectedItem",
            "AzureVmWorkloadSQLDatabase": "AzureVmWorkloadSQLDatabaseProtectedItem",
        }
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        friendly_name: Optional[str] = None,
        server_name: Optional[str] = None,
        parent_name: Optional[str] = None,
        parent_type: Optional[str] = None,
        protection_status: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        last_backup_status: Optional[Union[str, "_models.LastBackupStatus"]] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        last_backup_error_detail: Optional["_models.ErrorDetail"] = None,
        protected_item_data_source_id: Optional[str] = None,
        protected_item_health_status: Optional[Union[str, "_models.ProtectedItemHealthStatus"]] = None,
        extended_info: Optional["_models.AzureVmWorkloadProtectedItemExtendedInfo"] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword workload_type: Type of workload this item represents. Known values are: "Invalid",
         "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword friendly_name: Friendly name of the DB represented by this backup item.
        :paramtype friendly_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword parent_name: Parent name of the DB such as Instance or Availability Group.
        :paramtype parent_name: str
        :keyword parent_type: Parent type of protected item, example: for a DB, standalone server or
         distributed.
        :paramtype parent_type: str
        :keyword protection_status: Backup status of this backup item.
        :paramtype protection_status: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
        :keyword last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
         Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
        :paramtype last_backup_status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.LastBackupStatus
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword last_backup_error_detail: Error details in last backup.
        :paramtype last_backup_error_detail:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ErrorDetail
        :keyword protected_item_data_source_id: Data ID of the protected item.
        :paramtype protected_item_data_source_id: str
        :keyword protected_item_health_status: Health status of the backup item, evaluated based on
         last heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable",
         and "IRPending".
        :paramtype protected_item_health_status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemHealthStatus
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            **kwargs
        )
        self.protected_item_type: str = "AzureVmWorkloadProtectedItem"
        self.friendly_name = friendly_name
        self.server_name = server_name
        self.parent_name = parent_name
        self.parent_type = parent_type
        self.protection_status = protection_status
        self.protection_state = protection_state
        self.last_backup_status = last_backup_status
        self.last_backup_time = last_backup_time
        self.last_backup_error_detail = last_backup_error_detail
        self.protected_item_data_source_id = protected_item_data_source_id
        self.protected_item_health_status = protected_item_health_status
        self.extended_info = extended_info
        self.kpis_healths = kpis_healths


class AzureVmWorkloadProtectedItemExtendedInfo(_serialization.Model):
    """Additional information on Azure Workload for SQL specific backup item.

    :ivar oldest_recovery_point: The oldest backup copy available for this backup item.
    :vartype oldest_recovery_point: ~datetime.datetime
    :ivar recovery_point_count: Number of backup copies available for this backup item.
    :vartype recovery_point_count: int
    :ivar policy_state: Indicates consistency of policy object and policy applied to this backup
     item.
    :vartype policy_state: str
    """

    _attribute_map = {
        "oldest_recovery_point": {"key": "oldestRecoveryPoint", "type": "iso-8601"},
        "recovery_point_count": {"key": "recoveryPointCount", "type": "int"},
        "policy_state": {"key": "policyState", "type": "str"},
    }

    def __init__(
        self,
        *,
        oldest_recovery_point: Optional[datetime.datetime] = None,
        recovery_point_count: Optional[int] = None,
        policy_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword oldest_recovery_point: The oldest backup copy available for this backup item.
        :paramtype oldest_recovery_point: ~datetime.datetime
        :keyword recovery_point_count: Number of backup copies available for this backup item.
        :paramtype recovery_point_count: int
        :keyword policy_state: Indicates consistency of policy object and policy applied to this backup
         item.
        :paramtype policy_state: str
        """
        super().__init__(**kwargs)
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.policy_state = policy_state


class AzureVmWorkloadSAPAseDatabaseProtectedItem(
    AzureVmWorkloadProtectedItem
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Azure VM workload-specific protected item representing SAP ASE Database.

    All required parameters must be populated in order to send to server.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar friendly_name: Friendly name of the DB represented by this backup item.
    :vartype friendly_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar parent_name: Parent name of the DB such as Instance or Availability Group.
    :vartype parent_name: str
    :ivar parent_type: Parent type of protected item, example: for a DB, standalone server or
     distributed.
    :vartype parent_type: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
    :ivar last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
     Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
    :vartype last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.LastBackupStatus
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar last_backup_error_detail: Error details in last backup.
    :vartype last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ErrorDetail
    :ivar protected_item_data_source_id: Data ID of the protected item.
    :vartype protected_item_data_source_id: str
    :ivar protected_item_health_status: Health status of the backup item, evaluated based on last
     heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable", and
     "IRPending".
    :vartype protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemHealthStatus
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
    """

    _validation = {
        "protected_item_type": {"required": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_type": {"key": "parentType", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "last_backup_error_detail": {"key": "lastBackupErrorDetail", "type": "ErrorDetail"},
        "protected_item_data_source_id": {"key": "protectedItemDataSourceId", "type": "str"},
        "protected_item_health_status": {"key": "protectedItemHealthStatus", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureVmWorkloadProtectedItemExtendedInfo"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        friendly_name: Optional[str] = None,
        server_name: Optional[str] = None,
        parent_name: Optional[str] = None,
        parent_type: Optional[str] = None,
        protection_status: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        last_backup_status: Optional[Union[str, "_models.LastBackupStatus"]] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        last_backup_error_detail: Optional["_models.ErrorDetail"] = None,
        protected_item_data_source_id: Optional[str] = None,
        protected_item_health_status: Optional[Union[str, "_models.ProtectedItemHealthStatus"]] = None,
        extended_info: Optional["_models.AzureVmWorkloadProtectedItemExtendedInfo"] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword workload_type: Type of workload this item represents. Known values are: "Invalid",
         "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword friendly_name: Friendly name of the DB represented by this backup item.
        :paramtype friendly_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword parent_name: Parent name of the DB such as Instance or Availability Group.
        :paramtype parent_name: str
        :keyword parent_type: Parent type of protected item, example: for a DB, standalone server or
         distributed.
        :paramtype parent_type: str
        :keyword protection_status: Backup status of this backup item.
        :paramtype protection_status: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
        :keyword last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
         Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
        :paramtype last_backup_status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.LastBackupStatus
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword last_backup_error_detail: Error details in last backup.
        :paramtype last_backup_error_detail:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ErrorDetail
        :keyword protected_item_data_source_id: Data ID of the protected item.
        :paramtype protected_item_data_source_id: str
        :keyword protected_item_health_status: Health status of the backup item, evaluated based on
         last heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable",
         and "IRPending".
        :paramtype protected_item_health_status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemHealthStatus
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            friendly_name=friendly_name,
            server_name=server_name,
            parent_name=parent_name,
            parent_type=parent_type,
            protection_status=protection_status,
            protection_state=protection_state,
            last_backup_status=last_backup_status,
            last_backup_time=last_backup_time,
            last_backup_error_detail=last_backup_error_detail,
            protected_item_data_source_id=protected_item_data_source_id,
            protected_item_health_status=protected_item_health_status,
            extended_info=extended_info,
            kpis_healths=kpis_healths,
            **kwargs
        )
        self.protected_item_type: str = "AzureVmWorkloadSAPAseDatabase"


class AzureVmWorkloadSAPHanaDatabaseProtectedItem(
    AzureVmWorkloadProtectedItem
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Azure VM workload-specific protected item representing SAP HANA Database.

    All required parameters must be populated in order to send to server.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar friendly_name: Friendly name of the DB represented by this backup item.
    :vartype friendly_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar parent_name: Parent name of the DB such as Instance or Availability Group.
    :vartype parent_name: str
    :ivar parent_type: Parent type of protected item, example: for a DB, standalone server or
     distributed.
    :vartype parent_type: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
    :ivar last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
     Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
    :vartype last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.LastBackupStatus
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar last_backup_error_detail: Error details in last backup.
    :vartype last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ErrorDetail
    :ivar protected_item_data_source_id: Data ID of the protected item.
    :vartype protected_item_data_source_id: str
    :ivar protected_item_health_status: Health status of the backup item, evaluated based on last
     heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable", and
     "IRPending".
    :vartype protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemHealthStatus
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
    """

    _validation = {
        "protected_item_type": {"required": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_type": {"key": "parentType", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "last_backup_error_detail": {"key": "lastBackupErrorDetail", "type": "ErrorDetail"},
        "protected_item_data_source_id": {"key": "protectedItemDataSourceId", "type": "str"},
        "protected_item_health_status": {"key": "protectedItemHealthStatus", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureVmWorkloadProtectedItemExtendedInfo"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        friendly_name: Optional[str] = None,
        server_name: Optional[str] = None,
        parent_name: Optional[str] = None,
        parent_type: Optional[str] = None,
        protection_status: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        last_backup_status: Optional[Union[str, "_models.LastBackupStatus"]] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        last_backup_error_detail: Optional["_models.ErrorDetail"] = None,
        protected_item_data_source_id: Optional[str] = None,
        protected_item_health_status: Optional[Union[str, "_models.ProtectedItemHealthStatus"]] = None,
        extended_info: Optional["_models.AzureVmWorkloadProtectedItemExtendedInfo"] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword workload_type: Type of workload this item represents. Known values are: "Invalid",
         "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword friendly_name: Friendly name of the DB represented by this backup item.
        :paramtype friendly_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword parent_name: Parent name of the DB such as Instance or Availability Group.
        :paramtype parent_name: str
        :keyword parent_type: Parent type of protected item, example: for a DB, standalone server or
         distributed.
        :paramtype parent_type: str
        :keyword protection_status: Backup status of this backup item.
        :paramtype protection_status: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
        :keyword last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
         Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
        :paramtype last_backup_status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.LastBackupStatus
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword last_backup_error_detail: Error details in last backup.
        :paramtype last_backup_error_detail:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ErrorDetail
        :keyword protected_item_data_source_id: Data ID of the protected item.
        :paramtype protected_item_data_source_id: str
        :keyword protected_item_health_status: Health status of the backup item, evaluated based on
         last heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable",
         and "IRPending".
        :paramtype protected_item_health_status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemHealthStatus
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            friendly_name=friendly_name,
            server_name=server_name,
            parent_name=parent_name,
            parent_type=parent_type,
            protection_status=protection_status,
            protection_state=protection_state,
            last_backup_status=last_backup_status,
            last_backup_time=last_backup_time,
            last_backup_error_detail=last_backup_error_detail,
            protected_item_data_source_id=protected_item_data_source_id,
            protected_item_health_status=protected_item_health_status,
            extended_info=extended_info,
            kpis_healths=kpis_healths,
            **kwargs
        )
        self.protected_item_type: str = "AzureVmWorkloadSAPHanaDatabase"


class AzureVmWorkloadSQLDatabaseProtectedItem(
    AzureVmWorkloadProtectedItem
):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protected item representing SQL Database.

    All required parameters must be populated in order to send to server.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar friendly_name: Friendly name of the DB represented by this backup item.
    :vartype friendly_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar parent_name: Parent name of the DB such as Instance or Availability Group.
    :vartype parent_name: str
    :ivar parent_type: Parent type of protected item, example: for a DB, standalone server or
     distributed.
    :vartype parent_type: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
    :ivar last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
     Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
    :vartype last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.LastBackupStatus
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar last_backup_error_detail: Error details in last backup.
    :vartype last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ErrorDetail
    :ivar protected_item_data_source_id: Data ID of the protected item.
    :vartype protected_item_data_source_id: str
    :ivar protected_item_health_status: Health status of the backup item, evaluated based on last
     heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable", and
     "IRPending".
    :vartype protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemHealthStatus
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
    """

    _validation = {
        "protected_item_type": {"required": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_type": {"key": "parentType", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "last_backup_error_detail": {"key": "lastBackupErrorDetail", "type": "ErrorDetail"},
        "protected_item_data_source_id": {"key": "protectedItemDataSourceId", "type": "str"},
        "protected_item_health_status": {"key": "protectedItemHealthStatus", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureVmWorkloadProtectedItemExtendedInfo"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        friendly_name: Optional[str] = None,
        server_name: Optional[str] = None,
        parent_name: Optional[str] = None,
        parent_type: Optional[str] = None,
        protection_status: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        last_backup_status: Optional[Union[str, "_models.LastBackupStatus"]] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        last_backup_error_detail: Optional["_models.ErrorDetail"] = None,
        protected_item_data_source_id: Optional[str] = None,
        protected_item_health_status: Optional[Union[str, "_models.ProtectedItemHealthStatus"]] = None,
        extended_info: Optional["_models.AzureVmWorkloadProtectedItemExtendedInfo"] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword workload_type: Type of workload this item represents. Known values are: "Invalid",
         "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword friendly_name: Friendly name of the DB represented by this backup item.
        :paramtype friendly_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword parent_name: Parent name of the DB such as Instance or Availability Group.
        :paramtype parent_name: str
        :keyword parent_type: Parent type of protected item, example: for a DB, standalone server or
         distributed.
        :paramtype parent_type: str
        :keyword protection_status: Backup status of this backup item.
        :paramtype protection_status: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
        :keyword last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
         Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
        :paramtype last_backup_status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.LastBackupStatus
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword last_backup_error_detail: Error details in last backup.
        :paramtype last_backup_error_detail:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ErrorDetail
        :keyword protected_item_data_source_id: Data ID of the protected item.
        :paramtype protected_item_data_source_id: str
        :keyword protected_item_health_status: Health status of the backup item, evaluated based on
         last heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable",
         and "IRPending".
        :paramtype protected_item_health_status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemHealthStatus
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KPIResourceHealthDetails]
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            friendly_name=friendly_name,
            server_name=server_name,
            parent_name=parent_name,
            parent_type=parent_type,
            protection_status=protection_status,
            protection_state=protection_state,
            last_backup_status=last_backup_status,
            last_backup_time=last_backup_time,
            last_backup_error_detail=last_backup_error_detail,
            protected_item_data_source_id=protected_item_data_source_id,
            protected_item_health_status=protected_item_health_status,
            extended_info=extended_info,
            kpis_healths=kpis_healths,
            **kwargs
        )
        self.protected_item_type: str = "AzureVmWorkloadSQLDatabase"


class AzureWorkloadErrorInfo(_serialization.Model):
    """Azure storage specific error information.

    :ivar error_code: Error code.
    :vartype error_code: int
    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar error_title: Title: Typically, the entity that the error pertains to.
    :vartype error_title: str
    :ivar recommendations: List of localized recommendations for above error code.
    :vartype recommendations: list[str]
    :ivar additional_details: Additional details for above error code.
    :vartype additional_details: str
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "int"},
        "error_string": {"key": "errorString", "type": "str"},
        "error_title": {"key": "errorTitle", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
        "additional_details": {"key": "additionalDetails", "type": "str"},
    }

    def __init__(
        self,
        *,
        error_code: Optional[int] = None,
        error_string: Optional[str] = None,
        error_title: Optional[str] = None,
        recommendations: Optional[List[str]] = None,
        additional_details: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_code: Error code.
        :paramtype error_code: int
        :keyword error_string: Localized error string.
        :paramtype error_string: str
        :keyword error_title: Title: Typically, the entity that the error pertains to.
        :paramtype error_title: str
        :keyword recommendations: List of localized recommendations for above error code.
        :paramtype recommendations: list[str]
        :keyword additional_details: Additional details for above error code.
        :paramtype additional_details: str
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.error_string = error_string
        self.error_title = error_title
        self.recommendations = recommendations
        self.additional_details = additional_details


class AzureWorkloadJob(Job):  # pylint: disable=too-many-instance-attributes
    """Azure storage specific job.

    All required parameters must be populated in order to send to server.

    :ivar entity_friendly_name: Friendly name of the entity on which the current job is executing.
    :vartype entity_friendly_name: str
    :ivar backup_management_type: Backup management type to execute the current job. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar status: Job status.
    :vartype status: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar activity_id: ActivityId of job.
    :vartype activity_id: str
    :ivar job_type: This property will be used as the discriminator for deciding the specific types
     in the polymorphic chain of types. Required.
    :vartype job_type: str
    :ivar workload_type: Workload type of the job.
    :vartype workload_type: str
    :ivar duration: Time elapsed during the execution of this job.
    :vartype duration: ~datetime.timedelta
    :ivar actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
    :vartype actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobSupportedAction]
    :ivar error_details: Error details on execution of this job.
    :vartype error_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureWorkloadErrorInfo]
    :ivar extended_info: Additional information about the job.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureWorkloadJobExtendedInfo
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "entity_friendly_name": {"key": "entityFriendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "activity_id": {"key": "activityId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "actions_info": {"key": "actionsInfo", "type": "[str]"},
        "error_details": {"key": "errorDetails", "type": "[AzureWorkloadErrorInfo]"},
        "extended_info": {"key": "extendedInfo", "type": "AzureWorkloadJobExtendedInfo"},
    }

    def __init__(
        self,
        *,
        entity_friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        activity_id: Optional[str] = None,
        workload_type: Optional[str] = None,
        duration: Optional[datetime.timedelta] = None,
        actions_info: Optional[List[Union[str, "_models.JobSupportedAction"]]] = None,
        error_details: Optional[List["_models.AzureWorkloadErrorInfo"]] = None,
        extended_info: Optional["_models.AzureWorkloadJobExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity_friendly_name: Friendly name of the entity on which the current job is
         executing.
        :paramtype entity_friendly_name: str
        :keyword backup_management_type: Backup management type to execute the current job. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword operation: The operation name.
        :paramtype operation: str
        :keyword status: Job status.
        :paramtype status: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword activity_id: ActivityId of job.
        :paramtype activity_id: str
        :keyword workload_type: Workload type of the job.
        :paramtype workload_type: str
        :keyword duration: Time elapsed during the execution of this job.
        :paramtype duration: ~datetime.timedelta
        :keyword actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
        :paramtype actions_info: list[str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobSupportedAction]
        :keyword error_details: Error details on execution of this job.
        :paramtype error_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureWorkloadErrorInfo]
        :keyword extended_info: Additional information about the job.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureWorkloadJobExtendedInfo
        """
        super().__init__(
            entity_friendly_name=entity_friendly_name,
            backup_management_type=backup_management_type,
            operation=operation,
            status=status,
            start_time=start_time,
            end_time=end_time,
            activity_id=activity_id,
            **kwargs
        )
        self.job_type: str = "AzureWorkloadJob"
        self.workload_type = workload_type
        self.duration = duration
        self.actions_info = actions_info
        self.error_details = error_details
        self.extended_info = extended_info


class AzureWorkloadJobExtendedInfo(_serialization.Model):
    """Azure VM workload-specific additional information for job.

    :ivar tasks_list: List of tasks for this job.
    :vartype tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureWorkloadJobTaskDetails]
    :ivar property_bag: Job properties.
    :vartype property_bag: dict[str, str]
    :ivar dynamic_error_message: Non localized error message on job execution.
    :vartype dynamic_error_message: str
    """

    _attribute_map = {
        "tasks_list": {"key": "tasksList", "type": "[AzureWorkloadJobTaskDetails]"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "dynamic_error_message": {"key": "dynamicErrorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        tasks_list: Optional[List["_models.AzureWorkloadJobTaskDetails"]] = None,
        property_bag: Optional[Dict[str, str]] = None,
        dynamic_error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tasks_list: List of tasks for this job.
        :paramtype tasks_list:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureWorkloadJobTaskDetails]
        :keyword property_bag: Job properties.
        :paramtype property_bag: dict[str, str]
        :keyword dynamic_error_message: Non localized error message on job execution.
        :paramtype dynamic_error_message: str
        """
        super().__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.dynamic_error_message = dynamic_error_message


class AzureWorkloadJobTaskDetails(_serialization.Model):
    """Azure VM workload specific job task details.

    :ivar task_id: The task display name.
    :vartype task_id: str
    :ivar status: The status.
    :vartype status: str
    """

    _attribute_map = {
        "task_id": {"key": "taskId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, task_id: Optional[str] = None, status: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword task_id: The task display name.
        :paramtype task_id: str
        :keyword status: The status.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.task_id = task_id
        self.status = status


class AzureWorkloadRecoveryPoint(RecoveryPoint):
    """Workload specific recovery point, specifically encapsulates full/diff recovery point.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadPointInTimeRecoveryPoint, AzureWorkloadSAPHanaRecoveryPoint,
    AzureWorkloadSQLRecoveryPoint

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was created.
    :vartype recovery_point_time_in_utc: ~datetime.datetime
    :ivar type: Type of restore point. Known values are: "Invalid", "Full", "Log", "Differential",
     and "Incremental".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestorePointType
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
    """

    _validation = {
        "object_type": {"required": True},
        "recovery_point_time_in_utc": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_time_in_utc": {"key": "recoveryPointTimeInUTC", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformation]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
    }

    _subtype_map = {
        "object_type": {
            "AzureWorkloadPointInTimeRecoveryPoint": "AzureWorkloadPointInTimeRecoveryPoint",
            "AzureWorkloadSAPHanaRecoveryPoint": "AzureWorkloadSAPHanaRecoveryPoint",
            "AzureWorkloadSQLRecoveryPoint": "AzureWorkloadSQLRecoveryPoint",
        }
    }

    def __init__(
        self,
        *,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformation"]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
        """
        super().__init__(**kwargs)
        self.object_type: str = "AzureWorkloadRecoveryPoint"
        self.recovery_point_time_in_utc = None
        self.type = None
        self.recovery_point_tier_details = recovery_point_tier_details
        self.recovery_point_move_readiness_info = recovery_point_move_readiness_info


class AzureWorkloadPointInTimeRecoveryPoint(AzureWorkloadRecoveryPoint):
    """Recovery point specific to PointInTime.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadSAPHanaPointInTimeRecoveryPoint

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was created.
    :vartype recovery_point_time_in_utc: ~datetime.datetime
    :ivar type: Type of restore point. Known values are: "Invalid", "Full", "Log", "Differential",
     and "Incremental".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestorePointType
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
    :ivar time_ranges: List of log ranges.
    :vartype time_ranges:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.PointInTimeRange]
    """

    _validation = {
        "object_type": {"required": True},
        "recovery_point_time_in_utc": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_time_in_utc": {"key": "recoveryPointTimeInUTC", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformation]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
        "time_ranges": {"key": "timeRanges", "type": "[PointInTimeRange]"},
    }

    _subtype_map = {
        "object_type": {"AzureWorkloadSAPHanaPointInTimeRecoveryPoint": "AzureWorkloadSAPHanaPointInTimeRecoveryPoint"}
    }

    def __init__(
        self,
        *,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformation"]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        time_ranges: Optional[List["_models.PointInTimeRange"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
        :keyword time_ranges: List of log ranges.
        :paramtype time_ranges:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.PointInTimeRange]
        """
        super().__init__(
            recovery_point_tier_details=recovery_point_tier_details,
            recovery_point_move_readiness_info=recovery_point_move_readiness_info,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadPointInTimeRecoveryPoint"
        self.time_ranges = time_ranges


class AzureWorkloadRestoreRequest(RestoreRequest):
    """AzureWorkload-specific restore.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadPointInTimeRestoreRequest, AzureWorkloadSAPHanaRestoreRequest,
    AzureWorkloadSQLRestoreRequest

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "AzureWorkloadPointInTimeRestoreRequest": "AzureWorkloadPointInTimeRestoreRequest",
            "AzureWorkloadSAPHanaRestoreRequest": "AzureWorkloadSAPHanaRestoreRequest",
            "AzureWorkloadSQLRestoreRequest": "AzureWorkloadSQLRestoreRequest",
        }
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        """
        super().__init__(**kwargs)
        self.object_type: str = "AzureWorkloadRestoreRequest"
        self.recovery_type = recovery_type
        self.source_resource_id = source_resource_id
        self.property_bag = property_bag
        self.target_info = target_info
        self.recovery_mode = recovery_mode
        self.target_virtual_machine_id = target_virtual_machine_id


class AzureWorkloadPointInTimeRestoreRequest(AzureWorkloadRestoreRequest):
    """AzureWorkload SAP Hana -specific restore. Specifically for PointInTime/Log restore.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar point_in_time: PointInTime value.
    :vartype point_in_time: ~datetime.datetime
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "point_in_time": {"key": "pointInTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        point_in_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword point_in_time: PointInTime value.
        :paramtype point_in_time: ~datetime.datetime
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadPointInTimeRestoreRequest"
        self.point_in_time = point_in_time


class AzureWorkloadSAPHanaPointInTimeRecoveryPoint(
    AzureWorkloadPointInTimeRecoveryPoint
):  # pylint: disable=name-too-long
    """Recovery point specific to PointInTime in SAPHana.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was created.
    :vartype recovery_point_time_in_utc: ~datetime.datetime
    :ivar type: Type of restore point. Known values are: "Invalid", "Full", "Log", "Differential",
     and "Incremental".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestorePointType
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
    :ivar time_ranges: List of log ranges.
    :vartype time_ranges:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.PointInTimeRange]
    """

    _validation = {
        "object_type": {"required": True},
        "recovery_point_time_in_utc": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_time_in_utc": {"key": "recoveryPointTimeInUTC", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformation]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
        "time_ranges": {"key": "timeRanges", "type": "[PointInTimeRange]"},
    }

    def __init__(
        self,
        *,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformation"]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        time_ranges: Optional[List["_models.PointInTimeRange"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
        :keyword time_ranges: List of log ranges.
        :paramtype time_ranges:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.PointInTimeRange]
        """
        super().__init__(
            recovery_point_tier_details=recovery_point_tier_details,
            recovery_point_move_readiness_info=recovery_point_move_readiness_info,
            time_ranges=time_ranges,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSAPHanaPointInTimeRecoveryPoint"


class AzureWorkloadSAPHanaRestoreRequest(AzureWorkloadRestoreRequest):
    """AzureWorkload SAP Hana-specific restore.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadSAPHanaPointInTimeRestoreRequest

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "AzureWorkloadSAPHanaPointInTimeRestoreRequest": "AzureWorkloadSAPHanaPointInTimeRestoreRequest"
        }
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSAPHanaRestoreRequest"


class AzureWorkloadSAPHanaPointInTimeRestoreRequest(
    AzureWorkloadSAPHanaRestoreRequest
):  # pylint: disable=name-too-long
    """AzureWorkload SAP Hana -specific restore. Specifically for PointInTime/Log restore.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar point_in_time: PointInTime value.
    :vartype point_in_time: ~datetime.datetime
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "point_in_time": {"key": "pointInTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        point_in_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword point_in_time: PointInTime value.
        :paramtype point_in_time: ~datetime.datetime
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSAPHanaPointInTimeRestoreRequest"
        self.point_in_time = point_in_time


class AzureWorkloadSAPHanaRecoveryPoint(AzureWorkloadRecoveryPoint):
    """SAPHana specific recoverypoint, specifically encapsulates full/diff recoverypoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was created.
    :vartype recovery_point_time_in_utc: ~datetime.datetime
    :ivar type: Type of restore point. Known values are: "Invalid", "Full", "Log", "Differential",
     and "Incremental".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestorePointType
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
    """

    _validation = {
        "object_type": {"required": True},
        "recovery_point_time_in_utc": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_time_in_utc": {"key": "recoveryPointTimeInUTC", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformation]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
    }

    def __init__(
        self,
        *,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformation"]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
        """
        super().__init__(
            recovery_point_tier_details=recovery_point_tier_details,
            recovery_point_move_readiness_info=recovery_point_move_readiness_info,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSAPHanaRecoveryPoint"


class AzureWorkloadSQLRecoveryPoint(AzureWorkloadRecoveryPoint):
    """SQL specific recoverypoint, specifically encapsulates full/diff recoverypoint along with
    extended info.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadSQLPointInTimeRecoveryPoint

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was created.
    :vartype recovery_point_time_in_utc: ~datetime.datetime
    :ivar type: Type of restore point. Known values are: "Invalid", "Full", "Log", "Differential",
     and "Incremental".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestorePointType
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
    :ivar extended_info: Extended Info that provides data directory details. Will be populated in
     two cases:
     When a specific recovery point is accessed using GetRecoveryPoint
     Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo query filter.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureWorkloadSQLRecoveryPointExtendedInfo
    """

    _validation = {
        "object_type": {"required": True},
        "recovery_point_time_in_utc": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_time_in_utc": {"key": "recoveryPointTimeInUTC", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformation]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
        "extended_info": {"key": "extendedInfo", "type": "AzureWorkloadSQLRecoveryPointExtendedInfo"},
    }

    _subtype_map = {
        "object_type": {"AzureWorkloadSQLPointInTimeRecoveryPoint": "AzureWorkloadSQLPointInTimeRecoveryPoint"}
    }

    def __init__(
        self,
        *,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformation"]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        extended_info: Optional["_models.AzureWorkloadSQLRecoveryPointExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
        :keyword extended_info: Extended Info that provides data directory details. Will be populated
         in two cases:
         When a specific recovery point is accessed using GetRecoveryPoint
         Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo query filter.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureWorkloadSQLRecoveryPointExtendedInfo
        """
        super().__init__(
            recovery_point_tier_details=recovery_point_tier_details,
            recovery_point_move_readiness_info=recovery_point_move_readiness_info,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSQLRecoveryPoint"
        self.extended_info = extended_info


class AzureWorkloadSQLPointInTimeRecoveryPoint(AzureWorkloadSQLRecoveryPoint):
    """Recovery point specific to PointInTime.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was created.
    :vartype recovery_point_time_in_utc: ~datetime.datetime
    :ivar type: Type of restore point. Known values are: "Invalid", "Full", "Log", "Differential",
     and "Incremental".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestorePointType
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
    :ivar extended_info: Extended Info that provides data directory details. Will be populated in
     two cases:
     When a specific recovery point is accessed using GetRecoveryPoint
     Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo query filter.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureWorkloadSQLRecoveryPointExtendedInfo
    :ivar time_ranges: List of log ranges.
    :vartype time_ranges:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.PointInTimeRange]
    """

    _validation = {
        "object_type": {"required": True},
        "recovery_point_time_in_utc": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_time_in_utc": {"key": "recoveryPointTimeInUTC", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformation]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
        "extended_info": {"key": "extendedInfo", "type": "AzureWorkloadSQLRecoveryPointExtendedInfo"},
        "time_ranges": {"key": "timeRanges", "type": "[PointInTimeRange]"},
    }

    def __init__(
        self,
        *,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformation"]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        extended_info: Optional["_models.AzureWorkloadSQLRecoveryPointExtendedInfo"] = None,
        time_ranges: Optional[List["_models.PointInTimeRange"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
        :keyword extended_info: Extended Info that provides data directory details. Will be populated
         in two cases:
         When a specific recovery point is accessed using GetRecoveryPoint
         Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo query filter.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.AzureWorkloadSQLRecoveryPointExtendedInfo
        :keyword time_ranges: List of log ranges.
        :paramtype time_ranges:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.PointInTimeRange]
        """
        super().__init__(
            recovery_point_tier_details=recovery_point_tier_details,
            recovery_point_move_readiness_info=recovery_point_move_readiness_info,
            extended_info=extended_info,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSQLPointInTimeRecoveryPoint"
        self.time_ranges = time_ranges


class AzureWorkloadSQLRestoreRequest(AzureWorkloadRestoreRequest):
    """AzureWorkload SQL -specific restore. Specifically for full/diff restore.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadSQLPointInTimeRestoreRequest

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar should_use_alternate_target_location: Default option set to true. If this is set to
     false, alternate data directory must be provided.
    :vartype should_use_alternate_target_location: bool
    :ivar is_non_recoverable: SQL specific property where user can chose to set no-recovery when
     restore operation is tried.
    :vartype is_non_recoverable: bool
    :ivar alternate_directory_paths: Data directory details.
    :vartype alternate_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.SQLDataDirectoryMapping]
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "should_use_alternate_target_location": {"key": "shouldUseAlternateTargetLocation", "type": "bool"},
        "is_non_recoverable": {"key": "isNonRecoverable", "type": "bool"},
        "alternate_directory_paths": {"key": "alternateDirectoryPaths", "type": "[SQLDataDirectoryMapping]"},
    }

    _subtype_map = {
        "object_type": {"AzureWorkloadSQLPointInTimeRestoreRequest": "AzureWorkloadSQLPointInTimeRestoreRequest"}
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        should_use_alternate_target_location: Optional[bool] = None,
        is_non_recoverable: Optional[bool] = None,
        alternate_directory_paths: Optional[List["_models.SQLDataDirectoryMapping"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword should_use_alternate_target_location: Default option set to true. If this is set to
         false, alternate data directory must be provided.
        :paramtype should_use_alternate_target_location: bool
        :keyword is_non_recoverable: SQL specific property where user can chose to set no-recovery when
         restore operation is tried.
        :paramtype is_non_recoverable: bool
        :keyword alternate_directory_paths: Data directory details.
        :paramtype alternate_directory_paths:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.SQLDataDirectoryMapping]
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSQLRestoreRequest"
        self.should_use_alternate_target_location = should_use_alternate_target_location
        self.is_non_recoverable = is_non_recoverable
        self.alternate_directory_paths = alternate_directory_paths


class AzureWorkloadSQLPointInTimeRestoreRequest(
    AzureWorkloadSQLRestoreRequest
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """AzureWorkload SQL -specific restore. Specifically for PointInTime/Log restore.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar should_use_alternate_target_location: Default option set to true. If this is set to
     false, alternate data directory must be provided.
    :vartype should_use_alternate_target_location: bool
    :ivar is_non_recoverable: SQL specific property where user can chose to set no-recovery when
     restore operation is tried.
    :vartype is_non_recoverable: bool
    :ivar alternate_directory_paths: Data directory details.
    :vartype alternate_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.SQLDataDirectoryMapping]
    :ivar point_in_time: PointInTime value.
    :vartype point_in_time: ~datetime.datetime
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "should_use_alternate_target_location": {"key": "shouldUseAlternateTargetLocation", "type": "bool"},
        "is_non_recoverable": {"key": "isNonRecoverable", "type": "bool"},
        "alternate_directory_paths": {"key": "alternateDirectoryPaths", "type": "[SQLDataDirectoryMapping]"},
        "point_in_time": {"key": "pointInTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        should_use_alternate_target_location: Optional[bool] = None,
        is_non_recoverable: Optional[bool] = None,
        alternate_directory_paths: Optional[List["_models.SQLDataDirectoryMapping"]] = None,
        point_in_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword should_use_alternate_target_location: Default option set to true. If this is set to
         false, alternate data directory must be provided.
        :paramtype should_use_alternate_target_location: bool
        :keyword is_non_recoverable: SQL specific property where user can chose to set no-recovery when
         restore operation is tried.
        :paramtype is_non_recoverable: bool
        :keyword alternate_directory_paths: Data directory details.
        :paramtype alternate_directory_paths:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.SQLDataDirectoryMapping]
        :keyword point_in_time: PointInTime value.
        :paramtype point_in_time: ~datetime.datetime
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            should_use_alternate_target_location=should_use_alternate_target_location,
            is_non_recoverable=is_non_recoverable,
            alternate_directory_paths=alternate_directory_paths,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSQLPointInTimeRestoreRequest"
        self.point_in_time = point_in_time


class AzureWorkloadSQLRecoveryPointExtendedInfo(_serialization.Model):  # pylint: disable=name-too-long
    """Extended info class details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar data_directory_time_in_utc: UTC time at which data directory info was captured.
    :vartype data_directory_time_in_utc: ~datetime.datetime
    :ivar data_directory_paths: List of data directory paths during restore operation.
    :vartype data_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.SQLDataDirectory]
    """

    _validation = {
        "data_directory_time_in_utc": {"readonly": True},
        "data_directory_paths": {"readonly": True},
    }

    _attribute_map = {
        "data_directory_time_in_utc": {"key": "dataDirectoryTimeInUTC", "type": "iso-8601"},
        "data_directory_paths": {"key": "dataDirectoryPaths", "type": "[SQLDataDirectory]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.data_directory_time_in_utc = None
        self.data_directory_paths = None


class BackupManagementUsage(_serialization.Model):
    """Backup management usages of a vault.

    :ivar unit: Unit of the usage. Known values are: "Count", "Bytes", "Seconds", "Percent",
     "CountPerSecond", and "BytesPerSecond".
    :vartype unit: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.UsagesUnit
    :ivar quota_period: Quota period of usage.
    :vartype quota_period: str
    :ivar next_reset_time: Next reset time of usage.
    :vartype next_reset_time: ~datetime.datetime
    :ivar current_value: Current value of usage.
    :vartype current_value: int
    :ivar limit: Limit of usage.
    :vartype limit: int
    :ivar name: Name of usage.
    :vartype name: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.NameInfo
    """

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "quota_period": {"key": "quotaPeriod", "type": "str"},
        "next_reset_time": {"key": "nextResetTime", "type": "iso-8601"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "NameInfo"},
    }

    def __init__(
        self,
        *,
        unit: Optional[Union[str, "_models.UsagesUnit"]] = None,
        quota_period: Optional[str] = None,
        next_reset_time: Optional[datetime.datetime] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["_models.NameInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unit: Unit of the usage. Known values are: "Count", "Bytes", "Seconds", "Percent",
         "CountPerSecond", and "BytesPerSecond".
        :paramtype unit: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.UsagesUnit
        :keyword quota_period: Quota period of usage.
        :paramtype quota_period: str
        :keyword next_reset_time: Next reset time of usage.
        :paramtype next_reset_time: ~datetime.datetime
        :keyword current_value: Current value of usage.
        :paramtype current_value: int
        :keyword limit: Limit of usage.
        :paramtype limit: int
        :keyword name: Name of usage.
        :paramtype name: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.NameInfo
        """
        super().__init__(**kwargs)
        self.unit = unit
        self.quota_period = quota_period
        self.next_reset_time = next_reset_time
        self.current_value = current_value
        self.limit = limit
        self.name = name


class BackupManagementUsageList(_serialization.Model):
    """Backup management usage for vault.

    :ivar value: The list of backup management usages for the given vault.
    :vartype value:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementUsage]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BackupManagementUsage]"},
    }

    def __init__(self, *, value: Optional[List["_models.BackupManagementUsage"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of backup management usages for the given vault.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementUsage]
        """
        super().__init__(**kwargs)
        self.value = value


class BackupResourceConfig(_serialization.Model):
    """The resource storage details.

    :ivar storage_model_type: Storage type. Known values are: "Invalid", "GeoRedundant",
     "LocallyRedundant", "ZoneRedundant", and "ReadAccessGeoZoneRedundant".
    :vartype storage_model_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.StorageType
    :ivar storage_type: Storage type. Known values are: "Invalid", "GeoRedundant",
     "LocallyRedundant", "ZoneRedundant", and "ReadAccessGeoZoneRedundant".
    :vartype storage_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.StorageType
    :ivar storage_type_state: Locked or Unlocked. Once a machine is registered against a resource,
     the storageTypeState is always Locked. Known values are: "Invalid", "Locked", and "Unlocked".
    :vartype storage_type_state: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.StorageTypeState
    :ivar cross_region_restore_flag: Opt in details of Cross Region Restore feature.
    :vartype cross_region_restore_flag: bool
    """

    _attribute_map = {
        "storage_model_type": {"key": "storageModelType", "type": "str"},
        "storage_type": {"key": "storageType", "type": "str"},
        "storage_type_state": {"key": "storageTypeState", "type": "str"},
        "cross_region_restore_flag": {"key": "crossRegionRestoreFlag", "type": "bool"},
    }

    def __init__(
        self,
        *,
        storage_model_type: Optional[Union[str, "_models.StorageType"]] = None,
        storage_type: Optional[Union[str, "_models.StorageType"]] = None,
        storage_type_state: Optional[Union[str, "_models.StorageTypeState"]] = None,
        cross_region_restore_flag: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_model_type: Storage type. Known values are: "Invalid", "GeoRedundant",
         "LocallyRedundant", "ZoneRedundant", and "ReadAccessGeoZoneRedundant".
        :paramtype storage_model_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.StorageType
        :keyword storage_type: Storage type. Known values are: "Invalid", "GeoRedundant",
         "LocallyRedundant", "ZoneRedundant", and "ReadAccessGeoZoneRedundant".
        :paramtype storage_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.StorageType
        :keyword storage_type_state: Locked or Unlocked. Once a machine is registered against a
         resource, the storageTypeState is always Locked. Known values are: "Invalid", "Locked", and
         "Unlocked".
        :paramtype storage_type_state: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.StorageTypeState
        :keyword cross_region_restore_flag: Opt in details of Cross Region Restore feature.
        :paramtype cross_region_restore_flag: bool
        """
        super().__init__(**kwargs)
        self.storage_model_type = storage_model_type
        self.storage_type = storage_type
        self.storage_type_state = storage_type_state
        self.cross_region_restore_flag = cross_region_restore_flag


class BackupResourceConfigResource(Resource):
    """The resource storage details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: BackupResourceConfigResource properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupResourceConfig
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "BackupResourceConfig"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.BackupResourceConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: BackupResourceConfigResource properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupResourceConfig
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class BEKDetails(_serialization.Model):
    """BEK is bitlocker encryption key.

    :ivar secret_url: Secret is BEK.
    :vartype secret_url: str
    :ivar secret_vault_id: ID of the Key Vault where this Secret is stored.
    :vartype secret_vault_id: str
    :ivar secret_data: BEK data.
    :vartype secret_data: str
    """

    _attribute_map = {
        "secret_url": {"key": "secretUrl", "type": "str"},
        "secret_vault_id": {"key": "secretVaultId", "type": "str"},
        "secret_data": {"key": "secretData", "type": "str"},
    }

    def __init__(
        self,
        *,
        secret_url: Optional[str] = None,
        secret_vault_id: Optional[str] = None,
        secret_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword secret_url: Secret is BEK.
        :paramtype secret_url: str
        :keyword secret_vault_id: ID of the Key Vault where this Secret is stored.
        :paramtype secret_vault_id: str
        :keyword secret_data: BEK data.
        :paramtype secret_data: str
        """
        super().__init__(**kwargs)
        self.secret_url = secret_url
        self.secret_vault_id = secret_vault_id
        self.secret_data = secret_data


class BMSAADPropertiesQueryObject(_serialization.Model):
    """Filters to list backup items.

    :ivar backup_management_type: Backup management type for the backed up item. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    """

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
    }

    def __init__(
        self, *, backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Backup management type for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        """
        super().__init__(**kwargs)
        self.backup_management_type = backup_management_type


class BMSBackupSummariesQueryObject(_serialization.Model):
    """Query parameters to fetch backup summaries.

    :ivar type: Backup management type for this container. Known values are: "Invalid",
     "BackupProtectedItemCountSummary", and "BackupProtectionContainerCountSummary".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.Type
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.Type"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: Backup management type for this container. Known values are: "Invalid",
         "BackupProtectedItemCountSummary", and "BackupProtectionContainerCountSummary".
        :paramtype type: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.Type
        """
        super().__init__(**kwargs)
        self.type = type


class BMSRPQueryObject(_serialization.Model):
    """Filters to list backup copies.

    :ivar start_date: Backup copies created after this time.
    :vartype start_date: ~datetime.datetime
    :ivar end_date: Backup copies created before this time.
    :vartype end_date: ~datetime.datetime
    :ivar restore_point_query_type: RestorePoint type. Known values are: "Invalid", "Full", "Log",
     "Differential", "FullAndDifferential", "All", and "Incremental".
    :vartype restore_point_query_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestorePointQueryType
    :ivar extended_info: In Get Recovery Point, it tells whether extended information about
     recovery point is asked.
    :vartype extended_info: bool
    :ivar move_ready_rp_only: Whether the RP can be moved to another tier.
    :vartype move_ready_rp_only: bool
    """

    _attribute_map = {
        "start_date": {"key": "startDate", "type": "iso-8601"},
        "end_date": {"key": "endDate", "type": "iso-8601"},
        "restore_point_query_type": {"key": "restorePointQueryType", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "bool"},
        "move_ready_rp_only": {"key": "moveReadyRPOnly", "type": "bool"},
    }

    def __init__(
        self,
        *,
        start_date: Optional[datetime.datetime] = None,
        end_date: Optional[datetime.datetime] = None,
        restore_point_query_type: Optional[Union[str, "_models.RestorePointQueryType"]] = None,
        extended_info: Optional[bool] = None,
        move_ready_rp_only: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_date: Backup copies created after this time.
        :paramtype start_date: ~datetime.datetime
        :keyword end_date: Backup copies created before this time.
        :paramtype end_date: ~datetime.datetime
        :keyword restore_point_query_type: RestorePoint type. Known values are: "Invalid", "Full",
         "Log", "Differential", "FullAndDifferential", "All", and "Incremental".
        :paramtype restore_point_query_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestorePointQueryType
        :keyword extended_info: In Get Recovery Point, it tells whether extended information about
         recovery point is asked.
        :paramtype extended_info: bool
        :keyword move_ready_rp_only: Whether the RP can be moved to another tier.
        :paramtype move_ready_rp_only: bool
        """
        super().__init__(**kwargs)
        self.start_date = start_date
        self.end_date = end_date
        self.restore_point_query_type = restore_point_query_type
        self.extended_info = extended_info
        self.move_ready_rp_only = move_ready_rp_only


class ClientScriptForConnect(_serialization.Model):
    """Client script details for file / folder restore.

    :ivar script_content: File content of the client script for file / folder restore.
    :vartype script_content: str
    :ivar script_extension: File extension of the client script for file / folder restore - .ps1 ,
     .sh , etc.
    :vartype script_extension: str
    :ivar os_type: OS type - Windows, Linux etc. for which this file / folder restore client script
     works.
    :vartype os_type: str
    :ivar url: URL of Executable from where to source the content. If this is not null then
     ScriptContent should not be used.
    :vartype url: str
    :ivar script_name_suffix: Mandatory suffix that should be added to the name of script that is
     given for download to user.
     If its null or empty then , ignore it.
    :vartype script_name_suffix: str
    """

    _attribute_map = {
        "script_content": {"key": "scriptContent", "type": "str"},
        "script_extension": {"key": "scriptExtension", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "script_name_suffix": {"key": "scriptNameSuffix", "type": "str"},
    }

    def __init__(
        self,
        *,
        script_content: Optional[str] = None,
        script_extension: Optional[str] = None,
        os_type: Optional[str] = None,
        url: Optional[str] = None,
        script_name_suffix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword script_content: File content of the client script for file / folder restore.
        :paramtype script_content: str
        :keyword script_extension: File extension of the client script for file / folder restore - .ps1
         , .sh , etc.
        :paramtype script_extension: str
        :keyword os_type: OS type - Windows, Linux etc. for which this file / folder restore client
         script works.
        :paramtype os_type: str
        :keyword url: URL of Executable from where to source the content. If this is not null then
         ScriptContent should not be used.
        :paramtype url: str
        :keyword script_name_suffix: Mandatory suffix that should be added to the name of script that
         is given for download to user.
         If its null or empty then , ignore it.
        :paramtype script_name_suffix: str
        """
        super().__init__(**kwargs)
        self.script_content = script_content
        self.script_extension = script_extension
        self.os_type = os_type
        self.url = url
        self.script_name_suffix = script_name_suffix


class CrossRegionRestoreRequest(_serialization.Model):
    """CrossRegionRestoreRequest.

    :ivar cross_region_restore_access_details: Access details for cross region restore.
    :vartype cross_region_restore_access_details:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CrrAccessToken
    :ivar restore_request: Request object for triggering restore.
    :vartype restore_request: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestoreRequest
    """

    _attribute_map = {
        "cross_region_restore_access_details": {"key": "crossRegionRestoreAccessDetails", "type": "CrrAccessToken"},
        "restore_request": {"key": "restoreRequest", "type": "RestoreRequest"},
    }

    def __init__(
        self,
        *,
        cross_region_restore_access_details: Optional["_models.CrrAccessToken"] = None,
        restore_request: Optional["_models.RestoreRequest"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cross_region_restore_access_details: Access details for cross region restore.
        :paramtype cross_region_restore_access_details:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CrrAccessToken
        :keyword restore_request: Request object for triggering restore.
        :paramtype restore_request:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RestoreRequest
        """
        super().__init__(**kwargs)
        self.cross_region_restore_access_details = cross_region_restore_access_details
        self.restore_request = restore_request


class CrossRegionRestoreRequestResource(Resource):
    """CrossRegionRestoreRequestResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: CrossRegionRestoreRequestResource properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CrossRegionRestoreRequest
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "CrossRegionRestoreRequest"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.CrossRegionRestoreRequest"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: CrossRegionRestoreRequestResource properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CrossRegionRestoreRequest
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class CrrAccessToken(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """CrrAccessToken.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    WorkloadCrrAccessToken

    All required parameters must be populated in order to send to server.

    :ivar object_type: Type of the specific object - used for deserializing. Required.
    :vartype object_type: str
    :ivar access_token_string: Access token used for authentication.
    :vartype access_token_string: str
    :ivar subscription_id: Subscription Id of the source vault.
    :vartype subscription_id: str
    :ivar resource_group_name: Resource Group name of the source vault.
    :vartype resource_group_name: str
    :ivar resource_name: Resource Name of the source vault.
    :vartype resource_name: str
    :ivar resource_id: Resource Id of the source vault.
    :vartype resource_id: str
    :ivar protection_container_id: Protected item container id.
    :vartype protection_container_id: int
    :ivar recovery_point_id: Recovery Point Id.
    :vartype recovery_point_id: str
    :ivar recovery_point_time: Recovery Point Time.
    :vartype recovery_point_time: str
    :ivar container_name: Container Unique name.
    :vartype container_name: str
    :ivar container_type: Container Type.
    :vartype container_type: str
    :ivar backup_management_type: Backup Management Type.
    :vartype backup_management_type: str
    :ivar datasource_type: Datasource Type.
    :vartype datasource_type: str
    :ivar datasource_name: Datasource Friendly Name.
    :vartype datasource_name: str
    :ivar datasource_id: Datasource Id.
    :vartype datasource_id: str
    :ivar datasource_container_name: Datasource Container Unique Name.
    :vartype datasource_container_name: str
    :ivar coordinator_service_stamp_id: CoordinatorServiceStampId to be used by BCM in restore
     call.
    :vartype coordinator_service_stamp_id: str
    :ivar coordinator_service_stamp_uri: CoordinatorServiceStampUri to be used by BCM in restore
     call.
    :vartype coordinator_service_stamp_uri: str
    :ivar protection_service_stamp_id: ProtectionServiceStampId to be used by BCM in restore call.
    :vartype protection_service_stamp_id: str
    :ivar protection_service_stamp_uri: ProtectionServiceStampUri to be used by BCM in restore
     call.
    :vartype protection_service_stamp_uri: str
    :ivar token_extended_information: Extended Information about the token like FileSpec etc.
    :vartype token_extended_information: str
    :ivar rp_tier_information: Recovery point Tier Information.
    :vartype rp_tier_information: dict[str, str]
    :ivar rp_original_sa_option: Recovery point information: Original SA option.
    :vartype rp_original_sa_option: bool
    :ivar rp_is_managed_virtual_machine: Recovery point information: Managed virtual machine.
    :vartype rp_is_managed_virtual_machine: bool
    :ivar rp_vm_size_description: Recovery point information: VM size description.
    :vartype rp_vm_size_description: str
    :ivar b_ms_active_region: Active region name of BMS Stamp.
    :vartype b_ms_active_region: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "access_token_string": {"key": "accessTokenString", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "protection_container_id": {"key": "protectionContainerId", "type": "int"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
        "recovery_point_time": {"key": "recoveryPointTime", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "datasource_type": {"key": "datasourceType", "type": "str"},
        "datasource_name": {"key": "datasourceName", "type": "str"},
        "datasource_id": {"key": "datasourceId", "type": "str"},
        "datasource_container_name": {"key": "datasourceContainerName", "type": "str"},
        "coordinator_service_stamp_id": {"key": "coordinatorServiceStampId", "type": "str"},
        "coordinator_service_stamp_uri": {"key": "coordinatorServiceStampUri", "type": "str"},
        "protection_service_stamp_id": {"key": "protectionServiceStampId", "type": "str"},
        "protection_service_stamp_uri": {"key": "protectionServiceStampUri", "type": "str"},
        "token_extended_information": {"key": "tokenExtendedInformation", "type": "str"},
        "rp_tier_information": {"key": "rpTierInformation", "type": "{str}"},
        "rp_original_sa_option": {"key": "rpOriginalSAOption", "type": "bool"},
        "rp_is_managed_virtual_machine": {"key": "rpIsManagedVirtualMachine", "type": "bool"},
        "rp_vm_size_description": {"key": "rpVMSizeDescription", "type": "str"},
        "b_ms_active_region": {"key": "bMSActiveRegion", "type": "str"},
    }

    _subtype_map = {"object_type": {"WorkloadCrrAccessToken": "WorkloadCrrAccessToken"}}

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        access_token_string: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group_name: Optional[str] = None,
        resource_name: Optional[str] = None,
        resource_id: Optional[str] = None,
        protection_container_id: Optional[int] = None,
        recovery_point_id: Optional[str] = None,
        recovery_point_time: Optional[str] = None,
        container_name: Optional[str] = None,
        container_type: Optional[str] = None,
        backup_management_type: Optional[str] = None,
        datasource_type: Optional[str] = None,
        datasource_name: Optional[str] = None,
        datasource_id: Optional[str] = None,
        datasource_container_name: Optional[str] = None,
        coordinator_service_stamp_id: Optional[str] = None,
        coordinator_service_stamp_uri: Optional[str] = None,
        protection_service_stamp_id: Optional[str] = None,
        protection_service_stamp_uri: Optional[str] = None,
        token_extended_information: Optional[str] = None,
        rp_tier_information: Optional[Dict[str, str]] = None,
        rp_original_sa_option: Optional[bool] = None,
        rp_is_managed_virtual_machine: Optional[bool] = None,
        rp_vm_size_description: Optional[str] = None,
        b_ms_active_region: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword access_token_string: Access token used for authentication.
        :paramtype access_token_string: str
        :keyword subscription_id: Subscription Id of the source vault.
        :paramtype subscription_id: str
        :keyword resource_group_name: Resource Group name of the source vault.
        :paramtype resource_group_name: str
        :keyword resource_name: Resource Name of the source vault.
        :paramtype resource_name: str
        :keyword resource_id: Resource Id of the source vault.
        :paramtype resource_id: str
        :keyword protection_container_id: Protected item container id.
        :paramtype protection_container_id: int
        :keyword recovery_point_id: Recovery Point Id.
        :paramtype recovery_point_id: str
        :keyword recovery_point_time: Recovery Point Time.
        :paramtype recovery_point_time: str
        :keyword container_name: Container Unique name.
        :paramtype container_name: str
        :keyword container_type: Container Type.
        :paramtype container_type: str
        :keyword backup_management_type: Backup Management Type.
        :paramtype backup_management_type: str
        :keyword datasource_type: Datasource Type.
        :paramtype datasource_type: str
        :keyword datasource_name: Datasource Friendly Name.
        :paramtype datasource_name: str
        :keyword datasource_id: Datasource Id.
        :paramtype datasource_id: str
        :keyword datasource_container_name: Datasource Container Unique Name.
        :paramtype datasource_container_name: str
        :keyword coordinator_service_stamp_id: CoordinatorServiceStampId to be used by BCM in restore
         call.
        :paramtype coordinator_service_stamp_id: str
        :keyword coordinator_service_stamp_uri: CoordinatorServiceStampUri to be used by BCM in restore
         call.
        :paramtype coordinator_service_stamp_uri: str
        :keyword protection_service_stamp_id: ProtectionServiceStampId to be used by BCM in restore
         call.
        :paramtype protection_service_stamp_id: str
        :keyword protection_service_stamp_uri: ProtectionServiceStampUri to be used by BCM in restore
         call.
        :paramtype protection_service_stamp_uri: str
        :keyword token_extended_information: Extended Information about the token like FileSpec etc.
        :paramtype token_extended_information: str
        :keyword rp_tier_information: Recovery point Tier Information.
        :paramtype rp_tier_information: dict[str, str]
        :keyword rp_original_sa_option: Recovery point information: Original SA option.
        :paramtype rp_original_sa_option: bool
        :keyword rp_is_managed_virtual_machine: Recovery point information: Managed virtual machine.
        :paramtype rp_is_managed_virtual_machine: bool
        :keyword rp_vm_size_description: Recovery point information: VM size description.
        :paramtype rp_vm_size_description: str
        :keyword b_ms_active_region: Active region name of BMS Stamp.
        :paramtype b_ms_active_region: str
        """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None
        self.access_token_string = access_token_string
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.resource_name = resource_name
        self.resource_id = resource_id
        self.protection_container_id = protection_container_id
        self.recovery_point_id = recovery_point_id
        self.recovery_point_time = recovery_point_time
        self.container_name = container_name
        self.container_type = container_type
        self.backup_management_type = backup_management_type
        self.datasource_type = datasource_type
        self.datasource_name = datasource_name
        self.datasource_id = datasource_id
        self.datasource_container_name = datasource_container_name
        self.coordinator_service_stamp_id = coordinator_service_stamp_id
        self.coordinator_service_stamp_uri = coordinator_service_stamp_uri
        self.protection_service_stamp_id = protection_service_stamp_id
        self.protection_service_stamp_uri = protection_service_stamp_uri
        self.token_extended_information = token_extended_information
        self.rp_tier_information = rp_tier_information
        self.rp_original_sa_option = rp_original_sa_option
        self.rp_is_managed_virtual_machine = rp_is_managed_virtual_machine
        self.rp_vm_size_description = rp_vm_size_description
        self.b_ms_active_region = b_ms_active_region


class CrrAccessTokenResource(Resource):
    """CrrAccessTokenResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: CrrAccessTokenResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CrrAccessToken
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "CrrAccessToken"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.CrrAccessToken"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: CrrAccessTokenResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CrrAccessToken
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class CrrJobRequest(_serialization.Model):
    """Request object for fetching CRR jobs.

    :ivar resource_id: Entire ARM resource id of the resource.
    :vartype resource_id: str
    :ivar job_name: Job Name of the job to be fetched.
    :vartype job_name: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "job_name": {"key": "jobName", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, job_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: Entire ARM resource id of the resource.
        :paramtype resource_id: str
        :keyword job_name: Job Name of the job to be fetched.
        :paramtype job_name: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.job_name = job_name


class CrrJobRequestResource(Resource):
    """Request object for fetching CRR jobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: CrrJobRequestResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CrrJobRequest
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "CrrJobRequest"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.CrrJobRequest"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: CrrJobRequestResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CrrJobRequest
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class DiskExclusionProperties(_serialization.Model):
    """DiskExclusionProperties.

    :ivar disk_lun_list: List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
    :vartype disk_lun_list: list[int]
    :ivar is_inclusion_list: Flag to indicate whether DiskLunList is to be included/ excluded from
     backup.
    :vartype is_inclusion_list: bool
    """

    _attribute_map = {
        "disk_lun_list": {"key": "diskLunList", "type": "[int]"},
        "is_inclusion_list": {"key": "isInclusionList", "type": "bool"},
    }

    def __init__(
        self, *, disk_lun_list: Optional[List[int]] = None, is_inclusion_list: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword disk_lun_list: List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
        :paramtype disk_lun_list: list[int]
        :keyword is_inclusion_list: Flag to indicate whether DiskLunList is to be included/ excluded
         from backup.
        :paramtype is_inclusion_list: bool
        """
        super().__init__(**kwargs)
        self.disk_lun_list = disk_lun_list
        self.is_inclusion_list = is_inclusion_list


class DiskInformation(_serialization.Model):
    """Disk information.

    :ivar lun:
    :vartype lun: int
    :ivar name:
    :vartype name: str
    """

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, lun: Optional[int] = None, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword lun:
        :paramtype lun: int
        :keyword name:
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.lun = lun
        self.name = name


class DpmErrorInfo(_serialization.Model):
    """DPM workload-specific error information.

    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar recommendations: List of localized recommendations for above error code.
    :vartype recommendations: list[str]
    """

    _attribute_map = {
        "error_string": {"key": "errorString", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(
        self, *, error_string: Optional[str] = None, recommendations: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword error_string: Localized error string.
        :paramtype error_string: str
        :keyword recommendations: List of localized recommendations for above error code.
        :paramtype recommendations: list[str]
        """
        super().__init__(**kwargs)
        self.error_string = error_string
        self.recommendations = recommendations


class DpmJob(Job):  # pylint: disable=too-many-instance-attributes
    """DPM workload-specific job object.

    All required parameters must be populated in order to send to server.

    :ivar entity_friendly_name: Friendly name of the entity on which the current job is executing.
    :vartype entity_friendly_name: str
    :ivar backup_management_type: Backup management type to execute the current job. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar status: Job status.
    :vartype status: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar activity_id: ActivityId of job.
    :vartype activity_id: str
    :ivar job_type: This property will be used as the discriminator for deciding the specific types
     in the polymorphic chain of types. Required.
    :vartype job_type: str
    :ivar duration: Time elapsed for job.
    :vartype duration: ~datetime.timedelta
    :ivar dpm_server_name: DPM server name managing the backup item or backup job.
    :vartype dpm_server_name: str
    :ivar container_name: Name of cluster/server protecting current backup item, if any.
    :vartype container_name: str
    :ivar container_type: Type of container.
    :vartype container_type: str
    :ivar workload_type: Type of backup item.
    :vartype workload_type: str
    :ivar actions_info: The state/actions applicable on this job like cancel/retry.
    :vartype actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobSupportedAction]
    :ivar error_details: The errors.
    :vartype error_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.DpmErrorInfo]
    :ivar extended_info: Additional information for this job.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DpmJobExtendedInfo
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "entity_friendly_name": {"key": "entityFriendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "activity_id": {"key": "activityId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "dpm_server_name": {"key": "dpmServerName", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "actions_info": {"key": "actionsInfo", "type": "[str]"},
        "error_details": {"key": "errorDetails", "type": "[DpmErrorInfo]"},
        "extended_info": {"key": "extendedInfo", "type": "DpmJobExtendedInfo"},
    }

    def __init__(
        self,
        *,
        entity_friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        activity_id: Optional[str] = None,
        duration: Optional[datetime.timedelta] = None,
        dpm_server_name: Optional[str] = None,
        container_name: Optional[str] = None,
        container_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        actions_info: Optional[List[Union[str, "_models.JobSupportedAction"]]] = None,
        error_details: Optional[List["_models.DpmErrorInfo"]] = None,
        extended_info: Optional["_models.DpmJobExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity_friendly_name: Friendly name of the entity on which the current job is
         executing.
        :paramtype entity_friendly_name: str
        :keyword backup_management_type: Backup management type to execute the current job. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword operation: The operation name.
        :paramtype operation: str
        :keyword status: Job status.
        :paramtype status: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword activity_id: ActivityId of job.
        :paramtype activity_id: str
        :keyword duration: Time elapsed for job.
        :paramtype duration: ~datetime.timedelta
        :keyword dpm_server_name: DPM server name managing the backup item or backup job.
        :paramtype dpm_server_name: str
        :keyword container_name: Name of cluster/server protecting current backup item, if any.
        :paramtype container_name: str
        :keyword container_type: Type of container.
        :paramtype container_type: str
        :keyword workload_type: Type of backup item.
        :paramtype workload_type: str
        :keyword actions_info: The state/actions applicable on this job like cancel/retry.
        :paramtype actions_info: list[str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobSupportedAction]
        :keyword error_details: The errors.
        :paramtype error_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.DpmErrorInfo]
        :keyword extended_info: Additional information for this job.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DpmJobExtendedInfo
        """
        super().__init__(
            entity_friendly_name=entity_friendly_name,
            backup_management_type=backup_management_type,
            operation=operation,
            status=status,
            start_time=start_time,
            end_time=end_time,
            activity_id=activity_id,
            **kwargs
        )
        self.job_type: str = "DpmJob"
        self.duration = duration
        self.dpm_server_name = dpm_server_name
        self.container_name = container_name
        self.container_type = container_type
        self.workload_type = workload_type
        self.actions_info = actions_info
        self.error_details = error_details
        self.extended_info = extended_info


class DpmJobExtendedInfo(_serialization.Model):
    """Additional information on the DPM workload-specific job.

    :ivar tasks_list: List of tasks associated with this job.
    :vartype tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.DpmJobTaskDetails]
    :ivar property_bag: The job properties.
    :vartype property_bag: dict[str, str]
    :ivar dynamic_error_message: Non localized error message on job execution.
    :vartype dynamic_error_message: str
    """

    _attribute_map = {
        "tasks_list": {"key": "tasksList", "type": "[DpmJobTaskDetails]"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "dynamic_error_message": {"key": "dynamicErrorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        tasks_list: Optional[List["_models.DpmJobTaskDetails"]] = None,
        property_bag: Optional[Dict[str, str]] = None,
        dynamic_error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tasks_list: List of tasks associated with this job.
        :paramtype tasks_list:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.DpmJobTaskDetails]
        :keyword property_bag: The job properties.
        :paramtype property_bag: dict[str, str]
        :keyword dynamic_error_message: Non localized error message on job execution.
        :paramtype dynamic_error_message: str
        """
        super().__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.dynamic_error_message = dynamic_error_message


class DpmJobTaskDetails(_serialization.Model):
    """DPM workload-specific job task details.

    :ivar task_id: The task display name.
    :vartype task_id: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar duration: Time elapsed for task.
    :vartype duration: ~datetime.timedelta
    :ivar status: The status.
    :vartype status: str
    """

    _attribute_map = {
        "task_id": {"key": "taskId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "duration": {"key": "duration", "type": "duration"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        task_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        duration: Optional[datetime.timedelta] = None,
        status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword task_id: The task display name.
        :paramtype task_id: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword duration: Time elapsed for task.
        :paramtype duration: ~datetime.timedelta
        :keyword status: The status.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.task_id = task_id
        self.start_time = start_time
        self.end_time = end_time
        self.duration = duration
        self.status = status


class DPMProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """Additional information on Backup engine specific backup item.

    All required parameters must be populated in order to send to server.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar friendly_name: Friendly name of the managed item.
    :vartype friendly_name: str
    :ivar backup_engine_name: Backup Management server protecting this backup item.
    :vartype backup_engine_name: str
    :ivar protection_state: Protection state of the backup engine. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemState
    :ivar extended_info: Extended info of the backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DPMProtectedItemExtendedInfo
    """

    _validation = {
        "protected_item_type": {"required": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_engine_name": {"key": "backupEngineName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "DPMProtectedItemExtendedInfo"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        friendly_name: Optional[str] = None,
        backup_engine_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectedItemState"]] = None,
        extended_info: Optional["_models.DPMProtectedItemExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword workload_type: Type of workload this item represents. Known values are: "Invalid",
         "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword friendly_name: Friendly name of the managed item.
        :paramtype friendly_name: str
        :keyword backup_engine_name: Backup Management server protecting this backup item.
        :paramtype backup_engine_name: str
        :keyword protection_state: Protection state of the backup engine. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemState
        :keyword extended_info: Extended info of the backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DPMProtectedItemExtendedInfo
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            **kwargs
        )
        self.protected_item_type: str = "DPMProtectedItem"
        self.friendly_name = friendly_name
        self.backup_engine_name = backup_engine_name
        self.protection_state = protection_state
        self.extended_info = extended_info


class DPMProtectedItemExtendedInfo(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Additional information of DPM Protected item.

    :ivar protectable_object_load_path: Attribute to provide information on various DBs.
    :vartype protectable_object_load_path: dict[str, str]
    :ivar protected: To check if backup item is disk protected.
    :vartype protected: bool
    :ivar is_present_on_cloud: To check if backup item is cloud protected.
    :vartype is_present_on_cloud: bool
    :ivar last_backup_status: Last backup status information on backup item.
    :vartype last_backup_status: str
    :ivar last_refreshed_at: Last refresh time on backup item.
    :vartype last_refreshed_at: ~datetime.datetime
    :ivar oldest_recovery_point: Oldest cloud recovery point time.
    :vartype oldest_recovery_point: ~datetime.datetime
    :ivar recovery_point_count: cloud recovery point count.
    :vartype recovery_point_count: int
    :ivar on_premise_oldest_recovery_point: Oldest disk recovery point time.
    :vartype on_premise_oldest_recovery_point: ~datetime.datetime
    :ivar on_premise_latest_recovery_point: latest disk recovery point time.
    :vartype on_premise_latest_recovery_point: ~datetime.datetime
    :ivar on_premise_recovery_point_count: disk recovery point count.
    :vartype on_premise_recovery_point_count: int
    :ivar is_collocated: To check if backup item is collocated.
    :vartype is_collocated: bool
    :ivar protection_group_name: Protection group name of the backup item.
    :vartype protection_group_name: str
    :ivar disk_storage_used_in_bytes: Used Disk storage in bytes.
    :vartype disk_storage_used_in_bytes: str
    :ivar total_disk_storage_size_in_bytes: total Disk storage in bytes.
    :vartype total_disk_storage_size_in_bytes: str
    """

    _attribute_map = {
        "protectable_object_load_path": {"key": "protectableObjectLoadPath", "type": "{str}"},
        "protected": {"key": "protected", "type": "bool"},
        "is_present_on_cloud": {"key": "isPresentOnCloud", "type": "bool"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_refreshed_at": {"key": "lastRefreshedAt", "type": "iso-8601"},
        "oldest_recovery_point": {"key": "oldestRecoveryPoint", "type": "iso-8601"},
        "recovery_point_count": {"key": "recoveryPointCount", "type": "int"},
        "on_premise_oldest_recovery_point": {"key": "onPremiseOldestRecoveryPoint", "type": "iso-8601"},
        "on_premise_latest_recovery_point": {"key": "onPremiseLatestRecoveryPoint", "type": "iso-8601"},
        "on_premise_recovery_point_count": {"key": "onPremiseRecoveryPointCount", "type": "int"},
        "is_collocated": {"key": "isCollocated", "type": "bool"},
        "protection_group_name": {"key": "protectionGroupName", "type": "str"},
        "disk_storage_used_in_bytes": {"key": "diskStorageUsedInBytes", "type": "str"},
        "total_disk_storage_size_in_bytes": {"key": "totalDiskStorageSizeInBytes", "type": "str"},
    }

    def __init__(
        self,
        *,
        protectable_object_load_path: Optional[Dict[str, str]] = None,
        protected: Optional[bool] = None,
        is_present_on_cloud: Optional[bool] = None,
        last_backup_status: Optional[str] = None,
        last_refreshed_at: Optional[datetime.datetime] = None,
        oldest_recovery_point: Optional[datetime.datetime] = None,
        recovery_point_count: Optional[int] = None,
        on_premise_oldest_recovery_point: Optional[datetime.datetime] = None,
        on_premise_latest_recovery_point: Optional[datetime.datetime] = None,
        on_premise_recovery_point_count: Optional[int] = None,
        is_collocated: Optional[bool] = None,
        protection_group_name: Optional[str] = None,
        disk_storage_used_in_bytes: Optional[str] = None,
        total_disk_storage_size_in_bytes: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protectable_object_load_path: Attribute to provide information on various DBs.
        :paramtype protectable_object_load_path: dict[str, str]
        :keyword protected: To check if backup item is disk protected.
        :paramtype protected: bool
        :keyword is_present_on_cloud: To check if backup item is cloud protected.
        :paramtype is_present_on_cloud: bool
        :keyword last_backup_status: Last backup status information on backup item.
        :paramtype last_backup_status: str
        :keyword last_refreshed_at: Last refresh time on backup item.
        :paramtype last_refreshed_at: ~datetime.datetime
        :keyword oldest_recovery_point: Oldest cloud recovery point time.
        :paramtype oldest_recovery_point: ~datetime.datetime
        :keyword recovery_point_count: cloud recovery point count.
        :paramtype recovery_point_count: int
        :keyword on_premise_oldest_recovery_point: Oldest disk recovery point time.
        :paramtype on_premise_oldest_recovery_point: ~datetime.datetime
        :keyword on_premise_latest_recovery_point: latest disk recovery point time.
        :paramtype on_premise_latest_recovery_point: ~datetime.datetime
        :keyword on_premise_recovery_point_count: disk recovery point count.
        :paramtype on_premise_recovery_point_count: int
        :keyword is_collocated: To check if backup item is collocated.
        :paramtype is_collocated: bool
        :keyword protection_group_name: Protection group name of the backup item.
        :paramtype protection_group_name: str
        :keyword disk_storage_used_in_bytes: Used Disk storage in bytes.
        :paramtype disk_storage_used_in_bytes: str
        :keyword total_disk_storage_size_in_bytes: total Disk storage in bytes.
        :paramtype total_disk_storage_size_in_bytes: str
        """
        super().__init__(**kwargs)
        self.protectable_object_load_path = protectable_object_load_path
        self.protected = protected
        self.is_present_on_cloud = is_present_on_cloud
        self.last_backup_status = last_backup_status
        self.last_refreshed_at = last_refreshed_at
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.on_premise_oldest_recovery_point = on_premise_oldest_recovery_point
        self.on_premise_latest_recovery_point = on_premise_latest_recovery_point
        self.on_premise_recovery_point_count = on_premise_recovery_point_count
        self.is_collocated = is_collocated
        self.protection_group_name = protection_group_name
        self.disk_storage_used_in_bytes = disk_storage_used_in_bytes
        self.total_disk_storage_size_in_bytes = total_disk_storage_size_in_bytes


class EncryptionDetails(_serialization.Model):
    """Details needed if the VM was encrypted at the time of backup.

    :ivar encryption_enabled: Identifies whether this backup copy represents an encrypted VM at the
     time of backup.
    :vartype encryption_enabled: bool
    :ivar kek_url: Key Url.
    :vartype kek_url: str
    :ivar secret_key_url: Secret Url.
    :vartype secret_key_url: str
    :ivar kek_vault_id: ID of Key Vault where KEK is stored.
    :vartype kek_vault_id: str
    :ivar secret_key_vault_id: ID of Key Vault where Secret is stored.
    :vartype secret_key_vault_id: str
    """

    _attribute_map = {
        "encryption_enabled": {"key": "encryptionEnabled", "type": "bool"},
        "kek_url": {"key": "kekUrl", "type": "str"},
        "secret_key_url": {"key": "secretKeyUrl", "type": "str"},
        "kek_vault_id": {"key": "kekVaultId", "type": "str"},
        "secret_key_vault_id": {"key": "secretKeyVaultId", "type": "str"},
    }

    def __init__(
        self,
        *,
        encryption_enabled: Optional[bool] = None,
        kek_url: Optional[str] = None,
        secret_key_url: Optional[str] = None,
        kek_vault_id: Optional[str] = None,
        secret_key_vault_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword encryption_enabled: Identifies whether this backup copy represents an encrypted VM at
         the time of backup.
        :paramtype encryption_enabled: bool
        :keyword kek_url: Key Url.
        :paramtype kek_url: str
        :keyword secret_key_url: Secret Url.
        :paramtype secret_key_url: str
        :keyword kek_vault_id: ID of Key Vault where KEK is stored.
        :paramtype kek_vault_id: str
        :keyword secret_key_vault_id: ID of Key Vault where Secret is stored.
        :paramtype secret_key_vault_id: str
        """
        super().__init__(**kwargs)
        self.encryption_enabled = encryption_enabled
        self.kek_url = kek_url
        self.secret_key_url = secret_key_url
        self.kek_vault_id = kek_vault_id
        self.secret_key_vault_id = secret_key_vault_id


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """Error Detail class which encapsulates Code, Message and Recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error Message related to the Code.
    :vartype message: str
    :ivar recommendations: List of recommendation strings.
    :vartype recommendations: list[str]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "recommendations": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.recommendations = None


class ExtendedProperties(_serialization.Model):
    """Extended Properties for Azure IaasVM Backup.

    :ivar disk_exclusion_properties: Extended Properties for Disk Exclusion.
    :vartype disk_exclusion_properties:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DiskExclusionProperties
    """

    _attribute_map = {
        "disk_exclusion_properties": {"key": "diskExclusionProperties", "type": "DiskExclusionProperties"},
    }

    def __init__(
        self, *, disk_exclusion_properties: Optional["_models.DiskExclusionProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword disk_exclusion_properties: Extended Properties for Disk Exclusion.
        :paramtype disk_exclusion_properties:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DiskExclusionProperties
        """
        super().__init__(**kwargs)
        self.disk_exclusion_properties = disk_exclusion_properties


class GenericProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """Base class for backup items.

    All required parameters must be populated in order to send to server.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar policy_state: Indicates consistency of policy object and policy applied to this backup
     item.
    :vartype policy_state: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
    :ivar protected_item_id: Data Plane Service ID of the protected item.
    :vartype protected_item_id: int
    :ivar source_associations: Loosely coupled (type, value) associations (example - parent of a
     protected item).
    :vartype source_associations: dict[str, str]
    :ivar fabric_name: Name of this backup item's fabric.
    :vartype fabric_name: str
    """

    _validation = {
        "protected_item_type": {"required": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "policy_state": {"key": "policyState", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "protected_item_id": {"key": "protectedItemId", "type": "int"},
        "source_associations": {"key": "sourceAssociations", "type": "{str}"},
        "fabric_name": {"key": "fabricName", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        friendly_name: Optional[str] = None,
        policy_state: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        protected_item_id: Optional[int] = None,
        source_associations: Optional[Dict[str, str]] = None,
        fabric_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword workload_type: Type of workload this item represents. Known values are: "Invalid",
         "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword policy_state: Indicates consistency of policy object and policy applied to this backup
         item.
        :paramtype policy_state: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", and "ProtectionPaused".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectionState
        :keyword protected_item_id: Data Plane Service ID of the protected item.
        :paramtype protected_item_id: int
        :keyword source_associations: Loosely coupled (type, value) associations (example - parent of a
         protected item).
        :paramtype source_associations: dict[str, str]
        :keyword fabric_name: Name of this backup item's fabric.
        :paramtype fabric_name: str
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            **kwargs
        )
        self.protected_item_type: str = "GenericProtectedItem"
        self.friendly_name = friendly_name
        self.policy_state = policy_state
        self.protection_state = protection_state
        self.protected_item_id = protected_item_id
        self.source_associations = source_associations
        self.fabric_name = fabric_name


class GenericRecoveryPoint(RecoveryPoint):
    """Generic backup copy.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar friendly_name: Friendly name of the backup copy.
    :vartype friendly_name: str
    :ivar recovery_point_type: Type of the backup copy.
    :vartype recovery_point_type: str
    :ivar recovery_point_time: Time at which this backup copy was created.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar recovery_point_additional_info: Additional information associated with this backup copy.
    :vartype recovery_point_additional_info: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "recovery_point_time": {"key": "recoveryPointTime", "type": "iso-8601"},
        "recovery_point_additional_info": {"key": "recoveryPointAdditionalInfo", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        recovery_point_type: Optional[str] = None,
        recovery_point_time: Optional[datetime.datetime] = None,
        recovery_point_additional_info: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the backup copy.
        :paramtype friendly_name: str
        :keyword recovery_point_type: Type of the backup copy.
        :paramtype recovery_point_type: str
        :keyword recovery_point_time: Time at which this backup copy was created.
        :paramtype recovery_point_time: ~datetime.datetime
        :keyword recovery_point_additional_info: Additional information associated with this backup
         copy.
        :paramtype recovery_point_additional_info: str
        """
        super().__init__(**kwargs)
        self.object_type: str = "GenericRecoveryPoint"
        self.friendly_name = friendly_name
        self.recovery_point_type = recovery_point_type
        self.recovery_point_time = recovery_point_time
        self.recovery_point_additional_info = recovery_point_additional_info


class IaasVMRecoveryPoint(RecoveryPoint):  # pylint: disable=too-many-instance-attributes
    """IaaS VM workload specific backup copy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_type: Type of the backup copy.
    :vartype recovery_point_type: str
    :ivar recovery_point_time: Time at which this backup copy was created.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar recovery_point_additional_info: Additional information associated with this backup copy.
    :vartype recovery_point_additional_info: str
    :ivar source_vm_storage_type: Storage type of the VM whose backup copy is created.
    :vartype source_vm_storage_type: str
    :ivar is_source_vm_encrypted: Identifies whether the VM was encrypted when the backup copy is
     created.
    :vartype is_source_vm_encrypted: bool
    :ivar key_and_secret: Required details for recovering an encrypted VM. Applicable only when
     IsSourceVMEncrypted is true.
    :vartype key_and_secret:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KeyAndSecretDetails
    :ivar is_instant_ilr_session_active: Is the session to recover items from this backup copy
     still active.
    :vartype is_instant_ilr_session_active: bool
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
    :ivar is_managed_virtual_machine: Whether VM is with Managed Disks.
    :vartype is_managed_virtual_machine: bool
    :ivar virtual_machine_size: Virtual Machine Size.
    :vartype virtual_machine_size: str
    :ivar original_storage_account_option: Original Storage Account Option.
    :vartype original_storage_account_option: bool
    :ivar os_type: OS type.
    :vartype os_type: str
    :ivar recovery_point_disk_configuration: Disk configuration.
    :vartype recovery_point_disk_configuration:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointDiskConfiguration
    :ivar zones: Identifies the zone of the VM at the time of backup. Applicable only for
     zone-pinned Vms.
    :vartype zones: list[str]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
    """

    _validation = {
        "object_type": {"required": True},
        "recovery_point_type": {"readonly": True},
        "recovery_point_time": {"readonly": True},
        "recovery_point_additional_info": {"readonly": True},
        "source_vm_storage_type": {"readonly": True},
        "is_source_vm_encrypted": {"readonly": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "recovery_point_time": {"key": "recoveryPointTime", "type": "iso-8601"},
        "recovery_point_additional_info": {"key": "recoveryPointAdditionalInfo", "type": "str"},
        "source_vm_storage_type": {"key": "sourceVMStorageType", "type": "str"},
        "is_source_vm_encrypted": {"key": "isSourceVMEncrypted", "type": "bool"},
        "key_and_secret": {"key": "keyAndSecret", "type": "KeyAndSecretDetails"},
        "is_instant_ilr_session_active": {"key": "isInstantIlrSessionActive", "type": "bool"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformation]"},
        "is_managed_virtual_machine": {"key": "isManagedVirtualMachine", "type": "bool"},
        "virtual_machine_size": {"key": "virtualMachineSize", "type": "str"},
        "original_storage_account_option": {"key": "originalStorageAccountOption", "type": "bool"},
        "os_type": {"key": "osType", "type": "str"},
        "recovery_point_disk_configuration": {
            "key": "recoveryPointDiskConfiguration",
            "type": "RecoveryPointDiskConfiguration",
        },
        "zones": {"key": "zones", "type": "[str]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
    }

    def __init__(
        self,
        *,
        key_and_secret: Optional["_models.KeyAndSecretDetails"] = None,
        is_instant_ilr_session_active: Optional[bool] = None,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformation"]] = None,
        is_managed_virtual_machine: Optional[bool] = None,
        virtual_machine_size: Optional[str] = None,
        original_storage_account_option: Optional[bool] = None,
        os_type: Optional[str] = None,
        recovery_point_disk_configuration: Optional["_models.RecoveryPointDiskConfiguration"] = None,
        zones: Optional[List[str]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_and_secret: Required details for recovering an encrypted VM. Applicable only when
         IsSourceVMEncrypted is true.
        :paramtype key_and_secret:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KeyAndSecretDetails
        :keyword is_instant_ilr_session_active: Is the session to recover items from this backup copy
         still active.
        :paramtype is_instant_ilr_session_active: bool
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierInformation]
        :keyword is_managed_virtual_machine: Whether VM is with Managed Disks.
        :paramtype is_managed_virtual_machine: bool
        :keyword virtual_machine_size: Virtual Machine Size.
        :paramtype virtual_machine_size: str
        :keyword original_storage_account_option: Original Storage Account Option.
        :paramtype original_storage_account_option: bool
        :keyword os_type: OS type.
        :paramtype os_type: str
        :keyword recovery_point_disk_configuration: Disk configuration.
        :paramtype recovery_point_disk_configuration:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointDiskConfiguration
        :keyword zones: Identifies the zone of the VM at the time of backup. Applicable only for
         zone-pinned Vms.
        :paramtype zones: list[str]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointMoveReadinessInfo]
        """
        super().__init__(**kwargs)
        self.object_type: str = "IaasVMRecoveryPoint"
        self.recovery_point_type = None
        self.recovery_point_time = None
        self.recovery_point_additional_info = None
        self.source_vm_storage_type = None
        self.is_source_vm_encrypted = None
        self.key_and_secret = key_and_secret
        self.is_instant_ilr_session_active = is_instant_ilr_session_active
        self.recovery_point_tier_details = recovery_point_tier_details
        self.is_managed_virtual_machine = is_managed_virtual_machine
        self.virtual_machine_size = virtual_machine_size
        self.original_storage_account_option = original_storage_account_option
        self.os_type = os_type
        self.recovery_point_disk_configuration = recovery_point_disk_configuration
        self.zones = zones
        self.recovery_point_move_readiness_info = recovery_point_move_readiness_info


class IaasVMRestoreRequest(RestoreRequest):  # pylint: disable=too-many-instance-attributes
    """IaaS VM workload-specific restore.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_id: ID of the backup copy to be recovered.
    :vartype recovery_point_id: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM which is being recovered.
    :vartype source_resource_id: str
    :ivar target_virtual_machine_id: This is the complete ARM Id of the VM that will be created.
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar target_resource_group_id: This is the ARM Id of the resource group that you want to
     create for this Virtual machine and other artifacts.
     For e.g. /subscriptions/{subId}/resourcegroups/{rg}.
    :vartype target_resource_group_id: str
    :ivar storage_account_id: Fully qualified ARM ID of the storage account to which the VM has to
     be restored.
    :vartype storage_account_id: str
    :ivar virtual_network_id: This is the virtual network Id of the vnet that will be attached to
     the virtual machine.
     User will be validated for join action permissions in the linked access.
    :vartype virtual_network_id: str
    :ivar subnet_id: Subnet ID, is the subnet ID associated with the to be restored VM. For Classic
     VMs it would be
     {VnetID}/Subnet/{SubnetName} and, for the Azure Resource Manager VMs it would be ARM resource
     ID used to represent
     the subnet.
    :vartype subnet_id: str
    :ivar target_domain_name_id: Fully qualified ARM ID of the domain name to be associated to the
     VM being restored. This applies only to Classic
     Virtual Machines.
    :vartype target_domain_name_id: str
    :ivar region: Region in which the virtual machine is restored.
    :vartype region: str
    :ivar affinity_group: Affinity group associated to VM to be restored. Used only for Classic
     Compute Virtual Machines.
    :vartype affinity_group: str
    :ivar create_new_cloud_service: Should a new cloud service be created while restoring the VM.
     If this is false, VM will be restored to the same
     cloud service as it was at the time of backup.
    :vartype create_new_cloud_service: bool
    :ivar original_storage_account_option: Original Storage Account Option.
    :vartype original_storage_account_option: bool
    :ivar encryption_details: Details needed if the VM was encrypted at the time of backup.
    :vartype encryption_details:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.EncryptionDetails
    :ivar restore_disk_lun_list: List of Disk LUNs for partial restore.
    :vartype restore_disk_lun_list: list[int]
    :ivar restore_with_managed_disks: Flag to denote of an Unmanaged disk VM should be restored
     with Managed disks.
    :vartype restore_with_managed_disks: bool
    :ivar disk_encryption_set_id: DiskEncryptionSet's ID - needed if the VM needs to be encrypted
     at rest during restore with customer managed key.
    :vartype disk_encryption_set_id: str
    :ivar zones: Target zone where the VM and its disks should be restored.
    :vartype zones: list[str]
    :ivar identity_info: Managed Identity information required to access customer storage account.
    :vartype identity_info: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.IdentityInfo
    :ivar identity_based_restore_details: IaaS VM workload specific restore details for restores
     using managed identity.
    :vartype identity_based_restore_details:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.IdentityBasedRestoreDetails
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "target_resource_group_id": {"key": "targetResourceGroupId", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "virtual_network_id": {"key": "virtualNetworkId", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "target_domain_name_id": {"key": "targetDomainNameId", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "affinity_group": {"key": "affinityGroup", "type": "str"},
        "create_new_cloud_service": {"key": "createNewCloudService", "type": "bool"},
        "original_storage_account_option": {"key": "originalStorageAccountOption", "type": "bool"},
        "encryption_details": {"key": "encryptionDetails", "type": "EncryptionDetails"},
        "restore_disk_lun_list": {"key": "restoreDiskLunList", "type": "[int]"},
        "restore_with_managed_disks": {"key": "restoreWithManagedDisks", "type": "bool"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "identity_info": {"key": "identityInfo", "type": "IdentityInfo"},
        "identity_based_restore_details": {"key": "identityBasedRestoreDetails", "type": "IdentityBasedRestoreDetails"},
    }

    def __init__(
        self,
        *,
        recovery_point_id: Optional[str] = None,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        target_virtual_machine_id: Optional[str] = None,
        target_resource_group_id: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        virtual_network_id: Optional[str] = None,
        subnet_id: Optional[str] = None,
        target_domain_name_id: Optional[str] = None,
        region: Optional[str] = None,
        affinity_group: Optional[str] = None,
        create_new_cloud_service: Optional[bool] = None,
        original_storage_account_option: Optional[bool] = None,
        encryption_details: Optional["_models.EncryptionDetails"] = None,
        restore_disk_lun_list: Optional[List[int]] = None,
        restore_with_managed_disks: Optional[bool] = None,
        disk_encryption_set_id: Optional[str] = None,
        zones: Optional[List[str]] = None,
        identity_info: Optional["_models.IdentityInfo"] = None,
        identity_based_restore_details: Optional["_models.IdentityBasedRestoreDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_id: ID of the backup copy to be recovered.
        :paramtype recovery_point_id: str
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM which is being recovered.
        :paramtype source_resource_id: str
        :keyword target_virtual_machine_id: This is the complete ARM Id of the VM that will be created.
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword target_resource_group_id: This is the ARM Id of the resource group that you want to
         create for this Virtual machine and other artifacts.
         For e.g. /subscriptions/{subId}/resourcegroups/{rg}.
        :paramtype target_resource_group_id: str
        :keyword storage_account_id: Fully qualified ARM ID of the storage account to which the VM has
         to be restored.
        :paramtype storage_account_id: str
        :keyword virtual_network_id: This is the virtual network Id of the vnet that will be attached
         to the virtual machine.
         User will be validated for join action permissions in the linked access.
        :paramtype virtual_network_id: str
        :keyword subnet_id: Subnet ID, is the subnet ID associated with the to be restored VM. For
         Classic VMs it would be
         {VnetID}/Subnet/{SubnetName} and, for the Azure Resource Manager VMs it would be ARM resource
         ID used to represent
         the subnet.
        :paramtype subnet_id: str
        :keyword target_domain_name_id: Fully qualified ARM ID of the domain name to be associated to
         the VM being restored. This applies only to Classic
         Virtual Machines.
        :paramtype target_domain_name_id: str
        :keyword region: Region in which the virtual machine is restored.
        :paramtype region: str
        :keyword affinity_group: Affinity group associated to VM to be restored. Used only for Classic
         Compute Virtual Machines.
        :paramtype affinity_group: str
        :keyword create_new_cloud_service: Should a new cloud service be created while restoring the
         VM. If this is false, VM will be restored to the same
         cloud service as it was at the time of backup.
        :paramtype create_new_cloud_service: bool
        :keyword original_storage_account_option: Original Storage Account Option.
        :paramtype original_storage_account_option: bool
        :keyword encryption_details: Details needed if the VM was encrypted at the time of backup.
        :paramtype encryption_details:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.EncryptionDetails
        :keyword restore_disk_lun_list: List of Disk LUNs for partial restore.
        :paramtype restore_disk_lun_list: list[int]
        :keyword restore_with_managed_disks: Flag to denote of an Unmanaged disk VM should be restored
         with Managed disks.
        :paramtype restore_with_managed_disks: bool
        :keyword disk_encryption_set_id: DiskEncryptionSet's ID - needed if the VM needs to be
         encrypted at rest during restore with customer managed key.
        :paramtype disk_encryption_set_id: str
        :keyword zones: Target zone where the VM and its disks should be restored.
        :paramtype zones: list[str]
        :keyword identity_info: Managed Identity information required to access customer storage
         account.
        :paramtype identity_info: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.IdentityInfo
        :keyword identity_based_restore_details: IaaS VM workload specific restore details for restores
         using managed identity.
        :paramtype identity_based_restore_details:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.IdentityBasedRestoreDetails
        """
        super().__init__(**kwargs)
        self.object_type: str = "IaasVMRestoreRequest"
        self.recovery_point_id = recovery_point_id
        self.recovery_type = recovery_type
        self.source_resource_id = source_resource_id
        self.target_virtual_machine_id = target_virtual_machine_id
        self.target_resource_group_id = target_resource_group_id
        self.storage_account_id = storage_account_id
        self.virtual_network_id = virtual_network_id
        self.subnet_id = subnet_id
        self.target_domain_name_id = target_domain_name_id
        self.region = region
        self.affinity_group = affinity_group
        self.create_new_cloud_service = create_new_cloud_service
        self.original_storage_account_option = original_storage_account_option
        self.encryption_details = encryption_details
        self.restore_disk_lun_list = restore_disk_lun_list
        self.restore_with_managed_disks = restore_with_managed_disks
        self.disk_encryption_set_id = disk_encryption_set_id
        self.zones = zones
        self.identity_info = identity_info
        self.identity_based_restore_details = identity_based_restore_details


class IdentityBasedRestoreDetails(_serialization.Model):
    """IaaS VM workload specific restore details for restores using managed identity.

    :ivar object_type: Gets the class type.
    :vartype object_type: str
    :ivar target_storage_account_id: Fully qualified ARM ID of the target storage account.
    :vartype target_storage_account_id: str
    """

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "target_storage_account_id": {"key": "targetStorageAccountId", "type": "str"},
    }

    def __init__(
        self, *, object_type: Optional[str] = None, target_storage_account_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword object_type: Gets the class type.
        :paramtype object_type: str
        :keyword target_storage_account_id: Fully qualified ARM ID of the target storage account.
        :paramtype target_storage_account_id: str
        """
        super().__init__(**kwargs)
        self.object_type = object_type
        self.target_storage_account_id = target_storage_account_id


class IdentityInfo(_serialization.Model):
    """Encapsulates Managed Identity related information.

    :ivar is_system_assigned_identity: To differentiate if the managed identity is system assigned
     or user assigned.
    :vartype is_system_assigned_identity: bool
    :ivar managed_identity_resource_id: Managed Identity Resource Id
     Optional: Might not be required in the case of system assigned managed identity.
    :vartype managed_identity_resource_id: str
    """

    _attribute_map = {
        "is_system_assigned_identity": {"key": "isSystemAssignedIdentity", "type": "bool"},
        "managed_identity_resource_id": {"key": "managedIdentityResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        is_system_assigned_identity: Optional[bool] = None,
        managed_identity_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_system_assigned_identity: To differentiate if the managed identity is system
         assigned or user assigned.
        :paramtype is_system_assigned_identity: bool
        :keyword managed_identity_resource_id: Managed Identity Resource Id
         Optional: Might not be required in the case of system assigned managed identity.
        :paramtype managed_identity_resource_id: str
        """
        super().__init__(**kwargs)
        self.is_system_assigned_identity = is_system_assigned_identity
        self.managed_identity_resource_id = managed_identity_resource_id


class InstantItemRecoveryTarget(_serialization.Model):
    """Target details for file / folder restore.

    :ivar client_scripts: List of client scripts.
    :vartype client_scripts:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.ClientScriptForConnect]
    """

    _attribute_map = {
        "client_scripts": {"key": "clientScripts", "type": "[ClientScriptForConnect]"},
    }

    def __init__(
        self, *, client_scripts: Optional[List["_models.ClientScriptForConnect"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword client_scripts: List of client scripts.
        :paramtype client_scripts:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.ClientScriptForConnect]
        """
        super().__init__(**kwargs)
        self.client_scripts = client_scripts


class JobQueryObject(_serialization.Model):
    """Filters to list the jobs.

    :ivar status: Status of the job. Known values are: "Invalid", "InProgress", "Completed",
     "Failed", "CompletedWithWarnings", "Cancelled", and "Cancelling".
    :vartype status: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobStatus
    :ivar backup_management_type: Type of backup management for the job. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar operation: Type of operation. Known values are: "Invalid", "Register", "UnRegister",
     "ConfigureBackup", "Backup", "Restore", "DisableBackup", "DeleteBackupData",
     "CrossRegionRestore", "Undelete", and "UpdateCustomerManagedKey".
    :vartype operation: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobOperationType
    :ivar job_id: JobID represents the job uniquely.
    :vartype job_id: str
    :ivar start_time: Job has started at this time. Value is in UTC.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Job has ended at this time. Value is in UTC.
    :vartype end_time: ~datetime.datetime
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.JobStatus"]] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[Union[str, "_models.JobOperationType"]] = None,
        job_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the job. Known values are: "Invalid", "InProgress", "Completed",
         "Failed", "CompletedWithWarnings", "Cancelled", and "Cancelling".
        :paramtype status: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobStatus
        :keyword backup_management_type: Type of backup management for the job. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword operation: Type of operation. Known values are: "Invalid", "Register", "UnRegister",
         "ConfigureBackup", "Backup", "Restore", "DisableBackup", "DeleteBackupData",
         "CrossRegionRestore", "Undelete", and "UpdateCustomerManagedKey".
        :paramtype operation: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobOperationType
        :keyword job_id: JobID represents the job uniquely.
        :paramtype job_id: str
        :keyword start_time: Job has started at this time. Value is in UTC.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Job has ended at this time. Value is in UTC.
        :paramtype end_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.status = status
        self.backup_management_type = backup_management_type
        self.operation = operation
        self.job_id = job_id
        self.start_time = start_time
        self.end_time = end_time


class JobResource(Resource):
    """Defines workload agnostic properties for a job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: JobResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.Job
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "Job"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.Job"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: JobResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.Job
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ResourceList(_serialization.Model):
    """Base for all lists of resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link


class JobResourceList(ResourceList):
    """List of Job resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    :ivar value: List of resources.
    :vartype value: list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[JobResource]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.JobResource"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        :keyword value: List of resources.
        :paramtype value: list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobResource]
        """
        super().__init__(next_link=next_link, **kwargs)
        self.value = value


class KEKDetails(_serialization.Model):
    """KEK is encryption key for BEK.

    :ivar key_url: Key is KEK.
    :vartype key_url: str
    :ivar key_vault_id: Key Vault ID where this Key is stored.
    :vartype key_vault_id: str
    :ivar key_backup_data: KEK data.
    :vartype key_backup_data: str
    """

    _attribute_map = {
        "key_url": {"key": "keyUrl", "type": "str"},
        "key_vault_id": {"key": "keyVaultId", "type": "str"},
        "key_backup_data": {"key": "keyBackupData", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_url: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_backup_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_url: Key is KEK.
        :paramtype key_url: str
        :keyword key_vault_id: Key Vault ID where this Key is stored.
        :paramtype key_vault_id: str
        :keyword key_backup_data: KEK data.
        :paramtype key_backup_data: str
        """
        super().__init__(**kwargs)
        self.key_url = key_url
        self.key_vault_id = key_vault_id
        self.key_backup_data = key_backup_data


class KeyAndSecretDetails(_serialization.Model):
    """BEK is bitlocker key.
    KEK is encryption key for BEK
    If the VM was encrypted then we will store following details :


    #. Secret(BEK) - Url + Backup Data + vaultId.
    #. Key(KEK) - Url + Backup Data + vaultId.
    #. EncryptionMechanism
       BEK and KEK can potentially have different vault ids.

    :ivar kek_details: KEK is encryption key for BEK.
    :vartype kek_details: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KEKDetails
    :ivar bek_details: BEK is bitlocker encryption key.
    :vartype bek_details: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BEKDetails
    :ivar encryption_mechanism: Encryption mechanism: None/ SinglePass/ DoublePass.
    :vartype encryption_mechanism: str
    """

    _attribute_map = {
        "kek_details": {"key": "kekDetails", "type": "KEKDetails"},
        "bek_details": {"key": "bekDetails", "type": "BEKDetails"},
        "encryption_mechanism": {"key": "encryptionMechanism", "type": "str"},
    }

    def __init__(
        self,
        *,
        kek_details: Optional["_models.KEKDetails"] = None,
        bek_details: Optional["_models.BEKDetails"] = None,
        encryption_mechanism: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kek_details: KEK is encryption key for BEK.
        :paramtype kek_details: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.KEKDetails
        :keyword bek_details: BEK is bitlocker encryption key.
        :paramtype bek_details: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BEKDetails
        :keyword encryption_mechanism: Encryption mechanism: None/ SinglePass/ DoublePass.
        :paramtype encryption_mechanism: str
        """
        super().__init__(**kwargs)
        self.kek_details = kek_details
        self.bek_details = bek_details
        self.encryption_mechanism = encryption_mechanism


class KPIResourceHealthDetails(_serialization.Model):
    """KPI Resource Health Details.

    :ivar resource_health_status: Resource Health Status. Known values are: "Healthy",
     "TransientDegraded", "PersistentDegraded", "TransientUnhealthy", "PersistentUnhealthy", and
     "Invalid".
    :vartype resource_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ResourceHealthStatus
    :ivar resource_health_details: Resource Health Status.
    :vartype resource_health_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.ResourceHealthDetails]
    """

    _attribute_map = {
        "resource_health_status": {"key": "resourceHealthStatus", "type": "str"},
        "resource_health_details": {"key": "resourceHealthDetails", "type": "[ResourceHealthDetails]"},
    }

    def __init__(
        self,
        *,
        resource_health_status: Optional[Union[str, "_models.ResourceHealthStatus"]] = None,
        resource_health_details: Optional[List["_models.ResourceHealthDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_health_status: Resource Health Status. Known values are: "Healthy",
         "TransientDegraded", "PersistentDegraded", "TransientUnhealthy", "PersistentUnhealthy", and
         "Invalid".
        :paramtype resource_health_status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ResourceHealthStatus
        :keyword resource_health_details: Resource Health Status.
        :paramtype resource_health_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.ResourceHealthDetails]
        """
        super().__init__(**kwargs)
        self.resource_health_status = resource_health_status
        self.resource_health_details = resource_health_details


class MabErrorInfo(_serialization.Model):
    """MAB workload-specific error information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar recommendations: List of localized recommendations.
    :vartype recommendations: list[str]
    """

    _validation = {
        "error_string": {"readonly": True},
        "recommendations": {"readonly": True},
    }

    _attribute_map = {
        "error_string": {"key": "errorString", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error_string = None
        self.recommendations = None


class MabFileFolderProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """MAB workload-specific backup item.

    All required parameters must be populated in order to send to server.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar friendly_name: Friendly name of this backup item.
    :vartype friendly_name: str
    :ivar computer_name: Name of the computer associated with this backup item.
    :vartype computer_name: str
    :ivar last_backup_status: Status of last backup operation.
    :vartype last_backup_status: str
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar protection_state: Protected, ProtectionStopped, IRPending or ProtectionError.
    :vartype protection_state: str
    :ivar deferred_delete_sync_time_in_utc: Sync time for deferred deletion in UTC.
    :vartype deferred_delete_sync_time_in_utc: int
    :ivar extended_info: Additional information with this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.MabFileFolderProtectedItemExtendedInfo
    """

    _validation = {
        "protected_item_type": {"required": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "computer_name": {"key": "computerName", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "deferred_delete_sync_time_in_utc": {"key": "deferredDeleteSyncTimeInUTC", "type": "int"},
        "extended_info": {"key": "extendedInfo", "type": "MabFileFolderProtectedItemExtendedInfo"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        friendly_name: Optional[str] = None,
        computer_name: Optional[str] = None,
        last_backup_status: Optional[str] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        protection_state: Optional[str] = None,
        deferred_delete_sync_time_in_utc: Optional[int] = None,
        extended_info: Optional["_models.MabFileFolderProtectedItemExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword workload_type: Type of workload this item represents. Known values are: "Invalid",
         "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword friendly_name: Friendly name of this backup item.
        :paramtype friendly_name: str
        :keyword computer_name: Name of the computer associated with this backup item.
        :paramtype computer_name: str
        :keyword last_backup_status: Status of last backup operation.
        :paramtype last_backup_status: str
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword protection_state: Protected, ProtectionStopped, IRPending or ProtectionError.
        :paramtype protection_state: str
        :keyword deferred_delete_sync_time_in_utc: Sync time for deferred deletion in UTC.
        :paramtype deferred_delete_sync_time_in_utc: int
        :keyword extended_info: Additional information with this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.MabFileFolderProtectedItemExtendedInfo
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            **kwargs
        )
        self.protected_item_type: str = "MabFileFolderProtectedItem"
        self.friendly_name = friendly_name
        self.computer_name = computer_name
        self.last_backup_status = last_backup_status
        self.last_backup_time = last_backup_time
        self.protection_state = protection_state
        self.deferred_delete_sync_time_in_utc = deferred_delete_sync_time_in_utc
        self.extended_info = extended_info


class MabFileFolderProtectedItemExtendedInfo(_serialization.Model):
    """Additional information on the backed up item.

    :ivar last_refreshed_at: Last time when the agent data synced to service.
    :vartype last_refreshed_at: ~datetime.datetime
    :ivar oldest_recovery_point: The oldest backup copy available.
    :vartype oldest_recovery_point: ~datetime.datetime
    :ivar recovery_point_count: Number of backup copies associated with the backup item.
    :vartype recovery_point_count: int
    """

    _attribute_map = {
        "last_refreshed_at": {"key": "lastRefreshedAt", "type": "iso-8601"},
        "oldest_recovery_point": {"key": "oldestRecoveryPoint", "type": "iso-8601"},
        "recovery_point_count": {"key": "recoveryPointCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        last_refreshed_at: Optional[datetime.datetime] = None,
        oldest_recovery_point: Optional[datetime.datetime] = None,
        recovery_point_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword last_refreshed_at: Last time when the agent data synced to service.
        :paramtype last_refreshed_at: ~datetime.datetime
        :keyword oldest_recovery_point: The oldest backup copy available.
        :paramtype oldest_recovery_point: ~datetime.datetime
        :keyword recovery_point_count: Number of backup copies associated with the backup item.
        :paramtype recovery_point_count: int
        """
        super().__init__(**kwargs)
        self.last_refreshed_at = last_refreshed_at
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count


class MabJob(Job):  # pylint: disable=too-many-instance-attributes
    """MAB workload-specific job.

    All required parameters must be populated in order to send to server.

    :ivar entity_friendly_name: Friendly name of the entity on which the current job is executing.
    :vartype entity_friendly_name: str
    :ivar backup_management_type: Backup management type to execute the current job. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar status: Job status.
    :vartype status: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar activity_id: ActivityId of job.
    :vartype activity_id: str
    :ivar job_type: This property will be used as the discriminator for deciding the specific types
     in the polymorphic chain of types. Required.
    :vartype job_type: str
    :ivar duration: Time taken by job to run.
    :vartype duration: ~datetime.timedelta
    :ivar actions_info: The state/actions applicable on jobs like cancel/retry.
    :vartype actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobSupportedAction]
    :ivar mab_server_name: Name of server protecting the DS.
    :vartype mab_server_name: str
    :ivar mab_server_type: Server type of MAB container. Known values are: "Invalid", "Unknown",
     "IaasVMContainer", "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer",
     "MABContainer", "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", and "GenericContainer".
    :vartype mab_server_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.MabServerType
    :ivar workload_type: Workload type of backup item. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.WorkloadType
    :ivar error_details: The errors.
    :vartype error_details:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.MabErrorInfo]
    :ivar extended_info: Additional information on the job.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.MabJobExtendedInfo
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "entity_friendly_name": {"key": "entityFriendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "activity_id": {"key": "activityId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "actions_info": {"key": "actionsInfo", "type": "[str]"},
        "mab_server_name": {"key": "mabServerName", "type": "str"},
        "mab_server_type": {"key": "mabServerType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "error_details": {"key": "errorDetails", "type": "[MabErrorInfo]"},
        "extended_info": {"key": "extendedInfo", "type": "MabJobExtendedInfo"},
    }

    def __init__(
        self,
        *,
        entity_friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        activity_id: Optional[str] = None,
        duration: Optional[datetime.timedelta] = None,
        actions_info: Optional[List[Union[str, "_models.JobSupportedAction"]]] = None,
        mab_server_name: Optional[str] = None,
        mab_server_type: Optional[Union[str, "_models.MabServerType"]] = None,
        workload_type: Optional[Union[str, "_models.WorkloadType"]] = None,
        error_details: Optional[List["_models.MabErrorInfo"]] = None,
        extended_info: Optional["_models.MabJobExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity_friendly_name: Friendly name of the entity on which the current job is
         executing.
        :paramtype entity_friendly_name: str
        :keyword backup_management_type: Backup management type to execute the current job. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword operation: The operation name.
        :paramtype operation: str
        :keyword status: Job status.
        :paramtype status: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword activity_id: ActivityId of job.
        :paramtype activity_id: str
        :keyword duration: Time taken by job to run.
        :paramtype duration: ~datetime.timedelta
        :keyword actions_info: The state/actions applicable on jobs like cancel/retry.
        :paramtype actions_info: list[str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.JobSupportedAction]
        :keyword mab_server_name: Name of server protecting the DS.
        :paramtype mab_server_name: str
        :keyword mab_server_type: Server type of MAB container. Known values are: "Invalid", "Unknown",
         "IaasVMContainer", "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer",
         "MABContainer", "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
         "SQLAGWorkLoadContainer", "StorageContainer", and "GenericContainer".
        :paramtype mab_server_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.MabServerType
        :keyword workload_type: Workload type of backup item. Known values are: "Invalid", "VM",
         "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.WorkloadType
        :keyword error_details: The errors.
        :paramtype error_details:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.MabErrorInfo]
        :keyword extended_info: Additional information on the job.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.MabJobExtendedInfo
        """
        super().__init__(
            entity_friendly_name=entity_friendly_name,
            backup_management_type=backup_management_type,
            operation=operation,
            status=status,
            start_time=start_time,
            end_time=end_time,
            activity_id=activity_id,
            **kwargs
        )
        self.job_type: str = "MabJob"
        self.duration = duration
        self.actions_info = actions_info
        self.mab_server_name = mab_server_name
        self.mab_server_type = mab_server_type
        self.workload_type = workload_type
        self.error_details = error_details
        self.extended_info = extended_info


class MabJobExtendedInfo(_serialization.Model):
    """Additional information for the MAB workload-specific job.

    :ivar tasks_list: List of tasks for this job.
    :vartype tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.MabJobTaskDetails]
    :ivar property_bag: The job properties.
    :vartype property_bag: dict[str, str]
    :ivar dynamic_error_message: Non localized error message specific to this job.
    :vartype dynamic_error_message: str
    """

    _attribute_map = {
        "tasks_list": {"key": "tasksList", "type": "[MabJobTaskDetails]"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "dynamic_error_message": {"key": "dynamicErrorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        tasks_list: Optional[List["_models.MabJobTaskDetails"]] = None,
        property_bag: Optional[Dict[str, str]] = None,
        dynamic_error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tasks_list: List of tasks for this job.
        :paramtype tasks_list:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.MabJobTaskDetails]
        :keyword property_bag: The job properties.
        :paramtype property_bag: dict[str, str]
        :keyword dynamic_error_message: Non localized error message specific to this job.
        :paramtype dynamic_error_message: str
        """
        super().__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.dynamic_error_message = dynamic_error_message


class MabJobTaskDetails(_serialization.Model):
    """MAB workload-specific job task details.

    :ivar task_id: The task display name.
    :vartype task_id: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar duration: Time elapsed for task.
    :vartype duration: ~datetime.timedelta
    :ivar status: The status.
    :vartype status: str
    """

    _attribute_map = {
        "task_id": {"key": "taskId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "duration": {"key": "duration", "type": "duration"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        task_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        duration: Optional[datetime.timedelta] = None,
        status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword task_id: The task display name.
        :paramtype task_id: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword duration: Time elapsed for task.
        :paramtype duration: ~datetime.timedelta
        :keyword status: The status.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.task_id = task_id
        self.start_time = start_time
        self.end_time = end_time
        self.duration = duration
        self.status = status


class NameInfo(_serialization.Model):
    """The name of usage.

    :ivar value: Value of usage.
    :vartype value: str
    :ivar localized_value: Localized value of usage.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Value of usage.
        :paramtype value: str
        :keyword localized_value: Localized value of usage.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class NewErrorResponse(_serialization.Model):
    """The resource management error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.NewErrorResponseError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "NewErrorResponseError"},
    }

    def __init__(self, *, error: Optional["_models.NewErrorResponseError"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.NewErrorResponseError
        """
        super().__init__(**kwargs)
        self.error = error


class NewErrorResponseError(_serialization.Model):
    """The error object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.NewErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[NewErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class OperationStatus(_serialization.Model):
    """Operation status.

    :ivar id: ID of the operation.
    :vartype id: str
    :ivar name: Name of the operation.
    :vartype name: str
    :ivar status: Operation status. Known values are: "Invalid", "InProgress", "Succeeded",
     "Failed", and "Canceled".
    :vartype status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.OperationStatusValues
    :ivar start_time: Operation start time. Format: ISO-8601.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Operation end time. Format: ISO-8601.
    :vartype end_time: ~datetime.datetime
    :ivar error: Error information related to this operation.
    :vartype error: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.OperationStatusError
    :ivar properties: Additional information associated with this operation.
    :vartype properties:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.OperationStatusExtendedInfo
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "OperationStatusError"},
        "properties": {"key": "properties", "type": "OperationStatusExtendedInfo"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        status: Optional[Union[str, "_models.OperationStatusValues"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        error: Optional["_models.OperationStatusError"] = None,
        properties: Optional["_models.OperationStatusExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: ID of the operation.
        :paramtype id: str
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword status: Operation status. Known values are: "Invalid", "InProgress", "Succeeded",
         "Failed", and "Canceled".
        :paramtype status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.OperationStatusValues
        :keyword start_time: Operation start time. Format: ISO-8601.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Operation end time. Format: ISO-8601.
        :paramtype end_time: ~datetime.datetime
        :keyword error: Error information related to this operation.
        :paramtype error: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.OperationStatusError
        :keyword properties: Additional information associated with this operation.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.OperationStatusExtendedInfo
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.error = error
        self.properties = properties


class OperationStatusError(_serialization.Model):
    """Error information associated with operation status call.

    :ivar code: Error code of the operation failure.
    :vartype code: str
    :ivar message: Error message displayed if the operation failure.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code of the operation failure.
        :paramtype code: str
        :keyword message: Error message displayed if the operation failure.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class OperationStatusExtendedInfo(_serialization.Model):
    """Base class for additional information of operation status.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    OperationStatusJobExtendedInfo, OperationStatusJobsExtendedInfo,
    OperationStatusProvisionILRExtendedInfo, OperationStatusRecoveryPointExtendedInfo

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "OperationStatusJobExtendedInfo": "OperationStatusJobExtendedInfo",
            "OperationStatusJobsExtendedInfo": "OperationStatusJobsExtendedInfo",
            "OperationStatusProvisionILRExtendedInfo": "OperationStatusProvisionILRExtendedInfo",
            "OperationStatusRecoveryPointExtendedInfo": "OperationStatusRecoveryPointExtendedInfo",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None


class OperationStatusJobExtendedInfo(OperationStatusExtendedInfo):
    """Operation status job extended info.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar job_id: ID of the job created for this protected item.
    :vartype job_id: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
    }

    def __init__(self, *, job_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword job_id: ID of the job created for this protected item.
        :paramtype job_id: str
        """
        super().__init__(**kwargs)
        self.object_type: str = "OperationStatusJobExtendedInfo"
        self.job_id = job_id


class OperationStatusJobsExtendedInfo(OperationStatusExtendedInfo):
    """Operation status extended info for list of jobs.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar job_ids: IDs of the jobs created for the protected item.
    :vartype job_ids: list[str]
    :ivar failed_jobs_error: Stores all the failed jobs along with the corresponding error codes.
    :vartype failed_jobs_error: dict[str, str]
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "job_ids": {"key": "jobIds", "type": "[str]"},
        "failed_jobs_error": {"key": "failedJobsError", "type": "{str}"},
    }

    def __init__(
        self, *, job_ids: Optional[List[str]] = None, failed_jobs_error: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword job_ids: IDs of the jobs created for the protected item.
        :paramtype job_ids: list[str]
        :keyword failed_jobs_error: Stores all the failed jobs along with the corresponding error
         codes.
        :paramtype failed_jobs_error: dict[str, str]
        """
        super().__init__(**kwargs)
        self.object_type: str = "OperationStatusJobsExtendedInfo"
        self.job_ids = job_ids
        self.failed_jobs_error = failed_jobs_error


class OperationStatusProvisionILRExtendedInfo(OperationStatusExtendedInfo):
    """Operation status extended info for ILR provision action.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_target: Target details for file / folder restore.
    :vartype recovery_target:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.InstantItemRecoveryTarget
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_target": {"key": "recoveryTarget", "type": "InstantItemRecoveryTarget"},
    }

    def __init__(self, *, recovery_target: Optional["_models.InstantItemRecoveryTarget"] = None, **kwargs: Any) -> None:
        """
        :keyword recovery_target: Target details for file / folder restore.
        :paramtype recovery_target:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.InstantItemRecoveryTarget
        """
        super().__init__(**kwargs)
        self.object_type: str = "OperationStatusProvisionILRExtendedInfo"
        self.recovery_target = recovery_target


class OperationStatusRecoveryPointExtendedInfo(OperationStatusExtendedInfo):
    """Operation status extended info for Updated Recovery Point.

    All required parameters must be populated in order to send to server.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar updated_recovery_point: Recovery Point info with updated source snapshot URI.
    :vartype updated_recovery_point:
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPoint
    :ivar deleted_backup_item_version: In case the share is in soft-deleted state, populate this
     field with deleted backup item.
    :vartype deleted_backup_item_version: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "updated_recovery_point": {"key": "updatedRecoveryPoint", "type": "RecoveryPoint"},
        "deleted_backup_item_version": {"key": "deletedBackupItemVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        updated_recovery_point: Optional["_models.RecoveryPoint"] = None,
        deleted_backup_item_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword updated_recovery_point: Recovery Point info with updated source snapshot URI.
        :paramtype updated_recovery_point:
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPoint
        :keyword deleted_backup_item_version: In case the share is in soft-deleted state, populate this
         field with deleted backup item.
        :paramtype deleted_backup_item_version: str
        """
        super().__init__(**kwargs)
        self.object_type: str = "OperationStatusRecoveryPointExtendedInfo"
        self.updated_recovery_point = updated_recovery_point
        self.deleted_backup_item_version = deleted_backup_item_version


class PointInTimeRange(_serialization.Model):
    """Provides details for log ranges.

    :ivar start_time: Start time of the time range for log recovery.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the time range for log recovery.
    :vartype end_time: ~datetime.datetime
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: Start time of the time range for log recovery.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the time range for log recovery.
        :paramtype end_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time


class ProtectedItemQueryObject(_serialization.Model):
    """Filters to list backup items.

    :ivar health_state: Health State for the backed up item. Known values are: "Passed",
     "ActionRequired", "ActionSuggested", and "Invalid".
    :vartype health_state: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.HealthState
    :ivar backup_management_type: Backup management type for the backed up item. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
    :ivar item_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
     "SAPAseDatabase".
    :vartype item_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
    :ivar policy_name: Backup policy name associated with the backup item.
    :vartype policy_name: str
    :ivar container_name: Name of the container.
    :vartype container_name: str
    :ivar backup_engine_name: Backup Engine name.
    :vartype backup_engine_name: str
    :ivar friendly_name: Friendly name of protected item.
    :vartype friendly_name: str
    :ivar fabric_name: Name of the fabric.
    :vartype fabric_name: str
    :ivar backup_set_name: Name of the backup set.
    :vartype backup_set_name: str
    """

    _attribute_map = {
        "health_state": {"key": "healthState", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "item_type": {"key": "itemType", "type": "str"},
        "policy_name": {"key": "policyName", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "backup_engine_name": {"key": "backupEngineName", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
    }

    def __init__(
        self,
        *,
        health_state: Optional[Union[str, "_models.HealthState"]] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        item_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        policy_name: Optional[str] = None,
        container_name: Optional[str] = None,
        backup_engine_name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        fabric_name: Optional[str] = None,
        backup_set_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword health_state: Health State for the backed up item. Known values are: "Passed",
         "ActionRequired", "ActionSuggested", and "Invalid".
        :paramtype health_state: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.HealthState
        :keyword backup_management_type: Backup management type for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.BackupManagementType
        :keyword item_type: Type of workload this item represents. Known values are: "Invalid", "VM",
         "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", and
         "SAPAseDatabase".
        :paramtype item_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.DataSourceType
        :keyword policy_name: Backup policy name associated with the backup item.
        :paramtype policy_name: str
        :keyword container_name: Name of the container.
        :paramtype container_name: str
        :keyword backup_engine_name: Backup Engine name.
        :paramtype backup_engine_name: str
        :keyword friendly_name: Friendly name of protected item.
        :paramtype friendly_name: str
        :keyword fabric_name: Name of the fabric.
        :paramtype fabric_name: str
        :keyword backup_set_name: Name of the backup set.
        :paramtype backup_set_name: str
        """
        super().__init__(**kwargs)
        self.health_state = health_state
        self.backup_management_type = backup_management_type
        self.item_type = item_type
        self.policy_name = policy_name
        self.container_name = container_name
        self.backup_engine_name = backup_engine_name
        self.friendly_name = friendly_name
        self.fabric_name = fabric_name
        self.backup_set_name = backup_set_name


class ProtectedItemResource(Resource):
    """Base class for backup items.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: ProtectedItemResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItem
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "ProtectedItem"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.ProtectedItem"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: ProtectedItemResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItem
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ProtectedItemResourceList(ResourceList):
    """List of ProtectedItem resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    :ivar value: List of resources.
    :vartype value:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ProtectedItemResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.ProtectedItemResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        :keyword value: List of resources.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.ProtectedItemResource]
        """
        super().__init__(next_link=next_link, **kwargs)
        self.value = value


class RecoveryPointDiskConfiguration(_serialization.Model):
    """Disk configuration.

    :ivar number_of_disks_included_in_backup: Number of disks included in backup.
    :vartype number_of_disks_included_in_backup: int
    :ivar number_of_disks_attached_to_vm: Number of disks attached to the VM.
    :vartype number_of_disks_attached_to_vm: int
    :ivar included_disk_list: Information of disks included in backup.
    :vartype included_disk_list:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.DiskInformation]
    :ivar excluded_disk_list: Information of disks excluded from backup.
    :vartype excluded_disk_list:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.DiskInformation]
    """

    _attribute_map = {
        "number_of_disks_included_in_backup": {"key": "numberOfDisksIncludedInBackup", "type": "int"},
        "number_of_disks_attached_to_vm": {"key": "numberOfDisksAttachedToVm", "type": "int"},
        "included_disk_list": {"key": "includedDiskList", "type": "[DiskInformation]"},
        "excluded_disk_list": {"key": "excludedDiskList", "type": "[DiskInformation]"},
    }

    def __init__(
        self,
        *,
        number_of_disks_included_in_backup: Optional[int] = None,
        number_of_disks_attached_to_vm: Optional[int] = None,
        included_disk_list: Optional[List["_models.DiskInformation"]] = None,
        excluded_disk_list: Optional[List["_models.DiskInformation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number_of_disks_included_in_backup: Number of disks included in backup.
        :paramtype number_of_disks_included_in_backup: int
        :keyword number_of_disks_attached_to_vm: Number of disks attached to the VM.
        :paramtype number_of_disks_attached_to_vm: int
        :keyword included_disk_list: Information of disks included in backup.
        :paramtype included_disk_list:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.DiskInformation]
        :keyword excluded_disk_list: Information of disks excluded from backup.
        :paramtype excluded_disk_list:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.DiskInformation]
        """
        super().__init__(**kwargs)
        self.number_of_disks_included_in_backup = number_of_disks_included_in_backup
        self.number_of_disks_attached_to_vm = number_of_disks_attached_to_vm
        self.included_disk_list = included_disk_list
        self.excluded_disk_list = excluded_disk_list


class RecoveryPointMoveReadinessInfo(_serialization.Model):
    """RecoveryPointMoveReadinessInfo.

    :ivar is_ready_for_move:
    :vartype is_ready_for_move: bool
    :ivar additional_info:
    :vartype additional_info: str
    """

    _attribute_map = {
        "is_ready_for_move": {"key": "isReadyForMove", "type": "bool"},
        "additional_info": {"key": "additionalInfo", "type": "str"},
    }

    def __init__(
        self, *, is_ready_for_move: Optional[bool] = None, additional_info: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword is_ready_for_move:
        :paramtype is_ready_for_move: bool
        :keyword additional_info:
        :paramtype additional_info: str
        """
        super().__init__(**kwargs)
        self.is_ready_for_move = is_ready_for_move
        self.additional_info = additional_info


class RecoveryPointResource(Resource):
    """Base class for backup copies. Workload-specific backup copies are derived from this class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: RecoveryPointResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPoint
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "RecoveryPoint"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.RecoveryPoint"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: RecoveryPointResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPoint
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class RecoveryPointResourceList(ResourceList):
    """List of RecoveryPoint resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    :ivar value: List of resources.
    :vartype value:
     list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[RecoveryPointResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.RecoveryPointResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        :keyword value: List of resources.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointResource]
        """
        super().__init__(next_link=next_link, **kwargs)
        self.value = value


class RecoveryPointTierInformation(_serialization.Model):
    """Recovery point tier information.

    :ivar type: Recovery point tier type. Known values are: "Invalid", "InstantRP", "HardenedRP",
     and "ArchivedRP".
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierType
    :ivar status: Recovery point tier status. Known values are: "Invalid", "Valid", "Disabled",
     "Deleted", and "Rehydrated".
    :vartype status: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierStatus
    :ivar extended_info: Recovery point tier status.
    :vartype extended_info: dict[str, str]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.RecoveryPointTierType"]] = None,
        status: Optional[Union[str, "_models.RecoveryPointTierStatus"]] = None,
        extended_info: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Recovery point tier type. Known values are: "Invalid", "InstantRP",
         "HardenedRP", and "ArchivedRP".
        :paramtype type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierType
        :keyword status: Recovery point tier status. Known values are: "Invalid", "Valid", "Disabled",
         "Deleted", and "Rehydrated".
        :paramtype status: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.RecoveryPointTierStatus
        :keyword extended_info: Recovery point tier status.
        :paramtype extended_info: dict[str, str]
        """
        super().__init__(**kwargs)
        self.type = type
        self.status = status
        self.extended_info = extended_info


class RestoreFileSpecs(_serialization.Model):
    """Restore file specs like file path, type and target folder path info.

    :ivar path: Source File/Folder path.
    :vartype path: str
    :ivar file_spec_type: Indicates what the Path variable stands for.
    :vartype file_spec_type: str
    :ivar target_folder_path: Destination folder path in target FileShare.
    :vartype target_folder_path: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "file_spec_type": {"key": "fileSpecType", "type": "str"},
        "target_folder_path": {"key": "targetFolderPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        file_spec_type: Optional[str] = None,
        target_folder_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: Source File/Folder path.
        :paramtype path: str
        :keyword file_spec_type: Indicates what the Path variable stands for.
        :paramtype file_spec_type: str
        :keyword target_folder_path: Destination folder path in target FileShare.
        :paramtype target_folder_path: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.file_spec_type = file_spec_type
        self.target_folder_path = target_folder_path


class SQLDataDirectory(_serialization.Model):
    """SQLDataDirectory info.

    :ivar type: Type of data directory mapping. Known values are: "Invalid", "Data", and "Log".
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.SQLDataDirectoryType
    :ivar path: File path.
    :vartype path: str
    :ivar logical_name: Logical name of the file.
    :vartype logical_name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "logical_name": {"key": "logicalName", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.SQLDataDirectoryType"]] = None,
        path: Optional[str] = None,
        logical_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of data directory mapping. Known values are: "Invalid", "Data", and "Log".
        :paramtype type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.SQLDataDirectoryType
        :keyword path: File path.
        :paramtype path: str
        :keyword logical_name: Logical name of the file.
        :paramtype logical_name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.path = path
        self.logical_name = logical_name


class SQLDataDirectoryMapping(_serialization.Model):
    """Encapsulates information regarding data directory.

    :ivar mapping_type: Type of data directory mapping. Known values are: "Invalid", "Data", and
     "Log".
    :vartype mapping_type: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.SQLDataDirectoryType
    :ivar source_logical_name: Restore source logical name path.
    :vartype source_logical_name: str
    :ivar source_path: Restore source path.
    :vartype source_path: str
    :ivar target_path: Target path.
    :vartype target_path: str
    """

    _attribute_map = {
        "mapping_type": {"key": "mappingType", "type": "str"},
        "source_logical_name": {"key": "sourceLogicalName", "type": "str"},
        "source_path": {"key": "sourcePath", "type": "str"},
        "target_path": {"key": "targetPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        mapping_type: Optional[Union[str, "_models.SQLDataDirectoryType"]] = None,
        source_logical_name: Optional[str] = None,
        source_path: Optional[str] = None,
        target_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mapping_type: Type of data directory mapping. Known values are: "Invalid", "Data", and
         "Log".
        :paramtype mapping_type: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.SQLDataDirectoryType
        :keyword source_logical_name: Restore source logical name path.
        :paramtype source_logical_name: str
        :keyword source_path: Restore source path.
        :paramtype source_path: str
        :keyword target_path: Target path.
        :paramtype target_path: str
        """
        super().__init__(**kwargs)
        self.mapping_type = mapping_type
        self.source_logical_name = source_logical_name
        self.source_path = source_path
        self.target_path = target_path


class TargetAFSRestoreInfo(_serialization.Model):
    """Target Azure File Share Info.

    :ivar name: File share name.
    :vartype name: str
    :ivar target_resource_id: Target file share resource ARM ID.
    :vartype target_resource_id: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, target_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: File share name.
        :paramtype name: str
        :keyword target_resource_id: Target file share resource ARM ID.
        :paramtype target_resource_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.target_resource_id = target_resource_id


class TargetRestoreInfo(_serialization.Model):
    """Details about target workload during restore operation.

    :ivar overwrite_option: Can Overwrite if Target DataBase already exists. Known values are:
     "Invalid", "FailOnConflict", and "Overwrite".
    :vartype overwrite_option: str or
     ~azure.mgmt.recoveryservicesbackup.passivestamp.models.OverwriteOptions
    :ivar container_id: Resource Id name of the container in which Target DataBase resides.
    :vartype container_id: str
    :ivar database_name: Database name InstanceName/DataBaseName for SQL or System/DbName for SAP
     Hana.
    :vartype database_name: str
    :ivar target_directory_for_file_restore: Target directory location for restore as files.
    :vartype target_directory_for_file_restore: str
    """

    _attribute_map = {
        "overwrite_option": {"key": "overwriteOption", "type": "str"},
        "container_id": {"key": "containerId", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "target_directory_for_file_restore": {"key": "targetDirectoryForFileRestore", "type": "str"},
    }

    def __init__(
        self,
        *,
        overwrite_option: Optional[Union[str, "_models.OverwriteOptions"]] = None,
        container_id: Optional[str] = None,
        database_name: Optional[str] = None,
        target_directory_for_file_restore: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword overwrite_option: Can Overwrite if Target DataBase already exists. Known values are:
         "Invalid", "FailOnConflict", and "Overwrite".
        :paramtype overwrite_option: str or
         ~azure.mgmt.recoveryservicesbackup.passivestamp.models.OverwriteOptions
        :keyword container_id: Resource Id name of the container in which Target DataBase resides.
        :paramtype container_id: str
        :keyword database_name: Database name InstanceName/DataBaseName for SQL or System/DbName for
         SAP Hana.
        :paramtype database_name: str
        :keyword target_directory_for_file_restore: Target directory location for restore as files.
        :paramtype target_directory_for_file_restore: str
        """
        super().__init__(**kwargs)
        self.overwrite_option = overwrite_option
        self.container_id = container_id
        self.database_name = database_name
        self.target_directory_for_file_restore = target_directory_for_file_restore


class WorkloadCrrAccessToken(CrrAccessToken):  # pylint: disable=too-many-instance-attributes
    """WorkloadCrrAccessToken.

    All required parameters must be populated in order to send to server.

    :ivar object_type: Type of the specific object - used for deserializing. Required.
    :vartype object_type: str
    :ivar access_token_string: Access token used for authentication.
    :vartype access_token_string: str
    :ivar subscription_id: Subscription Id of the source vault.
    :vartype subscription_id: str
    :ivar resource_group_name: Resource Group name of the source vault.
    :vartype resource_group_name: str
    :ivar resource_name: Resource Name of the source vault.
    :vartype resource_name: str
    :ivar resource_id: Resource Id of the source vault.
    :vartype resource_id: str
    :ivar protection_container_id: Protected item container id.
    :vartype protection_container_id: int
    :ivar recovery_point_id: Recovery Point Id.
    :vartype recovery_point_id: str
    :ivar recovery_point_time: Recovery Point Time.
    :vartype recovery_point_time: str
    :ivar container_name: Container Unique name.
    :vartype container_name: str
    :ivar container_type: Container Type.
    :vartype container_type: str
    :ivar backup_management_type: Backup Management Type.
    :vartype backup_management_type: str
    :ivar datasource_type: Datasource Type.
    :vartype datasource_type: str
    :ivar datasource_name: Datasource Friendly Name.
    :vartype datasource_name: str
    :ivar datasource_id: Datasource Id.
    :vartype datasource_id: str
    :ivar datasource_container_name: Datasource Container Unique Name.
    :vartype datasource_container_name: str
    :ivar coordinator_service_stamp_id: CoordinatorServiceStampId to be used by BCM in restore
     call.
    :vartype coordinator_service_stamp_id: str
    :ivar coordinator_service_stamp_uri: CoordinatorServiceStampUri to be used by BCM in restore
     call.
    :vartype coordinator_service_stamp_uri: str
    :ivar protection_service_stamp_id: ProtectionServiceStampId to be used by BCM in restore call.
    :vartype protection_service_stamp_id: str
    :ivar protection_service_stamp_uri: ProtectionServiceStampUri to be used by BCM in restore
     call.
    :vartype protection_service_stamp_uri: str
    :ivar token_extended_information: Extended Information about the token like FileSpec etc.
    :vartype token_extended_information: str
    :ivar rp_tier_information: Recovery point Tier Information.
    :vartype rp_tier_information: dict[str, str]
    :ivar rp_original_sa_option: Recovery point information: Original SA option.
    :vartype rp_original_sa_option: bool
    :ivar rp_is_managed_virtual_machine: Recovery point information: Managed virtual machine.
    :vartype rp_is_managed_virtual_machine: bool
    :ivar rp_vm_size_description: Recovery point information: VM size description.
    :vartype rp_vm_size_description: str
    :ivar b_ms_active_region: Active region name of BMS Stamp.
    :vartype b_ms_active_region: str
    :ivar protectable_object_unique_name:
    :vartype protectable_object_unique_name: str
    :ivar protectable_object_friendly_name:
    :vartype protectable_object_friendly_name: str
    :ivar protectable_object_workload_type:
    :vartype protectable_object_workload_type: str
    :ivar protectable_object_protection_state:
    :vartype protectable_object_protection_state: str
    :ivar protectable_object_container_host_os_name:
    :vartype protectable_object_container_host_os_name: str
    :ivar protectable_object_parent_logical_container_name:
    :vartype protectable_object_parent_logical_container_name: str
    :ivar container_id: Container Id.
    :vartype container_id: str
    :ivar policy_name: Policy Name.
    :vartype policy_name: str
    :ivar policy_id: Policy Id.
    :vartype policy_id: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "access_token_string": {"key": "accessTokenString", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "protection_container_id": {"key": "protectionContainerId", "type": "int"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
        "recovery_point_time": {"key": "recoveryPointTime", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "datasource_type": {"key": "datasourceType", "type": "str"},
        "datasource_name": {"key": "datasourceName", "type": "str"},
        "datasource_id": {"key": "datasourceId", "type": "str"},
        "datasource_container_name": {"key": "datasourceContainerName", "type": "str"},
        "coordinator_service_stamp_id": {"key": "coordinatorServiceStampId", "type": "str"},
        "coordinator_service_stamp_uri": {"key": "coordinatorServiceStampUri", "type": "str"},
        "protection_service_stamp_id": {"key": "protectionServiceStampId", "type": "str"},
        "protection_service_stamp_uri": {"key": "protectionServiceStampUri", "type": "str"},
        "token_extended_information": {"key": "tokenExtendedInformation", "type": "str"},
        "rp_tier_information": {"key": "rpTierInformation", "type": "{str}"},
        "rp_original_sa_option": {"key": "rpOriginalSAOption", "type": "bool"},
        "rp_is_managed_virtual_machine": {"key": "rpIsManagedVirtualMachine", "type": "bool"},
        "rp_vm_size_description": {"key": "rpVMSizeDescription", "type": "str"},
        "b_ms_active_region": {"key": "bMSActiveRegion", "type": "str"},
        "protectable_object_unique_name": {"key": "protectableObjectUniqueName", "type": "str"},
        "protectable_object_friendly_name": {"key": "protectableObjectFriendlyName", "type": "str"},
        "protectable_object_workload_type": {"key": "protectableObjectWorkloadType", "type": "str"},
        "protectable_object_protection_state": {"key": "protectableObjectProtectionState", "type": "str"},
        "protectable_object_container_host_os_name": {"key": "protectableObjectContainerHostOsName", "type": "str"},
        "protectable_object_parent_logical_container_name": {
            "key": "protectableObjectParentLogicalContainerName",
            "type": "str",
        },
        "container_id": {"key": "containerId", "type": "str"},
        "policy_name": {"key": "policyName", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        access_token_string: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group_name: Optional[str] = None,
        resource_name: Optional[str] = None,
        resource_id: Optional[str] = None,
        protection_container_id: Optional[int] = None,
        recovery_point_id: Optional[str] = None,
        recovery_point_time: Optional[str] = None,
        container_name: Optional[str] = None,
        container_type: Optional[str] = None,
        backup_management_type: Optional[str] = None,
        datasource_type: Optional[str] = None,
        datasource_name: Optional[str] = None,
        datasource_id: Optional[str] = None,
        datasource_container_name: Optional[str] = None,
        coordinator_service_stamp_id: Optional[str] = None,
        coordinator_service_stamp_uri: Optional[str] = None,
        protection_service_stamp_id: Optional[str] = None,
        protection_service_stamp_uri: Optional[str] = None,
        token_extended_information: Optional[str] = None,
        rp_tier_information: Optional[Dict[str, str]] = None,
        rp_original_sa_option: Optional[bool] = None,
        rp_is_managed_virtual_machine: Optional[bool] = None,
        rp_vm_size_description: Optional[str] = None,
        b_ms_active_region: Optional[str] = None,
        protectable_object_unique_name: Optional[str] = None,
        protectable_object_friendly_name: Optional[str] = None,
        protectable_object_workload_type: Optional[str] = None,
        protectable_object_protection_state: Optional[str] = None,
        protectable_object_container_host_os_name: Optional[str] = None,
        protectable_object_parent_logical_container_name: Optional[str] = None,
        container_id: Optional[str] = None,
        policy_name: Optional[str] = None,
        policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword access_token_string: Access token used for authentication.
        :paramtype access_token_string: str
        :keyword subscription_id: Subscription Id of the source vault.
        :paramtype subscription_id: str
        :keyword resource_group_name: Resource Group name of the source vault.
        :paramtype resource_group_name: str
        :keyword resource_name: Resource Name of the source vault.
        :paramtype resource_name: str
        :keyword resource_id: Resource Id of the source vault.
        :paramtype resource_id: str
        :keyword protection_container_id: Protected item container id.
        :paramtype protection_container_id: int
        :keyword recovery_point_id: Recovery Point Id.
        :paramtype recovery_point_id: str
        :keyword recovery_point_time: Recovery Point Time.
        :paramtype recovery_point_time: str
        :keyword container_name: Container Unique name.
        :paramtype container_name: str
        :keyword container_type: Container Type.
        :paramtype container_type: str
        :keyword backup_management_type: Backup Management Type.
        :paramtype backup_management_type: str
        :keyword datasource_type: Datasource Type.
        :paramtype datasource_type: str
        :keyword datasource_name: Datasource Friendly Name.
        :paramtype datasource_name: str
        :keyword datasource_id: Datasource Id.
        :paramtype datasource_id: str
        :keyword datasource_container_name: Datasource Container Unique Name.
        :paramtype datasource_container_name: str
        :keyword coordinator_service_stamp_id: CoordinatorServiceStampId to be used by BCM in restore
         call.
        :paramtype coordinator_service_stamp_id: str
        :keyword coordinator_service_stamp_uri: CoordinatorServiceStampUri to be used by BCM in restore
         call.
        :paramtype coordinator_service_stamp_uri: str
        :keyword protection_service_stamp_id: ProtectionServiceStampId to be used by BCM in restore
         call.
        :paramtype protection_service_stamp_id: str
        :keyword protection_service_stamp_uri: ProtectionServiceStampUri to be used by BCM in restore
         call.
        :paramtype protection_service_stamp_uri: str
        :keyword token_extended_information: Extended Information about the token like FileSpec etc.
        :paramtype token_extended_information: str
        :keyword rp_tier_information: Recovery point Tier Information.
        :paramtype rp_tier_information: dict[str, str]
        :keyword rp_original_sa_option: Recovery point information: Original SA option.
        :paramtype rp_original_sa_option: bool
        :keyword rp_is_managed_virtual_machine: Recovery point information: Managed virtual machine.
        :paramtype rp_is_managed_virtual_machine: bool
        :keyword rp_vm_size_description: Recovery point information: VM size description.
        :paramtype rp_vm_size_description: str
        :keyword b_ms_active_region: Active region name of BMS Stamp.
        :paramtype b_ms_active_region: str
        :keyword protectable_object_unique_name:
        :paramtype protectable_object_unique_name: str
        :keyword protectable_object_friendly_name:
        :paramtype protectable_object_friendly_name: str
        :keyword protectable_object_workload_type:
        :paramtype protectable_object_workload_type: str
        :keyword protectable_object_protection_state:
        :paramtype protectable_object_protection_state: str
        :keyword protectable_object_container_host_os_name:
        :paramtype protectable_object_container_host_os_name: str
        :keyword protectable_object_parent_logical_container_name:
        :paramtype protectable_object_parent_logical_container_name: str
        :keyword container_id: Container Id.
        :paramtype container_id: str
        :keyword policy_name: Policy Name.
        :paramtype policy_name: str
        :keyword policy_id: Policy Id.
        :paramtype policy_id: str
        """
        super().__init__(
            access_token_string=access_token_string,
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            resource_id=resource_id,
            protection_container_id=protection_container_id,
            recovery_point_id=recovery_point_id,
            recovery_point_time=recovery_point_time,
            container_name=container_name,
            container_type=container_type,
            backup_management_type=backup_management_type,
            datasource_type=datasource_type,
            datasource_name=datasource_name,
            datasource_id=datasource_id,
            datasource_container_name=datasource_container_name,
            coordinator_service_stamp_id=coordinator_service_stamp_id,
            coordinator_service_stamp_uri=coordinator_service_stamp_uri,
            protection_service_stamp_id=protection_service_stamp_id,
            protection_service_stamp_uri=protection_service_stamp_uri,
            token_extended_information=token_extended_information,
            rp_tier_information=rp_tier_information,
            rp_original_sa_option=rp_original_sa_option,
            rp_is_managed_virtual_machine=rp_is_managed_virtual_machine,
            rp_vm_size_description=rp_vm_size_description,
            b_ms_active_region=b_ms_active_region,
            **kwargs
        )
        self.object_type: str = "WorkloadCrrAccessToken"
        self.protectable_object_unique_name = protectable_object_unique_name
        self.protectable_object_friendly_name = protectable_object_friendly_name
        self.protectable_object_workload_type = protectable_object_workload_type
        self.protectable_object_protection_state = protectable_object_protection_state
        self.protectable_object_container_host_os_name = protectable_object_container_host_os_name
        self.protectable_object_parent_logical_container_name = protectable_object_parent_logical_container_name
        self.container_id = container_id
        self.policy_name = policy_name
        self.policy_id = policy_id
